/**
 * @brief           VIA Primitive Header
 * @author          AXELL CORPORATION
 * @description     VIA Primitive Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef VIAPRM_H
#define VIAPRM_H
/* DOM-IGNORE-END */

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/** AiOrfI̓|[g */
#define AG903_VIA_PRM_MAX_PORTS         (4)

/** VIA.SRC_SELECTWX^p[^ */
typedef struct _VIAPrmParamVIASRCSELECT {
	uint16_t gcat;                      /** GCATtB[hl */
	uint16_t nsck;                      /** NSCKtB[hl */
	uint16_t nsns;                      /** NSNStB[hl */
	uint16_t nons;                      /** NONStB[hl */
}VIAPrmParamVIASRCSELECT;

/** VIA.CHD_SETUP3WX^p[^ */
typedef struct _VIAPrmParamVIACHDSETUP3 {
	uint16_t agcen;                     /** AGCENtB[hl   */
	uint16_t accov;                     /** ACCOVtB[hl   */
	uint16_t acctc;                     /** ACCTCtB[hl   */
	uint16_t accmark;                   /** ACCMARKtB[hl */
}VIAPrmParamVIACHDSETUP3;

/** VIA.CHD_SETUP5WX^p[^ */
typedef struct _VIAPrmParamVIACHDSETUP5 {
	uint16_t cbpllulth;                 /** CBPLLULTHtB[hl  */
	uint16_t cbpllulsv;                 /** CBPLLULSVtB[hl  */
	uint16_t agcgainspd;                /** AGCGAINSPDtB[hl */
	uint16_t agcofstspd;                /** AGCOFSTSPDtB[hl */
	uint16_t agcpos;                    /** AGCPOStB[hl     */
	uint16_t agcpal;                    /** AGCPALtB[hl     */
	uint16_t agcgainen;                 /** AGCGAINENtB[hl  */
	uint16_t agcofsten;                 /** AGCOFSTENtB[hl  */
}VIAPrmParamVIACHDSETUP5;

/** VIA.DET_STATUSWX^p[^ */
typedef struct _VIAPrmParamVIADETSTATUS {
	uint16_t fmt;                       /** FMTtB[hl    */
	uint16_t tbcno;                     /** TBCNOtB[hl  */
	uint16_t std;                       /** STDtB[hl    */
	uint16_t ckill;                     /** CKILLtB[hl  */
	uint16_t trick;                     /** TRICKtB[hl  */
	uint16_t normal;                    /** NORMALtB[hl */
	uint16_t vtr;                       /** VTRtB[hl    */
	uint16_t prog;                      /** PROGtB[hl   */
	uint16_t nosync;                    /** NOSYNCtB[hl */
}VIAPrmParamVIADETSTATUS;

void AG903_ViaPrmSetVIASRCSELECT(uint32_t id, VIAPrmParamVIASRCSELECT *select);
void AG903_ViaPrmGetVIASRCSELECT(uint32_t id, VIAPrmParamVIASRCSELECT *select);
void AG903_ViaPrmSetVIASRCFORMAT(uint32_t id, uint16_t fmt);
void AG903_ViaPrmGetVIASRCFORMAT(uint32_t id, uint16_t *fmt);
void AG903_ViaPrmSetVIASRCHCYCLE(uint32_t id, uint16_t hcycle);
void AG903_ViaPrmGetVIASRCHCYCLE(uint32_t id, uint16_t *hcycle);
void AG903_ViaPrmSetVIASRCHVALID(uint32_t id, uint16_t hvalid);
void AG903_ViaPrmGetVIASRCHVALID(uint32_t id, uint16_t *hvalid);
void AG903_ViaPrmSetVIASRCHDELAY(uint32_t id, uint16_t hdelay);
void AG903_ViaPrmGetVIASRCHDELAY(uint32_t id, uint16_t *hdelay);
void AG903_ViaPrmSetVIASRCVCYCLE(uint32_t id, uint16_t vcycle);
void AG903_ViaPrmGetVIASRCVCYCLE(uint32_t id, uint16_t *vcycle);
void AG903_ViaPrmSetVIASRCVVALID(uint32_t id, uint16_t vvalid);
void AG903_ViaPrmGetVIASRCVVALID(uint32_t id, uint16_t *vvalid);
void AG903_ViaPrmSetVIASRCVDELAY(uint32_t id, uint16_t vdelay);
void AG903_ViaPrmGetVIASRCVDELAY(uint32_t id, uint16_t *vdelay);
void AG903_ViaPrmSetVIASRCFRMFREQ(uint32_t id, uint16_t frm);
void AG903_ViaPrmGetVIASRCFRMFREQ(uint32_t id, uint16_t *frm);
void AG903_ViaPrmSetVIASIGYCS(uint32_t id, uint16_t trap, uint16_t mono);
void AG903_ViaPrmGetVIASIGYCS(uint32_t id, uint16_t *trap, uint16_t *mono);
void AG903_ViaPrmSetVIACHDSETUP2(uint32_t id, uint16_t bpf, uint16_t hue);
void AG903_ViaPrmGetVIACHDSETUP2(uint32_t id, uint16_t *bpf, uint16_t *hue);
void AG903_ViaPrmSetVIACHDSETUP3(uint32_t id, VIAPrmParamVIACHDSETUP3 *setup);
void AG903_ViaPrmGetVIACHDSETUP3(uint32_t id, VIAPrmParamVIACHDSETUP3 *setup);
void AG903_ViaPrmSetVIACHDSETUP5(uint32_t id, VIAPrmParamVIACHDSETUP5 *setup);
void AG903_ViaPrmGetVIACHDSETUP5(uint32_t id, VIAPrmParamVIACHDSETUP5 *setup);
void AG903_ViaPrmSetVIAOUTLEVELY(uint32_t id, uint16_t yofst, uint16_t ygain);
void AG903_ViaPrmGetVIAOUTLEVELY(uint32_t id, uint16_t *yofst, uint16_t *ygain);
void AG903_ViaPrmSetVIAOUTLEVELCB(uint32_t id, uint16_t cbofst, uint16_t cbgain);
void AG903_ViaPrmGetVIAOUTLEVELCB(uint32_t id, uint16_t *cbofst, uint16_t *cbgain);
void AG903_ViaPrmSetVIAOUTLEVELCR(uint32_t id, uint16_t crofst, uint16_t crgain);
void AG903_ViaPrmGetVIAOUTLEVELCR(uint32_t id, uint16_t *crofst, uint16_t *crgain);
void AG903_ViaPrmSetVIACLAMPLEVEL(uint32_t id, uint16_t clampofs);
void AG903_ViaPrmGetVIACLAMPLEVEL(uint32_t id, uint16_t *clampofs);
void AG903_ViaPrmGetVIADETSTATUS(uint32_t id, VIAPrmParamVIADETSTATUS *status);
void AG903_ViaPrmGetVIADETHCYCLE(uint32_t id, uint16_t *hcycle);
void AG903_ViaPrmGetVIADETVCYCLE(uint32_t id, uint16_t *vcycle);

#ifdef __cplusplus
}
#endif

#endif



