/** 
 * @brief           USBC main Header
 * @author          AXELL CORPORATION
 * @description     usbc_main.cpwb_
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */



#ifndef __USBC_MAIN_H__
#define __USBC_MAIN_H__
//#include "hcd_com.h"
//#include "uhs_config.h"
/* DOM-IGNORE-END */


// *************************************************************************************************
//	define
// *************************************************************************************************
//------------------------------------------------------------------------------
// VXe̓EɊւ錾
//------------------------------------------------------------------------------
/** USBfoCXڑ̃R}h̃gC */
#define 	USBD_CONN_RETRY_CNT     (1)
/** {VXeőΉڑfoCX */
#define 	USB_MAX_CHILDREN_LOCAL  (32)
/** ڑfoCXɊ蓖ĂfoCXԍ̍ŏl */
#define 	USB_MIN_CHILDREN_LOCAL  (1)
/** {VXeɓɓo^łNXhCo */
#define 	USB_MAX_DRIVERS         (20)
/** nủʃ|[gɐڑ\ȃfoCX */
#define 	USB_MAX_LOWER_DEV       (7)
/** ^CAEg */
/** ftHg̓]^CAEg */
#define 	USB_HOST_TIMEOUT		(2500)
/** Z}tH҂ */
#define 	USB_HOST_SEMTIMEOUT		(8000)
/** USB]^CAEgԁiControlʐMŁArcv_msg҂鎞ԁj */
#define 	USB_CTRL_GET_TIMEOUT    (USB_HOST_TIMEOUT+500)


//------------------------------------------------------------------------------
// USBgpɊւ錾
//------------------------------------------------------------------------------
/** USBfoCXfBXNv^TCY */
#define 	USB_DEVDESC_SIZE        (0x12)
/** USBfoCXNHt@CAfBXNv^TCY */
#define 	USB_DEVQLFRDESC_SIZE    (0xA)
/** USBRtBO[VfBXNv^TCY */
#define 	USB_CONFIGDESC_SIZE     (0x9)
/** USBC^[tF[XfBXNv^TCY */
#define 	USB_INFTDESC_SIZE       (0x9)
/** USBGh|CgfBXNv^TCY */
#define 	USB_EPDESC_SIZE         (0x7)
/** USBdlŋK肳ĂڑfoCX */
#define 	USB_MAX_CHILDREN        (127)
/** Rg[pCṽ}bNXpPbgTCY */
#define 	USB_MAXPKT_CTRLEP       (64)
/** USB ZbgAbvpPbg̃TCY */
#define 	USB_SETUP_SIZE          (8)
/** Gh|Cg̑(1.1̏ꍇ) */
#define 	USB_MAX_ENDPOINT        (32)


//------------------------------------------------------------------------------
// ]ɊւG[R[h
//------------------------------------------------------------------------------
#define     EUSB_NO_ERROR           (0)											// OHCI Completion Codes
#define     EUSB_CRC                (-100)
#define     EUSB_BIT_STUFF          (-101)
#define     EUSB_DATA_TOGGLE        (-102)
#define     EUSB_HALT               (-103)
#define     EUSB_TIMEOUT            (-104)
#define     EUSB_PID                (-105)
#define     EUSB_DATA_OVERRUN       (-106)
#define     EUSB_DATA_UNDERRUN      (-107)
#define     EUSB_BUF_OVERRUN        (-108)
#define     EUSB_BUF_UNDERRUN       (-109)
#define     EUSB_NOT_ACCESSED       (-110)
/** S/W̗vɂ]~ */
#define     EUSB_STOP_TRANS         (-111)

#define     EUSB_DATABUF_ERROR      (-200)										// EHCI status code in qTD
#define     EUSB_BABBLE_DETECTED    (-201)
#define     EUSB_TX_ERROR           (-202)
#define     EUSB_MISSED_MICROFRAME  (-203)

#define     EUSB_INTXFER_UNKNOWNSIZE  (-204)

//------------------------------------------------------------------------------
// XgO擾}N
//------------------------------------------------------------------------------
#define 	Usb_Core_GetStringManu(ucb, usbdev)     Usb_Core_GetString(ucb, usbdev, usbdev->usbdev_DevDescriptor->iManufacturer, &usbdev->usbdev_StringManu)
#define 	Usb_Core_GetStringProduct(ucb, usbdev)  Usb_Core_GetString(ucb, usbdev, usbdev->usbdev_DevDescriptor->iProduct, &usbdev->usbdev_StringProduct)
#define 	Usb_Core_GetStringSerial(ucb, usbdev)   Usb_Core_GetString(ucb, usbdev, usbdev->usbdev_DevDescriptor->iSerialNumber, &usbdev->usbdev_StringSerial)
#define 	CS_DESC_DATA_OFFSET 0x02		/* bLength +  bDescriptorType = 2Byte */

// *************************************************************************************************
//	structure
// *************************************************************************************************
//------------------------------------------------------------------------------
// USBRAǗ\
//------------------------------------------------------------------------------
typedef struct {                            // __st__
    kernel_context_t    *lock_driver_list;										// hCoo^XgیpZ}tH
//  kernel_context_t    *mbx_osc;
} usb_core_object_t;

/** RtBO[VEfBXNv^Ɋ܂܂WJ\́B<p>
    {\̂AC^tF[XEfBXNv^yсANXSpecificfBXNv^A
    Gh|CgEfBXNv^̏ǂ鎖ł܂B<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct drv_usb_configuration_descriptor {
    struct drv_usb_configuration_descriptor *next;		/** ConfigfBXNv^ */
    struct usb_configuration_descriptor *conf_desc;		/** USBKitH[}bgŊi[ꂽ
    														RtBO[VEfBXNv^ */
    uhs_ubit8_t                         num_intf;		/** SC^[tF[X */
    struct usb_interface                *interfaces;	/** C^tF[XEfBXNv^ւ
    														|C^(擪) */
    uhs_ubit8_t                         config_num;		/** RtBO[Vԍ */
    uhs_ubit8_t                         *extra;			/** gf[^(9byteȏ̏ꍇ) */
    uhs_size_t                          extralen;		/** gf[^OX */
};

/** NXSpecificfBXNv^ێ\<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct usb_cs_descriptor {
    udi_ubit8_t bLength;        		/** Size of this descriptor in bytes */
    udi_ubit8_t bDescriptorType;        /** descriptor type (assigned by USB) */
    udi_ubit8_t* pbData;        		/** Pointer of specific data */
};

/** C^tF[XEfBXNv^Ɋ܂܂WJ\́B<p>
    ̃C^tF[XEfBXNv^݂ꍇ́A*next ɂ̎̂N܂B<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct usb_interface {
    struct usb_interface                *next;			/** ̃C^tF[XEfBXNv^ւ
    														N */
    uhs_ubit8_t                         intf_num;		/** C^[tF[Xԍ */
    uhs_ubit8_t                         num_altif;		/** C^[tF[Xԍɑ
    														C^[tF[X */
    uhs_ubit32_t                        act_alt_num;	/** ANeBuȃI^l[gԍ */
    struct drv_usb_interface_descriptor *alt_intf;		/** 擪̃C^tF[XEfBXNv^
    														|C^ */
    struct drv_usb_interface_descriptor *act_alt;		/** ANeBuȃI^l[gZbeBO
    														Ǘ\ */
    void                                *private_data;	/** gp */
};

/** C^tF[XEfBXNv^̓WJp\<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct drv_usb_interface_descriptor {
    struct drv_usb_interface_descriptor *next;			/** }`C^[tF[XΉׂ̈̃N */
    struct usb_interface_descriptor     *intf_desc;		/** USBKitH[}bg̃C^tF[XE
    														fBXNv^ */
    uhs_ubit8_t                         intf_num;		/**	C^[tF[Xԍ */
    uhs_ubit8_t                         *extra;			/** gf[^(9byteȏ̏ꍇ) */
    uhs_size_t                          extralen;		/** gf[^OX */
    uhs_ubit8_t                         num_ep;			/** ̃C^tF[XEfBXNv^
    														܂܂Ep */
    struct drv_usb_cs_descriptor 		*cs_descriptors;/**	NXŗLDescriptorp̈ */

    struct drv_usb_endpoint_descriptor  *endpoints;		/** ̃C^tF[XEfBXNv^
    														֘AGh|CgEfBXNv^
    														 */
};

/** Gh|CgEfBXNv^̏p\<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct drv_usb_endpoint_descriptor {
    struct drv_usb_endpoint_descriptor *next;		/** Gh|CgΉׂ̈̃N */
    struct usb_endpoint_descriptor      *ep_desc;	/** USBKitH[}bgł̃Gh|CgE
    													fBXNv^ */
    uhs_ubit8_t                         *extra;		/** gf[^(7byteȏ̏ꍇ) */
    uhs_size_t                          extralen;	/** gf[^OX */
    uhs_ubit8_t                         ep_addr;	/** EPAhX */
};

/** NXSpecificfBXNv^Ǘ\<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct drv_usb_cs_descriptor {
	struct drv_usb_cs_descriptor	*next;		/** ̃NXSpecificfBXNv^ւ̃N */
	struct usb_cs_descriptor  		*cs_desc;	/** NXSpecificfBXNv^̎̐ */
};

/**	Split Infomation (for LS/FS device via HS hub)  QHɐݒ肷ׂSplit֘A<p>
    USB2.0HUBoRFS/LSfoCXƒʐMsۂSprit Transaction𗘗p܂B<p>
    Ɋ֘Aێׂ̍\̂łBڑfoCXɖ{\̂𐶐AǗ܂B<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct	split_infomation	{

	uhs_boolean_t	is_split;			/**	0=NotSplit / 1=Split */

		#define		USBH_SPLT_DISABLE				(0)
		#define		USBH_SPLT_ENABLE				(1)

	uhs_boolean_t	is_multi;			/**	0=SingleTT / 1=MultiTT */

		#define		USBH_TT_KIND_SINGLE				(0)
		#define		USBH_TT_KIND_MULTI				(1)

	uhs_ubit8_t		hub_adr;			/**	HUB ADDRESS */
	uhs_ubit16_t	port_no;			/**	PORT Number */
};


/** USBfoCXǗp\		(USBfoCXڑɐ)<p>
    USB HostUSBytFfoCX̏AڑfoCXɖ{\̂𐶐Ǘ܂B<p>
    ܂AfoCXڑEؒfɃNXhCoւ̃R[obN̈ƂĖ{\͎̂g܂B<p>
    NXhCo̓foCXڑ̃R[obNŎ󂯎{\̂NXhCoŕێA
    eAPÏƂĒځA܂USBRg[ubÑoƂĊԐړIɎgp܂B<p>
    NXhCo̓foCXڑ̃R[obNŎ󂯎{\̂鎖֎~܂B
    ܂Aoւ݂̏֎~łB<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct usbd_usb_deviceinfo{

    uhs_ubit8_t     usbdev_DevNum;			/** foCXԍ */
    uhs_sbit32_t    usbdev_DevSpeed;		/** foCX̃Xs[h */
        #define USB_DEVSPEED_HS         0	/** High-Speed */
        #define USB_DEVSPEED_FS         1	/** Full-Speed */
        #define USB_DEVSPEED_LS         2	/** Low-Speed */

    struct usb_device_descriptor *usbdev_DevDescriptor;	/** foCXfBXNv^ */
    uhs_ubit8_t     * raw_config;			/** QbgfBXNv^ERtBO[Vs
												Mf[^obt@|C^ */
    struct drv_usb_configuration_descriptor *Drv_ConfDescriptor;	/** RtBO[VfBXNv^ */
    uhs_ubit32_t    usbdev_EpMaxpktIn[16];	/** eGh|Cg̃}bNXpPbgTCY */
    uhs_ubit32_t    usbdev_EpMaxpktOut[16];	/** eGh|Cg̃}bNXpPbgTCY */
    uhs_ubit16_t    usbdev_EpHalt[2];		/** eGh|CgHALT<p>
											    erbgtOƂĎgp<p>
											    [0]AEgGh|Cg<p>
											    [1]CGh|Cg */
    uhs_ubit16_t    usbdev_EpToggle[2];		/** eGh|CgHALT<p>
											    erbgtOƂĎgp<p>
											    [0]AEgGh|Cg<p>
											    [1]CGh|Cg */
    struct usbd_usb_deviceinfo *usbdev_UpperHub;	/** ʃnũfoCX\̃AhX */
    struct usbd_usb_deviceinfo *usbdev_LowerHub[USB_MAX_LOWER_DEV+1];	/** nủʃfoCX\̃AhX<p>
    																	    [1]-[n]|[gɑΉ */
    uhs_ubit8_t     usbdev_LanguageId[2];	/** IDۑobt@ */
    uhs_sbit8_t     * usbdev_StringManu;	/** x_i[obt@AhX */
    uhs_sbit8_t     * usbdev_StringProduct;	/** ԍi[obt@AhX */
    uhs_sbit8_t     * usbdev_StringSerial;	/** VAԍi[obt@AhX */
    
    uhs_ubit8_t     usbdev_TotalConfig;		/** SRtBO */
    uhs_ubit8_t     usbdev_ActConfig;		/** ݐݒ肳ĂRtBO[Vԍ */
    void            *drv_info;				/** hCoi[obt@|C^  unknown device NULL */

    struct hcd_info * hcd_info;				/** ڑHCD */

    void * hc_context;						/** HCDŗLf[^i[ */

    kernel_context_t    usbdev_sem;			/** USBfoCXیpZ}tH */

    kernel_context_t    usbdev_mbx;			/** Rg[]p[{bNX */

    uhs_boolean_t connect_status;			/** ڑԃXe[^X */
    void * context;							/** ReLXgf[^i[ */

	struct split_infomation	split_info;		/**	split infomation */
};


/**	Sprit TransactioñG[ɃG[]vɊւi[\<p>
    ̏́ACLEAR_TT_BUFFER𔭍sۂɕKvȏłB<p>
    ^C~O F SplitG[o<p>
    폜^C~O F SplitG[CALLBACK */
struct	usbd_usb_spliterrinfo{

    uhs_ubit8_t					usbdev_DevNum;	/** foCXԍ */
    uhs_ubit32_t				pipe;			/**	PIPE */
	struct	split_infomation	split_info;		/**	split infomation */
};


// *************************************************************************************************
//	extern
// *************************************************************************************************
extern uhs_status_t Usb_Core_Constructor(void);
extern void         Usb_Core_Destructor(void);
extern uhs_status_t Usb_Core_DeviceEnumerate(struct usbd_usb_deviceinfo *usbdev);
extern uhs_status_t  Usb_Core_FreeConfDesc(struct drv_usb_configuration_descriptor * conf_ctrl);
extern void         Usb_Core_RelDevNumber(uhs_ubit8_t dev_num);

#endif	// __USBC_MAIN_H__

