/*
 * @history		2019_12_27  [SDK3.0] ^XNTA_FPUtŋNĂȂsC (uC3) (#2698)
 */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/

/*****************************************************************************/
/*     include file                                                          */
/*****************************************************************************/
#include "kernel.h"
#include "sample_common.h"
#include "uhs_configtop.h"
#include "storage/usb_msc_type.h"
#include "storage/usb_msc_api.h"
#include <stdint.h>
#include "vram/vrammgr.h"
#include "usb_sample.h"
#include "sample_util.h"
#include "sample_app_msc.h"


/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/
/* ^XN */
typedef struct MscTaskInfo {
	ID					tskid;								/* ^XNID							*/
	ID					mbxid;								/* [{bNXID					*/
	VB					drive;								/* hCu^[					*/
	char				*pFileName;							/* t@C						*/
	char				*pReadBuff;							/* ǂݏopobt@AhX		*/
	char				*pWriteBuff;						/* ݗpobt@AhX		*/
	void				*pContext;							/* ڑĂȂNULL			*/
} MSC_TASK_INFO;

/* ڑ^ؒfbZ[W */
typedef struct MscConnMsgPkt {
	uhs_ubit32_t		msg;								/* bZ[We					*/
	void				*pContext;							/* ʒmfoCX̃ReLXg		*/
} MSC_CONN_MSG_PKT;

/* AvP[V^XNbZ[W */
typedef struct MscAppMsgPkt {
	uhs_ubit32_t		msg;								/* bZ[We					*/
	void				*pContext;							/* ʒmfoCX̃ReLXg		*/
} MSC_APP_MSG_PKT;

/*****************************************************************************/
/*     define                                                                */
/*****************************************************************************/
/* obt@TCY */
#define BUFF_SIZE					(128)

/* 쐬fBNg */
#define DIR_NAME					"DIR"

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/
/* obt@ */
static char g_ReadBuff[USBH_MAX_CLS_MSC_NUM][BUFF_SIZE];
static char g_WriteBuff[USBH_MAX_CLS_MSC_NUM][BUFF_SIZE];

/* ^XNe[u */
static MSC_TASK_INFO g_MscTaskInfoTbl[USBH_MAX_CLS_MSC_NUM];

/* ڑؒf^XNp[{bNXID */
ER_ID				g_mbxid_msc_conn;

/* ڑؒf^XNp^XNID */
ER_ID				g_tskid_msc_conn;

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern	int32_t AG903_VRAMMgrCreateMpl(AG903_VRAMMgrMplPrm* mplprm);
extern	int32_t AG903_VRAMMgrDeleteMpl(int32_t mplid);
extern	void* AG903_VRAMMgrMalloc(int32_t mplid, uint32_t blksz);
extern	int32_t AG903_VRAMMgrFree(int32_t mplid, void* blk);

/*****************************************************************************/
/*     function prototype                                                    */
/*****************************************************************************/
static int msc_registTaskInfo(void* pContext);
static int msc_unregistTaskInfo(void* pContext);
static void msc_conn_task(void* context);

/******************************************************************************
   FunctionF  msc_appinit
   ArgumentF  Ȃ
   Return  F  Ȃ
   Summary F  MSCs܂
   Caution F  Ȃ
******************************************************************************/
void msc_appinit(void)
{
	T_CMBX					cmbx;							/* [{bNXp[^		*/
	T_CTSK					ctsk;							/* ^XNp[^				*/
	uhs_ubit8_t				majorVersion, minorVersion;		/* o[W						*/
	char fileName[]			= "FILE_01.txt";				/* t@C						*/
	char writeBuff[] =
		{ "FILE_01.txt 0001\r\nThe quick brown fox jumps over the lazy dog. 1234567890" };
	uhs_status_t			retval;
//	ER						ercd;
	int						i;


	/*----------------*/
	/* o[W擾 */
	/*----------------*/
	retval = Usbh_Stor_GetVersion(&majorVersion, &minorVersion);
	if(retval == USBSTOR_SUCCESS) {
		SAMPLE_PRINT("MSC Driver version : ");
		SAMPLE_PRINT_BYTE_HEX(majorVersion);
		SAMPLE_PRINT(".");
		SAMPLE_PRINT_BYTE_HEX(minorVersion);
		SAMPLE_PRINT("\r\n");
	}

	/*--------------------------*/
	/* ^XNe[u */
	/*--------------------------*/
	for(i = 0; i < USBH_MAX_CLS_MSC_NUM; i++) {
		g_MscTaskInfoTbl[i].tskid		= 0;
		g_MscTaskInfoTbl[i].mbxid		= 0;
		g_MscTaskInfoTbl[i].drive		= ('C' + i);
		fileName[6] = ('1' + i);
		g_MscTaskInfoTbl[i].pFileName	= AG903_VRAMMgrMalloc(g_mplid_app, sizeof(fileName));
		sample_memcpy(g_MscTaskInfoTbl[i].pFileName, fileName, sizeof(fileName));
		g_MscTaskInfoTbl[i].pReadBuff	= g_ReadBuff[i];
		g_MscTaskInfoTbl[i].pWriteBuff	= g_WriteBuff[i];
		g_MscTaskInfoTbl[i].pContext	= NULL;
	}
	
	/*--------------*/
	/* obt@ݒ */
	/*--------------*/
	/* ݃f[^ݒ */
	for(i = 0; i < USBH_MAX_CLS_MSC_NUM; i++) {
		sample_memset(g_MscTaskInfoTbl[i].pWriteBuff, 0, BUFF_SIZE);
		writeBuff[6]= ('1' + i);
		sample_memcpy(g_MscTaskInfoTbl[i].pWriteBuff, writeBuff, sizeof(writeBuff));
	}
	
	/*--------------------*/
	/* [{bNX */
	/*--------------------*/
	/* p[^ݒ */
    cmbx.mbxatr		= TA_TFIFO | TA_MFIFO;
    cmbx.maxmpri	= 1;
    cmbx.mprihd		= NULL;

	/* ڑؒf^XNp[{bNX */
	g_mbxid_msc_conn = acre_mbx(&cmbx);
	if(g_mbxid_msc_conn < 0) {
		/* G[ */
		return;
	}

	/*----------------------*/
	/* ڑ^ؒf^XN */
	/*----------------------*/
	/* p[^ݒ */
	ctsk.tskatr		= TA_HLNG | TA_ACT | TA_FPU;
	ctsk.exinf		= (void *)NULL;							/* TASKÑp[^()			*/
	ctsk.task		= (FP)msc_conn_task;					/* TASK̋NAhX					*/
	ctsk.itskpri	= (PRI)TSK_PRI_SAMPLE;					/* TASK̗Dx							*/
	ctsk.stksz		= (INT)TSK_STACK_SIZE_SAMPLE;			/* TASK̃X^bNSIZE					*/
	ctsk.stk		= NULL;									/* TASK̃X^bNAhX=NULL()	*/
	
	/* ^XN */
	g_tskid_msc_conn = acre_tsk(&ctsk);
	if(g_tskid_msc_conn < 0) {
		/* G[ */
		return;
	}
}

/******************************************************************************
   FunctionF  msc_append
   ArgumentF  Ȃ
   Return  F  Ȃ
   Summary F  MSCIs܂
   Caution F  Ȃ
******************************************************************************/
void msc_append(void)
{
	int						i;

	del_mbx(g_mbxid_msc_conn);
	
	for(i = 0; i < USBH_MAX_CLS_MSC_NUM; i++) {
		del_mbx(g_MscTaskInfoTbl[i].mbxid);
	}

	ter_tsk(g_tskid_msc_conn);
	del_tsk(g_tskid_msc_conn);
	
	for(i = 0; i < USBH_MAX_CLS_MSC_NUM; i++) {
		ter_tsk(g_MscTaskInfoTbl[i].tskid);
		del_tsk(g_MscTaskInfoTbl[i].tskid);
	}

	return;
}

/******************************************************************************
   FunctionF  msc_getContext
   ArgumentF  devnum   F foCXԍ [0`USBH_MAX_CLS_MSC_NUM]
               pContext	F 擾context
   Return  F  Ȃ
   Summary F  context擾܂
   Caution F  Ȃ
******************************************************************************/
void msc_getContext(uint8_t devnum, int32_t* pContext)
{

	if( (USBH_MAX_CLS_MSC_NUM <= devnum) ||
		(NULL == g_MscTaskInfoTbl[devnum].pContext) ) {
		(*pContext) = -1;
		return;
	}

	(*pContext) = (int32_t)g_MscTaskInfoTbl[devnum].pContext;

	return;
}

/******************************************************************************
   FunctionF  msc_callback
   ArgumentF  callback_id : R[obN
               pContext    : R[obNcontext
   Return  F  Ȃ
   Summary F  MSCNXhCo̐ڑ^ؒfR[obN
   Caution F  Ȃ
******************************************************************************/
void msc_callback(int callback_id, void* pContext)
{
	MSC_CONN_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/
	ER						ercd;
	
	
	/* bZ[Wobt@擾 */
	pk_msg = AG903_VRAMMgrMalloc(g_mplid_app, sizeof(MSC_CONN_MSG_PKT));
	/* bZ[We */
	pk_msg->msg = (uhs_ubit32_t)callback_id;
	/* ReLXg */
	pk_msg->pContext = pContext;
	
	switch(callback_id){
		/*--------*/
		/* ڑ   */
		/*--------*/
		case CBID_STOR_DEVATTACH:

//			SAMPLE_PRINT("MSC device attached\r\n");

			/* ReLXgo^ */
			msc_registTaskInfo(pContext);
			
			/* bZ[WM */
			ercd = snd_mbx(g_mbxid_msc_conn, (T_MSG *)pk_msg);
			if(ercd != E_OK) {
				/* obt@ */
				AG903_VRAMMgrFree(g_mplid_app, pk_msg);
				return;
			}
			break;
		
		/*--------*/
		/* ؒf   */
		/*--------*/
		case CBID_STOR_DEVDETACH:

//			SAMPLE_PRINT("MSC device detached\r\n");

			/* ReLXg폜 */
			msc_unregistTaskInfo(pContext);

			/* bZ[WM */
			ercd = snd_mbx(g_mbxid_msc_conn, (T_MSG *)pk_msg);
			if(ercd != E_OK) {
				/* obt@ */
				AG903_VRAMMgrFree(g_mplid_app, pk_msg);
				return;
			}
			break;
		
		/*----------------------------------*/
		/* ꎞIɎgpoȂfoCXڑ */
		/*----------------------------------*/
		case CBID_STOR_DEVATTACH_NOT_READY:
		
//			SAMPLE_PRINT("MSC device attached not ready\r\n");
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			break;
			
		/*--------------------------*/
		/* gpoȂfoCXڑ */
		/*--------------------------*/
		case CBID_STOR_DEVATTACH_NOT_USE:
		
//			SAMPLE_PRINT("MSC device attached not use\r\n");
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			break;

		/*--------*/
		/* ̑ */
		/*--------*/
		default:

//			SAMPLE_PRINT("MSC callback other\r\n");
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			break;
	}
}

/******************************************************************************
   FunctionF  msc_registTaskInfo
   ArgumentF  pContext     : R[obNcontext
   Return  F  SAMPLE_TRUE  : 
               SAMPLE_FALSE : s
   Summary F  ^XNɃReLXgo^܂
   Caution F  Ȃ
******************************************************************************/
static int msc_registTaskInfo(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_MSC_NUM; i++) {
		/* o^ */
		if(g_MscTaskInfoTbl[i].pContext == NULL) {
			/* ReLXgo^ */
			g_MscTaskInfoTbl[i].pContext = pContext;
			return SAMPLE_TRUE;
		}
	}
	/* 󂫂Ȃ */
	return SAMPLE_FALSE;
}

/******************************************************************************
   FunctionF  msc_unregistTaskInfo
   ArgumentF  pContext     : R[obNcontext
   Return  F  SAMPLE_TRUE  : 
               SAMPLE_FALSE : s
   Summary F  ^XN񂩂ReLXg폜܂
   Caution F  Ȃ
******************************************************************************/
static int msc_unregistTaskInfo(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_MSC_NUM; i++) {
		/* ReLXgv */
		if(g_MscTaskInfoTbl[i].pContext == pContext) {
			/* ReLXg폜 */
			g_MscTaskInfoTbl[i].pContext = NULL;
			return SAMPLE_TRUE;
		}
	}
	/* ReLXgȂ */
	return SAMPLE_FALSE;
}

/******************************************************************************
   FunctionF  msc_conn_task
   ArgumentF  context     : NULL
   Return  F  Ȃ
   Summary F  MSCڑ^ؒfm^XN
   Caution F  MSCfoCX
******************************************************************************/
static void msc_conn_task(void* context)
{
	MSC_CONN_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/
	uhs_ubit32_t			msg;							/* bZ[We					*/
	void*					pContext;						/* ReLXg						*/

	((void)context);

	while(1) {
		/* ڑ^ؒfbZ[W҂ */
		rcv_mbx(g_mbxid_msc_conn, (T_MSG **)&pk_msg);
			
		/* ڑ^ꂽfoCX̃ReLXg擾 */
		pContext = pk_msg->pContext;
		/* 擾s */
		if(pContext == NULL) {
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			continue;
		}

		SAMPLE_PRINT("  context : 0x");
		SAMPLE_PRINT_LONG_HEX((unsigned long)pContext);
		SAMPLE_PRINT("\r\n");

		/* bZ[Weۑ */
		msg = pk_msg->msg;
		
		/*------*/
		/* ڑ */
		/*------*/
		if(msg == CBID_STOR_DEVATTACH) {
			/* Ȃ */
		}
		
		/*------*/
		/* ؒf */
		/*------*/
		else {
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
		}
	}
}

