/**
 * @brief           SSP Manager Header
 * @author          AXELL CORPORATION
 * @description     SSP Manager񋟃wb_B<p>SSP ManagergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2025_03_06  [SDK3.7] SSPCuSPI[hł̑MANZX@\ǉ (#5662)
 * @history         2025_03_06  [SDK3.7] SSPCuDMAɂ鑗M֐ǉ (#5780)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */

#ifndef _SSPMGR_H_
#define _SSPMGR_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** ML[ */
#define AG903_SSP_TXQUE_NUM			(8)

/** ML[ */
#define AG903_SSP_RXQUE_NUM			(8)

/** MFIFO Treshold */
#define AG903_SSP_TXFIFO_THRESHOLD	(8)

/** MFIFO Treshold */
#define AG903_SSP_RXFIFO_THRESHOLD	(1)

/** ɐ */
enum _AG903_SspPolarityType {
	AG903_SSP_POL_POSITIVE = 0,	/** _ */
	AG903_SSP_POL_NEGATIVE,		/** _ */
	AG903_SSP_POL_TYPENUM,		/** ɐ` */
};

/** MSB/LSB */
enum _AG903_SspFirstbitType {
	AG903_SSP_FIRSTBIT_MSB = 0,	/** MSB */
	AG903_SSP_FIRSTBIT_LSB,		/** LSB */
	AG903_SSP_FIRSTBIT_TYPENUM,	/** FIRSTBIT_TYPE` */
};

/** SPINbN[h */
enum _AG903_SspSpiClkMode {
	AG903_SSP_SPICLK_MODE0 = 0,	/** SCLKPO =0, SCLKPH =0 */
	AG903_SSP_SPICLK_MODE1,		/** SCLKPO =0, SCLKPH =1 */
	AG903_SSP_SPICLK_MODE2,		/** SCLKPO =1, SCLKPH =0 */
	AG903_SSP_SPICLK_MODE3,		/** SCLKPO =1, SCLKPH =1 */
	AG903_SSP_SPICLK_MODENUM,	/** SPINbN[h */
};

/** pfBO^Cv */
enum _AG903_SspJustifiedType {
	AG903_SSP_LEFT_JUSTIFIED = 0,	/** ipfBOj*/
	AG903_SSP_RIGHT_JUSTIFIED,		/** EiOpfBOj*/
	AG903_SSP_JUSTIFIED_TYPENUM,	/** pfBO^Cv */
};

/** FSMpXiTDMpj*/
enum _AG903_SspI2sTdmFspw {
	AG903_SSP_I2STDM_FSPW_CYCLE = 0,	/** 1TCNiPʁFSCLKj*/
	AG903_SSP_I2STDM_FSPW_WORD,			/** 1[hi擪1Xbgj*/
	AG903_SSP_I2STDM_FSPW_TYPENUM,		/** FSMpXiTDMpj` */
};

/** Cxgorbg iMj*/
#define AG903_SSP_EVENT_SNDEND		(1<<0)

/** Cxgorbg iMj*/
#define AG903_SSP_EVENT_RCVEND		(1<<1)

/** Cxgorbg iI[o[j*/
#define AG903_SSP_EVENT_OVERRUN		(1<<8)

/** Cxgorbg iA_[j*/
#define AG903_SSP_EVENT_UNDERRUN	(1<<9)

/** SSPnh */
typedef uint32_t	AG903_SSPMgrHandle;

/** R[obN֐̌^B<p>
	handleSSPnhAevent̓Cxgorbg(\Q)B<p>
    <table>
    <tr><th>bit</th><th>e</th></tr>
    <tr><td>31:10</td><td>reserve</td></tr>
    <tr><td>9</td><td>MFIFOA_[</td></tr>
    <tr><td>8</td><td>MFIFOI[o[</td></tr>
    <tr><td>7:2</td><td>reserve</td></tr>
    <tr><td>1</td><td>M</td></tr>
    <tr><td>0</td><td>M</td></tr>
    </table> */
typedef void (*AG903_SSPMgrClbk)(AG903_SSPMgrHandle* handle, uint32_t event);

/** SSPݒp[^<p>
	clkdiv ̍ŏĺu4vŊw͕słB܂Slave쎞͐ݒ薳łB<p>
	wordlen ͓`f[^WordbitPʂŐݒ肵܂B<p>
	slave  true=SlaveAfalse=Master łB */
typedef struct _AG903_SSPMgrSspParam{
	uint16_t  	clkdiv;			/** VANbN */
	uint8_t	  	wordlen;		/** Word Length */
	uint8_t		slave;    		/** Slaveݒ */
} AG903_SSPMgrSspParam;

/** SPIݒp[^<p>
	clkdiv ̍ŏĺu2vŊw͕słB܂Slave쎞͐ݒ薳łB<p>
	wordlen ͓`f[^WordbitPʂŐݒ肵܂B<p>
    polarity ͉Ew肵܂B _AG903_SspPolarityType<p>
	firstbit ͉Ew肵܂B _AG903_SspFirstbitType<p>
	sclktype ͉Ew肵܂B _AG903_SspSpiClkMode<p>
	slave  true=SlaveAfalse=Master łB<p>
	flash  SPItbV[hŃANZXƂ1Ȃ̂Ƃ0łB<p>
 */
typedef struct _AG903_SSPMgrSpiParam{
	uint16_t  	clkdiv;			/** VANbN */
	uint8_t	  	wordlen;		/** Word Length */
	uint8_t	  	polarity;		/** frame/sync ɐ */
	uint8_t	  	firstbit;		/** MSB first or LSB first */
	uint8_t	  	sclktype;		/** 0`3 type */
	uint8_t		slave;			/** Slaveݒ */
	uint8_t		flash;			/** SPItbV[h */
} AG903_SSPMgrSpiParam; 

/** I2Sݒp[^<p>
	clkdiv ̍ŏĺu4vŊw͕słB܂Slave쎞͐ݒ薳łB<p>
	wordlen ͓`f[^WordbitPʂŐݒ肵܂B<p>
	mono  true=monoAfalse=stereo łB<p>
    polarity ͉Ew肵܂B _AG903_SspPolarityType<p>
	firstbit ͉Ew肵܂B _AG903_SspFirstbitType<p>
	padlen 0߂PaddingTCYw肵܂B<p>
	justified ͉Ew肵܂B _AG903_SspJustifiedType<p>
	slave  true=SlaveAfalse=Master łB */
typedef struct _AG903_SSPMgrI2sParam{
	uint16_t  	clkdiv;			/** SCLK = SSPCLK/ clkdiv */
	uint8_t	  	wordlen;		/** Word Length */
	uint8_t	  	mono;			/** stereo or mono */
	uint8_t	  	polarity;		/** LRCLKɐ */
	uint8_t	  	firstbit;		/** MSB first or LSB first */
	uint8_t	  	padlen;			/** Padding Length */
	uint8_t	  	justified;		/**  or E */
    uint8_t	  	slave;			/** Slaveݒ */
	uint8_t	  	reserve[3];		/** \ */
} AG903_SSPMgrI2sParam;

/** S/PDIFݒp[^<p>
	datalen ̓I[fBIf[^ݒ肵܂Bݒ\ȒĺA16,20,24łB<p>
	validity  true=I[fBIf[^LAfalse=I[fBIf[^ łB */
typedef struct _AG903_SSPMgrSpdifParam{
	uint8_t	 	datalen;		/** Audio Data Length */
	uint8_t	 	validity;		/** D/A or NOT */
	uint8_t	 	reserve[2];		/** \ */
} AG903_SSPMgrSpdifParam;

/** S/PDIF Crbg */
typedef struct _AG903_SSPMgrSpdifCbit{
	uint8_t	 status[5];			/** Channel Status Byte 0`4 */
	uint8_t	 reserve[3];		/** \ */
} AG903_SSPMgrSpdifCbit;

/** S/PDIF Urbg */
typedef struct _AG903_SSPMgrSpdifUbit{
	uint32_t  userbit[12];		/** User bit 0`383 */
} AG903_SSPMgrSpdifUbit;

/** L[ */
typedef struct _AG903_SSPMgrQueStatus{
	uint32_t	txremain;		/** sL[McTCY[byte] */
	uint32_t	received;		/** sL[MσTCY[byte] */
	uint32_t	txquecnt;		/** ML[CO */
	uint32_t	rxquecnt;		/** ML[CO */
} AG903_SSPMgrQueStatus;

/** Xe[^X<p>
    SSPnSSPStatus ̓eɂȂ܂Bڍׂ́wAX51903dlxQƂĉB*/
typedef struct _AG903_SSPMgrStatus{
	uint8_t		txfifo_num;		/** MFIFOGg */
	uint8_t		rxfifo_num;		/** MFIFOGg */
	uint8_t		busy;			/** Busy [true=Busy] */
	uint8_t		txfifo_notfull; /** MFIFO Not Full [true=Not Full] */
	uint8_t		rxfifo_full;	/** MFIFO Full [true=Full] */
	uint8_t		reserve[3];		/** \ */
} AG903_SSPMgrStatus;


int32_t	AG903_SSPMgrInit(uint8_t ch);
int32_t	AG903_SSPMgrGetHandle(uint8_t ch, AG903_SSPMgrHandle** handle);
int32_t	AG903_SSPMgrReleaseHandle(AG903_SSPMgrHandle* handle);
int32_t	AG903_SSPMgrSetCallback(AG903_SSPMgrHandle* handle, AG903_SSPMgrClbk clbk);
int32_t	AG903_SSPMgrSetSspMode(AG903_SSPMgrHandle* handle, AG903_SSPMgrSspParam* param);
int32_t	AG903_SSPMgrSetSpiMode(AG903_SSPMgrHandle* handle, AG903_SSPMgrSpiParam* param);
int32_t	AG903_SSPMgrSetI2sMode(AG903_SSPMgrHandle* handle, AG903_SSPMgrI2sParam* param);
int32_t	AG903_SSPMgrSetSpdifMode(AG903_SSPMgrHandle* handle, AG903_SSPMgrSpdifParam* param);
int32_t	AG903_SSPMgrSetSpdifCbit(AG903_SSPMgrHandle* handle, AG903_SSPMgrSpdifCbit* cbit);
int32_t	AG903_SSPMgrSetSpdifUbit(AG903_SSPMgrHandle* handle, uint8_t offset, uint32_t ubit);
int32_t	AG903_SSPMgrSetSpdifUbitALL(AG903_SSPMgrHandle* handle, AG903_SSPMgrSpdifUbit* ubit);
int32_t	AG903_SSPMgrSetSendBuf(AG903_SSPMgrHandle* handle, uint8_t* buf, uint32_t size);
int32_t	AG903_SSPMgrSetReceiveBuf(AG903_SSPMgrHandle* handle, uint8_t* buf, uint32_t size);
int32_t	AG903_SSPMgrEnableDmaMode(AG903_SSPMgrHandle* handle, uint8_t mode);
int32_t	AG903_SSPMgrDisableDmaMode(AG903_SSPMgrHandle* handle);
int32_t	AG903_SSPMgrEnableTransfer(AG903_SSPMgrHandle* handle);
int32_t	AG903_SSPMgrDisableTransfer(AG903_SSPMgrHandle* handle);

int32_t AG903_SSPMgrSpiSend(AG903_SSPMgrHandle* handle, const void* buf, uint32_t num);
int32_t AG903_SSPMgrSpiReceive(AG903_SSPMgrHandle* handle, void* buf, uint32_t num);
int32_t AG903_SSPMgrSpiSendReceive(AG903_SSPMgrHandle* handle, const void* tx_buf, uint32_t tx_num, void *rx_buf, uint32_t rx_num);
int32_t AG903_SSPMgrSpiSendDma(AG903_SSPMgrHandle* handle, const void* buf, uint32_t num);
int32_t AG903_SSPMgrSpiReceiveDma(AG903_SSPMgrHandle* handle, void* buf, uint32_t num);
int32_t AG903_SSPMgrSpiSendReceiveDma(AG903_SSPMgrHandle* handle, const void* tx_buf, uint32_t tx_num, void *rx_buf, uint32_t rx_num);
int32_t AG903_SSPMgrSpiEnableTransfer(AG903_SSPMgrHandle* handle);
int32_t AG903_SSPMgrSpiDisableTransfer(AG903_SSPMgrHandle* handle);

int32_t AG903_SSPMgrAttachTxDma(AG903_SSPMgrHandle* handle, uint8_t dma_ch, uint8_t dma_if);
int32_t AG903_SSPMgrAttachRxDma(AG903_SSPMgrHandle* handle, uint8_t dma_ch, uint8_t dma_if);
int32_t AG903_SSPMgrDetachTxDma(AG903_SSPMgrHandle* handle);
int32_t AG903_SSPMgrDetachRxDma(AG903_SSPMgrHandle* handle);
int32_t AG903_SSPMgrSetTxDmaBeat(AG903_SSPMgrHandle* handle, uint8_t beat);
int32_t AG903_SSPMgrSetRxDmaBeat(AG903_SSPMgrHandle* handle, uint8_t beat);
int32_t AG903_SSPMgrSendDma(AG903_SSPMgrHandle* handle, const uint8_t* buf, uint32_t size);
int32_t AG903_SSPMgrReceiveDma(AG903_SSPMgrHandle* handle, uint8_t* buf, uint32_t size);

int32_t	AG903_SSPMgrGetStatus(AG903_SSPMgrHandle* handle, AG903_SSPMgrStatus* status);
int32_t	AG903_SSPMgrClearTxQue(AG903_SSPMgrHandle* handle);
int32_t	AG903_SSPMgrClearRxQue(AG903_SSPMgrHandle* handle);
int32_t	AG903_SSPMgrGetQueStatus(AG903_SSPMgrHandle* handle, AG903_SSPMgrQueStatus* status);
int32_t	AG903_SSPMgrClearTxFifo(AG903_SSPMgrHandle* handle);
int32_t	AG903_SSPMgrClearRxFifo(AG903_SSPMgrHandle* handle);
int32_t AG903_SSPMgrSetTxFifoThreshold(AG903_SSPMgrHandle* handle, uint8_t threshold);
int32_t AG903_SSPMgrSetRxFifoThreshold(AG903_SSPMgrHandle* handle, uint8_t threshold);	
int32_t	AG903_SSPMgrReset(AG903_SSPMgrHandle* handle);

#ifdef __cplusplus
}
#endif
#endif /* _SSPMGR_H_ */
