/**
 * @brief           SPC Register Definition
 * @author          AXELL CORPORATION
 * @description     SPC Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 * @history         2019_12_27  [SDK3.0] AG903dlAX51903_DS06.pdf̏C𔽉f (#2633)
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_SPC_REGMAP_H_
#define _AG903_SPC_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** SPC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  BOOTUP_STATUS;

        struct {
                 uint32_t                                 :  8;
            __IO uint32_t  HWR                            :  1;
            __IO uint32_t  WDR                            :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  PWR                            :  1;
        } BOOTUP_STATUS_bits;
    };

    __I  uint32_t  RESERVED1[7];

    union {
        __IO uint32_t  FCS_CTRL;

        struct {
                 uint32_t                                 :  6;
            __IO uint32_t  FCS                            :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  SW_RST                         :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  CPU_MASK                       :  1;
            __IO uint32_t  CPU_MASK2                      :  1;
                 uint32_t                                 : 14;
            __IO uint32_t  FCS_PLL0_RSTn                  :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  SELFR_CMD_OFF                  :  1;
        } FCS_CTRL_bits;
    };

    union {
        __IO uint32_t  INT_STATUS;

        struct {
                 uint32_t                                 :  6;
            __IO uint32_t  INT_FCS                        :  1;
        } INT_STATUS_bits;
    };

    union {
        __IO uint32_t  INT_ENABLE;

        struct {
            __IO uint32_t  EINT_R0                        :  1;
            __IO uint32_t  EINT_R1                        :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  EINT_R3                        :  1;
            __IO uint32_t  EINT_R4                        :  1;
            __IO uint32_t  EINT_R5                        :  1;
            __IO uint32_t  EINT_FCS                       :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  EINT_R8                        :  1;
        } INT_ENABLE_bits;
    };

    union {
        __IO uint32_t  SOFTRESET_SETUP;

        struct {
            __IO uint32_t  SWRST_ACTIVE                   :  5;
                 uint32_t                                 : 11;
            __IO uint32_t  SWRST_WAIT                     :  5;
        } SOFTRESET_SETUP_bits;
    };

    union {
        __IO uint32_t  PLL0_CTRL;

        struct {
            __IO uint32_t  EN                             :  1;
            __IO uint32_t  STB                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  MUX                            :  4;
            __IO uint32_t  DIV                            :  3;
                 uint32_t                                 :  5;
            __IO uint32_t  MS                             :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  NS                             :  6;
        } PLL0_CTRL_bits;
    };

    __I  uint32_t  RESERVED2[3];

    union {
        __IO uint32_t  DDRPHY_PLLSETUP;

        struct {
            __IO uint32_t  PLLEN                          :  1;
        } DDRPHY_PLLSETUP_bits;
    };

    union {
        __IO uint32_t  DDRPHY_DLLSETUP;

        struct {
            __IO uint32_t  DLLEN                          :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  FRANGE                         :  3;
        } DDRPHY_DLLSETUP_bits;
    };

    __I  uint32_t  RESERVED3[2];

    union {
        __IO uint32_t  AHB_CLK_CTRL;
    };

    __I  uint32_t  RESERVED4[3];

    union {
        __IO uint32_t  APB_CLK_CTRL;
    };

    __I  uint32_t  RESERVED5[7];

    union {
        __IO uint32_t  AXI_CLK_CTRL1;
    };

    union {
        __IO uint32_t  AXI_CLK_CTRL2;

        struct {
            __IO uint32_t  ACLK_EN2                       : 13;
        } AXI_CLK_CTRL2_bits;
    };

    __I  uint32_t  RESERVED6[162];

    union {
        __IO uint32_t  PLL1_CTRL;

        struct {
            __IO uint32_t  MS                             :  6;
                 uint32_t                                 :  2;
            __IO uint32_t  NS                             :  6;
                 uint32_t                                 :  2;
            __IO uint32_t  FR                             :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  SRC                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  DIV                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  EN                             :  1;
        } PLL1_CTRL_bits;
    };

    union {
        __IO uint32_t  PLL2_CTRL;

        struct {
            __IO uint32_t  MS                             :  6;
                 uint32_t                                 :  2;
            __IO uint32_t  NS                             :  6;
                 uint32_t                                 :  2;
            __IO uint32_t  FR                             :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  SRC                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  DIV                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  EN                             :  1;
        } PLL2_CTRL_bits;
    };

    union {
        __IO uint32_t  PLL3_CTRL;

        struct {
            __IO uint32_t  MS                             :  6;
                 uint32_t                                 :  2;
            __IO uint32_t  NS                             :  6;
                 uint32_t                                 :  2;
            __IO uint32_t  FR                             :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  SRC                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  DIV                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  EN                             :  1;
        } PLL3_CTRL_bits;
    };

    union {
        __IO uint32_t  PLLA_CTRL;

        struct {
            __IO uint32_t  MS                             :  4;
            __IO uint32_t  CC                             :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  NS                             :  8;
            __IO uint32_t  FR                             :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  SRC                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  DIV                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  EN                             :  1;
        } PLLA_CTRL_bits;
    };

    union {
        __IO uint32_t  SOFTRESET_MASK1;
    };

    union {
        __IO uint32_t  SOFTRESET_MASK2;
    };

    union {
        __IO uint32_t  SOFTRESET_MASK3;
    };

    union {
        __IO uint32_t  SOFTRESET_MASK4;
    };

    union {
        __IO uint32_t  SOFTRESET_MASK5;
    };

    __I  uint32_t  RESERVED7[4];

    union {
        __IO uint32_t  APB_SDMC_CLK_CTRL;

        struct {
            __IO uint32_t  PCLK_EN                        : 24;
            __IO uint32_t  SDMCCLK_EN                     :  8;
        } APB_SDMC_CLK_CTRL_bits;
    };

    union {
        __IO uint32_t  MISC_CLK_CTRL;
    };

    union {
        __I  uint32_t  PIN_STATUS;

        struct {
            __I  uint32_t  MODE                           :  4;
            __I  uint32_t  TEST                           :  4;
        } PIN_STATUS_bits;
    };

    __I  uint32_t  RESERVED8[4];

    union {
        __IO uint32_t  SDMC_MISC_CTRL;

        struct {
            __IO uint32_t  CLK_SEL                        :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  SREF_REQ                       :  1;
                 uint32_t                                 :  3;
            __I  uint32_t  SREF_ACK                       :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  WCLK_SEL                       :  4;
            __IO uint32_t  RCLK_SEL                       :  4;
            __IO uint32_t  HCLK_SEL                       :  4;
        } SDMC_MISC_CTRL_bits;
    };

    union {
        __IO uint32_t  DDR_MISC_CTRL;

        struct {
            __IO uint32_t  REFRESH                        :  1;
                 uint32_t                                 :  7;
            __I  uint32_t  INIT_OK                        :  1;
        } DDR_MISC_CTRL_bits;
    };

    union {
        __IO uint32_t  SPIROM_MISC_CTRL;

        struct {
            __IO uint32_t  ADDR_CYC                       :  1;
        } SPIROM_MISC_CTRL_bits;
    };

    union {
        __IO uint32_t  CLK_SEL1;

        struct {
            __IO uint32_t  HDACLK_SEL                     :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  DT0CLK_SEL                     :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  DT1CLK_SEL                     :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  LVDSCLK_SEL                    :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  CP0CLK_SEL                     :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  CP1CLK_SEL                     :  2;
        } CLK_SEL1_bits;
    };

    __I  uint32_t  RESERVED9[1];

    union {
        __IO uint32_t  CLK_SSP_SEL;

        struct {
            __IO uint32_t  SSP0CLK_SEL                    :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  SSP1CLK_SEL                    :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  SSP2CLK_SEL                    :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  SSP3CLK_SEL                    :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  PLL3CLK_SEL                    :  2;
        } CLK_SSP_SEL_bits;
    };

    union {
        __IO uint32_t  CLK_SSP_DIV;

        struct {
            __IO uint32_t  SSP0CLK_DIV                    :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  SSP1CLK_DIV                    :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  SSP2CLK_DIV                    :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  SSP3CLK_DIV                    :  5;
        } CLK_SSP_DIV_bits;
    };

    union {
        __IO uint32_t  ETH_PHY_SEL;

        struct {
            __IO uint32_t  RMII                           :  1;
        } ETH_PHY_SEL_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL1;

        struct {
            __IO uint32_t  dbgen                          :  4;
            __IO uint32_t  dbgrestart                     :  4;
            __IO uint32_t  dbgromaddrv                    :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  dbgselfaddrv                   :  1;
        } CA5_MISC_CTRL1_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL2;

        struct {
                 uint32_t                                 : 12;
            __IO uint32_t  dbgromaddr                     : 20;
        } CA5_MISC_CTRL2_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL3;

        struct {
                 uint32_t                                 : 12;
            __IO uint32_t  dbgselfaddr                    : 20;
        } CA5_MISC_CTRL3_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL4;

        struct {
                 uint32_t                                 : 13;
            __IO uint32_t  periphbase                     : 19;
        } CA5_MISC_CTRL4_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL5;

        struct {
            __IO uint32_t  L2waysize                      :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  L2associativity                :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  L2spniden                      :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  L2filteren                     :  1;
        } CA5_MISC_CTRL5_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL6;

        struct {
                 uint32_t                                 : 12;
            __IO uint32_t  L2periphbase                   : 20;
        } CA5_MISC_CTRL6_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL7;

        struct {
            __IO uint32_t  L2filterstart                  : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  L2filterend                    : 12;
        } CA5_MISC_CTRL7_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL8;

        struct {
            __IO uint32_t  portconnected                  :  8;
            __IO uint32_t  portenabled                    :  8;
            __IO uint32_t  srstconnected                  :  8;
            __IO uint32_t  CP15Sdisable                   :  4;
            __IO uint32_t  L1rstdisable                   :  4;
        } CA5_MISC_CTRL8_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL9;

        struct {
            __IO uint32_t  pwrctli0                       :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  pwrctli1                       :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  pwrctli2                       :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  pwrctli3                       :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  atb_csysreq                    :  4;
            __IO uint32_t  atb_mstclamp                   :  4;
            __IO uint32_t  atb_slvclamp                   :  4;
        } CA5_MISC_CTRL9_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL10;

        struct {
            __IO uint32_t  eventi                         :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  maxextin                       :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  maxextout                      :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  niden                          :  4;
            __IO uint32_t  spiden                         :  4;
            __IO uint32_t  spniden                        :  4;
        } CA5_MISC_CTRL10_bits;
    };

    union {
        __IO uint32_t  CA5_MISC_CTRL11;

        struct {
            __IO uint32_t  ARusers                        :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  AWusers                        :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  ARprots                        :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  AWprots                        :  3;
        } CA5_MISC_CTRL11_bits;
    };

    __I  uint32_t  RESERVED10[1];

    union {
        __IO uint32_t  VIDEOADC_MISC_CTRL1;

        struct {
            __IO uint32_t  ENABLE                         :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  CLAMP_EN0                      :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  CLAMP_EN1                      :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  CLAMP_EN2                      :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  CLAMP_EN3                      :  1;
        } VIDEOADC_MISC_CTRL1_bits;
    };

    union {
        __IO uint32_t  VIDEOADC_MISC_CTRL2;

        struct {
                 uint32_t                                 :  1;
            __IO uint32_t  CH0_ENABLE                     :  1;
            __IO uint32_t  CH1_ENABLE                     :  1;
            __IO uint32_t  CH2_ENABLE                     :  1;
            __IO uint32_t  CH3_ENABLE                     :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  CLAMP_IMP                      :  2;
            __IO uint32_t  CH0_CLAMP                      :  8;
            __IO uint32_t  CH1_CLAMP                      :  8;
            __IO uint32_t  CH2_CLAMP                      :  8;
        } VIDEOADC_MISC_CTRL2_bits;
    };

    union {
        __IO uint32_t  VIDEOADC_MISC_CTRL3;

        struct {
            __IO uint32_t  CH3_CLAMP                      :  8;
            __IO uint32_t  CH0_GAIN                       :  4;
                 uint32_t                                 :  4;
            __IO uint32_t  CH1_GAIN                       :  4;
                 uint32_t                                 :  4;
            __IO uint32_t  CH2_GAIN                       :  4;
        } VIDEOADC_MISC_CTRL3_bits;
    };

    union {
        __IO uint32_t  VIDEOADC_MISC_CTRL4;

        struct {
            __IO uint32_t  CH3_GAIN                       :  4;
                 uint32_t                                 : 14;
            __IO uint32_t  QUAN_BIAS_UP                   :  2;
                 uint32_t                                 :  4;
            __IO uint32_t  AAF_CTRL                       :  6;
        } VIDEOADC_MISC_CTRL4_bits;
    };

    union {
        __IO uint32_t  VIDEOADC_MISC_CTRL5;

        struct {
                 uint32_t                                 :  2;
            __IO uint32_t  REF_BIAS_UP                    :  2;
                 uint32_t                                 : 14;
            __IO uint32_t  INPUT_RANGE                    :  2;
        } VIDEOADC_MISC_CTRL5_bits;
    };

    __I  uint32_t  RESERVED11[1];

    union {
        __IO uint32_t  LVDS_TX_SETUP;

        struct {
            __IO uint32_t  RF_0                           :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  RF_1                           :  1;
        } LVDS_TX_SETUP_bits;
    };

    __I  uint32_t  RESERVED12[1];

    union {
        __IO uint32_t  USB_MISC_CTRL1;

        struct {
            __IO uint32_t  CLK_SEL                        :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  CLK_DIV                        :  1;
                 uint32_t                                 :  3;
            __I  uint32_t  VPRTCT_state                   :  1;
                 uint32_t                                 :  3;
            __I  uint32_t  VBUS_outen                     :  1;
        } USB_MISC_CTRL1_bits;
    };

    union {
        __IO uint32_t  USB_MISC_CTRL2;

        struct {
            __IO uint32_t  OSCOUTEN                       :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  XTLSEL                         :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  PLLALIV                        :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  OUTCLKSEL                      :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  TC_TB_TA                       :  3;
                 uint32_t                                 :  5;
            __IO uint32_t  wakeup                         :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  suspendm                       :  1;
        } USB_MISC_CTRL2_bits;
    };

    union {
        __IO uint32_t  DDR_PHY_SETUP;

        struct {
            __IO uint32_t  AFL_GAIN                       :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  PD_GAIN                        :  3;
        } DDR_PHY_SETUP_bits;
    };

    union {
        __IO uint32_t  BOOT_SWAP_CTRL;

        struct {
            __IO uint32_t  BOOTSWAP                       :  1;
        } BOOT_SWAP_CTRL_bits;
    };

    union {
        __IO uint32_t  IDE_CLK_SEL;

        struct {
            __IO uint32_t  IDECLK_SEL                     :  1;
        } IDE_CLK_SEL_bits;
    };

/* DOM-IGNORE-END */
}AG903_SPC_Type;

#define AG903_SPC                                ((volatile AG903_SPC_Type *) AG903_SPC_BASE)                            /** SPC Base Address */


#define AG903_SPC_BOOTUP_STATUS_HWR_POS                    8                                                             /** SPCBOOTUP_STATUS HWR-bit position */
#define AG903_SPC_BOOTUP_STATUS_HWR_MSK                    (0x1UL << AG903_SPC_BOOTUP_STATUS_HWR_POS)                    /** SPCBOOTUP_STATUS HWR-bit mask */
#define AG903_SPC_BOOTUP_STATUS_WDR_POS                    9                                                             /** SPCBOOTUP_STATUS WDR-bit position */
#define AG903_SPC_BOOTUP_STATUS_WDR_MSK                    (0x1UL << AG903_SPC_BOOTUP_STATUS_WDR_POS)                    /** SPCBOOTUP_STATUS WDR-bit mask */
#define AG903_SPC_BOOTUP_STATUS_PWR_POS                    16                                                            /** SPCBOOTUP_STATUS PWR-bit position */
#define AG903_SPC_BOOTUP_STATUS_PWR_MSK                    (0x1UL << AG903_SPC_BOOTUP_STATUS_PWR_POS)                    /** SPCBOOTUP_STATUS PWR-bit mask */

#define AG903_SPC_FCS_CTRL_FCS_POS                         6                                                             /** SPCFCS_CTRL FCS-bit position */
#define AG903_SPC_FCS_CTRL_FCS_MSK                         (0x1UL << AG903_SPC_FCS_CTRL_FCS_POS)                         /** SPCFCS_CTRL FCS-bit mask */
#define AG903_SPC_FCS_CTRL_SW_RST_POS                      10                                                            /** SPCFCS_CTRL SW_RST-bit position */
#define AG903_SPC_FCS_CTRL_SW_RST_MSK                      (0x1UL << AG903_SPC_FCS_CTRL_SW_RST_POS)                      /** SPCFCS_CTRL SW_RST-bit mask */
#define AG903_SPC_FCS_CTRL_CPU_MASK_POS                    12                                                            /** SPCFCS_CTRL CPU_MASK-bit position */
#define AG903_SPC_FCS_CTRL_CPU_MASK_MSK                    (0x1UL << AG903_SPC_FCS_CTRL_CPU_MASK_POS)                    /** SPCFCS_CTRL CPU_MASK-bit mask */
#define AG903_SPC_FCS_CTRL_CPU_MASK2_POS                   13                                                            /** SPCFCS_CTRL CPU_MASK2-bit position */
#define AG903_SPC_FCS_CTRL_CPU_MASK2_MSK                   (0x1UL << AG903_SPC_FCS_CTRL_CPU_MASK2_POS)                   /** SPCFCS_CTRL CPU_MASK2-bit mask */
#define AG903_SPC_FCS_CTRL_FCS_PLL0_RSTn_POS               28                                                            /** SPCFCS_CTRL FCS_PLL0_RSTn-bit position */
#define AG903_SPC_FCS_CTRL_FCS_PLL0_RSTn_MSK               (0x1UL << AG903_SPC_FCS_CTRL_FCS_PLL0_RSTn_POS)               /** SPCFCS_CTRL FCS_PLL0_RSTn-bit mask */
#define AG903_SPC_FCS_CTRL_SELFR_CMD_OFF_POS               31                                                            /** SPCFCS_CTRL SELFR_CMD_OFF-bit position */
#define AG903_SPC_FCS_CTRL_SELFR_CMD_OFF_MSK               (0x1UL << AG903_SPC_FCS_CTRL_SELFR_CMD_OFF_POS)               /** SPCFCS_CTRL SELFR_CMD_OFF-bit mask */

#define AG903_SPC_INT_STATUS_INT_FCS_POS                   6                                                             /** SPCINT_STATUS INT_FCS-bit position */
#define AG903_SPC_INT_STATUS_INT_FCS_MSK                   (0x1UL << AG903_SPC_INT_STATUS_INT_FCS_POS)                   /** SPCINT_STATUS INT_FCS-bit mask */

#define AG903_SPC_INT_ENABLE_EINT_R0_POS                   0                                                             /** SPCINT_ENABLE EINT_R0-bit position */
#define AG903_SPC_INT_ENABLE_EINT_R0_MSK                   (0x1UL << AG903_SPC_INT_ENABLE_EINT_R0_POS)                   /** SPCINT_ENABLE EINT_R0-bit mask */
#define AG903_SPC_INT_ENABLE_EINT_R1_POS                   1                                                             /** SPCINT_ENABLE EINT_R1-bit position */
#define AG903_SPC_INT_ENABLE_EINT_R1_MSK                   (0x1UL << AG903_SPC_INT_ENABLE_EINT_R1_POS)                   /** SPCINT_ENABLE EINT_R1-bit mask */
#define AG903_SPC_INT_ENABLE_EINT_R3_POS                   3                                                             /** SPCINT_ENABLE EINT_R3-bit position */
#define AG903_SPC_INT_ENABLE_EINT_R3_MSK                   (0x1UL << AG903_SPC_INT_ENABLE_EINT_R3_POS)                   /** SPCINT_ENABLE EINT_R3-bit mask */
#define AG903_SPC_INT_ENABLE_EINT_R4_POS                   4                                                             /** SPCINT_ENABLE EINT_R4-bit position */
#define AG903_SPC_INT_ENABLE_EINT_R4_MSK                   (0x1UL << AG903_SPC_INT_ENABLE_EINT_R4_POS)                   /** SPCINT_ENABLE EINT_R4-bit mask */
#define AG903_SPC_INT_ENABLE_EINT_R5_POS                   5                                                             /** SPCINT_ENABLE EINT_R5-bit position */
#define AG903_SPC_INT_ENABLE_EINT_R5_MSK                   (0x1UL << AG903_SPC_INT_ENABLE_EINT_R5_POS)                   /** SPCINT_ENABLE EINT_R5-bit mask */
#define AG903_SPC_INT_ENABLE_EINT_FCS_POS                  6                                                             /** SPCINT_ENABLE EINT_FCS-bit position */
#define AG903_SPC_INT_ENABLE_EINT_FCS_MSK                  (0x1UL << AG903_SPC_INT_ENABLE_EINT_FCS_POS)                  /** SPCINT_ENABLE EINT_FCS-bit mask */
#define AG903_SPC_INT_ENABLE_EINT_R8_POS                   8                                                             /** SPCINT_ENABLE EINT_R8-bit position */
#define AG903_SPC_INT_ENABLE_EINT_R8_MSK                   (0x1UL << AG903_SPC_INT_ENABLE_EINT_R8_POS)                   /** SPCINT_ENABLE EINT_R8-bit mask */

#define AG903_SPC_SOFTRESET_SETUP_SWRST_ACTIVE_POS         0                                                             /** SPCSOFTRESET_SETUP SWRST_ACTIVE-bit position */
#define AG903_SPC_SOFTRESET_SETUP_SWRST_ACTIVE_MSK         (0x1fUL << AG903_SPC_SOFTRESET_SETUP_SWRST_ACTIVE_POS)        /** SPCSOFTRESET_SETUP SWRST_ACTIVE-bit mask */
#define AG903_SPC_SOFTRESET_SETUP_SWRST_WAIT_POS           16                                                            /** SPCSOFTRESET_SETUP SWRST_WAIT-bit position */
#define AG903_SPC_SOFTRESET_SETUP_SWRST_WAIT_MSK           (0x1fUL << AG903_SPC_SOFTRESET_SETUP_SWRST_WAIT_POS)          /** SPCSOFTRESET_SETUP SWRST_WAIT-bit mask */

#define AG903_SPC_PLL0_CTRL_EN_POS                         0                                                             /** SPCPLL0_CTRL EN-bit position */
#define AG903_SPC_PLL0_CTRL_EN_MSK                         (0x1UL << AG903_SPC_PLL0_CTRL_EN_POS)                         /** SPCPLL0_CTRL EN-bit mask */
#define AG903_SPC_PLL0_CTRL_STB_POS                        1                                                             /** SPCPLL0_CTRL STB-bit position */
#define AG903_SPC_PLL0_CTRL_STB_MSK                        (0x1UL << AG903_SPC_PLL0_CTRL_STB_POS)                        /** SPCPLL0_CTRL STB-bit mask */
#define AG903_SPC_PLL0_CTRL_MUX_POS                        4                                                             /** SPCPLL0_CTRL MUX-bit position */
#define AG903_SPC_PLL0_CTRL_MUX_MSK                        (0xfUL << AG903_SPC_PLL0_CTRL_MUX_POS)                        /** SPCPLL0_CTRL MUX-bit mask */
#define AG903_SPC_PLL0_CTRL_DIV_POS                        8                                                             /** SPCPLL0_CTRL DIV-bit position */
#define AG903_SPC_PLL0_CTRL_DIV_MSK                        (0x7UL << AG903_SPC_PLL0_CTRL_DIV_POS)                        /** SPCPLL0_CTRL DIV-bit mask */
#define AG903_SPC_PLL0_CTRL_MS_POS                         16                                                            /** SPCPLL0_CTRL MS-bit position */
#define AG903_SPC_PLL0_CTRL_MS_MSK                         (0x1fUL << AG903_SPC_PLL0_CTRL_MS_POS)                        /** SPCPLL0_CTRL MS-bit mask */
#define AG903_SPC_PLL0_CTRL_NS_POS                         24                                                            /** SPCPLL0_CTRL NS-bit position */
#define AG903_SPC_PLL0_CTRL_NS_MSK                         (0x3fUL << AG903_SPC_PLL0_CTRL_NS_POS)                        /** SPCPLL0_CTRL NS-bit mask */

#define AG903_SPC_DDRPHY_PLLSETUP_PLLEN_POS                0                                                             /** SPCDDRPHY_PLLSETUP PLLEN-bit position */
#define AG903_SPC_DDRPHY_PLLSETUP_PLLEN_MSK                (0x1UL << AG903_SPC_DDRPHY_PLLSETUP_PLLEN_POS)                /** SPCDDRPHY_PLLSETUP PLLEN-bit mask */

#define AG903_SPC_DDRPHY_DLLSETUP_DLLEN_POS                0                                                             /** SPCDDRPHY_DLLSETUP DLLEN-bit position */
#define AG903_SPC_DDRPHY_DLLSETUP_DLLEN_MSK                (0x1UL << AG903_SPC_DDRPHY_DLLSETUP_DLLEN_POS)                /** SPCDDRPHY_DLLSETUP DLLEN-bit mask */
#define AG903_SPC_DDRPHY_DLLSETUP_FRANGE_POS               8                                                             /** SPCDDRPHY_DLLSETUP FRANGE-bit position */
#define AG903_SPC_DDRPHY_DLLSETUP_FRANGE_MSK               (0x7UL << AG903_SPC_DDRPHY_DLLSETUP_FRANGE_POS)               /** SPCDDRPHY_DLLSETUP FRANGE-bit mask */

#define AG903_SPC_AHB_CLK_CTRL_HCLK_EN_POS                 0                                                             /** SPCAHB_CLK_CTRL HCLK_EN-bit position */
#define AG903_SPC_AHB_CLK_CTRL_HCLK_EN_MSK                 (0xffffffffUL << AG903_SPC_AHB_CLK_CTRL_HCLK_EN_POS)          /** SPCAHB_CLK_CTRL HCLK_EN-bit mask */

#define AG903_SPC_APB_CLK_CTRL_PCLK_EN_POS                 0                                                             /** SPCAPB_CLK_CTRL PCLK_EN-bit position */
#define AG903_SPC_APB_CLK_CTRL_PCLK_EN_MSK                 (0xffffffffUL << AG903_SPC_APB_CLK_CTRL_PCLK_EN_POS)          /** SPCAPB_CLK_CTRL PCLK_EN-bit mask */

#define AG903_SPC_AXI_CLK_CTRL1_ACLK_EN1_POS               0                                                             /** SPCAXI_CLK_CTRL1 ACLK_EN1-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_ACLK_EN1_MSK               (0xffffffffUL << AG903_SPC_AXI_CLK_CTRL1_ACLK_EN1_POS)        /** SPCAXI_CLK_CTRL1 ACLK_EN1-bit mask */

#define AG903_SPC_AXI_CLK_CTRL2_ACLK_EN2_POS               0                                                             /** SPCAXI_CLK_CTRL2 ACLK_EN2-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_ACLK_EN2_MSK               (0x1fffUL << AG903_SPC_AXI_CLK_CTRL2_ACLK_EN2_POS)            /** SPCAXI_CLK_CTRL2 ACLK_EN2-bit mask */

#define AG903_SPC_PLL1_CTRL_MS_POS                         0                                                             /** SPCPLL1_CTRL MS-bit position */
#define AG903_SPC_PLL1_CTRL_MS_MSK                         (0x3fUL << AG903_SPC_PLL1_CTRL_MS_POS)                        /** SPCPLL1_CTRL MS-bit mask */
#define AG903_SPC_PLL1_CTRL_NS_POS                         8                                                             /** SPCPLL1_CTRL NS-bit position */
#define AG903_SPC_PLL1_CTRL_NS_MSK                         (0x3fUL << AG903_SPC_PLL1_CTRL_NS_POS)                        /** SPCPLL1_CTRL NS-bit mask */
#define AG903_SPC_PLL1_CTRL_FR_POS                         16                                                            /** SPCPLL1_CTRL FR-bit position */
#define AG903_SPC_PLL1_CTRL_FR_MSK                         (0x3UL << AG903_SPC_PLL1_CTRL_FR_POS)                         /** SPCPLL1_CTRL FR-bit mask */
#define AG903_SPC_PLL1_CTRL_SRC_POS                        20                                                            /** SPCPLL1_CTRL SRC-bit position */
#define AG903_SPC_PLL1_CTRL_SRC_MSK                        (0x3UL << AG903_SPC_PLL1_CTRL_SRC_POS)                        /** SPCPLL1_CTRL SRC-bit mask */
#define AG903_SPC_PLL1_CTRL_DIV_POS                        24                                                            /** SPCPLL1_CTRL DIV-bit position */
#define AG903_SPC_PLL1_CTRL_DIV_MSK                        (0x7UL << AG903_SPC_PLL1_CTRL_DIV_POS)                        /** SPCPLL1_CTRL DIV-bit mask */
#define AG903_SPC_PLL1_CTRL_EN_POS                         28                                                            /** SPCPLL1_CTRL EN-bit position */
#define AG903_SPC_PLL1_CTRL_EN_MSK                         (0x1UL << AG903_SPC_PLL1_CTRL_EN_POS)                         /** SPCPLL1_CTRL EN-bit mask */

#define AG903_SPC_PLL2_CTRL_MS_POS                         0                                                             /** SPCPLL2_CTRL MS-bit position */
#define AG903_SPC_PLL2_CTRL_MS_MSK                         (0x3fUL << AG903_SPC_PLL2_CTRL_MS_POS)                        /** SPCPLL2_CTRL MS-bit mask */
#define AG903_SPC_PLL2_CTRL_NS_POS                         8                                                             /** SPCPLL2_CTRL NS-bit position */
#define AG903_SPC_PLL2_CTRL_NS_MSK                         (0x3fUL << AG903_SPC_PLL2_CTRL_NS_POS)                        /** SPCPLL2_CTRL NS-bit mask */
#define AG903_SPC_PLL2_CTRL_FR_POS                         16                                                            /** SPCPLL2_CTRL FR-bit position */
#define AG903_SPC_PLL2_CTRL_FR_MSK                         (0x3UL << AG903_SPC_PLL2_CTRL_FR_POS)                         /** SPCPLL2_CTRL FR-bit mask */
#define AG903_SPC_PLL2_CTRL_SRC_POS                        20                                                            /** SPCPLL2_CTRL SRC-bit position */
#define AG903_SPC_PLL2_CTRL_SRC_MSK                        (0x3UL << AG903_SPC_PLL2_CTRL_SRC_POS)                        /** SPCPLL2_CTRL SRC-bit mask */
#define AG903_SPC_PLL2_CTRL_DIV_POS                        24                                                            /** SPCPLL2_CTRL DIV-bit position */
#define AG903_SPC_PLL2_CTRL_DIV_MSK                        (0x7UL << AG903_SPC_PLL2_CTRL_DIV_POS)                        /** SPCPLL2_CTRL DIV-bit mask */
#define AG903_SPC_PLL2_CTRL_EN_POS                         28                                                            /** SPCPLL2_CTRL EN-bit position */
#define AG903_SPC_PLL2_CTRL_EN_MSK                         (0x1UL << AG903_SPC_PLL2_CTRL_EN_POS)                         /** SPCPLL2_CTRL EN-bit mask */

#define AG903_SPC_PLL3_CTRL_MS_POS                         0                                                             /** SPCPLL3_CTRL MS-bit position */
#define AG903_SPC_PLL3_CTRL_MS_MSK                         (0x3fUL << AG903_SPC_PLL3_CTRL_MS_POS)                        /** SPCPLL3_CTRL MS-bit mask */
#define AG903_SPC_PLL3_CTRL_NS_POS                         8                                                             /** SPCPLL3_CTRL NS-bit position */
#define AG903_SPC_PLL3_CTRL_NS_MSK                         (0x3fUL << AG903_SPC_PLL3_CTRL_NS_POS)                        /** SPCPLL3_CTRL NS-bit mask */
#define AG903_SPC_PLL3_CTRL_FR_POS                         16                                                            /** SPCPLL3_CTRL FR-bit position */
#define AG903_SPC_PLL3_CTRL_FR_MSK                         (0x3UL << AG903_SPC_PLL3_CTRL_FR_POS)                         /** SPCPLL3_CTRL FR-bit mask */
#define AG903_SPC_PLL3_CTRL_SRC_POS                        20                                                            /** SPCPLL3_CTRL SRC-bit position */
#define AG903_SPC_PLL3_CTRL_SRC_MSK                        (0x3UL << AG903_SPC_PLL3_CTRL_SRC_POS)                        /** SPCPLL3_CTRL SRC-bit mask */
#define AG903_SPC_PLL3_CTRL_DIV_POS                        24                                                            /** SPCPLL3_CTRL DIV-bit position */
#define AG903_SPC_PLL3_CTRL_DIV_MSK                        (0x7UL << AG903_SPC_PLL3_CTRL_DIV_POS)                        /** SPCPLL3_CTRL DIV-bit mask */
#define AG903_SPC_PLL3_CTRL_EN_POS                         28                                                            /** SPCPLL3_CTRL EN-bit position */
#define AG903_SPC_PLL3_CTRL_EN_MSK                         (0x1UL << AG903_SPC_PLL3_CTRL_EN_POS)                         /** SPCPLL3_CTRL EN-bit mask */

#define AG903_SPC_PLLA_CTRL_MS_POS                         0                                                             /** SPCPLLA_CTRL MS-bit position */
#define AG903_SPC_PLLA_CTRL_MS_MSK                         (0xfUL << AG903_SPC_PLLA_CTRL_MS_POS)                         /** SPCPLLA_CTRL MS-bit mask */
#define AG903_SPC_PLLA_CTRL_CC_POS                         4                                                             /** SPCPLLA_CTRL CC-bit position */
#define AG903_SPC_PLLA_CTRL_CC_MSK                         (0x7UL << AG903_SPC_PLLA_CTRL_CC_POS)                         /** SPCPLLA_CTRL CC-bit mask */
#define AG903_SPC_PLLA_CTRL_NS_POS                         8                                                             /** SPCPLLA_CTRL NS-bit position */
#define AG903_SPC_PLLA_CTRL_NS_MSK                         (0xffUL << AG903_SPC_PLLA_CTRL_NS_POS)                        /** SPCPLLA_CTRL NS-bit mask */
#define AG903_SPC_PLLA_CTRL_FR_POS                         16                                                            /** SPCPLLA_CTRL FR-bit position */
#define AG903_SPC_PLLA_CTRL_FR_MSK                         (0x3UL << AG903_SPC_PLLA_CTRL_FR_POS)                         /** SPCPLLA_CTRL FR-bit mask */
#define AG903_SPC_PLLA_CTRL_SRC_POS                        20                                                            /** SPCPLLA_CTRL SRC-bit position */
#define AG903_SPC_PLLA_CTRL_SRC_MSK                        (0x3UL << AG903_SPC_PLLA_CTRL_SRC_POS)                        /** SPCPLLA_CTRL SRC-bit mask */
#define AG903_SPC_PLLA_CTRL_DIV_POS                        24                                                            /** SPCPLLA_CTRL DIV-bit position */
#define AG903_SPC_PLLA_CTRL_DIV_MSK                        (0x7UL << AG903_SPC_PLLA_CTRL_DIV_POS)                        /** SPCPLLA_CTRL DIV-bit mask */
#define AG903_SPC_PLLA_CTRL_EN_POS                         28                                                            /** SPCPLLA_CTRL EN-bit position */
#define AG903_SPC_PLLA_CTRL_EN_MSK                         (0x1UL << AG903_SPC_PLLA_CTRL_EN_POS)                         /** SPCPLLA_CTRL EN-bit mask */

#define AG903_SPC_SOFTRESET_MASK1_SWRST_MASK1_POS          0                                                             /** SPCSOFTRESET_MASK1 SWRST_MASK1-bit position */
#define AG903_SPC_SOFTRESET_MASK1_SWRST_MASK1_MSK          (0xffffffffUL << AG903_SPC_SOFTRESET_MASK1_SWRST_MASK1_POS)   /** SPCSOFTRESET_MASK1 SWRST_MASK1-bit mask */

#define AG903_SPC_SOFTRESET_MASK2_SWRST_MASK2_POS          0                                                             /** SPCSOFTRESET_MASK2 SWRST_MASK2-bit position */
#define AG903_SPC_SOFTRESET_MASK2_SWRST_MASK2_MSK          (0xffffffffUL << AG903_SPC_SOFTRESET_MASK2_SWRST_MASK2_POS)   /** SPCSOFTRESET_MASK2 SWRST_MASK2-bit mask */

#define AG903_SPC_SOFTRESET_MASK3_SWRST_MASK3_POS          0                                                             /** SPCSOFTRESET_MASK3 SWRST_MASK3-bit position */
#define AG903_SPC_SOFTRESET_MASK3_SWRST_MASK3_MSK          (0xffffffffUL << AG903_SPC_SOFTRESET_MASK3_SWRST_MASK3_POS)   /** SPCSOFTRESET_MASK3 SWRST_MASK3-bit mask */

#define AG903_SPC_SOFTRESET_MASK4_SWRST_MASK4_POS          0                                                             /** SPCSOFTRESET_MASK4 SWRST_MASK4-bit position */
#define AG903_SPC_SOFTRESET_MASK4_SWRST_MASK4_MSK          (0xffffffffUL << AG903_SPC_SOFTRESET_MASK4_SWRST_MASK4_POS)   /** SPCSOFTRESET_MASK4 SWRST_MASK4-bit mask */

#define AG903_SPC_SOFTRESET_MASK5_SWRST_MASK5_POS          0                                                             /** SPCSOFTRESET_MASK5 SWRST_MASK5-bit position */
#define AG903_SPC_SOFTRESET_MASK5_SWRST_MASK5_MSK          (0xffffffffUL << AG903_SPC_SOFTRESET_MASK5_SWRST_MASK5_POS)   /** SPCSOFTRESET_MASK5 SWRST_MASK5-bit mask */

#define AG903_SPC_APB_SDMC_CLK_CTRL_PCLK_EN_POS            0                                                             /** SPCAPB_SDMC_CLK_CTRL PCLK_EN-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_PCLK_EN_MSK            (0xffffffUL << AG903_SPC_APB_SDMC_CLK_CTRL_PCLK_EN_POS)       /** SPCAPB_SDMC_CLK_CTRL PCLK_EN-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_SDMCCLK_EN_POS         24                                                            /** SPCAPB_SDMC_CLK_CTRL SDMCCLK_EN-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_SDMCCLK_EN_MSK         (0xffUL << AG903_SPC_APB_SDMC_CLK_CTRL_SDMCCLK_EN_POS)        /** SPCAPB_SDMC_CLK_CTRL SDMCCLK_EN-bit mask */

#define AG903_SPC_MISC_CLK_CTRL_SCLK_EN_POS                0                                                             /** SPCMISC_CLK_CTRL SCLK_EN-bit position */
#define AG903_SPC_MISC_CLK_CTRL_SCLK_EN_MSK                (0xffffffffUL << AG903_SPC_MISC_CLK_CTRL_SCLK_EN_POS)         /** SPCMISC_CLK_CTRL SCLK_EN-bit mask */

#define AG903_SPC_PIN_STATUS_MODE_POS                      0                                                             /** SPCPIN_STATUS MODE-bit position */
#define AG903_SPC_PIN_STATUS_MODE_MSK                      (0xfUL << AG903_SPC_PIN_STATUS_MODE_POS)                      /** SPCPIN_STATUS MODE-bit mask */
#define AG903_SPC_PIN_STATUS_TEST_POS                      4                                                             /** SPCPIN_STATUS TEST-bit position */
#define AG903_SPC_PIN_STATUS_TEST_MSK                      (0xfUL << AG903_SPC_PIN_STATUS_TEST_POS)                      /** SPCPIN_STATUS TEST-bit mask */

#define AG903_SPC_SDMC_MISC_CTRL_CLK_SEL_POS               0                                                             /** SPCSDMC_MISC_CTRL CLK_SEL-bit position */
#define AG903_SPC_SDMC_MISC_CTRL_CLK_SEL_MSK               (0x1UL << AG903_SPC_SDMC_MISC_CTRL_CLK_SEL_POS)               /** SPCSDMC_MISC_CTRL CLK_SEL-bit mask */
#define AG903_SPC_SDMC_MISC_CTRL_SREF_REQ_POS              8                                                             /** SPCSDMC_MISC_CTRL SREF_REQ-bit position */
#define AG903_SPC_SDMC_MISC_CTRL_SREF_REQ_MSK              (0x1UL << AG903_SPC_SDMC_MISC_CTRL_SREF_REQ_POS)              /** SPCSDMC_MISC_CTRL SREF_REQ-bit mask */
#define AG903_SPC_SDMC_MISC_CTRL_SREF_ACK_POS              12                                                            /** SPCSDMC_MISC_CTRL SREF_ACK-bit position */
#define AG903_SPC_SDMC_MISC_CTRL_SREF_ACK_MSK              (0x1UL << AG903_SPC_SDMC_MISC_CTRL_SREF_ACK_POS)              /** SPCSDMC_MISC_CTRL SREF_ACK-bit mask */
#define AG903_SPC_SDMC_MISC_CTRL_WCLK_SEL_POS              16                                                            /** SPCSDMC_MISC_CTRL WCLK_SEL-bit position */
#define AG903_SPC_SDMC_MISC_CTRL_WCLK_SEL_MSK              (0xfUL << AG903_SPC_SDMC_MISC_CTRL_WCLK_SEL_POS)              /** SPCSDMC_MISC_CTRL WCLK_SEL-bit mask */
#define AG903_SPC_SDMC_MISC_CTRL_RCLK_SEL_POS              20                                                            /** SPCSDMC_MISC_CTRL RCLK_SEL-bit position */
#define AG903_SPC_SDMC_MISC_CTRL_RCLK_SEL_MSK              (0xfUL << AG903_SPC_SDMC_MISC_CTRL_RCLK_SEL_POS)              /** SPCSDMC_MISC_CTRL RCLK_SEL-bit mask */
#define AG903_SPC_SDMC_MISC_CTRL_HCLK_SEL_POS              24                                                            /** SPCSDMC_MISC_CTRL HCLK_SEL-bit position */
#define AG903_SPC_SDMC_MISC_CTRL_HCLK_SEL_MSK              (0xfUL << AG903_SPC_SDMC_MISC_CTRL_HCLK_SEL_POS)              /** SPCSDMC_MISC_CTRL HCLK_SEL-bit mask */

#define AG903_SPC_DDR_MISC_CTRL_REFRESH_POS                0                                                             /** SPCDDR_MISC_CTRL REFRESH-bit position */
#define AG903_SPC_DDR_MISC_CTRL_REFRESH_MSK                (0x1UL << AG903_SPC_DDR_MISC_CTRL_REFRESH_POS)                /** SPCDDR_MISC_CTRL REFRESH-bit mask */
#define AG903_SPC_DDR_MISC_CTRL_INIT_OK_POS                8                                                             /** SPCDDR_MISC_CTRL INIT_OK-bit position */
#define AG903_SPC_DDR_MISC_CTRL_INIT_OK_MSK                (0x1UL << AG903_SPC_DDR_MISC_CTRL_INIT_OK_POS)                /** SPCDDR_MISC_CTRL INIT_OK-bit mask */

#define AG903_SPC_SPIROM_MISC_CTRL_ADDR_CYC_POS            0                                                             /** SPCSPIROM_MISC_CTRL ADDR_CYC-bit position */
#define AG903_SPC_SPIROM_MISC_CTRL_ADDR_CYC_MSK            (0x1UL << AG903_SPC_SPIROM_MISC_CTRL_ADDR_CYC_POS)            /** SPCSPIROM_MISC_CTRL ADDR_CYC-bit mask */

#define AG903_SPC_CLK_SEL1_HDACLK_SEL_POS                  0                                                             /** SPCCLK_SEL1 HDACLK_SEL-bit position */
#define AG903_SPC_CLK_SEL1_HDACLK_SEL_MSK                  (0x3UL << AG903_SPC_CLK_SEL1_HDACLK_SEL_POS)                  /** SPCCLK_SEL1 HDACLK_SEL-bit mask */
#define AG903_SPC_CLK_SEL1_DT0CLK_SEL_POS                  4                                                             /** SPCCLK_SEL1 DT0CLK_SEL-bit position */
#define AG903_SPC_CLK_SEL1_DT0CLK_SEL_MSK                  (0x1UL << AG903_SPC_CLK_SEL1_DT0CLK_SEL_POS)                  /** SPCCLK_SEL1 DT0CLK_SEL-bit mask */
#define AG903_SPC_CLK_SEL1_DT1CLK_SEL_POS                  8                                                             /** SPCCLK_SEL1 DT1CLK_SEL-bit position */
#define AG903_SPC_CLK_SEL1_DT1CLK_SEL_MSK                  (0x3UL << AG903_SPC_CLK_SEL1_DT1CLK_SEL_POS)                  /** SPCCLK_SEL1 DT1CLK_SEL-bit mask */
#define AG903_SPC_CLK_SEL1_LVDSCLK_SEL_POS                 12                                                            /** SPCCLK_SEL1 LVDSCLK_SEL-bit position */
#define AG903_SPC_CLK_SEL1_LVDSCLK_SEL_MSK                 (0x1UL << AG903_SPC_CLK_SEL1_LVDSCLK_SEL_POS)                 /** SPCCLK_SEL1 LVDSCLK_SEL-bit mask */
#define AG903_SPC_CLK_SEL1_CP0CLK_SEL_POS                  16                                                            /** SPCCLK_SEL1 CP0CLK_SEL-bit position */
#define AG903_SPC_CLK_SEL1_CP0CLK_SEL_MSK                  (0x3UL << AG903_SPC_CLK_SEL1_CP0CLK_SEL_POS)                  /** SPCCLK_SEL1 CP0CLK_SEL-bit mask */
#define AG903_SPC_CLK_SEL1_CP1CLK_SEL_POS                  20                                                            /** SPCCLK_SEL1 CP1CLK_SEL-bit position */
#define AG903_SPC_CLK_SEL1_CP1CLK_SEL_MSK                  (0x3UL << AG903_SPC_CLK_SEL1_CP1CLK_SEL_POS)                  /** SPCCLK_SEL1 CP1CLK_SEL-bit mask */

#define AG903_SPC_CLK_SSP_SEL_SSP0CLK_SEL_POS              0                                                             /** SPCCLK_SSP_SEL SSP0CLK_SEL-bit position */
#define AG903_SPC_CLK_SSP_SEL_SSP0CLK_SEL_MSK              (0x7UL << AG903_SPC_CLK_SSP_SEL_SSP0CLK_SEL_POS)              /** SPCCLK_SSP_SEL SSP0CLK_SEL-bit mask */
#define AG903_SPC_CLK_SSP_SEL_SSP1CLK_SEL_POS              4                                                             /** SPCCLK_SSP_SEL SSP1CLK_SEL-bit position */
#define AG903_SPC_CLK_SSP_SEL_SSP1CLK_SEL_MSK              (0x7UL << AG903_SPC_CLK_SSP_SEL_SSP1CLK_SEL_POS)              /** SPCCLK_SSP_SEL SSP1CLK_SEL-bit mask */
#define AG903_SPC_CLK_SSP_SEL_SSP2CLK_SEL_POS              8                                                             /** SPCCLK_SSP_SEL SSP2CLK_SEL-bit position */
#define AG903_SPC_CLK_SSP_SEL_SSP2CLK_SEL_MSK              (0x7UL << AG903_SPC_CLK_SSP_SEL_SSP2CLK_SEL_POS)              /** SPCCLK_SSP_SEL SSP2CLK_SEL-bit mask */
#define AG903_SPC_CLK_SSP_SEL_SSP3CLK_SEL_POS              12                                                            /** SPCCLK_SSP_SEL SSP3CLK_SEL-bit position */
#define AG903_SPC_CLK_SSP_SEL_SSP3CLK_SEL_MSK              (0x7UL << AG903_SPC_CLK_SSP_SEL_SSP3CLK_SEL_POS)              /** SPCCLK_SSP_SEL SSP3CLK_SEL-bit mask */
#define AG903_SPC_CLK_SSP_SEL_PLL3CLK_SEL_POS              16                                                            /** SPCCLK_SSP_SEL PLL3CLK_SEL-bit position */
#define AG903_SPC_CLK_SSP_SEL_PLL3CLK_SEL_MSK              (0x3UL << AG903_SPC_CLK_SSP_SEL_PLL3CLK_SEL_POS)              /** SPCCLK_SSP_SEL PLL3CLK_SEL-bit mask */

#define AG903_SPC_CLK_SSP_DIV_SSP0CLK_DIV_POS              0                                                             /** SPCCLK_SSP_DIV SSP0CLK_DIV-bit position */
#define AG903_SPC_CLK_SSP_DIV_SSP0CLK_DIV_MSK              (0x1fUL << AG903_SPC_CLK_SSP_DIV_SSP0CLK_DIV_POS)             /** SPCCLK_SSP_DIV SSP0CLK_DIV-bit mask */
#define AG903_SPC_CLK_SSP_DIV_SSP1CLK_DIV_POS              8                                                             /** SPCCLK_SSP_DIV SSP1CLK_DIV-bit position */
#define AG903_SPC_CLK_SSP_DIV_SSP1CLK_DIV_MSK              (0x1fUL << AG903_SPC_CLK_SSP_DIV_SSP1CLK_DIV_POS)             /** SPCCLK_SSP_DIV SSP1CLK_DIV-bit mask */
#define AG903_SPC_CLK_SSP_DIV_SSP2CLK_DIV_POS              16                                                            /** SPCCLK_SSP_DIV SSP2CLK_DIV-bit position */
#define AG903_SPC_CLK_SSP_DIV_SSP2CLK_DIV_MSK              (0x1fUL << AG903_SPC_CLK_SSP_DIV_SSP2CLK_DIV_POS)             /** SPCCLK_SSP_DIV SSP2CLK_DIV-bit mask */
#define AG903_SPC_CLK_SSP_DIV_SSP3CLK_DIV_POS              24                                                            /** SPCCLK_SSP_DIV SSP3CLK_DIV-bit position */
#define AG903_SPC_CLK_SSP_DIV_SSP3CLK_DIV_MSK              (0x1fUL << AG903_SPC_CLK_SSP_DIV_SSP3CLK_DIV_POS)             /** SPCCLK_SSP_DIV SSP3CLK_DIV-bit mask */

#define AG903_SPC_ETH_PHY_SEL_RMII_POS                     0                                                             /** SPCETH_PHY_SEL RMII-bit position */
#define AG903_SPC_ETH_PHY_SEL_RMII_MSK                     (0x1UL << AG903_SPC_ETH_PHY_SEL_RMII_POS)                     /** SPCETH_PHY_SEL RMII-bit mask */

#define AG903_SPC_CA5_MISC_CTRL1_dbgen_POS                 0                                                             /** SPCCA5_MISC_CTRL1 dbgen-bit position */
#define AG903_SPC_CA5_MISC_CTRL1_dbgen_MSK                 (0xfUL << AG903_SPC_CA5_MISC_CTRL1_dbgen_POS)                 /** SPCCA5_MISC_CTRL1 dbgen-bit mask */
#define AG903_SPC_CA5_MISC_CTRL1_dbgrestart_POS            4                                                             /** SPCCA5_MISC_CTRL1 dbgrestart-bit position */
#define AG903_SPC_CA5_MISC_CTRL1_dbgrestart_MSK            (0xfUL << AG903_SPC_CA5_MISC_CTRL1_dbgrestart_POS)            /** SPCCA5_MISC_CTRL1 dbgrestart-bit mask */
#define AG903_SPC_CA5_MISC_CTRL1_dbgromaddrv_POS           8                                                             /** SPCCA5_MISC_CTRL1 dbgromaddrv-bit position */
#define AG903_SPC_CA5_MISC_CTRL1_dbgromaddrv_MSK           (0x1UL << AG903_SPC_CA5_MISC_CTRL1_dbgromaddrv_POS)           /** SPCCA5_MISC_CTRL1 dbgromaddrv-bit mask */
#define AG903_SPC_CA5_MISC_CTRL1_dbgselfaddrv_POS          12                                                            /** SPCCA5_MISC_CTRL1 dbgselfaddrv-bit position */
#define AG903_SPC_CA5_MISC_CTRL1_dbgselfaddrv_MSK          (0x1UL << AG903_SPC_CA5_MISC_CTRL1_dbgselfaddrv_POS)          /** SPCCA5_MISC_CTRL1 dbgselfaddrv-bit mask */

#define AG903_SPC_CA5_MISC_CTRL2_dbgromaddr_POS            12                                                            /** SPCCA5_MISC_CTRL2 dbgromaddr-bit position */
#define AG903_SPC_CA5_MISC_CTRL2_dbgromaddr_MSK            (0xfffffUL << AG903_SPC_CA5_MISC_CTRL2_dbgromaddr_POS)        /** SPCCA5_MISC_CTRL2 dbgromaddr-bit mask */

#define AG903_SPC_CA5_MISC_CTRL3_dbgselfaddr_POS           12                                                            /** SPCCA5_MISC_CTRL3 dbgselfaddr-bit position */
#define AG903_SPC_CA5_MISC_CTRL3_dbgselfaddr_MSK           (0xfffffUL << AG903_SPC_CA5_MISC_CTRL3_dbgselfaddr_POS)       /** SPCCA5_MISC_CTRL3 dbgselfaddr-bit mask */

#define AG903_SPC_CA5_MISC_CTRL4_periphbase_POS            13                                                            /** SPCCA5_MISC_CTRL4 periphbase-bit position */
#define AG903_SPC_CA5_MISC_CTRL4_periphbase_MSK            (0x7ffffUL << AG903_SPC_CA5_MISC_CTRL4_periphbase_POS)        /** SPCCA5_MISC_CTRL4 periphbase-bit mask */

#define AG903_SPC_CA5_MISC_CTRL5_L2waysize_POS             0                                                             /** SPCCA5_MISC_CTRL5 L2waysize-bit position */
#define AG903_SPC_CA5_MISC_CTRL5_L2waysize_MSK             (0x7UL << AG903_SPC_CA5_MISC_CTRL5_L2waysize_POS)             /** SPCCA5_MISC_CTRL5 L2waysize-bit mask */
#define AG903_SPC_CA5_MISC_CTRL5_L2associativity_POS       4                                                             /** SPCCA5_MISC_CTRL5 L2associativity-bit position */
#define AG903_SPC_CA5_MISC_CTRL5_L2associativity_MSK       (0x1UL << AG903_SPC_CA5_MISC_CTRL5_L2associativity_POS)       /** SPCCA5_MISC_CTRL5 L2associativity-bit mask */
#define AG903_SPC_CA5_MISC_CTRL5_L2spniden_POS             8                                                             /** SPCCA5_MISC_CTRL5 L2spniden-bit position */
#define AG903_SPC_CA5_MISC_CTRL5_L2spniden_MSK             (0x1UL << AG903_SPC_CA5_MISC_CTRL5_L2spniden_POS)             /** SPCCA5_MISC_CTRL5 L2spniden-bit mask */
#define AG903_SPC_CA5_MISC_CTRL5_L2filteren_POS            12                                                            /** SPCCA5_MISC_CTRL5 L2filteren-bit position */
#define AG903_SPC_CA5_MISC_CTRL5_L2filteren_MSK            (0x1UL << AG903_SPC_CA5_MISC_CTRL5_L2filteren_POS)            /** SPCCA5_MISC_CTRL5 L2filteren-bit mask */

#define AG903_SPC_CA5_MISC_CTRL6_L2periphbase_POS          12                                                            /** SPCCA5_MISC_CTRL6 L2periphbase-bit position */
#define AG903_SPC_CA5_MISC_CTRL6_L2periphbase_MSK          (0xfffffUL << AG903_SPC_CA5_MISC_CTRL6_L2periphbase_POS)      /** SPCCA5_MISC_CTRL6 L2periphbase-bit mask */

#define AG903_SPC_CA5_MISC_CTRL7_L2filterstart_POS         0                                                             /** SPCCA5_MISC_CTRL7 L2filterstart-bit position */
#define AG903_SPC_CA5_MISC_CTRL7_L2filterstart_MSK         (0xfffUL << AG903_SPC_CA5_MISC_CTRL7_L2filterstart_POS)       /** SPCCA5_MISC_CTRL7 L2filterstart-bit mask */
#define AG903_SPC_CA5_MISC_CTRL7_L2filterend_POS           16                                                            /** SPCCA5_MISC_CTRL7 L2filterend-bit position */
#define AG903_SPC_CA5_MISC_CTRL7_L2filterend_MSK           (0xfffUL << AG903_SPC_CA5_MISC_CTRL7_L2filterend_POS)         /** SPCCA5_MISC_CTRL7 L2filterend-bit mask */

#define AG903_SPC_CA5_MISC_CTRL8_portconnected_POS         0                                                             /** SPCCA5_MISC_CTRL8 portconnected-bit position */
#define AG903_SPC_CA5_MISC_CTRL8_portconnected_MSK         (0xffUL << AG903_SPC_CA5_MISC_CTRL8_portconnected_POS)        /** SPCCA5_MISC_CTRL8 portconnected-bit mask */
#define AG903_SPC_CA5_MISC_CTRL8_portenabled_POS           8                                                             /** SPCCA5_MISC_CTRL8 portenabled-bit position */
#define AG903_SPC_CA5_MISC_CTRL8_portenabled_MSK           (0xffUL << AG903_SPC_CA5_MISC_CTRL8_portenabled_POS)          /** SPCCA5_MISC_CTRL8 portenabled-bit mask */
#define AG903_SPC_CA5_MISC_CTRL8_srstconnected_POS         16                                                            /** SPCCA5_MISC_CTRL8 srstconnected-bit position */
#define AG903_SPC_CA5_MISC_CTRL8_srstconnected_MSK         (0xffUL << AG903_SPC_CA5_MISC_CTRL8_srstconnected_POS)        /** SPCCA5_MISC_CTRL8 srstconnected-bit mask */
#define AG903_SPC_CA5_MISC_CTRL8_CP15Sdisable_POS          24                                                            /** SPCCA5_MISC_CTRL8 CP15Sdisable-bit position */
#define AG903_SPC_CA5_MISC_CTRL8_CP15Sdisable_MSK          (0xfUL << AG903_SPC_CA5_MISC_CTRL8_CP15Sdisable_POS)          /** SPCCA5_MISC_CTRL8 CP15Sdisable-bit mask */
#define AG903_SPC_CA5_MISC_CTRL8_L1rstdisable_POS          28                                                            /** SPCCA5_MISC_CTRL8 L1rstdisable-bit position */
#define AG903_SPC_CA5_MISC_CTRL8_L1rstdisable_MSK          (0xfUL << AG903_SPC_CA5_MISC_CTRL8_L1rstdisable_POS)          /** SPCCA5_MISC_CTRL8 L1rstdisable-bit mask */

#define AG903_SPC_CA5_MISC_CTRL9_pwrctli0_POS              0                                                             /** SPCCA5_MISC_CTRL9 pwrctli0-bit position */
#define AG903_SPC_CA5_MISC_CTRL9_pwrctli0_MSK              (0x3UL << AG903_SPC_CA5_MISC_CTRL9_pwrctli0_POS)              /** SPCCA5_MISC_CTRL9 pwrctli0-bit mask */
#define AG903_SPC_CA5_MISC_CTRL9_pwrctli1_POS              4                                                             /** SPCCA5_MISC_CTRL9 pwrctli1-bit position */
#define AG903_SPC_CA5_MISC_CTRL9_pwrctli1_MSK              (0x3UL << AG903_SPC_CA5_MISC_CTRL9_pwrctli1_POS)              /** SPCCA5_MISC_CTRL9 pwrctli1-bit mask */
#define AG903_SPC_CA5_MISC_CTRL9_pwrctli2_POS              8                                                             /** SPCCA5_MISC_CTRL9 pwrctli2-bit position */
#define AG903_SPC_CA5_MISC_CTRL9_pwrctli2_MSK              (0x3UL << AG903_SPC_CA5_MISC_CTRL9_pwrctli2_POS)              /** SPCCA5_MISC_CTRL9 pwrctli2-bit mask */
#define AG903_SPC_CA5_MISC_CTRL9_pwrctli3_POS              12                                                            /** SPCCA5_MISC_CTRL9 pwrctli3-bit position */
#define AG903_SPC_CA5_MISC_CTRL9_pwrctli3_MSK              (0x3UL << AG903_SPC_CA5_MISC_CTRL9_pwrctli3_POS)              /** SPCCA5_MISC_CTRL9 pwrctli3-bit mask */
#define AG903_SPC_CA5_MISC_CTRL9_atb_csysreq_POS           16                                                            /** SPCCA5_MISC_CTRL9 atb_csysreq-bit position */
#define AG903_SPC_CA5_MISC_CTRL9_atb_csysreq_MSK           (0xfUL << AG903_SPC_CA5_MISC_CTRL9_atb_csysreq_POS)           /** SPCCA5_MISC_CTRL9 atb_csysreq-bit mask */
#define AG903_SPC_CA5_MISC_CTRL9_atb_mstclamp_POS          20                                                            /** SPCCA5_MISC_CTRL9 atb_mstclamp-bit position */
#define AG903_SPC_CA5_MISC_CTRL9_atb_mstclamp_MSK          (0xfUL << AG903_SPC_CA5_MISC_CTRL9_atb_mstclamp_POS)          /** SPCCA5_MISC_CTRL9 atb_mstclamp-bit mask */
#define AG903_SPC_CA5_MISC_CTRL9_atb_slvclamp_POS          24                                                            /** SPCCA5_MISC_CTRL9 atb_slvclamp-bit position */
#define AG903_SPC_CA5_MISC_CTRL9_atb_slvclamp_MSK          (0xfUL << AG903_SPC_CA5_MISC_CTRL9_atb_slvclamp_POS)          /** SPCCA5_MISC_CTRL9 atb_slvclamp-bit mask */

#define AG903_SPC_CA5_MISC_CTRL10_eventi_POS               0                                                             /** SPCCA5_MISC_CTRL10 eventi-bit position */
#define AG903_SPC_CA5_MISC_CTRL10_eventi_MSK               (0x1UL << AG903_SPC_CA5_MISC_CTRL10_eventi_POS)               /** SPCCA5_MISC_CTRL10 eventi-bit mask */
#define AG903_SPC_CA5_MISC_CTRL10_maxextin_POS             4                                                             /** SPCCA5_MISC_CTRL10 maxextin-bit position */
#define AG903_SPC_CA5_MISC_CTRL10_maxextin_MSK             (0x7UL << AG903_SPC_CA5_MISC_CTRL10_maxextin_POS)             /** SPCCA5_MISC_CTRL10 maxextin-bit mask */
#define AG903_SPC_CA5_MISC_CTRL10_maxextout_POS            8                                                             /** SPCCA5_MISC_CTRL10 maxextout-bit position */
#define AG903_SPC_CA5_MISC_CTRL10_maxextout_MSK            (0x3UL << AG903_SPC_CA5_MISC_CTRL10_maxextout_POS)            /** SPCCA5_MISC_CTRL10 maxextout-bit mask */
#define AG903_SPC_CA5_MISC_CTRL10_niden_POS                12                                                            /** SPCCA5_MISC_CTRL10 niden-bit position */
#define AG903_SPC_CA5_MISC_CTRL10_niden_MSK                (0xfUL << AG903_SPC_CA5_MISC_CTRL10_niden_POS)                /** SPCCA5_MISC_CTRL10 niden-bit mask */
#define AG903_SPC_CA5_MISC_CTRL10_spiden_POS               16                                                            /** SPCCA5_MISC_CTRL10 spiden-bit position */
#define AG903_SPC_CA5_MISC_CTRL10_spiden_MSK               (0xfUL << AG903_SPC_CA5_MISC_CTRL10_spiden_POS)               /** SPCCA5_MISC_CTRL10 spiden-bit mask */
#define AG903_SPC_CA5_MISC_CTRL10_spniden_POS              20                                                            /** SPCCA5_MISC_CTRL10 spniden-bit position */
#define AG903_SPC_CA5_MISC_CTRL10_spniden_MSK              (0xfUL << AG903_SPC_CA5_MISC_CTRL10_spniden_POS)              /** SPCCA5_MISC_CTRL10 spniden-bit mask */

#define AG903_SPC_CA5_MISC_CTRL11_ARusers_POS              0                                                             /** SPCCA5_MISC_CTRL11 ARusers-bit position */
#define AG903_SPC_CA5_MISC_CTRL11_ARusers_MSK              (0x1UL << AG903_SPC_CA5_MISC_CTRL11_ARusers_POS)              /** SPCCA5_MISC_CTRL11 ARusers-bit mask */
#define AG903_SPC_CA5_MISC_CTRL11_AWusers_POS              8                                                             /** SPCCA5_MISC_CTRL11 AWusers-bit position */
#define AG903_SPC_CA5_MISC_CTRL11_AWusers_MSK              (0x1UL << AG903_SPC_CA5_MISC_CTRL11_AWusers_POS)              /** SPCCA5_MISC_CTRL11 AWusers-bit mask */
#define AG903_SPC_CA5_MISC_CTRL11_ARprots_POS              16                                                            /** SPCCA5_MISC_CTRL11 ARprots-bit position */
#define AG903_SPC_CA5_MISC_CTRL11_ARprots_MSK              (0x7UL << AG903_SPC_CA5_MISC_CTRL11_ARprots_POS)              /** SPCCA5_MISC_CTRL11 ARprots-bit mask */
#define AG903_SPC_CA5_MISC_CTRL11_AWprots_POS              20                                                            /** SPCCA5_MISC_CTRL11 AWprots-bit position */
#define AG903_SPC_CA5_MISC_CTRL11_AWprots_MSK              (0x7UL << AG903_SPC_CA5_MISC_CTRL11_AWprots_POS)              /** SPCCA5_MISC_CTRL11 AWprots-bit mask */

#define AG903_SPC_VIDEOADC_MISC_CTRL1_ENABLE_POS           0                                                             /** SPCVIDEOADC_MISC_CTRL1 ENABLE-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL1_ENABLE_MSK           (0x1UL << AG903_SPC_VIDEOADC_MISC_CTRL1_ENABLE_POS)           /** SPCVIDEOADC_MISC_CTRL1 ENABLE-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN0_POS        4                                                             /** SPCVIDEOADC_MISC_CTRL1 CLAMP_EN0-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN0_MSK        (0x1UL << AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN0_POS)        /** SPCVIDEOADC_MISC_CTRL1 CLAMP_EN0-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN1_POS        8                                                             /** SPCVIDEOADC_MISC_CTRL1 CLAMP_EN1-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN1_MSK        (0x1UL << AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN1_POS)        /** SPCVIDEOADC_MISC_CTRL1 CLAMP_EN1-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN2_POS        12                                                            /** SPCVIDEOADC_MISC_CTRL1 CLAMP_EN2-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN2_MSK        (0x1UL << AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN2_POS)        /** SPCVIDEOADC_MISC_CTRL1 CLAMP_EN2-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN3_POS        16                                                            /** SPCVIDEOADC_MISC_CTRL1 CLAMP_EN3-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN3_MSK        (0x1UL << AG903_SPC_VIDEOADC_MISC_CTRL1_CLAMP_EN3_POS)        /** SPCVIDEOADC_MISC_CTRL1 CLAMP_EN3-bit mask */

#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH0_ENABLE_POS       1                                                             /** SPCVIDEOADC_MISC_CTRL2 CH0_ENABLE-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH0_ENABLE_MSK       (0x1UL << AG903_SPC_VIDEOADC_MISC_CTRL2_CH0_ENABLE_POS)       /** SPCVIDEOADC_MISC_CTRL2 CH0_ENABLE-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH1_ENABLE_POS       2                                                             /** SPCVIDEOADC_MISC_CTRL2 CH1_ENABLE-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH1_ENABLE_MSK       (0x1UL << AG903_SPC_VIDEOADC_MISC_CTRL2_CH1_ENABLE_POS)       /** SPCVIDEOADC_MISC_CTRL2 CH1_ENABLE-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH2_ENABLE_POS       3                                                             /** SPCVIDEOADC_MISC_CTRL2 CH2_ENABLE-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH2_ENABLE_MSK       (0x1UL << AG903_SPC_VIDEOADC_MISC_CTRL2_CH2_ENABLE_POS)       /** SPCVIDEOADC_MISC_CTRL2 CH2_ENABLE-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH3_ENABLE_POS       4                                                             /** SPCVIDEOADC_MISC_CTRL2 CH3_ENABLE-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH3_ENABLE_MSK       (0x1UL << AG903_SPC_VIDEOADC_MISC_CTRL2_CH3_ENABLE_POS)       /** SPCVIDEOADC_MISC_CTRL2 CH3_ENABLE-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CLAMP_IMP_POS        6                                                             /** SPCVIDEOADC_MISC_CTRL2 CLAMP_IMP-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CLAMP_IMP_MSK        (0x3UL << AG903_SPC_VIDEOADC_MISC_CTRL2_CLAMP_IMP_POS)        /** SPCVIDEOADC_MISC_CTRL2 CLAMP_IMP-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH0_CLAMP_POS        8                                                             /** SPCVIDEOADC_MISC_CTRL2 CH0_CLAMP-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH0_CLAMP_MSK        (0xffUL << AG903_SPC_VIDEOADC_MISC_CTRL2_CH0_CLAMP_POS)       /** SPCVIDEOADC_MISC_CTRL2 CH0_CLAMP-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH1_CLAMP_POS        16                                                            /** SPCVIDEOADC_MISC_CTRL2 CH1_CLAMP-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH1_CLAMP_MSK        (0xffUL << AG903_SPC_VIDEOADC_MISC_CTRL2_CH1_CLAMP_POS)       /** SPCVIDEOADC_MISC_CTRL2 CH1_CLAMP-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH2_CLAMP_POS        24                                                            /** SPCVIDEOADC_MISC_CTRL2 CH2_CLAMP-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL2_CH2_CLAMP_MSK        (0xffUL << AG903_SPC_VIDEOADC_MISC_CTRL2_CH2_CLAMP_POS)       /** SPCVIDEOADC_MISC_CTRL2 CH2_CLAMP-bit mask */

#define AG903_SPC_VIDEOADC_MISC_CTRL3_CH3_CLAMP_POS        0                                                             /** SPCVIDEOADC_MISC_CTRL3 CH3_CLAMP-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL3_CH3_CLAMP_MSK        (0xffUL << AG903_SPC_VIDEOADC_MISC_CTRL3_CH3_CLAMP_POS)       /** SPCVIDEOADC_MISC_CTRL3 CH3_CLAMP-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL3_CH0_GAIN_POS         8                                                             /** SPCVIDEOADC_MISC_CTRL3 CH0_GAIN-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL3_CH0_GAIN_MSK         (0xfUL << AG903_SPC_VIDEOADC_MISC_CTRL3_CH0_GAIN_POS)         /** SPCVIDEOADC_MISC_CTRL3 CH0_GAIN-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL3_CH1_GAIN_POS         16                                                            /** SPCVIDEOADC_MISC_CTRL3 CH1_GAIN-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL3_CH1_GAIN_MSK         (0xfUL << AG903_SPC_VIDEOADC_MISC_CTRL3_CH1_GAIN_POS)         /** SPCVIDEOADC_MISC_CTRL3 CH1_GAIN-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL3_CH2_GAIN_POS         24                                                            /** SPCVIDEOADC_MISC_CTRL3 CH2_GAIN-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL3_CH2_GAIN_MSK         (0xfUL << AG903_SPC_VIDEOADC_MISC_CTRL3_CH2_GAIN_POS)         /** SPCVIDEOADC_MISC_CTRL3 CH2_GAIN-bit mask */

#define AG903_SPC_VIDEOADC_MISC_CTRL4_CH3_GAIN_POS         0                                                             /** SPCVIDEOADC_MISC_CTRL4 CH3_GAIN-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL4_CH3_GAIN_MSK         (0xfUL << AG903_SPC_VIDEOADC_MISC_CTRL4_CH3_GAIN_POS)         /** SPCVIDEOADC_MISC_CTRL4 CH3_GAIN-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL4_QUAN_BIAS_UP_POS     18                                                            /** SPCVIDEOADC_MISC_CTRL4 QUAN_BIAS_UP-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL4_QUAN_BIAS_UP_MSK     (0x3UL << AG903_SPC_VIDEOADC_MISC_CTRL4_QUAN_BIAS_UP_POS)     /** SPCVIDEOADC_MISC_CTRL4 QUAN_BIAS_UP-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL4_AAF_CTRL_POS         24                                                            /** SPCVIDEOADC_MISC_CTRL4 AAF_CTRL-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL4_AAF_CTRL_MSK         (0x3fUL << AG903_SPC_VIDEOADC_MISC_CTRL4_AAF_CTRL_POS)        /** SPCVIDEOADC_MISC_CTRL4 AAF_CTRL-bit mask */

#define AG903_SPC_VIDEOADC_MISC_CTRL5_REF_BIAS_UP_POS      2                                                             /** SPCVIDEOADC_MISC_CTRL5 REF_BIAS_UP-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL5_REF_BIAS_UP_MSK      (0x3UL << AG903_SPC_VIDEOADC_MISC_CTRL5_REF_BIAS_UP_POS)      /** SPCVIDEOADC_MISC_CTRL5 REF_BIAS_UP-bit mask */
#define AG903_SPC_VIDEOADC_MISC_CTRL5_INPUT_RANGE_POS      18                                                            /** SPCVIDEOADC_MISC_CTRL5 INPUT_RANGE-bit position */
#define AG903_SPC_VIDEOADC_MISC_CTRL5_INPUT_RANGE_MSK      (0x3UL << AG903_SPC_VIDEOADC_MISC_CTRL5_INPUT_RANGE_POS)      /** SPCVIDEOADC_MISC_CTRL5 INPUT_RANGE-bit mask */

#define AG903_SPC_LVDS_TX_SETUP_RF_0_POS                   0                                                             /** SPCLVDS_TX_SETUP RF_0-bit position */
#define AG903_SPC_LVDS_TX_SETUP_RF_0_MSK                   (0x1UL << AG903_SPC_LVDS_TX_SETUP_RF_0_POS)                   /** SPCLVDS_TX_SETUP RF_0-bit mask */
#define AG903_SPC_LVDS_TX_SETUP_RF_1_POS                   4                                                             /** SPCLVDS_TX_SETUP RF_1-bit position */
#define AG903_SPC_LVDS_TX_SETUP_RF_1_MSK                   (0x1UL << AG903_SPC_LVDS_TX_SETUP_RF_1_POS)                   /** SPCLVDS_TX_SETUP RF_1-bit mask */

#define AG903_SPC_USB_MISC_CTRL1_CLK_SEL_POS               0                                                             /** SPCUSB_MISC_CTRL1 CLK_SEL-bit position */
#define AG903_SPC_USB_MISC_CTRL1_CLK_SEL_MSK               (0x1UL << AG903_SPC_USB_MISC_CTRL1_CLK_SEL_POS)               /** SPCUSB_MISC_CTRL1 CLK_SEL-bit mask */
#define AG903_SPC_USB_MISC_CTRL1_CLK_DIV_POS               4                                                             /** SPCUSB_MISC_CTRL1 CLK_DIV-bit position */
#define AG903_SPC_USB_MISC_CTRL1_CLK_DIV_MSK               (0x1UL << AG903_SPC_USB_MISC_CTRL1_CLK_DIV_POS)               /** SPCUSB_MISC_CTRL1 CLK_DIV-bit mask */
#define AG903_SPC_USB_MISC_CTRL1_VPRTCT_state_POS          8                                                             /** SPCUSB_MISC_CTRL1 VPRTCT_state-bit position */
#define AG903_SPC_USB_MISC_CTRL1_VPRTCT_state_MSK          (0x1UL << AG903_SPC_USB_MISC_CTRL1_VPRTCT_state_POS)          /** SPCUSB_MISC_CTRL1 VPRTCT_state-bit mask */
#define AG903_SPC_USB_MISC_CTRL1_VBUS_outen_POS            12                                                            /** SPCUSB_MISC_CTRL1 VBUS_outen-bit position */
#define AG903_SPC_USB_MISC_CTRL1_VBUS_outen_MSK            (0x1UL << AG903_SPC_USB_MISC_CTRL1_VBUS_outen_POS)            /** SPCUSB_MISC_CTRL1 VBUS_outen-bit mask */

#define AG903_SPC_USB_MISC_CTRL2_OSCOUTEN_POS              0                                                             /** SPCUSB_MISC_CTRL2 OSCOUTEN-bit position */
#define AG903_SPC_USB_MISC_CTRL2_OSCOUTEN_MSK              (0x1UL << AG903_SPC_USB_MISC_CTRL2_OSCOUTEN_POS)              /** SPCUSB_MISC_CTRL2 OSCOUTEN-bit mask */
#define AG903_SPC_USB_MISC_CTRL2_XTLSEL_POS                4                                                             /** SPCUSB_MISC_CTRL2 XTLSEL-bit position */
#define AG903_SPC_USB_MISC_CTRL2_XTLSEL_MSK                (0x1UL << AG903_SPC_USB_MISC_CTRL2_XTLSEL_POS)                /** SPCUSB_MISC_CTRL2 XTLSEL-bit mask */
#define AG903_SPC_USB_MISC_CTRL2_PLLALIV_POS               8                                                             /** SPCUSB_MISC_CTRL2 PLLALIV-bit position */
#define AG903_SPC_USB_MISC_CTRL2_PLLALIV_MSK               (0x1UL << AG903_SPC_USB_MISC_CTRL2_PLLALIV_POS)               /** SPCUSB_MISC_CTRL2 PLLALIV-bit mask */
#define AG903_SPC_USB_MISC_CTRL2_OUTCLKSEL_POS             12                                                            /** SPCUSB_MISC_CTRL2 OUTCLKSEL-bit position */
#define AG903_SPC_USB_MISC_CTRL2_OUTCLKSEL_MSK             (0x1UL << AG903_SPC_USB_MISC_CTRL2_OUTCLKSEL_POS)             /** SPCUSB_MISC_CTRL2 OUTCLKSEL-bit mask */
#define AG903_SPC_USB_MISC_CTRL2_TC_TB_TA_POS              16                                                            /** SPCUSB_MISC_CTRL2 TC_TB_TA-bit position */
#define AG903_SPC_USB_MISC_CTRL2_TC_TB_TA_MSK              (0x7UL << AG903_SPC_USB_MISC_CTRL2_TC_TB_TA_POS)              /** SPCUSB_MISC_CTRL2 TC_TB_TA-bit mask */
#define AG903_SPC_USB_MISC_CTRL2_wakeup_POS                24                                                            /** SPCUSB_MISC_CTRL2 wakeup-bit position */
#define AG903_SPC_USB_MISC_CTRL2_wakeup_MSK                (0x1UL << AG903_SPC_USB_MISC_CTRL2_wakeup_POS)                /** SPCUSB_MISC_CTRL2 wakeup-bit mask */
#define AG903_SPC_USB_MISC_CTRL2_suspendm_POS              28                                                            /** SPCUSB_MISC_CTRL2 suspendm-bit position */
#define AG903_SPC_USB_MISC_CTRL2_suspendm_MSK              (0x1UL << AG903_SPC_USB_MISC_CTRL2_suspendm_POS)              /** SPCUSB_MISC_CTRL2 suspendm-bit mask */

#define AG903_SPC_DDR_PHY_SETUP_AFL_GAIN_POS               0                                                             /** SPCDDR_PHY_SETUP AFL_GAIN-bit position */
#define AG903_SPC_DDR_PHY_SETUP_AFL_GAIN_MSK               (0x3UL << AG903_SPC_DDR_PHY_SETUP_AFL_GAIN_POS)               /** SPCDDR_PHY_SETUP AFL_GAIN-bit mask */
#define AG903_SPC_DDR_PHY_SETUP_PD_GAIN_POS                4                                                             /** SPCDDR_PHY_SETUP PD_GAIN-bit position */
#define AG903_SPC_DDR_PHY_SETUP_PD_GAIN_MSK                (0x7UL << AG903_SPC_DDR_PHY_SETUP_PD_GAIN_POS)                /** SPCDDR_PHY_SETUP PD_GAIN-bit mask */

#define AG903_SPC_BOOT_SWAP_CTRL_BOOTSWAP_POS              0                                                             /** SPCBOOT_SWAP_CTRL BOOTSWAP-bit position */
#define AG903_SPC_BOOT_SWAP_CTRL_BOOTSWAP_MSK              (0x1UL << AG903_SPC_BOOT_SWAP_CTRL_BOOTSWAP_POS)              /** SPCBOOT_SWAP_CTRL BOOTSWAP-bit mask */

#define AG903_SPC_IDE_CLK_SEL_IDECLK_SEL_POS               0                                                             /** SPCIDE_CLK_SEL IDECLK_SEL-bit position */
#define AG903_SPC_IDE_CLK_SEL_IDECLK_SEL_MSK               (0x1UL << AG903_SPC_IDE_CLK_SEL_IDECLK_SEL_POS)               /** SPCIDE_CLK_SEL IDECLK_SEL-bit mask */


#endif /* _AG903_SPC_REGMAP_H_ */

