/**
 * @brief           VIA Manager Header
 * @author          AXELL CORPORATION
 * @description     VIA Manager Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2019_03_08  [SDK2.2] VIAɃrfI͂̐MLł邱Ƃo֐ǉ (#2454)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef VIAMGR_H
#define VIAMGR_H
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>
#include "AG903_errno.h"

/** AiOrfI̓|[g */
#define AG903_VIA_MGR_MAX_PORTS             (4)

/** AiOrfI̓nhʂ郆j[NID */
#define AG903_VIA_MGR_INPUT_HANDLE_ID       (0xA1234AAA)

/** ̓tH[}bg NTSC/ITU-BT.601 */
#define AG903_VIA_MGR_FORMAT_NTSC_BT        (0)
/** ̓tH[}bg NTSC/SquarePixel */
#define AG903_VIA_MGR_FORMAT_NTSC_SQ        (1)
/** ̓tH[}bg NTSC/3Fsc */
#define AG903_VIA_MGR_FORMAT_NTSC_4F        (2)
/** ̓tH[}bg PAL/ITU-BT.601 */
#define AG903_VIA_MGR_FORMAT_PAL_BT         (3)
/** ̓tH[}bg PAL/SquarePixel */
#define AG903_VIA_MGR_FORMAT_PAL_SQ         (4)
/** ̓tH[}bg */
#define AG903_VIA_MGR_FORMAT_MAX            (5)

/** J[[h J[ */
#define AG903_VIA_MGR_MODE_COLOR            (0)
/** J[[h mN */
#define AG903_VIA_MGR_MODE_MONOCHROME       (1)
/** J[[h */
#define AG903_VIA_MGR_MODE_MAX              (2)

/**
 * AiOrfI̓nh
 */
typedef struct _AG903_ViaMgrInputHandle {
    uint32_t id;                /** AiOrfI̓|[gnhʂ邽߂ID */
    uint32_t port_no;           /** ̓|[g̕No */
} AG903_ViaMgrInputHandle;

int32_t AG903_ViaMgrInit(void);
int32_t AG903_ViaMgrGetInputHandle(int32_t *ports, int32_t num_ports, AG903_ViaMgrInputHandle **handles);
int32_t AG903_ViaMgrReleaseInputHandle(AG903_ViaMgrInputHandle *handle);
int32_t AG903_ViaMgrSetInputParameter(AG903_ViaMgrInputHandle *handle, uint32_t format, uint32_t mode);
int32_t AG903_ViaMgrIsInputValid(AG903_ViaMgrInputHandle *handle);

#ifdef __cplusplus
}
#endif

#endif
