/**
 * @brief           SSP Register Definition
 * @author          AXELL CORPORATION
 * @description     SSP Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_SSP_REGMAP_H_
#define _AG903_SSP_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** SSPn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  SSPCR0;

        struct {
            __IO uint32_t  SCLKPH                         :  1;
            __IO uint32_t  SCLKPO                         :  1;
            __IO uint32_t  OPM                            :  2;
            __IO uint32_t  FSJSTFY                        :  1;
            __IO uint32_t  FSPO                           :  1;
            __IO uint32_t  LSB                            :  1;
            __IO uint32_t  LBM                            :  1;
            __IO uint32_t  FSDIST                         :  2;
            __IO uint32_t  Validity                       :  1;
            __IO uint32_t  FLASH                          :  1;
            __IO uint32_t  FFMT                           :  3;
            __IO uint32_t  SPIFSPO                        :  1;
            __IO uint32_t  SCLKFDBK                       :  1;
            __IO uint32_t  FSFDBK                         :  1;
        } SSPCR0_bits;
    };

    union {
        __IO uint32_t  SSPCR1;

        struct {
            __IO uint32_t  SCLKDIV                        : 16;
            __IO uint32_t  SDL                            :  7;
                 uint32_t                                 :  1;
            __IO uint32_t  PDL                            :  8;
        } SSPCR1_bits;
    };

    union {
        __IO uint32_t  SSPCR2;

        struct {
            __IO uint32_t  SSPEN                          :  1;
            __IO uint32_t  TXDOE                          :  1;
            __IO uint32_t  RXFCLR                         :  1;
            __IO uint32_t  TXFCLR                         :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  SSPRST                         :  1;
            __IO uint32_t  RXEN                           :  1;
            __IO uint32_t  TXEN                           :  1;
            __IO uint32_t  FS                             :  1;
            __IO uint32_t  FSOS                           :  2;
        } SSPCR2_bits;
    };

    union {
        __I  uint32_t  SSPStatus;

        struct {
            __I  uint32_t  RFF                            :  1;
            __I  uint32_t  TFNF                           :  1;
            __I  uint32_t  BUSY                           :  1;
                 uint32_t                                 :  1;
            __I  uint32_t  RFVE                           :  6;
                 uint32_t                                 :  2;
            __I  uint32_t  TFVE                           :  6;
        } SSPStatus_bits;
    };

    union {
        __IO uint32_t  IntrCR;

        struct {
            __IO uint32_t  RFORIEN                        :  1;
            __IO uint32_t  TFURIEN                        :  1;
            __IO uint32_t  RFTHIEN                        :  1;
            __IO uint32_t  TFTHIEN                        :  1;
            __IO uint32_t  RFDMAEN                        :  1;
            __IO uint32_t  TFDMAEN                        :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  RFTHOD                         :  5;
            __IO uint32_t  TFTHOD                         :  5;
        } IntrCR_bits;
    };

    union {
        __I  uint32_t  IntrStatus;

        struct {
            __I  uint32_t  RFORI                          :  1;
            __I  uint32_t  TFURI                          :  1;
            __I  uint32_t  RFTHI                          :  1;
            __I  uint32_t  TFTHI                          :  1;
        } IntrStatus_bits;
    };

    union {
        __IO uint32_t  TxRxDR;
    };

    __I  uint32_t  RESERVED1[2];

    union {
        __IO uint32_t  SPDIFStatus0;

        struct {
            __IO uint32_t  STUS0                          :  8;
            __IO uint32_t  STUS1                          :  8;
            __IO uint32_t  STUS2                          :  8;
            __IO uint32_t  STUS3                          :  8;
        } SPDIFStatus0_bits;
    };

    union {
        __IO uint32_t  SPDIFStatus1;

        struct {
            __IO uint32_t  STUS4                          :  8;
        } SPDIFStatus1_bits;
    };

    union {
        __IO uint32_t  SPDIFUser0;
    };

    union {
        __IO uint32_t  SPDIFUser1;
    };

    union {
        __IO uint32_t  SPDIFUser2;
    };

    union {
        __IO uint32_t  SPDIFUser3;
    };

    union {
        __IO uint32_t  SPDIFUser4;
    };

    union {
        __IO uint32_t  SPDIFUser5;
    };

    union {
        __IO uint32_t  SPDIFUser6;
    };

    union {
        __IO uint32_t  SPDIFUser7;
    };

    union {
        __IO uint32_t  SPDIFUser8;
    };

    union {
        __IO uint32_t  SPDIFUser9;
    };

    union {
        __IO uint32_t  SPDIFUser10;
    };

    union {
        __IO uint32_t  SPDIFUser11;
    };

    __I  uint32_t  RESERVED2[1];

    union {
        __I  uint32_t  SSPRevision;

        struct {
            __I  uint32_t  REL_REV                        :  8;
            __I  uint32_t  MINOR_REV                      :  8;
            __I  uint32_t  MAJOR_REV                      :  8;
        } SSPRevision_bits;
    };

    union {
        __I  uint32_t  SSPFeature;

        struct {
            __I  uint32_t  FIFO_WIDTH                     :  8;
            __I  uint32_t  RXFIFO_DEPTH                   :  8;
            __I  uint32_t  TXFIFO_DEPTH                   :  8;
                 uint32_t                                 :  1;
            __I  uint32_t  I2S_FCFG                       :  1;
            __I  uint32_t  SPIMWR_FCFG                    :  1;
            __I  uint32_t  SSP_FCFG                       :  1;
            __I  uint32_t  SPDIF_FCFG                     :  1;
            __I  uint32_t  EXT_FSNUM                      :  2;
        } SSPFeature_bits;
    };

/* DOM-IGNORE-END */
}AG903_SSPn_Type;

#define AG903_SSPn(ch)                           ((volatile AG903_SSPn_Type *)(AG903_SSP0_BASE + 0x100000 * ch))         /** SSPn Base Address (n=0..3) */
#define AG903_SSPn_SSPCR0(ch)                    AG903_SSPn(ch)->SSPCR0                                                  /** SSPnSSPCR0 Address (n=0..3) */
#define AG903_SSPn_SSPCR1(ch)                    AG903_SSPn(ch)->SSPCR1                                                  /** SSPnSSPCR1 Address (n=0..3) */
#define AG903_SSPn_SSPCR2(ch)                    AG903_SSPn(ch)->SSPCR2                                                  /** SSPnSSPCR2 Address (n=0..3) */
#define AG903_SSPn_SSPStatus(ch)                 AG903_SSPn(ch)->SSPStatus                                               /** SSPnSSPStatus Address (n=0..3) */
#define AG903_SSPn_IntrCR(ch)                    AG903_SSPn(ch)->IntrCR                                                  /** SSPnIntrCR Address (n=0..3) */
#define AG903_SSPn_IntrStatus(ch)                AG903_SSPn(ch)->IntrStatus                                              /** SSPnIntrStatus Address (n=0..3) */
#define AG903_SSPn_TxRxDR(ch)                    AG903_SSPn(ch)->TxRxDR                                                  /** SSPnTxRxDR Address (n=0..3) */
#define AG903_SSPn_SPDIFStatus0(ch)              AG903_SSPn(ch)->SPDIFStatus0                                            /** SSPnSPDIFStatus0 Address (n=0..3) */
#define AG903_SSPn_SPDIFStatus1(ch)              AG903_SSPn(ch)->SPDIFStatus1                                            /** SSPnSPDIFStatus1 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser0(ch)                AG903_SSPn(ch)->SPDIFUser0                                              /** SSPnSPDIFUser0 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser1(ch)                AG903_SSPn(ch)->SPDIFUser1                                              /** SSPnSPDIFUser1 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser2(ch)                AG903_SSPn(ch)->SPDIFUser2                                              /** SSPnSPDIFUser2 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser3(ch)                AG903_SSPn(ch)->SPDIFUser3                                              /** SSPnSPDIFUser3 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser4(ch)                AG903_SSPn(ch)->SPDIFUser4                                              /** SSPnSPDIFUser4 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser5(ch)                AG903_SSPn(ch)->SPDIFUser5                                              /** SSPnSPDIFUser5 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser6(ch)                AG903_SSPn(ch)->SPDIFUser6                                              /** SSPnSPDIFUser6 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser7(ch)                AG903_SSPn(ch)->SPDIFUser7                                              /** SSPnSPDIFUser7 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser8(ch)                AG903_SSPn(ch)->SPDIFUser8                                              /** SSPnSPDIFUser8 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser9(ch)                AG903_SSPn(ch)->SPDIFUser9                                              /** SSPnSPDIFUser9 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser10(ch)               AG903_SSPn(ch)->SPDIFUser10                                             /** SSPnSPDIFUser10 Address (n=0..3) */
#define AG903_SSPn_SPDIFUser11(ch)               AG903_SSPn(ch)->SPDIFUser11                                             /** SSPnSPDIFUser11 Address (n=0..3) */
#define AG903_SSPn_SSPRevision(ch)               AG903_SSPn(ch)->SSPRevision                                             /** SSPnSSPRevision Address (n=0..3) */
#define AG903_SSPn_SSPFeature(ch)                AG903_SSPn(ch)->SSPFeature                                              /** SSPnSSPFeature Address (n=0..3) */

#define AG903_SSP0                               ((volatile AG903_SSPn_Type *) AG903_SSP0_BASE)                          /** SSPn Base Address */
#define AG903_SSP1                               ((volatile AG903_SSPn_Type *) AG903_SSP1_BASE)                          /** SSPn Base Address */
#define AG903_SSP2                               ((volatile AG903_SSPn_Type *) AG903_SSP2_BASE)                          /** SSPn Base Address */
#define AG903_SSP3                               ((volatile AG903_SSPn_Type *) AG903_SSP3_BASE)                          /** SSPn Base Address */


#define AG903_SSPn_SSPCR0_SCLKPH_POS                       0                                                             /** SSPnSSPCR0 SCLKPH-bit position */
#define AG903_SSPn_SSPCR0_SCLKPH_MSK                       (0x1UL << AG903_SSPn_SSPCR0_SCLKPH_POS)                       /** SSPnSSPCR0 SCLKPH-bit mask */
#define AG903_SSPn_SSPCR0_SCLKPO_POS                       1                                                             /** SSPnSSPCR0 SCLKPO-bit position */
#define AG903_SSPn_SSPCR0_SCLKPO_MSK                       (0x1UL << AG903_SSPn_SSPCR0_SCLKPO_POS)                       /** SSPnSSPCR0 SCLKPO-bit mask */
#define AG903_SSPn_SSPCR0_OPM_POS                          2                                                             /** SSPnSSPCR0 OPM-bit position */
#define AG903_SSPn_SSPCR0_OPM_MSK                          (0x3UL << AG903_SSPn_SSPCR0_OPM_POS)                          /** SSPnSSPCR0 OPM-bit mask */
#define AG903_SSPn_SSPCR0_FSJSTFY_POS                      4                                                             /** SSPnSSPCR0 FSJSTFY-bit position */
#define AG903_SSPn_SSPCR0_FSJSTFY_MSK                      (0x1UL << AG903_SSPn_SSPCR0_FSJSTFY_POS)                      /** SSPnSSPCR0 FSJSTFY-bit mask */
#define AG903_SSPn_SSPCR0_FSPO_POS                         5                                                             /** SSPnSSPCR0 FSPO-bit position */
#define AG903_SSPn_SSPCR0_FSPO_MSK                         (0x1UL << AG903_SSPn_SSPCR0_FSPO_POS)                         /** SSPnSSPCR0 FSPO-bit mask */
#define AG903_SSPn_SSPCR0_LSB_POS                          6                                                             /** SSPnSSPCR0 LSB-bit position */
#define AG903_SSPn_SSPCR0_LSB_MSK                          (0x1UL << AG903_SSPn_SSPCR0_LSB_POS)                          /** SSPnSSPCR0 LSB-bit mask */
#define AG903_SSPn_SSPCR0_LBM_POS                          7                                                             /** SSPnSSPCR0 LBM-bit position */
#define AG903_SSPn_SSPCR0_LBM_MSK                          (0x1UL << AG903_SSPn_SSPCR0_LBM_POS)                          /** SSPnSSPCR0 LBM-bit mask */
#define AG903_SSPn_SSPCR0_FSDIST_POS                       8                                                             /** SSPnSSPCR0 FSDIST-bit position */
#define AG903_SSPn_SSPCR0_FSDIST_MSK                       (0x3UL << AG903_SSPn_SSPCR0_FSDIST_POS)                       /** SSPnSSPCR0 FSDIST-bit mask */
#define AG903_SSPn_SSPCR0_Validity_POS                     10                                                            /** SSPnSSPCR0 Validity-bit position */
#define AG903_SSPn_SSPCR0_Validity_MSK                     (0x1UL << AG903_SSPn_SSPCR0_Validity_POS)                     /** SSPnSSPCR0 Validity-bit mask */
#define AG903_SSPn_SSPCR0_FLASH_POS                        11                                                            /** SSPnSSPCR0 FLASH-bit position */
#define AG903_SSPn_SSPCR0_FLASH_MSK                        (0x1UL << AG903_SSPn_SSPCR0_FLASH_POS)                        /** SSPnSSPCR0 FLASH-bit mask */
#define AG903_SSPn_SSPCR0_FFMT_POS                         12                                                            /** SSPnSSPCR0 FFMT-bit position */
#define AG903_SSPn_SSPCR0_FFMT_MSK                         (0x7UL << AG903_SSPn_SSPCR0_FFMT_POS)                         /** SSPnSSPCR0 FFMT-bit mask */
#define AG903_SSPn_SSPCR0_SPIFSPO_POS                      15                                                            /** SSPnSSPCR0 SPIFSPO-bit position */
#define AG903_SSPn_SSPCR0_SPIFSPO_MSK                      (0x1UL << AG903_SSPn_SSPCR0_SPIFSPO_POS)                      /** SSPnSSPCR0 SPIFSPO-bit mask */
#define AG903_SSPn_SSPCR0_SCLKFDBK_POS                     16                                                            /** SSPnSSPCR0 SCLKFDBK-bit position */
#define AG903_SSPn_SSPCR0_SCLKFDBK_MSK                     (0x1UL << AG903_SSPn_SSPCR0_SCLKFDBK_POS)                     /** SSPnSSPCR0 SCLKFDBK-bit mask */
#define AG903_SSPn_SSPCR0_FSFDBK_POS                       17                                                            /** SSPnSSPCR0 FSFDBK-bit position */
#define AG903_SSPn_SSPCR0_FSFDBK_MSK                       (0x1UL << AG903_SSPn_SSPCR0_FSFDBK_POS)                       /** SSPnSSPCR0 FSFDBK-bit mask */

#define AG903_SSPn_SSPCR1_SCLKDIV_POS                      0                                                             /** SSPnSSPCR1 SCLKDIV-bit position */
#define AG903_SSPn_SSPCR1_SCLKDIV_MSK                      (0xffffUL << AG903_SSPn_SSPCR1_SCLKDIV_POS)                   /** SSPnSSPCR1 SCLKDIV-bit mask */
#define AG903_SSPn_SSPCR1_SDL_POS                          16                                                            /** SSPnSSPCR1 SDL-bit position */
#define AG903_SSPn_SSPCR1_SDL_MSK                          (0x7fUL << AG903_SSPn_SSPCR1_SDL_POS)                         /** SSPnSSPCR1 SDL-bit mask */
#define AG903_SSPn_SSPCR1_PDL_POS                          24                                                            /** SSPnSSPCR1 PDL-bit position */
#define AG903_SSPn_SSPCR1_PDL_MSK                          (0xffUL << AG903_SSPn_SSPCR1_PDL_POS)                         /** SSPnSSPCR1 PDL-bit mask */

#define AG903_SSPn_SSPCR2_SSPEN_POS                        0                                                             /** SSPnSSPCR2 SSPEN-bit position */
#define AG903_SSPn_SSPCR2_SSPEN_MSK                        (0x1UL << AG903_SSPn_SSPCR2_SSPEN_POS)                        /** SSPnSSPCR2 SSPEN-bit mask */
#define AG903_SSPn_SSPCR2_TXDOE_POS                        1                                                             /** SSPnSSPCR2 TXDOE-bit position */
#define AG903_SSPn_SSPCR2_TXDOE_MSK                        (0x1UL << AG903_SSPn_SSPCR2_TXDOE_POS)                        /** SSPnSSPCR2 TXDOE-bit mask */
#define AG903_SSPn_SSPCR2_RXFCLR_POS                       2                                                             /** SSPnSSPCR2 RXFCLR-bit position */
#define AG903_SSPn_SSPCR2_RXFCLR_MSK                       (0x1UL << AG903_SSPn_SSPCR2_RXFCLR_POS)                       /** SSPnSSPCR2 RXFCLR-bit mask */
#define AG903_SSPn_SSPCR2_TXFCLR_POS                       3                                                             /** SSPnSSPCR2 TXFCLR-bit position */
#define AG903_SSPn_SSPCR2_TXFCLR_MSK                       (0x1UL << AG903_SSPn_SSPCR2_TXFCLR_POS)                       /** SSPnSSPCR2 TXFCLR-bit mask */
#define AG903_SSPn_SSPCR2_SSPRST_POS                       6                                                             /** SSPnSSPCR2 SSPRST-bit position */
#define AG903_SSPn_SSPCR2_SSPRST_MSK                       (0x1UL << AG903_SSPn_SSPCR2_SSPRST_POS)                       /** SSPnSSPCR2 SSPRST-bit mask */
#define AG903_SSPn_SSPCR2_RXEN_POS                         7                                                             /** SSPnSSPCR2 RXEN-bit position */
#define AG903_SSPn_SSPCR2_RXEN_MSK                         (0x1UL << AG903_SSPn_SSPCR2_RXEN_POS)                         /** SSPnSSPCR2 RXEN-bit mask */
#define AG903_SSPn_SSPCR2_TXEN_POS                         8                                                             /** SSPnSSPCR2 TXEN-bit position */
#define AG903_SSPn_SSPCR2_TXEN_MSK                         (0x1UL << AG903_SSPn_SSPCR2_TXEN_POS)                         /** SSPnSSPCR2 TXEN-bit mask */
#define AG903_SSPn_SSPCR2_FS_POS                           9                                                             /** SSPnSSPCR2 FS-bit position */
#define AG903_SSPn_SSPCR2_FS_MSK                           (0x1UL << AG903_SSPn_SSPCR2_FS_POS)                           /** SSPnSSPCR2 FS-bit mask */
#define AG903_SSPn_SSPCR2_FSOS_POS                         10                                                            /** SSPnSSPCR2 FSOS-bit position */
#define AG903_SSPn_SSPCR2_FSOS_MSK                         (0x3UL << AG903_SSPn_SSPCR2_FSOS_POS)                         /** SSPnSSPCR2 FSOS-bit mask */

#define AG903_SSPn_SSPStatus_RFF_POS                       0                                                             /** SSPnSSPStatus RFF-bit position */
#define AG903_SSPn_SSPStatus_RFF_MSK                       (0x1UL << AG903_SSPn_SSPStatus_RFF_POS)                       /** SSPnSSPStatus RFF-bit mask */
#define AG903_SSPn_SSPStatus_TFNF_POS                      1                                                             /** SSPnSSPStatus TFNF-bit position */
#define AG903_SSPn_SSPStatus_TFNF_MSK                      (0x1UL << AG903_SSPn_SSPStatus_TFNF_POS)                      /** SSPnSSPStatus TFNF-bit mask */
#define AG903_SSPn_SSPStatus_BUSY_POS                      2                                                             /** SSPnSSPStatus BUSY-bit position */
#define AG903_SSPn_SSPStatus_BUSY_MSK                      (0x1UL << AG903_SSPn_SSPStatus_BUSY_POS)                      /** SSPnSSPStatus BUSY-bit mask */
#define AG903_SSPn_SSPStatus_RFVE_POS                      4                                                             /** SSPnSSPStatus RFVE-bit position */
#define AG903_SSPn_SSPStatus_RFVE_MSK                      (0x3fUL << AG903_SSPn_SSPStatus_RFVE_POS)                     /** SSPnSSPStatus RFVE-bit mask */
#define AG903_SSPn_SSPStatus_TFVE_POS                      12                                                            /** SSPnSSPStatus TFVE-bit position */
#define AG903_SSPn_SSPStatus_TFVE_MSK                      (0x3fUL << AG903_SSPn_SSPStatus_TFVE_POS)                     /** SSPnSSPStatus TFVE-bit mask */

#define AG903_SSPn_IntrCR_RFORIEN_POS                      0                                                             /** SSPnIntrCR RFORIEN-bit position */
#define AG903_SSPn_IntrCR_RFORIEN_MSK                      (0x1UL << AG903_SSPn_IntrCR_RFORIEN_POS)                      /** SSPnIntrCR RFORIEN-bit mask */
#define AG903_SSPn_IntrCR_TFURIEN_POS                      1                                                             /** SSPnIntrCR TFURIEN-bit position */
#define AG903_SSPn_IntrCR_TFURIEN_MSK                      (0x1UL << AG903_SSPn_IntrCR_TFURIEN_POS)                      /** SSPnIntrCR TFURIEN-bit mask */
#define AG903_SSPn_IntrCR_RFTHIEN_POS                      2                                                             /** SSPnIntrCR RFTHIEN-bit position */
#define AG903_SSPn_IntrCR_RFTHIEN_MSK                      (0x1UL << AG903_SSPn_IntrCR_RFTHIEN_POS)                      /** SSPnIntrCR RFTHIEN-bit mask */
#define AG903_SSPn_IntrCR_TFTHIEN_POS                      3                                                             /** SSPnIntrCR TFTHIEN-bit position */
#define AG903_SSPn_IntrCR_TFTHIEN_MSK                      (0x1UL << AG903_SSPn_IntrCR_TFTHIEN_POS)                      /** SSPnIntrCR TFTHIEN-bit mask */
#define AG903_SSPn_IntrCR_RFDMAEN_POS                      4                                                             /** SSPnIntrCR RFDMAEN-bit position */
#define AG903_SSPn_IntrCR_RFDMAEN_MSK                      (0x1UL << AG903_SSPn_IntrCR_RFDMAEN_POS)                      /** SSPnIntrCR RFDMAEN-bit mask */
#define AG903_SSPn_IntrCR_TFDMAEN_POS                      5                                                             /** SSPnIntrCR TFDMAEN-bit position */
#define AG903_SSPn_IntrCR_TFDMAEN_MSK                      (0x1UL << AG903_SSPn_IntrCR_TFDMAEN_POS)                      /** SSPnIntrCR TFDMAEN-bit mask */
#define AG903_SSPn_IntrCR_RFTHOD_POS                       7                                                             /** SSPnIntrCR RFTHOD-bit position */
#define AG903_SSPn_IntrCR_RFTHOD_MSK                       (0x1fUL << AG903_SSPn_IntrCR_RFTHOD_POS)                      /** SSPnIntrCR RFTHOD-bit mask */
#define AG903_SSPn_IntrCR_TFTHOD_POS                       12                                                            /** SSPnIntrCR TFTHOD-bit position */
#define AG903_SSPn_IntrCR_TFTHOD_MSK                       (0x1fUL << AG903_SSPn_IntrCR_TFTHOD_POS)                      /** SSPnIntrCR TFTHOD-bit mask */

#define AG903_SSPn_IntrStatus_RFORI_POS                    0                                                             /** SSPnIntrStatus RFORI-bit position */
#define AG903_SSPn_IntrStatus_RFORI_MSK                    (0x1UL << AG903_SSPn_IntrStatus_RFORI_POS)                    /** SSPnIntrStatus RFORI-bit mask */
#define AG903_SSPn_IntrStatus_TFURI_POS                    1                                                             /** SSPnIntrStatus TFURI-bit position */
#define AG903_SSPn_IntrStatus_TFURI_MSK                    (0x1UL << AG903_SSPn_IntrStatus_TFURI_POS)                    /** SSPnIntrStatus TFURI-bit mask */
#define AG903_SSPn_IntrStatus_RFTHI_POS                    2                                                             /** SSPnIntrStatus RFTHI-bit position */
#define AG903_SSPn_IntrStatus_RFTHI_MSK                    (0x1UL << AG903_SSPn_IntrStatus_RFTHI_POS)                    /** SSPnIntrStatus RFTHI-bit mask */
#define AG903_SSPn_IntrStatus_TFTHI_POS                    3                                                             /** SSPnIntrStatus TFTHI-bit position */
#define AG903_SSPn_IntrStatus_TFTHI_MSK                    (0x1UL << AG903_SSPn_IntrStatus_TFTHI_POS)                    /** SSPnIntrStatus TFTHI-bit mask */

#define AG903_SSPn_TxRxDR_DATA_POS                         0                                                             /** SSPnTxRxDR DATA-bit position */
#define AG903_SSPn_TxRxDR_DATA_MSK                         (0xffffffffUL << AG903_SSPn_TxRxDR_DATA_POS)                  /** SSPnTxRxDR DATA-bit mask */

#define AG903_SSPn_SPDIFStatus0_STUS0_POS                  0                                                             /** SSPnSPDIFStatus0 STUS0-bit position */
#define AG903_SSPn_SPDIFStatus0_STUS0_MSK                  (0xffUL << AG903_SSPn_SPDIFStatus0_STUS0_POS)                 /** SSPnSPDIFStatus0 STUS0-bit mask */
#define AG903_SSPn_SPDIFStatus0_STUS1_POS                  8                                                             /** SSPnSPDIFStatus0 STUS1-bit position */
#define AG903_SSPn_SPDIFStatus0_STUS1_MSK                  (0xffUL << AG903_SSPn_SPDIFStatus0_STUS1_POS)                 /** SSPnSPDIFStatus0 STUS1-bit mask */
#define AG903_SSPn_SPDIFStatus0_STUS2_POS                  16                                                            /** SSPnSPDIFStatus0 STUS2-bit position */
#define AG903_SSPn_SPDIFStatus0_STUS2_MSK                  (0xffUL << AG903_SSPn_SPDIFStatus0_STUS2_POS)                 /** SSPnSPDIFStatus0 STUS2-bit mask */
#define AG903_SSPn_SPDIFStatus0_STUS3_POS                  24                                                            /** SSPnSPDIFStatus0 STUS3-bit position */
#define AG903_SSPn_SPDIFStatus0_STUS3_MSK                  (0xffUL << AG903_SSPn_SPDIFStatus0_STUS3_POS)                 /** SSPnSPDIFStatus0 STUS3-bit mask */

#define AG903_SSPn_SPDIFStatus1_STUS4_POS                  0                                                             /** SSPnSPDIFStatus1 STUS4-bit position */
#define AG903_SSPn_SPDIFStatus1_STUS4_MSK                  (0xffUL << AG903_SSPn_SPDIFStatus1_STUS4_POS)                 /** SSPnSPDIFStatus1 STUS4-bit mask */

#define AG903_SSPn_SPDIFUser0_USER0_POS                    0                                                             /** SSPnSPDIFUser0 USER0-bit position */
#define AG903_SSPn_SPDIFUser0_USER0_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser0_USER0_POS)             /** SSPnSPDIFUser0 USER0-bit mask */

#define AG903_SSPn_SPDIFUser1_USER1_POS                    0                                                             /** SSPnSPDIFUser1 USER1-bit position */
#define AG903_SSPn_SPDIFUser1_USER1_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser1_USER1_POS)             /** SSPnSPDIFUser1 USER1-bit mask */

#define AG903_SSPn_SPDIFUser2_USER2_POS                    0                                                             /** SSPnSPDIFUser2 USER2-bit position */
#define AG903_SSPn_SPDIFUser2_USER2_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser2_USER2_POS)             /** SSPnSPDIFUser2 USER2-bit mask */

#define AG903_SSPn_SPDIFUser3_USER3_POS                    0                                                             /** SSPnSPDIFUser3 USER3-bit position */
#define AG903_SSPn_SPDIFUser3_USER3_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser3_USER3_POS)             /** SSPnSPDIFUser3 USER3-bit mask */

#define AG903_SSPn_SPDIFUser4_USER4_POS                    0                                                             /** SSPnSPDIFUser4 USER4-bit position */
#define AG903_SSPn_SPDIFUser4_USER4_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser4_USER4_POS)             /** SSPnSPDIFUser4 USER4-bit mask */

#define AG903_SSPn_SPDIFUser5_USER5_POS                    0                                                             /** SSPnSPDIFUser5 USER5-bit position */
#define AG903_SSPn_SPDIFUser5_USER5_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser5_USER5_POS)             /** SSPnSPDIFUser5 USER5-bit mask */

#define AG903_SSPn_SPDIFUser6_USER6_POS                    0                                                             /** SSPnSPDIFUser6 USER6-bit position */
#define AG903_SSPn_SPDIFUser6_USER6_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser6_USER6_POS)             /** SSPnSPDIFUser6 USER6-bit mask */

#define AG903_SSPn_SPDIFUser7_USER7_POS                    0                                                             /** SSPnSPDIFUser7 USER7-bit position */
#define AG903_SSPn_SPDIFUser7_USER7_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser7_USER7_POS)             /** SSPnSPDIFUser7 USER7-bit mask */

#define AG903_SSPn_SPDIFUser8_USER8_POS                    0                                                             /** SSPnSPDIFUser8 USER8-bit position */
#define AG903_SSPn_SPDIFUser8_USER8_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser8_USER8_POS)             /** SSPnSPDIFUser8 USER8-bit mask */

#define AG903_SSPn_SPDIFUser9_USER9_POS                    0                                                             /** SSPnSPDIFUser9 USER9-bit position */
#define AG903_SSPn_SPDIFUser9_USER9_MSK                    (0xffffffffUL << AG903_SSPn_SPDIFUser9_USER9_POS)             /** SSPnSPDIFUser9 USER9-bit mask */

#define AG903_SSPn_SPDIFUser10_USER10_POS                  0                                                             /** SSPnSPDIFUser10 USER10-bit position */
#define AG903_SSPn_SPDIFUser10_USER10_MSK                  (0xffffffffUL << AG903_SSPn_SPDIFUser10_USER10_POS)           /** SSPnSPDIFUser10 USER10-bit mask */

#define AG903_SSPn_SPDIFUser11_USER11_POS                  0                                                             /** SSPnSPDIFUser11 USER11-bit position */
#define AG903_SSPn_SPDIFUser11_USER11_MSK                  (0xffffffffUL << AG903_SSPn_SPDIFUser11_USER11_POS)           /** SSPnSPDIFUser11 USER11-bit mask */

#define AG903_SSPn_SSPRevision_REL_REV_POS                 0                                                             /** SSPnSSPRevision REL_REV-bit position */
#define AG903_SSPn_SSPRevision_REL_REV_MSK                 (0xffUL << AG903_SSPn_SSPRevision_REL_REV_POS)                /** SSPnSSPRevision REL_REV-bit mask */
#define AG903_SSPn_SSPRevision_MINOR_REV_POS               8                                                             /** SSPnSSPRevision MINOR_REV-bit position */
#define AG903_SSPn_SSPRevision_MINOR_REV_MSK               (0xffUL << AG903_SSPn_SSPRevision_MINOR_REV_POS)              /** SSPnSSPRevision MINOR_REV-bit mask */
#define AG903_SSPn_SSPRevision_MAJOR_REV_POS               16                                                            /** SSPnSSPRevision MAJOR_REV-bit position */
#define AG903_SSPn_SSPRevision_MAJOR_REV_MSK               (0xffUL << AG903_SSPn_SSPRevision_MAJOR_REV_POS)              /** SSPnSSPRevision MAJOR_REV-bit mask */

#define AG903_SSPn_SSPFeature_FIFO_WIDTH_POS               0                                                             /** SSPnSSPFeature FIFO_WIDTH-bit position */
#define AG903_SSPn_SSPFeature_FIFO_WIDTH_MSK               (0xffUL << AG903_SSPn_SSPFeature_FIFO_WIDTH_POS)              /** SSPnSSPFeature FIFO_WIDTH-bit mask */
#define AG903_SSPn_SSPFeature_RXFIFO_DEPTH_POS             8                                                             /** SSPnSSPFeature RXFIFO_DEPTH-bit position */
#define AG903_SSPn_SSPFeature_RXFIFO_DEPTH_MSK             (0xffUL << AG903_SSPn_SSPFeature_RXFIFO_DEPTH_POS)            /** SSPnSSPFeature RXFIFO_DEPTH-bit mask */
#define AG903_SSPn_SSPFeature_TXFIFO_DEPTH_POS             16                                                            /** SSPnSSPFeature TXFIFO_DEPTH-bit position */
#define AG903_SSPn_SSPFeature_TXFIFO_DEPTH_MSK             (0xffUL << AG903_SSPn_SSPFeature_TXFIFO_DEPTH_POS)            /** SSPnSSPFeature TXFIFO_DEPTH-bit mask */
#define AG903_SSPn_SSPFeature_I2S_FCFG_POS                 25                                                            /** SSPnSSPFeature I2S_FCFG-bit position */
#define AG903_SSPn_SSPFeature_I2S_FCFG_MSK                 (0x1UL << AG903_SSPn_SSPFeature_I2S_FCFG_POS)                 /** SSPnSSPFeature I2S_FCFG-bit mask */
#define AG903_SSPn_SSPFeature_SPIMWR_FCFG_POS              26                                                            /** SSPnSSPFeature SPIMWR_FCFG-bit position */
#define AG903_SSPn_SSPFeature_SPIMWR_FCFG_MSK              (0x1UL << AG903_SSPn_SSPFeature_SPIMWR_FCFG_POS)              /** SSPnSSPFeature SPIMWR_FCFG-bit mask */
#define AG903_SSPn_SSPFeature_SSP_FCFG_POS                 27                                                            /** SSPnSSPFeature SSP_FCFG-bit position */
#define AG903_SSPn_SSPFeature_SSP_FCFG_MSK                 (0x1UL << AG903_SSPn_SSPFeature_SSP_FCFG_POS)                 /** SSPnSSPFeature SSP_FCFG-bit mask */
#define AG903_SSPn_SSPFeature_SPDIF_FCFG_POS               28                                                            /** SSPnSSPFeature SPDIF_FCFG-bit position */
#define AG903_SSPn_SSPFeature_SPDIF_FCFG_MSK               (0x1UL << AG903_SSPn_SSPFeature_SPDIF_FCFG_POS)               /** SSPnSSPFeature SPDIF_FCFG-bit mask */
#define AG903_SSPn_SSPFeature_EXT_FSNUM_POS                29                                                            /** SSPnSSPFeature EXT_FSNUM-bit position */
#define AG903_SSPn_SSPFeature_EXT_FSNUM_MSK                (0x3UL << AG903_SSPn_SSPFeature_EXT_FSNUM_POS)                /** SSPnSSPFeature EXT_FSNUM-bit mask */

#endif /* _AG903_SSP_REGMAP_H_ */

