/**
 * @brief           DTA Register Definition
 * @author          AXELL CORPORATION
 * @description     DTA Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_DTA_REGMAP_H_
#define _AG903_DTA_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** DTA Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __O  uint32_t  EXEC;

        struct {
            __O  uint32_t  EN                             :  1;
        } EXEC_bits;
    };

    union {
        __I  uint32_t  STAT;

        struct {
            __I  uint32_t  BSY                            :  2;
        } STAT_bits;
    };

    union {
        __IO uint32_t  MODE;

        struct {
            __IO uint32_t  DEC                            :  1;
            __IO uint32_t  D2                             :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  DPMD                           :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  SSWP                           :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  DSWP                           :  3;
        } MODE_bits;
    };

    __I  uint32_t  RESERVED1[1];

    union {
        __I  uint32_t  INTS;

        struct {
            __I  uint32_t  STA                            :  5;
        } INTS_bits;
    };

    union {
        __O  uint32_t  INTC;

        struct {
            __O  uint32_t  CLR                            :  5;
        } INTC_bits;
    };

    union {
        __IO uint32_t  INTM;

        struct {
            __IO uint32_t  MSK                            :  5;
        } INTM_bits;
    };

    __I  uint32_t  RESERVED2[1];

    union {
        __IO uint32_t  SRCA;
    };

    union {
        __IO uint32_t  SRCS;

        struct {
            __IO uint32_t  STR                            : 16;
        } SRCS_bits;
    };

    union {
        __IO uint32_t  DSTA;
    };

    union {
        __IO uint32_t  DSTS;

        struct {
            __IO uint32_t  STR                            : 16;
        } DSTS_bits;
    };

    union {
        __IO uint32_t  SIZ1;

        struct {
            __IO uint32_t  SIZ                            : 26;
        } SIZ1_bits;
    };

    union {
        __IO uint32_t  SIZ2;

        struct {
            __IO uint32_t  HSIZ                           : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  VSIZ                           : 12;
        } SIZ2_bits;
    };

    __I  uint32_t  RESERVED3[2];

    union {
        __IO uint32_t  DPORT;
    };

    union {
        __I  uint32_t  DPSTA;

        struct {
            __I  uint32_t  AVAI                           :  6;
        } DPSTA_bits;
    };

    union {
        __I  uint32_t  SRCM;
    };

    union {
        __I  uint32_t  DSTM;
    };

/* DOM-IGNORE-END */
}AG903_DTA_Type;

#define AG903_DTA                                ((volatile AG903_DTA_Type *) AG903_DTA_BASE)                            /** DTA Base Address */


#define AG903_DTA_EXEC_EN_POS                              0                                                             /** DTAEXEC EN-bit position */
#define AG903_DTA_EXEC_EN_MSK                              (0x1UL << AG903_DTA_EXEC_EN_POS)                              /** DTAEXEC EN-bit mask */

#define AG903_DTA_STAT_BSY_POS                             0                                                             /** DTASTAT BSY-bit position */
#define AG903_DTA_STAT_BSY_MSK                             (0x3UL << AG903_DTA_STAT_BSY_POS)                             /** DTASTAT BSY-bit mask */

#define AG903_DTA_MODE_DEC_POS                             0                                                             /** DTAMODE DEC-bit position */
#define AG903_DTA_MODE_DEC_MSK                             (0x1UL << AG903_DTA_MODE_DEC_POS)                             /** DTAMODE DEC-bit mask */
#define AG903_DTA_MODE_D2_POS                              1                                                             /** DTAMODE D2-bit position */
#define AG903_DTA_MODE_D2_MSK                              (0x1UL << AG903_DTA_MODE_D2_POS)                              /** DTAMODE D2-bit mask */
#define AG903_DTA_MODE_DPMD_POS                            8                                                             /** DTAMODE DPMD-bit position */
#define AG903_DTA_MODE_DPMD_MSK                            (0x3UL << AG903_DTA_MODE_DPMD_POS)                            /** DTAMODE DPMD-bit mask */
#define AG903_DTA_MODE_SSWP_POS                            16                                                            /** DTAMODE SSWP-bit position */
#define AG903_DTA_MODE_SSWP_MSK                            (0x3UL << AG903_DTA_MODE_SSWP_POS)                            /** DTAMODE SSWP-bit mask */
#define AG903_DTA_MODE_DSWP_POS                            24                                                            /** DTAMODE DSWP-bit position */
#define AG903_DTA_MODE_DSWP_MSK                            (0x7UL << AG903_DTA_MODE_DSWP_POS)                            /** DTAMODE DSWP-bit mask */

#define AG903_DTA_INTS_STA_POS                             0                                                             /** DTAINTS STA-bit position */
#define AG903_DTA_INTS_STA_MSK                             (0x1fUL << AG903_DTA_INTS_STA_POS)                            /** DTAINTS STA-bit mask */

#define AG903_DTA_INTC_CLR_POS                             0                                                             /** DTAINTC CLR-bit position */
#define AG903_DTA_INTC_CLR_MSK                             (0x1fUL << AG903_DTA_INTC_CLR_POS)                            /** DTAINTC CLR-bit mask */

#define AG903_DTA_INTM_MSK_POS                             0                                                             /** DTAINTM MSK-bit position */
#define AG903_DTA_INTM_MSK_MSK                             (0x1fUL << AG903_DTA_INTM_MSK_POS)                            /** DTAINTM MSK-bit mask */

#define AG903_DTA_SRCA_ADR_POS                             0                                                             /** DTASRCA ADR-bit position */
#define AG903_DTA_SRCA_ADR_MSK                             (0xffffffffUL << AG903_DTA_SRCA_ADR_POS)                      /** DTASRCA ADR-bit mask */

#define AG903_DTA_SRCS_STR_POS                             0                                                             /** DTASRCS STR-bit position */
#define AG903_DTA_SRCS_STR_MSK                             (0xffffUL << AG903_DTA_SRCS_STR_POS)                          /** DTASRCS STR-bit mask */

#define AG903_DTA_DSTA_ADR_POS                             0                                                             /** DTADSTA ADR-bit position */
#define AG903_DTA_DSTA_ADR_MSK                             (0xffffffffUL << AG903_DTA_DSTA_ADR_POS)                      /** DTADSTA ADR-bit mask */

#define AG903_DTA_DSTS_STR_POS                             0                                                             /** DTADSTS STR-bit position */
#define AG903_DTA_DSTS_STR_MSK                             (0xffffUL << AG903_DTA_DSTS_STR_POS)                          /** DTADSTS STR-bit mask */

#define AG903_DTA_SIZ1_SIZ_POS                             0                                                             /** DTASIZ1 SIZ-bit position */
#define AG903_DTA_SIZ1_SIZ_MSK                             (0x3ffffffUL << AG903_DTA_SIZ1_SIZ_POS)                       /** DTASIZ1 SIZ-bit mask */

#define AG903_DTA_SIZ2_HSIZ_POS                            0                                                             /** DTASIZ2 HSIZ-bit position */
#define AG903_DTA_SIZ2_HSIZ_MSK                            (0xfffUL << AG903_DTA_SIZ2_HSIZ_POS)                          /** DTASIZ2 HSIZ-bit mask */
#define AG903_DTA_SIZ2_VSIZ_POS                            16                                                            /** DTASIZ2 VSIZ-bit position */
#define AG903_DTA_SIZ2_VSIZ_MSK                            (0xfffUL << AG903_DTA_SIZ2_VSIZ_POS)                          /** DTASIZ2 VSIZ-bit mask */

#define AG903_DTA_DPORT_DAT_POS                            0                                                             /** DTADPORT DAT-bit position */
#define AG903_DTA_DPORT_DAT_MSK                            (0xffffffffUL << AG903_DTA_DPORT_DAT_POS)                     /** DTADPORT DAT-bit mask */

#define AG903_DTA_DPSTA_AVAI_POS                           0                                                             /** DTADPSTA AVAI-bit position */
#define AG903_DTA_DPSTA_AVAI_MSK                           (0x3fUL << AG903_DTA_DPSTA_AVAI_POS)                          /** DTADPSTA AVAI-bit mask */

#define AG903_DTA_SRCM_ADR_POS                             0                                                             /** DTASRCM ADR-bit position */
#define AG903_DTA_SRCM_ADR_MSK                             (0xffffffffUL << AG903_DTA_SRCM_ADR_POS)                      /** DTASRCM ADR-bit mask */

#define AG903_DTA_DSTM_ADR_POS                             0                                                             /** DTADSTM ADR-bit position */
#define AG903_DTA_DSTM_ADR_MSK                             (0xffffffffUL << AG903_DTA_DSTM_ADR_POS)                      /** DTADSTM ADR-bit mask */

#endif /* _AG903_DTA_REGMAP_H_ */

