/**
 * @brief           USBH CDC Common Header
 * @author          AXELL CORPORATION
 * @description     USBH CDC Common Header
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */



#ifndef __USB_CDC_COMMON_H__
#define __USB_CDC_COMMON_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_cdc_coreinclude.h"
#include "usb_cdc_type.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
/* Pipe ֘A */
extern PCDC_PIPE Usbh_Cdc_CreateCdcPipe(struct usbd_usb_deviceinfo *pParentDev, uhs_ubit8_t u8EpNum, uhs_ubit8_t u8EpDir, uhs_ubit8_t u8EpType, uhs_ubit8_t u8Interval );
extern uhs_boolean_t Usbh_Cdc_DeleteCdcPipe(PCDC_PIPE pPipe);
extern uhs_boolean_t Usbh_Cdc_OpenCdcPipe(PCDC_PIPE pPipe);
extern uhs_boolean_t Usbh_Cdc_CloseCdcPipe(PCDC_PIPE pPipe);
extern CDC_FUNC_STATUS Usbh_Cdc_CdcPipe_ClearHalt(PCDC_PIPE pPipe, PCDC_DEVICE pCdcDevice);
extern uhs_boolean_t Usbh_Cdc_CdcDevice_GetPipeInfo( struct usbd_usb_deviceinfo* usbdev, udi_ubit8_t TransferType, uhs_ubit8_t * out_epnum, uhs_ubit8_t * in_epnum ,uhs_ubit8_t * out_interval, uhs_ubit8_t * in_interval);

extern PCDC_DEVICE Usbh_Cdc_SearchCdcDevice(PCDC_DEVICE pContext);
extern CDC_FUNC_STATUS Usbh_Cdc_ForCommand(PCDC_DEVICE pCdcDevice, usb_device_request_t* pdevice_request, uhs_ubit8_t* pBuff, uhs_ubit32_t* pActualLength);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define CMN_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define CMN_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#else
#define CMN_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportDummy(err)
#define CMN_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportDummy(err)
#endif

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_CDC_COMMON_H__ */
