/**
 * @brief           ATA Register Definition
 * @author          AXELL CORPORATION
 * @description     ATA Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_ATA_REGMAP_H_
#define _AG903_ATA_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** ATA Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint32_t  Read_FIFO;
        __O  uint32_t  Write_FIFO;
    };

    union {
        __I  uint32_t  Status_Register;

        struct {
            __I  uint32_t  CSEL                           :  1;
            __I  uint32_t  CSX                            :  2;
            __I  uint32_t  DMACKX                         :  1;
            __I  uint32_t  DMARQ                          :  1;
            __I  uint32_t  INTRQ                          :  1;
            __I  uint32_t  DIORX                          :  1;
            __I  uint32_t  IORDY                          :  1;
            __I  uint32_t  DIOWX                          :  1;
            __I  uint32_t  PDIAG                          :  1;
            __I  uint32_t  DASPX                          :  1;
            __I  uint32_t  DEV                            :  1;
            __I  uint32_t  PIO                            :  1;
            __I  uint32_t  DMA                            :  1;
            __I  uint32_t  WFE                            :  1;
            __I  uint32_t  REF                            :  1;
            __I  uint32_t  Counter                        : 14;
            __I  uint32_t  ERR                            :  1;
            __I  uint32_t  AER                            :  1;
        } Status_Register_bits;

        __O  uint32_t  Command_FIFO;
    };

    union {
        __IO uint32_t  Control_Register;

        struct {
            __IO uint32_t  type0                          :  3;
            __IO uint32_t  IRE0                           :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  E0                             :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  RAFIE                          :  1;
            __IO uint32_t  RNEIE                          :  1;
            __IO uint32_t  WAEIE                          :  1;
            __IO uint32_t  WNFIE                          :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  AERIE                          :  1;
            __IO uint32_t  IIE                            :  1;
            __IO uint32_t  type1                          :  3;
            __IO uint32_t  IRE1                           :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  E1                             :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  DRE                            :  1;
            __IO uint32_t  DTE                            :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  TERIE                          :  1;
            __IO uint32_t  T                              :  1;
            __IO uint32_t  SRST                           :  1;
            __IO uint32_t  RST                            :  1;
        } Control_Register_bits;
    };

    union {
        __IO uint32_t  IRQ_Register;

        struct {
            __IO uint32_t  rxthresh                       : 10;
            __IO uint32_t  RFAFIRQ                        :  1;
            __IO uint32_t  RFNEIRQ                        :  1;
            __IO uint32_t  WFAEIRQ                        :  1;
            __IO uint32_t  WFNFIRQ                        :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  IIRQ                           :  1;
            __IO uint32_t  txthresh                       : 10;
                 uint32_t                                 :  2;
            __IO uint32_t  TERMERR                        :  1;
            __IO uint32_t  AHBERR                         :  1;
        } IRQ_Register_bits;
    };

    union {
        __IO uint32_t  Command_Timing_0;

        struct {
            __IO uint32_t  T1                             :  8;
            __IO uint32_t  T2                             :  8;
            __IO uint32_t  T4                             :  8;
            __IO uint32_t  TEOC                           :  8;
        } Command_Timing_0_bits;
    };

    union {
        __IO uint32_t  Data_Timing_PIO_0;

        struct {
            __IO uint32_t  T1                             :  8;
            __IO uint32_t  T2                             :  8;
            __IO uint32_t  T4                             :  8;
            __IO uint32_t  TEOC                           :  8;
        } Data_Timing_PIO_0_bits;

        __IO uint32_t  Data_Timing_UDMA_0;

        struct {
            __IO uint32_t  TENV                           :  4;
            __IO uint32_t  TMLI                           :  4;
            __IO uint32_t  TCYC                           :  8;
            __IO uint32_t  TACK                           :  4;
            __IO uint32_t  TCVS                           :  4;
            __IO uint32_t  TRP                            :  8;
        } Data_Timing_UDMA_0_bits;
    };

    union {
        __IO uint32_t  Command_Timing_1;

        struct {
            __IO uint32_t  T1                             :  8;
            __IO uint32_t  T2                             :  8;
            __IO uint32_t  T4                             :  8;
            __IO uint32_t  TEOC                           :  8;
        } Command_Timing_1_bits;
    };

    union {
        __IO uint32_t  Data_Timing_PIO_1;

        struct {
            __IO uint32_t  T1                             :  8;
            __IO uint32_t  T2                             :  8;
            __IO uint32_t  T4                             :  8;
            __IO uint32_t  TEOC                           :  8;
        } Data_Timing_PIO_1_bits;

        __IO uint32_t  Data_Timing_UDMA_1;

        struct {
            __IO uint32_t  TENV                           :  4;
            __IO uint32_t  TMLI                           :  4;
            __IO uint32_t  TCYC                           :  8;
            __IO uint32_t  TACK                           :  4;
            __IO uint32_t  TCVS                           :  4;
            __IO uint32_t  TRP                            :  8;
        } Data_Timing_UDMA_1_bits;
    };

    union {
        __IO uint32_t  AHB_Timeout;

        struct {
            __IO uint32_t  WRITE_VALUE                    : 15;
            __IO uint32_t  WRITE_ENABLE                   :  1;
            __IO uint32_t  READ_VALUE                     : 15;
            __IO uint32_t  READ_ENABLE                    :  1;
        } AHB_Timeout_bits;
    };

    __I  uint32_t  RESERVED1[3];

    union {
        __I  uint32_t  Feature_CFIFO;

        struct {
            __I  uint32_t  CFIFO_DEPTH                    :  8;
            __I  uint32_t  CFIFO_WIDTH                    :  8;
        } Feature_CFIFO_bits;
    };

    union {
        __I  uint32_t  Feature_WFIFO;

        struct {
            __I  uint32_t  WFIFO_DEPTH                    :  8;
            __I  uint32_t  WFIFO_WIDTH                    :  8;
        } Feature_WFIFO_bits;
    };

    union {
        __I  uint32_t  Feature_RFIFO;

        struct {
            __I  uint32_t  RFIFO_DEPTH                    :  8;
            __I  uint32_t  RFIFO_WIDTH                    :  8;
        } Feature_RFIFO_bits;
    };

    union {
        __I  uint32_t  Revision;
    };

/* DOM-IGNORE-END */
}AG903_ATA_Type;

#define AG903_ATA                                ((volatile AG903_ATA_Type *) AG903_ATA_BASE)                            /** ATA Base Address */


#define AG903_ATA_Read_FIFO_DATA_POS                       0                                                             /** ATARead_FIFO DATA-bit position */
#define AG903_ATA_Read_FIFO_DATA_MSK                       (0xffffffffUL << AG903_ATA_Read_FIFO_DATA_POS)                /** ATARead_FIFO DATA-bit mask */

#define AG903_ATA_Write_FIFO_DATA_POS                      0                                                             /** ATAWrite_FIFO DATA-bit position */
#define AG903_ATA_Write_FIFO_DATA_MSK                      (0xffffffffUL << AG903_ATA_Write_FIFO_DATA_POS)               /** ATAWrite_FIFO DATA-bit mask */

#define AG903_ATA_Status_Register_CSEL_POS                 0                                                             /** ATAStatus_Register CSEL-bit position */
#define AG903_ATA_Status_Register_CSEL_MSK                 (0x1UL << AG903_ATA_Status_Register_CSEL_POS)                 /** ATAStatus_Register CSEL-bit mask */
#define AG903_ATA_Status_Register_CSX_POS                  1                                                             /** ATAStatus_Register CSX-bit position */
#define AG903_ATA_Status_Register_CSX_MSK                  (0x3UL << AG903_ATA_Status_Register_CSX_POS)                  /** ATAStatus_Register CSX-bit mask */
#define AG903_ATA_Status_Register_DMACKX_POS               3                                                             /** ATAStatus_Register DMACKX-bit position */
#define AG903_ATA_Status_Register_DMACKX_MSK               (0x1UL << AG903_ATA_Status_Register_DMACKX_POS)               /** ATAStatus_Register DMACKX-bit mask */
#define AG903_ATA_Status_Register_DMARQ_POS                4                                                             /** ATAStatus_Register DMARQ-bit position */
#define AG903_ATA_Status_Register_DMARQ_MSK                (0x1UL << AG903_ATA_Status_Register_DMARQ_POS)                /** ATAStatus_Register DMARQ-bit mask */
#define AG903_ATA_Status_Register_INTRQ_POS                5                                                             /** ATAStatus_Register INTRQ-bit position */
#define AG903_ATA_Status_Register_INTRQ_MSK                (0x1UL << AG903_ATA_Status_Register_INTRQ_POS)                /** ATAStatus_Register INTRQ-bit mask */
#define AG903_ATA_Status_Register_DIORX_POS                6                                                             /** ATAStatus_Register DIORX-bit position */
#define AG903_ATA_Status_Register_DIORX_MSK                (0x1UL << AG903_ATA_Status_Register_DIORX_POS)                /** ATAStatus_Register DIORX-bit mask */
#define AG903_ATA_Status_Register_IORDY_POS                7                                                             /** ATAStatus_Register IORDY-bit position */
#define AG903_ATA_Status_Register_IORDY_MSK                (0x1UL << AG903_ATA_Status_Register_IORDY_POS)                /** ATAStatus_Register IORDY-bit mask */
#define AG903_ATA_Status_Register_DIOWX_POS                8                                                             /** ATAStatus_Register DIOWX-bit position */
#define AG903_ATA_Status_Register_DIOWX_MSK                (0x1UL << AG903_ATA_Status_Register_DIOWX_POS)                /** ATAStatus_Register DIOWX-bit mask */
#define AG903_ATA_Status_Register_PDIAG_POS                9                                                             /** ATAStatus_Register PDIAG-bit position */
#define AG903_ATA_Status_Register_PDIAG_MSK                (0x1UL << AG903_ATA_Status_Register_PDIAG_POS)                /** ATAStatus_Register PDIAG-bit mask */
#define AG903_ATA_Status_Register_DASPX_POS                10                                                            /** ATAStatus_Register DASPX-bit position */
#define AG903_ATA_Status_Register_DASPX_MSK                (0x1UL << AG903_ATA_Status_Register_DASPX_POS)                /** ATAStatus_Register DASPX-bit mask */
#define AG903_ATA_Status_Register_DEV_POS                  11                                                            /** ATAStatus_Register DEV-bit position */
#define AG903_ATA_Status_Register_DEV_MSK                  (0x1UL << AG903_ATA_Status_Register_DEV_POS)                  /** ATAStatus_Register DEV-bit mask */
#define AG903_ATA_Status_Register_PIO_POS                  12                                                            /** ATAStatus_Register PIO-bit position */
#define AG903_ATA_Status_Register_PIO_MSK                  (0x1UL << AG903_ATA_Status_Register_PIO_POS)                  /** ATAStatus_Register PIO-bit mask */
#define AG903_ATA_Status_Register_DMA_POS                  13                                                            /** ATAStatus_Register DMA-bit position */
#define AG903_ATA_Status_Register_DMA_MSK                  (0x1UL << AG903_ATA_Status_Register_DMA_POS)                  /** ATAStatus_Register DMA-bit mask */
#define AG903_ATA_Status_Register_WFE_POS                  14                                                            /** ATAStatus_Register WFE-bit position */
#define AG903_ATA_Status_Register_WFE_MSK                  (0x1UL << AG903_ATA_Status_Register_WFE_POS)                  /** ATAStatus_Register WFE-bit mask */
#define AG903_ATA_Status_Register_REF_POS                  15                                                            /** ATAStatus_Register REF-bit position */
#define AG903_ATA_Status_Register_REF_MSK                  (0x1UL << AG903_ATA_Status_Register_REF_POS)                  /** ATAStatus_Register REF-bit mask */
#define AG903_ATA_Status_Register_Counter_POS              16                                                            /** ATAStatus_Register Counter-bit position */
#define AG903_ATA_Status_Register_Counter_MSK              (0x3fffUL << AG903_ATA_Status_Register_Counter_POS)           /** ATAStatus_Register Counter-bit mask */
#define AG903_ATA_Status_Register_ERR_POS                  30                                                            /** ATAStatus_Register ERR-bit position */
#define AG903_ATA_Status_Register_ERR_MSK                  (0x1UL << AG903_ATA_Status_Register_ERR_POS)                  /** ATAStatus_Register ERR-bit mask */
#define AG903_ATA_Status_Register_AER_POS                  31                                                            /** ATAStatus_Register AER-bit position */
#define AG903_ATA_Status_Register_AER_MSK                  (0x1UL << AG903_ATA_Status_Register_AER_POS)                  /** ATAStatus_Register AER-bit mask */

#define AG903_ATA_Command_FIFO_DATA_POS                    0                                                             /** ATACommand_FIFO DATA-bit position */
#define AG903_ATA_Command_FIFO_DATA_MSK                    (0xffffffffUL << AG903_ATA_Command_FIFO_DATA_POS)             /** ATACommand_FIFO DATA-bit mask */

#define AG903_ATA_Control_Register_type0_POS               0                                                             /** ATAControl_Register type0-bit position */
#define AG903_ATA_Control_Register_type0_MSK               (0x7UL << AG903_ATA_Control_Register_type0_POS)               /** ATAControl_Register type0-bit mask */
#define AG903_ATA_Control_Register_IRE0_POS                3                                                             /** ATAControl_Register IRE0-bit position */
#define AG903_ATA_Control_Register_IRE0_MSK                (0x1UL << AG903_ATA_Control_Register_IRE0_POS)                /** ATAControl_Register IRE0-bit mask */
#define AG903_ATA_Control_Register_E0_POS                  5                                                             /** ATAControl_Register E0-bit position */
#define AG903_ATA_Control_Register_E0_MSK                  (0x1UL << AG903_ATA_Control_Register_E0_POS)                  /** ATAControl_Register E0-bit mask */
#define AG903_ATA_Control_Register_RAFIE_POS               9                                                             /** ATAControl_Register RAFIE-bit position */
#define AG903_ATA_Control_Register_RAFIE_MSK               (0x1UL << AG903_ATA_Control_Register_RAFIE_POS)               /** ATAControl_Register RAFIE-bit mask */
#define AG903_ATA_Control_Register_RNEIE_POS               10                                                            /** ATAControl_Register RNEIE-bit position */
#define AG903_ATA_Control_Register_RNEIE_MSK               (0x1UL << AG903_ATA_Control_Register_RNEIE_POS)               /** ATAControl_Register RNEIE-bit mask */
#define AG903_ATA_Control_Register_WAEIE_POS               11                                                            /** ATAControl_Register WAEIE-bit position */
#define AG903_ATA_Control_Register_WAEIE_MSK               (0x1UL << AG903_ATA_Control_Register_WAEIE_POS)               /** ATAControl_Register WAEIE-bit mask */
#define AG903_ATA_Control_Register_WNFIE_POS               12                                                            /** ATAControl_Register WNFIE-bit position */
#define AG903_ATA_Control_Register_WNFIE_MSK               (0x1UL << AG903_ATA_Control_Register_WNFIE_POS)               /** ATAControl_Register WNFIE-bit mask */
#define AG903_ATA_Control_Register_AERIE_POS               14                                                            /** ATAControl_Register AERIE-bit position */
#define AG903_ATA_Control_Register_AERIE_MSK               (0x1UL << AG903_ATA_Control_Register_AERIE_POS)               /** ATAControl_Register AERIE-bit mask */
#define AG903_ATA_Control_Register_IIE_POS                 15                                                            /** ATAControl_Register IIE-bit position */
#define AG903_ATA_Control_Register_IIE_MSK                 (0x1UL << AG903_ATA_Control_Register_IIE_POS)                 /** ATAControl_Register IIE-bit mask */
#define AG903_ATA_Control_Register_type1_POS               16                                                            /** ATAControl_Register type1-bit position */
#define AG903_ATA_Control_Register_type1_MSK               (0x7UL << AG903_ATA_Control_Register_type1_POS)               /** ATAControl_Register type1-bit mask */
#define AG903_ATA_Control_Register_IRE1_POS                19                                                            /** ATAControl_Register IRE1-bit position */
#define AG903_ATA_Control_Register_IRE1_MSK                (0x1UL << AG903_ATA_Control_Register_IRE1_POS)                /** ATAControl_Register IRE1-bit mask */
#define AG903_ATA_Control_Register_E1_POS                  21                                                            /** ATAControl_Register E1-bit position */
#define AG903_ATA_Control_Register_E1_MSK                  (0x1UL << AG903_ATA_Control_Register_E1_POS)                  /** ATAControl_Register E1-bit mask */
#define AG903_ATA_Control_Register_DRE_POS                 25                                                            /** ATAControl_Register DRE-bit position */
#define AG903_ATA_Control_Register_DRE_MSK                 (0x1UL << AG903_ATA_Control_Register_DRE_POS)                 /** ATAControl_Register DRE-bit mask */
#define AG903_ATA_Control_Register_DTE_POS                 26                                                            /** ATAControl_Register DTE-bit position */
#define AG903_ATA_Control_Register_DTE_MSK                 (0x1UL << AG903_ATA_Control_Register_DTE_POS)                 /** ATAControl_Register DTE-bit mask */
#define AG903_ATA_Control_Register_TERIE_POS               28                                                            /** ATAControl_Register TERIE-bit position */
#define AG903_ATA_Control_Register_TERIE_MSK               (0x1UL << AG903_ATA_Control_Register_TERIE_POS)               /** ATAControl_Register TERIE-bit mask */
#define AG903_ATA_Control_Register_T_POS                   29                                                            /** ATAControl_Register T-bit position */
#define AG903_ATA_Control_Register_T_MSK                   (0x1UL << AG903_ATA_Control_Register_T_POS)                   /** ATAControl_Register T-bit mask */
#define AG903_ATA_Control_Register_SRST_POS                30                                                            /** ATAControl_Register SRST-bit position */
#define AG903_ATA_Control_Register_SRST_MSK                (0x1UL << AG903_ATA_Control_Register_SRST_POS)                /** ATAControl_Register SRST-bit mask */
#define AG903_ATA_Control_Register_RST_POS                 31                                                            /** ATAControl_Register RST-bit position */
#define AG903_ATA_Control_Register_RST_MSK                 (0x1UL << AG903_ATA_Control_Register_RST_POS)                 /** ATAControl_Register RST-bit mask */

#define AG903_ATA_IRQ_Register_rxthresh_POS                0                                                             /** ATAIRQ_Register rxthresh-bit position */
#define AG903_ATA_IRQ_Register_rxthresh_MSK                (0x3ffUL << AG903_ATA_IRQ_Register_rxthresh_POS)              /** ATAIRQ_Register rxthresh-bit mask */
#define AG903_ATA_IRQ_Register_RFAFIRQ_POS                 10                                                            /** ATAIRQ_Register RFAFIRQ-bit position */
#define AG903_ATA_IRQ_Register_RFAFIRQ_MSK                 (0x1UL << AG903_ATA_IRQ_Register_RFAFIRQ_POS)                 /** ATAIRQ_Register RFAFIRQ-bit mask */
#define AG903_ATA_IRQ_Register_RFNEIRQ_POS                 11                                                            /** ATAIRQ_Register RFNEIRQ-bit position */
#define AG903_ATA_IRQ_Register_RFNEIRQ_MSK                 (0x1UL << AG903_ATA_IRQ_Register_RFNEIRQ_POS)                 /** ATAIRQ_Register RFNEIRQ-bit mask */
#define AG903_ATA_IRQ_Register_WFAEIRQ_POS                 12                                                            /** ATAIRQ_Register WFAEIRQ-bit position */
#define AG903_ATA_IRQ_Register_WFAEIRQ_MSK                 (0x1UL << AG903_ATA_IRQ_Register_WFAEIRQ_POS)                 /** ATAIRQ_Register WFAEIRQ-bit mask */
#define AG903_ATA_IRQ_Register_WFNFIRQ_POS                 13                                                            /** ATAIRQ_Register WFNFIRQ-bit position */
#define AG903_ATA_IRQ_Register_WFNFIRQ_MSK                 (0x1UL << AG903_ATA_IRQ_Register_WFNFIRQ_POS)                 /** ATAIRQ_Register WFNFIRQ-bit mask */
#define AG903_ATA_IRQ_Register_IIRQ_POS                    15                                                            /** ATAIRQ_Register IIRQ-bit position */
#define AG903_ATA_IRQ_Register_IIRQ_MSK                    (0x1UL << AG903_ATA_IRQ_Register_IIRQ_POS)                    /** ATAIRQ_Register IIRQ-bit mask */
#define AG903_ATA_IRQ_Register_txthresh_POS                16                                                            /** ATAIRQ_Register txthresh-bit position */
#define AG903_ATA_IRQ_Register_txthresh_MSK                (0x3ffUL << AG903_ATA_IRQ_Register_txthresh_POS)              /** ATAIRQ_Register txthresh-bit mask */
#define AG903_ATA_IRQ_Register_TERMERR_POS                 28                                                            /** ATAIRQ_Register TERMERR-bit position */
#define AG903_ATA_IRQ_Register_TERMERR_MSK                 (0x1UL << AG903_ATA_IRQ_Register_TERMERR_POS)                 /** ATAIRQ_Register TERMERR-bit mask */
#define AG903_ATA_IRQ_Register_AHBERR_POS                  29                                                            /** ATAIRQ_Register AHBERR-bit position */
#define AG903_ATA_IRQ_Register_AHBERR_MSK                  (0x1UL << AG903_ATA_IRQ_Register_AHBERR_POS)                  /** ATAIRQ_Register AHBERR-bit mask */

#define AG903_ATA_Command_Timing_0_T1_POS                  0                                                             /** ATACommand_Timing_0 T1-bit position */
#define AG903_ATA_Command_Timing_0_T1_MSK                  (0xffUL << AG903_ATA_Command_Timing_0_T1_POS)                 /** ATACommand_Timing_0 T1-bit mask */
#define AG903_ATA_Command_Timing_0_T2_POS                  8                                                             /** ATACommand_Timing_0 T2-bit position */
#define AG903_ATA_Command_Timing_0_T2_MSK                  (0xffUL << AG903_ATA_Command_Timing_0_T2_POS)                 /** ATACommand_Timing_0 T2-bit mask */
#define AG903_ATA_Command_Timing_0_T4_POS                  16                                                            /** ATACommand_Timing_0 T4-bit position */
#define AG903_ATA_Command_Timing_0_T4_MSK                  (0xffUL << AG903_ATA_Command_Timing_0_T4_POS)                 /** ATACommand_Timing_0 T4-bit mask */
#define AG903_ATA_Command_Timing_0_TEOC_POS                24                                                            /** ATACommand_Timing_0 TEOC-bit position */
#define AG903_ATA_Command_Timing_0_TEOC_MSK                (0xffUL << AG903_ATA_Command_Timing_0_TEOC_POS)               /** ATACommand_Timing_0 TEOC-bit mask */

#define AG903_ATA_Data_Timing_PIO_0_T1_POS                 0                                                             /** ATAData_Timing_PIO_0 T1-bit position */
#define AG903_ATA_Data_Timing_PIO_0_T1_MSK                 (0xffUL << AG903_ATA_Data_Timing_PIO_0_T1_POS)                /** ATAData_Timing_PIO_0 T1-bit mask */
#define AG903_ATA_Data_Timing_PIO_0_T2_POS                 8                                                             /** ATAData_Timing_PIO_0 T2-bit position */
#define AG903_ATA_Data_Timing_PIO_0_T2_MSK                 (0xffUL << AG903_ATA_Data_Timing_PIO_0_T2_POS)                /** ATAData_Timing_PIO_0 T2-bit mask */
#define AG903_ATA_Data_Timing_PIO_0_T4_POS                 16                                                            /** ATAData_Timing_PIO_0 T4-bit position */
#define AG903_ATA_Data_Timing_PIO_0_T4_MSK                 (0xffUL << AG903_ATA_Data_Timing_PIO_0_T4_POS)                /** ATAData_Timing_PIO_0 T4-bit mask */
#define AG903_ATA_Data_Timing_PIO_0_TEOC_POS               24                                                            /** ATAData_Timing_PIO_0 TEOC-bit position */
#define AG903_ATA_Data_Timing_PIO_0_TEOC_MSK               (0xffUL << AG903_ATA_Data_Timing_PIO_0_TEOC_POS)              /** ATAData_Timing_PIO_0 TEOC-bit mask */

#define AG903_ATA_Data_Timing_UDMA_0_TENV_POS              0                                                             /** ATAData_Timing_UDMA_0 TENV-bit position */
#define AG903_ATA_Data_Timing_UDMA_0_TENV_MSK              (0xfUL << AG903_ATA_Data_Timing_UDMA_0_TENV_POS)              /** ATAData_Timing_UDMA_0 TENV-bit mask */
#define AG903_ATA_Data_Timing_UDMA_0_TMLI_POS              4                                                             /** ATAData_Timing_UDMA_0 TMLI-bit position */
#define AG903_ATA_Data_Timing_UDMA_0_TMLI_MSK              (0xfUL << AG903_ATA_Data_Timing_UDMA_0_TMLI_POS)              /** ATAData_Timing_UDMA_0 TMLI-bit mask */
#define AG903_ATA_Data_Timing_UDMA_0_TCYC_POS              8                                                             /** ATAData_Timing_UDMA_0 TCYC-bit position */
#define AG903_ATA_Data_Timing_UDMA_0_TCYC_MSK              (0xffUL << AG903_ATA_Data_Timing_UDMA_0_TCYC_POS)             /** ATAData_Timing_UDMA_0 TCYC-bit mask */
#define AG903_ATA_Data_Timing_UDMA_0_TACK_POS              16                                                            /** ATAData_Timing_UDMA_0 TACK-bit position */
#define AG903_ATA_Data_Timing_UDMA_0_TACK_MSK              (0xfUL << AG903_ATA_Data_Timing_UDMA_0_TACK_POS)              /** ATAData_Timing_UDMA_0 TACK-bit mask */
#define AG903_ATA_Data_Timing_UDMA_0_TCVS_POS              20                                                            /** ATAData_Timing_UDMA_0 TCVS-bit position */
#define AG903_ATA_Data_Timing_UDMA_0_TCVS_MSK              (0xfUL << AG903_ATA_Data_Timing_UDMA_0_TCVS_POS)              /** ATAData_Timing_UDMA_0 TCVS-bit mask */
#define AG903_ATA_Data_Timing_UDMA_0_TRP_POS               24                                                            /** ATAData_Timing_UDMA_0 TRP-bit position */
#define AG903_ATA_Data_Timing_UDMA_0_TRP_MSK               (0xffUL << AG903_ATA_Data_Timing_UDMA_0_TRP_POS)              /** ATAData_Timing_UDMA_0 TRP-bit mask */

#define AG903_ATA_Command_Timing_1_T1_POS                  0                                                             /** ATACommand_Timing_1 T1-bit position */
#define AG903_ATA_Command_Timing_1_T1_MSK                  (0xffUL << AG903_ATA_Command_Timing_1_T1_POS)                 /** ATACommand_Timing_1 T1-bit mask */
#define AG903_ATA_Command_Timing_1_T2_POS                  8                                                             /** ATACommand_Timing_1 T2-bit position */
#define AG903_ATA_Command_Timing_1_T2_MSK                  (0xffUL << AG903_ATA_Command_Timing_1_T2_POS)                 /** ATACommand_Timing_1 T2-bit mask */
#define AG903_ATA_Command_Timing_1_T4_POS                  16                                                            /** ATACommand_Timing_1 T4-bit position */
#define AG903_ATA_Command_Timing_1_T4_MSK                  (0xffUL << AG903_ATA_Command_Timing_1_T4_POS)                 /** ATACommand_Timing_1 T4-bit mask */
#define AG903_ATA_Command_Timing_1_TEOC_POS                24                                                            /** ATACommand_Timing_1 TEOC-bit position */
#define AG903_ATA_Command_Timing_1_TEOC_MSK                (0xffUL << AG903_ATA_Command_Timing_1_TEOC_POS)               /** ATACommand_Timing_1 TEOC-bit mask */

#define AG903_ATA_Data_Timing_PIO_1_T1_POS                 0                                                             /** ATAData_Timing_PIO_1 T1-bit position */
#define AG903_ATA_Data_Timing_PIO_1_T1_MSK                 (0xffUL << AG903_ATA_Data_Timing_PIO_1_T1_POS)                /** ATAData_Timing_PIO_1 T1-bit mask */
#define AG903_ATA_Data_Timing_PIO_1_T2_POS                 8                                                             /** ATAData_Timing_PIO_1 T2-bit position */
#define AG903_ATA_Data_Timing_PIO_1_T2_MSK                 (0xffUL << AG903_ATA_Data_Timing_PIO_1_T2_POS)                /** ATAData_Timing_PIO_1 T2-bit mask */
#define AG903_ATA_Data_Timing_PIO_1_T4_POS                 16                                                            /** ATAData_Timing_PIO_1 T4-bit position */
#define AG903_ATA_Data_Timing_PIO_1_T4_MSK                 (0xffUL << AG903_ATA_Data_Timing_PIO_1_T4_POS)                /** ATAData_Timing_PIO_1 T4-bit mask */
#define AG903_ATA_Data_Timing_PIO_1_TEOC_POS               24                                                            /** ATAData_Timing_PIO_1 TEOC-bit position */
#define AG903_ATA_Data_Timing_PIO_1_TEOC_MSK               (0xffUL << AG903_ATA_Data_Timing_PIO_1_TEOC_POS)              /** ATAData_Timing_PIO_1 TEOC-bit mask */

#define AG903_ATA_Data_Timing_UDMA_1_TENV_POS              0                                                             /** ATAData_Timing_UDMA_1 TENV-bit position */
#define AG903_ATA_Data_Timing_UDMA_1_TENV_MSK              (0xfUL << AG903_ATA_Data_Timing_UDMA_1_TENV_POS)              /** ATAData_Timing_UDMA_1 TENV-bit mask */
#define AG903_ATA_Data_Timing_UDMA_1_TMLI_POS              4                                                             /** ATAData_Timing_UDMA_1 TMLI-bit position */
#define AG903_ATA_Data_Timing_UDMA_1_TMLI_MSK              (0xfUL << AG903_ATA_Data_Timing_UDMA_1_TMLI_POS)              /** ATAData_Timing_UDMA_1 TMLI-bit mask */
#define AG903_ATA_Data_Timing_UDMA_1_TCYC_POS              8                                                             /** ATAData_Timing_UDMA_1 TCYC-bit position */
#define AG903_ATA_Data_Timing_UDMA_1_TCYC_MSK              (0xffUL << AG903_ATA_Data_Timing_UDMA_1_TCYC_POS)             /** ATAData_Timing_UDMA_1 TCYC-bit mask */
#define AG903_ATA_Data_Timing_UDMA_1_TACK_POS              16                                                            /** ATAData_Timing_UDMA_1 TACK-bit position */
#define AG903_ATA_Data_Timing_UDMA_1_TACK_MSK              (0xfUL << AG903_ATA_Data_Timing_UDMA_1_TACK_POS)              /** ATAData_Timing_UDMA_1 TACK-bit mask */
#define AG903_ATA_Data_Timing_UDMA_1_TCVS_POS              20                                                            /** ATAData_Timing_UDMA_1 TCVS-bit position */
#define AG903_ATA_Data_Timing_UDMA_1_TCVS_MSK              (0xfUL << AG903_ATA_Data_Timing_UDMA_1_TCVS_POS)              /** ATAData_Timing_UDMA_1 TCVS-bit mask */
#define AG903_ATA_Data_Timing_UDMA_1_TRP_POS               24                                                            /** ATAData_Timing_UDMA_1 TRP-bit position */
#define AG903_ATA_Data_Timing_UDMA_1_TRP_MSK               (0xffUL << AG903_ATA_Data_Timing_UDMA_1_TRP_POS)              /** ATAData_Timing_UDMA_1 TRP-bit mask */

#define AG903_ATA_AHB_Timeout_WRITE_VALUE_POS              0                                                             /** ATAAHB_Timeout WRITE_VALUE-bit position */
#define AG903_ATA_AHB_Timeout_WRITE_VALUE_MSK              (0x7fffUL << AG903_ATA_AHB_Timeout_WRITE_VALUE_POS)           /** ATAAHB_Timeout WRITE_VALUE-bit mask */
#define AG903_ATA_AHB_Timeout_WRITE_ENABLE_POS             15                                                            /** ATAAHB_Timeout WRITE_ENABLE-bit position */
#define AG903_ATA_AHB_Timeout_WRITE_ENABLE_MSK             (0x1UL << AG903_ATA_AHB_Timeout_WRITE_ENABLE_POS)             /** ATAAHB_Timeout WRITE_ENABLE-bit mask */
#define AG903_ATA_AHB_Timeout_READ_VALUE_POS               16                                                            /** ATAAHB_Timeout READ_VALUE-bit position */
#define AG903_ATA_AHB_Timeout_READ_VALUE_MSK               (0x7fffUL << AG903_ATA_AHB_Timeout_READ_VALUE_POS)            /** ATAAHB_Timeout READ_VALUE-bit mask */
#define AG903_ATA_AHB_Timeout_READ_ENABLE_POS              31                                                            /** ATAAHB_Timeout READ_ENABLE-bit position */
#define AG903_ATA_AHB_Timeout_READ_ENABLE_MSK              (0x1UL << AG903_ATA_AHB_Timeout_READ_ENABLE_POS)              /** ATAAHB_Timeout READ_ENABLE-bit mask */

#define AG903_ATA_Feature_CFIFO_CFIFO_DEPTH_POS            0                                                             /** ATAFeature_CFIFO CFIFO_DEPTH-bit position */
#define AG903_ATA_Feature_CFIFO_CFIFO_DEPTH_MSK            (0xffUL << AG903_ATA_Feature_CFIFO_CFIFO_DEPTH_POS)           /** ATAFeature_CFIFO CFIFO_DEPTH-bit mask */
#define AG903_ATA_Feature_CFIFO_CFIFO_WIDTH_POS            8                                                             /** ATAFeature_CFIFO CFIFO_WIDTH-bit position */
#define AG903_ATA_Feature_CFIFO_CFIFO_WIDTH_MSK            (0xffUL << AG903_ATA_Feature_CFIFO_CFIFO_WIDTH_POS)           /** ATAFeature_CFIFO CFIFO_WIDTH-bit mask */

#define AG903_ATA_Feature_WFIFO_WFIFO_DEPTH_POS            0                                                             /** ATAFeature_WFIFO WFIFO_DEPTH-bit position */
#define AG903_ATA_Feature_WFIFO_WFIFO_DEPTH_MSK            (0xffUL << AG903_ATA_Feature_WFIFO_WFIFO_DEPTH_POS)           /** ATAFeature_WFIFO WFIFO_DEPTH-bit mask */
#define AG903_ATA_Feature_WFIFO_WFIFO_WIDTH_POS            8                                                             /** ATAFeature_WFIFO WFIFO_WIDTH-bit position */
#define AG903_ATA_Feature_WFIFO_WFIFO_WIDTH_MSK            (0xffUL << AG903_ATA_Feature_WFIFO_WFIFO_WIDTH_POS)           /** ATAFeature_WFIFO WFIFO_WIDTH-bit mask */

#define AG903_ATA_Feature_RFIFO_RFIFO_DEPTH_POS            0                                                             /** ATAFeature_RFIFO RFIFO_DEPTH-bit position */
#define AG903_ATA_Feature_RFIFO_RFIFO_DEPTH_MSK            (0xffUL << AG903_ATA_Feature_RFIFO_RFIFO_DEPTH_POS)           /** ATAFeature_RFIFO RFIFO_DEPTH-bit mask */
#define AG903_ATA_Feature_RFIFO_RFIFO_WIDTH_POS            8                                                             /** ATAFeature_RFIFO RFIFO_WIDTH-bit position */
#define AG903_ATA_Feature_RFIFO_RFIFO_WIDTH_MSK            (0xffUL << AG903_ATA_Feature_RFIFO_RFIFO_WIDTH_POS)           /** ATAFeature_RFIFO RFIFO_WIDTH-bit mask */

#define AG903_ATA_Revision_REVISION_NUMBER_POS             0                                                             /** ATARevision REVISION_NUMBER-bit position */
#define AG903_ATA_Revision_REVISION_NUMBER_MSK             (0xffffffffUL << AG903_ATA_Revision_REVISION_NUMBER_POS)      /** ATARevision REVISION_NUMBER-bit mask */

#endif /* _AG903_ATA_REGMAP_H_ */

