/**
 * @brief           USBH CDC Osutils Header
 * @author          AXELL CORPORATION
 * @description     USBH CDC Osutils Header
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_CDC_OSUTILS_H__
#define __USB_CDC_OSUTILS_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_cdc_coreinclude.h"
#include "usb_cdc_log.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
/* R~jP[VfoCXNXp Bulk IN Mobt@ŏTCY */
#define CDC_BULKIN_BUFF_MIN_SIZE	(2048)
/* R~jP[VfoCXNXp Bulk IN Mobt@őTCY */
#define CDC_BULKIN_BUFF_MAX_SIZE	(32768)
/* R~jP[VfoCXNXp Bulk IN e|Bobt@TCY */
#define CDC_BULKIN_TEMP_BUFF_SIZE	(1024)
/* R~jP[VfoCXNXpv[őTCY */
/* (Bulk IN Mobt@ + Bulk IN e|Bobt@) */
#define CDC_MPL_MAX_SIZE			(CDC_BULKIN_BUFF_MAX_SIZE + CDC_BULKIN_TEMP_BUFF_SIZE)
/* R~jP[VfoCXNXp mێ OS Ǘ̈TCY */
#define CDC_OS_MANAGE_SIZE			(8)

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern void *CdcUtils_Malloc(uhs_size_t nSize);
extern uhs_boolean_t CdcUtils_Free(void *pMem);

extern void *CdcUtils_BuffMalloc(unsigned long size);
extern uhs_boolean_t CdcUtils_BuffFree(void *block);


extern kernel_context_t *CdcUtils_CreateSemaphore(kernel_context_t *pSem, uhs_index_t num, uhs_index_t init);
extern uhs_boolean_t CdcUtils_DeleteSemaphore(kernel_context_t *pSem);
extern uhs_boolean_t CdcUtils_AcquisitionSemaphore(kernel_context_t *pSem, uhs_ubit32_t u32Timeout);
extern uhs_boolean_t CdcUtils_ReleaseSemaphore(kernel_context_t *pSem);

extern kernel_context_t *CdcUtils_CreateEvent(kernel_context_t* pEvent, uhs_boolean_t bInit);
extern uhs_boolean_t CdcUtils_DeleteEvent(kernel_context_t *pEvent);
extern uhs_boolean_t CdcUtils_SetEvent(kernel_context_t *pEvent);
extern uhs_boolean_t CdcUtils_WaitEvent(kernel_context_t *pEvent, uhs_ubit32_t u32Timeout);


/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define OSUTILS_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define OSUTILS_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#else
#define OSUTILS_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportDummy(err)
#define OSUTILS_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportDummy(err)
#endif

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_CDC_OSUTILS_H__ */
