/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#ifndef FFSYSDRV_CFG_H
#define FFSYSDRV_CFG_H


/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
/* Global configuration */
#define CFG_DRV_DSK_CNT				(3)			/* Number of disks */
#define CFG_DRV_DSK_ID_ENA       	(1)     	/* Disk device ID enable */

/* Device ID */
#define FFS_DEVID_SD				(0)
#define FFS_DEVID_CF				(1)
#define FFS_DEVID_USB				(2)

/* Low-driver 0 [SD] */
#include "DDR_AG903_SD.h"
#define CFG_DRV_LOW0_DEV_ID     	(0)      	/* Device ID */
#define CFG_DRV_LOW0_TMO        	(4000)   	/* Timeout (msec) */
#define ffs_drv_low0_ini        	sd_ena
#define ffs_drv_low0_ext        	sd_dis
#define ffs_drv_low0_mnt        	sd_mnt
#define ffs_drv_low0_umt        	sd_umt
#define ffs_drv_low0_read       	sd_read
#define ffs_drv_low0_write      	sd_write

/* Low-driver 1 [CF] */
#if (CFG_DRV_DSK_CNT > 1)
#include "DDR_AG903_CF.h"
#define CFG_DRV_LOW1_DEV_ID     	(0)      	/* Device ID */
#define CFG_DRV_LOW1_TMO        	(4000)   	/* Timeout (msec) */
#define ffs_drv_low1_ini        	cf_ena
#define ffs_drv_low1_ext        	cf_dis
#define ffs_drv_low1_mnt        	cf_mnt
#define ffs_drv_low1_umt        	cf_umt
#define ffs_drv_low1_read       	cf_read
#define ffs_drv_low1_write      	cf_write
#endif

/* Low-driver 2 [USB] */
#if (CFG_DRV_DSK_CNT > 2)
#include "fsif.h"
#include "usb_msc_api.h"
#include "usb_msc_param.h"
#define MPL_FS_ADDR             	(0x83E90000)	
#define MPL_FS_SIZE             	(0x10000 * USBH_MAX_CLS_MSC_NUM)
#define CFG_DRV_LOW2_DEV_ID      	(0)      		/* Device ID () */
#define CFG_DRV_LOW_FIXED_DEV_ID	(ID)0xFFFF		/* Device ID */
#define CFG_DRV_LOW2_TMO        	(4000)   		/* Time-out */
#define ffs_drv_low2_ini        	usb_ini
#define ffs_drv_low2_ext        	usb_ext
#define ffs_drv_low2_mnt        	usb_mnt
#define ffs_drv_low2_umt        	usb_umt
#define ffs_drv_low2_read       	usb_read
#define ffs_drv_low2_write      	usb_write
#define CFG_DRV_LOW2_CONTEXT_BASE	CONTEXT_BASE
#define CFG_DRV_LOW2_MAX_DRIVE		MAX_DRIVE
#endif

#endif
