/*
* This program was created by AXELL CORPORATION.
* Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#ifndef __GFX_SAMPLE_H__
#define __GFX_SAMPLE_H__

#include "sample_common.h"
#include "EGL/eglext_AG903.h"
#include "EGL/egl.h"
#include "VG/openvg.h"
#include "VG/vgext_AG903.h"
#include "vxlib.h"

#ifdef __IAR_SYSTEMS_ICC__
#include <intrinsics.h>
#else
#define __DMB()	asm("dmb")
#endif

/* Macro */
#define EPRINT(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)
#define PRINT(FMT, ...)			sys_print(0, FMT"\r\n",##__VA_ARGS__)
#define GFX_ERROR(str)			PRINT(" ERROR:%s[%d] *%s*",__FUNCTION__, __LINE__, str)
#define IOW32(A,D)				*((volatile uint32_t *)(A)) = (D)
#define IOR32(A)				(*((volatile uint32_t *)(A)))

/* 定数定義 */
#define GFX_GMEM_SIZE			(0x00900000)
#define GFX_SYSMEM_SIZE			(0x00200000)


#define GFX_WIDTH				640
#define GFX_HEIGHT				480

#define IMAGE_WIDTH				160
#define IMAGE_HEIGHT			120
#define IMAGE_BPP				4
#define IMAGE_STRIDE			(IMAGE_WIDTH * IMAGE_BPP)
#define IMAGE_NAME1				"A:\\rgba1.dat"
#define IMAGE_NAME2				"A:\\rgba2.dat"
#define BLEND_WIDTH				120
#define BLEND_HEIGHT			120
#define BLEND_BPP				4
#define BLEND_STRIDE			(BLEND_WIDTH * BLEND_BPP)
#define BLEND_NAME1				"A:\\blend1.dat"
#define BLEND_NAME2				"A:\\blend2.dat"
#define VGA_WIDTH				640
#define VGA_HEIGHT				480
#define VGA_BPP					4
#define VGA_STRIDE				(VGA_WIDTH * VGA_BPP)
#define VGA_NAME				"A:\\vga.dat"
#define MASK_WIDTH				640
#define MASK_HEIGHT				480
#define MASK_BPP				1
#define MASK_STRIDE				(MASK_WIDTH * MASK_BPP)
#define MASK_NAME				"A:\\mask.dat"
#define FILTER_WIDTH			200
#define FILTER_HEIGHT			150
#define FILTER_BPP				4
#define FILTER_STRIDE			(FILTER_WIDTH * FILTER_BPP)
#define FILTER_NAME				"A:\\filter.dat"
#define PAT_WIDTH				32
#define PAT_HEIGHT				32
#define PAT_BPP					4
#define PAT_STRIDE				(PAT_WIDTH * PAT_BPP)
#define PAT_NAME				"A:\\pat.dat"
#define RGB_WIDTH				224
#define RGB_HEIGHT				224
#define RGB_BPP					3
#define RGB_STRIDE				(RGB_WIDTH * RGB_BPP)
#define RGB_NAME				"A:\\rgb.dat"
#define YUV_WIDTH				224
#define YUV_HEIGHT				224
#define YUV_BPP					2
#define YUV_STRIDE				(YUV_WIDTH * YUV_BPP)
#define YUV_NAME				"A:\\yuv.dat"
#define LUT_WIDTH				224
#define LUT_HEIGHT				224
#define LUT_BPP					1
#define LUT_STRIDE				(LUT_WIDTH * LUT_BPP)
#define LUT_NAME				"A:\\lut.dat"
#define PLT_WIDTH				256
#define PLT_HEIGHT				4
#define PLT_BPP					1
#define PLT_STRIDE				(PLT_WIDTH * PLT_BPP)
#define PLT_NAME				"A:\\plt.dat"
#define COVER_WIDTH				320
#define COVER_HEIGHT			240
#define COVER_BPP				4
#define COVER_STRIDE			(COVER_WIDTH * COVER_BPP)
#define COVER_NAME0				"A:\\image0.dat"
#define COVER_NAME1				"A:\\image1.dat"
#define COVER_NAME2				"A:\\image2.dat"
#define COVER_NAME3				"A:\\image3.dat"
#define COVER_NAME4				"A:\\image4.dat"
#define COVER_NAME5				"A:\\image5.dat"
#define COVER_NAME6				"A:\\image6.dat"
#define COVER_NAME7				"A:\\image7.dat"
#define COVER_NAME8				"A:\\image8.dat"

extern void GfxSwapBuffer(void);
extern void GfxWriteMemory(void *dst, void *src, size_t size);
extern void *GfxGetFreeArea(int width, int height, int bpp);
extern void GfxReleaseFreeArea(void *addr);
extern void GfxFsRead(int8_t *filename, uint32_t size, void *buf);
extern void ClearMain(void);
extern void PathMain(void);
extern void StrokeMain(void);
extern void ImageMain(void);
extern void MatrixMain(void);
extern void PaintMain(void);
extern void ScissorMain(void);
extern void MaskMain(void);
extern void ColorTransformMain(void);
extern void BlendMain(void);
extern void GlyphMain(void);
extern void AntialiasingMain(void);
extern void ImageFilterMain(void);
extern void ExtImageMain(void);
extern void DirectImageMain(void);
extern void FastPathMain(void);
extern void ConvolutionMain(void);
extern void CopyRectMain(void);
extern void MultifuncMain(void);
extern void BmuGfxMain(void);

#endif/* __GFX_SAMPLE_H_ */
