/**
 * @brief           Movie Player Sample API I/F
 * @author          AXELL CORPORATION
 * @description     APIC^tF[X
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 */

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

//DOM-IGNORE-BEGIN
#ifndef __MPS_API_H_
#define __MPS_API_H_
//DOM-IGNORE-END

#include "mps/mps_type.h"
#include "mps/mps_fileio.h"
#include "mps/mps_mp4perser.h"
#include "mps/mps_gvdinterface.h"

/**
 * Imۂ̏`Ă.<p>
 * ̊֐MPSR[܂.
 *
 * @brief Imۃ[`
 * @param size [in] vTCY
 * @return NULL mێs
 * @return Otherwise mۂ̐擪AhX
 * @note   8oCgȏ̋EŊmۂĂ.
 */
extern void *MPS_Malloc(size_t size);

/**
 * Ȉ`Ă.<p>
 * ̊֐MPSR[܂.
 *
 * @brief I[`
 * @param ptr [in] 郁̐擪AhX
 * @return any G[R[h
 * @note G[eɊւĂ"AG903_error.h"QƂ̂.
 */
extern int32_t MPS_Free(void *ptr);

/**
 * KvɉāAG[o͂̏`Ă.<p>
 * ̊֐MPSR[܂.
 *
 * @brief G[o̓[`
 * @param fmt [in] 
 * @return >=0 o͂
 * @return <0 G[R[h
 * @note G[eɊւĂ"AG903_error.h"QƂ̂.
 */
extern int32_t MPS_ErrPrintf(const char *fmt, ...);

/**
 * fBC֐̒`
 * @param UW [in] fBC[ms]
 * @return ER G[R[h
 * @return G[R[hITROÑR[hQ.
 */
#include "itron.h"
extern ER dly_tsk(UW);

/**
 * TvłITRONȂ̂ITRONdly_tskɒu
 * @brief fBC֐̒`
 */
#define MPS_Delay dly_tsk

/* getters */
gvdInitializeParam *MPS_getGVDInitParam(void);
mpsConfig *MPS_getConfig(void);
mpsContext *MPS_getContext(uint32_t movie_id);
mpsInfoPos *MPS_getInfoPos(uint32_t movie_id);
mpsAVCHeader *MPS_getAVCHeader(uint32_t movie_id);

int32_t MPS_Initialize(mpsSetting setting);
uint32_t MPS_GetRequiredWorkMemorySize(void);
int32_t MPS_Start(mpsConfig config);
int32_t MPS_Parse(uint32_t movie_id, char *filename);
int32_t MPS_Open(uint32_t movie_id, char *filename);
int32_t MPS_Play(uint32_t movie_id);
int32_t MPS_Pause(uint32_t movie_id);
int32_t MPS_Seek(uint32_t movie_id, uint32_t pos, mpsSeekMode mode);
int32_t MPS_Forward(uint32_t movie_id, uint32_t speed);
int32_t MPS_Rewind(uint32_t movie_id, uint32_t speed);
int32_t MPS_Close(uint32_t movie_id);
int32_t MPS_Finalize(void);

int32_t MPS_PutOutputBuffer(int32_t movie_id, mpsOutBufInfo *bufinfo);
int32_t MPS_Async(void);

int32_t cbMPSConnectDone(void *param_gvd, void *param_user, gvdError error);
int32_t cbMPSDisConnectDone(void *param_gvd, void *param_user, gvdError error);
int32_t cbMPSPlayAccepted(void *param_gvd, void *param_user, gvdError error);
int32_t cbMPSRewindAccepted(void *param_gvd, void *param_user, gvdError error);
int32_t cbMPSForwardAccepted(void *param_gvd, void *param_user, gvdError error);
int32_t cbMPSDecodeStreamEnd(void *param_gvd, void *param_user, gvdError error);
int32_t cbMPSPauseDone(void *param_gvd, void *param_user, gvdError error);
int32_t cbMPSSeekDone(void *param_gvd, void *param_user, gvdError error);
int32_t cbMPSRewindDone(void *param_gvd, void *param_user, gvdError error);

#endif /* __MPS_API_H_ */
