/*
 * @history 2025_03_06  [SDK3.7] RTCdr؂̂ƂI2CnhȂsC (#5792)
 */
/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */
#include "sample_common.h"
#include "com.h"
#include "i2c/i2cmgr.h"

/* vg^Cv */
static int32_t I2c_init_module(void);
static int32_t I2c_term_module(void);
static void I2c_SampleHelp(void);
static void I2c_RtcReadTime(void);
static void I2c_RtcSetTime(void);
static void I2c_SensGetInTemp(void);
static void I2c_SensGetExTemp(void);
static void I2c_SensGetTemp(uint8_t type, uint16_t* tmprdata);
static int32_t I2c_SensWaitBusyClr(AG903_I2CMgrHandle* handle);
static int32_t I2c_WaitWrite(uint32_t timout);
static int32_t I2c_WaitRead(uint32_t timout);
static uint8_t I2c_24Hto12H(uint8_t val);
static uint8_t I2c_12Hto24H(uint8_t val);
static uint8_t BCDtoDEC(uint8_t bcd);
static void I2c_CallbackEvent(AG903_I2CMgrHandle* handle, uint32_t event);

#define I2C_SMP_RTC_1224BIT		(1<<5)		/* RTC /12,24bit */

enum {	/* SENSOR 擾 */
	I2C_SMP_IN_TEMP=0,
	I2C_SMP_EX_TEMP,
};

/** Data Types **/
typedef struct _I2c_RtcTime{
	uint8_t		sec;
	uint8_t		min;
	uint8_t		hour;
	uint8_t		day;
	uint8_t		month;
	uint8_t		year;
} I2c_RtcTime;

/* Macro */
#define	EPRINT(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)
#define	PRINT(FMT, ...)			sys_print(0, FMT"\r\n",##__VA_ARGS__)
#define I2C_ERROR(str)			sys_print(1, " ERROR:%s[%d] *%s*\r\n",__FUNCTION__, __LINE__, str)

static void (*func[])() = {
	I2c_SampleHelp,
	I2c_RtcReadTime,
	I2c_RtcSetTime,
	I2c_SensGetInTemp,
	I2c_SensGetExTemp,
};

static _Bool	I2cWriteEnd=false;
static _Bool	I2cReadEnd=false;

/**
 * @brief		C
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void I2C_main(uint8_t param)
{
	uint8_t		mode = 0;
	char		input[2+2];

	((void)param);

	I2c_SampleHelp();	/* Help\ */

	I2c_init_module();

	while (mode != 0xFF) {
		EPRINT(" -- Choose sample number (00h<HELP> to FFh): ");
		COM_GetNum_Wait(input, sizeof(input));
		mode = (ASCtoBIN(input[0]) << 4)
			 | (ASCtoBIN(input[1]) << 0);
		if(0xFF == mode) {
			break;
		}
		if(mode >= (sizeof(func)/sizeof(void*))) {
			func[0](); /* Help */
		}
		else {
			func[mode]();	/* Sample funcs */
		}
	}

	I2c_term_module();

	return;
}

/**
 * @brief		Tu
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void I2C_sub(uint32_t param)
{
	((void)param);
	/* Ȃ */
	return;
}

/**
 * @brief		W[
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t I2c_init_module(void)
{
	/* MainTaskŏς */
	return AG903_ENONE;
}

/**
 * @brief		W[I
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t I2c_term_module(void)
{
	/* Ȃ */
	return AG903_ENONE;
}

/**
 * @brief		wv\
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void I2c_SampleHelp(void)
{
	PRINT("\t# 00 ... Help");
	PRINT("\t# 01 ... RTC[RX-8025] Read Time");
	PRINT("\t# 02 ... RTC[RX-8025] Set Time");
	PRINT("\t# 03 ... Sensor[EMC1412] Internal Temperature");
	PRINT("\t# 04 ... Sensor[EMC1412] External Temperature");
	PRINT("\t# FF ... Exit Sample");

	return;
}

/**
 * @brief		RTC Read
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void I2c_RtcReadTime(void)
{
	AG903_I2CMgrHandle*		handle;
	AG903_I2CMgrReadParam 	rd;
	AG903_I2CMgrWriteParam 	wr;
	I2c_RtcTime tim;
	int32_t 	result;
	uint8_t		regaddr;
	uint8_t		rxbuf[16];

	PRINT(" RTC[RX-8025] Read Time");

	I2cWriteEnd = false;
	I2cReadEnd  = false;

	/* I2Cݒ */
	result = AG903_I2CMgrGetHandle(AG903_RTC_I2C_CH, &handle); 						/* I2Cnh擾 */
	if(AG903_ENONE != result) {
		I2C_ERROR("GetHandle");
	}
	result = AG903_I2CMgrSetCallback(handle, (AG903_I2CMgrClbk)I2c_CallbackEvent);	/* R[obNo^ */
	if(AG903_ENONE != result) {
		I2C_ERROR("GetHandle");
	}

	/* RTC Read [Standard read method] */
	regaddr = 0; /* Seconds` */
	wr.addr = AG903_RTC_SADDR;
	wr.buf  = &regaddr;
	wr.size = 1;
	wr.stop = false; /* ReStart */
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	rd.addr = (AG903_RTC_SADDR|0x01); /* bit0FR/W */
	rd.buf  = rxbuf;
	rd.size = 16; /* ALL Regster Read */
	result  = AG903_I2CMgrMasterRead(handle, &rd);									/* Master Read */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterRead");
	}
	result = I2c_WaitRead(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitRead");
	}

	/* I2C */
	result = AG903_I2CMgrReleaseHandle(handle);										/* nh */
	if(AG903_ENONE != result) {
		I2C_ERROR("ReleaseHandle");
		AG903_I2CMgrReset(handle);
	}

	/* \ */
	if(I2C_SMP_RTC_1224BIT & ~rxbuf[14]) {
		rxbuf[2] = I2c_12Hto24H(rxbuf[2]);
	}
	tim.sec   = BCDtoDEC(rxbuf[0]);
	tim.min   = BCDtoDEC(rxbuf[1]);
	tim.hour  = BCDtoDEC(rxbuf[2]);
	tim.day   = BCDtoDEC(rxbuf[4]);
	tim.month = BCDtoDEC(rxbuf[5]);
	tim.year  = BCDtoDEC(rxbuf[6]);
	PRINT(" 20%02d/%02d/%02d %02d:%02d:%02d", tim.year, tim.month,
												tim.day, tim.hour, tim.min, tim.sec);

	return;
}

/**
 * @brief		RTC ݒ菈
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void I2c_RtcSetTime(void)
{
	AG903_I2CMgrHandle*		handle;
	AG903_I2CMgrReadParam 	rd;
	AG903_I2CMgrWriteParam 	wr;
	I2c_RtcTime tim;
	int32_t 	result;
	uint8_t		regaddr;
	uint8_t		rxbuf[16];
	uint8_t		txbuf[2];
	char 	 	chara[16];

	PRINT(" RTC[RX-8025] Set Time");

	I2cWriteEnd = false;
	I2cReadEnd  = false;

	/* I2Cݒ */
	result = AG903_I2CMgrGetHandle(AG903_RTC_I2C_CH, &handle); 						/* I2Cnh擾 */
	if(AG903_ENONE != result) {
		I2C_ERROR("GetHandle");
	}
	result = AG903_I2CMgrSetCallback(handle, (AG903_I2CMgrClbk)I2c_CallbackEvent);	/* R[obNo^ */
	if(AG903_ENONE != result) {
		I2C_ERROR("GetHandle");
	}

	/* RTC Read [Standard read method] */
	regaddr = 0; /* Seconds` */
	wr.addr = AG903_RTC_SADDR;
	wr.buf  = &regaddr;
	wr.size = 1;
	wr.stop = false; /* ReStart */
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	rd.addr = (AG903_RTC_SADDR|0x01); /* bit0FR/W */
	rd.buf  = rxbuf;
	rd.size = 16; /* ALL Regster Read */
	result  = AG903_I2CMgrMasterRead(handle, &rd);									/* Master Read */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterRead");
	}
	result = I2c_WaitRead(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitRead");
	}

	/* \ */
	if(I2C_SMP_RTC_1224BIT & ~rxbuf[14]) {
		rxbuf[2] = I2c_12Hto24H(rxbuf[2]);
	}
	tim.sec   = BCDtoDEC(rxbuf[0]);
	tim.min   = BCDtoDEC(rxbuf[1]);
	tim.hour  = BCDtoDEC(rxbuf[2]);
	tim.day   = BCDtoDEC(rxbuf[4]);
	tim.month = BCDtoDEC(rxbuf[5]);
	tim.year  = BCDtoDEC(rxbuf[6]);
	PRINT(" Current Time : 20%02d/%02d/%02d %02d:%02d:%02d", tim.year, tim.month,
												tim.day, tim.hour, tim.min, tim.sec);

	/* ݒ莞͑҂ */
	PRINT(" Enter the set time.");
	PRINT(" yymmddhhmmCRLF");
	EPRINT(" ");
	COM_GetNum_Wait(chara, 12);

	/* RTC Write */
	wr.addr = AG903_RTC_SADDR;
	wr.buf  = txbuf;
	wr.size = 2;
	wr.stop = true;
	txbuf[0]  = 0x60; /* years */
	txbuf[1]  = ASCtoBIN(chara[0]);
	txbuf[1] <<= 4;
	txbuf[1] += ASCtoBIN(chara[1]);
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	txbuf[0]  = 0x50; /* Months */
	txbuf[1]  = ASCtoBIN(chara[2]);
	txbuf[1] <<= 4;
	txbuf[1] += ASCtoBIN(chara[3]);
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	txbuf[0]  = 0x40; /* Days */
	txbuf[1]  = ASCtoBIN(chara[4]);
	txbuf[1] <<= 4;
	txbuf[1] += ASCtoBIN(chara[5]);
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	txbuf[0]  = 0x20; /* Hours */
	txbuf[1]  = ASCtoBIN(chara[6]);
	txbuf[1] <<= 4;
	txbuf[1] += ASCtoBIN(chara[7]);
	if(I2C_SMP_RTC_1224BIT & ~rxbuf[14]) {
		txbuf[1] = I2c_24Hto12H(txbuf[1]);
	}
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	txbuf[0]  = 0x10; /* Minutes */
	txbuf[1]  = ASCtoBIN(chara[8]);
	txbuf[1] <<= 4;
	txbuf[1] += ASCtoBIN(chara[9]);
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	txbuf[0]  = 0x00; /* Seconds */
	txbuf[1]  = 0x00;
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}

	/* I2C */
	result = AG903_I2CMgrReleaseHandle(handle);										/* nh */
	if(AG903_ENONE != result) {
		I2C_ERROR("ReleaseHandle");
		AG903_I2CMgrReset(handle);
	}

	return;
}

/**
 * @brief		Internal Temperature 擾
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void I2c_SensGetInTemp(void)
{
	uint16_t	tmprdata;

	PRINT(" Sensor[EMC1412] Internal Temperature");

	I2c_SensGetTemp(I2C_SMP_IN_TEMP, &tmprdata);

	PRINT(" Internal Temperature : %2d.%03d", (tmprdata/1000), (tmprdata%1000));

	return;
}

/**
 * @brief		External Temperature 擾
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void I2c_SensGetExTemp(void)
{
	uint16_t	tmprdata;

	PRINT(" Sensor[EMC1412] External Temperature");

	I2c_SensGetTemp(I2C_SMP_EX_TEMP, &tmprdata);

	PRINT(" External Temperature : %2d.%03d", (tmprdata/1000), (tmprdata%1000));

	return;
}

/**
 * @brief		Temperature 擾
 * @param[in]	type		擾ʁiInternal/Externalj
 * @param[out]	tmprdata	xf[^ (x1000)
 * @return		Ȃ
 * @note		Ȃ
 */
static void I2c_SensGetTemp(uint8_t type, uint16_t* tmprdata)
{
	AG903_I2CMgrHandle*		handle;
	AG903_I2CMgrReadParam 	rd;
	AG903_I2CMgrWriteParam 	wr;
	int32_t 	result;
	uint8_t		highbyte;
	uint8_t		lowbyte;
	uint8_t		txbuf[2];
	uint8_t		rxbuf[2];

	I2cWriteEnd = false;
	I2cReadEnd  = false;

	/* I2Cݒ */
	result = AG903_I2CMgrGetHandle(AG903_SENSOR_I2C_CH, &handle); 					/* I2Cnh擾 */
	if(AG903_ENONE != result) {
		I2C_ERROR("GetHandle");
	}
	result = AG903_I2CMgrSetCallback(handle, (AG903_I2CMgrClbk)I2c_CallbackEvent);	/* R[obNo^ */
	if(AG903_ENONE != result) {
		I2C_ERROR("GetHandle");
	}

	/* Set Configuration */
	txbuf[0] = 0x03; /* Configuration Register */
	txbuf[1] = 0x40; /* Default [STOP, DAVG Enable] */
	wr.addr = AG903_SENSOR_SADDR;
	wr.buf  = txbuf;
	wr.size = 2;
	wr.stop = true;
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	result = I2c_SensWaitBusyClr(handle);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitBusy");
	}

	/* One Shot */
	txbuf[0] = 0x0F; /* One Shot */
	txbuf[1] = 0xFF; /* Dummy */
	wr.addr = AG903_SENSOR_SADDR;
	wr.buf  = txbuf;
	wr.size = 2;
	wr.stop = true;
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	result = I2c_SensWaitBusyClr(handle);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitBusy");
	}

	/* EMC1412 Read Register */
	switch(type) {
		case I2C_SMP_IN_TEMP:
			highbyte = 0x00;			/* Internal Diode High Byte */
			lowbyte  = 0x29;
			break;
		case I2C_SMP_EX_TEMP:
			highbyte = 0x01;			/* External Diode High Byte */
			lowbyte  = 0x10;
			break;
		default:
			break;
	}
	wr.addr = AG903_SENSOR_SADDR;
	wr.buf  = &highbyte;
	wr.size = 1;
	wr.stop = false; /* ReStart */
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	rd.addr = (AG903_SENSOR_SADDR|0x01); /* bit0FR/W */
	rd.buf  = &rxbuf[0];
	rd.size = 1;
	result  = AG903_I2CMgrMasterRead(handle, &rd);									/* Master Read */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterRead");
	}
	result = I2c_WaitRead(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitRead");
	}

	wr.addr = AG903_SENSOR_SADDR;
	wr.buf  = &lowbyte;
	wr.size = 1;
	wr.stop = false; /* ReStart */
	result = AG903_I2CMgrMasterWrite(handle, &wr);									/* Master Write */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterWrite");
	}
	result = I2c_WaitWrite(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitWrite");
	}
	rd.addr = (AG903_SENSOR_SADDR|0x01); /* bit0FR/W */
	rd.buf  = &rxbuf[1];
	rd.size = 1;
	result  = AG903_I2CMgrMasterRead(handle, &rd);									/* Master Read */
	if(AG903_ENONE != result) {
		I2C_ERROR("MasterRead");
	}
	result = I2c_WaitRead(5000);
	if(AG903_ENONE != result) {
		I2C_ERROR("WaitRead");
	}

	/* I2C */
	result = AG903_I2CMgrReleaseHandle(handle);										/* nh */
	if(AG903_ENONE != result) {
		I2C_ERROR("ReleaseHandle");
		AG903_I2CMgrReset(handle);
	}

	(*tmprdata)   = (rxbuf[0] << 8);
	(*tmprdata)  |= rxbuf[1];
	(*tmprdata) >>= 5;
	(*tmprdata)  *= 125;

	return;
}

/**
 * @brief		Sensor BusyNA҂
 * @param[in]	handle		I2Cnh
 * @return		AG903_ENONE		I
 * @return		-AG903_EFAULT		ُI
 * @note		Ȃ
 */
static int32_t I2c_SensWaitBusyClr(AG903_I2CMgrHandle* handle)
{
	AG903_I2CMgrReadParam 	rd;
	AG903_I2CMgrWriteParam 	wr;
	int32_t		result = -AG903_EFAULT;
	uint32_t	loop;
	uint8_t		status;

	for(loop=0; loop<10; loop++) {
		status  = 0x02;	/* Status Register */
		wr.addr = AG903_SENSOR_SADDR;
		wr.buf  = &status;
		wr.size = 1;
		wr.stop = false; /* ReStart */
		result = AG903_I2CMgrMasterWrite(handle, &wr);								/* Master Write */
		if(AG903_ENONE != result) {
			break;
		}
		result = I2c_WaitWrite(5000);
		if(AG903_ENONE != result) {
			break;
		}
		rd.addr = (AG903_SENSOR_SADDR|0x01); /* bit0FR/W */
		rd.buf  = &status;
		rd.size = 1;
		result  = AG903_I2CMgrMasterRead(handle, &rd);								/* Master Read */
		if(AG903_ENONE != result) {
			break;
		}
		result = I2c_WaitRead(5000);
		if(AG903_ENONE != result) {
			break;
		}
		if(0 == (status&0x80)) {
			result = AG903_ENONE;
			break;
		}
		sys_dlytsk(100);
	}

	return result;
}

/**
 * @brief		Write҂
 * @param[in]	timout	^CAEg[ms]
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t I2c_WaitWrite(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == I2cWriteEnd) {
			I2cWriteEnd = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

/**
 * @brief		Read҂
 * @param[in]	timout	^CAEg[ms]
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t I2c_WaitRead(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == I2cReadEnd) {
			I2cReadEnd = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

/**
 * @brief		24H12Hϊ
 * @param[in]	val		24Hl
 * @return		ret		12Hl
 * @note		Ȃ
 */
static uint8_t I2c_24Hto12H(uint8_t val)
{
	uint8_t ret=val;

	if(0x00==val) {
		/* Ȃ */
		ret = 0x12;
	}
	else {
		if(0x12<=val) {
			if((0x20==val)||(0x21==val)) {
				ret = val - 0x18;
			}
			else if(0x13<=val) {
				ret = val - 0x12;
			}
			else {
				/* Ȃ */
			}
			ret |= 0x20;
		}
	}

	return ret;
}

/**
 * @brief		12H24Hϊ
 * @param[in]	val		24Hl
 * @return		ret		12Hl
 * @note		Ȃ
 */
static uint8_t I2c_12Hto24H(uint8_t val)
{
	uint8_t ret=val;

	if(0x12==val) {
		/* Ȃ */
		ret = 0x00;
	}
	else {
		if(0x20&val) {
			val &= (~0x20);
			if((0x08==val)||(0x09==val)) {
				ret = val + 0x18;
			}
			else if(0x11>=val) {
				ret = val + 0x12;
			}
			else {
				ret = val;
			}
		}
	}

	return ret;
}

/**
 * @brief		BCDDecimalϊ
 * @param[in]	bcd		BCDl
 * @return		dec		Decimall
 * @note		Ȃ
 */
static uint8_t BCDtoDEC(uint8_t bcd)
{
	uint8_t	dec;

	dec  = (bcd>>4)*10;
	dec += (bcd&0x0F);
	return dec;
}

/**
 * @brief	R[obN (I2CCxg).
 * @param[in]	handle	I2Cnh.
 * @param[in]	event	R[obNCxg.
 * @return	Ȃ.
 * @note	Ȃ.
 */
static void I2c_CallbackEvent(AG903_I2CMgrHandle* handle, uint32_t event)
{
	((void)handle);

	if(AG903_I2C_EVENT_WRITE_END & event) {
		I2cWriteEnd=true;
	}

	if(AG903_I2C_EVENT_READ_END & event) {
		I2cReadEnd=true;
	}

	if( (AG903_I2C_EVENT_LOSES_ARBITRATION|AG903_I2C_EVENT_SEQUENCE_ERR|AG903_I2C_EVENT_WRITE_ERR|
		AG903_I2C_EVENT_READ_ERR) & event) {
		/* Ȃ */
	}

	return;
}

