/**
 * @brief           Communication Device Class Driver API Header
 * @author          AXELL CORPORATION
 * @description     Communication Device Class Driver API Header
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef __USB_CDC_API_H__
#define __USB_CDC_API_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_cdc_type.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
/* APIG[R[h */
#define CDC_BULK_TIMEOUT (5000)

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/* APIG[R[h */
/** I */
#define	USBCDC_API_SUCCESS				0
/** l */
#define	USBCDC_API_ERRCODE_BASE			(-0x0100)
/** p[^wɌ肪 */
#define	USBCDC_API_PARAM_ERROR			(USBCDC_API_ERRCODE_BASE - 1)
/** gpĂȂ */
#define	USBCDC_API_NOT_READY			(USBCDC_API_ERRCODE_BASE - 2)
/** R~jP[VfoCXڑł */
#define	USBCDC_API_NO_CDC				(USBCDC_API_ERRCODE_BASE - 3)
/** Ή̃R~jP[VfoCXڑĂ */
#define	USBCDC_API_NO_SUPPORT			(USBCDC_API_ERRCODE_BASE - 4)
/** CallBack o^Ɏ{ς */
#define	USBCDC_API_ALREADY_REGIST		(USBCDC_API_ERRCODE_BASE - 5)
/** Open Ɏ{ς */
#define	USBCDC_API_ALREADY_OPEN			(USBCDC_API_ERRCODE_BASE - 6)
/** Close Ɏ{ς */
#define	USBCDC_API_ALREADY_CLOSE		(USBCDC_API_ERRCODE_BASE - 7)
/** Open { */
#define	USBCDC_API_NOT_OPEN				(USBCDC_API_ERRCODE_BASE - 8)
/** Bulk IN vɔsς */
#define	USBCDC_API_ALREADY_START_BULKIN	(USBCDC_API_ERRCODE_BASE - 9)
/** Bulk IN vɒ~ς */
#define	USBCDC_API_ALREADY_STOP_BULKIN	(USBCDC_API_ERRCODE_BASE - 10)
/** Bulk IN obt@t */
#define	USBCDC_API_BUFF_FULL_BULKIN		(USBCDC_API_ERRCODE_BASE - 11)
/** NXNGXg̓]ŃG[ */
#define	USBCDC_API_TRANS_CLSREQ_FAILED	(USBCDC_API_ERRCODE_BASE - 12)
/** f[^]ŃG[ */
#define	USBCDC_API_TRANS_DATA_FAILED	(USBCDC_API_ERRCODE_BASE - 13)
/** f[^]ŃpCvHALTĂߓ]s(ClearFeature𔭍s) */
#define	USBCDC_API_TRANS_HALT_PIPE		(USBCDC_API_ERRCODE_BASE - 14)
/** VXe\[X(Z}tHAtOA)̃ANZXŃG[ */
#define	USBCDC_API_SYS_OUT_OF_RESOURCE	(USBCDC_API_ERRCODE_BASE - 15)
/** ̑̃VXeG[ */
#define	USBCDC_API_SYS_SYSTEM_ERROR		(USBCDC_API_ERRCODE_BASE - 16)
/** C^vg]ŃG[ */
#define	USBCDC_API_TRANS_INT_FAILED		(USBCDC_API_ERRCODE_BASE - 17)
/** Intrrupt IN vɔsς */
#define	USBCDC_API_ALREADY_START_INTIN	(USBCDC_API_ERRCODE_BASE - 18)
/** Intrrupt IN vɒ~ς */
#define	USBCDC_API_ALREADY_STOP_INTIN	(USBCDC_API_ERRCODE_BASE - 19)

/** R[obNID */
typedef enum _CDC_CALLBACK_ID {
    CBID_CDC_DEVATTACH,									/** foCXڑꂽ(gp\) */
    CBID_CDC_DEVATTACH_NOT_USE,							/** foCXڑꂽ(gps) */
    CBID_CDC_DEVDETACH									/** foCXؒfꂽ */
} CDC_CALLBACK_ID;

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/
extern PCDC_DRIVER g_pCdcDriver;

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/

#endif /* __USB_CDC_API_H__ */
