/*
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __VGEXT_AG903_H__
#define __VGEXT_AG903_H__

#include <VG/openvg.h>

typedef VGHandle VGPalette;
typedef VGHandle VGPolygon;

#define VG_EXT_BIT           0x40000000


typedef enum {
    VG_EXT_YUV422                       = (VG_EXT_BIT | 0x00000000),
    VG_EXT_LVQ88                        = (VG_EXT_BIT | 0x00000001),
    VG_EXT_LVQ84                        = (VG_EXT_BIT | 0x00000002),
    VG_EXT_LVQ88A1                      = (VG_EXT_BIT | 0x00000003),
    VG_EXT_LVQ88A4                      = (VG_EXT_BIT | 0x00000004),
    VG_EXT_PALETTE4                     = (VG_EXT_BIT | 0x00000005),
    VG_EXT_PALETTE8                     = (VG_EXT_BIT | 0x00000006),
    VG_EXT_PALETTE1                     = (VG_EXT_BIT | 0x00000007),
    VG_EXT_PALETTE2                     = (VG_EXT_BIT | 0x00000008),
    VG_EXT_sRGB_888                     = (VG_EXT_BIT | 0x00000009),
    VG_EXT_lRGB_888                     = (VG_EXT_BIT | 0x0000000A),
    VG_EXT_sBGR_888                     = (VG_EXT_BIT | 0x0000000B),
    VG_EXT_lBGR_888                     = (VG_EXT_BIT | 0x0000000C),
    VG_EXT_IMAGE_FORMAT_FORCE_SIZE      = VG_MAX_ENUM
} VGImageFormatEXT;


typedef enum {
    VG_EXT_YUV_RGB_CONVERSION           = (VG_EXT_BIT | 0x00002000),
    VG_EXT_YUV_RGB_COEFFICIENT          = (VG_EXT_BIT | 0x00002001),
    VG_EXT_RGB_YUV_COEFFICIENT          = (VG_EXT_BIT | 0x00002002),
    VG_EXT_BLEND_UNIT                   = (VG_EXT_BIT | 0x00005000),
    VG_EXT_BLEND_FUNC_SEPARATE          = (VG_EXT_BIT | 0x00005001),
    VG_EXT_BLEND_EQUATION               = (VG_EXT_BIT | 0x00005002),
    VG_EXT_BLEND_COLOR                  = (VG_EXT_BIT | 0x00005003),
    VG_EXT_BLEND_MODE_SPECIAL           = (VG_EXT_BIT | 0x00005004),
    VG_EXT_CHANNEL_MASK                 = (VG_EXT_BIT | 0x00006000),
    VG_EXT_ALTERNATE_COLOR              = (VG_EXT_BIT | 0x00007000),
    VG_EXT_SEPARATE_STROKE_CAP_STYLE       = (VG_EXT_BIT | 0x00008001),
    VG_EXT_SEPARATE_STROKE_START_CAP_STYLE = (VG_EXT_BIT | 0x00008002),
    VG_EXT_SEPARATE_STROKE_END_CAP_STYLE   = (VG_EXT_BIT | 0x00008003),
    VG_EXT_FAST_PATH_OPERATION          = (VG_EXT_BIT | 0x00008010),
    VG_EXT_FILL_BEZIER_TYPE             = (VG_EXT_BIT | 0x00008011),
    VG_EXT_STROKE_BEZIER_TYPE           = (VG_EXT_BIT | 0x00008012),
    VG_EXT_FILL_BEZIER_POW2_NUM         = (VG_EXT_BIT | 0x00008013),
    VG_EXT_STROKE_BEZIER_POW2_NUM       = (VG_EXT_BIT | 0x00008014),
    VG_EXT_DYNAMIC_MIPMAP_FOR_PATTERN = (VG_EXT_BIT | 0x00009000),
    VG_EXT_DYNAMIC_MIPMAP_FOR_DRAWIMAGE = (VG_EXT_BIT | 0x00009001),
    VG_EXT_DYNAMIC_MIPMAP_LEVEL_FOR_PATTERN         = (VG_EXT_BIT | 0x00009002),
    VG_EXT_DYNAMIC_MIPMAP_LEVEL_FOR_DRAWIMAGE         = (VG_EXT_BIT | 0x00009003),
    VG_EXT_CONVOLUTION_FILTER           = (VG_EXT_BIT | 0x0000A000),
    VG_EXT_CONVOLUTION_KERNEL           = (VG_EXT_BIT | 0x0000A001),
    VG_EXT_PPO0_CONFIG                  = (VG_EXT_BIT | 0x0000B000),
    VG_EXT_PPO1_CONFIG                  = (VG_EXT_BIT | 0x0000B001),
    VG_EXT_PPO2_CONFIG                  = (VG_EXT_BIT | 0x0000B002),
    VG_EXT_PPO3_CONFIG                  = (VG_EXT_BIT | 0x0000B003),
    VG_EXT_PPO4_CONFIG                  = (VG_EXT_BIT | 0x0000B004),
    VG_EXT_PPO5_CONFIG                  = (VG_EXT_BIT | 0x0000B005),
    VG_EXT_PPO6_CONFIG                  = (VG_EXT_BIT | 0x0000B006),
    VG_EXT_PPO7_CONFIG                  = (VG_EXT_BIT | 0x0000B007),
    VG_EXT_UNPREMULTIPLY_PIPELINE       = (VG_EXT_BIT | 0x0000C000),
    VG_EXT_POLYGON_CULLING              = (VG_EXT_BIT | 0x0000D000),
    VG_EXT_POLYGON_FRONT_FACE           = (VG_EXT_BIT | 0x0000D001),
    VG_EXT_POLYGON_CULL_FACE            = (VG_EXT_BIT | 0x0000D002),
    VG_EXT_HIDDEN_PIXEL_REMOVAL         = (VG_EXT_BIT | 0x0000F000),
    VG_EXT_PARAM_TYPE_FORCE_SIZE        = VG_MAX_ENUM
} VGParamTypeEXT;


typedef enum {
    VG_EXT_TRIANGLES                    = (VG_EXT_BIT | 0x0000E000),
    VG_EXT_QUADS                        = (VG_EXT_BIT | 0x0000E001),
} VGPolygonTypeEXT;

/* VG_EXT_BLEND_UNIT */
#define VG_EXT_BLEND_UNIT_OVG                   (VG_EXT_BIT | 0x00005100)
#define VG_EXT_BLEND_UNIT_OGL                   (VG_EXT_BIT | 0x00005101)
#define VG_EXT_BLEND_UNIT_SPECIAL               (VG_EXT_BIT | 0x00005102)

/* VG_EXT_BLEND_FUNC_SEPARATE */
#define VG_EXT_BLEND_ZERO                       (VG_EXT_BIT | 0x00005300)
#define VG_EXT_BLEND_ONE                        (VG_EXT_BIT | 0x00005301)
#define VG_EXT_BLEND_SRC_COLOR                  (VG_EXT_BIT | 0x00005302)
#define VG_EXT_BLEND_ONE_MINUS_SRC_COLOR        (VG_EXT_BIT | 0x00005303)
#define VG_EXT_BLEND_SRC_ALPHA                  (VG_EXT_BIT | 0x00005304)
#define VG_EXT_BLEND_ONE_MINUS_SRC_ALPHA        (VG_EXT_BIT | 0x00005305)
#define VG_EXT_BLEND_DST_ALPHA                  (VG_EXT_BIT | 0x00005306)
#define VG_EXT_BLEND_ONE_MINUS_DST_ALPHA        (VG_EXT_BIT | 0x00005307)
#define VG_EXT_BLEND_DST_COLOR                  (VG_EXT_BIT | 0x00005308)
#define VG_EXT_BLEND_ONE_MINUS_DST_COLOR        (VG_EXT_BIT | 0x00005309)
#define VG_EXT_BLEND_SRC_ALPHA_SATURATE         (VG_EXT_BIT | 0x0000530A)
#define VG_EXT_BLEND_CONSTANT_COLOR             (VG_EXT_BIT | 0x0000530B)
#define VG_EXT_BLEND_ONE_MINUS_CONSTANT_COLOR   (VG_EXT_BIT | 0x0000530C)
#define VG_EXT_BLEND_CONSTANT_ALPHA             (VG_EXT_BIT | 0x0000530D)
#define VG_EXT_BLEND_ONE_MINUS_CONSTANT_ALPHA   (VG_EXT_BIT | 0x0000530E)

/* VG_EXT_BLEND_EQUATION */
#define VG_EXT_BLEND_FUNC_ADD                   (VG_EXT_BIT | 0x00005400)
#define VG_EXT_BLEND_FUNC_SUBTRACT              (VG_EXT_BIT | 0x00005401)
#define VG_EXT_BLEND_FUNC_REVERSE_SUBTRACT      (VG_EXT_BIT | 0x00005402)

/* VG_EXT_BLEND_MODE_SPECIAL */
#define VG_EXT_BLEND_WHITE_OUT                  (VG_EXT_BIT | 0x00005500)

/* VG_EXT_[FILL|STROKE]_BEZIER_TYPE */
#define VG_EXT_BEZIER_TYPE_ORIG                 (VG_EXT_BIT | 0x00008100) 
#define VG_EXT_BEZIER_TYPE_DIV2                 (VG_EXT_BIT | 0x00008101) 
#define VG_EXT_BEZIER_TYPE_DIV4                 (VG_EXT_BIT | 0x00008102) 
#define VG_EXT_BEZIER_TYPE_POW2                 (VG_EXT_BIT | 0x00008103)

/* VG_EXT_POLYGON_FRONT_FACE */
#define VG_EXT_POLYGON_CCW                      (VG_EXT_BIT | 0x0000D100)
#define VG_EXT_POLYGON_CW                       (VG_EXT_BIT | 0x0000D101)
#define VG_EXT_POLYGON_FRONT                    (VG_EXT_BIT | 0x0000D102)
#define VG_EXT_POLYGON_BACK                     (VG_EXT_BIT | 0x0000D103)

/* VG_EXT_CHANNEL_MASK */
#define VG_EXT_CHANNEL_MASK_RED                 8
#define VG_EXT_CHANNEL_MASK_GREEN               4
#define VG_EXT_CHANNEL_MASK_BLUE                2
#define VG_EXT_CHANNEL_MASK_ALPHA               1

/* VG_EXT_ALTERNATE_COLOR */
#define VG_EXT_ALTERNATE_COLOR_RED              8
#define VG_EXT_ALTERNATE_COLOR_GREEN            4
#define VG_EXT_ALTERNATE_COLOR_BLUE             2
#define VG_EXT_ALTERNATE_COLOR_ALPHA            1

/* VG_EXT_YUV_RGB_CONVERSION */
#define VG_EXT_RGB2YUV_B3_U                     (0 << 30)
#define VG_EXT_RGB2YUV_B3_V                     (1 << 30)
#define VG_EXT_RGB2YUV_B3_Y0                    (2 << 30)
#define VG_EXT_RGB2YUV_B3_Y1                    (3 << 30)
#define VG_EXT_RGB2YUV_B2_U                     (0 << 28)
#define VG_EXT_RGB2YUV_B2_V                     (1 << 28)
#define VG_EXT_RGB2YUV_B2_Y0                    (2 << 28)
#define VG_EXT_RGB2YUV_B2_Y1                    (3 << 28)
#define VG_EXT_RGB2YUV_B1_U                     (0 << 26)
#define VG_EXT_RGB2YUV_B1_V                     (1 << 26)
#define VG_EXT_RGB2YUV_B1_Y0                    (2 << 26)
#define VG_EXT_RGB2YUV_B1_Y1                    (3 << 26)
#define VG_EXT_RGB2YUV_B0_U                     (0 << 24)
#define VG_EXT_RGB2YUV_B0_V                     (1 << 24)
#define VG_EXT_RGB2YUV_B0_Y0                    (2 << 24)
#define VG_EXT_RGB2YUV_B0_Y1                    (3 << 24)
#define VG_EXT_YUV2RGB_Y1_B0                    (0 << 22)
#define VG_EXT_YUV2RGB_Y1_B1                    (1 << 22)
#define VG_EXT_YUV2RGB_Y1_B2                    (2 << 22)
#define VG_EXT_YUV2RGB_Y1_B3                    (3 << 22)
#define VG_EXT_YUV2RGB_Y0_B0                    (0 << 20)
#define VG_EXT_YUV2RGB_Y0_B1                    (1 << 20)
#define VG_EXT_YUV2RGB_Y0_B2                    (2 << 20)
#define VG_EXT_YUV2RGB_Y0_B3                    (3 << 20)
#define VG_EXT_YUV2RGB_V_B0                     (0 << 18)
#define VG_EXT_YUV2RGB_V_B1                     (1 << 18)
#define VG_EXT_YUV2RGB_V_B2                     (2 << 18)
#define VG_EXT_YUV2RGB_V_B3                     (3 << 18)
#define VG_EXT_YUV2RGB_U_B0                     (0 << 16)
#define VG_EXT_YUV2RGB_U_B1                     (1 << 16)
#define VG_EXT_YUV2RGB_U_B2                     (2 << 16)
#define VG_EXT_YUV2RGB_U_B3                     (3 << 16)
#define VG_EXT_YUV_YPM                          4
#define VG_EXT_YUV_UVEM                         2
#define VG_EXT_YUV_YEM                          1

/* VGRectInfo */
typedef struct {
    void *addr;
    VGuint width;
    VGuint height;
    VGuint stride;
    VGImageFormat format;
} VGRectInfo;


#ifdef __cplusplus
extern "C" {
#endif

VG_API_CALL VGImage VG_API_ENTRY
    VGAPI(vgCreateImageEXT) (VGint format, VGint width, VGint height,
                      VGbitfield allowedQuality, const void *data) VG_API_EXIT;
VG_API_CALL VGImage VG_API_ENTRY
    VGAPI(vgCreateDirectImageEXT) (VGint format, VGint width, VGint height,
                      VGbitfield allowedQuality, const void *data, VGint stride) VG_API_EXIT;
VG_API_CALL void VG_API_ENTRY
    VGAPI(vgSetiEXT) (VGParamTypeEXT param, VGint value) VG_API_EXIT;
VG_API_CALL void VG_API_ENTRY
    VGAPI(vgSetivEXT) (VGParamTypeEXT param, VGint count, const VGint *values) VG_API_EXIT;

VG_API_CALL VGPalette VG_API_ENTRY
    VGAPI(vgCreatePaletteEXT) (VGImageFormat format, VGuint num, const VGuint *ptr) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDestroyPaletteEXT) (VGPalette palette) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgSetPaletteDataEXT) (VGPalette palette, const VGuint *ptr, VGuint start, VGuint num) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgGetPaletteDataEXT) (VGPalette palette, VGuint *ptr, VGuint start, VGuint num) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgBindPaletteEXT) (VGImage image, VGPalette palette) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgSetColorRampEXT) (VGuint ramptablenum, VGfloat *ramptable, VGuint gradientsize) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgGradientClearEXT) (VGuint start, VGuint x, VGuint y, VGuint width, VGuint height) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDrawLinesEXT) (VGint mode, VGint count, VGPathDatatype type, const void *coords) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDrawRectsEXT) (VGint count, VGPathDatatype type, const void *data,
                           VGbitfield paintModes) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDrawRoundRectsEXT) (VGint count, VGPathDatatype type, const void *data,
                                VGbitfield paintModes) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDrawPolygonEXT) (VGint count, VGPathDatatype type, const void *points,
                             VGboolean closed, VGbitfield paintModes) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDrawEllipseEXT) (VGint count, VGPathDatatype type, const void *data,
                             VGbitfield paintModes) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDrawPathEXT) (VGPathDatatype type, VGint numSegments, const VGubyte *segments,
                          const void *data, VGbitfield paintModes) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDrawPathDirectEXT) (VGPathDatatype type, VGint numSegments, VGuint dataSize, const VGubyte *segments,
                                const void *data, VGbitfield paintModes) VG_API_EXIT;

VG_API_CALL VGPolygon VG_API_ENTRY
    VGAPI(vgCreatePolygonArrayEXT) (VGPolygonTypeEXT type, VGint num, const VGfloat *vtxArray,
                                    const VGfloat *qArray, const VGfloat *uvArray) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDestroyPolygonArrayEXT) (VGPolygon polygon) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgModifyPolygonArrayEXT) (VGPolygon polygon, const VGfloat *vtxArray,
                                    const VGfloat *qArray, const VGfloat *uvArray) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgDrawPolygonArrayEXT) (VGPolygon polygon) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgExtOutPulseControlEXT) (VGuint target, VGboolean immediate) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgExtOutLevelControlEXT) (VGuint target, VGboolean immediate) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgExtInWaitControlEXT) (VGuint target) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgCopyRectEXT) (VGRectInfo *dst, VGint dx, VGint dy, VGRectInfo *src,
                          VGint sx, VGint sy, VGint width, VGint height) VG_API_EXIT;

VG_API_CALL void VG_API_ENTRY
    VGAPI(vgCopyScaleRectEXT) (VGRectInfo *dst, VGint dx, VGint dy, VGint dw, VGint dh,
                               VGRectInfo *src, VGint sx, VGint sy, VGint sw, VGint sh) VG_API_EXIT;


#ifdef __cplusplus 
} /* extern "C" */
#endif

#endif /* __VGEXT_AG903_H__ */

