/**
 * @brief           DMAC Manager Header
 * @author          AXELL CORPORATION
 * @description     DMAC Manager񋟃wb_B<p>DMAC ManagergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_05_09  [#1319]DMACMgr̈ꕔAPIDoc_o_maticɐfȂ 
 * @history         2017_10_26  Ver2.0
 * @history         2025_03_06  [SDK3.7] DMACɊ荞݃R[obNobN֐ǉ (#5756)
 *  
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */

#ifndef _DMACMGR_H_
#define _DMACMGR_H_
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

/** fBXNv^MaxN */
#define AG903_DMAC_DESC_LINK_MAX 	(16)

/** [JfBXNv^ MaxGg */
#define AG903_DMAC_LDD_ENTRY_NUM 	(32)

/** [gfBXNv^ MaxGg(ύX) */
#define AG903_DMAC_RDD_ENTRY_NUM 	(16)

/** fBXNv^TCY [oCg] */
#define AG903_DMAC_DESC_SIZE		(32)

/** TERM݃Xe[^Xrbg */
#define AG903_DMAC_INTSTS_TERM		(1<<0)

/** ABORT݃Xe[^Xrbg */
#define AG903_DMAC_INTSTS_ABORT		(1<<1)

/** WDT݃Xe[^Xrbg */
#define AG903_DMAC_INTSTS_WDT		(1<<2)

/** ERROR݃Xe[^Xrbg */
#define AG903_DMAC_INTSTS_ERROR		(1<<3)

/** DMACnh */
typedef uint32_t	AG903_DMACMgrHandle;

/** DMACԏ */
typedef struct _AG903_DMACMgrStatus
{
	uint8_t enable;		/** Enable */
	uint8_t reserve[3]; /** (폜) */
} AG903_DMACMgrStatus;

/** fBXNv^^ */
typedef struct _AG903_DMACMgrDesc
{
	uint32_t SrcAddr;	/** ]AhX */
	uint32_t DstAddr;	/** ]AhX */

	void *next;		/** fBXNv^̃|C^ */ 

	/** ControlWX^ */
	union
	{
		/** DMACnCTRL_REG WX^̃rbg` */
		struct {
			unsigned int ChWEvent : 8; /** [7:0] `l̃Cxgҋ@ */
			unsigned int WSync    : 1; /** [8] Ō̏݊̑ҋ@ */
			unsigned int ChSEvent : 3; /** [11:9] `l̃Cxg */
			unsigned int SEventEn : 1; /** [12] Cxgݒ */
			unsigned int WEventEn : 1; /** [13] Cxgҋ@ */
			unsigned int SDEn     : 1; /** [14] 2D] */
			unsigned int ExpEn    : 1; /** [15] g */
			unsigned int ChEn     : 1; /** [16] `l */
			unsigned int WDTEn    : 1; /** [17] EHb`hbO^C} */
			unsigned int DstCtrl  : 2; /** [19:18] ]o[Xg^Cv̐@ */
			unsigned int SrcCtrl  : 2; /** [21:20] ]o[Xg^Cv̐@ */
			unsigned int DstWidth : 3; /** [24:22] ]̃f[^ */
			unsigned int SrcWidth : 3; /** [27:25] ]̃f[^ */
			unsigned int TCMsk    : 1; /** [28] ^[~iJEg̃}XN */
			unsigned int SrcTcnt  : 3; /** [31:29] 1DMAnhVFCN̓]]JEgP */
		} /*__attribute__((packed))*/ st;

		uint32_t val; /** DMACnCTRL_REG WX^ */
	} Ctrl;

	/** Transfer Size */
	union
	{
		/** DMACnTRNS_SIZE_1D WX^ */
		struct {
			unsigned int TCnt : 22; /** [21:0] ݂̃fBXNv^̓]JEg */
			unsigned int      : 10;
		} /*__attribute__((packed))*/ d1;

		/** DMACnTRNS_SIZE_2D WX^ */
		struct {
			unsigned int XTCnt : 16; /** [15:0] ݂̃fBXNv^X̓]JEg */
			unsigned int YTCnt : 16; /** [31:16] ݂̃fBXNv^Y̓]JEg */
		} /*__attribute__((packed))*/ d2;

		uint32_t val; /** DMACnTRNS_SIZE_xD WX^ */
	} Trns;
	
	/** SrcDst Stride */
	union
	{
		/** DMACnSTRIDE_SRC_DST_ADDR WX^̃rbg` */
		struct {
			unsigned int SrcStride : 16; /** [15:0] ]XgChl */
			unsigned int DstStride : 16; /** [31:16] ]XgChl */
		} /*__attribute__((packed))*/ st;

		uint32_t val; /** DMACnSTRIDE_SRC_DST_ADDR WX^ */
	} Stride;

} AG903_DMACMgrDesc;

/** Configuration^ */
typedef union _AG903_DMACMgrConfig
{
	/** DMACnCFG_REG WX^̃rbg` */
	struct {
		unsigned int TCIntMsk    : 1; /** [0] ^[~iJEg荞݃}XN */
		unsigned int ErrIntMsk   : 1; /** [1] `lG[荞݃}XN */
		unsigned int AbtIntMsk   : 1; /** [2] `lA{[g荞݃}XN */
		unsigned int SrcRS       : 4; /** [6:3] ]nhVFCNṽ\[X */
		unsigned int SrcHEn      : 1; /** [7] ]nhVFCN */
		unsigned int             : 1;
		unsigned int DstRS       : 4; /** [12:9] ]nhVFCNṽ\[X */
		unsigned int DstHEn      : 1; /** [13] ]nhVFCN */
		unsigned int             : 2;
		unsigned int LLPCnt      : 4; /** [19:16] NXg|C^JE^ */
		unsigned int ChGntWin    : 8; /** [27:20] `lA[rg[VEBhẼR}h */
		unsigned int ChPri       : 1; /** [28] `lA[rg[VD揇 */
		unsigned int             : 1;
		unsigned int WOMode      : 1; /** [30] ݐp[h */
		unsigned int UnalignMode : 1; /** [31] AC][h */
	} /*__attribute__((packed))*/ st;
	uint32_t val; /** DMACnCFG_REG WX^ */

} AG903_DMACMgrConfig;



int32_t AG903_DMACMgrGetHandle(int ch, AG903_DMACMgrHandle **handle);
int32_t AG903_DMACMgrReleaseHandle(AG903_DMACMgrHandle *handle);
int32_t AG903_DMACMgrGetIntStatus(AG903_DMACMgrHandle *handle, uint32_t *status);
int32_t AG903_DMACMgrClearInt(AG903_DMACMgrHandle *handle, uint32_t clrbit);
int32_t AG903_DMACMgrSetIntCallback(AG903_DMACMgrHandle *handle,
 void (*cb_term)(AG903_DMACMgrHandle*, AG903_DMACMgrDesc**, uint8_t*),
 void (*cb_abt)(AG903_DMACMgrHandle*),
 void (*cb_error)(AG903_DMACMgrHandle*));
int32_t AG903_DMACMgrUnsetIntCallback(AG903_DMACMgrHandle *handle);
int32_t AG903_DMACMgrEnable(AG903_DMACMgrHandle *handle);
int32_t AG903_DMACMgrAbort(AG903_DMACMgrHandle *handle);
int32_t AG903_DMACMgrSetSyncPeripheral(int port, int val);
int32_t AG903_DMACMgrSetWatchdog(int val);
int32_t AG903_DMACMgrSetConstantValue(uint32_t val);
int32_t AG903_DMACMgrSetEvent(int id);
int32_t AG903_DMACMgrClearEvent(int id);
int32_t AG903_DMACMgrGetEvent(int id, uint8_t *val);
int32_t AG903_DMACMgrSetSimpleTrnsDesc(AG903_DMACMgrHandle *handle, void *from, uint32_t from_size, void *to);
int32_t AG903_DMACMgrSetDescList(AG903_DMACMgrHandle *handle, AG903_DMACMgrConfig *config, AG903_DMACMgrDesc *desc_list, int list_num);
int32_t AG903_DMACMgrRemoveDescList(AG903_DMACMgrHandle *handle);
int32_t AG903_DMACMgrSetRemoteDescAddr(void *addr);
int32_t AG903_DMACMgrClearRemoteDescAddr(void);
int32_t AG903_DMACMgrGetStatus(AG903_DMACMgrHandle *handle, AG903_DMACMgrStatus *status);

#ifdef __cplusplus
}
#endif
#endif
