/**
 * @brief           VOD Primitive
 * @author          AXELL CORPORATION
 * @description     VOD Primitive Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __VODPRM_H__
#define __VODPRM_H__
/* DOM-IGNORE-END */

#include "register/AG903_vodreg.h"

#ifdef __cplusplus
extern "C" {
#endif

/** VODnMODWX^̐ݒl󂯓np\ */
typedef struct _VODPrmParamMOD {
	uint32_t dp;        /** [0]     dp rbg̒l */
	uint32_t vp;        /** [1]     vp rbg̒l */
	uint32_t hp;        /** [2]     hp rbg̒l */
	uint32_t fp;        /** [3]     fp rbg̒l */
	uint32_t cdp;       /** [4]     cdp rbg̒l */
	uint32_t dex;       /** [8]     dex rbg̒l */
	uint32_t vex;       /** [9]     vex rbg̒l */
	uint32_t hex;       /** [10]    hex rbg̒l */
	uint32_t fex;       /** [11]    fex rbg̒l */
	uint32_t cdex;      /** [12]    cdex rbg̒l */
	uint32_t pex;       /** [13]    pex rbg̒l */
	uint32_t cp;        /** [16]    cp rbg̒l */
	uint32_t code;      /** [17]    code rbg̒l */
	uint32_t yuv;       /** [18]    yuv rbg̒l */
	uint32_t fmt;       /** [25:24] fmt rbg̒l */
	uint32_t ct0;       /** [26]    ct0 rbg̒l */
	uint32_t ct1;       /** [27]    ct1 rbg̒l */
}VODPrmParamMOD;

/* ֐vg^Cv */
void AG903_VODPrmGetPORTSEL(uint8_t ch, uint32_t *portsel);
void AG903_VODPrmSetPORTSEL(uint8_t ch, uint32_t portsel);
void AG903_VODPrmGetMOD(uint8_t ch, VODPrmParamMOD *mod);
void AG903_VODPrmSetMOD(uint8_t ch, VODPrmParamMOD *mod);
void AG903_VODPrmGetBPWRMOD(uint8_t ch, uint32_t *en, uint32_t *unit);
void AG903_VODPrmSetBPWRMOD(uint8_t ch, uint32_t en, uint32_t unit);
void AG903_VODPrmGetPPWRONCNT(uint8_t ch, uint32_t *cnt);
void AG903_VODPrmSetPPWRONCNT(uint8_t ch, uint32_t cnt);
void AG903_VODPrmGetBPWRONCNT(uint8_t ch, uint32_t *cnt);
void AG903_VODPrmSetBPWRONCNT(uint8_t ch, uint32_t cnt);
void AG903_VODPrmGetBLGTONCNT(uint8_t ch, uint32_t *cnt);
void AG903_VODPrmSetBLGTONCNT(uint8_t ch, uint32_t cnt);
void AG903_VODPrmGetPPWROFFCNT(uint8_t ch, uint32_t *cnt);
void AG903_VODPrmSetPPWROFFCNT(uint8_t ch, uint32_t cnt);
void AG903_VODPrmGetBPWROFFCNT(uint8_t ch, uint32_t *cnt);
void AG903_VODPrmSetBPWROFFCNT(uint8_t ch, uint32_t cnt);
void AG903_VODPrmGetBLGTOFFCNT(uint8_t ch, uint32_t *cnt);
void AG903_VODPrmSetBLGTOFFCNT(uint8_t ch, uint32_t cnt);
void AG903_VODPrmGetPWMPERIOD(uint8_t ch, uint32_t *period);
void AG903_VODPrmSetPWMPERIOD(uint8_t ch, uint32_t period);
void AG903_VODPrmGetPWMCNT(uint8_t ch, uint32_t *cnt);
void AG903_VODPrmSetPWMCNT(uint8_t ch, uint32_t cnt);
void AG903_VODPrmGetSTAT(uint8_t ch, uint32_t *state);
void AG903_VODPrmGetMACRO0(uint32_t *fr, uint32_t *pm, uint32_t *pdx);
void AG903_VODPrmSetMACRO0(uint32_t fr, uint32_t pm, uint32_t pdx);
void AG903_VODPrmGetMACRO1(uint32_t *fr, uint32_t *pm, uint32_t *pdx);
void AG903_VODPrmSetMACRO1(uint32_t fr, uint32_t pm, uint32_t pdx);

#ifdef __cplusplus
}
#endif

#endif/* __VODPRM_H__ */
