/**
 * @brief           PGP Register Definition
 * @author          AXELL CORPORATION
 * @description     PGP Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_PGP_REGMAP_H_
#define _AG903_PGP_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** PGPn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __O  uint32_t  CMD;

        struct {
            __O  uint32_t  CMD                            :  4;
        } CMD_bits;
    };

    union {
        __I  uint32_t  STATE;

        struct {
            __I  uint32_t  ST                             :  4;
            __I  uint32_t  SST                            :  4;
            __I  uint32_t  QUEUE                          :  2;
                 uint32_t                                 :  2;
            __I  uint32_t  VRMACC                         :  1;
            __I  uint32_t  BLANK                          :  1;
        } STATE_bits;
    };

    union {
        __IO uint32_t  INTCTRLI;

        struct {
            __IO uint32_t  LINE                           : 13;
                 uint32_t                                 :  3;
            __IO uint32_t  FCNT                           :  4;
            __IO uint32_t  FIELD                          :  2;
        } INTCTRLI_bits;
    };

    union {
        __IO uint32_t  INTCTRLO;

        struct {
            __IO uint32_t  LINE                           : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  FCNT                           :  4;
            __IO uint32_t  FIELD                          :  2;
        } INTCTRLO_bits;
    };

    union {
        __IO uint32_t  INTEN;

        struct {
            __IO uint32_t  VLINEI                         :  1;
            __IO uint32_t  VSYNCI                         :  1;
            __IO uint32_t  VLINEO                         :  1;
            __IO uint32_t  VSYNCO                         :  1;
            __IO uint32_t  HGMCPL                         :  1;
            __IO uint32_t  HGMICPL                        :  1;
            __IO uint32_t  LBLCPL                         :  1;
            __IO uint32_t  LBLCRPT                        :  1;
            __IO uint32_t  IFCOFM                         :  1;
            __IO uint32_t  IFCOFS                         :  1;
            __IO uint32_t  VOOFLW                         :  1;
            __IO uint32_t  VOICPL                         :  1;
            __IO uint32_t  ND                             :  1;
        } INTEN_bits;
    };

    union {
        __I  uint32_t  INTSTAT;

        struct {
            __I  uint32_t  VLINEI                         :  1;
            __I  uint32_t  VSYNCI                         :  1;
            __I  uint32_t  VLINEO                         :  1;
            __I  uint32_t  VSYNCO                         :  1;
            __I  uint32_t  HGMCPL                         :  1;
            __I  uint32_t  HGMICPL                        :  1;
            __I  uint32_t  LBLCPL                         :  1;
            __I  uint32_t  LBLCRPT                        :  1;
            __I  uint32_t  IFCOFM                         :  1;
            __I  uint32_t  IFCOFS                         :  1;
            __I  uint32_t  VOOFLW                         :  1;
            __I  uint32_t  VOICPL                         :  1;
            __I  uint32_t  ND                             :  1;
        } INTSTAT_bits;
    };

    union {
        __O  uint32_t  INTCLR;

        struct {
            __O  uint32_t  VLINEI                         :  1;
            __O  uint32_t  VSYNCI                         :  1;
            __O  uint32_t  VLINEO                         :  1;
            __O  uint32_t  VSYNCO                         :  1;
            __O  uint32_t  HGMCPL                         :  1;
            __O  uint32_t  HGMICPL                        :  1;
            __O  uint32_t  LBLCPL                         :  1;
            __O  uint32_t  LBLCRPT                        :  1;
            __O  uint32_t  IFCOFM                         :  1;
            __O  uint32_t  IFCOFS                         :  1;
            __O  uint32_t  VOOFLW                         :  1;
            __O  uint32_t  VOICPL                         :  1;
            __O  uint32_t  ND                             :  1;
        } INTCLR_bits;
    };

    union {
        __IO uint32_t  TRGCTRLI;

        struct {
            __IO uint32_t  LINE                           : 13;
                 uint32_t                                 :  3;
            __IO uint32_t  FCNT                           :  4;
            __IO uint32_t  FIELD                          :  2;
        } TRGCTRLI_bits;
    };

    union {
        __IO uint32_t  TRGCTRLO;

        struct {
            __IO uint32_t  LINE                           : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  FCNT                           :  4;
            __IO uint32_t  FIELD                          :  2;
        } TRGCTRLO_bits;
    };

    union {
        __IO uint32_t  TRGEN;

        struct {
            __IO uint32_t  VLINEI                         :  1;
            __IO uint32_t  VSYNCI                         :  1;
            __IO uint32_t  VLINEO                         :  1;
            __IO uint32_t  VSYNCO                         :  1;
        } TRGEN_bits;
    };

    union {
        __IO uint32_t  INCTRL;

        struct {
            __IO uint32_t  FMT                            :  3;
                 uint32_t                                 :  5;
            __IO uint32_t  SEL                            :  4;
                 uint32_t                                 :  4;
            __IO uint32_t  TRG                            :  3;
                 uint32_t                                 :  5;
            __IO uint32_t  TICK                           :  1;
            __IO uint32_t  MD                             :  2;
                 uint32_t                                 :  1;
            __IO uint32_t  HDLY                           :  3;
        } INCTRL_bits;
    };

    union {
        __IO uint32_t  FUNCCTRL;

        struct {
            __IO uint32_t  NRF                            :  1;
            __IO uint32_t  CSC1                           :  1;
            __IO uint32_t  SCALE                          :  1;
            __IO uint32_t  SPF                            :  1;
            __IO uint32_t  HSV1                           :  1;
            __IO uint32_t  DGC                            :  1;
            __IO uint32_t  THR                            :  1;
            __IO uint32_t  IFC                            :  1;
            __IO uint32_t  IFCODR                         :  1;
            __IO uint32_t  OUT                            :  1;
        } FUNCCTRL_bits;
    };

    union {
        __IO uint32_t  SIZE;

        struct {
            __IO uint32_t  HSIZE                          : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  VSIZE                          : 12;
        } SIZE_bits;
    };

    union {
        __IO uint32_t  POS;

        struct {
            __IO uint32_t  HPOS                           : 13;
                 uint32_t                                 :  3;
            __IO uint32_t  VPOS                           : 13;
            __IO uint32_t  SCAN                           :  1;
            __IO uint32_t  OPOS                           :  1;
            __IO uint32_t  EPOS                           :  1;
        } POS_bits;
    };

    union {
        __IO uint32_t  OUTCTRL0;

        struct {
            __IO uint32_t  FMT                            :  4;
            __IO uint32_t  MD                             :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  SWAP1                          :  1;
            __IO uint32_t  SWAP4                          :  1;
            __IO uint32_t  SWAPH                          :  1;
            __IO uint32_t  SWAPW                          :  1;
            __IO uint32_t  DIM                            :  1;
            __IO uint32_t  SCAN                           :  1;
            __IO uint32_t  BMU                            :  2;
            __IO uint32_t  DTH                            :  1;
            __IO uint32_t  FAI                            :  1;
            __IO uint32_t  LIMIT                          :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  PAD                            :  8;
        } OUTCTRL0_bits;
    };

    union {
        __IO uint32_t  OUTCTRL1;

        struct {
            __IO uint32_t  BE                             :  1;
            __IO uint32_t  GE                             :  1;
            __IO uint32_t  RE                             :  1;
        } OUTCTRL1_bits;
    };

    union {
        __IO uint32_t  OUTBASE;

        struct {
                 uint32_t                                 :  3;
            __IO uint32_t  ADR                            : 29;
        } OUTBASE_bits;
    };

    union {
        __IO uint32_t  OUTHSIZE;

        struct {
            __IO uint32_t  HSIZE                          : 14;
        } OUTHSIZE_bits;
    };

    __I  uint32_t  RESERVED1[6];

    union {
        __I  uint32_t  FAIVAL0;
    };

    union {
        __I  uint32_t  FAIVAL1;

        struct {
            __I  uint32_t  FNUM                           : 16;
            __I  uint32_t  PORT                           :  3;
            __I  uint32_t  FIELD                          :  1;
        } FAIVAL1_bits;
    };

    __I  uint32_t  RESERVED2[6];

    union {
        __IO uint32_t  IPCPRM;

        struct {
            __IO uint32_t  BLKC                           :  8;
            __IO uint32_t  BLKY                           :  8;
            __IO uint32_t  LIMIT                          :  1;
        } IPCPRM_bits;
    };

    __I  uint32_t  RESERVED3[1];

    union {
        __IO uint32_t  CSC1CTRL;

        struct {
            __IO uint32_t  SFT                            :  4;
            __IO uint32_t  LIMIT                          :  1;
        } CSC1CTRL_bits;
    };

    union {
        __IO uint32_t  CSC1PRM0;

        struct {
            __IO uint32_t  M11                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  M12                            : 12;
        } CSC1PRM0_bits;
    };

    union {
        __IO uint32_t  CSC1PRM1;

        struct {
            __IO uint32_t  M13                            : 12;
        } CSC1PRM1_bits;
    };

    union {
        __IO uint32_t  CSC1PRM2;

        struct {
            __IO uint32_t  M14                            : 20;
        } CSC1PRM2_bits;
    };

    union {
        __IO uint32_t  CSC1PRM3;

        struct {
            __IO uint32_t  M21                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  M22                            : 12;
        } CSC1PRM3_bits;
    };

    union {
        __IO uint32_t  CSC1PRM4;

        struct {
            __IO uint32_t  M23                            : 12;
        } CSC1PRM4_bits;
    };

    union {
        __IO uint32_t  CSC1PRM5;

        struct {
            __IO uint32_t  M24                            : 20;
        } CSC1PRM5_bits;
    };

    union {
        __IO uint32_t  CSC1PRM6;

        struct {
            __IO uint32_t  M31                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  M32                            : 12;
        } CSC1PRM6_bits;
    };

    union {
        __IO uint32_t  CSC1PRM7;

        struct {
            __IO uint32_t  M33                            : 12;
        } CSC1PRM7_bits;
    };

    union {
        __IO uint32_t  CSC1PRM8;

        struct {
            __IO uint32_t  M34                            : 20;
        } CSC1PRM8_bits;
    };

    union {
        __IO uint32_t  SCCTRL;

        struct {
            __IO uint32_t  DNMH                           :  4;
            __IO uint32_t  NMRH                           :  4;
            __IO uint32_t  DNMV                           :  4;
            __IO uint32_t  NMRV                           :  4;
            __IO uint32_t  MTD                            :  1;
            __IO uint32_t  LIMIT                          :  1;
        } SCCTRL_bits;
    };

    __I  uint32_t  RESERVED4[19];

    union {
        __IO uint32_t  SPFCTRL;

        struct {
            __IO uint32_t  B                              :  8;
            __IO uint32_t  G                              :  8;
            __IO uint32_t  R                              :  8;
            __IO uint32_t  BC                             :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  SFT                            :  4;
        } SPFCTRL_bits;
    };

    union {
        __IO uint32_t  SPFPRM0;

        struct {
            __IO uint32_t  HMM                            :  8;
            __IO uint32_t  H0M                            :  8;
            __IO uint32_t  H1M                            :  8;
        } SPFPRM0_bits;
    };

    union {
        __IO uint32_t  SPFPRM1;

        struct {
            __IO uint32_t  HM0                            :  8;
            __IO uint32_t  H00                            :  8;
            __IO uint32_t  H10                            :  8;
        } SPFPRM1_bits;
    };

    union {
        __IO uint32_t  SPFPRM2;

        struct {
            __IO uint32_t  HM1                            :  8;
            __IO uint32_t  H01                            :  8;
            __IO uint32_t  H11                            :  8;
        } SPFPRM2_bits;
    };

    union {
        __IO uint32_t  SPFPRM3;

        struct {
            __IO uint32_t  OFS                            :  9;
        } SPFPRM3_bits;
    };

    union {
        __IO uint32_t  HSV1CTRL;

        struct {
            __IO uint32_t  FMT                            :  1;
        } HSV1CTRL_bits;
    };

    union {
        __I  uint32_t  DGCSTAT;

        struct {
            __I  uint32_t  QUEUE                          :  3;
        } DGCSTAT_bits;
    };

    union {
        __O  uint32_t  HGMCMD;

        struct {
            __O  uint32_t  CMD                            :  3;
        } HGMCMD_bits;
    };

    union {
        __IO uint32_t  HGMCTRL;

        struct {
            __IO uint32_t  HINC                           :  4;
            __IO uint32_t  VINC                           :  4;
            __IO uint32_t  SFT                            :  4;
            __IO uint32_t  THR                            :  4;
            __IO uint32_t  EXC                            :  2;
            __IO uint32_t  BMU                            :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  INV                            :  4;
        } HGMCTRL_bits;
    };

    union {
        __IO uint32_t  HGMSIZE;

        struct {
            __IO uint32_t  HSIZE                          : 10;
                 uint32_t                                 :  6;
            __IO uint32_t  VSIZE                          : 10;
        } HGMSIZE_bits;
    };

    union {
        __IO uint32_t  HGMPOS;

        struct {
            __IO uint32_t  HPOS                           : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  VPOS                           : 12;
        } HGMPOS_bits;
    };

    union {
        __IO uint32_t  HGMDST;

        struct {
                 uint32_t                                 :  3;
            __IO uint32_t  ADR                            : 29;
        } HGMDST_bits;
    };

    union {
        __I  uint32_t  HGMMOD0;

        struct {
            __I  uint32_t  CNT                            : 16;
            __I  uint32_t  VAL                            :  8;
            __I  uint32_t  BW                             :  5;
        } HGMMOD0_bits;
    };

    union {
        __I  uint32_t  HGMRNG0;

        struct {
            __I  uint32_t  MINVAL                         :  8;
            __I  uint32_t  MAXVAL                         :  8;
        } HGMRNG0_bits;
    };

    union {
        __I  uint32_t  HGMMOD1;

        struct {
            __I  uint32_t  CNT                            : 16;
            __I  uint32_t  VAL                            :  8;
            __I  uint32_t  BW                             :  5;
        } HGMMOD1_bits;
    };

    union {
        __I  uint32_t  HGMRNG1;

        struct {
            __I  uint32_t  MINVAL                         :  8;
            __I  uint32_t  MAXVAL                         :  8;
        } HGMRNG1_bits;
    };

    union {
        __I  uint32_t  HGMMOD2;

        struct {
            __I  uint32_t  CNT                            : 16;
            __I  uint32_t  VAL                            :  8;
            __I  uint32_t  BW                             :  5;
        } HGMMOD2_bits;
    };

    union {
        __I  uint32_t  HGMRNG2;

        struct {
            __I  uint32_t  MINVAL                         :  8;
            __I  uint32_t  MAXVAL                         :  8;
        } HGMRNG2_bits;
    };

    union {
        __I  uint32_t  HGMSTAT;

        struct {
            __I  uint32_t  CMD                            :  3;
                 uint32_t                                 :  1;
            __I  uint32_t  QUEUE                          :  2;
            __I  uint32_t  ACT                            :  1;
            __I  uint32_t  VRMACC                         :  1;
            __I  uint32_t  INIT                           :  1;
        } HGMSTAT_bits;
    };

    union {
        __IO uint32_t  THRCTRL;

        struct {
            __IO uint32_t  C8SEL                          :  2;
            __IO uint32_t  OUTSEL                         :  2;
            __IO uint32_t  THR8                           :  1;
            __IO uint32_t  HSV2                           :  1;
            __IO uint32_t  CSC2                           :  1;
            __IO uint32_t  MSK                            :  1;
            __IO uint32_t  SPF1                           :  1;
            __IO uint32_t  LIMIT                          :  1;
        } THRCTRL_bits;
    };

    union {
        __IO uint32_t  HSV2CTRL;

        struct {
            __IO uint32_t  FMT                            :  1;
        } HSV2CTRL_bits;
    };

    union {
        __IO uint32_t  CSC2CTRL;

        struct {
            __IO uint32_t  SFT                            :  4;
            __IO uint32_t  LIMIT                          :  1;
        } CSC2CTRL_bits;
    };

    union {
        __IO uint32_t  CSC2PRM0;

        struct {
            __IO uint32_t  M11                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  M12                            : 12;
        } CSC2PRM0_bits;
    };

    union {
        __IO uint32_t  CSC2PRM1;

        struct {
            __IO uint32_t  M13                            : 12;
        } CSC2PRM1_bits;
    };

    union {
        __IO uint32_t  CSC2PRM2;

        struct {
            __IO uint32_t  M14                            : 20;
        } CSC2PRM2_bits;
    };

    union {
        __IO uint32_t  CSC2PRM3;

        struct {
            __IO uint32_t  M21                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  M22                            : 12;
        } CSC2PRM3_bits;
    };

    union {
        __IO uint32_t  CSC2PRM4;

        struct {
            __IO uint32_t  M23                            : 12;
        } CSC2PRM4_bits;
    };

    union {
        __IO uint32_t  CSC2PRM5;

        struct {
            __IO uint32_t  M24                            : 20;
        } CSC2PRM5_bits;
    };

    union {
        __IO uint32_t  CSC2PRM6;

        struct {
            __IO uint32_t  M31                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  M32                            : 12;
        } CSC2PRM6_bits;
    };

    union {
        __IO uint32_t  CSC2PRM7;

        struct {
            __IO uint32_t  M33                            : 12;
        } CSC2PRM7_bits;
    };

    union {
        __IO uint32_t  CSC2PRM8;

        struct {
            __IO uint32_t  M34                            : 20;
        } CSC2PRM8_bits;
    };

    union {
        __IO uint32_t  MSK0PRM0;

        struct {
            __IO uint32_t  X                              :  1;
            __IO uint32_t  L                              :  1;
            __IO uint32_t  H                              :  1;
        } MSK0PRM0_bits;
    };

    union {
        __IO uint32_t  MSK0PRM1;

        struct {
            __IO uint32_t  LMIN                           :  8;
            __IO uint32_t  LMAX                           :  8;
            __IO uint32_t  HMIN                           :  8;
            __IO uint32_t  HMAX                           :  8;
        } MSK0PRM1_bits;
    };

    union {
        __IO uint32_t  MSK1PRM0;

        struct {
            __IO uint32_t  X                              :  1;
            __IO uint32_t  L                              :  1;
            __IO uint32_t  H                              :  1;
        } MSK1PRM0_bits;
    };

    union {
        __IO uint32_t  MSK1PRM1;

        struct {
            __IO uint32_t  LMIN                           :  8;
            __IO uint32_t  LMAX                           :  8;
            __IO uint32_t  HMIN                           :  8;
            __IO uint32_t  HMAX                           :  8;
        } MSK1PRM1_bits;
    };

    union {
        __IO uint32_t  MSK2PRM0;

        struct {
            __IO uint32_t  X                              :  1;
            __IO uint32_t  L                              :  1;
            __IO uint32_t  H                              :  1;
        } MSK2PRM0_bits;
    };

    union {
        __IO uint32_t  MSK2PRM1;

        struct {
            __IO uint32_t  LMIN                           :  8;
            __IO uint32_t  LMAX                           :  8;
            __IO uint32_t  HMIN                           :  8;
            __IO uint32_t  HMAX                           :  8;
        } MSK2PRM1_bits;
    };

    union {
        __IO uint32_t  THR8PRM0;

        struct {
            __IO uint32_t  MINTHR                         :  8;
            __IO uint32_t  MAXTHR                         :  8;
            __IO uint32_t  MAXVAL                         :  8;
            __IO uint32_t  TYPE                           :  4;
        } THR8PRM0_bits;
    };

    union {
        __IO uint32_t  THR8PRM1;

        struct {
            __IO uint32_t  MINTHR                         :  8;
            __IO uint32_t  MAXTHR                         :  8;
            __IO uint32_t  MAXVAL                         :  8;
            __IO uint32_t  TYPE                           :  4;
        } THR8PRM1_bits;
    };

    union {
        __IO uint32_t  THR8PRM2;

        struct {
            __IO uint32_t  MINTHR                         :  8;
            __IO uint32_t  MAXTHR                         :  8;
            __IO uint32_t  MAXVAL                         :  8;
            __IO uint32_t  TYPE                           :  4;
        } THR8PRM2_bits;
    };

    union {
        __IO uint32_t  THR1PRM0;

        struct {
            __IO uint32_t  X                              :  1;
            __IO uint32_t  L                              :  1;
            __IO uint32_t  H                              :  1;
        } THR1PRM0_bits;
    };

    union {
        __IO uint32_t  THR1PRM1;

        struct {
            __IO uint32_t  LMIN                           :  8;
            __IO uint32_t  LMAX                           :  8;
            __IO uint32_t  HMIN                           :  8;
            __IO uint32_t  HMAX                           :  8;
        } THR1PRM1_bits;
    };

    union {
        __IO uint32_t  SPF1PRM0;

        struct {
            __IO uint32_t  HMM                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  H0M                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  H1M                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  HM0                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  H00                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  H10                            :  3;
        } SPF1PRM0_bits;
    };

    union {
        __IO uint32_t  SPF1PRM1;

        struct {
            __IO uint32_t  HM1                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  H01                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  H11                            :  3;
                 uint32_t                                 :  5;
            __IO uint32_t  THR                            :  6;
        } SPF1PRM1_bits;
    };

    union {
        __I  uint32_t  THR1CNT;

        struct {
            __I  uint32_t  CNT                            : 24;
        } THR1CNT_bits;
    };

    union {
        __O  uint32_t  LBLCMD;

        struct {
            __O  uint32_t  CMD                            :  3;
        } LBLCMD_bits;
    };

    union {
        __IO uint32_t  LBLCTRL;

        struct {
            __IO uint32_t  MAXID                          :  8;
            __IO uint32_t  FLTHR                          :  8;
            __IO uint32_t  BMU                            :  1;
            __IO uint32_t  CNCT                           :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  INV                            :  4;
            __IO uint32_t  VLD                            :  4;
        } LBLCTRL_bits;
    };

    union {
        __IO uint32_t  LBLSIZE;

        struct {
            __IO uint32_t  HSIZE                          : 10;
                 uint32_t                                 :  6;
            __IO uint32_t  VSIZE                          : 10;
        } LBLSIZE_bits;
    };

    union {
        __IO uint32_t  LBLPOS;

        struct {
            __IO uint32_t  HPOS                           : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  VPOS                           : 12;
        } LBLPOS_bits;
    };

    union {
        __IO uint32_t  LBLDST;

        struct {
                 uint32_t                                 :  3;
            __IO uint32_t  ADR                            : 29;
        } LBLDST_bits;
    };

    union {
        __I  uint32_t  LBLSTAT;

        struct {
            __I  uint32_t  CMD                            :  3;
                 uint32_t                                 :  1;
            __I  uint32_t  QUEUE                          :  2;
            __I  uint32_t  ACT                            :  1;
            __I  uint32_t  VRMACC                         :  1;
            __I  uint32_t  ID                             :  8;
        } LBLSTAT_bits;
    };

    union {
        __O  uint32_t  IFCCMD;

        struct {
            __O  uint32_t  CMD                            :  3;
        } IFCCMD_bits;
    };

    union {
        __IO uint32_t  IFCCTRL;

        struct {
            __IO uint32_t  SFT0                           :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  SFT1                           :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  OP                             :  3;
                 uint32_t                                 :  5;
            __IO uint32_t  SRC                            :  2;
            __IO uint32_t  LIMIT                          :  2;
            __IO uint32_t  SCAN                           :  1;
        } IFCCTRL_bits;
    };

    union {
        __IO uint32_t  IFCPRM;

        struct {
            __IO uint32_t  GAIN0                          :  8;
            __IO uint32_t  GAIN1                          :  8;
        } IFCPRM_bits;
    };

/* DOM-IGNORE-END */
}AG903_PGPn_Type;

/** PGPVIn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __O  uint32_t  CMD;

        struct {
            __O  uint32_t  CMD                            :  4;
        } CMD_bits;
    };

    union {
        __I  uint32_t  STATE;

        struct {
            __I  uint32_t  ST                             :  4;
                 uint32_t                                 :  4;
            __I  uint32_t  QUEUE                          :  2;
                 uint32_t                                 :  2;
            __I  uint32_t  VRMACC                         :  1;
        } STATE_bits;
    };

    union {
        __IO uint32_t  CTRL0;

        struct {
            __IO uint32_t  FMT                            :  4;
            __IO uint32_t  MD                             :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  SWAP1                          :  1;
            __IO uint32_t  SWAP4                          :  1;
            __IO uint32_t  SWAPH                          :  1;
            __IO uint32_t  SWAPW                          :  1;
            __IO uint32_t  DIM                            :  1;
            __IO uint32_t  SCAN                           :  1;
            __IO uint32_t  BMU                            :  2;
                 uint32_t                                 :  1;
            __IO uint32_t  FAI                            :  1;
        } CTRL0_bits;
    };

    union {
        __IO uint32_t  CTRL1;

        struct {
            __IO uint32_t  INV                            :  4;
            __IO uint32_t  VLD                            :  4;
            __IO uint32_t  DIV                            :  8;
        } CTRL1_bits;
    };

    union {
        __IO uint32_t  BASE;

        struct {
                 uint32_t                                 :  3;
            __IO uint32_t  ADR                            : 29;
        } BASE_bits;
    };

    union {
        __IO uint32_t  HSIZE;

        struct {
            __IO uint32_t  HSIZE                          : 14;
        } HSIZE_bits;
    };

    union {
        __IO uint32_t  HPRM0;

        struct {
            __IO uint32_t  HPW                            : 12;
        } HPRM0_bits;
    };

    union {
        __IO uint32_t  HPRM1;

        struct {
            __IO uint32_t  HBP                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  HFP                            : 12;
        } HPRM1_bits;
    };

    union {
        __IO uint32_t  VPRM0;

        struct {
            __IO uint32_t  VPW                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  OFP                            :  1;
            __IO uint32_t  OBP                            :  1;
            __IO uint32_t  EFP                            :  1;
            __IO uint32_t  EBP                            :  1;
        } VPRM0_bits;
    };

    union {
        __IO uint32_t  VPRM1;

        struct {
            __IO uint32_t  VBP                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  VFP                            : 12;
        } VPRM1_bits;
    };

    union {
        __IO uint32_t  SIZE;

        struct {
            __IO uint32_t  HSIZE                          : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  VSIZE                          : 12;
            __IO uint32_t  OVSIZE                         :  1;
        } SIZE_bits;
    };

/* DOM-IGNORE-END */
}AG903_PGPVIn_Type;

/** PGP Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  JPGOUTSEL;

        struct {
            __IO uint32_t  SEL                            :  3;
            __IO uint32_t  EN                             :  1;
        } JPGOUTSEL_bits;
    };

/* DOM-IGNORE-END */
}AG903_PGP_Type;

/** PGP0DGC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  LUTB[64];

        struct {
            __IO uint32_t  B0                             :  8;
            __IO uint32_t  B1                             :  8;
            __IO uint32_t  B2                             :  8;
            __IO uint32_t  B3                             :  8;
        } LUTB_bits[64];
    };

    union {
        __IO uint32_t  LUTG[64];

        struct {
            __IO uint32_t  G0                             :  8;
            __IO uint32_t  G1                             :  8;
            __IO uint32_t  G2                             :  8;
            __IO uint32_t  G3                             :  8;
        } LUTG_bits[64];
    };

    union {
        __IO uint32_t  LUTR[64];

        struct {
            __IO uint32_t  R0                             :  8;
            __IO uint32_t  R1                             :  8;
            __IO uint32_t  R2                             :  8;
            __IO uint32_t  R3                             :  8;
        } LUTR_bits[64];
    };

/* DOM-IGNORE-END */
}AG903_PGP0DGC_Type;

/** PGP0DGCF Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __O  uint32_t  LUTB[64];

        struct {
            __O  uint32_t  B0                             :  8;
            __O  uint32_t  B1                             :  8;
            __O  uint32_t  B2                             :  8;
            __O  uint32_t  B3                             :  8;
        } LUTB_bits[64];
    };

    union {
        __O  uint32_t  LUTG[64];

        struct {
            __O  uint32_t  G0                             :  8;
            __O  uint32_t  G1                             :  8;
            __O  uint32_t  G2                             :  8;
            __O  uint32_t  G3                             :  8;
        } LUTG_bits[64];
    };

    union {
        __O  uint32_t  LUTR[64];

        struct {
            __O  uint32_t  R0                             :  8;
            __O  uint32_t  R1                             :  8;
            __O  uint32_t  R2                             :  8;
            __O  uint32_t  R3                             :  8;
        } LUTR_bits[64];
    };

/* DOM-IGNORE-END */
}AG903_PGP0DGCF_Type;

/** PGP1DGC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  LUTB[64];

        struct {
            __IO uint32_t  B0                             :  8;
            __IO uint32_t  B1                             :  8;
            __IO uint32_t  B2                             :  8;
            __IO uint32_t  B3                             :  8;
        } LUTB_bits[64];
    };

    union {
        __IO uint32_t  LUTG[64];

        struct {
            __IO uint32_t  G0                             :  8;
            __IO uint32_t  G1                             :  8;
            __IO uint32_t  G2                             :  8;
            __IO uint32_t  G3                             :  8;
        } LUTG_bits[64];
    };

    union {
        __IO uint32_t  LUTR[64];

        struct {
            __IO uint32_t  R0                             :  8;
            __IO uint32_t  R1                             :  8;
            __IO uint32_t  R2                             :  8;
            __IO uint32_t  R3                             :  8;
        } LUTR_bits[64];
    };

/* DOM-IGNORE-END */
}AG903_PGP1DGC_Type;

/** PGP1DGCF Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __O  uint32_t  LUTB[64];

        struct {
            __O  uint32_t  B0                             :  8;
            __O  uint32_t  B1                             :  8;
            __O  uint32_t  B2                             :  8;
            __O  uint32_t  B3                             :  8;
        } LUTB_bits[64];
    };

    union {
        __O  uint32_t  LUTG[64];

        struct {
            __O  uint32_t  G0                             :  8;
            __O  uint32_t  G1                             :  8;
            __O  uint32_t  G2                             :  8;
            __O  uint32_t  G3                             :  8;
        } LUTG_bits[64];
    };

    union {
        __O  uint32_t  LUTR[64];

        struct {
            __O  uint32_t  R0                             :  8;
            __O  uint32_t  R1                             :  8;
            __O  uint32_t  R2                             :  8;
            __O  uint32_t  R3                             :  8;
        } LUTR_bits[64];
    };

/* DOM-IGNORE-END */
}AG903_PGP1DGCF_Type;

#define AG903_PGPn(ch)                           ((volatile AG903_PGPn_Type *)(AG903_PGP0_BASE + 0x200 * ch))            /** PGPn Base Address (n=0..5) */
#define AG903_PGPn_CMD(ch)                       AG903_PGPn(ch)->CMD                                                     /** PGPnCMD Address (n=0..5) */
#define AG903_PGPn_STATE(ch)                     AG903_PGPn(ch)->STATE                                                   /** PGPnSTATE Address (n=0..5) */
#define AG903_PGPn_INTCTRLI(ch)                  AG903_PGPn(ch)->INTCTRLI                                                /** PGPnINTCTRLI Address (n=0..5) */
#define AG903_PGPn_INTCTRLO(ch)                  AG903_PGPn(ch)->INTCTRLO                                                /** PGPnINTCTRLO Address (n=0..5) */
#define AG903_PGPn_INTEN(ch)                     AG903_PGPn(ch)->INTEN                                                   /** PGPnINTEN Address (n=0..5) */
#define AG903_PGPn_INTSTAT(ch)                   AG903_PGPn(ch)->INTSTAT                                                 /** PGPnINTSTAT Address (n=0..5) */
#define AG903_PGPn_INTCLR(ch)                    AG903_PGPn(ch)->INTCLR                                                  /** PGPnINTCLR Address (n=0..5) */
#define AG903_PGPn_TRGCTRLI(ch)                  AG903_PGPn(ch)->TRGCTRLI                                                /** PGPnTRGCTRLI Address (n=0..5) */
#define AG903_PGPn_TRGCTRLO(ch)                  AG903_PGPn(ch)->TRGCTRLO                                                /** PGPnTRGCTRLO Address (n=0..5) */
#define AG903_PGPn_TRGEN(ch)                     AG903_PGPn(ch)->TRGEN                                                   /** PGPnTRGEN Address (n=0..5) */
#define AG903_PGPn_INCTRL(ch)                    AG903_PGPn(ch)->INCTRL                                                  /** PGPnINCTRL Address (n=0..5) */
#define AG903_PGPn_FUNCCTRL(ch)                  AG903_PGPn(ch)->FUNCCTRL                                                /** PGPnFUNCCTRL Address (n=0..5) */
#define AG903_PGPn_SIZE(ch)                      AG903_PGPn(ch)->SIZE                                                    /** PGPnSIZE Address (n=0..5) */
#define AG903_PGPn_POS(ch)                       AG903_PGPn(ch)->POS                                                     /** PGPnPOS Address (n=0..5) */
#define AG903_PGPn_OUTCTRL0(ch)                  AG903_PGPn(ch)->OUTCTRL0                                                /** PGPnOUTCTRL0 Address (n=0..5) */
#define AG903_PGPn_OUTCTRL1(ch)                  AG903_PGPn(ch)->OUTCTRL1                                                /** PGPnOUTCTRL1 Address (n=0..5) */
#define AG903_PGPn_OUTBASE(ch)                   AG903_PGPn(ch)->OUTBASE                                                 /** PGPnOUTBASE Address (n=0..5) */
#define AG903_PGPn_OUTHSIZE(ch)                  AG903_PGPn(ch)->OUTHSIZE                                                /** PGPnOUTHSIZE Address (n=0..5) */
#define AG903_PGPn_FAIVAL0(ch)                   AG903_PGPn(ch)->FAIVAL0                                                 /** PGPnFAIVAL0 Address (n=0..5) */
#define AG903_PGPn_FAIVAL1(ch)                   AG903_PGPn(ch)->FAIVAL1                                                 /** PGPnFAIVAL1 Address (n=0..5) */
#define AG903_PGPn_IPCPRM(ch)                    AG903_PGPn(ch)->IPCPRM                                                  /** PGPnIPCPRM Address (n=0..5) */
#define AG903_PGPn_CSC1CTRL(ch)                  AG903_PGPn(ch)->CSC1CTRL                                                /** PGPnCSC1CTRL Address (n=0..5) */
#define AG903_PGPn_CSC1PRM0(ch)                  AG903_PGPn(ch)->CSC1PRM0                                                /** PGPnCSC1PRM0 Address (n=0..5) */
#define AG903_PGPn_CSC1PRM1(ch)                  AG903_PGPn(ch)->CSC1PRM1                                                /** PGPnCSC1PRM1 Address (n=0..5) */
#define AG903_PGPn_CSC1PRM2(ch)                  AG903_PGPn(ch)->CSC1PRM2                                                /** PGPnCSC1PRM2 Address (n=0..5) */
#define AG903_PGPn_CSC1PRM3(ch)                  AG903_PGPn(ch)->CSC1PRM3                                                /** PGPnCSC1PRM3 Address (n=0..5) */
#define AG903_PGPn_CSC1PRM4(ch)                  AG903_PGPn(ch)->CSC1PRM4                                                /** PGPnCSC1PRM4 Address (n=0..5) */
#define AG903_PGPn_CSC1PRM5(ch)                  AG903_PGPn(ch)->CSC1PRM5                                                /** PGPnCSC1PRM5 Address (n=0..5) */
#define AG903_PGPn_CSC1PRM6(ch)                  AG903_PGPn(ch)->CSC1PRM6                                                /** PGPnCSC1PRM6 Address (n=0..5) */
#define AG903_PGPn_CSC1PRM7(ch)                  AG903_PGPn(ch)->CSC1PRM7                                                /** PGPnCSC1PRM7 Address (n=0..5) */
#define AG903_PGPn_CSC1PRM8(ch)                  AG903_PGPn(ch)->CSC1PRM8                                                /** PGPnCSC1PRM8 Address (n=0..5) */
#define AG903_PGPn_SCCTRL(ch)                    AG903_PGPn(ch)->SCCTRL                                                  /** PGPnSCCTRL Address (n=0..5) */
#define AG903_PGPn_SPFCTRL(ch)                   AG903_PGPn(ch)->SPFCTRL                                                 /** PGPnSPFCTRL Address (n=0..5) */
#define AG903_PGPn_SPFPRM0(ch)                   AG903_PGPn(ch)->SPFPRM0                                                 /** PGPnSPFPRM0 Address (n=0..5) */
#define AG903_PGPn_SPFPRM1(ch)                   AG903_PGPn(ch)->SPFPRM1                                                 /** PGPnSPFPRM1 Address (n=0..5) */
#define AG903_PGPn_SPFPRM2(ch)                   AG903_PGPn(ch)->SPFPRM2                                                 /** PGPnSPFPRM2 Address (n=0..5) */
#define AG903_PGPn_SPFPRM3(ch)                   AG903_PGPn(ch)->SPFPRM3                                                 /** PGPnSPFPRM3 Address (n=0..5) */
#define AG903_PGPn_HSV1CTRL(ch)                  AG903_PGPn(ch)->HSV1CTRL                                                /** PGPnHSV1CTRL Address (n=0..5) */
#define AG903_PGPn_DGCSTAT(ch)                   AG903_PGPn(ch)->DGCSTAT                                                 /** PGPnDGCSTAT Address (n=0..5) */
#define AG903_PGPn_HGMCMD(ch)                    AG903_PGPn(ch)->HGMCMD                                                  /** PGPnHGMCMD Address (n=0..5) */
#define AG903_PGPn_HGMCTRL(ch)                   AG903_PGPn(ch)->HGMCTRL                                                 /** PGPnHGMCTRL Address (n=0..5) */
#define AG903_PGPn_HGMSIZE(ch)                   AG903_PGPn(ch)->HGMSIZE                                                 /** PGPnHGMSIZE Address (n=0..5) */
#define AG903_PGPn_HGMPOS(ch)                    AG903_PGPn(ch)->HGMPOS                                                  /** PGPnHGMPOS Address (n=0..5) */
#define AG903_PGPn_HGMDST(ch)                    AG903_PGPn(ch)->HGMDST                                                  /** PGPnHGMDST Address (n=0..5) */
#define AG903_PGPn_HGMMOD0(ch)                   AG903_PGPn(ch)->HGMMOD0                                                 /** PGPnHGMMOD0 Address (n=0..5) */
#define AG903_PGPn_HGMRNG0(ch)                   AG903_PGPn(ch)->HGMRNG0                                                 /** PGPnHGMRNG0 Address (n=0..5) */
#define AG903_PGPn_HGMMOD1(ch)                   AG903_PGPn(ch)->HGMMOD1                                                 /** PGPnHGMMOD1 Address (n=0..5) */
#define AG903_PGPn_HGMRNG1(ch)                   AG903_PGPn(ch)->HGMRNG1                                                 /** PGPnHGMRNG1 Address (n=0..5) */
#define AG903_PGPn_HGMMOD2(ch)                   AG903_PGPn(ch)->HGMMOD2                                                 /** PGPnHGMMOD2 Address (n=0..5) */
#define AG903_PGPn_HGMRNG2(ch)                   AG903_PGPn(ch)->HGMRNG2                                                 /** PGPnHGMRNG2 Address (n=0..5) */
#define AG903_PGPn_HGMSTAT(ch)                   AG903_PGPn(ch)->HGMSTAT                                                 /** PGPnHGMSTAT Address (n=0..5) */
#define AG903_PGPn_THRCTRL(ch)                   AG903_PGPn(ch)->THRCTRL                                                 /** PGPnTHRCTRL Address (n=0..5) */
#define AG903_PGPn_HSV2CTRL(ch)                  AG903_PGPn(ch)->HSV2CTRL                                                /** PGPnHSV2CTRL Address (n=0..5) */
#define AG903_PGPn_CSC2CTRL(ch)                  AG903_PGPn(ch)->CSC2CTRL                                                /** PGPnCSC2CTRL Address (n=0..5) */
#define AG903_PGPn_CSC2PRM0(ch)                  AG903_PGPn(ch)->CSC2PRM0                                                /** PGPnCSC2PRM0 Address (n=0..5) */
#define AG903_PGPn_CSC2PRM1(ch)                  AG903_PGPn(ch)->CSC2PRM1                                                /** PGPnCSC2PRM1 Address (n=0..5) */
#define AG903_PGPn_CSC2PRM2(ch)                  AG903_PGPn(ch)->CSC2PRM2                                                /** PGPnCSC2PRM2 Address (n=0..5) */
#define AG903_PGPn_CSC2PRM3(ch)                  AG903_PGPn(ch)->CSC2PRM3                                                /** PGPnCSC2PRM3 Address (n=0..5) */
#define AG903_PGPn_CSC2PRM4(ch)                  AG903_PGPn(ch)->CSC2PRM4                                                /** PGPnCSC2PRM4 Address (n=0..5) */
#define AG903_PGPn_CSC2PRM5(ch)                  AG903_PGPn(ch)->CSC2PRM5                                                /** PGPnCSC2PRM5 Address (n=0..5) */
#define AG903_PGPn_CSC2PRM6(ch)                  AG903_PGPn(ch)->CSC2PRM6                                                /** PGPnCSC2PRM6 Address (n=0..5) */
#define AG903_PGPn_CSC2PRM7(ch)                  AG903_PGPn(ch)->CSC2PRM7                                                /** PGPnCSC2PRM7 Address (n=0..5) */
#define AG903_PGPn_CSC2PRM8(ch)                  AG903_PGPn(ch)->CSC2PRM8                                                /** PGPnCSC2PRM8 Address (n=0..5) */
#define AG903_PGPn_MSK0PRM0(ch)                  AG903_PGPn(ch)->MSK0PRM0                                                /** PGPnMSK0PRM0 Address (n=0..5) */
#define AG903_PGPn_MSK0PRM1(ch)                  AG903_PGPn(ch)->MSK0PRM1                                                /** PGPnMSK0PRM1 Address (n=0..5) */
#define AG903_PGPn_MSK1PRM0(ch)                  AG903_PGPn(ch)->MSK1PRM0                                                /** PGPnMSK1PRM0 Address (n=0..5) */
#define AG903_PGPn_MSK1PRM1(ch)                  AG903_PGPn(ch)->MSK1PRM1                                                /** PGPnMSK1PRM1 Address (n=0..5) */
#define AG903_PGPn_MSK2PRM0(ch)                  AG903_PGPn(ch)->MSK2PRM0                                                /** PGPnMSK2PRM0 Address (n=0..5) */
#define AG903_PGPn_MSK2PRM1(ch)                  AG903_PGPn(ch)->MSK2PRM1                                                /** PGPnMSK2PRM1 Address (n=0..5) */
#define AG903_PGPn_THR8PRM0(ch)                  AG903_PGPn(ch)->THR8PRM0                                                /** PGPnTHR8PRM0 Address (n=0..5) */
#define AG903_PGPn_THR8PRM1(ch)                  AG903_PGPn(ch)->THR8PRM1                                                /** PGPnTHR8PRM1 Address (n=0..5) */
#define AG903_PGPn_THR8PRM2(ch)                  AG903_PGPn(ch)->THR8PRM2                                                /** PGPnTHR8PRM2 Address (n=0..5) */
#define AG903_PGPn_THR1PRM0(ch)                  AG903_PGPn(ch)->THR1PRM0                                                /** PGPnTHR1PRM0 Address (n=0..5) */
#define AG903_PGPn_THR1PRM1(ch)                  AG903_PGPn(ch)->THR1PRM1                                                /** PGPnTHR1PRM1 Address (n=0..5) */
#define AG903_PGPn_SPF1PRM0(ch)                  AG903_PGPn(ch)->SPF1PRM0                                                /** PGPnSPF1PRM0 Address (n=0..5) */
#define AG903_PGPn_SPF1PRM1(ch)                  AG903_PGPn(ch)->SPF1PRM1                                                /** PGPnSPF1PRM1 Address (n=0..5) */
#define AG903_PGPn_THR1CNT(ch)                   AG903_PGPn(ch)->THR1CNT                                                 /** PGPnTHR1CNT Address (n=0..5) */
#define AG903_PGPn_LBLCMD(ch)                    AG903_PGPn(ch)->LBLCMD                                                  /** PGPnLBLCMD Address (n=0..5) */
#define AG903_PGPn_LBLCTRL(ch)                   AG903_PGPn(ch)->LBLCTRL                                                 /** PGPnLBLCTRL Address (n=0..5) */
#define AG903_PGPn_LBLSIZE(ch)                   AG903_PGPn(ch)->LBLSIZE                                                 /** PGPnLBLSIZE Address (n=0..5) */
#define AG903_PGPn_LBLPOS(ch)                    AG903_PGPn(ch)->LBLPOS                                                  /** PGPnLBLPOS Address (n=0..5) */
#define AG903_PGPn_LBLDST(ch)                    AG903_PGPn(ch)->LBLDST                                                  /** PGPnLBLDST Address (n=0..5) */
#define AG903_PGPn_LBLSTAT(ch)                   AG903_PGPn(ch)->LBLSTAT                                                 /** PGPnLBLSTAT Address (n=0..5) */
#define AG903_PGPn_IFCCMD(ch)                    AG903_PGPn(ch)->IFCCMD                                                  /** PGPnIFCCMD Address (n=0..5) */
#define AG903_PGPn_IFCCTRL(ch)                   AG903_PGPn(ch)->IFCCTRL                                                 /** PGPnIFCCTRL Address (n=0..5) */
#define AG903_PGPn_IFCPRM(ch)                    AG903_PGPn(ch)->IFCPRM                                                  /** PGPnIFCPRM Address (n=0..5) */

#define AG903_PGPVIn(ch)                         ((volatile AG903_PGPVIn_Type *)(AG903_PGPVI0_BASE + 0x100 * ch))        /** PGPVIn Base Address (n=0..3) */
#define AG903_PGPVIn_CMD(ch)                     AG903_PGPVIn(ch)->CMD                                                   /** PGPVInCMD Address (n=0..3) */
#define AG903_PGPVIn_STATE(ch)                   AG903_PGPVIn(ch)->STATE                                                 /** PGPVInSTATE Address (n=0..3) */
#define AG903_PGPVIn_CTRL0(ch)                   AG903_PGPVIn(ch)->CTRL0                                                 /** PGPVInCTRL0 Address (n=0..3) */
#define AG903_PGPVIn_CTRL1(ch)                   AG903_PGPVIn(ch)->CTRL1                                                 /** PGPVInCTRL1 Address (n=0..3) */
#define AG903_PGPVIn_BASE(ch)                    AG903_PGPVIn(ch)->BASE                                                  /** PGPVInBASE Address (n=0..3) */
#define AG903_PGPVIn_HSIZE(ch)                   AG903_PGPVIn(ch)->HSIZE                                                 /** PGPVInHSIZE Address (n=0..3) */
#define AG903_PGPVIn_HPRM0(ch)                   AG903_PGPVIn(ch)->HPRM0                                                 /** PGPVInHPRM0 Address (n=0..3) */
#define AG903_PGPVIn_HPRM1(ch)                   AG903_PGPVIn(ch)->HPRM1                                                 /** PGPVInHPRM1 Address (n=0..3) */
#define AG903_PGPVIn_VPRM0(ch)                   AG903_PGPVIn(ch)->VPRM0                                                 /** PGPVInVPRM0 Address (n=0..3) */
#define AG903_PGPVIn_VPRM1(ch)                   AG903_PGPVIn(ch)->VPRM1                                                 /** PGPVInVPRM1 Address (n=0..3) */
#define AG903_PGPVIn_SIZE(ch)                    AG903_PGPVIn(ch)->SIZE                                                  /** PGPVInSIZE Address (n=0..3) */

#define AG903_PGP0                               ((volatile AG903_PGPn_Type *) AG903_PGP0_BASE)                          /** PGPn Base Address */
#define AG903_PGP1                               ((volatile AG903_PGPn_Type *) AG903_PGP1_BASE)                          /** PGPn Base Address */
#define AG903_PGP2                               ((volatile AG903_PGPn_Type *) AG903_PGP2_BASE)                          /** PGPn Base Address */
#define AG903_PGP3                               ((volatile AG903_PGPn_Type *) AG903_PGP3_BASE)                          /** PGPn Base Address */
#define AG903_PGP4                               ((volatile AG903_PGPn_Type *) AG903_PGP4_BASE)                          /** PGPn Base Address */
#define AG903_PGP5                               ((volatile AG903_PGPn_Type *) AG903_PGP5_BASE)                          /** PGPn Base Address */
#define AG903_PGPVI0                             ((volatile AG903_PGPVIn_Type *) AG903_PGPVI0_BASE)                      /** PGPVIn Base Address */
#define AG903_PGPVI1                             ((volatile AG903_PGPVIn_Type *) AG903_PGPVI1_BASE)                      /** PGPVIn Base Address */
#define AG903_PGPVI2                             ((volatile AG903_PGPVIn_Type *) AG903_PGPVI2_BASE)                      /** PGPVIn Base Address */
#define AG903_PGPVI3                             ((volatile AG903_PGPVIn_Type *) AG903_PGPVI3_BASE)                      /** PGPVIn Base Address */
#define AG903_PGP                                ((volatile AG903_PGP_Type *) AG903_PGP_BASE)                            /** PGP Base Address */
#define AG903_PGP0DGC                            ((volatile AG903_PGP0DGC_Type *) AG903_PGP0DGC_BASE)                    /** PGP0DGC Base Address */
#define AG903_PGP0DGCF                           ((volatile AG903_PGP0DGCF_Type *) AG903_PGP0DGCF_BASE)                  /** PGP0DGCF Base Address */
#define AG903_PGP1DGC                            ((volatile AG903_PGP1DGC_Type *) AG903_PGP1DGC_BASE)                    /** PGP1DGC Base Address */
#define AG903_PGP1DGCF                           ((volatile AG903_PGP1DGCF_Type *) AG903_PGP1DGCF_BASE)                  /** PGP1DGCF Base Address */


#define AG903_PGPn_CMD_CMD_POS                             0                                                             /** PGPnCMD CMD-bit position */
#define AG903_PGPn_CMD_CMD_MSK                             (0xfUL << AG903_PGPn_CMD_CMD_POS)                             /** PGPnCMD CMD-bit mask */

#define AG903_PGPn_STATE_ST_POS                            0                                                             /** PGPnSTATE ST-bit position */
#define AG903_PGPn_STATE_ST_MSK                            (0xfUL << AG903_PGPn_STATE_ST_POS)                            /** PGPnSTATE ST-bit mask */
#define AG903_PGPn_STATE_SST_POS                           4                                                             /** PGPnSTATE SST-bit position */
#define AG903_PGPn_STATE_SST_MSK                           (0xfUL << AG903_PGPn_STATE_SST_POS)                           /** PGPnSTATE SST-bit mask */
#define AG903_PGPn_STATE_QUEUE_POS                         8                                                             /** PGPnSTATE QUEUE-bit position */
#define AG903_PGPn_STATE_QUEUE_MSK                         (0x3UL << AG903_PGPn_STATE_QUEUE_POS)                         /** PGPnSTATE QUEUE-bit mask */
#define AG903_PGPn_STATE_VRMACC_POS                        12                                                            /** PGPnSTATE VRMACC-bit position */
#define AG903_PGPn_STATE_VRMACC_MSK                        (0x1UL << AG903_PGPn_STATE_VRMACC_POS)                        /** PGPnSTATE VRMACC-bit mask */
#define AG903_PGPn_STATE_BLANK_POS                         13                                                            /** PGPnSTATE BLANK-bit position */
#define AG903_PGPn_STATE_BLANK_MSK                         (0x1UL << AG903_PGPn_STATE_BLANK_POS)                         /** PGPnSTATE BLANK-bit mask */

#define AG903_PGPn_INTCTRLI_LINE_POS                       0                                                             /** PGPnINTCTRLI LINE-bit position */
#define AG903_PGPn_INTCTRLI_LINE_MSK                       (0x1fffUL << AG903_PGPn_INTCTRLI_LINE_POS)                    /** PGPnINTCTRLI LINE-bit mask */
#define AG903_PGPn_INTCTRLI_FCNT_POS                       16                                                            /** PGPnINTCTRLI FCNT-bit position */
#define AG903_PGPn_INTCTRLI_FCNT_MSK                       (0xfUL << AG903_PGPn_INTCTRLI_FCNT_POS)                       /** PGPnINTCTRLI FCNT-bit mask */
#define AG903_PGPn_INTCTRLI_FIELD_POS                      20                                                            /** PGPnINTCTRLI FIELD-bit position */
#define AG903_PGPn_INTCTRLI_FIELD_MSK                      (0x3UL << AG903_PGPn_INTCTRLI_FIELD_POS)                      /** PGPnINTCTRLI FIELD-bit mask */

#define AG903_PGPn_INTCTRLO_LINE_POS                       0                                                             /** PGPnINTCTRLO LINE-bit position */
#define AG903_PGPn_INTCTRLO_LINE_MSK                       (0xfffUL << AG903_PGPn_INTCTRLO_LINE_POS)                     /** PGPnINTCTRLO LINE-bit mask */
#define AG903_PGPn_INTCTRLO_FCNT_POS                       16                                                            /** PGPnINTCTRLO FCNT-bit position */
#define AG903_PGPn_INTCTRLO_FCNT_MSK                       (0xfUL << AG903_PGPn_INTCTRLO_FCNT_POS)                       /** PGPnINTCTRLO FCNT-bit mask */
#define AG903_PGPn_INTCTRLO_FIELD_POS                      20                                                            /** PGPnINTCTRLO FIELD-bit position */
#define AG903_PGPn_INTCTRLO_FIELD_MSK                      (0x3UL << AG903_PGPn_INTCTRLO_FIELD_POS)                      /** PGPnINTCTRLO FIELD-bit mask */

#define AG903_PGPn_INTEN_VLINEI_POS                        0                                                             /** PGPnINTEN VLINEI-bit position */
#define AG903_PGPn_INTEN_VLINEI_MSK                        (0x1UL << AG903_PGPn_INTEN_VLINEI_POS)                        /** PGPnINTEN VLINEI-bit mask */
#define AG903_PGPn_INTEN_VSYNCI_POS                        1                                                             /** PGPnINTEN VSYNCI-bit position */
#define AG903_PGPn_INTEN_VSYNCI_MSK                        (0x1UL << AG903_PGPn_INTEN_VSYNCI_POS)                        /** PGPnINTEN VSYNCI-bit mask */
#define AG903_PGPn_INTEN_VLINEO_POS                        2                                                             /** PGPnINTEN VLINEO-bit position */
#define AG903_PGPn_INTEN_VLINEO_MSK                        (0x1UL << AG903_PGPn_INTEN_VLINEO_POS)                        /** PGPnINTEN VLINEO-bit mask */
#define AG903_PGPn_INTEN_VSYNCO_POS                        3                                                             /** PGPnINTEN VSYNCO-bit position */
#define AG903_PGPn_INTEN_VSYNCO_MSK                        (0x1UL << AG903_PGPn_INTEN_VSYNCO_POS)                        /** PGPnINTEN VSYNCO-bit mask */
#define AG903_PGPn_INTEN_HGMCPL_POS                        4                                                             /** PGPnINTEN HGMCPL-bit position */
#define AG903_PGPn_INTEN_HGMCPL_MSK                        (0x1UL << AG903_PGPn_INTEN_HGMCPL_POS)                        /** PGPnINTEN HGMCPL-bit mask */
#define AG903_PGPn_INTEN_HGMICPL_POS                       5                                                             /** PGPnINTEN HGMICPL-bit position */
#define AG903_PGPn_INTEN_HGMICPL_MSK                       (0x1UL << AG903_PGPn_INTEN_HGMICPL_POS)                       /** PGPnINTEN HGMICPL-bit mask */
#define AG903_PGPn_INTEN_LBLCPL_POS                        6                                                             /** PGPnINTEN LBLCPL-bit position */
#define AG903_PGPn_INTEN_LBLCPL_MSK                        (0x1UL << AG903_PGPn_INTEN_LBLCPL_POS)                        /** PGPnINTEN LBLCPL-bit mask */
#define AG903_PGPn_INTEN_LBLCRPT_POS                       7                                                             /** PGPnINTEN LBLCRPT-bit position */
#define AG903_PGPn_INTEN_LBLCRPT_MSK                       (0x1UL << AG903_PGPn_INTEN_LBLCRPT_POS)                       /** PGPnINTEN LBLCRPT-bit mask */
#define AG903_PGPn_INTEN_IFCOFM_POS                        8                                                             /** PGPnINTEN IFCOFM-bit position */
#define AG903_PGPn_INTEN_IFCOFM_MSK                        (0x1UL << AG903_PGPn_INTEN_IFCOFM_POS)                        /** PGPnINTEN IFCOFM-bit mask */
#define AG903_PGPn_INTEN_IFCOFS_POS                        9                                                             /** PGPnINTEN IFCOFS-bit position */
#define AG903_PGPn_INTEN_IFCOFS_MSK                        (0x1UL << AG903_PGPn_INTEN_IFCOFS_POS)                        /** PGPnINTEN IFCOFS-bit mask */
#define AG903_PGPn_INTEN_VOOFLW_POS                        10                                                            /** PGPnINTEN VOOFLW-bit position */
#define AG903_PGPn_INTEN_VOOFLW_MSK                        (0x1UL << AG903_PGPn_INTEN_VOOFLW_POS)                        /** PGPnINTEN VOOFLW-bit mask */
#define AG903_PGPn_INTEN_VOICPL_POS                        11                                                            /** PGPnINTEN VOICPL-bit position */
#define AG903_PGPn_INTEN_VOICPL_MSK                        (0x1UL << AG903_PGPn_INTEN_VOICPL_POS)                        /** PGPnINTEN VOICPL-bit mask */
#define AG903_PGPn_INTEN_ND_POS                            12                                                            /** PGPnINTEN ND-bit position */
#define AG903_PGPn_INTEN_ND_MSK                            (0x1UL << AG903_PGPn_INTEN_ND_POS)                            /** PGPnINTEN ND-bit mask */

#define AG903_PGPn_INTSTAT_VLINEI_POS                      0                                                             /** PGPnINTSTAT VLINEI-bit position */
#define AG903_PGPn_INTSTAT_VLINEI_MSK                      (0x1UL << AG903_PGPn_INTSTAT_VLINEI_POS)                      /** PGPnINTSTAT VLINEI-bit mask */
#define AG903_PGPn_INTSTAT_VSYNCI_POS                      1                                                             /** PGPnINTSTAT VSYNCI-bit position */
#define AG903_PGPn_INTSTAT_VSYNCI_MSK                      (0x1UL << AG903_PGPn_INTSTAT_VSYNCI_POS)                      /** PGPnINTSTAT VSYNCI-bit mask */
#define AG903_PGPn_INTSTAT_VLINEO_POS                      2                                                             /** PGPnINTSTAT VLINEO-bit position */
#define AG903_PGPn_INTSTAT_VLINEO_MSK                      (0x1UL << AG903_PGPn_INTSTAT_VLINEO_POS)                      /** PGPnINTSTAT VLINEO-bit mask */
#define AG903_PGPn_INTSTAT_VSYNCO_POS                      3                                                             /** PGPnINTSTAT VSYNCO-bit position */
#define AG903_PGPn_INTSTAT_VSYNCO_MSK                      (0x1UL << AG903_PGPn_INTSTAT_VSYNCO_POS)                      /** PGPnINTSTAT VSYNCO-bit mask */
#define AG903_PGPn_INTSTAT_HGMCPL_POS                      4                                                             /** PGPnINTSTAT HGMCPL-bit position */
#define AG903_PGPn_INTSTAT_HGMCPL_MSK                      (0x1UL << AG903_PGPn_INTSTAT_HGMCPL_POS)                      /** PGPnINTSTAT HGMCPL-bit mask */
#define AG903_PGPn_INTSTAT_HGMICPL_POS                     5                                                             /** PGPnINTSTAT HGMICPL-bit position */
#define AG903_PGPn_INTSTAT_HGMICPL_MSK                     (0x1UL << AG903_PGPn_INTSTAT_HGMICPL_POS)                     /** PGPnINTSTAT HGMICPL-bit mask */
#define AG903_PGPn_INTSTAT_LBLCPL_POS                      6                                                             /** PGPnINTSTAT LBLCPL-bit position */
#define AG903_PGPn_INTSTAT_LBLCPL_MSK                      (0x1UL << AG903_PGPn_INTSTAT_LBLCPL_POS)                      /** PGPnINTSTAT LBLCPL-bit mask */
#define AG903_PGPn_INTSTAT_LBLCRPT_POS                     7                                                             /** PGPnINTSTAT LBLCRPT-bit position */
#define AG903_PGPn_INTSTAT_LBLCRPT_MSK                     (0x1UL << AG903_PGPn_INTSTAT_LBLCRPT_POS)                     /** PGPnINTSTAT LBLCRPT-bit mask */
#define AG903_PGPn_INTSTAT_IFCOFM_POS                      8                                                             /** PGPnINTSTAT IFCOFM-bit position */
#define AG903_PGPn_INTSTAT_IFCOFM_MSK                      (0x1UL << AG903_PGPn_INTSTAT_IFCOFM_POS)                      /** PGPnINTSTAT IFCOFM-bit mask */
#define AG903_PGPn_INTSTAT_IFCOFS_POS                      9                                                             /** PGPnINTSTAT IFCOFS-bit position */
#define AG903_PGPn_INTSTAT_IFCOFS_MSK                      (0x1UL << AG903_PGPn_INTSTAT_IFCOFS_POS)                      /** PGPnINTSTAT IFCOFS-bit mask */
#define AG903_PGPn_INTSTAT_VOOFLW_POS                      10                                                            /** PGPnINTSTAT VOOFLW-bit position */
#define AG903_PGPn_INTSTAT_VOOFLW_MSK                      (0x1UL << AG903_PGPn_INTSTAT_VOOFLW_POS)                      /** PGPnINTSTAT VOOFLW-bit mask */
#define AG903_PGPn_INTSTAT_VOICPL_POS                      11                                                            /** PGPnINTSTAT VOICPL-bit position */
#define AG903_PGPn_INTSTAT_VOICPL_MSK                      (0x1UL << AG903_PGPn_INTSTAT_VOICPL_POS)                      /** PGPnINTSTAT VOICPL-bit mask */
#define AG903_PGPn_INTSTAT_ND_POS                          12                                                            /** PGPnINTSTAT ND-bit position */
#define AG903_PGPn_INTSTAT_ND_MSK                          (0x1UL << AG903_PGPn_INTSTAT_ND_POS)                          /** PGPnINTSTAT ND-bit mask */

#define AG903_PGPn_INTCLR_VLINEI_POS                       0                                                             /** PGPnINTCLR VLINEI-bit position */
#define AG903_PGPn_INTCLR_VLINEI_MSK                       (0x1UL << AG903_PGPn_INTCLR_VLINEI_POS)                       /** PGPnINTCLR VLINEI-bit mask */
#define AG903_PGPn_INTCLR_VSYNCI_POS                       1                                                             /** PGPnINTCLR VSYNCI-bit position */
#define AG903_PGPn_INTCLR_VSYNCI_MSK                       (0x1UL << AG903_PGPn_INTCLR_VSYNCI_POS)                       /** PGPnINTCLR VSYNCI-bit mask */
#define AG903_PGPn_INTCLR_VLINEO_POS                       2                                                             /** PGPnINTCLR VLINEO-bit position */
#define AG903_PGPn_INTCLR_VLINEO_MSK                       (0x1UL << AG903_PGPn_INTCLR_VLINEO_POS)                       /** PGPnINTCLR VLINEO-bit mask */
#define AG903_PGPn_INTCLR_VSYNCO_POS                       3                                                             /** PGPnINTCLR VSYNCO-bit position */
#define AG903_PGPn_INTCLR_VSYNCO_MSK                       (0x1UL << AG903_PGPn_INTCLR_VSYNCO_POS)                       /** PGPnINTCLR VSYNCO-bit mask */
#define AG903_PGPn_INTCLR_HGMCPL_POS                       4                                                             /** PGPnINTCLR HGMCPL-bit position */
#define AG903_PGPn_INTCLR_HGMCPL_MSK                       (0x1UL << AG903_PGPn_INTCLR_HGMCPL_POS)                       /** PGPnINTCLR HGMCPL-bit mask */
#define AG903_PGPn_INTCLR_HGMICPL_POS                      5                                                             /** PGPnINTCLR HGMICPL-bit position */
#define AG903_PGPn_INTCLR_HGMICPL_MSK                      (0x1UL << AG903_PGPn_INTCLR_HGMICPL_POS)                      /** PGPnINTCLR HGMICPL-bit mask */
#define AG903_PGPn_INTCLR_LBLCPL_POS                       6                                                             /** PGPnINTCLR LBLCPL-bit position */
#define AG903_PGPn_INTCLR_LBLCPL_MSK                       (0x1UL << AG903_PGPn_INTCLR_LBLCPL_POS)                       /** PGPnINTCLR LBLCPL-bit mask */
#define AG903_PGPn_INTCLR_LBLCRPT_POS                      7                                                             /** PGPnINTCLR LBLCRPT-bit position */
#define AG903_PGPn_INTCLR_LBLCRPT_MSK                      (0x1UL << AG903_PGPn_INTCLR_LBLCRPT_POS)                      /** PGPnINTCLR LBLCRPT-bit mask */
#define AG903_PGPn_INTCLR_IFCOFM_POS                       8                                                             /** PGPnINTCLR IFCOFM-bit position */
#define AG903_PGPn_INTCLR_IFCOFM_MSK                       (0x1UL << AG903_PGPn_INTCLR_IFCOFM_POS)                       /** PGPnINTCLR IFCOFM-bit mask */
#define AG903_PGPn_INTCLR_IFCOFS_POS                       9                                                             /** PGPnINTCLR IFCOFS-bit position */
#define AG903_PGPn_INTCLR_IFCOFS_MSK                       (0x1UL << AG903_PGPn_INTCLR_IFCOFS_POS)                       /** PGPnINTCLR IFCOFS-bit mask */
#define AG903_PGPn_INTCLR_VOOFLW_POS                       10                                                            /** PGPnINTCLR VOOFLW-bit position */
#define AG903_PGPn_INTCLR_VOOFLW_MSK                       (0x1UL << AG903_PGPn_INTCLR_VOOFLW_POS)                       /** PGPnINTCLR VOOFLW-bit mask */
#define AG903_PGPn_INTCLR_VOICPL_POS                       11                                                            /** PGPnINTCLR VOICPL-bit position */
#define AG903_PGPn_INTCLR_VOICPL_MSK                       (0x1UL << AG903_PGPn_INTCLR_VOICPL_POS)                       /** PGPnINTCLR VOICPL-bit mask */
#define AG903_PGPn_INTCLR_ND_POS                           12                                                            /** PGPnINTCLR ND-bit position */
#define AG903_PGPn_INTCLR_ND_MSK                           (0x1UL << AG903_PGPn_INTCLR_ND_POS)                           /** PGPnINTCLR ND-bit mask */

#define AG903_PGPn_TRGCTRLI_LINE_POS                       0                                                             /** PGPnTRGCTRLI LINE-bit position */
#define AG903_PGPn_TRGCTRLI_LINE_MSK                       (0x1fffUL << AG903_PGPn_TRGCTRLI_LINE_POS)                    /** PGPnTRGCTRLI LINE-bit mask */
#define AG903_PGPn_TRGCTRLI_FCNT_POS                       16                                                            /** PGPnTRGCTRLI FCNT-bit position */
#define AG903_PGPn_TRGCTRLI_FCNT_MSK                       (0xfUL << AG903_PGPn_TRGCTRLI_FCNT_POS)                       /** PGPnTRGCTRLI FCNT-bit mask */
#define AG903_PGPn_TRGCTRLI_FIELD_POS                      20                                                            /** PGPnTRGCTRLI FIELD-bit position */
#define AG903_PGPn_TRGCTRLI_FIELD_MSK                      (0x3UL << AG903_PGPn_TRGCTRLI_FIELD_POS)                      /** PGPnTRGCTRLI FIELD-bit mask */

#define AG903_PGPn_TRGCTRLO_LINE_POS                       0                                                             /** PGPnTRGCTRLO LINE-bit position */
#define AG903_PGPn_TRGCTRLO_LINE_MSK                       (0xfffUL << AG903_PGPn_TRGCTRLO_LINE_POS)                     /** PGPnTRGCTRLO LINE-bit mask */
#define AG903_PGPn_TRGCTRLO_FCNT_POS                       16                                                            /** PGPnTRGCTRLO FCNT-bit position */
#define AG903_PGPn_TRGCTRLO_FCNT_MSK                       (0xfUL << AG903_PGPn_TRGCTRLO_FCNT_POS)                       /** PGPnTRGCTRLO FCNT-bit mask */
#define AG903_PGPn_TRGCTRLO_FIELD_POS                      20                                                            /** PGPnTRGCTRLO FIELD-bit position */
#define AG903_PGPn_TRGCTRLO_FIELD_MSK                      (0x3UL << AG903_PGPn_TRGCTRLO_FIELD_POS)                      /** PGPnTRGCTRLO FIELD-bit mask */

#define AG903_PGPn_TRGEN_VLINEI_POS                        0                                                             /** PGPnTRGEN VLINEI-bit position */
#define AG903_PGPn_TRGEN_VLINEI_MSK                        (0x1UL << AG903_PGPn_TRGEN_VLINEI_POS)                        /** PGPnTRGEN VLINEI-bit mask */
#define AG903_PGPn_TRGEN_VSYNCI_POS                        1                                                             /** PGPnTRGEN VSYNCI-bit position */
#define AG903_PGPn_TRGEN_VSYNCI_MSK                        (0x1UL << AG903_PGPn_TRGEN_VSYNCI_POS)                        /** PGPnTRGEN VSYNCI-bit mask */
#define AG903_PGPn_TRGEN_VLINEO_POS                        2                                                             /** PGPnTRGEN VLINEO-bit position */
#define AG903_PGPn_TRGEN_VLINEO_MSK                        (0x1UL << AG903_PGPn_TRGEN_VLINEO_POS)                        /** PGPnTRGEN VLINEO-bit mask */
#define AG903_PGPn_TRGEN_VSYNCO_POS                        3                                                             /** PGPnTRGEN VSYNCO-bit position */
#define AG903_PGPn_TRGEN_VSYNCO_MSK                        (0x1UL << AG903_PGPn_TRGEN_VSYNCO_POS)                        /** PGPnTRGEN VSYNCO-bit mask */

#define AG903_PGPn_INCTRL_FMT_POS                          0                                                             /** PGPnINCTRL FMT-bit position */
#define AG903_PGPn_INCTRL_FMT_MSK                          (0x7UL << AG903_PGPn_INCTRL_FMT_POS)                          /** PGPnINCTRL FMT-bit mask */
#define AG903_PGPn_INCTRL_SEL_POS                          8                                                             /** PGPnINCTRL SEL-bit position */
#define AG903_PGPn_INCTRL_SEL_MSK                          (0xfUL << AG903_PGPn_INCTRL_SEL_POS)                          /** PGPnINCTRL SEL-bit mask */
#define AG903_PGPn_INCTRL_TRG_POS                          16                                                            /** PGPnINCTRL TRG-bit position */
#define AG903_PGPn_INCTRL_TRG_MSK                          (0x7UL << AG903_PGPn_INCTRL_TRG_POS)                          /** PGPnINCTRL TRG-bit mask */
#define AG903_PGPn_INCTRL_TICK_POS                         24                                                            /** PGPnINCTRL TICK-bit position */
#define AG903_PGPn_INCTRL_TICK_MSK                         (0x1UL << AG903_PGPn_INCTRL_TICK_POS)                         /** PGPnINCTRL TICK-bit mask */
#define AG903_PGPn_INCTRL_MD_POS                           25                                                            /** PGPnINCTRL MD-bit position */
#define AG903_PGPn_INCTRL_MD_MSK                           (0x3UL << AG903_PGPn_INCTRL_MD_POS)                           /** PGPnINCTRL MD-bit mask */
#define AG903_PGPn_INCTRL_HDLY_POS                         28                                                            /** PGPnINCTRL HDLY-bit position */
#define AG903_PGPn_INCTRL_HDLY_MSK                         (0x7UL << AG903_PGPn_INCTRL_HDLY_POS)                         /** PGPnINCTRL HDLY-bit mask */

#define AG903_PGPn_FUNCCTRL_NRF_POS                        0                                                             /** PGPnFUNCCTRL NRF-bit position */
#define AG903_PGPn_FUNCCTRL_NRF_MSK                        (0x1UL << AG903_PGPn_FUNCCTRL_NRF_POS)                        /** PGPnFUNCCTRL NRF-bit mask */
#define AG903_PGPn_FUNCCTRL_CSC1_POS                       1                                                             /** PGPnFUNCCTRL CSC1-bit position */
#define AG903_PGPn_FUNCCTRL_CSC1_MSK                       (0x1UL << AG903_PGPn_FUNCCTRL_CSC1_POS)                       /** PGPnFUNCCTRL CSC1-bit mask */
#define AG903_PGPn_FUNCCTRL_SCALE_POS                      2                                                             /** PGPnFUNCCTRL SCALE-bit position */
#define AG903_PGPn_FUNCCTRL_SCALE_MSK                      (0x1UL << AG903_PGPn_FUNCCTRL_SCALE_POS)                      /** PGPnFUNCCTRL SCALE-bit mask */
#define AG903_PGPn_FUNCCTRL_SPF_POS                        3                                                             /** PGPnFUNCCTRL SPF-bit position */
#define AG903_PGPn_FUNCCTRL_SPF_MSK                        (0x1UL << AG903_PGPn_FUNCCTRL_SPF_POS)                        /** PGPnFUNCCTRL SPF-bit mask */
#define AG903_PGPn_FUNCCTRL_HSV1_POS                       4                                                             /** PGPnFUNCCTRL HSV1-bit position */
#define AG903_PGPn_FUNCCTRL_HSV1_MSK                       (0x1UL << AG903_PGPn_FUNCCTRL_HSV1_POS)                       /** PGPnFUNCCTRL HSV1-bit mask */
#define AG903_PGPn_FUNCCTRL_DGC_POS                        5                                                             /** PGPnFUNCCTRL DGC-bit position */
#define AG903_PGPn_FUNCCTRL_DGC_MSK                        (0x1UL << AG903_PGPn_FUNCCTRL_DGC_POS)                        /** PGPnFUNCCTRL DGC-bit mask */
#define AG903_PGPn_FUNCCTRL_THR_POS                        6                                                             /** PGPnFUNCCTRL THR-bit position */
#define AG903_PGPn_FUNCCTRL_THR_MSK                        (0x1UL << AG903_PGPn_FUNCCTRL_THR_POS)                        /** PGPnFUNCCTRL THR-bit mask */
#define AG903_PGPn_FUNCCTRL_IFC_POS                        7                                                             /** PGPnFUNCCTRL IFC-bit position */
#define AG903_PGPn_FUNCCTRL_IFC_MSK                        (0x1UL << AG903_PGPn_FUNCCTRL_IFC_POS)                        /** PGPnFUNCCTRL IFC-bit mask */
#define AG903_PGPn_FUNCCTRL_IFCODR_POS                     8                                                             /** PGPnFUNCCTRL IFCODR-bit position */
#define AG903_PGPn_FUNCCTRL_IFCODR_MSK                     (0x1UL << AG903_PGPn_FUNCCTRL_IFCODR_POS)                     /** PGPnFUNCCTRL IFCODR-bit mask */
#define AG903_PGPn_FUNCCTRL_OUT_POS                        9                                                             /** PGPnFUNCCTRL OUT-bit position */
#define AG903_PGPn_FUNCCTRL_OUT_MSK                        (0x1UL << AG903_PGPn_FUNCCTRL_OUT_POS)                        /** PGPnFUNCCTRL OUT-bit mask */

#define AG903_PGPn_SIZE_HSIZE_POS                          0                                                             /** PGPnSIZE HSIZE-bit position */
#define AG903_PGPn_SIZE_HSIZE_MSK                          (0xfffUL << AG903_PGPn_SIZE_HSIZE_POS)                        /** PGPnSIZE HSIZE-bit mask */
#define AG903_PGPn_SIZE_VSIZE_POS                          16                                                            /** PGPnSIZE VSIZE-bit position */
#define AG903_PGPn_SIZE_VSIZE_MSK                          (0xfffUL << AG903_PGPn_SIZE_VSIZE_POS)                        /** PGPnSIZE VSIZE-bit mask */

#define AG903_PGPn_POS_HPOS_POS                            0                                                             /** PGPnPOS HPOS-bit position */
#define AG903_PGPn_POS_HPOS_MSK                            (0x1fffUL << AG903_PGPn_POS_HPOS_POS)                         /** PGPnPOS HPOS-bit mask */
#define AG903_PGPn_POS_VPOS_POS                            16                                                            /** PGPnPOS VPOS-bit position */
#define AG903_PGPn_POS_VPOS_MSK                            (0x1fffUL << AG903_PGPn_POS_VPOS_POS)                         /** PGPnPOS VPOS-bit mask */
#define AG903_PGPn_POS_SCAN_POS                            29                                                            /** PGPnPOS SCAN-bit position */
#define AG903_PGPn_POS_SCAN_MSK                            (0x1UL << AG903_PGPn_POS_SCAN_POS)                            /** PGPnPOS SCAN-bit mask */
#define AG903_PGPn_POS_OPOS_POS                            30                                                            /** PGPnPOS OPOS-bit position */
#define AG903_PGPn_POS_OPOS_MSK                            (0x1UL << AG903_PGPn_POS_OPOS_POS)                            /** PGPnPOS OPOS-bit mask */
#define AG903_PGPn_POS_EPOS_POS                            31                                                            /** PGPnPOS EPOS-bit position */
#define AG903_PGPn_POS_EPOS_MSK                            (0x1UL << AG903_PGPn_POS_EPOS_POS)                            /** PGPnPOS EPOS-bit mask */

#define AG903_PGPn_OUTCTRL0_FMT_POS                        0                                                             /** PGPnOUTCTRL0 FMT-bit position */
#define AG903_PGPn_OUTCTRL0_FMT_MSK                        (0xfUL << AG903_PGPn_OUTCTRL0_FMT_POS)                        /** PGPnOUTCTRL0 FMT-bit mask */
#define AG903_PGPn_OUTCTRL0_MD_POS                         4                                                             /** PGPnOUTCTRL0 MD-bit position */
#define AG903_PGPn_OUTCTRL0_MD_MSK                         (0x7UL << AG903_PGPn_OUTCTRL0_MD_POS)                         /** PGPnOUTCTRL0 MD-bit mask */
#define AG903_PGPn_OUTCTRL0_SWAP1_POS                      8                                                             /** PGPnOUTCTRL0 SWAP1-bit position */
#define AG903_PGPn_OUTCTRL0_SWAP1_MSK                      (0x1UL << AG903_PGPn_OUTCTRL0_SWAP1_POS)                      /** PGPnOUTCTRL0 SWAP1-bit mask */
#define AG903_PGPn_OUTCTRL0_SWAP4_POS                      9                                                             /** PGPnOUTCTRL0 SWAP4-bit position */
#define AG903_PGPn_OUTCTRL0_SWAP4_MSK                      (0x1UL << AG903_PGPn_OUTCTRL0_SWAP4_POS)                      /** PGPnOUTCTRL0 SWAP4-bit mask */
#define AG903_PGPn_OUTCTRL0_SWAPH_POS                      10                                                            /** PGPnOUTCTRL0 SWAPH-bit position */
#define AG903_PGPn_OUTCTRL0_SWAPH_MSK                      (0x1UL << AG903_PGPn_OUTCTRL0_SWAPH_POS)                      /** PGPnOUTCTRL0 SWAPH-bit mask */
#define AG903_PGPn_OUTCTRL0_SWAPW_POS                      11                                                            /** PGPnOUTCTRL0 SWAPW-bit position */
#define AG903_PGPn_OUTCTRL0_SWAPW_MSK                      (0x1UL << AG903_PGPn_OUTCTRL0_SWAPW_POS)                      /** PGPnOUTCTRL0 SWAPW-bit mask */
#define AG903_PGPn_OUTCTRL0_DIM_POS                        12                                                            /** PGPnOUTCTRL0 DIM-bit position */
#define AG903_PGPn_OUTCTRL0_DIM_MSK                        (0x1UL << AG903_PGPn_OUTCTRL0_DIM_POS)                        /** PGPnOUTCTRL0 DIM-bit mask */
#define AG903_PGPn_OUTCTRL0_SCAN_POS                       13                                                            /** PGPnOUTCTRL0 SCAN-bit position */
#define AG903_PGPn_OUTCTRL0_SCAN_MSK                       (0x1UL << AG903_PGPn_OUTCTRL0_SCAN_POS)                       /** PGPnOUTCTRL0 SCAN-bit mask */
#define AG903_PGPn_OUTCTRL0_BMU_POS                        14                                                            /** PGPnOUTCTRL0 BMU-bit position */
#define AG903_PGPn_OUTCTRL0_BMU_MSK                        (0x3UL << AG903_PGPn_OUTCTRL0_BMU_POS)                        /** PGPnOUTCTRL0 BMU-bit mask */
#define AG903_PGPn_OUTCTRL0_DTH_POS                        16                                                            /** PGPnOUTCTRL0 DTH-bit position */
#define AG903_PGPn_OUTCTRL0_DTH_MSK                        (0x1UL << AG903_PGPn_OUTCTRL0_DTH_POS)                        /** PGPnOUTCTRL0 DTH-bit mask */
#define AG903_PGPn_OUTCTRL0_FAI_POS                        17                                                            /** PGPnOUTCTRL0 FAI-bit position */
#define AG903_PGPn_OUTCTRL0_FAI_MSK                        (0x1UL << AG903_PGPn_OUTCTRL0_FAI_POS)                        /** PGPnOUTCTRL0 FAI-bit mask */
#define AG903_PGPn_OUTCTRL0_LIMIT_POS                      18                                                            /** PGPnOUTCTRL0 LIMIT-bit position */
#define AG903_PGPn_OUTCTRL0_LIMIT_MSK                      (0x1UL << AG903_PGPn_OUTCTRL0_LIMIT_POS)                      /** PGPnOUTCTRL0 LIMIT-bit mask */
#define AG903_PGPn_OUTCTRL0_PAD_POS                        24                                                            /** PGPnOUTCTRL0 PAD-bit position */
#define AG903_PGPn_OUTCTRL0_PAD_MSK                        (0xffUL << AG903_PGPn_OUTCTRL0_PAD_POS)                       /** PGPnOUTCTRL0 PAD-bit mask */

#define AG903_PGPn_OUTCTRL1_BE_POS                         0                                                             /** PGPnOUTCTRL1 BE-bit position */
#define AG903_PGPn_OUTCTRL1_BE_MSK                         (0x1UL << AG903_PGPn_OUTCTRL1_BE_POS)                         /** PGPnOUTCTRL1 BE-bit mask */
#define AG903_PGPn_OUTCTRL1_GE_POS                         1                                                             /** PGPnOUTCTRL1 GE-bit position */
#define AG903_PGPn_OUTCTRL1_GE_MSK                         (0x1UL << AG903_PGPn_OUTCTRL1_GE_POS)                         /** PGPnOUTCTRL1 GE-bit mask */
#define AG903_PGPn_OUTCTRL1_RE_POS                         2                                                             /** PGPnOUTCTRL1 RE-bit position */
#define AG903_PGPn_OUTCTRL1_RE_MSK                         (0x1UL << AG903_PGPn_OUTCTRL1_RE_POS)                         /** PGPnOUTCTRL1 RE-bit mask */

#define AG903_PGPn_OUTBASE_ADR_POS                         3                                                             /** PGPnOUTBASE ADR-bit position */
#define AG903_PGPn_OUTBASE_ADR_MSK                         (0x1fffffffUL << AG903_PGPn_OUTBASE_ADR_POS)                  /** PGPnOUTBASE ADR-bit mask */

#define AG903_PGPn_OUTHSIZE_HSIZE_POS                      0                                                             /** PGPnOUTHSIZE HSIZE-bit position */
#define AG903_PGPn_OUTHSIZE_HSIZE_MSK                      (0x3fffUL << AG903_PGPn_OUTHSIZE_HSIZE_POS)                   /** PGPnOUTHSIZE HSIZE-bit mask */

#define AG903_PGPn_FAIVAL0_TMSTMP_POS                      0                                                             /** PGPnFAIVAL0 TMSTMP-bit position */
#define AG903_PGPn_FAIVAL0_TMSTMP_MSK                      (0xffffffffUL << AG903_PGPn_FAIVAL0_TMSTMP_POS)               /** PGPnFAIVAL0 TMSTMP-bit mask */

#define AG903_PGPn_FAIVAL1_FNUM_POS                        0                                                             /** PGPnFAIVAL1 FNUM-bit position */
#define AG903_PGPn_FAIVAL1_FNUM_MSK                        (0xffffUL << AG903_PGPn_FAIVAL1_FNUM_POS)                     /** PGPnFAIVAL1 FNUM-bit mask */
#define AG903_PGPn_FAIVAL1_PORT_POS                        16                                                            /** PGPnFAIVAL1 PORT-bit position */
#define AG903_PGPn_FAIVAL1_PORT_MSK                        (0x7UL << AG903_PGPn_FAIVAL1_PORT_POS)                        /** PGPnFAIVAL1 PORT-bit mask */
#define AG903_PGPn_FAIVAL1_FIELD_POS                       19                                                            /** PGPnFAIVAL1 FIELD-bit position */
#define AG903_PGPn_FAIVAL1_FIELD_MSK                       (0x1UL << AG903_PGPn_FAIVAL1_FIELD_POS)                       /** PGPnFAIVAL1 FIELD-bit mask */

#define AG903_PGPn_IPCPRM_BLKC_POS                         0                                                             /** PGPnIPCPRM BLKC-bit position */
#define AG903_PGPn_IPCPRM_BLKC_MSK                         (0xffUL << AG903_PGPn_IPCPRM_BLKC_POS)                        /** PGPnIPCPRM BLKC-bit mask */
#define AG903_PGPn_IPCPRM_BLKY_POS                         8                                                             /** PGPnIPCPRM BLKY-bit position */
#define AG903_PGPn_IPCPRM_BLKY_MSK                         (0xffUL << AG903_PGPn_IPCPRM_BLKY_POS)                        /** PGPnIPCPRM BLKY-bit mask */
#define AG903_PGPn_IPCPRM_LIMIT_POS                        16                                                            /** PGPnIPCPRM LIMIT-bit position */
#define AG903_PGPn_IPCPRM_LIMIT_MSK                        (0x1UL << AG903_PGPn_IPCPRM_LIMIT_POS)                        /** PGPnIPCPRM LIMIT-bit mask */

#define AG903_PGPn_CSC1CTRL_SFT_POS                        0                                                             /** PGPnCSC1CTRL SFT-bit position */
#define AG903_PGPn_CSC1CTRL_SFT_MSK                        (0xfUL << AG903_PGPn_CSC1CTRL_SFT_POS)                        /** PGPnCSC1CTRL SFT-bit mask */
#define AG903_PGPn_CSC1CTRL_LIMIT_POS                      4                                                             /** PGPnCSC1CTRL LIMIT-bit position */
#define AG903_PGPn_CSC1CTRL_LIMIT_MSK                      (0x1UL << AG903_PGPn_CSC1CTRL_LIMIT_POS)                      /** PGPnCSC1CTRL LIMIT-bit mask */

#define AG903_PGPn_CSC1PRM0_M11_POS                        0                                                             /** PGPnCSC1PRM0 M11-bit position */
#define AG903_PGPn_CSC1PRM0_M11_MSK                        (0xfffUL << AG903_PGPn_CSC1PRM0_M11_POS)                      /** PGPnCSC1PRM0 M11-bit mask */
#define AG903_PGPn_CSC1PRM0_M12_POS                        16                                                            /** PGPnCSC1PRM0 M12-bit position */
#define AG903_PGPn_CSC1PRM0_M12_MSK                        (0xfffUL << AG903_PGPn_CSC1PRM0_M12_POS)                      /** PGPnCSC1PRM0 M12-bit mask */

#define AG903_PGPn_CSC1PRM1_M13_POS                        0                                                             /** PGPnCSC1PRM1 M13-bit position */
#define AG903_PGPn_CSC1PRM1_M13_MSK                        (0xfffUL << AG903_PGPn_CSC1PRM1_M13_POS)                      /** PGPnCSC1PRM1 M13-bit mask */

#define AG903_PGPn_CSC1PRM2_M14_POS                        0                                                             /** PGPnCSC1PRM2 M14-bit position */
#define AG903_PGPn_CSC1PRM2_M14_MSK                        (0xfffffUL << AG903_PGPn_CSC1PRM2_M14_POS)                    /** PGPnCSC1PRM2 M14-bit mask */

#define AG903_PGPn_CSC1PRM3_M21_POS                        0                                                             /** PGPnCSC1PRM3 M21-bit position */
#define AG903_PGPn_CSC1PRM3_M21_MSK                        (0xfffUL << AG903_PGPn_CSC1PRM3_M21_POS)                      /** PGPnCSC1PRM3 M21-bit mask */
#define AG903_PGPn_CSC1PRM3_M22_POS                        16                                                            /** PGPnCSC1PRM3 M22-bit position */
#define AG903_PGPn_CSC1PRM3_M22_MSK                        (0xfffUL << AG903_PGPn_CSC1PRM3_M22_POS)                      /** PGPnCSC1PRM3 M22-bit mask */

#define AG903_PGPn_CSC1PRM4_M23_POS                        0                                                             /** PGPnCSC1PRM4 M23-bit position */
#define AG903_PGPn_CSC1PRM4_M23_MSK                        (0xfffUL << AG903_PGPn_CSC1PRM4_M23_POS)                      /** PGPnCSC1PRM4 M23-bit mask */

#define AG903_PGPn_CSC1PRM5_M24_POS                        0                                                             /** PGPnCSC1PRM5 M24-bit position */
#define AG903_PGPn_CSC1PRM5_M24_MSK                        (0xfffffUL << AG903_PGPn_CSC1PRM5_M24_POS)                    /** PGPnCSC1PRM5 M24-bit mask */

#define AG903_PGPn_CSC1PRM6_M31_POS                        0                                                             /** PGPnCSC1PRM6 M31-bit position */
#define AG903_PGPn_CSC1PRM6_M31_MSK                        (0xfffUL << AG903_PGPn_CSC1PRM6_M31_POS)                      /** PGPnCSC1PRM6 M31-bit mask */
#define AG903_PGPn_CSC1PRM6_M32_POS                        16                                                            /** PGPnCSC1PRM6 M32-bit position */
#define AG903_PGPn_CSC1PRM6_M32_MSK                        (0xfffUL << AG903_PGPn_CSC1PRM6_M32_POS)                      /** PGPnCSC1PRM6 M32-bit mask */

#define AG903_PGPn_CSC1PRM7_M33_POS                        0                                                             /** PGPnCSC1PRM7 M33-bit position */
#define AG903_PGPn_CSC1PRM7_M33_MSK                        (0xfffUL << AG903_PGPn_CSC1PRM7_M33_POS)                      /** PGPnCSC1PRM7 M33-bit mask */

#define AG903_PGPn_CSC1PRM8_M34_POS                        0                                                             /** PGPnCSC1PRM8 M34-bit position */
#define AG903_PGPn_CSC1PRM8_M34_MSK                        (0xfffffUL << AG903_PGPn_CSC1PRM8_M34_POS)                    /** PGPnCSC1PRM8 M34-bit mask */

#define AG903_PGPn_SCCTRL_DNMH_POS                         0                                                             /** PGPnSCCTRL DNMH-bit position */
#define AG903_PGPn_SCCTRL_DNMH_MSK                         (0xfUL << AG903_PGPn_SCCTRL_DNMH_POS)                         /** PGPnSCCTRL DNMH-bit mask */
#define AG903_PGPn_SCCTRL_NMRH_POS                         4                                                             /** PGPnSCCTRL NMRH-bit position */
#define AG903_PGPn_SCCTRL_NMRH_MSK                         (0xfUL << AG903_PGPn_SCCTRL_NMRH_POS)                         /** PGPnSCCTRL NMRH-bit mask */
#define AG903_PGPn_SCCTRL_DNMV_POS                         8                                                             /** PGPnSCCTRL DNMV-bit position */
#define AG903_PGPn_SCCTRL_DNMV_MSK                         (0xfUL << AG903_PGPn_SCCTRL_DNMV_POS)                         /** PGPnSCCTRL DNMV-bit mask */
#define AG903_PGPn_SCCTRL_NMRV_POS                         12                                                            /** PGPnSCCTRL NMRV-bit position */
#define AG903_PGPn_SCCTRL_NMRV_MSK                         (0xfUL << AG903_PGPn_SCCTRL_NMRV_POS)                         /** PGPnSCCTRL NMRV-bit mask */
#define AG903_PGPn_SCCTRL_MTD_POS                          16                                                            /** PGPnSCCTRL MTD-bit position */
#define AG903_PGPn_SCCTRL_MTD_MSK                          (0x1UL << AG903_PGPn_SCCTRL_MTD_POS)                          /** PGPnSCCTRL MTD-bit mask */
#define AG903_PGPn_SCCTRL_LIMIT_POS                        17                                                            /** PGPnSCCTRL LIMIT-bit position */
#define AG903_PGPn_SCCTRL_LIMIT_MSK                        (0x1UL << AG903_PGPn_SCCTRL_LIMIT_POS)                        /** PGPnSCCTRL LIMIT-bit mask */

#define AG903_PGPn_SPFCTRL_B_POS                           0                                                             /** PGPnSPFCTRL B-bit position */
#define AG903_PGPn_SPFCTRL_B_MSK                           (0xffUL << AG903_PGPn_SPFCTRL_B_POS)                          /** PGPnSPFCTRL B-bit mask */
#define AG903_PGPn_SPFCTRL_G_POS                           8                                                             /** PGPnSPFCTRL G-bit position */
#define AG903_PGPn_SPFCTRL_G_MSK                           (0xffUL << AG903_PGPn_SPFCTRL_G_POS)                          /** PGPnSPFCTRL G-bit mask */
#define AG903_PGPn_SPFCTRL_R_POS                           16                                                            /** PGPnSPFCTRL R-bit position */
#define AG903_PGPn_SPFCTRL_R_MSK                           (0xffUL << AG903_PGPn_SPFCTRL_R_POS)                          /** PGPnSPFCTRL R-bit mask */
#define AG903_PGPn_SPFCTRL_BC_POS                          24                                                            /** PGPnSPFCTRL BC-bit position */
#define AG903_PGPn_SPFCTRL_BC_MSK                          (0x1UL << AG903_PGPn_SPFCTRL_BC_POS)                          /** PGPnSPFCTRL BC-bit mask */
#define AG903_PGPn_SPFCTRL_SFT_POS                         28                                                            /** PGPnSPFCTRL SFT-bit position */
#define AG903_PGPn_SPFCTRL_SFT_MSK                         (0xfUL << AG903_PGPn_SPFCTRL_SFT_POS)                         /** PGPnSPFCTRL SFT-bit mask */

#define AG903_PGPn_SPFPRM0_HMM_POS                         0                                                             /** PGPnSPFPRM0 HMM-bit position */
#define AG903_PGPn_SPFPRM0_HMM_MSK                         (0xffUL << AG903_PGPn_SPFPRM0_HMM_POS)                        /** PGPnSPFPRM0 HMM-bit mask */
#define AG903_PGPn_SPFPRM0_H0M_POS                         8                                                             /** PGPnSPFPRM0 H0M-bit position */
#define AG903_PGPn_SPFPRM0_H0M_MSK                         (0xffUL << AG903_PGPn_SPFPRM0_H0M_POS)                        /** PGPnSPFPRM0 H0M-bit mask */
#define AG903_PGPn_SPFPRM0_H1M_POS                         16                                                            /** PGPnSPFPRM0 H1M-bit position */
#define AG903_PGPn_SPFPRM0_H1M_MSK                         (0xffUL << AG903_PGPn_SPFPRM0_H1M_POS)                        /** PGPnSPFPRM0 H1M-bit mask */

#define AG903_PGPn_SPFPRM1_HM0_POS                         0                                                             /** PGPnSPFPRM1 HM0-bit position */
#define AG903_PGPn_SPFPRM1_HM0_MSK                         (0xffUL << AG903_PGPn_SPFPRM1_HM0_POS)                        /** PGPnSPFPRM1 HM0-bit mask */
#define AG903_PGPn_SPFPRM1_H00_POS                         8                                                             /** PGPnSPFPRM1 H00-bit position */
#define AG903_PGPn_SPFPRM1_H00_MSK                         (0xffUL << AG903_PGPn_SPFPRM1_H00_POS)                        /** PGPnSPFPRM1 H00-bit mask */
#define AG903_PGPn_SPFPRM1_H10_POS                         16                                                            /** PGPnSPFPRM1 H10-bit position */
#define AG903_PGPn_SPFPRM1_H10_MSK                         (0xffUL << AG903_PGPn_SPFPRM1_H10_POS)                        /** PGPnSPFPRM1 H10-bit mask */

#define AG903_PGPn_SPFPRM2_HM1_POS                         0                                                             /** PGPnSPFPRM2 HM1-bit position */
#define AG903_PGPn_SPFPRM2_HM1_MSK                         (0xffUL << AG903_PGPn_SPFPRM2_HM1_POS)                        /** PGPnSPFPRM2 HM1-bit mask */
#define AG903_PGPn_SPFPRM2_H01_POS                         8                                                             /** PGPnSPFPRM2 H01-bit position */
#define AG903_PGPn_SPFPRM2_H01_MSK                         (0xffUL << AG903_PGPn_SPFPRM2_H01_POS)                        /** PGPnSPFPRM2 H01-bit mask */
#define AG903_PGPn_SPFPRM2_H11_POS                         16                                                            /** PGPnSPFPRM2 H11-bit position */
#define AG903_PGPn_SPFPRM2_H11_MSK                         (0xffUL << AG903_PGPn_SPFPRM2_H11_POS)                        /** PGPnSPFPRM2 H11-bit mask */

#define AG903_PGPn_SPFPRM3_OFS_POS                         0                                                             /** PGPnSPFPRM3 OFS-bit position */
#define AG903_PGPn_SPFPRM3_OFS_MSK                         (0x1ffUL << AG903_PGPn_SPFPRM3_OFS_POS)                       /** PGPnSPFPRM3 OFS-bit mask */

#define AG903_PGPn_HSV1CTRL_FMT_POS                        0                                                             /** PGPnHSV1CTRL FMT-bit position */
#define AG903_PGPn_HSV1CTRL_FMT_MSK                        (0x1UL << AG903_PGPn_HSV1CTRL_FMT_POS)                        /** PGPnHSV1CTRL FMT-bit mask */

#define AG903_PGPn_DGCSTAT_QUEUE_POS                       0                                                             /** PGPnDGCSTAT QUEUE-bit position */
#define AG903_PGPn_DGCSTAT_QUEUE_MSK                       (0x7UL << AG903_PGPn_DGCSTAT_QUEUE_POS)                       /** PGPnDGCSTAT QUEUE-bit mask */

#define AG903_PGPn_HGMCMD_CMD_POS                          0                                                             /** PGPnHGMCMD CMD-bit position */
#define AG903_PGPn_HGMCMD_CMD_MSK                          (0x7UL << AG903_PGPn_HGMCMD_CMD_POS)                          /** PGPnHGMCMD CMD-bit mask */

#define AG903_PGPn_HGMCTRL_HINC_POS                        0                                                             /** PGPnHGMCTRL HINC-bit position */
#define AG903_PGPn_HGMCTRL_HINC_MSK                        (0xfUL << AG903_PGPn_HGMCTRL_HINC_POS)                        /** PGPnHGMCTRL HINC-bit mask */
#define AG903_PGPn_HGMCTRL_VINC_POS                        4                                                             /** PGPnHGMCTRL VINC-bit position */
#define AG903_PGPn_HGMCTRL_VINC_MSK                        (0xfUL << AG903_PGPn_HGMCTRL_VINC_POS)                        /** PGPnHGMCTRL VINC-bit mask */
#define AG903_PGPn_HGMCTRL_SFT_POS                         8                                                             /** PGPnHGMCTRL SFT-bit position */
#define AG903_PGPn_HGMCTRL_SFT_MSK                         (0xfUL << AG903_PGPn_HGMCTRL_SFT_POS)                         /** PGPnHGMCTRL SFT-bit mask */
#define AG903_PGPn_HGMCTRL_THR_POS                         12                                                            /** PGPnHGMCTRL THR-bit position */
#define AG903_PGPn_HGMCTRL_THR_MSK                         (0xfUL << AG903_PGPn_HGMCTRL_THR_POS)                         /** PGPnHGMCTRL THR-bit mask */
#define AG903_PGPn_HGMCTRL_EXC_POS                         16                                                            /** PGPnHGMCTRL EXC-bit position */
#define AG903_PGPn_HGMCTRL_EXC_MSK                         (0x3UL << AG903_PGPn_HGMCTRL_EXC_POS)                         /** PGPnHGMCTRL EXC-bit mask */
#define AG903_PGPn_HGMCTRL_BMU_POS                         18                                                            /** PGPnHGMCTRL BMU-bit position */
#define AG903_PGPn_HGMCTRL_BMU_MSK                         (0x1UL << AG903_PGPn_HGMCTRL_BMU_POS)                         /** PGPnHGMCTRL BMU-bit mask */
#define AG903_PGPn_HGMCTRL_INV_POS                         24                                                            /** PGPnHGMCTRL INV-bit position */
#define AG903_PGPn_HGMCTRL_INV_MSK                         (0xfUL << AG903_PGPn_HGMCTRL_INV_POS)                         /** PGPnHGMCTRL INV-bit mask */

#define AG903_PGPn_HGMSIZE_HSIZE_POS                       0                                                             /** PGPnHGMSIZE HSIZE-bit position */
#define AG903_PGPn_HGMSIZE_HSIZE_MSK                       (0x3ffUL << AG903_PGPn_HGMSIZE_HSIZE_POS)                     /** PGPnHGMSIZE HSIZE-bit mask */
#define AG903_PGPn_HGMSIZE_VSIZE_POS                       16                                                            /** PGPnHGMSIZE VSIZE-bit position */
#define AG903_PGPn_HGMSIZE_VSIZE_MSK                       (0x3ffUL << AG903_PGPn_HGMSIZE_VSIZE_POS)                     /** PGPnHGMSIZE VSIZE-bit mask */

#define AG903_PGPn_HGMPOS_HPOS_POS                         0                                                             /** PGPnHGMPOS HPOS-bit position */
#define AG903_PGPn_HGMPOS_HPOS_MSK                         (0xfffUL << AG903_PGPn_HGMPOS_HPOS_POS)                       /** PGPnHGMPOS HPOS-bit mask */
#define AG903_PGPn_HGMPOS_VPOS_POS                         16                                                            /** PGPnHGMPOS VPOS-bit position */
#define AG903_PGPn_HGMPOS_VPOS_MSK                         (0xfffUL << AG903_PGPn_HGMPOS_VPOS_POS)                       /** PGPnHGMPOS VPOS-bit mask */

#define AG903_PGPn_HGMDST_ADR_POS                          3                                                             /** PGPnHGMDST ADR-bit position */
#define AG903_PGPn_HGMDST_ADR_MSK                          (0x1fffffffUL << AG903_PGPn_HGMDST_ADR_POS)                   /** PGPnHGMDST ADR-bit mask */

#define AG903_PGPn_HGMMOD0_CNT_POS                         0                                                             /** PGPnHGMMOD0 CNT-bit position */
#define AG903_PGPn_HGMMOD0_CNT_MSK                         (0xffffUL << AG903_PGPn_HGMMOD0_CNT_POS)                      /** PGPnHGMMOD0 CNT-bit mask */
#define AG903_PGPn_HGMMOD0_VAL_POS                         16                                                            /** PGPnHGMMOD0 VAL-bit position */
#define AG903_PGPn_HGMMOD0_VAL_MSK                         (0xffUL << AG903_PGPn_HGMMOD0_VAL_POS)                        /** PGPnHGMMOD0 VAL-bit mask */
#define AG903_PGPn_HGMMOD0_BW_POS                          24                                                            /** PGPnHGMMOD0 BW-bit position */
#define AG903_PGPn_HGMMOD0_BW_MSK                          (0x1fUL << AG903_PGPn_HGMMOD0_BW_POS)                         /** PGPnHGMMOD0 BW-bit mask */

#define AG903_PGPn_HGMRNG0_MINVAL_POS                      0                                                             /** PGPnHGMRNG0 MINVAL-bit position */
#define AG903_PGPn_HGMRNG0_MINVAL_MSK                      (0xffUL << AG903_PGPn_HGMRNG0_MINVAL_POS)                     /** PGPnHGMRNG0 MINVAL-bit mask */
#define AG903_PGPn_HGMRNG0_MAXVAL_POS                      8                                                             /** PGPnHGMRNG0 MAXVAL-bit position */
#define AG903_PGPn_HGMRNG0_MAXVAL_MSK                      (0xffUL << AG903_PGPn_HGMRNG0_MAXVAL_POS)                     /** PGPnHGMRNG0 MAXVAL-bit mask */

#define AG903_PGPn_HGMMOD1_CNT_POS                         0                                                             /** PGPnHGMMOD1 CNT-bit position */
#define AG903_PGPn_HGMMOD1_CNT_MSK                         (0xffffUL << AG903_PGPn_HGMMOD1_CNT_POS)                      /** PGPnHGMMOD1 CNT-bit mask */
#define AG903_PGPn_HGMMOD1_VAL_POS                         16                                                            /** PGPnHGMMOD1 VAL-bit position */
#define AG903_PGPn_HGMMOD1_VAL_MSK                         (0xffUL << AG903_PGPn_HGMMOD1_VAL_POS)                        /** PGPnHGMMOD1 VAL-bit mask */
#define AG903_PGPn_HGMMOD1_BW_POS                          24                                                            /** PGPnHGMMOD1 BW-bit position */
#define AG903_PGPn_HGMMOD1_BW_MSK                          (0x1fUL << AG903_PGPn_HGMMOD1_BW_POS)                         /** PGPnHGMMOD1 BW-bit mask */

#define AG903_PGPn_HGMRNG1_MINVAL_POS                      0                                                             /** PGPnHGMRNG1 MINVAL-bit position */
#define AG903_PGPn_HGMRNG1_MINVAL_MSK                      (0xffUL << AG903_PGPn_HGMRNG1_MINVAL_POS)                     /** PGPnHGMRNG1 MINVAL-bit mask */
#define AG903_PGPn_HGMRNG1_MAXVAL_POS                      8                                                             /** PGPnHGMRNG1 MAXVAL-bit position */
#define AG903_PGPn_HGMRNG1_MAXVAL_MSK                      (0xffUL << AG903_PGPn_HGMRNG1_MAXVAL_POS)                     /** PGPnHGMRNG1 MAXVAL-bit mask */

#define AG903_PGPn_HGMMOD2_CNT_POS                         0                                                             /** PGPnHGMMOD2 CNT-bit position */
#define AG903_PGPn_HGMMOD2_CNT_MSK                         (0xffffUL << AG903_PGPn_HGMMOD2_CNT_POS)                      /** PGPnHGMMOD2 CNT-bit mask */
#define AG903_PGPn_HGMMOD2_VAL_POS                         16                                                            /** PGPnHGMMOD2 VAL-bit position */
#define AG903_PGPn_HGMMOD2_VAL_MSK                         (0xffUL << AG903_PGPn_HGMMOD2_VAL_POS)                        /** PGPnHGMMOD2 VAL-bit mask */
#define AG903_PGPn_HGMMOD2_BW_POS                          24                                                            /** PGPnHGMMOD2 BW-bit position */
#define AG903_PGPn_HGMMOD2_BW_MSK                          (0x1fUL << AG903_PGPn_HGMMOD2_BW_POS)                         /** PGPnHGMMOD2 BW-bit mask */

#define AG903_PGPn_HGMRNG2_MINVAL_POS                      0                                                             /** PGPnHGMRNG2 MINVAL-bit position */
#define AG903_PGPn_HGMRNG2_MINVAL_MSK                      (0xffUL << AG903_PGPn_HGMRNG2_MINVAL_POS)                     /** PGPnHGMRNG2 MINVAL-bit mask */
#define AG903_PGPn_HGMRNG2_MAXVAL_POS                      8                                                             /** PGPnHGMRNG2 MAXVAL-bit position */
#define AG903_PGPn_HGMRNG2_MAXVAL_MSK                      (0xffUL << AG903_PGPn_HGMRNG2_MAXVAL_POS)                     /** PGPnHGMRNG2 MAXVAL-bit mask */

#define AG903_PGPn_HGMSTAT_CMD_POS                         0                                                             /** PGPnHGMSTAT CMD-bit position */
#define AG903_PGPn_HGMSTAT_CMD_MSK                         (0x7UL << AG903_PGPn_HGMSTAT_CMD_POS)                         /** PGPnHGMSTAT CMD-bit mask */
#define AG903_PGPn_HGMSTAT_QUEUE_POS                       4                                                             /** PGPnHGMSTAT QUEUE-bit position */
#define AG903_PGPn_HGMSTAT_QUEUE_MSK                       (0x3UL << AG903_PGPn_HGMSTAT_QUEUE_POS)                       /** PGPnHGMSTAT QUEUE-bit mask */
#define AG903_PGPn_HGMSTAT_ACT_POS                         6                                                             /** PGPnHGMSTAT ACT-bit position */
#define AG903_PGPn_HGMSTAT_ACT_MSK                         (0x1UL << AG903_PGPn_HGMSTAT_ACT_POS)                         /** PGPnHGMSTAT ACT-bit mask */
#define AG903_PGPn_HGMSTAT_VRMACC_POS                      7                                                             /** PGPnHGMSTAT VRMACC-bit position */
#define AG903_PGPn_HGMSTAT_VRMACC_MSK                      (0x1UL << AG903_PGPn_HGMSTAT_VRMACC_POS)                      /** PGPnHGMSTAT VRMACC-bit mask */
#define AG903_PGPn_HGMSTAT_INIT_POS                        8                                                             /** PGPnHGMSTAT INIT-bit position */
#define AG903_PGPn_HGMSTAT_INIT_MSK                        (0x1UL << AG903_PGPn_HGMSTAT_INIT_POS)                        /** PGPnHGMSTAT INIT-bit mask */

#define AG903_PGPn_THRCTRL_C8SEL_POS                       0                                                             /** PGPnTHRCTRL C8SEL-bit position */
#define AG903_PGPn_THRCTRL_C8SEL_MSK                       (0x3UL << AG903_PGPn_THRCTRL_C8SEL_POS)                       /** PGPnTHRCTRL C8SEL-bit mask */
#define AG903_PGPn_THRCTRL_OUTSEL_POS                      2                                                             /** PGPnTHRCTRL OUTSEL-bit position */
#define AG903_PGPn_THRCTRL_OUTSEL_MSK                      (0x3UL << AG903_PGPn_THRCTRL_OUTSEL_POS)                      /** PGPnTHRCTRL OUTSEL-bit mask */
#define AG903_PGPn_THRCTRL_THR8_POS                        4                                                             /** PGPnTHRCTRL THR8-bit position */
#define AG903_PGPn_THRCTRL_THR8_MSK                        (0x1UL << AG903_PGPn_THRCTRL_THR8_POS)                        /** PGPnTHRCTRL THR8-bit mask */
#define AG903_PGPn_THRCTRL_HSV2_POS                        5                                                             /** PGPnTHRCTRL HSV2-bit position */
#define AG903_PGPn_THRCTRL_HSV2_MSK                        (0x1UL << AG903_PGPn_THRCTRL_HSV2_POS)                        /** PGPnTHRCTRL HSV2-bit mask */
#define AG903_PGPn_THRCTRL_CSC2_POS                        6                                                             /** PGPnTHRCTRL CSC2-bit position */
#define AG903_PGPn_THRCTRL_CSC2_MSK                        (0x1UL << AG903_PGPn_THRCTRL_CSC2_POS)                        /** PGPnTHRCTRL CSC2-bit mask */
#define AG903_PGPn_THRCTRL_MSK_POS                         7                                                             /** PGPnTHRCTRL MSK-bit position */
#define AG903_PGPn_THRCTRL_MSK_MSK                         (0x1UL << AG903_PGPn_THRCTRL_MSK_POS)                         /** PGPnTHRCTRL MSK-bit mask */
#define AG903_PGPn_THRCTRL_SPF1_POS                        8                                                             /** PGPnTHRCTRL SPF1-bit position */
#define AG903_PGPn_THRCTRL_SPF1_MSK                        (0x1UL << AG903_PGPn_THRCTRL_SPF1_POS)                        /** PGPnTHRCTRL SPF1-bit mask */
#define AG903_PGPn_THRCTRL_LIMIT_POS                       9                                                             /** PGPnTHRCTRL LIMIT-bit position */
#define AG903_PGPn_THRCTRL_LIMIT_MSK                       (0x1UL << AG903_PGPn_THRCTRL_LIMIT_POS)                       /** PGPnTHRCTRL LIMIT-bit mask */

#define AG903_PGPn_HSV2CTRL_FMT_POS                        0                                                             /** PGPnHSV2CTRL FMT-bit position */
#define AG903_PGPn_HSV2CTRL_FMT_MSK                        (0x1UL << AG903_PGPn_HSV2CTRL_FMT_POS)                        /** PGPnHSV2CTRL FMT-bit mask */

#define AG903_PGPn_CSC2CTRL_SFT_POS                        0                                                             /** PGPnCSC2CTRL SFT-bit position */
#define AG903_PGPn_CSC2CTRL_SFT_MSK                        (0xfUL << AG903_PGPn_CSC2CTRL_SFT_POS)                        /** PGPnCSC2CTRL SFT-bit mask */
#define AG903_PGPn_CSC2CTRL_LIMIT_POS                      4                                                             /** PGPnCSC2CTRL LIMIT-bit position */
#define AG903_PGPn_CSC2CTRL_LIMIT_MSK                      (0x1UL << AG903_PGPn_CSC2CTRL_LIMIT_POS)                      /** PGPnCSC2CTRL LIMIT-bit mask */

#define AG903_PGPn_CSC2PRM0_M11_POS                        0                                                             /** PGPnCSC2PRM0 M11-bit position */
#define AG903_PGPn_CSC2PRM0_M11_MSK                        (0xfffUL << AG903_PGPn_CSC2PRM0_M11_POS)                      /** PGPnCSC2PRM0 M11-bit mask */
#define AG903_PGPn_CSC2PRM0_M12_POS                        16                                                            /** PGPnCSC2PRM0 M12-bit position */
#define AG903_PGPn_CSC2PRM0_M12_MSK                        (0xfffUL << AG903_PGPn_CSC2PRM0_M12_POS)                      /** PGPnCSC2PRM0 M12-bit mask */

#define AG903_PGPn_CSC2PRM1_M13_POS                        0                                                             /** PGPnCSC2PRM1 M13-bit position */
#define AG903_PGPn_CSC2PRM1_M13_MSK                        (0xfffUL << AG903_PGPn_CSC2PRM1_M13_POS)                      /** PGPnCSC2PRM1 M13-bit mask */

#define AG903_PGPn_CSC2PRM2_M14_POS                        0                                                             /** PGPnCSC2PRM2 M14-bit position */
#define AG903_PGPn_CSC2PRM2_M14_MSK                        (0xfffffUL << AG903_PGPn_CSC2PRM2_M14_POS)                    /** PGPnCSC2PRM2 M14-bit mask */

#define AG903_PGPn_CSC2PRM3_M21_POS                        0                                                             /** PGPnCSC2PRM3 M21-bit position */
#define AG903_PGPn_CSC2PRM3_M21_MSK                        (0xfffUL << AG903_PGPn_CSC2PRM3_M21_POS)                      /** PGPnCSC2PRM3 M21-bit mask */
#define AG903_PGPn_CSC2PRM3_M22_POS                        16                                                            /** PGPnCSC2PRM3 M22-bit position */
#define AG903_PGPn_CSC2PRM3_M22_MSK                        (0xfffUL << AG903_PGPn_CSC2PRM3_M22_POS)                      /** PGPnCSC2PRM3 M22-bit mask */

#define AG903_PGPn_CSC2PRM4_M23_POS                        0                                                             /** PGPnCSC2PRM4 M23-bit position */
#define AG903_PGPn_CSC2PRM4_M23_MSK                        (0xfffUL << AG903_PGPn_CSC2PRM4_M23_POS)                      /** PGPnCSC2PRM4 M23-bit mask */

#define AG903_PGPn_CSC2PRM5_M24_POS                        0                                                             /** PGPnCSC2PRM5 M24-bit position */
#define AG903_PGPn_CSC2PRM5_M24_MSK                        (0xfffffUL << AG903_PGPn_CSC2PRM5_M24_POS)                    /** PGPnCSC2PRM5 M24-bit mask */

#define AG903_PGPn_CSC2PRM6_M31_POS                        0                                                             /** PGPnCSC2PRM6 M31-bit position */
#define AG903_PGPn_CSC2PRM6_M31_MSK                        (0xfffUL << AG903_PGPn_CSC2PRM6_M31_POS)                      /** PGPnCSC2PRM6 M31-bit mask */
#define AG903_PGPn_CSC2PRM6_M32_POS                        16                                                            /** PGPnCSC2PRM6 M32-bit position */
#define AG903_PGPn_CSC2PRM6_M32_MSK                        (0xfffUL << AG903_PGPn_CSC2PRM6_M32_POS)                      /** PGPnCSC2PRM6 M32-bit mask */

#define AG903_PGPn_CSC2PRM7_M33_POS                        0                                                             /** PGPnCSC2PRM7 M33-bit position */
#define AG903_PGPn_CSC2PRM7_M33_MSK                        (0xfffUL << AG903_PGPn_CSC2PRM7_M33_POS)                      /** PGPnCSC2PRM7 M33-bit mask */

#define AG903_PGPn_CSC2PRM8_M34_POS                        0                                                             /** PGPnCSC2PRM8 M34-bit position */
#define AG903_PGPn_CSC2PRM8_M34_MSK                        (0xfffffUL << AG903_PGPn_CSC2PRM8_M34_POS)                    /** PGPnCSC2PRM8 M34-bit mask */

#define AG903_PGPn_MSK0PRM0_X_POS                          0                                                             /** PGPnMSK0PRM0 X-bit position */
#define AG903_PGPn_MSK0PRM0_X_MSK                          (0x1UL << AG903_PGPn_MSK0PRM0_X_POS)                          /** PGPnMSK0PRM0 X-bit mask */
#define AG903_PGPn_MSK0PRM0_L_POS                          1                                                             /** PGPnMSK0PRM0 L-bit position */
#define AG903_PGPn_MSK0PRM0_L_MSK                          (0x1UL << AG903_PGPn_MSK0PRM0_L_POS)                          /** PGPnMSK0PRM0 L-bit mask */
#define AG903_PGPn_MSK0PRM0_H_POS                          2                                                             /** PGPnMSK0PRM0 H-bit position */
#define AG903_PGPn_MSK0PRM0_H_MSK                          (0x1UL << AG903_PGPn_MSK0PRM0_H_POS)                          /** PGPnMSK0PRM0 H-bit mask */

#define AG903_PGPn_MSK0PRM1_LMIN_POS                       0                                                             /** PGPnMSK0PRM1 LMIN-bit position */
#define AG903_PGPn_MSK0PRM1_LMIN_MSK                       (0xffUL << AG903_PGPn_MSK0PRM1_LMIN_POS)                      /** PGPnMSK0PRM1 LMIN-bit mask */
#define AG903_PGPn_MSK0PRM1_LMAX_POS                       8                                                             /** PGPnMSK0PRM1 LMAX-bit position */
#define AG903_PGPn_MSK0PRM1_LMAX_MSK                       (0xffUL << AG903_PGPn_MSK0PRM1_LMAX_POS)                      /** PGPnMSK0PRM1 LMAX-bit mask */
#define AG903_PGPn_MSK0PRM1_HMIN_POS                       16                                                            /** PGPnMSK0PRM1 HMIN-bit position */
#define AG903_PGPn_MSK0PRM1_HMIN_MSK                       (0xffUL << AG903_PGPn_MSK0PRM1_HMIN_POS)                      /** PGPnMSK0PRM1 HMIN-bit mask */
#define AG903_PGPn_MSK0PRM1_HMAX_POS                       24                                                            /** PGPnMSK0PRM1 HMAX-bit position */
#define AG903_PGPn_MSK0PRM1_HMAX_MSK                       (0xffUL << AG903_PGPn_MSK0PRM1_HMAX_POS)                      /** PGPnMSK0PRM1 HMAX-bit mask */

#define AG903_PGPn_MSK1PRM0_X_POS                          0                                                             /** PGPnMSK1PRM0 X-bit position */
#define AG903_PGPn_MSK1PRM0_X_MSK                          (0x1UL << AG903_PGPn_MSK1PRM0_X_POS)                          /** PGPnMSK1PRM0 X-bit mask */
#define AG903_PGPn_MSK1PRM0_L_POS                          1                                                             /** PGPnMSK1PRM0 L-bit position */
#define AG903_PGPn_MSK1PRM0_L_MSK                          (0x1UL << AG903_PGPn_MSK1PRM0_L_POS)                          /** PGPnMSK1PRM0 L-bit mask */
#define AG903_PGPn_MSK1PRM0_H_POS                          2                                                             /** PGPnMSK1PRM0 H-bit position */
#define AG903_PGPn_MSK1PRM0_H_MSK                          (0x1UL << AG903_PGPn_MSK1PRM0_H_POS)                          /** PGPnMSK1PRM0 H-bit mask */

#define AG903_PGPn_MSK1PRM1_LMIN_POS                       0                                                             /** PGPnMSK1PRM1 LMIN-bit position */
#define AG903_PGPn_MSK1PRM1_LMIN_MSK                       (0xffUL << AG903_PGPn_MSK1PRM1_LMIN_POS)                      /** PGPnMSK1PRM1 LMIN-bit mask */
#define AG903_PGPn_MSK1PRM1_LMAX_POS                       8                                                             /** PGPnMSK1PRM1 LMAX-bit position */
#define AG903_PGPn_MSK1PRM1_LMAX_MSK                       (0xffUL << AG903_PGPn_MSK1PRM1_LMAX_POS)                      /** PGPnMSK1PRM1 LMAX-bit mask */
#define AG903_PGPn_MSK1PRM1_HMIN_POS                       16                                                            /** PGPnMSK1PRM1 HMIN-bit position */
#define AG903_PGPn_MSK1PRM1_HMIN_MSK                       (0xffUL << AG903_PGPn_MSK1PRM1_HMIN_POS)                      /** PGPnMSK1PRM1 HMIN-bit mask */
#define AG903_PGPn_MSK1PRM1_HMAX_POS                       24                                                            /** PGPnMSK1PRM1 HMAX-bit position */
#define AG903_PGPn_MSK1PRM1_HMAX_MSK                       (0xffUL << AG903_PGPn_MSK1PRM1_HMAX_POS)                      /** PGPnMSK1PRM1 HMAX-bit mask */

#define AG903_PGPn_MSK2PRM0_X_POS                          0                                                             /** PGPnMSK2PRM0 X-bit position */
#define AG903_PGPn_MSK2PRM0_X_MSK                          (0x1UL << AG903_PGPn_MSK2PRM0_X_POS)                          /** PGPnMSK2PRM0 X-bit mask */
#define AG903_PGPn_MSK2PRM0_L_POS                          1                                                             /** PGPnMSK2PRM0 L-bit position */
#define AG903_PGPn_MSK2PRM0_L_MSK                          (0x1UL << AG903_PGPn_MSK2PRM0_L_POS)                          /** PGPnMSK2PRM0 L-bit mask */
#define AG903_PGPn_MSK2PRM0_H_POS                          2                                                             /** PGPnMSK2PRM0 H-bit position */
#define AG903_PGPn_MSK2PRM0_H_MSK                          (0x1UL << AG903_PGPn_MSK2PRM0_H_POS)                          /** PGPnMSK2PRM0 H-bit mask */

#define AG903_PGPn_MSK2PRM1_LMIN_POS                       0                                                             /** PGPnMSK2PRM1 LMIN-bit position */
#define AG903_PGPn_MSK2PRM1_LMIN_MSK                       (0xffUL << AG903_PGPn_MSK2PRM1_LMIN_POS)                      /** PGPnMSK2PRM1 LMIN-bit mask */
#define AG903_PGPn_MSK2PRM1_LMAX_POS                       8                                                             /** PGPnMSK2PRM1 LMAX-bit position */
#define AG903_PGPn_MSK2PRM1_LMAX_MSK                       (0xffUL << AG903_PGPn_MSK2PRM1_LMAX_POS)                      /** PGPnMSK2PRM1 LMAX-bit mask */
#define AG903_PGPn_MSK2PRM1_HMIN_POS                       16                                                            /** PGPnMSK2PRM1 HMIN-bit position */
#define AG903_PGPn_MSK2PRM1_HMIN_MSK                       (0xffUL << AG903_PGPn_MSK2PRM1_HMIN_POS)                      /** PGPnMSK2PRM1 HMIN-bit mask */
#define AG903_PGPn_MSK2PRM1_HMAX_POS                       24                                                            /** PGPnMSK2PRM1 HMAX-bit position */
#define AG903_PGPn_MSK2PRM1_HMAX_MSK                       (0xffUL << AG903_PGPn_MSK2PRM1_HMAX_POS)                      /** PGPnMSK2PRM1 HMAX-bit mask */

#define AG903_PGPn_THR8PRM0_MINTHR_POS                     0                                                             /** PGPnTHR8PRM0 MINTHR-bit position */
#define AG903_PGPn_THR8PRM0_MINTHR_MSK                     (0xffUL << AG903_PGPn_THR8PRM0_MINTHR_POS)                    /** PGPnTHR8PRM0 MINTHR-bit mask */
#define AG903_PGPn_THR8PRM0_MAXTHR_POS                     8                                                             /** PGPnTHR8PRM0 MAXTHR-bit position */
#define AG903_PGPn_THR8PRM0_MAXTHR_MSK                     (0xffUL << AG903_PGPn_THR8PRM0_MAXTHR_POS)                    /** PGPnTHR8PRM0 MAXTHR-bit mask */
#define AG903_PGPn_THR8PRM0_MAXVAL_POS                     16                                                            /** PGPnTHR8PRM0 MAXVAL-bit position */
#define AG903_PGPn_THR8PRM0_MAXVAL_MSK                     (0xffUL << AG903_PGPn_THR8PRM0_MAXVAL_POS)                    /** PGPnTHR8PRM0 MAXVAL-bit mask */
#define AG903_PGPn_THR8PRM0_TYPE_POS                       24                                                            /** PGPnTHR8PRM0 TYPE-bit position */
#define AG903_PGPn_THR8PRM0_TYPE_MSK                       (0xfUL << AG903_PGPn_THR8PRM0_TYPE_POS)                       /** PGPnTHR8PRM0 TYPE-bit mask */

#define AG903_PGPn_THR8PRM1_MINTHR_POS                     0                                                             /** PGPnTHR8PRM1 MINTHR-bit position */
#define AG903_PGPn_THR8PRM1_MINTHR_MSK                     (0xffUL << AG903_PGPn_THR8PRM1_MINTHR_POS)                    /** PGPnTHR8PRM1 MINTHR-bit mask */
#define AG903_PGPn_THR8PRM1_MAXTHR_POS                     8                                                             /** PGPnTHR8PRM1 MAXTHR-bit position */
#define AG903_PGPn_THR8PRM1_MAXTHR_MSK                     (0xffUL << AG903_PGPn_THR8PRM1_MAXTHR_POS)                    /** PGPnTHR8PRM1 MAXTHR-bit mask */
#define AG903_PGPn_THR8PRM1_MAXVAL_POS                     16                                                            /** PGPnTHR8PRM1 MAXVAL-bit position */
#define AG903_PGPn_THR8PRM1_MAXVAL_MSK                     (0xffUL << AG903_PGPn_THR8PRM1_MAXVAL_POS)                    /** PGPnTHR8PRM1 MAXVAL-bit mask */
#define AG903_PGPn_THR8PRM1_TYPE_POS                       24                                                            /** PGPnTHR8PRM1 TYPE-bit position */
#define AG903_PGPn_THR8PRM1_TYPE_MSK                       (0xfUL << AG903_PGPn_THR8PRM1_TYPE_POS)                       /** PGPnTHR8PRM1 TYPE-bit mask */

#define AG903_PGPn_THR8PRM2_MINTHR_POS                     0                                                             /** PGPnTHR8PRM2 MINTHR-bit position */
#define AG903_PGPn_THR8PRM2_MINTHR_MSK                     (0xffUL << AG903_PGPn_THR8PRM2_MINTHR_POS)                    /** PGPnTHR8PRM2 MINTHR-bit mask */
#define AG903_PGPn_THR8PRM2_MAXTHR_POS                     8                                                             /** PGPnTHR8PRM2 MAXTHR-bit position */
#define AG903_PGPn_THR8PRM2_MAXTHR_MSK                     (0xffUL << AG903_PGPn_THR8PRM2_MAXTHR_POS)                    /** PGPnTHR8PRM2 MAXTHR-bit mask */
#define AG903_PGPn_THR8PRM2_MAXVAL_POS                     16                                                            /** PGPnTHR8PRM2 MAXVAL-bit position */
#define AG903_PGPn_THR8PRM2_MAXVAL_MSK                     (0xffUL << AG903_PGPn_THR8PRM2_MAXVAL_POS)                    /** PGPnTHR8PRM2 MAXVAL-bit mask */
#define AG903_PGPn_THR8PRM2_TYPE_POS                       24                                                            /** PGPnTHR8PRM2 TYPE-bit position */
#define AG903_PGPn_THR8PRM2_TYPE_MSK                       (0xfUL << AG903_PGPn_THR8PRM2_TYPE_POS)                       /** PGPnTHR8PRM2 TYPE-bit mask */

#define AG903_PGPn_THR1PRM0_X_POS                          0                                                             /** PGPnTHR1PRM0 X-bit position */
#define AG903_PGPn_THR1PRM0_X_MSK                          (0x1UL << AG903_PGPn_THR1PRM0_X_POS)                          /** PGPnTHR1PRM0 X-bit mask */
#define AG903_PGPn_THR1PRM0_L_POS                          1                                                             /** PGPnTHR1PRM0 L-bit position */
#define AG903_PGPn_THR1PRM0_L_MSK                          (0x1UL << AG903_PGPn_THR1PRM0_L_POS)                          /** PGPnTHR1PRM0 L-bit mask */
#define AG903_PGPn_THR1PRM0_H_POS                          2                                                             /** PGPnTHR1PRM0 H-bit position */
#define AG903_PGPn_THR1PRM0_H_MSK                          (0x1UL << AG903_PGPn_THR1PRM0_H_POS)                          /** PGPnTHR1PRM0 H-bit mask */

#define AG903_PGPn_THR1PRM1_LMIN_POS                       0                                                             /** PGPnTHR1PRM1 LMIN-bit position */
#define AG903_PGPn_THR1PRM1_LMIN_MSK                       (0xffUL << AG903_PGPn_THR1PRM1_LMIN_POS)                      /** PGPnTHR1PRM1 LMIN-bit mask */
#define AG903_PGPn_THR1PRM1_LMAX_POS                       8                                                             /** PGPnTHR1PRM1 LMAX-bit position */
#define AG903_PGPn_THR1PRM1_LMAX_MSK                       (0xffUL << AG903_PGPn_THR1PRM1_LMAX_POS)                      /** PGPnTHR1PRM1 LMAX-bit mask */
#define AG903_PGPn_THR1PRM1_HMIN_POS                       16                                                            /** PGPnTHR1PRM1 HMIN-bit position */
#define AG903_PGPn_THR1PRM1_HMIN_MSK                       (0xffUL << AG903_PGPn_THR1PRM1_HMIN_POS)                      /** PGPnTHR1PRM1 HMIN-bit mask */
#define AG903_PGPn_THR1PRM1_HMAX_POS                       24                                                            /** PGPnTHR1PRM1 HMAX-bit position */
#define AG903_PGPn_THR1PRM1_HMAX_MSK                       (0xffUL << AG903_PGPn_THR1PRM1_HMAX_POS)                      /** PGPnTHR1PRM1 HMAX-bit mask */

#define AG903_PGPn_SPF1PRM0_HMM_POS                        0                                                             /** PGPnSPF1PRM0 HMM-bit position */
#define AG903_PGPn_SPF1PRM0_HMM_MSK                        (0x7UL << AG903_PGPn_SPF1PRM0_HMM_POS)                        /** PGPnSPF1PRM0 HMM-bit mask */
#define AG903_PGPn_SPF1PRM0_H0M_POS                        4                                                             /** PGPnSPF1PRM0 H0M-bit position */
#define AG903_PGPn_SPF1PRM0_H0M_MSK                        (0x7UL << AG903_PGPn_SPF1PRM0_H0M_POS)                        /** PGPnSPF1PRM0 H0M-bit mask */
#define AG903_PGPn_SPF1PRM0_H1M_POS                        8                                                             /** PGPnSPF1PRM0 H1M-bit position */
#define AG903_PGPn_SPF1PRM0_H1M_MSK                        (0x7UL << AG903_PGPn_SPF1PRM0_H1M_POS)                        /** PGPnSPF1PRM0 H1M-bit mask */
#define AG903_PGPn_SPF1PRM0_HM0_POS                        12                                                            /** PGPnSPF1PRM0 HM0-bit position */
#define AG903_PGPn_SPF1PRM0_HM0_MSK                        (0x7UL << AG903_PGPn_SPF1PRM0_HM0_POS)                        /** PGPnSPF1PRM0 HM0-bit mask */
#define AG903_PGPn_SPF1PRM0_H00_POS                        16                                                            /** PGPnSPF1PRM0 H00-bit position */
#define AG903_PGPn_SPF1PRM0_H00_MSK                        (0x7UL << AG903_PGPn_SPF1PRM0_H00_POS)                        /** PGPnSPF1PRM0 H00-bit mask */
#define AG903_PGPn_SPF1PRM0_H10_POS                        20                                                            /** PGPnSPF1PRM0 H10-bit position */
#define AG903_PGPn_SPF1PRM0_H10_MSK                        (0x7UL << AG903_PGPn_SPF1PRM0_H10_POS)                        /** PGPnSPF1PRM0 H10-bit mask */

#define AG903_PGPn_SPF1PRM1_HM1_POS                        0                                                             /** PGPnSPF1PRM1 HM1-bit position */
#define AG903_PGPn_SPF1PRM1_HM1_MSK                        (0x7UL << AG903_PGPn_SPF1PRM1_HM1_POS)                        /** PGPnSPF1PRM1 HM1-bit mask */
#define AG903_PGPn_SPF1PRM1_H01_POS                        4                                                             /** PGPnSPF1PRM1 H01-bit position */
#define AG903_PGPn_SPF1PRM1_H01_MSK                        (0x7UL << AG903_PGPn_SPF1PRM1_H01_POS)                        /** PGPnSPF1PRM1 H01-bit mask */
#define AG903_PGPn_SPF1PRM1_H11_POS                        8                                                             /** PGPnSPF1PRM1 H11-bit position */
#define AG903_PGPn_SPF1PRM1_H11_MSK                        (0x7UL << AG903_PGPn_SPF1PRM1_H11_POS)                        /** PGPnSPF1PRM1 H11-bit mask */
#define AG903_PGPn_SPF1PRM1_THR_POS                        16                                                            /** PGPnSPF1PRM1 THR-bit position */
#define AG903_PGPn_SPF1PRM1_THR_MSK                        (0x3fUL << AG903_PGPn_SPF1PRM1_THR_POS)                       /** PGPnSPF1PRM1 THR-bit mask */

#define AG903_PGPn_THR1CNT_CNT_POS                         0                                                             /** PGPnTHR1CNT CNT-bit position */
#define AG903_PGPn_THR1CNT_CNT_MSK                         (0xffffffUL << AG903_PGPn_THR1CNT_CNT_POS)                    /** PGPnTHR1CNT CNT-bit mask */

#define AG903_PGPn_LBLCMD_CMD_POS                          0                                                             /** PGPnLBLCMD CMD-bit position */
#define AG903_PGPn_LBLCMD_CMD_MSK                          (0x7UL << AG903_PGPn_LBLCMD_CMD_POS)                          /** PGPnLBLCMD CMD-bit mask */

#define AG903_PGPn_LBLCTRL_MAXID_POS                       0                                                             /** PGPnLBLCTRL MAXID-bit position */
#define AG903_PGPn_LBLCTRL_MAXID_MSK                       (0xffUL << AG903_PGPn_LBLCTRL_MAXID_POS)                      /** PGPnLBLCTRL MAXID-bit mask */
#define AG903_PGPn_LBLCTRL_FLTHR_POS                       8                                                             /** PGPnLBLCTRL FLTHR-bit position */
#define AG903_PGPn_LBLCTRL_FLTHR_MSK                       (0xffUL << AG903_PGPn_LBLCTRL_FLTHR_POS)                      /** PGPnLBLCTRL FLTHR-bit mask */
#define AG903_PGPn_LBLCTRL_BMU_POS                         16                                                            /** PGPnLBLCTRL BMU-bit position */
#define AG903_PGPn_LBLCTRL_BMU_MSK                         (0x1UL << AG903_PGPn_LBLCTRL_BMU_POS)                         /** PGPnLBLCTRL BMU-bit mask */
#define AG903_PGPn_LBLCTRL_CNCT_POS                        17                                                            /** PGPnLBLCTRL CNCT-bit position */
#define AG903_PGPn_LBLCTRL_CNCT_MSK                        (0x1UL << AG903_PGPn_LBLCTRL_CNCT_POS)                        /** PGPnLBLCTRL CNCT-bit mask */
#define AG903_PGPn_LBLCTRL_INV_POS                         24                                                            /** PGPnLBLCTRL INV-bit position */
#define AG903_PGPn_LBLCTRL_INV_MSK                         (0xfUL << AG903_PGPn_LBLCTRL_INV_POS)                         /** PGPnLBLCTRL INV-bit mask */
#define AG903_PGPn_LBLCTRL_VLD_POS                         28                                                            /** PGPnLBLCTRL VLD-bit position */
#define AG903_PGPn_LBLCTRL_VLD_MSK                         (0xfUL << AG903_PGPn_LBLCTRL_VLD_POS)                         /** PGPnLBLCTRL VLD-bit mask */

#define AG903_PGPn_LBLSIZE_HSIZE_POS                       0                                                             /** PGPnLBLSIZE HSIZE-bit position */
#define AG903_PGPn_LBLSIZE_HSIZE_MSK                       (0x3ffUL << AG903_PGPn_LBLSIZE_HSIZE_POS)                     /** PGPnLBLSIZE HSIZE-bit mask */
#define AG903_PGPn_LBLSIZE_VSIZE_POS                       16                                                            /** PGPnLBLSIZE VSIZE-bit position */
#define AG903_PGPn_LBLSIZE_VSIZE_MSK                       (0x3ffUL << AG903_PGPn_LBLSIZE_VSIZE_POS)                     /** PGPnLBLSIZE VSIZE-bit mask */

#define AG903_PGPn_LBLPOS_HPOS_POS                         0                                                             /** PGPnLBLPOS HPOS-bit position */
#define AG903_PGPn_LBLPOS_HPOS_MSK                         (0xfffUL << AG903_PGPn_LBLPOS_HPOS_POS)                       /** PGPnLBLPOS HPOS-bit mask */
#define AG903_PGPn_LBLPOS_VPOS_POS                         16                                                            /** PGPnLBLPOS VPOS-bit position */
#define AG903_PGPn_LBLPOS_VPOS_MSK                         (0xfffUL << AG903_PGPn_LBLPOS_VPOS_POS)                       /** PGPnLBLPOS VPOS-bit mask */

#define AG903_PGPn_LBLDST_ADR_POS                          3                                                             /** PGPnLBLDST ADR-bit position */
#define AG903_PGPn_LBLDST_ADR_MSK                          (0x1fffffffUL << AG903_PGPn_LBLDST_ADR_POS)                   /** PGPnLBLDST ADR-bit mask */

#define AG903_PGPn_LBLSTAT_CMD_POS                         0                                                             /** PGPnLBLSTAT CMD-bit position */
#define AG903_PGPn_LBLSTAT_CMD_MSK                         (0x7UL << AG903_PGPn_LBLSTAT_CMD_POS)                         /** PGPnLBLSTAT CMD-bit mask */
#define AG903_PGPn_LBLSTAT_QUEUE_POS                       4                                                             /** PGPnLBLSTAT QUEUE-bit position */
#define AG903_PGPn_LBLSTAT_QUEUE_MSK                       (0x3UL << AG903_PGPn_LBLSTAT_QUEUE_POS)                       /** PGPnLBLSTAT QUEUE-bit mask */
#define AG903_PGPn_LBLSTAT_ACT_POS                         6                                                             /** PGPnLBLSTAT ACT-bit position */
#define AG903_PGPn_LBLSTAT_ACT_MSK                         (0x1UL << AG903_PGPn_LBLSTAT_ACT_POS)                         /** PGPnLBLSTAT ACT-bit mask */
#define AG903_PGPn_LBLSTAT_VRMACC_POS                      7                                                             /** PGPnLBLSTAT VRMACC-bit position */
#define AG903_PGPn_LBLSTAT_VRMACC_MSK                      (0x1UL << AG903_PGPn_LBLSTAT_VRMACC_POS)                      /** PGPnLBLSTAT VRMACC-bit mask */
#define AG903_PGPn_LBLSTAT_ID_POS                          8                                                             /** PGPnLBLSTAT ID-bit position */
#define AG903_PGPn_LBLSTAT_ID_MSK                          (0xffUL << AG903_PGPn_LBLSTAT_ID_POS)                         /** PGPnLBLSTAT ID-bit mask */

#define AG903_PGPn_IFCCMD_CMD_POS                          0                                                             /** PGPnIFCCMD CMD-bit position */
#define AG903_PGPn_IFCCMD_CMD_MSK                          (0x7UL << AG903_PGPn_IFCCMD_CMD_POS)                          /** PGPnIFCCMD CMD-bit mask */

#define AG903_PGPn_IFCCTRL_SFT0_POS                        0                                                             /** PGPnIFCCTRL SFT0-bit position */
#define AG903_PGPn_IFCCTRL_SFT0_MSK                        (0x7UL << AG903_PGPn_IFCCTRL_SFT0_POS)                        /** PGPnIFCCTRL SFT0-bit mask */
#define AG903_PGPn_IFCCTRL_SFT1_POS                        4                                                             /** PGPnIFCCTRL SFT1-bit position */
#define AG903_PGPn_IFCCTRL_SFT1_MSK                        (0x7UL << AG903_PGPn_IFCCTRL_SFT1_POS)                        /** PGPnIFCCTRL SFT1-bit mask */
#define AG903_PGPn_IFCCTRL_OP_POS                          8                                                             /** PGPnIFCCTRL OP-bit position */
#define AG903_PGPn_IFCCTRL_OP_MSK                          (0x7UL << AG903_PGPn_IFCCTRL_OP_POS)                          /** PGPnIFCCTRL OP-bit mask */
#define AG903_PGPn_IFCCTRL_SRC_POS                         16                                                            /** PGPnIFCCTRL SRC-bit position */
#define AG903_PGPn_IFCCTRL_SRC_MSK                         (0x3UL << AG903_PGPn_IFCCTRL_SRC_POS)                         /** PGPnIFCCTRL SRC-bit mask */
#define AG903_PGPn_IFCCTRL_LIMIT_POS                       18                                                            /** PGPnIFCCTRL LIMIT-bit position */
#define AG903_PGPn_IFCCTRL_LIMIT_MSK                       (0x3UL << AG903_PGPn_IFCCTRL_LIMIT_POS)                       /** PGPnIFCCTRL LIMIT-bit mask */
#define AG903_PGPn_IFCCTRL_SCAN_POS                        20                                                            /** PGPnIFCCTRL SCAN-bit position */
#define AG903_PGPn_IFCCTRL_SCAN_MSK                        (0x1UL << AG903_PGPn_IFCCTRL_SCAN_POS)                        /** PGPnIFCCTRL SCAN-bit mask */

#define AG903_PGPn_IFCPRM_GAIN0_POS                        0                                                             /** PGPnIFCPRM GAIN0-bit position */
#define AG903_PGPn_IFCPRM_GAIN0_MSK                        (0xffUL << AG903_PGPn_IFCPRM_GAIN0_POS)                       /** PGPnIFCPRM GAIN0-bit mask */
#define AG903_PGPn_IFCPRM_GAIN1_POS                        8                                                             /** PGPnIFCPRM GAIN1-bit position */
#define AG903_PGPn_IFCPRM_GAIN1_MSK                        (0xffUL << AG903_PGPn_IFCPRM_GAIN1_POS)                       /** PGPnIFCPRM GAIN1-bit mask */

#define AG903_PGPVIn_CMD_CMD_POS                           0                                                             /** PGPVInCMD CMD-bit position */
#define AG903_PGPVIn_CMD_CMD_MSK                           (0xfUL << AG903_PGPVIn_CMD_CMD_POS)                           /** PGPVInCMD CMD-bit mask */

#define AG903_PGPVIn_STATE_ST_POS                          0                                                             /** PGPVInSTATE ST-bit position */
#define AG903_PGPVIn_STATE_ST_MSK                          (0xfUL << AG903_PGPVIn_STATE_ST_POS)                          /** PGPVInSTATE ST-bit mask */
#define AG903_PGPVIn_STATE_QUEUE_POS                       8                                                             /** PGPVInSTATE QUEUE-bit position */
#define AG903_PGPVIn_STATE_QUEUE_MSK                       (0x3UL << AG903_PGPVIn_STATE_QUEUE_POS)                       /** PGPVInSTATE QUEUE-bit mask */
#define AG903_PGPVIn_STATE_VRMACC_POS                      12                                                            /** PGPVInSTATE VRMACC-bit position */
#define AG903_PGPVIn_STATE_VRMACC_MSK                      (0x1UL << AG903_PGPVIn_STATE_VRMACC_POS)                      /** PGPVInSTATE VRMACC-bit mask */

#define AG903_PGPVIn_CTRL0_FMT_POS                         0                                                             /** PGPVInCTRL0 FMT-bit position */
#define AG903_PGPVIn_CTRL0_FMT_MSK                         (0xfUL << AG903_PGPVIn_CTRL0_FMT_POS)                         /** PGPVInCTRL0 FMT-bit mask */
#define AG903_PGPVIn_CTRL0_MD_POS                          4                                                             /** PGPVInCTRL0 MD-bit position */
#define AG903_PGPVIn_CTRL0_MD_MSK                          (0x7UL << AG903_PGPVIn_CTRL0_MD_POS)                          /** PGPVInCTRL0 MD-bit mask */
#define AG903_PGPVIn_CTRL0_SWAP1_POS                       8                                                             /** PGPVInCTRL0 SWAP1-bit position */
#define AG903_PGPVIn_CTRL0_SWAP1_MSK                       (0x1UL << AG903_PGPVIn_CTRL0_SWAP1_POS)                       /** PGPVInCTRL0 SWAP1-bit mask */
#define AG903_PGPVIn_CTRL0_SWAP4_POS                       9                                                             /** PGPVInCTRL0 SWAP4-bit position */
#define AG903_PGPVIn_CTRL0_SWAP4_MSK                       (0x1UL << AG903_PGPVIn_CTRL0_SWAP4_POS)                       /** PGPVInCTRL0 SWAP4-bit mask */
#define AG903_PGPVIn_CTRL0_SWAPH_POS                       10                                                            /** PGPVInCTRL0 SWAPH-bit position */
#define AG903_PGPVIn_CTRL0_SWAPH_MSK                       (0x1UL << AG903_PGPVIn_CTRL0_SWAPH_POS)                       /** PGPVInCTRL0 SWAPH-bit mask */
#define AG903_PGPVIn_CTRL0_SWAPW_POS                       11                                                            /** PGPVInCTRL0 SWAPW-bit position */
#define AG903_PGPVIn_CTRL0_SWAPW_MSK                       (0x1UL << AG903_PGPVIn_CTRL0_SWAPW_POS)                       /** PGPVInCTRL0 SWAPW-bit mask */
#define AG903_PGPVIn_CTRL0_DIM_POS                         12                                                            /** PGPVInCTRL0 DIM-bit position */
#define AG903_PGPVIn_CTRL0_DIM_MSK                         (0x1UL << AG903_PGPVIn_CTRL0_DIM_POS)                         /** PGPVInCTRL0 DIM-bit mask */
#define AG903_PGPVIn_CTRL0_SCAN_POS                        13                                                            /** PGPVInCTRL0 SCAN-bit position */
#define AG903_PGPVIn_CTRL0_SCAN_MSK                        (0x1UL << AG903_PGPVIn_CTRL0_SCAN_POS)                        /** PGPVInCTRL0 SCAN-bit mask */
#define AG903_PGPVIn_CTRL0_BMU_POS                         14                                                            /** PGPVInCTRL0 BMU-bit position */
#define AG903_PGPVIn_CTRL0_BMU_MSK                         (0x3UL << AG903_PGPVIn_CTRL0_BMU_POS)                         /** PGPVInCTRL0 BMU-bit mask */
#define AG903_PGPVIn_CTRL0_FAI_POS                         17                                                            /** PGPVInCTRL0 FAI-bit position */
#define AG903_PGPVIn_CTRL0_FAI_MSK                         (0x1UL << AG903_PGPVIn_CTRL0_FAI_POS)                         /** PGPVInCTRL0 FAI-bit mask */

#define AG903_PGPVIn_CTRL1_INV_POS                         0                                                             /** PGPVInCTRL1 INV-bit position */
#define AG903_PGPVIn_CTRL1_INV_MSK                         (0xfUL << AG903_PGPVIn_CTRL1_INV_POS)                         /** PGPVInCTRL1 INV-bit mask */
#define AG903_PGPVIn_CTRL1_VLD_POS                         4                                                             /** PGPVInCTRL1 VLD-bit position */
#define AG903_PGPVIn_CTRL1_VLD_MSK                         (0xfUL << AG903_PGPVIn_CTRL1_VLD_POS)                         /** PGPVInCTRL1 VLD-bit mask */
#define AG903_PGPVIn_CTRL1_DIV_POS                         8                                                             /** PGPVInCTRL1 DIV-bit position */
#define AG903_PGPVIn_CTRL1_DIV_MSK                         (0xffUL << AG903_PGPVIn_CTRL1_DIV_POS)                        /** PGPVInCTRL1 DIV-bit mask */

#define AG903_PGPVIn_BASE_ADR_POS                          3                                                             /** PGPVInBASE ADR-bit position */
#define AG903_PGPVIn_BASE_ADR_MSK                          (0x1fffffffUL << AG903_PGPVIn_BASE_ADR_POS)                   /** PGPVInBASE ADR-bit mask */

#define AG903_PGPVIn_HSIZE_HSIZE_POS                       0                                                             /** PGPVInHSIZE HSIZE-bit position */
#define AG903_PGPVIn_HSIZE_HSIZE_MSK                       (0x3fffUL << AG903_PGPVIn_HSIZE_HSIZE_POS)                    /** PGPVInHSIZE HSIZE-bit mask */

#define AG903_PGPVIn_HPRM0_HPW_POS                         0                                                             /** PGPVInHPRM0 HPW-bit position */
#define AG903_PGPVIn_HPRM0_HPW_MSK                         (0xfffUL << AG903_PGPVIn_HPRM0_HPW_POS)                       /** PGPVInHPRM0 HPW-bit mask */

#define AG903_PGPVIn_HPRM1_HBP_POS                         0                                                             /** PGPVInHPRM1 HBP-bit position */
#define AG903_PGPVIn_HPRM1_HBP_MSK                         (0xfffUL << AG903_PGPVIn_HPRM1_HBP_POS)                       /** PGPVInHPRM1 HBP-bit mask */
#define AG903_PGPVIn_HPRM1_HFP_POS                         16                                                            /** PGPVInHPRM1 HFP-bit position */
#define AG903_PGPVIn_HPRM1_HFP_MSK                         (0xfffUL << AG903_PGPVIn_HPRM1_HFP_POS)                       /** PGPVInHPRM1 HFP-bit mask */

#define AG903_PGPVIn_VPRM0_VPW_POS                         0                                                             /** PGPVInVPRM0 VPW-bit position */
#define AG903_PGPVIn_VPRM0_VPW_MSK                         (0xfffUL << AG903_PGPVIn_VPRM0_VPW_POS)                       /** PGPVInVPRM0 VPW-bit mask */
#define AG903_PGPVIn_VPRM0_OFP_POS                         16                                                            /** PGPVInVPRM0 OFP-bit position */
#define AG903_PGPVIn_VPRM0_OFP_MSK                         (0x1UL << AG903_PGPVIn_VPRM0_OFP_POS)                         /** PGPVInVPRM0 OFP-bit mask */
#define AG903_PGPVIn_VPRM0_OBP_POS                         17                                                            /** PGPVInVPRM0 OBP-bit position */
#define AG903_PGPVIn_VPRM0_OBP_MSK                         (0x1UL << AG903_PGPVIn_VPRM0_OBP_POS)                         /** PGPVInVPRM0 OBP-bit mask */
#define AG903_PGPVIn_VPRM0_EFP_POS                         18                                                            /** PGPVInVPRM0 EFP-bit position */
#define AG903_PGPVIn_VPRM0_EFP_MSK                         (0x1UL << AG903_PGPVIn_VPRM0_EFP_POS)                         /** PGPVInVPRM0 EFP-bit mask */
#define AG903_PGPVIn_VPRM0_EBP_POS                         19                                                            /** PGPVInVPRM0 EBP-bit position */
#define AG903_PGPVIn_VPRM0_EBP_MSK                         (0x1UL << AG903_PGPVIn_VPRM0_EBP_POS)                         /** PGPVInVPRM0 EBP-bit mask */

#define AG903_PGPVIn_VPRM1_VBP_POS                         0                                                             /** PGPVInVPRM1 VBP-bit position */
#define AG903_PGPVIn_VPRM1_VBP_MSK                         (0xfffUL << AG903_PGPVIn_VPRM1_VBP_POS)                       /** PGPVInVPRM1 VBP-bit mask */
#define AG903_PGPVIn_VPRM1_VFP_POS                         16                                                            /** PGPVInVPRM1 VFP-bit position */
#define AG903_PGPVIn_VPRM1_VFP_MSK                         (0xfffUL << AG903_PGPVIn_VPRM1_VFP_POS)                       /** PGPVInVPRM1 VFP-bit mask */

#define AG903_PGPVIn_SIZE_HSIZE_POS                        0                                                             /** PGPVInSIZE HSIZE-bit position */
#define AG903_PGPVIn_SIZE_HSIZE_MSK                        (0xfffUL << AG903_PGPVIn_SIZE_HSIZE_POS)                      /** PGPVInSIZE HSIZE-bit mask */
#define AG903_PGPVIn_SIZE_VSIZE_POS                        16                                                            /** PGPVInSIZE VSIZE-bit position */
#define AG903_PGPVIn_SIZE_VSIZE_MSK                        (0xfffUL << AG903_PGPVIn_SIZE_VSIZE_POS)                      /** PGPVInSIZE VSIZE-bit mask */
#define AG903_PGPVIn_SIZE_OVSIZE_POS                       28                                                            /** PGPVInSIZE OVSIZE-bit position */
#define AG903_PGPVIn_SIZE_OVSIZE_MSK                       (0x1UL << AG903_PGPVIn_SIZE_OVSIZE_POS)                       /** PGPVInSIZE OVSIZE-bit mask */

#define AG903_PGP_JPGOUTSEL_SEL_POS                        0                                                             /** PGPJPGOUTSEL SEL-bit position */
#define AG903_PGP_JPGOUTSEL_SEL_MSK                        (0x7UL << AG903_PGP_JPGOUTSEL_SEL_POS)                        /** PGPJPGOUTSEL SEL-bit mask */
#define AG903_PGP_JPGOUTSEL_EN_POS                         3                                                             /** PGPJPGOUTSEL EN-bit position */
#define AG903_PGP_JPGOUTSEL_EN_MSK                         (0x1UL << AG903_PGP_JPGOUTSEL_EN_POS)                         /** PGPJPGOUTSEL EN-bit mask */


#define AG903_PGP0DGC_LUTB_B0_POS                          0                                                             /** PGP0DGCLUTB B0-bit position */
#define AG903_PGP0DGC_LUTB_B0_MSK                          (0xffUL << AG903_PGP0DGC_LUTB_B0_POS)                         /** PGP0DGCLUTB B0-bit mask */
#define AG903_PGP0DGC_LUTB_B1_POS                          8                                                             /** PGP0DGCLUTB B1-bit position */
#define AG903_PGP0DGC_LUTB_B1_MSK                          (0xffUL << AG903_PGP0DGC_LUTB_B1_POS)                         /** PGP0DGCLUTB B1-bit mask */
#define AG903_PGP0DGC_LUTB_B2_POS                          16                                                            /** PGP0DGCLUTB B2-bit position */
#define AG903_PGP0DGC_LUTB_B2_MSK                          (0xffUL << AG903_PGP0DGC_LUTB_B2_POS)                         /** PGP0DGCLUTB B2-bit mask */
#define AG903_PGP0DGC_LUTB_B3_POS                          24                                                            /** PGP0DGCLUTB B3-bit position */
#define AG903_PGP0DGC_LUTB_B3_MSK                          (0xffUL << AG903_PGP0DGC_LUTB_B3_POS)                         /** PGP0DGCLUTB B3-bit mask */

#define AG903_PGP0DGC_LUTG_G0_POS                          0                                                             /** PGP0DGCLUTG G0-bit position */
#define AG903_PGP0DGC_LUTG_G0_MSK                          (0xffUL << AG903_PGP0DGC_LUTG_G0_POS)                         /** PGP0DGCLUTG G0-bit mask */
#define AG903_PGP0DGC_LUTG_G1_POS                          8                                                             /** PGP0DGCLUTG G1-bit position */
#define AG903_PGP0DGC_LUTG_G1_MSK                          (0xffUL << AG903_PGP0DGC_LUTG_G1_POS)                         /** PGP0DGCLUTG G1-bit mask */
#define AG903_PGP0DGC_LUTG_G2_POS                          16                                                            /** PGP0DGCLUTG G2-bit position */
#define AG903_PGP0DGC_LUTG_G2_MSK                          (0xffUL << AG903_PGP0DGC_LUTG_G2_POS)                         /** PGP0DGCLUTG G2-bit mask */
#define AG903_PGP0DGC_LUTG_G3_POS                          24                                                            /** PGP0DGCLUTG G3-bit position */
#define AG903_PGP0DGC_LUTG_G3_MSK                          (0xffUL << AG903_PGP0DGC_LUTG_G3_POS)                         /** PGP0DGCLUTG G3-bit mask */

#define AG903_PGP0DGC_LUTR_R0_POS                          0                                                             /** PGP0DGCLUTR R0-bit position */
#define AG903_PGP0DGC_LUTR_R0_MSK                          (0xffUL << AG903_PGP0DGC_LUTR_R0_POS)                         /** PGP0DGCLUTR R0-bit mask */
#define AG903_PGP0DGC_LUTR_R1_POS                          8                                                             /** PGP0DGCLUTR R1-bit position */
#define AG903_PGP0DGC_LUTR_R1_MSK                          (0xffUL << AG903_PGP0DGC_LUTR_R1_POS)                         /** PGP0DGCLUTR R1-bit mask */
#define AG903_PGP0DGC_LUTR_R2_POS                          16                                                            /** PGP0DGCLUTR R2-bit position */
#define AG903_PGP0DGC_LUTR_R2_MSK                          (0xffUL << AG903_PGP0DGC_LUTR_R2_POS)                         /** PGP0DGCLUTR R2-bit mask */
#define AG903_PGP0DGC_LUTR_R3_POS                          24                                                            /** PGP0DGCLUTR R3-bit position */
#define AG903_PGP0DGC_LUTR_R3_MSK                          (0xffUL << AG903_PGP0DGC_LUTR_R3_POS)                         /** PGP0DGCLUTR R3-bit mask */

#define AG903_PGP0DGCF_LUTB_B0_POS                         0                                                             /** PGP0DGCFLUTB B0-bit position */
#define AG903_PGP0DGCF_LUTB_B0_MSK                         (0xffUL << AG903_PGP0DGCF_LUTB_B0_POS)                        /** PGP0DGCFLUTB B0-bit mask */
#define AG903_PGP0DGCF_LUTB_B1_POS                         8                                                             /** PGP0DGCFLUTB B1-bit position */
#define AG903_PGP0DGCF_LUTB_B1_MSK                         (0xffUL << AG903_PGP0DGCF_LUTB_B1_POS)                        /** PGP0DGCFLUTB B1-bit mask */
#define AG903_PGP0DGCF_LUTB_B2_POS                         16                                                            /** PGP0DGCFLUTB B2-bit position */
#define AG903_PGP0DGCF_LUTB_B2_MSK                         (0xffUL << AG903_PGP0DGCF_LUTB_B2_POS)                        /** PGP0DGCFLUTB B2-bit mask */
#define AG903_PGP0DGCF_LUTB_B3_POS                         24                                                            /** PGP0DGCFLUTB B3-bit position */
#define AG903_PGP0DGCF_LUTB_B3_MSK                         (0xffUL << AG903_PGP0DGCF_LUTB_B3_POS)                        /** PGP0DGCFLUTB B3-bit mask */

#define AG903_PGP0DGCF_LUTG_G0_POS                         0                                                             /** PGP0DGCFLUTG G0-bit position */
#define AG903_PGP0DGCF_LUTG_G0_MSK                         (0xffUL << AG903_PGP0DGCF_LUTG_G0_POS)                        /** PGP0DGCFLUTG G0-bit mask */
#define AG903_PGP0DGCF_LUTG_G1_POS                         8                                                             /** PGP0DGCFLUTG G1-bit position */
#define AG903_PGP0DGCF_LUTG_G1_MSK                         (0xffUL << AG903_PGP0DGCF_LUTG_G1_POS)                        /** PGP0DGCFLUTG G1-bit mask */
#define AG903_PGP0DGCF_LUTG_G2_POS                         16                                                            /** PGP0DGCFLUTG G2-bit position */
#define AG903_PGP0DGCF_LUTG_G2_MSK                         (0xffUL << AG903_PGP0DGCF_LUTG_G2_POS)                        /** PGP0DGCFLUTG G2-bit mask */
#define AG903_PGP0DGCF_LUTG_G3_POS                         24                                                            /** PGP0DGCFLUTG G3-bit position */
#define AG903_PGP0DGCF_LUTG_G3_MSK                         (0xffUL << AG903_PGP0DGCF_LUTG_G3_POS)                        /** PGP0DGCFLUTG G3-bit mask */

#define AG903_PGP0DGCF_LUTR_R0_POS                         0                                                             /** PGP0DGCFLUTR R0-bit position */
#define AG903_PGP0DGCF_LUTR_R0_MSK                         (0xffUL << AG903_PGP0DGCF_LUTR_R0_POS)                        /** PGP0DGCFLUTR R0-bit mask */
#define AG903_PGP0DGCF_LUTR_R1_POS                         8                                                             /** PGP0DGCFLUTR R1-bit position */
#define AG903_PGP0DGCF_LUTR_R1_MSK                         (0xffUL << AG903_PGP0DGCF_LUTR_R1_POS)                        /** PGP0DGCFLUTR R1-bit mask */
#define AG903_PGP0DGCF_LUTR_R2_POS                         16                                                            /** PGP0DGCFLUTR R2-bit position */
#define AG903_PGP0DGCF_LUTR_R2_MSK                         (0xffUL << AG903_PGP0DGCF_LUTR_R2_POS)                        /** PGP0DGCFLUTR R2-bit mask */
#define AG903_PGP0DGCF_LUTR_R3_POS                         24                                                            /** PGP0DGCFLUTR R3-bit position */
#define AG903_PGP0DGCF_LUTR_R3_MSK                         (0xffUL << AG903_PGP0DGCF_LUTR_R3_POS)                        /** PGP0DGCFLUTR R3-bit mask */

#define AG903_PGP1DGC_LUTB_B0_POS                          0                                                             /** PGP1DGCLUTB B0-bit position */
#define AG903_PGP1DGC_LUTB_B0_MSK                          (0xffUL << AG903_PGP1DGC_LUTB_B0_POS)                         /** PGP1DGCLUTB B0-bit mask */
#define AG903_PGP1DGC_LUTB_B1_POS                          8                                                             /** PGP1DGCLUTB B1-bit position */
#define AG903_PGP1DGC_LUTB_B1_MSK                          (0xffUL << AG903_PGP1DGC_LUTB_B1_POS)                         /** PGP1DGCLUTB B1-bit mask */
#define AG903_PGP1DGC_LUTB_B2_POS                          16                                                            /** PGP1DGCLUTB B2-bit position */
#define AG903_PGP1DGC_LUTB_B2_MSK                          (0xffUL << AG903_PGP1DGC_LUTB_B2_POS)                         /** PGP1DGCLUTB B2-bit mask */
#define AG903_PGP1DGC_LUTB_B3_POS                          24                                                            /** PGP1DGCLUTB B3-bit position */
#define AG903_PGP1DGC_LUTB_B3_MSK                          (0xffUL << AG903_PGP1DGC_LUTB_B3_POS)                         /** PGP1DGCLUTB B3-bit mask */

#define AG903_PGP1DGC_LUTG_G0_POS                          0                                                             /** PGP1DGCLUTG G0-bit position */
#define AG903_PGP1DGC_LUTG_G0_MSK                          (0xffUL << AG903_PGP1DGC_LUTG_G0_POS)                         /** PGP1DGCLUTG G0-bit mask */
#define AG903_PGP1DGC_LUTG_G1_POS                          8                                                             /** PGP1DGCLUTG G1-bit position */
#define AG903_PGP1DGC_LUTG_G1_MSK                          (0xffUL << AG903_PGP1DGC_LUTG_G1_POS)                         /** PGP1DGCLUTG G1-bit mask */
#define AG903_PGP1DGC_LUTG_G2_POS                          16                                                            /** PGP1DGCLUTG G2-bit position */
#define AG903_PGP1DGC_LUTG_G2_MSK                          (0xffUL << AG903_PGP1DGC_LUTG_G2_POS)                         /** PGP1DGCLUTG G2-bit mask */
#define AG903_PGP1DGC_LUTG_G3_POS                          24                                                            /** PGP1DGCLUTG G3-bit position */
#define AG903_PGP1DGC_LUTG_G3_MSK                          (0xffUL << AG903_PGP1DGC_LUTG_G3_POS)                         /** PGP1DGCLUTG G3-bit mask */

#define AG903_PGP1DGC_LUTR_R0_POS                          0                                                             /** PGP1DGCLUTR R0-bit position */
#define AG903_PGP1DGC_LUTR_R0_MSK                          (0xffUL << AG903_PGP1DGC_LUTR_R0_POS)                         /** PGP1DGCLUTR R0-bit mask */
#define AG903_PGP1DGC_LUTR_R1_POS                          8                                                             /** PGP1DGCLUTR R1-bit position */
#define AG903_PGP1DGC_LUTR_R1_MSK                          (0xffUL << AG903_PGP1DGC_LUTR_R1_POS)                         /** PGP1DGCLUTR R1-bit mask */
#define AG903_PGP1DGC_LUTR_R2_POS                          16                                                            /** PGP1DGCLUTR R2-bit position */
#define AG903_PGP1DGC_LUTR_R2_MSK                          (0xffUL << AG903_PGP1DGC_LUTR_R2_POS)                         /** PGP1DGCLUTR R2-bit mask */
#define AG903_PGP1DGC_LUTR_R3_POS                          24                                                            /** PGP1DGCLUTR R3-bit position */
#define AG903_PGP1DGC_LUTR_R3_MSK                          (0xffUL << AG903_PGP1DGC_LUTR_R3_POS)                         /** PGP1DGCLUTR R3-bit mask */

#define AG903_PGP1DGCF_LUTB_B0_POS                         0                                                             /** PGP1DGCFLUTB B0-bit position */
#define AG903_PGP1DGCF_LUTB_B0_MSK                         (0xffUL << AG903_PGP1DGCF_LUTB_B0_POS)                        /** PGP1DGCFLUTB B0-bit mask */
#define AG903_PGP1DGCF_LUTB_B1_POS                         8                                                             /** PGP1DGCFLUTB B1-bit position */
#define AG903_PGP1DGCF_LUTB_B1_MSK                         (0xffUL << AG903_PGP1DGCF_LUTB_B1_POS)                        /** PGP1DGCFLUTB B1-bit mask */
#define AG903_PGP1DGCF_LUTB_B2_POS                         16                                                            /** PGP1DGCFLUTB B2-bit position */
#define AG903_PGP1DGCF_LUTB_B2_MSK                         (0xffUL << AG903_PGP1DGCF_LUTB_B2_POS)                        /** PGP1DGCFLUTB B2-bit mask */
#define AG903_PGP1DGCF_LUTB_B3_POS                         24                                                            /** PGP1DGCFLUTB B3-bit position */
#define AG903_PGP1DGCF_LUTB_B3_MSK                         (0xffUL << AG903_PGP1DGCF_LUTB_B3_POS)                        /** PGP1DGCFLUTB B3-bit mask */

#define AG903_PGP1DGCF_LUTG_G0_POS                         0                                                             /** PGP1DGCFLUTG G0-bit position */
#define AG903_PGP1DGCF_LUTG_G0_MSK                         (0xffUL << AG903_PGP1DGCF_LUTG_G0_POS)                        /** PGP1DGCFLUTG G0-bit mask */
#define AG903_PGP1DGCF_LUTG_G1_POS                         8                                                             /** PGP1DGCFLUTG G1-bit position */
#define AG903_PGP1DGCF_LUTG_G1_MSK                         (0xffUL << AG903_PGP1DGCF_LUTG_G1_POS)                        /** PGP1DGCFLUTG G1-bit mask */
#define AG903_PGP1DGCF_LUTG_G2_POS                         16                                                            /** PGP1DGCFLUTG G2-bit position */
#define AG903_PGP1DGCF_LUTG_G2_MSK                         (0xffUL << AG903_PGP1DGCF_LUTG_G2_POS)                        /** PGP1DGCFLUTG G2-bit mask */
#define AG903_PGP1DGCF_LUTG_G3_POS                         24                                                            /** PGP1DGCFLUTG G3-bit position */
#define AG903_PGP1DGCF_LUTG_G3_MSK                         (0xffUL << AG903_PGP1DGCF_LUTG_G3_POS)                        /** PGP1DGCFLUTG G3-bit mask */

#define AG903_PGP1DGCF_LUTR_R0_POS                         0                                                             /** PGP1DGCFLUTR R0-bit position */
#define AG903_PGP1DGCF_LUTR_R0_MSK                         (0xffUL << AG903_PGP1DGCF_LUTR_R0_POS)                        /** PGP1DGCFLUTR R0-bit mask */
#define AG903_PGP1DGCF_LUTR_R1_POS                         8                                                             /** PGP1DGCFLUTR R1-bit position */
#define AG903_PGP1DGCF_LUTR_R1_MSK                         (0xffUL << AG903_PGP1DGCF_LUTR_R1_POS)                        /** PGP1DGCFLUTR R1-bit mask */
#define AG903_PGP1DGCF_LUTR_R2_POS                         16                                                            /** PGP1DGCFLUTR R2-bit position */
#define AG903_PGP1DGCF_LUTR_R2_MSK                         (0xffUL << AG903_PGP1DGCF_LUTR_R2_POS)                        /** PGP1DGCFLUTR R2-bit mask */
#define AG903_PGP1DGCF_LUTR_R3_POS                         24                                                            /** PGP1DGCFLUTR R3-bit position */
#define AG903_PGP1DGCF_LUTR_R3_MSK                         (0xffUL << AG903_PGP1DGCF_LUTR_R3_POS)                        /** PGP1DGCFLUTR R3-bit mask */

#endif /* _AG903_PGP_REGMAP_H_ */

