/**
 * @brief           UART Primitive Header
 * @author          AXELL CORPORATION
 * @description     UART Primitive񋟃wb_B<p>UART PrimitivegpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2020_07_22  [SDK3.1] UARTDMA[h2gpsɕύX (#2900)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2020 AXELL CORPORATION, all rights reserved.
 */

#ifndef _UARTPRM_H_
#define _UARTPRM_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"
#include "register/AG903_uartreg.h"

#ifdef __cplusplus
extern "C" {
#endif

/** UART`l */
#define AG903_UART_CH_NUM		(4)

/** FIFOTCY */
#define AG903_UART_FIFO_SIZE	(16)

/** PSRݒMAXl */
#define AG903_UART_PSR_MAXNUM	(31)

/** peB */
enum _AG903_UartParityType {
	AG903_UART_PARITY_TYPE_NON = 0,	/** peBȂ */
	AG903_UART_PARITY_TYPE_ODD,		/** peB */
	AG903_UART_PARITY_TYPE_EVEN,	/** peB */
	AG903_UART_PARITY_TYPE_MAX,		/** peBʐ */
};

/** rbg */
enum _AG903_UartWordlenType {
	AG903_UART_WORDLEN5_STOP1 = 0,	/** LN^ 5 , Xgbvrbg 1 */
	AG903_UART_WORDLEN6_STOP1,		/** LN^ 6 , Xgbvrbg 1 */
	AG903_UART_WORDLEN7_STOP1,		/** LN^ 7 , Xgbvrbg 1 */
	AG903_UART_WORDLEN8_STOP1,		/** LN^ 8 , Xgbvrbg 1 */
	AG903_UART_WORDLEN5_STOP15,		/** LN^ 5 , Xgbvrbg 1.5 */
	AG903_UART_WORDLEN6_STOP2,		/** LN^ 6 , Xgbvrbg 2 */
	AG903_UART_WORDLEN7_STOP2,		/** LN^ 7 , Xgbvrbg 2 */
	AG903_UART_WORDLEN8_STOP2,		/** LN^ 8 , Xgbvrbg 2 */
	AG903_UART_WORDLEN_TYPE_MAX,	/** rbgʐ */
};

/** MFIFOgKx */
enum _AG903_UartRxFifoTrgl {
	AG903_UART_RXTRGL_1 = 0,	/** 1LN^ */
	AG903_UART_RXTRGL_4,		/** 4LN^ */
	AG903_UART_RXTRGL_8,		/** 8LN^ */
	AG903_UART_RXTRGL_14,		/** 14LN^ */
	AG903_UART_RXTRGL_MAX,		/** gKxʐ */
};

/** MFIFOgKx */
enum _AG903_UartTxFifoTrgl {
	AG903_UART_TXTRGL_1 = 0,	/** 1LN^ */
	AG903_UART_TXTRGL_3,		/** 3LN^ */
	AG903_UART_TXTRGL_9,		/** 9LN^ */
	AG903_UART_TXTRGL_13,		/** 13LN^ */
	AG903_UART_TXTRGL_MAX,		/** gKxʐ */
};

/** DMA[h */
enum _AG903_UartDmaMode {
	AG903_UART_DMA_MODE0 = 0,	/** DMA[h0 */
	AG903_UART_DMA_MODE1,		/** DMA[h1 */
	AG903_UART_DMA_MODE_MAX,	/** DMA[h */
};

/** MFIFOwrbg */
#define AG903_UART_RXFIFO_BIT		(1<<0)

/** MFIFOwrbg */
#define AG903_UART_TXFIFO_BIT		(1<<1)

/** MFIFOrbg */
#define AG903_UART_ALLFIFO_BIT		(AG903_UART_RXFIFO_BIT | AG903_UART_TXFIFO_BIT)

#define AG903_UART_FLOW_RTS_BIT		(1<<AG903_UARTn_IER_RTSEn_POS)	/** UARTnIER RTSEn-bit */
#define AG903_UART_FLOW_CTS_BIT		(1<<AG903_UARTn_IER_CTSEn_POS)	/** UARTnIER CTSEn-bit */
#define AG903_UART_FLOW_DTR_BIT		(1<<AG903_UARTn_IER_DTREn_POS)	/** UARTnIER DTREn-bit */
#define AG903_UART_FLOW_DSR_BIT		(1<<AG903_UARTn_IER_DSREn_POS)	/** UARTnIER DSREn-bit */

/** t[wrbg */
#define AG903_UART_FLOW_ALL_BIT		(AG903_UART_FLOW_RTS_BIT | AG903_UART_FLOW_CTS_BIT | AG903_UART_FLOW_DTR_BIT | AG903_UART_FLOW_DSR_BIT)

#define AG903_UART_DETECT_RTO_BIT	(1<<AG903_UARTn_STAT_RTO_POS)	/** UARTnSTAT RTO-bit */
#define AG903_UART_DETECT_CTO_BIT	(1<<AG903_UARTn_STAT_CTO_POS)	/** UARTnSTAT CTO-bit */

/** ^CAEgorbg */
#define AG903_UART_DETECT_ALL_BIT	(AG903_UART_DETECT_RTO_BIT | AG903_UART_DETECT_CTO_BIT)

#define AG903_UART_IER_DATARDY_BIT	(1<<AG903_UARTn_IER_Receiver_Data_Available_POS)	/** UARTnIER Receiver_Data_Available-bit */
#define AG903_UART_IER_THREMP_BIT	(1<<AG903_UARTn_IER_THR_Empty_POS)					/** UARTnIER THR_Empty-bit */
#define AG903_UART_IER_LINEST_BIT	(1<<AG903_UARTn_IER_Receiver_Line_Status_POS)		/** UARTnIER Receiver_Line_Status-bit */
#define AG903_UART_IER_MODEMST_BIT	(1<<AG903_UARTn_IER_MODEM_Status_POS)				/** UARTnIER MODEM_Status-bit */

#define AG903_UART_LSR_DATARDY_BIT	(1<<AG903_UARTn_LSR_Data_Ready_POS)			/** UARTnLSR Data_Ready-bit */
#define AG903_UART_LSR_OVERRUN_BIT	(1<<AG903_UARTn_LSR_Overrun_Error_POS)		/** UARTnLSR Overrun_Error-bit */
#define AG903_UART_LSR_PARITY_BIT	(1<<AG903_UARTn_LSR_Parity_Error_POS)		/** UARTnLSR Parity_Error-bit */
#define AG903_UART_LSR_FRAMING_BIT	(1<<AG903_UARTn_LSR_Framing_Error_POS)		/** UARTnLSR Framing_Error-bit */
#define AG903_UART_LSR_BREAK_BIT	(1<<AG903_UARTn_LSR_Break_Interrupt_POS)	/** UARTnLSR Break_Interrupt-bit */
#define AG903_UART_LSR_THREMP_BIT	(1<<AG903_UARTn_LSR_THR_Empty_POS)			/** UARTnLSR THR_Empty-bit */
#define AG903_UART_LSR_TRANENP_BIT	(1<<AG903_UARTn_LSR_Transmitter_Empty_POS)	/** UARTnLSR Transmitter_Empty-bit */
#define AG903_UART_LSR_FIFOERR_BIT	(1<<AG903_UARTn_LSR_FIFO_Data_Error_POS)	/** UARTnLSR FIFO_Data_Error-bit */

/** ݃^Cv MCXe[^X */
#define AG903_UART_INT_LINESTATUS	(0x06)

/** ݃^Cv Mf[^fB */
#define AG903_UART_INT_DATAREADY	(0x04)

/** ݃^Cv LN^M^CAEg */
#define AG903_UART_INT_RCVTIMEOUT	(0x0C)

/** ݃^Cv UARTnTHR WX^GveB */
#define AG903_UART_INT_THREMPTY		(0x02)

/** ݃^Cv fXe[^X */
#define AG903_UART_INT_MODEMSTATUS	(0x00)



void AG903_UARTPrmSetDivisor(uint8_t ch, uint8_t pscale, uint16_t div);
void AG903_UARTPrmSetWordLength(uint8_t ch, uint8_t parity_type, uint8_t length_type);
void AG903_UARTPrmDisableFifo(uint8_t ch);
void AG903_UARTPrmEnableFifo(uint8_t ch);
void AG903_UARTPrmSetFifoTrigger(uint8_t ch, uint8_t rx_trgl, uint8_t tx_trgl);
void AG903_UARTPrmResetFifo(uint8_t ch, uint8_t bit);
void AG903_UARTPrmDisableFlowControl(uint8_t ch, uint8_t bit);
void AG903_UARTPrmEnableFlowControl(uint8_t ch, uint8_t bit);
void AG903_UARTPrmSetDmaMode(uint8_t ch, uint8_t mode);
void AG903_UARTPrmSetBreak(uint8_t ch, _Bool enable);
void AG903_UARTPrmDisableInt(uint8_t ch, uint32_t bit);
void AG903_UARTPrmEnableInt(uint8_t ch, uint32_t bit);
void AG903_UARTPrmSendData(uint8_t ch, uint8_t* buf, uint32_t sndsz);
void AG903_UARTPrmGetReceiveData(uint8_t ch, uint8_t* buf);
void AG903_UARTPrmGetIntType(uint8_t ch, uint8_t* type);
void AG903_UARTPrmGetLineStatus(uint8_t ch, uint8_t* status);
void AG903_UARTPrmGetRs485Status(uint8_t ch, uint32_t* status);

void AG903_UARTPrmDisableRS485(uint8_t ch);
void AG903_UARTPrmEnableRS485(uint8_t ch);
void AG903_UARTPrmDisableTimeoutDetect(uint8_t ch);
void AG903_UARTPrmEnableTimeoutDetect(uint8_t ch);
void AG903_UARTPrmDisableTimeoutIntMask(uint8_t ch, uint32_t bit);
void AG903_UARTPrmEnableTimeoutIntMask(uint8_t ch, uint32_t bit);
void AG903_UARTPrmSetAutoMode(uint8_t ch, _Bool hold, _Bool setup);
void AG903_UARTPrmSetSetuptime(uint8_t ch, uint32_t setup_time);
void AG903_UARTPrmSetHoldtime(uint8_t ch, uint32_t hold_time);
void AG903_UARTPrmSetReceivetime(uint8_t ch, uint32_t rcv_time);
void AG903_UARTPrmSetCharainterval(uint8_t ch, uint32_t chara_interval);
void AG903_UARTPrmSetTimeout(uint8_t ch, uint32_t timeout);
void AG903_UARTPrmClerTimeoutStatus(uint8_t ch, uint32_t bit);

#ifdef __cplusplus
}
#endif
#endif /* _UARTPRM_H_ */
