/*
 * @history		2019_12_27  [SDK3.0] ^XNTA_FPUtŋNĂȂsC (uC3) (#2698)
 * @history		2019_12_27  [SDK3.0] BMUobt@̃TCYƃAC4096̔{ɂȂ悤C (#2188)
 * @history     2020_07_22  [SDK3.1] GVDL郁̈w肷APIǉ (#2965)
*/
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2020 AXELL CORPORATION, all rights reserved.
 */

/* uC3 */
#include "kernel.h"
#include "ffsys.h"

/* Standards */
#include <stdint.h>

/* Cu */
#include "bmu/bmumgr.h"
#include "dsp/dspmgr.h"
#include "int/intmgr.h"

/* MP4 */
#include "mps/mps_api.h"

/* AvŗL` */
#include "sample_common.h"
#include "mps_multi.h"

/* ^XN */

/* 񓯊^XN
 * ȊÕ^XNŗ]ԂɃR[
 * fR[_̐s߁AR[pxƃfR[h\ɉe܂ */
extern void async_tsk(VP_INT);
static const T_CTSK ctsk_async = {
	TA_HLNG | TA_ACT | TA_FPU, (VP_INT)0, (FP)async_tsk, 9, 0x800, 0, "Async"
};


/* EBhE^XN
 * t[obt@̊Ǘƃt[\Ԃ̐ */
extern void window_tsk(VP_INT);
static const T_CTSK ctsk_window = {
	TA_HLNG | TA_ACT | TA_FPU, (VP_INT)0, (FP)window_tsk, 3, 0x400, 0, "Window"
};

/* ֐ */
static void VSyncHandler(void);
static void BufferReset(int window);
static void WindowUpdate();
static void UpdateWindowAddr(int win_id, uintptr_t addr);
static void AppendBufferInfo(mpsContext *ctx, gvdOutBufInfo buf, gvdTimeStamp ts);

static int32_t cbMPSDecodeDone(void *param_gvd, void *param_user, gvdError error);
static int32_t cbMPSFatalerror(void *param_gvd, void *param_user, gvdError error);

/* O[oϐ */
extern gvdFatalErrorInfo gFatal;	/* vIG[ێp */
extern int8_t	gFlagMPSDone;	/* ItO */
extern ER_ID	gSemID_BufSync;	/* t[obt@Ǘp */

static ER_ID	gWindowTaskID;	/* EBhE^XNID */
static ER_ID	gAsyncTaskID;	/* 񓯊^XNID */
static ER_ID	gVSyncHdrID;	/* 荞݃nhID */
static uint8_t	gCallCnt;		/* t[XVp */
static void		*gWindowAttributeAddr; /* EBhEAgr[gAhXێp */
static mpsOutBufInfo gOutbufinfo[MPS_MAX_STREAM][MPS_OUTBUF_COUNT]; /* o̓obt@ */
static volatile uint32_t gCurrentFrame[MPS_MAX_STREAM]; /* ݕ\̃t[ID */

/* \nh */
static AG903_DSPMgrHandle *dsp_handle[2];

/* (obt@Ǘ)obt@\ */
typedef struct _DecodedBufferInfo{
	mpsContext *ctx;
	gvdOutBufInfo buf;
	gvdTimeStamp ts;
}DecodedBufferInfo;

static DecodedBufferInfo gBufList[MPS_MAX_STREAM][MPS_OUTBUF_COUNT];	/* ݍς݃obt@񃊃Xg */
static uint32_t gBufListNextAdd[MPS_MAX_STREAM];	/* ݍςݏo̓obt@Ǘp */
static uint32_t gBufListCount[MPS_MAX_STREAM];		/* ݍς݃obt@̌ */
static uint32_t gBufListCurrent[MPS_MAX_STREAM];	/* ݎgp̃obt@ԍ */
static uint32_t gBufListNext[MPS_MAX_STREAM];		/* gpobt@ԍ */
static uint32_t gBufListPrev[MPS_MAX_STREAM];		/* gpobt@ԍ */


static int movie_init(void)
{
	int32_t idx;
	int32_t err;

	mpsSetting mpssetting;
	mpsConfig mpsconfig;
	mpsContext *mpsctx;

	/* MPS̏ */
	mpssetting.max_stream = MPS_MAX_STREAM;
	mpssetting.stream_buffer_size = MPS_INBUF_SIZE;
	mpssetting.stream_buffer_num = MPS_INBUF_COUNT;
	mpssetting.func_decode_done_handler =
		(int32_t (*)(void *, void *, gvdError))cbMPSDecodeDone;
	mpssetting.func_fatalerror_handler =
		(int32_t (*)(void *, void *, gvdError))cbMPSFatalerror;
	err = MPS_Initialize(mpssetting);
	if(err)
	{
		MPS_ErrPrintf("ERROR: MPS_Initialize() : %d\r\n", err);
		return err;
	}

	ERRCHK(GVD_ERR_SUCCESS, GVD_SetFatalErrorAddress((void *)0xFE007000));
	ERRCHK(GVD_ERR_SUCCESS, GVD_SetOccupyMemoryAddress((void *)0x83FF0000));

	/* GVDp[N̊m */
	mpsconfig.memory_work_size = MPS_GetRequiredWorkMemorySize();
	MPS_Printf("[Memory] GVD requested %u [Byte]\r\n", mpsconfig.memory_work_size);

	/* GVDp[N32KBȏ̃ACK{ */
	mpsconfig.memory_work_top = MPS_Memalign(mpsconfig.memory_work_size, 32*1024);
	if(mpsconfig.memory_work_top == 0)
	{
		MPS_ErrPrintf("ERROR: [GVD WorkBuffer] allocate faild.\r\n");
		return -AG903_ENOMEM;
	}
	/* o̓obt@ */
	mpsconfig.num_out_buffer = MPS_OUTBUF_COUNT;

	/* GVDpq[v2KBȏ̃ACK{ */
	mpsconfig.memory_heap_top = MPS_Memalign(MPS_HEAP_SIZE, 2048);
	if(mpsconfig.memory_heap_top == NULL)
	{
		MPS_ErrPrintf("ERROR: Heap memory alloc failed.\r\n");
		return -AG903_ENOMEM;
	}
	mpsconfig.memory_heap_size = MPS_HEAP_SIZE;

	/* MP4Reỉ
	 * ȍ~Rei񂪎g */
	for(idx=0; idx<MPS_MAX_STREAM; idx++)
	{
		err = MPS_Parse(idx, STREAM_NAME[idx]);
		if (err != AG903_ENONE)
		{
			MPS_ErrPrintf("ERROR: MP4 Parse failed\r\n");
			return err;
		}

		mpsctx = MPS_getContext(idx);
		MPS_GetPositionBuffer(idx, &mpsctx->info.position_buf, &mpsctx->info.position_count);
	}

	/* o̓obt@̊m */
	{
		uint32_t stream_stride[MPS_MAX_STREAM];
		for(idx=0; idx<MPS_MAX_STREAM; idx++)
		{
			mpsctx = MPS_getContext(idx);
			if(mpsctx->info.width == 0 && mpsctx->info.height == 0)
			{
				mpsctx->info.width = STREAM_WIDTH[idx];
				mpsctx->info.height = STREAM_HEIGHT[idx];
				mpsctx->info.frame_length = 1;
				mpsctx->info.time_scale = 30;
			}

			stream_stride[idx] = MPS_ALIGNn(64, mpsctx->info.width)
			                   * MPS_ALIGNn(32, mpsctx->info.height)
			                   * 2;
		}
		/* o̓obt@mہiMPS_OUTBUF_COUNT[/Xg[]j */
		for(idx=0; idx<MPS_MAX_STREAM; idx++)
		{
			int32_t cnt;
			mpsctx = MPS_getContext(idx);
			for(cnt=0; cnt<MPS_OUTBUF_COUNT; cnt++)
			{
				/*  */
				gOutbufinfo[idx][cnt].buffer = MPS_Memalign(stream_stride[idx], 1024);
				gOutbufinfo[idx][cnt].size_buffer = stream_stride[idx];
				gOutbufinfo[idx][cnt].height = mpsctx->info.height;
				gOutbufinfo[idx][cnt].width = mpsctx->info.width;
				if(gOutbufinfo[idx][cnt].buffer == NULL)
				{
					MPS_ErrPrintf("ERROR: [Outputbuf] allocate faild.\r\n");
					return -AG903_ENOMEM;
				}
			}
		}
		mpsconfig.output_select = GVD_OUTMOD_VRAM;

		/* \t[obt@̏ */
		for(idx=0; idx<MPS_MAX_STREAM; idx++)
		{
			uint32_t cnt;
			uint32_t *p = (uint32_t *)gOutbufinfo[idx][MPS_OUTBUF_COUNT-1].buffer;
			for(cnt=0; cnt<stream_stride[idx]>>2; cnt++)
			{
				*(p + cnt) = 0x00000000;
			}

			/* \obt@\҂L[ɒǉ */
			{
				gvdTimeStamp ts = {0};
				BufferReset(idx);
				AppendBufferInfo(mpsctx, gOutbufinfo[idx][MPS_OUTBUF_COUNT-1], ts);
			}
		}
	}

	/* GVD̏ */
	err = MPS_Start(mpsconfig);
	if(err)
	{
		MPS_ErrPrintf("ERROR: MPS_Start() : %d\r\n", err);
		return err;
	}

	/* o̓obt@ݒ */
	for(idx=0; idx<MPS_MAX_STREAM; idx++)
	{
		mpsctx = MPS_getContext(idx);
		ERRCHK(GVD_ERR_SUCCESS, GVD_SetMaxNumInputBuffers(mpsctx->gvdctx, MPS_INBUF_COUNT));
		ERRCHK(GVD_ERR_SUCCESS, GVD_SetMaxNumOutputBuffers(mpsctx->gvdctx, MPS_OUTBUF_COUNT));
	}

	return 0;
}

static int movie_play(void)
{
	int idx, cnt;
	int32_t err;
	gvdInitializeParam *gvdparam = MPS_getGVDInitParam();
	mpsContext *ctx[MPS_MAX_STREAM] = {NULL};

	gFlagMPSDone = false;

	for(idx=0; idx<MPS_MAX_STREAM; idx++)
		ctx[idx] = MPS_getContext(idx);

	/* 񓯊Jn */
	gAsyncTaskID = acre_tsk((T_CTSK*)&ctsk_async);

	/* \XVJn */
	gWindowTaskID = acre_tsk((T_CTSK*)&ctsk_window);

	/* Xg[̃I[v */
	for(idx=0; idx<(int32_t)gvdparam->stream_num; idx++)
	{
		/* ParseĂȂMPS_OpenParse
		 * Parseς݂ł΃Reî܂܎gp */
		err = MPS_Open(idx, STREAM_NAME[idx]);
		if (err != AG903_ENONE)
		{
			MPS_ErrPrintf("ERROR: Movie file open failed\r\n");
			return err;
		}
	}

	/* o̓obt@ */
	for(idx=0; idx<MPS_MAX_STREAM; idx++)
	{
		for(cnt=0; cnt<MPS_OUTBUF_COUNT-1; cnt++)
		{
			err = MPS_PutOutputBuffer(idx, &gOutbufinfo[idx][cnt]);
			if(err)
				MPS_ErrPrintf("ERROR: MPS_PutOutputBuffer : %d\r\n", err);
		}
	}

	/* Đ */
	for (idx = 0; idx < MPS_MAX_STREAM; idx++)
	{
		MPS_Printf("[#%d] Play\r\n", idx);
		MPS_Play(idx);
	}

	bool done[MPS_MAX_STREAM] = {false};
	volatile mpsAsyncFlag *f[MPS_MAX_STREAM];
	for(idx=0; idx<MPS_MAX_STREAM; idx++)
		f[idx] = &ctx[idx]->flag;

	while(1)
	{
		for(idx=0; idx<MPS_MAX_STREAM; idx++)
		{
			if(!done[idx] && f[idx]->bDecDone)
			{
				done[idx] = true;
			}
		}

		bool btmp = true;
		for(idx=0; idx<MPS_MAX_STREAM; idx++)
			btmp &= done[idx];
		if(btmp)
			break;

		sys_dlytsk(100); /* tO`FbN */
	}

	/* Xg[̃N[Y */
	for (idx = 0; idx < MPS_MAX_STREAM; idx++)
	{
		MPS_Close(idx);
	}

	/* o̓obt@̉ */
	for(idx=0; idx<MPS_MAX_STREAM; idx++) {
		for(cnt=0; cnt<MPS_OUTBUF_COUNT; cnt++) {
			if(gOutbufinfo[idx][cnt].buffer != NULL) {
				MPS_Free(gOutbufinfo[idx][cnt].buffer);
				gOutbufinfo[idx][cnt].buffer = NULL;
			}
		}
	}

	MPS_Printf("Play done.\r\n");
	gFlagMPSDone = true; /* ĐIʒm */
	return 0;
}

/* TASK */
void mps_multi(void)
{
	/* ϐ */
	{
		gWindowAttributeAddr	= NULL;
		gWindowTaskID			= -1;
		gAsyncTaskID			= -1;
		gVSyncHdrID				= -1;
		gCallCnt				= 0;
		sys_memset(gBufListNextAdd,	0, sizeof(gBufListNextAdd));
		sys_memset(gBufListCount,	0, sizeof(gBufListCount));
		sys_memset(gBufListCurrent,	0, sizeof(gBufListCurrent));
		sys_memset(gBufListNext,	0, sizeof(gBufListNext));
		sys_memset(gBufListPrev,	0, sizeof(gBufListPrev));
		sys_memset(gBufList,		0, sizeof(gBufList));
		sys_memset(gOutbufinfo,		0, sizeof(gOutbufinfo));
		sys_memset(dsp_handle,		0, sizeof(dsp_handle));
		sys_memset((void *)gCurrentFrame,	0, sizeof(gCurrentFrame));
	}

	mpsConfig *mpsconf = MPS_getConfig();

	MPS_Printf("\r\n"
			   "[MOVIE PLAYER SAMPLE : MULTI STREAM]\r\n"
			   "\r\n");
	MPS_Printf("Setting start >>>\r\n");

	/* File system */
	{
		ER ercd;

		ercd = mountp('A', 0, (ID)Fsif_GetDevid(FSIF_DEV_CF)); /* CF->'A' */
		if (ercd != E_OK) {
			MPS_ErrPrintf("ERROR: CF mount failed.\r\n");
			return;
		}
	}

	/* semaphore */
	{
		T_CSEM pk_csem = {
		.sematr = TA_TPRI,
		.isemcnt = 1,
		.maxsem = 1,
		.name = "sem_window",
		};
		gSemID_BufSync = acre_sem(&pk_csem);
		if(gSemID_BufSync < 0)
		{
			MPS_ErrPrintf("ERROR: Sem create failed.\r\n");
			return;
		}
	}

	/* GVD */
	{
		int32_t err;
		err = movie_init();
		if(err) {
			goto label_finalize;
		}
	}

	/* DSP */
	{
		mpsContext *mpsctx;
		gWindowAttributeAddr = MPS_Memalign(0x20 * MPS_MAX_STREAM, 8);
		if(gWindowAttributeAddr == NULL)
		{
			MPS_ErrPrintf("ERROR: Out of memory.\r\n");
			return;
		}

		AG903_DSPMgrCtrlParam		dsp_ctrl	= {0};
		AG903_DSPMgrCMOSParam		dsp_cmos	= {0};
		AG903_DSPMgrWinAttribute	*dsp_attr	= NULL;
		AG903_DSPMgrWindowParam		dsp_win		= {0};
		AG903_DSPMgrIntParam		dsp_int		= {0};

		ERRCHK(AG903_ENONE, AG903_DSPMgrInit());

		MPS_Printf("Initialize display settings...\r\n");

		ERRCHK(AG903_ENONE, AG903_DSPMgrGetHandle(0, &dsp_handle[0]));

		dsp_ctrl.ip_sel			= AG903_DSP_VMODE_NONINTERLACE;
		dsp_ctrl.hrz_framesize	= 1280;
		dsp_ctrl.vt_framesize	= 1024;
		dsp_ctrl.syncparam		= &DSP_SAMPLE_SYNCPARAM[DSP_SAMPLE_RES_SXGA];

		/* PLL */
		AG903_SPCPrmPllnParam pll = {0};
		AG903_SPCPrmSetPll1Ctrl(&pll);
		sys_delayus(50);
		AG903_SPCPrmSetPll1Ctrl(&DSP_SAMPLE_PLL[DSP_SAMPLE_RES_SXGA]);
		sys_delayus(50);

		/* PORT */
		AG903_DSPMgrSetPortSel(dsp_handle[0], AG903_VOD0_PORTSEL_LVCMOS24);

		dsp_cmos.dotclk_polarity	= AG903_VOD_DOTCLK_LATCH_FALL;
		dsp_cmos.field_polarity	= AG903_DSP_POLARITY_POSI;
		dsp_cmos.hsync_polarity	= AG903_DSP_POLARITY_NEGA;
		dsp_cmos.vsync_polarity	= AG903_DSP_POLARITY_NEGA;
		dsp_cmos.rgbde_polarity	= AG903_DSP_POLARITY_POSI;
		dsp_cmos.hsync_en		= true;
		dsp_cmos.vsync_en		= true;
		dsp_cmos.rgbde_en		= true;
		dsp_cmos.pixeldata_en	= true;

		ERRCHK(AG903_ENONE,
			   AG903_DSPMgrSetCMOSParam(dsp_handle[0], &dsp_ctrl, &dsp_cmos));

		dsp_int.trigger_out		= AG903_DSP_EVENT_VT;
		dsp_int.trigger_vt		= AG903_DSP_TRG_VT_START_OF_VBLANK;
		dsp_int.int_vt_blank	= AG903_DSP_INT_START_OF_VBLANK;
		dsp_int.mask_vt_blank	= false;
		dsp_int.mask_dspoff		= true;
		dsp_int.mask_error		= true;
		dsp_int.mask_hrz_line	= true;
	    ERRCHK(AG903_ENONE,
			   AG903_DSPMgrSetIntParam(dsp_handle[0], &dsp_int));

		dsp_win.update_timing		= AG903_DSP_ATTR_END_OF_VSYNC;
		dsp_win.background			= 0x00000000;
		dsp_win.num_config			= MPS_MAX_STREAM;
		dsp_win.num_attr				= MPS_MAX_STREAM;
		dsp_win.palette_update		= 0;
		dsp_win.window_attr_base		= (uint32_t)gWindowAttributeAddr;
		dsp_win.window_attr_update	= 1;
		ERRCHK(AG903_ENONE,
			   AG903_DSPMgrSetWindowParam(dsp_handle[0], &dsp_win));

		/* Window 0 */
		mpsctx = MPS_getContext(0);
		ERRCHK(AG903_ENONE, AG903_DSPMgrGetAttribute(dsp_handle[0], 0, &dsp_attr));
		sys_memset(dsp_attr, 0, 0x20*MPS_MAX_STREAM);
		dsp_attr[0].position_x				= 10; /* 10px */
		dsp_attr[0].position_y				= WINDOW_HEIGHT[2] + 30; /* window2̉30px */
		dsp_attr[0].destination_width		= WINDOW_WIDTH[0];
		dsp_attr[0].destination_height		= WINDOW_HEIGHT[0];
		dsp_attr[0].framebuffer_base		= (uint32_t)gOutbufinfo[0][MPS_OUTBUF_COUNT-1].buffer;
		dsp_attr[0].source_width			= mpsctx->info.width;
		dsp_attr[0].source_height			= mpsctx->info.height;
		dsp_attr[0].hrz_size				= dsp_attr[0].source_width * 2;
		dsp_attr[0].conf.default_alpha		= 0xFF;
		dsp_attr[0].conf.framebuffer_format	= AG903_DSP_FFMT_YUV422_BT601_LIMIT;
		dsp_attr[0].conf.valid				= true;

		/* Window 1 */
		mpsctx = MPS_getContext(1);
		dsp_attr[1].position_x				= dsp_ctrl.hrz_framesize-WINDOW_WIDTH[1] - 10; /* E10px */
		dsp_attr[1].position_y				= dsp_ctrl.vt_framesize-WINDOW_HEIGHT[1]; /*  */
		dsp_attr[1].destination_width		= WINDOW_WIDTH[1];
		dsp_attr[1].destination_height		= WINDOW_HEIGHT[1];
		dsp_attr[1].framebuffer_base		= (uint32_t)gOutbufinfo[1][MPS_OUTBUF_COUNT-1].buffer;
		dsp_attr[1].source_width			= mpsctx->info.width;
		dsp_attr[1].source_height			= mpsctx->info.height;
		dsp_attr[1].hrz_size				= dsp_attr[1].source_width * 2;
		dsp_attr[1].conf.default_alpha		= 0xFF;
		dsp_attr[1].conf.framebuffer_format	= AG903_DSP_FFMT_YUV422_BT601_LIMIT;
		dsp_attr[1].conf.valid				= true;

		/* Window 2 */
		mpsctx = MPS_getContext(2);
		dsp_attr[2].position_x				= 0; /*  */
		dsp_attr[2].position_y				= 0; /*  */
		dsp_attr[2].destination_width		= WINDOW_WIDTH[2];
		dsp_attr[2].destination_height		= WINDOW_HEIGHT[2];
		dsp_attr[2].framebuffer_base		= (uint32_t)gOutbufinfo[2][MPS_OUTBUF_COUNT-1].buffer;
		dsp_attr[2].source_width			= mpsctx->info.width;
		dsp_attr[2].source_height			= mpsctx->info.height;
		dsp_attr[2].hrz_size				= dsp_attr[2].source_width * 2;
		dsp_attr[2].conf.default_alpha		= 0xFF;
		dsp_attr[2].conf.framebuffer_format	= AG903_DSP_FFMT_YUV422_BT601_LIMIT;
		dsp_attr[2].conf.valid				= true;

		ERRCHK(AG903_ENONE, AG903_DSPMgrSetAttribute(dsp_handle[0], 0));

		/* \ON */
		ERRCHK(AG903_ENONE, AG903_DSPMgrEnable(dsp_handle[0]));

		/* CMOSo͗L */
		Board_SelectDviTX();

		sys_dlytsk(1000); /* fBXvC̈҂ */
	}

	/* IRQ */
	{
		int32_t rc = AG903_ENONE;
		AG903_INTMgrHdrPrm intparam;
		intparam.atr	= AG903_INT_HLNG;
		intparam.func	= (void *)VSyncHandler;
		intparam.intno	= AG903_IRQ16_DSP0;
		if(rc == AG903_ENONE) {
			gVSyncHdrID = AG903_INTMgrSetHandler(&intparam);
		}

		if(gVSyncHdrID >= 0) {
			AG903_INTMgrEnableInt(intparam.intno);
		} else {
			rc = gVSyncHdrID;
		}
	}

	MPS_Printf("<<< Setting done.\r\n");

	movie_play(); /* Đ */

	sys_dlytsk(50); /* ^XNIP\ */

	/* I */
label_finalize:
	{
		if(gWindowTaskID >= 0)
		{
			ERRCHK(E_OK, del_tsk(gWindowTaskID));
			gWindowTaskID = -1;
		}
		if(gAsyncTaskID >= 0)
			ERRCHK(E_OK, del_tsk(gAsyncTaskID));

		if(dsp_handle[0] != NULL) {
			ERRCHK(AG903_ENONE, AG903_DSPMgrDisable(dsp_handle[0]));
			while(AG903_DSPMgrCheckStopped(dsp_handle[0]));
			AG903_DSPMgrIntStat intclr = {
				.clr_dspoff		= true,
				.clr_hrz_line	= true,
				.clr_vt_blank	= true,
			};
			AG903_DSPMgrClearIntStat(dsp_handle[0], &intclr);
			ERRCHK(AG903_ENONE, AG903_DSPMgrReleaseHandle(dsp_handle[0]));
		}

		ERRCHK(AG903_ENONE, AG903_INTMgrDisableInt(AG903_IRQ16_DSP0));
		ERRCHK(AG903_ENONE, AG903_INTMgrDeleteHandler(gVSyncHdrID));
		gVSyncHdrID = -1;
		ERRCHK(E_OK, del_sem(gSemID_BufSync));

		ERRCHK(AG903_ENONE, MPS_Finalize());
		mpsconf = MPS_getConfig();
		ERRCHK(AG903_ENONE, MPS_Free(mpsconf->memory_heap_top));
		mpsconf->memory_heap_top = NULL;
		ERRCHK(AG903_ENONE, MPS_Free(mpsconf->memory_work_top));
		mpsconf->memory_work_top = NULL;

		ERRCHK(AG903_ENONE, umountp(0, (ID)Fsif_GetDevid(FSIF_DEV_CF))); /* CFA}Eg */

		ERRCHK(AG903_ENONE, MPS_Free(gWindowAttributeAddr));
		gWindowAttributeAddr = NULL;
	}

	MPS_Printf("Main task done.\r\n");
	MPS_Printf("\n[SAMPLE END]\r\n");
}


/***********************************
		   WINDOW CONTROL
***********************************/

void window_tsk(VP_INT exinf)
{
	((void)exinf);
	while(!gFlagMPSDone)
	{
		ERRCHK(E_OK, wai_sem(gSemID_BufSync));
		WindowUpdate();
		ERRCHK(E_OK, sig_sem(gSemID_BufSync));
		slp_tsk();
	}

	MPS_Printf("Window task done.\r\n");
	ext_tsk();
}

static void VSyncHandler(void)
{
	AG903_DSPMgrIntStat intstat = {0};
	AG903_DSPMgrGetIntStat(dsp_handle[0], &intstat);
	intstat.clr_vt_blank	= intstat.int_vt_blank;
	AG903_DSPMgrClearIntStat(dsp_handle[0], &intstat);
	if(gWindowTaskID > 0)
		wup_tsk(gWindowTaskID);

	return;
}

static void UpdateWindowAddr(int win_id, uintptr_t addr)
{
	AG903_DSPMgrWinAttribute *dsp_attr;
	AG903_DSPMgrGetAttribute(dsp_handle[0], 0, &dsp_attr);
	dsp_attr[win_id].framebuffer_base = (uint32_t)addr;
	AG903_DSPMgrSetAttribute(dsp_handle[0], 0);
}

/* fR[hς݃obt@̒ǉ */
static void AppendBufferInfo(mpsContext *ctx, gvdOutBufInfo buf, gvdTimeStamp ts)
{
	ERRCHK(E_OK, wai_sem(gSemID_BufSync));

	DecodedBufferInfo dbi = {ctx, buf, ts};
	uint32_t wID = ctx->id;

	gBufList[wID][gBufListNextAdd[wID]] = dbi;
	gBufListNextAdd[wID]++;
	if(gBufListNextAdd[wID] == MPS_OUTBUF_COUNT)
		gBufListNextAdd[wID] = 0;
	gBufListCount[wID]++;

	ERRCHK(E_OK, sig_sem(gSemID_BufSync));
}

/* \̍XV */
static void WindowUpdate()
{
	int32_t w, w_min, w_max;

	/* window0window1,2ŕ */
	if(gCallCnt == 0)
	{
		gCallCnt = 1;
		w_min = w_max = 0;
	}
	else
	{
		gCallCnt = 0;
		w_min = 1;
		w_max = MPS_MAX_STREAM-1;
	}

	for(w=w_min; w<=w_max; w++)
	{
		if(gBufListCount[w] > 0)
		{

			/* \t[̍XV */
			UpdateWindowAddr(gBufList[w][gBufListCurrent[w]].ctx->id,
							 (uintptr_t)gBufList[w][gBufListCurrent[w]].buf.buffer);
			gCurrentFrame[w] = gBufList[w][gBufListCurrent[w]].ts.frame_id;

			/* gIo̓obt@̍ċ */
			if(gBufListPrev[w] != gBufListCurrent[w])
			{
				MPS_PutOutputBuffer(gBufList[w][gBufListPrev[w]].ctx->id,
									&gBufList[w][gBufListPrev[w]].buf);
				gBufList[w][gBufListPrev[w]].buf.buffer = NULL;
			}

			gBufListPrev[w] = gBufListCurrent[w];
			gBufListCurrent[w] = gBufListNext[w];
			gBufListNext[w]++;
			if(gBufListNext[w] == MPS_OUTBUF_COUNT)
				gBufListNext[w] = 0;

			gBufListCount[w]--;

		}
	} /* for(w=0; w<MPS_MAX_STREAM; w++) */

	return;
}

static void BufferReset(int window)
{
	gBufListNextAdd[window]	= MPS_OUTBUF_COUNT-1;
	gBufListCount[window]	= 0;
	gBufListCurrent[window]	= MPS_OUTBUF_COUNT-1;
	gBufListNext[window]	= 0;
	gBufListPrev[window]	= MPS_OUTBUF_COUNT-1;
}


/* GVDcommit_output_buffer̃R[obN */
static int32_t cbMPSDecodeDone(void *param_gvd, void *param_user, gvdError error)
{
	((void)(error));

	gvdOutBufInfo *outbuf = NULL;
	mpsContext *ctx = (mpsContext *)param_user;
	gvdFrameInfo *frameInfo = (gvdFrameInfo *)param_gvd;
	gvdTimeStamp ts = {frameInfo->timestamp, frameInfo->frame_count, 0};

	/* ԋpꂽgvdFrameInfoƓAhXgvdOutBufInfo */
	int32_t idx;
	for (idx=0; idx<MPS_OUTBUF_COUNT; idx++)
	{
		if(gOutbufinfo[ctx->id][idx].buffer == frameInfo->buffer)
		{
			outbuf = &gOutbufinfo[ctx->id][idx];
			break;
		}
	}

	/* fR[hς݃obt@ǉ */
	AppendBufferInfo(ctx, *outbuf, ts);

	return 0;
}

/* GVD̒vIG[̃R[obN */
static int32_t cbMPSFatalerror(void *param_gvd, void *param_user, gvdError error)
{
	((void)param_user);
	((void)error);
	gFatal = *(gvdFatalErrorInfo *)param_gvd;
	MPS_ErrPrintf("ERROR: Fatal error detected. cont=%hhu, cause=%hhu\r\n",
			   gFatal.context_id, gFatal.cause);
	return 0;
}
