/*
 * @history		2019_12_27  [SDK3.0] BMUobt@̃TCYƃAC4096̔{ɂȂ悤C (#2188)
 * @history     2020_07_22  [SDK3.1] GVDL郁̈w肷APIǉ (#2965)
 */
#include <stdio.h>
#include <stdint.h>
#include <stdarg.h>

#include "kernel.h"
#include "com.h"
#include "sample_common.h"
#include "mps_common.h"
#include "mtx_movie.h"
#include "mtx_sample.h"

#include "int/intmgr.h"
#include "bmu/bmumgr.h"
#include "dsp/dspmgr.h"
#include "timr/timrmgr.h"
#include "osp/ospmgr.h"

/* }N */
#define	PRINT(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)

static gvdFatalErrorInfo		gFatal = {0, 0};
mpsOutBufInfo				gOutbufinfo[MTX_MOV_OUTBUF_COUNT];	/* o̓obt@ */
static char					MTX_MOV_STREAM_NAME[100] = "A:\\mtx_mov.mp4";

extern bool					gFlagExit;			/* TvItO */
extern bool					gFlagMPSDone;		/* 揈ItO */
extern ER_ID				gWindowTaskID;		/* EBhE^XNID */
extern ER_ID				gAsyncTaskID;		/* 񓯊^XNID */
/* Cunh */
extern AG903_DSPMgrHandle	*MTX_dsp_handle;
extern AG903_TIMRMgrHandle	*MTX_tim_handle;
extern AG903_BMUMgrHandle	*MTX_bmu_handle[2];
extern AG903_OSPMgrHandle	*MTX_osp_handle;

/* 񓯊^XN
 * ȊÕ^XNŗ]ԂɃR[
 * fR[_̐s߁AR[pxƃfR[h\ɉe܂ */
extern void async_tsk(VP_INT);
static const T_CTSK ctsk_async = {
	TA_HLNG | TA_ACT | TA_FPU, (VP_INT)0, (FP)async_tsk, 8, 0x800, 0, "Async"
};


/* mۊ֘A */
static int32_t cbMPSDecodeDone(void *param_gvd, void *param_user, gvdError error);
static int32_t cbMPSFatalerror(void *param_gvd, void *param_user, gvdError error);

int32_t movie_init(void)
{
	int32_t err;
	int32_t cnt;

	size_t work_size;
	void *work_addr;

	mpsSetting mpssetting;
	mpsConfig mpsconfig;
	mpsContext *mpsctx;

	/* MPS̏ */
	mpssetting.max_stream = MTX_MOV_STREAM_COUNT;
	mpssetting.stream_buffer_size = MTX_MOV_INBUF_TOTAL;
	mpssetting.stream_buffer_num = MTX_MOV_INBUF_COUNT;
	mpssetting.func_decode_done_handler =
		(int32_t (*)(void *, void *, gvdError))cbMPSDecodeDone;
	mpssetting.func_fatalerror_handler =
		(int32_t (*)(void *, void *, gvdError))cbMPSFatalerror;
	err = MPS_Initialize(mpssetting);
	if(err)
	{
		MTX_ErrPrintf("ERROR: MPS_Initialize() : %d\n", err);
		return err;
	}

	ERRCHK(GVD_ERR_SUCCESS, GVD_SetFatalErrorAddress((void *)0xFE007000));
	ERRCHK(GVD_ERR_SUCCESS, GVD_SetOccupyMemoryAddress((void *)0x83FF0000));

	/* GVDp[N̊m */
	work_size = MPS_GetRequiredWorkMemorySize();
	MTX_Printf("[Memory] GVD requested %u [Byte]\n", work_size);

	/* GVDp[N32KBȏ̃ACK{ */
	work_addr = sys_memalign(work_size, 32*1024);
	if(work_addr == 0)
	{
		MTX_ErrPrintf("ERROR: [GVD WorkBuffer] allocate faild.\r\n");
		return -1;
	}

	mpsconfig.num_out_buffer = MTX_MOV_OUTBUF_COUNT;
	mpsconfig.memory_work_top = work_addr;
	mpsconfig.memory_work_size = work_size;

	/* GVDpq[v2KBȏ̃ACK{ */
	mpsconfig.memory_heap_top = sys_memalign(MTX_MOV_HEAP_SIZE, 2048);
	if(mpsconfig.memory_heap_top == NULL)
	{
		MTX_ErrPrintf("ERROR: Heap memory alloc failed.\r\n");
		return -AG903_ENOMEM;
	}
	mpsconfig.memory_heap_size = MTX_MOV_HEAP_SIZE;

	/* MP4Reỉ
	 * ȍ~Rei񂪎g */
	err = MPS_Parse(0, MTX_MOV_STREAM_NAME);
	if (err != AG903_ENONE)
	{
		MTX_ErrPrintf("ERROR: MP4 Parse failed\n");
		return err;
	}

	/* o̓obt@̊m */
	{
		uint32_t stream_stride;
		mpsctx = MPS_getContext(0);
		if(mpsctx->info.width == 0 || mpsctx->info.height == 0)
		{
			mpsctx->info.width = MTX_MOV_STREAM_WIDTH;
			mpsctx->info.height = MTX_MOV_STREAM_HEIGHT;
			mpsctx->info.frame_length = 1;
			mpsctx->info.time_scale = 30;
		}

		stream_stride = MTX_ALIGNn(64, mpsctx->info.width)
		              * MTX_ALIGNn(32, mpsctx->info.height)
		              * 2;
		/* ꊇobt@mێɊeobt@AhXAC𖞂߂̒ */
		stream_stride = MTX_ALIGNn(4096, stream_stride);

		/* BMUŎgp镪܂Ƃ߂Ċm */
		gOutbufinfo[0].size_buffer =
			stream_stride * MTX_MOV_OUTBUF_COUNT;
		gOutbufinfo[0].buffer =
			sys_memalign(gOutbufinfo[0].size_buffer, 4096);
		if(gOutbufinfo[0].buffer == NULL)
		{
			MTX_ErrPrintf("ERROR: [BMU buffer area] allocate faild.\r\n");
			return -AG903_ENOMEM;
		}
		mpsconfig.output_select = GVD_OUTMOD_BMU;

		/* t[obt@̏ */
		uint32_t *p = (uint32_t *)gOutbufinfo[0].buffer;
		for(cnt=0; cnt<gOutbufinfo[0].size_buffer>>2; cnt++)
		{
			*(p + cnt) = 0x00000000;
		}
	}

	/* GVD̏ */
	err = MPS_Start(mpsconfig);
	if(err)
	{
		MTX_ErrPrintf("ERROR: MPS_Start() : %d\n", err);
		return err;
	}

	/* o̓obt@ݒ */
	mpsctx = MPS_getContext(0);
	ERRCHK(GVD_ERR_SUCCESS, GVD_SetMaxNumInputBuffers(mpsctx->gvdctx, MTX_MOV_INBUF_COUNT));
	ERRCHK(GVD_ERR_SUCCESS, GVD_SetMaxNumOutputBuffers(mpsctx->gvdctx, MTX_MOV_OUTBUF_COUNT));

	return 0;
}


int32_t movie_play(void)
{
	int cnt;
	int32_t err;
	mpsContext *ctx = NULL;

	ctx = MPS_getContext(0);
	gFlagMPSDone = false;

	/* 񓯊Jn */
	gAsyncTaskID = acre_tsk((T_CTSK*)&ctsk_async);

	/* Xg[̃I[v */
	/* ParseĂȂMPS_OpenParse
	 * Parseς݂ł΃Reî܂܎gp */
	err = MPS_Open(0, MTX_MOV_STREAM_NAME);
	if (err != AG903_ENONE)
	{
		MTX_ErrPrintf("ERROR: Movie file open failed\n");
		return err;
	}

	/* Đ */
	MTX_Printf("Play #%d\n", 0);
	MPS_Play(0);

	volatile mpsAsyncFlag *f;
	f = &ctx->flag;

	while(1)
	{
		if(gFlagExit == false)
		{
			if(f->bDecDone && !f->bSought)
			{
				/* [vɐ擪t[ւ̃V[NKv.
				 * ̂MPS_OpenŎIɐ擪t[փV[N */
				MPS_Seek(0, 0, MPS_SEEK_FRAME);
				MPS_Play(0);
			}
		}
		else
		{
			MPS_Pause(0);
			break;
		}
		sys_dlytsk(33); /* tO`FbN */
	}

	/* Xg[̃N[Y */
	MPS_Close(0);

	/* o̓obt@̉ */
	for(cnt=0; cnt<MTX_MOV_OUTBUF_COUNT; cnt++) {
		if(gOutbufinfo[cnt].buffer != NULL) {
			sys_free(gOutbufinfo[cnt].buffer);
			gOutbufinfo[cnt].buffer = NULL;
		}
	}

	gFlagMPSDone = true; /* ĐIʒm */
	return 0;
}


/* \̍XV */
void WindowUpdate(void)
{
	AG903_OSPMgrClearFIFO(MTX_osp_handle);
	AG903_OSPMgrSetFIFO(MTX_osp_handle, 5);
	AG903_OSPMgrEnable(MTX_osp_handle);
}

/*----------------------------
  R[obN
  ----------------------------*/

/* GVDcommit_output_buffer̃R[obN */
static int32_t cbMPSDecodeDone(void *param_gvd, void *param_user, gvdError error)
{
	((void)(error));
	((void)(param_gvd));
	((void)(param_user));
	return 0;
}

/* GVD̒vIG[̃R[obN */
static int32_t cbMPSFatalerror(void *param_gvd, void *param_user, gvdError error)
{
	((void)param_user);
	((void)error);
	gFatal = *(gvdFatalErrorInfo *)param_gvd;
	MTX_ErrPrintf("ERROR: Fatal error detected. cont=%hhu, cause=%hhu\n",
			   gFatal.context_id, gFatal.cause);
	return 0;
}

