/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __BMUGFX_H__
#define __BMUGFX_H__

#include <stdint.h>


#define RU(X,M)	(((X) + (M)-1) & ~((M)-1))

// Lv`C[W 
#define BG_WIDTH	640
#define BG_HEIGHT	480
#define BG_BPP		16
#define BG_SIZE		RU((BG_WIDTH*BG_BPP/8)*BG_HEIGHT, 4096)
#define BG_FRAMES	3

// \C[W
#define GB_WIDTH	640
#define GB_HEIGHT	480
#define GB_BPP		16
#define GB_SIZE		RU((GB_WIDTH*GB_BPP/8)*GB_HEIGHT, 4096)
#define GB_FRAMES	3

extern void *gfx_bg_adr; // BMU page address for PGP-BMU-GFX
extern void *gfx_gb_adr; // BMU page address for         GFX-BMU-DSP
extern uint32_t gfx_bg_srcadr;
extern uint32_t gfx_bg_snkadr;
extern uint32_t gfx_gb_srcadr;
extern uint32_t gfx_gb_snkadr;

#endif
