/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

static void *dstAddr;
static void *image_data1, *image_data2;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {0.0F, 0.0F, 0.0F, 0.0F};

    /* 摜Ǎ */
    image_data1 = GfxGetFreeArea(IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_BPP<<3);
    GfxFsRead((int8_t*)IMAGE_NAME1, IMAGE_STRIDE * IMAGE_HEIGHT, (void*)image_data1);
    image_data2 = GfxGetFreeArea(IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_BPP<<3);
    GfxFsRead((int8_t*)IMAGE_NAME2, IMAGE_STRIDE * IMAGE_HEIGHT, (void*)image_data2);

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* IMAGE_USER_TO_SURFACEPʍsɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);
    vgLoadIdentity();

    /* */
    dstAddr = GfxGetFreeArea(IMAGE_WIDTH, IMAGE_HEIGHT, 32);
}

static void DrawDirectImage(void)
{
    VGImage directImage;

    /* DRAMɃC[Wf[^] */
    GfxWriteMemory(dstAddr, image_data1, IMAGE_STRIDE * IMAGE_HEIGHT);

    /* _CNgC[WQƂ̃IuWFNg𐶐 */
    directImage = vgCreateDirectImageEXT(VG_sRGBA_8888,
                                         IMAGE_WIDTH,
                                         IMAGE_HEIGHT,
                                         VG_IMAGE_QUALITY_FASTER,
                                         dstAddr,
                                         IMAGE_STRIDE);

    /* ` */
    vgTranslate(100, 180);
    vgDrawImage(directImage);
    vgFinish();

    /* DRAMɕʂ̃C[Wf[^] */
    GfxWriteMemory(dstAddr, image_data2, IMAGE_STRIDE * IMAGE_HEIGHT);

    /* ` */
    vgTranslate(280, 0);
    vgDrawImage(directImage);

    /* C[WIuWFNgj */
    vgDestroyImage(directImage);

}

static void TestTerm(void)
{
    GfxReleaseFreeArea(image_data1);
    GfxReleaseFreeArea(image_data2);
    GfxReleaseFreeArea(dstAddr);
}

void DirectImageMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* _CNgC[W` */
    DrawDirectImage();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
