/**
 * @brief		Tvʕ
 * @file		sample_common.c
 * @author		AXELL
 * @history     2017_02_22	
 * @description
 * @note
*/

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include "kernel.h"
#include "AG903_UC3.h"
#include "sample_common.h"
#include "com.h"
#include "vram/vrammgr.h"
#include "sys/sscprm.h"
#include "ffsysdrv_cfg.h"

/*-- System Memory --*/
static int32_t	gMplID = 0;
static void*	gMemList[AG903_SAMPLE_SYS_MALLOC_MAX] = {NULL};
static const int8_t MemTypeTbl[SYSMEM_TYPE_NUM] =
{AG903_VRAM_NORMAL_CACHE_OFF, AG903_VRAM_NORMAL_CACHE_ON, AG903_VRAM_STRONGLY_ORDERED};

static void* GetBufferPoolMemory(size_t size, uint32_t align);

/**
 * @brief		VXe
 * @param		mplsz [in] TCY
 * @param		mpl   [in] AhX
 * @param		type  [in] ^Cv
 * @return		G[R[h
 * @note		malloc񐔂̏"AG903_SAMPLE_SYS_MALLOC_MAX"Œ`
*/
int32_t sys_meminit(uint32_t mplsz, void *mpl, SysMemType type)
{
	int32_t				rc = AG903_ENONE;
	AG903_VRAMMgrMplPrm	mplprm;

	if(0 != gMplID) {
		return -AG903_EFAULT;	/* ς */
	}

	mplprm.memtype = MemTypeTbl[type];
	mplprm.mplatr  = AG903_VRAM_ATRFIFO;
	mplprm.mplsz   = mplsz;
	mplprm.mpl     = mpl;

	gMplID = AG903_VRAMMgrCreateMpl(&mplprm);

	if (gMplID <= 0) {
		rc = -AG903_ENOMEM;
	}
	else {
		sys_memset((void *)&gMemList, 0, sizeof(gMemList));
	}

	return rc;
}

/**
 * @brief		VXe
 * @param		Ȃ
 * @return		Ȃ
 * @note
*/
void sys_memfinal(void)
{
	int32_t	ii;

	for (ii = 0;ii < AG903_SAMPLE_SYS_MALLOC_MAX;ii++) {
		if (gMemList[ii]) {
			sys_free((void *)gMemList[ii]);
		}
	}

	if (gMplID > 0) {
		AG903_VRAMMgrDeleteMpl(gMplID);
		gMplID = 0;
	}

	return;
}

/**
 * @brief		mہiAC4Œj
 * @param		size [in] mۃTCY
 * @return		mۃAhX
 * @note
*/
void* sys_malloc(size_t size)
{
	int32_t	ii;
	void	*ptr = NULL;

	for (ii = 0;ii < AG903_SAMPLE_SYS_MALLOC_MAX;ii++) {
		if (gMemList[ii] == NULL) {
			gMemList[ii] = ptr = GetBufferPoolMemory(size, 4);
			break;
		}
	}

	return ptr;
}

/**
 * @brief		mہiACwj
 * @param		size [in] mۃTCY
 * @param		align [in] ACTCY
 * @return		mۃAhX
 * @note
*/
void* sys_memalign(size_t size, uint32_t align)
{
	int32_t	ii;
	void	*ptr = NULL;

	for (ii = 0;ii < AG903_SAMPLE_SYS_MALLOC_MAX;ii++) {
		if (gMemList[ii] == NULL) {
			gMemList[ii] = ptr =GetBufferPoolMemory(size, align);
			break;
		}
	}

	return ptr;
}

/**
 * @brief		
 * @param		blk [in] AhX
 * @return		G[R[h
 * @note
*/
int32_t sys_free(void *blk)
{
	int32_t	rc = AG903_ENONE;
	int32_t	ii;

	for (ii = 0;ii < AG903_SAMPLE_SYS_MALLOC_MAX;ii++) {
		if (gMemList[ii] == blk) {
			rc = AG903_VRAMMgrFree(gMplID, blk);
			if (rc == AG903_ENONE) { gMemList[ii] = NULL; }
			break;
		}
	}

	return rc;
}

/**
 * @brief		Ԏ擾
 * @param		size [out] mۉ\TCY
 * @return		G[R[h
 * @note
*/
void sys_memspace(size_t *size)
{
	int32_t					rc;
	AG903_VRAMMgrMplStat	mplsta;

	rc = AG903_VRAMMgrMrefer(gMplID, &mplsta);

	if (rc == AG903_ENONE) {
		*size = mplsta.fblksz;
	}
	else {
		*size = 0;
	}

	return;
}

static void* GetBufferPoolMemory(size_t size, uint32_t align)
{
	void	*addr;

	if (align < 4) {
		align = 4/*ŏE=4oCg*/;
	}

	addr = AG903_VRAMMgrMallocAlign(gMplID, align, size);

	return addr;
}


/*-- FileSystem I/F --*/
#if (CFG_DRV_DSK_CNT > 2)
extern void msc_getContext(uint8_t devnum, int32_t* pContext);
#endif
/**
 * @brief		foCXID擾
 * @param		device [in] ΏۃfoCX
 * @return		foCXID
 * @note
*/
int32_t Fsif_GetDevid(uint8_t device)
{
	int32_t devid;

	switch(device) {
		case FSIF_DEV_SD:
			devid = 0;		/** devidffsysdrv_cfg.h̓eɈˑ **/
			break;
#if (CFG_DRV_DSK_CNT > 1)
		case FSIF_DEV_CF:
			devid = 1;		/** devidffsysdrv_cfg.h̓eɈˑ **/
			break;
#endif
#if (CFG_DRV_DSK_CNT > 2)
		case FSIF_DEV_USB0:
			msc_getContext(0, &devid);
			break;
		case FSIF_DEV_USB1:
			msc_getContext(1, &devid);
			break;
#endif
		default:
			devid=(-1);
			break;
	}

	return devid;
}


/*-- utility --*/
/**
 * @brief		Print
 * @param		cond [in] 0FPrintA1FG[óȂFȂ
 * @param		pFormat [in] 
 * @return		Ȃ
 * @note		"AG903_SAMPLE_SYS_PRINT_MAX"
*/
void sys_print(int32_t cond, char *pFormat, ...)
{
	char		xxx[AG903_SAMPLE_SYS_PRINT_MAX];
	va_list		ap;

	if (cond == 0 || cond == 1) {
		va_start(ap, pFormat);
		(void)vsprintf(xxx, pFormat, ap);
		va_end(ap);
		COM_PutStr(xxx);
	}

	if (cond == 1) {
		sys_dlytsk(AG903_SAMPLE_DLY_ERROUT);
	}

	return;
}

/**
 * @brief		w莞ԑҋ@iusPʁj
 * @param		us [in]  (<= 20,000,000[us])
 * @return		Ȃ
 * @note		w莞ԃbN܂.
 * @note		20bԂw肳ꂽꍇ, ҋ@܂.
*/
void sys_delayus(uint32_t us)
{
	if(us > 20000000) return;

	uint32_t upper, lower;
	uint64_t start, now;
	uint64_t time = (AG903_SAMPLE_SYSCLK/1000000)*us;

	AG903_SSCPrmGetFreeRunCnt(&upper, &lower);
	start = (uint64_t)upper << 32 | lower;

	do {
		AG903_SSCPrmGetFreeRunCnt(&upper, &lower);
		now = (uint64_t)upper << 32 | lower;
	}while(now - start < time);
}

/**
 * @brief		DelayimsPʁj
 * @param		msec [in] delay
 * @return		Ȃ
 * @note
*/
void sys_dlytsk(uint32_t msec)
{
	uint32_t tim;

	tim = (msec/AG903_SAMPLE_TICK);
	if(msec%AG903_SAMPLE_TICK) {
		tim ++;
	}
	dly_tsk(tim);
	return;
}

/**
 * @brief		Zbg
 * @param		buf [in] AhX
 * @param		chr [in] Zbg
 * @param		len [in] ZbgTCY
 * @return		Ȃ
 * @note
*/
void sys_memset(void* buf, int32_t chr, uint32_t len)
{
	uint8_t *str = (uint8_t *)buf,
			*end = (str + len);

	while (str < end) { *str = chr; str++; }
	return;
}

/**
 * @brief		Rs[
 * @param		dst [in] Rs[AhX
 * @param		src [in] Rs[AhX
 * @param		len [in] Rs[TCY
 * @return		Rs[AhX
 * @note
*/
void* sys_memcpy(void *dst, const void *src, uint32_t len)
{
	int8_t	*ptr1 = (int8_t *)dst,
			*ptr2 = (int8_t *)src;

	while (len-- > 0) {
		*ptr1 = *ptr2;
		ptr1++;
		ptr2++;
	}

	return dst;
}

/**
 * @brief		
 * @param		buf [in] AhX
 * @param		chr [in] 
 * @param		len [in] TCY
 * @return		Rs[AhX
 * @note
*/
void* sys_memchr(const void *buf, uint8_t chr, uint32_t len)
{
	uint8_t		*sp = (uint8_t *)buf,
				*ep = ((uint8_t *)buf + len);
	void 		*pp = NULL;

	while (sp <= ep) {
		if (*sp == chr) {
			pp = (void *)sp;
			break;
		}

		sp++;
	}

	return pp;
}

/**
 * @brief		񌟍
 * @param		str1 [in] AhX
 * @param		str2 [in] 
 * @return		vAhX
 * @note
*/
char* sys_strstr(char* str1, char* str2)
{
	char	*str = NULL;
	char	*ptr1, *ptr2;

	if (*str2 == '\0') {
		str =  str1;
	}
	else {
		do {
			if (*str1 == *str2) {
				ptr1 = str1;
				ptr2 = str2;

				while (*ptr1 == *ptr2) {
					ptr1++;
					ptr2++;

					if (*ptr2 == '\0') {
						str = str1;
						break;
					}
				}
			}
		} while ((str == NULL) && *str1++);
	}

	return str;
}


/**
 * @brief		[擾
 * @return		[
*/
uint32_t sys_rand(void)
{
	uint32_t upper, lower;
	AG903_SSCPrmGetFreeRunCnt(&upper, &lower);

	srand(lower);

	return ((uint32_t)rand());
}

/* uint32_tɕϊ */
uint32_t sys_strtoul(const char * restrict nptr, char ** restrict endptr, int32_t base)
{
	return strtoul(nptr, endptr, base);
}

/**
 * @brief		ASCIIoCiϊ
 * @param		chr [in] ASCII
 * @return		oCil
 * @note
*/
uint8_t ASCtoBIN(uint8_t chr)
{
	uint8_t	val;

	if ((chr >= '0') && (chr <= '9')) {
		val = chr - '0';
	}
	else if ((chr >= 'A') && (chr <= 'F')) {
		val = chr - 'A' + 10;
	}
	else if ((chr >= 'a') && (chr <= 'f')) {
		val = chr - 'a' + 10;
	}
	else {
		val = 0;
	}

	return val;
}

void Port_SetFunction(uint8_t group, uint8_t function)
{
	uint32_t val;
	uint8_t  regno;
	uint8_t  offset;

	regno  = group/16;
	offset = (group%16)*2;

	AG903_SSCPrmGetPinFunction(regno, &val);
	val   &= ~(0x03 << offset);
	val   |= function << offset;
	AG903_SSCPrmSetPinFunction(regno, val);

	return;
}

void Port_DisableGpio(uint8_t gpio, uint8_t num)
{
	uint32_t	val;
	uint8_t		loop;
	uint8_t		reg;
	uint8_t 	bit;

	for(loop=0; loop<num; loop++) {
		reg = (gpio+loop)/32;
		bit = (gpio+loop)%32;
		AG903_SSCPrmGetPinGpioEnable(reg, &val);
		val &= ~(0x01 << bit);
		AG903_SSCPrmSetPinGpioEnable(reg, val);
	}

	return;
}

void Port_EnableGpio(uint8_t gpio, uint8_t num)
{
	uint32_t	val;
	uint8_t		loop;
	uint8_t		reg;
	uint8_t 	bit;

	for(loop=0; loop<num; loop++) {
		reg = (gpio+loop)/32;
		bit = (gpio+loop)%32;
		AG903_SSCPrmGetPinGpioEnable(reg, &val);
		val |= (0x01 << bit);
		AG903_SSCPrmSetPinGpioEnable(reg, val);
	}

	return;
}

void Sys_SetDmaInterface(uint8_t interface, uint8_t req)
{
	uint32_t	val;
	uint8_t		reg_no;
	uint8_t		offset;

	reg_no = interface/4;
	offset = interface%4;

	AG903_SSCPrmGetDmaInterface(reg_no, &val);
	val &= ~(0xFF << (offset*8));
	val |= (req << (offset*8));
	AG903_SSCPrmSetDmaInterface(reg_no, val);

	return;
}

