/**
 * @brief			{[hˑ
 * @file			board.c
 * @author			AXELL
 * @history			2016_07_07	(main.cycommon.c番)<p>
 *					2018_03_30	[SDK2.1] ^NgXCb`̐ڑ/ڑ̐ݒǉ (#1895)
 *                  2024_03_22  [SDK3.6] @\O[v24UART3ɑΉGPIOsԍ̃RgC (#5205)
 *                  2025_03_06  [SDK3.7] SSPCuSPI[hł̑MANZX@\ǉ (#5662)
 * @description
 * @note
*/

/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */

#include "AG903_UC3.h"
#include "sample_common.h"
#include "i2c/i2cmgr.h"
#include "via/viamgr.h"
#include "sys/sscprm.h"
#include "sys/spcprm.h"

#ifdef  AG903_SAMPLE_USE_FS
#include "DDR_AG903_CF_cfg.h"
#endif/*AG903_SAMPLE_USE_FS*/

#define AG903_SAMPLE_USE_BLP0	(0)

/*-- vg^Cv` --*/
static void FPGA_RegWrite(uint8_t addr, uint8_t data);
static void FPGA_RegRead(uint8_t addr, uint8_t* data);
static void Bd_I2cWrite(uint8_t ch, uint8_t saddr, uint8_t addr, uint8_t data);
static void Bd_I2cRead(uint8_t saddr, uint8_t addr, uint8_t* data);
static void Bd_I2cCallback(AG903_I2CMgrHandle* handle, uint32_t event);
static int32_t Bd_I2cWaitWrite(uint32_t timout);
static int32_t Bd_I2cWaitRead(uint32_t timout);
static void Ssp_SetClkSrc(uint8_t ch, uint8_t src, uint8_t div);


extern void Port_SetFunction(uint8_t group, uint8_t function);
extern void Port_DisableGpio(uint8_t gpio, uint8_t num);

/*-- ϐ` --*/
static _Bool	I2cWriteEnd=false;
static _Bool	I2cReadEnd=false;


/**
 * @brief		|[gt@NVݒ
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
*/
void Board_SetPotrFunc(void)
{
	Port_SetFunction( 0, PORT_FUNCTION_3);	/* O[v0 = Function3 [EQS] */
	Port_DisableGpio(60, 4);				/* GPIO60`GP63 = Disable */

	Port_SetFunction( 1, PORT_FUNCTION_3);	/* O[v1 = Function3 [EQS] */
	Port_DisableGpio(58, 2);				/* GPIO58`GP59 = Disable */

	Port_SetFunction( 2, PORT_FUNCTION_2);	/* O[v2 = Function2 [DVO] */
	Port_SetFunction( 3, PORT_FUNCTION_2);	/* O[v3 = Function2 [DVO] */
	Port_SetFunction( 4, PORT_FUNCTION_2);	/* O[v4 = Function2 [DVO] */
	Port_SetFunction( 5, PORT_FUNCTION_2);	/* O[v5 = Function2 [DVO] */
	Port_DisableGpio(64, 29);				/* GPIO64`GPIO92 = Disable */

	Port_SetFunction( 6, PORT_FUNCTION_4);	/* O[v6 = Function4 [CF/IDE] */
	Port_DisableGpio(104, 2);				/* GPIO104`GPIO105 = Disable */

	Port_EnableGpio(106, 2);				/* GPIO106`GPIO107 = Enable [GPIO] */

#if AG903_SAMPLE_USE_BLP0
	Port_SetFunction( 6, PORT_FUNCTION_2);	/* O[v6 = Function2 [BLP0] F[CF/IDE]Ɣr */
	Port_SetFunction( 7, PORT_FUNCTION_2);	/* O[v7 = Function2 [BLP0] F[GPIO]Ɣr */
	Port_DisableGpio(104, 4);				/* GPIO104`GPIO107 = Disable */
#endif
	Port_SetFunction( 8, PORT_FUNCTION_2);	/* O[v8 = Function2 [BLP1] */
	Port_SetFunction( 9, PORT_FUNCTION_2);	/* O[v9 = Function2 [BLP1] */
	Port_DisableGpio(108, 4);				/* GPIO108`GPIO111 = Disable */

	Port_SetFunction(10, PORT_FUNCTION_1);	/* O[v10 = Function1 [UART0] */
	Port_DisableGpio(96, 2);				/* GPIO96`GPIO97 = Disable */

	Port_SetFunction(12, PORT_FUNCTION_3);	/* O[v12 = Function3 [CF/IDE] */
	Port_DisableGpio(94, 2);				/* GPIO94`GPIO95 = Disable */

	Port_SetFunction(15, PORT_FUNCTION_4);	/* O[v15 = Function4 [CF/IDE] */
	Port_DisableGpio(124, 2);				/* GPIO124`GPIO125 = Disable */

	Port_SetFunction(16, PORT_FUNCTION_4);	/* O[v16 = Function4 [SSP3] */
	Port_DisableGpio(100, 4);				/* GPIO100`GPIO103 = Disable */

											/* Fixed Function [USB] */
	Port_DisableGpio(112, 2);				/* GPIO112`GPIO113 = Disable */

	Port_SetFunction(17, PORT_FUNCTION_4);	/* O[v17 = Function4 [CF/IDE] */
	Port_DisableGpio(114, 5);				/* GPIO114`GPIO118 = Disable */

	Port_SetFunction(18, PORT_FUNCTION_4);	/* O[v18 = Function4 [CF/IDE] */
	Port_DisableGpio(119, 1);				/* GPIO119 = Disable */
	Port_DisableGpio(126, 1);				/* GPIO126 = Disable */

	Port_SetFunction(19, PORT_FUNCTION_3);	/* O[v19 = Function3 [EQS] */
	Port_DisableGpio(93, 1);				/* GPIO93 = Disable */

	Port_SetFunction(20, PORT_FUNCTION_4);	/* O[v20 = Function4 [CF/IDE] */
	Port_DisableGpio(120, 2);				/* GPIO120`GPIO121 = Disable */

	Port_SetFunction(21, PORT_FUNCTION_2);	/* O[v21 = Function2 [CF/IDE] */

	Port_SetFunction(22, PORT_FUNCTION_4);	/* O[v22 = Function4 [CF/IDE] */
	Port_DisableGpio(32, 3);				/* GPIO32`GPIO34 = Disable */

	Port_SetFunction(24, PORT_FUNCTION_4);	/* O[v24 = Function4 [UART3B] */
	Port_DisableGpio(43, 4);				/* GPIO43`GPIO46(Pin131`Pin134) = Disable */

	Port_SetFunction(25, PORT_FUNCTION_4);	/* O[v25 = Function4 [SDC] */
	Port_DisableGpio(47, 2);				/* GPIO47`GPIO48 = Disable */

	Port_SetFunction(26, PORT_FUNCTION_4);	/* O[v26 = Function4 [SDC] */
	Port_DisableGpio(49, 2);				/* GPIO49`GPIO50 = Disable */

	Port_SetFunction(27, PORT_FUNCTION_4);	/* O[v27 = Function4 [SDC] */
	Port_DisableGpio(51, 6);				/* GPIO51`GPIO56 = Disable */

	Port_SetFunction(29, PORT_FUNCTION_4);	/* O[v29 = Function4 [CF/IDE] */
	Port_DisableGpio(0, 16);				/* GPIO0`GPIO15 = Disable */

	Port_SetFunction(30, PORT_FUNCTION_3);	/* O[v30 = Function3 [CF/IDE] */
	Port_DisableGpio(16, 5);				/* GPIO51`GPIO56 = Disable */

	Port_SetFunction(31, PORT_FUNCTION_4);	/* O[v31 = Function4 [SSP2] */
	Port_DisableGpio(21, 4);				/* GPIO21`GPIO24 = Disable */
}

#ifdef  AG903_SAMPLE_USE_FS
/**
 * @brief		CF I/Fݒ
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
*/
void Board_SetCfInterface(void)
{

	#if (CFG_CF_CLK_MHZ == 100)
    	AG903_SPCPrmSetIdeClk(AG903_SPC_IDECLK_PLL0DIV4); /* IDE 100MHz (PLL0/4) */
    #else
    	AG903_SPCPrmSetIdeClk(AG903_SPC_IDECLK_PLL0DIV3); /* IDE 133MHz (PLL0/3) */
    #endif

	REG_BSC.PMPACR = 0x02;			/* TrueIDE Select */

	FPGA_RegWrite(0x16, 0x01);		/* TrueIDE ڑ */
}

/**
 * @brief		SDJ[h I/Fݒ
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
*/
void Board_SetSdInterface(void)
{
	FPGA_RegWrite(0x15, 0x01);		/* SDJ[hI/F ڑ */
}
#endif/*AG903_SAMPLE_USE_FS*/


/**
 * @brief	AiO͏
 * @param	cvbs_mode [in] p[^
 * @return	AG903_ENONE I
 * @return	-AG903_EINVAL cvbs_modeݒl͈͊O
 * @note	Ȃ
 */
int32_t Board_SetupCvbs(int32_t cvbs_mode)
{
	AG903_SPCPrmPllnParam	pll3;
	AG903_SPCPrmPllaParam	plla;

	if(cvbs_mode >= TEST_CVBS_NUM_SET) {
	    return -AG903_EINVAL;
	}

	pll3.en = false; /* p[_E */
	AG903_SPCPrmSetPll3Ctrl(&pll3);

	pll3.src    = AG903_SPC_PLL3_CLKSRC_XOUT; /* NbN\[X */
	pll3.ns     = 0x04; /* { */
	pll3.ms     = 0x01; /* vXP[ */
	pll3.div    = 0x07; /* |XgXP[ */
	pll3.frange = 0;	/* 샌W (20`40MHz) */
	pll3.en     = true; /* ANeBu */
	AG903_SPCPrmSetPll3Ctrl(&pll3);

	plla.en = false; /* p[_E */
	AG903_SPCPrmSetPllACtrl(&plla);

	switch (cvbs_mode) {
		case TEST_CVBS_NTSC_BT:
		case TEST_CVBS_PAL_BT:
			plla.src = AG903_SPC_PLLA_CLKSRC_OSC; /* NbN\[X */
			plla.ns  = 0x90; /* { */
			plla.ms  = 0x08; /* vXP[ */
			plla.fr  = 0x02; /* |XgXP[1 */
			plla.div = 0x03; /* |XgXP[2 */
			plla.cc  = 0x05; /* PLLA[vtB^ */
			plla.en  = true; /* ANeBu */
			break;
		case TEST_CVBS_NTSC_SQ:
			plla.src = AG903_SPC_PLLA_CLKSRC_OSC; /* NbN\[X */
			plla.ns  = 0xB4; /* { */
			plla.ms  = 0x0B; /* vXP[ */
			plla.fr  = 0x02; /* |XgXP[1 */
			plla.div = 0x03; /* |XgXP[2 */
			plla.cc  = 0x05; /* PLLA[vtB^ */
			plla.en  = true; /* ANeBu */
			break;
		case TEST_CVBS_NTSC_4F:
			plla.src = AG903_SPC_PLLA_CLKSRC_OSC; /* NbN\[X */
			plla.ns  = 0xD2; /* { */
			plla.ms  = 0x0B; /* vXP[ */
			plla.fr  = 0x02; /* |XgXP[1 */
			plla.div = 0x03; /* |XgXP[2 */
			plla.cc  = 0x05; /* PLLA[vtB^ */
			plla.en  = true; /* ANeBu */
			break;
		case TEST_CVBS_PAL_SQ:
			plla.src = AG903_SPC_PLLA_CLKSRC_OSC; /* NbN\[X */
			plla.ns  = 0x76; /* { */
			plla.ms  = 0x08; /* vXP[ */
			plla.fr  = 0x01; /* |XgXP[1 */
			plla.div = 0x03; /* |XgXP[2 */
			plla.cc  = 0x05; /* PLLA[vtB^ */
			plla.en  = true; /* ANeBu */
			break;
		default:
			break;
	}
	AG903_SPCPrmSetPllACtrl(&plla);

	AG903_ViaMgrInit();

	return AG903_ENONE;
}

/**
 * @brief	obNCgHڑI
 * @param	ch [in] obNCgHCH
 * @param	sel [in] 0:펞ON, 1:obNCgH, 2:LED[4:1], 2:LED[4:1](x), 4:GPIO[3:0], 5:̃obNCgHɘA
 * @return	none
 * @note	none
*/
void Board_BacklightSel(uint32_t ch, uint32_t sel)
{
	if(ch > 1 || sel > 5) return;
	FPGA_RegWrite(0x0E + ch, sel);		/* obNCgHڑI */
}

/**
 * @brief	DVI-TXo͐ݒ
 * @param	none
 * @return	none
 * @note	none
*/
void Board_SelectDviTX(void)
{
	Port_SetFunction( 2, PORT_FUNCTION_2);	/* O[v2 = Function2 [VOD] */
	Port_SetFunction( 3, PORT_FUNCTION_2);	/* O[v3 = Function2 [VOD] */
	Port_SetFunction( 4, PORT_FUNCTION_2);	/* O[v4 = Function2 [VOD] */
	Port_SetFunction( 5, PORT_FUNCTION_2);	/* O[v5 = Function2 [VOD] */
	Port_DisableGpio(64, 29);				/* GPIO64`GPIO92 = Disable */

	AG903_SSCPrmDspSetup dsp_setup = {
		.dot0	= AG903_SSC_PINDIR_OUTPUT,
		.dot1	= AG903_SSC_PINDIR_OUTPUT,
		.field0	= AG903_SSC_PINDIR_OUTPUT,
		.field1	= AG903_SSC_PINDIR_OUTPUT,
		.vsync0	= AG903_SSC_PINDIR_OUTPUT,
		.vsync1	= AG903_SSC_PINDIR_OUTPUT,
	};
	AG903_SSCPrmSetDspPinDir(&dsp_setup);

	uint8_t rst;

	FPGA_RegRead(0x04, &rst);		/* Zbg̏Ԃ擾 */

	rst &= ~0x08;
	FPGA_RegWrite(0x04, rst);		/* DVI-TXZbgԂɂ */
    sys_dlytsk(100);

	FPGA_RegWrite(0x07, 0x1);		/* DVOI24bito͂ɐݒ */

	rst |= 0x8;
	FPGA_RegWrite(0x04, rst);		/* DVI-TX̃Zbgԉ */
}


/**
 * @brief	DVI-RXݒ
 * @param	none
 * @return	none
 * @note	none
*/
void Board_SelectDviRX(void)
{
	Port_SetFunction( 2, PORT_FUNCTION_3);	/* O[v2 = Function3 [VID] */
	Port_SetFunction( 3, PORT_FUNCTION_3);	/* O[v3 = Function3 [VID] */
	Port_SetFunction( 4, PORT_FUNCTION_3);	/* O[v4 = Function3 [VID] */
	Port_SetFunction( 5, PORT_FUNCTION_3);	/* O[v5 = Function3 [VID] */
	Port_DisableGpio(64, 29);				/* GPIO64`GPIO92 = Disable */

	AG903_SSCPrmDspSetup dsp_setup = {
		.dot0	= AG903_SSC_PINDIR_INPUT,
		.dot1	= AG903_SSC_PINDIR_INPUT,
		.field0	= AG903_SSC_PINDIR_INPUT,
		.field1	= AG903_SSC_PINDIR_INPUT,
		.vsync0	= AG903_SSC_PINDIR_INPUT,
		.vsync1	= AG903_SSC_PINDIR_INPUT,
	};
	AG903_SSCPrmSetDspPinDir(&dsp_setup);


	uint8_t rst;

	FPGA_RegRead(0x04, &rst);		/* Zbg̏Ԃ擾 */

	rst &= ~0x10;
	FPGA_RegWrite(0x04, rst);		/* DVI-RXp[_EԂɂ */
    sys_dlytsk(100);

	FPGA_RegWrite(0x07, 0x2);		/* DVI͉Hڑ */

	rst |= 0x10;
	FPGA_RegWrite(0x04, rst);		/* DVI-RX̃p[_Eԉ */
}


/**
 * @brief		EQS-RAMڑ
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
*/
void Board_ConnectEqsAndRam(void)
{
	FPGA_RegWrite(0x08, 0x09);					/* FPGARAMڑ				*/
}

/**
 * @brief	UARTI
 * @param	ch [in] UART`l
 * @param	sel [in] ڑ
 * @return	none
 * @note	ch3[40pin`43pin]ch=3Ach3[131pin`134pin]ch=4ݒ肵ĉB
*/
void Board_SelectUartConnection(uint8_t ch, uint8_t sel)
{
	uint8_t addr = 0x09;	/* UART0IWX^ */

	FPGA_RegWrite((addr+ch), sel);
}

/**
 * @brief	obNCg|[gڑI
 * @param	port [in] obNCg|[gi0`1j
 * @param	sel [in] ڑ,IO
 * @return	none
 * @note	ڑIꍇA펞ONAPWM100%ƂȂ܂B
*/
void Board_SelectBlpConnection(uint8_t port, uint8_t sel)
{
	uint8_t addr = 0x0E;	/* obNCg0IWX^ */

	FPGA_RegWrite((addr+port), sel);
}

/**
 * @brief	LEDݒ
 * @param	led [in] LEDݒirbgwj
 * @return	none
 * @note	LEDݒ"0"=_,"1"=łB
*/
void Board_SetLedStatus(uint8_t led)
{
	FPGA_RegWrite(0x05, led);
}

/**
 * @brief	LEDԎ擾
 * @param	led [out] LED
 * @return	none
 * @note	LEDԂ"0"=_,"1"=łB
*/
void Board_GetLedStatus(uint8_t* led)
{
	FPGA_RegRead(0x05, led);
}

/**
 * @brief	I[fBICODECZbg
 * @param	none
 * @return	none
 * @note	none
*/
void Board_ActivateAudioCodec(void)
{
	uint8_t rst;

	FPGA_RegRead(0x04, &rst);
	FPGA_RegWrite(0x04, rst|0x04);	/* Codec Zbg */
}

/**
 * @brief	EthernetI
 * @param	type [in] Ethernet
 * @return	none
 * @note	none
*/
void Board_SelectEthernetType(uint8_t type)
{
	FPGA_RegWrite(0x17, type);
}

/**
 * @brief	USB[hI
 * @param	mode [in] USB[h
 * @return	none
 * @note	none
*/
void Board_SelectUsbMode(uint8_t mode)
{
	if(AG903_USB_MODE_FUNCTION == mode) {
		FPGA_RegWrite(0x18, 0x01);
	}
	else {
		FPGA_RegWrite(0x18, 0x03);
	}
}

/**
 * @brief	SSPʐMݒ
 * @param	ch [in] SSP`l
 * @param	type [in] ݒ
 * @return	none
 * @note	none
*/
void Board_SetSspCommuType(uint8_t ch, uint8_t type)
{
	AG903_SSCPrmSspSetup	  ssp;

	switch(type) {
		case AG903_I2S_MASTER_READ:
			FPGA_RegWrite(0x10, 0x00);		/* SSP}X^- */
			FPGA_RegWrite(0x11+ch, 0x45);	/* RXDMCLKo, ͌ADC_SDOUT1 */
			ssp.mclk_div = 0; 						  /* Ȃ */
			ssp.mclk_dir = AG903_SSC_PINDIR_INPUT;	  /* MCLK  */
			ssp.mode     = AG903_SSC_SSPMODE_HLFDPLX; /* d */
			ssp.dir      = AG903_SSC_PINDIR_INPUT;	  /* TXD=RXD */
			AG903_SSCPrmSetSspSetup(ch, &ssp);
			break;
		case AG903_I2S_MASTER_WRITE:
			FPGA_RegWrite(0x10, 0x00);		/* SSP}X^- */
			FPGA_RegWrite(0x11+ch, 0x41);	/* RXDMCLKo, o͐ADC_SDIN1 */
			ssp.mclk_div = 0; 						  /* Ȃ */
			ssp.mclk_dir = AG903_SSC_PINDIR_INPUT;	  /* MCLK  */
			ssp.mode     = AG903_SSC_SSPMODE_HLFDPLX; /* d */
			ssp.dir      = AG903_SSC_PINDIR_OUTPUT;	  /* TXD=TXD */
			AG903_SSCPrmSetSspSetup(ch, &ssp);
			break;
		default:
			/* LȊO͔Ή */
			break;
	}
	Ssp_SetClkSrc(ch, AG903_SPC_SSP_CLKSRC_MCLK, 0); /* SSPn_MCLK 1 11.2896[MHz] */
}

void Board_SetSpiFlashInterface(void)
{
	/* Pin function Group0 to SSP0 */
	Port_SetFunction( 0, PORT_FUNCTION_4);
	/* 60:SSP0_SCLK */
	/* 61:SSP0_TXD */
	/* 62:SSP0_RXD */
	/* 63:SSP0_FS */
	Port_DisableGpio(60, 4);

	FPGA_RegWrite(0x08, 0x00);  /* 08h:EQS 0:ڑ */
	FPGA_RegWrite(0x11, 0x00);	/* 11h:AUIDO 0:SSP0=RXDڑ/TXDڑ */

	AG903_SSCPrmSspSetup	  ssp = {0};
	ssp.mclk_div = 0; 						  /* MCLKo͈ȊÔƂݒ薳 */
	ssp.mclk_dir = AG903_SSC_PINDIR_OUTPUT;	  /* MCLKdȊÔƂݒ薳 */
	ssp.mode     = AG903_SSC_SSPMODE_FLLDPLX; /* Sd */
	ssp.dir      = AG903_SSC_PINDIR_OUTPUT;	  /* MCLKdȊÔƂݒ薳 */
	AG903_SSCPrmSetSspSetup(0, &ssp);

	Ssp_SetClkSrc(0, AG903_SPC_SSP_CLKSRC_XOUT, 1-1); /* XOUT(24.0[MHz]) / 1 = 24.0[MHz] */
}

void Board_UnsetSpiFlashInterface(void)
{
	/* Repaire EQS */
	Port_SetFunction( 0, PORT_FUNCTION_3);
	Port_DisableGpio(60, 4);
	Board_ConnectEqsAndRam();
}

static void Ssp_SetClkSrc(uint8_t ch, uint8_t src, uint8_t div)
{
	AG903_SPCPrmSspClkSel	clk_src;
	AG903_SPCPrmSspClkDiv	clk_div;

	AG903_SPCPrmGetSspClkSrc(&clk_src);
	AG903_SPCPrmGetSspClkDiv(&clk_div);
	switch(ch) {
		case 0:
			clk_src.ssp0 = src;
			clk_div.ssp0 = div;
			break;
		case 1:
			clk_src.ssp1 = src;
			clk_div.ssp1 = div;
			break;
		case 2:
			clk_src.ssp2 = src;
			clk_div.ssp2 = div;
			break;
		case 3:
			clk_src.ssp3 = src;
			clk_div.ssp3 = div;
			break;
		default:
			break;
	}
	AG903_SPCPrmSetSspClkSrc(&clk_src);
	AG903_SPCPrmSetSspClkDiv(&clk_div);

	return;
}

/**
 * @brief	Audio Codec WX^
 * @param	addr [in] AhX
 * @param	data [in] f[^
 * @return	none
 * @note	none
*/
void Board_WriteAudioCodec(uint8_t addr, uint8_t data)
{
	Bd_I2cWrite(AG903_CODEC_I2C_CH, AG903_CODEC_I2C_SADDR, addr, data);
}

/**
 * @brief	poX݂̐ݒ
 * @param	num [in] poXݔԍ
 * @param	en  [in] nINTn̏
 * @return	none
 * @note	nINTn̏Ԃ"en=false"Hi-Z,"en=true"LowƂȂ܂.
 */
void Board_EnablePbInt(uint8_t num, _Bool en)
{
	uint8_t itn;

	Bd_I2cRead(AG903_FPGA_SADDR, 0x1d, &itn);

	if(en == false){
		itn &= (~(1 << num) & 0x0f);
	}else{
		itn |= ((1 << num) & 0x0f);
	}
	Bd_I2cWrite(AG903_FPGA_I2C_CH, AG903_FPGA_SADDR, 0x1d, itn);
}

/**
 * @brief	^NgXCb`̐ڑ/ڑ̐ݒ
 * @param	en  [in] trueȂڑAfalseȂ疢ڑ
 * @return	none
 * @note	M02̎AUART0_RTSSW4AUART0_CTSSW5̐ڑs.
 */
void Board_ConnectTactSwitchs(_Bool en)
{
	uint8_t val;

	Bd_I2cRead(AG903_FPGA_SADDR, 0x00, &val);

	/* {[ho[W`FbN */
	if(val == AG903_VER_PKG_M02){
		Bd_I2cRead(AG903_FPGA_SADDR, 0x09, &val);
		if(en == false){
			/* ڑ */
			val &= ~AG903_UART0_TACTSW;
		}else{
			/* ڑ */
			val |=  AG903_UART0_TACTSW;
		}
		Bd_I2cWrite(AG903_FPGA_I2C_CH, AG903_FPGA_SADDR, 0x09, val);
	}
}

static void FPGA_RegWrite(uint8_t addr, uint8_t data)
{
	Bd_I2cWrite(AG903_FPGA_I2C_CH, AG903_FPGA_SADDR, addr, data);
	return;
}

static void FPGA_RegRead(uint8_t addr, uint8_t* data)
{
	Bd_I2cRead(AG903_FPGA_SADDR, addr, data);
	return;
}

static void Bd_I2cWrite(uint8_t ch, uint8_t saddr, uint8_t addr, uint8_t data)
{
	AG903_I2CMgrHandle*		handle;
	AG903_I2CMgrWriteParam 	wr;
	int32_t	result;
	uint8_t	val[2];

	do{
		result = AG903_I2CMgrGetHandle(ch, &handle);
		if(AG903_ENONE != result) {
			break;
		}
		result = AG903_I2CMgrSetCallback(handle, (AG903_I2CMgrClbk)Bd_I2cCallback);
		if(AG903_ENONE != result) {
			AG903_I2CMgrReleaseHandle(handle);
			break;
		}
		val[0]=addr;
		val[1]=data;
		wr.addr = saddr;
		wr.buf  = val;
		wr.size = 2;
		wr.stop = true;
		result = AG903_I2CMgrMasterWrite(handle, &wr);
		if(AG903_ENONE != result) {
			AG903_I2CMgrReleaseHandle(handle);
			break;
		}
		Bd_I2cWaitWrite(300);
		AG903_I2CMgrReleaseHandle(handle);
	}while(0);

	return;
}

static void Bd_I2cRead(uint8_t saddr, uint8_t addr, uint8_t* data)
{
	AG903_I2CMgrHandle*		handle;
	AG903_I2CMgrReadParam 	rd;
	AG903_I2CMgrWriteParam 	wr;
	int32_t	result;
	uint8_t	val;

	do{
		result = AG903_I2CMgrGetHandle(AG903_FPGA_I2C_CH, &handle);
		if(AG903_ENONE != result) {
			break;
		}
		result = AG903_I2CMgrSetCallback(handle, (AG903_I2CMgrClbk)Bd_I2cCallback);
		if(AG903_ENONE != result) {
			AG903_I2CMgrReleaseHandle(handle);
			break;
		}
		val=addr;
		wr.addr = saddr;
		wr.buf  = &val;
		wr.size = 1;
		wr.stop = false; /* ReStart */
		result = AG903_I2CMgrMasterWrite(handle, &wr);
		if(AG903_ENONE != result) {
			AG903_I2CMgrReleaseHandle(handle);
			break;
		}
		result = Bd_I2cWaitWrite(300);
		if(AG903_ENONE != result) {
			AG903_I2CMgrReleaseHandle(handle);
			break;
		}
		rd.addr = (saddr|0x01); /* bit0FR/W */
		rd.buf  = data;
		rd.size = 1;
		result  = AG903_I2CMgrMasterRead(handle, &rd);
		if(AG903_ENONE != result) {
			AG903_I2CMgrReleaseHandle(handle);
			break;
		}
		result = Bd_I2cWaitRead(300);
		AG903_I2CMgrReleaseHandle(handle);
	}while(0);

	return;
}

static void Bd_I2cCallback(AG903_I2CMgrHandle* handle, uint32_t event)
{
	if(AG903_I2C_EVENT_WRITE_END & event) {
		I2cWriteEnd=true;
	}
	if(AG903_I2C_EVENT_READ_END & event) {
		I2cReadEnd=true;
	}
	if( (AG903_I2C_EVENT_LOSES_ARBITRATION|AG903_I2C_EVENT_SEQUENCE_ERR|AG903_I2C_EVENT_WRITE_ERR|
		AG903_I2C_EVENT_READ_ERR) & event) {
		/* Ȃ */
	}
	return;
}

static int32_t Bd_I2cWaitWrite(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == I2cWriteEnd) {
			I2cWriteEnd = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

static int32_t Bd_I2cWaitRead(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == I2cReadEnd) {
			I2cReadEnd = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

