/*
 * @history		2019_12_27  [SDK3.0] ^XNTA_FPUtŋNĂȂsC (uC3) (#2698)
 */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/

/*****************************************************************************/
/*     include file                                                          */
/*****************************************************************************/
#include "kernel.h"
#include "uhs_configtop.h"
#include "hid/usb_hid_class_api.h"
#include "hid/usb_hid_api.h"
#include <stdint.h>
#include "vram/vrammgr.h"
#include "usb_sample.h"
#include "sample_util.h"
#include "sample_app_hid.h"


/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/
/* HIDfoCX^Cv */
typedef enum {
	HID_DEVICE_TYPE_MOUSE,									/* }EX		*/
	HID_DEVICE_TYPE_MOUSE12,								/* }EX(12bit)*/
	HID_DEVICE_TYPE_KEYBOARD,								/* L[{[h	*/
} HID_DEVICE_TYPE;

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/
/* ^XN */
typedef struct HidTaskInfo {
	ID					tskid;								/* ^XNID							*/
	ID					mbxid;								/* [{bNXID					*/
	uhs_ubit8_t*		pNotifyBuff;						/* Notifypobt@AhX			*/
	PHID_DESC_INFO		pHidDescInfo;						/* HIDfBXNv^			*/
	PHID_DESC_INFO		pReportDescInfo;					/* |[gfBXNv^		*/
	HID_DEVICE_TYPE		deviceType;							/* HIDfoCX^Cv				*/
	uhs_ubit8_t*		pLastReport;						/* Õ|[g(L[{[ĥ)	*/
	void				*pContext;							/* ڑĂȂNULL			*/
} HID_TASK_INFO;

/* ڑ^ؒfbZ[W */
typedef struct HidConnMsgPkt {
	uhs_ubit32_t		msg;								/* bZ[We					*/
	void*				pContext;							/* ʒmfoCX̃ReLXg		*/
} HID_CONN_MSG_PKT;

/* AvP[V^XNbZ[W */
typedef struct HidAppMsgPkt {
	uhs_ubit32_t		msg;								/* bZ[We					*/
	HID_NOTIFY_INFO		notify;								/* ʒm							*/
	void*				pContext;							/* ʒmfoCX̃ReLXg		*/
} HID_APP_MSG_PKT;

/*****************************************************************************/
/*     define                                                                */
/*****************************************************************************/
/* obt@TCY */
#define NOTIFY_BUFF_SIZE			(64)

/* HIDfBXNv^TCY */
#define HID_DESC_SIZE				(9)

/* |[gfBXNv^pobt@TCY */
#define REPORT_DESC_SIZE			(200)

/* L[R[hliModifier bytej */
#define HID_LEFT_CTRL				(0x01)
#define HID_LEFT_SHIFT				(0x02)
#define HID_LEFT_ALT				(0x04)
#define HID_LEFT_GUI				(0x08)
#define HID_RIGHT_CTRL				(0x10)
#define HID_RIGHT_SHIFT				(0x20)
#define HID_RIGHT_ALT				(0x40)
#define HID_RIGHT_GUI				(0x80)

/* L[R[hi[z̃TCY */
#define KEY_CODE_ARR_SIZE			(6)

/* }EX̃|[gTCY */
#define MOUSE_REPORT_SIZE			(4)

/* L[{[h̃|[gTCY */
#define KEYBOARD_REPORT_SIZE		(8)


/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/
/* Notifypobt@ */
static uhs_ubit8_t	g_notifyBuff[USBH_MAX_CLS_HID_NUM][NOTIFY_BUFF_SIZE];

/* HIDfBXNv^ */
static HID_DESC_INFO	g_hidDescInfo[USBH_MAX_CLS_HID_NUM];

/* |[gfBXNv^ */
static HID_DESC_INFO	g_reportDescInfo[USBH_MAX_CLS_HID_NUM];

/* O񃌃|[g */
static uhs_ubit8_t		g_lastReport[USBH_MAX_CLS_HID_NUM][KEYBOARD_REPORT_SIZE];

/* ^XNe[u */
static HID_TASK_INFO g_HidTaskInfoTbl[USBH_MAX_CLS_HID_NUM];

/* ڑؒf^XNp[{bNXID */
ER_ID				g_mbxid_hid_conn;

/* ڑؒf^XNp^XNID */
ER_ID				g_tskid_hid_conn;

/* L[R[he[u(VtgȂ) */
static char		g_keyTable[] = {
/*	 		 0    1    2    3    4    5    6    7    8    9    a    b    c    d    e    f */
/* 00 */	 0 ,  0 ,  0 ,  0 , 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l',
/* 10 */	'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2',
/* 20 */	'3', '4', '5', '6', '7', '8', '9', '0',  0 ,  0 ,  0 ,'\t', ' ', '-', '^', '@',
/* 30 */	'[',  0 , ']', ';', ':',  0 , ',', '.', '/',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 40 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 50 */	 0 ,  0 ,  0 ,  0 , '/', '*', '-', '+',  0 , '1', '2', '3', '4', '5', '6', '7',
/* 60 */	'8', '9', '0', '.',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 70 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 80 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,'\\',  0 ,'\\',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 90 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* a0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* b0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* c0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* d0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* e0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* f0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
};

/* L[R[he[u(Vtg) */
static char		g_keyTableShift[] = {
/*	 		 0    1    2    3    4    5    6    7    8    9    a    b    c    d    e    f */
/* 00 */	 0 ,  0 ,  0 ,  0 , 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L',
/* 10 */	'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '!','\"',
/* 20 */	'#', '$', '%', '&','\'', '(', ')',  0 ,  0 ,  0 ,  0 ,  0 , ' ', '=', '~', '`',
/* 30 */	'{',  0 , '}', '+', '*',  0 , '<', '>','\?',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 40 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 50 */	 0 ,  0 ,  0 ,  0 , '/', '*', '-', '+',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 60 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 70 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 80 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 , '_',  0 , '|',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* 90 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* a0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* b0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* c0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* d0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* e0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
/* f0 */	 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
};

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern	int32_t AG903_VRAMMgrCreateMpl(AG903_VRAMMgrMplPrm* mplprm);
extern	int32_t AG903_VRAMMgrDeleteMpl(int32_t mplid);
extern	void* AG903_VRAMMgrMalloc(int32_t mplid, uint32_t blksz);
extern	int32_t AG903_VRAMMgrFree(int32_t mplid, void* blk);

/*****************************************************************************/
/*     function prototype                                                    */
/*****************************************************************************/
static void hid_notifyCallback(PHID_NOTIFY_INFO pNotifyInfo, uhs_status_t RetVal);
static int hid_registTaskInfo(void* pContext);
static int hid_unregistTaskInfo(void* pContext);
static ID hid_getMbxId(void* pContext);
static uhs_ubit8_t* hid_getNotifyBuff(void* pContext);
static PHID_DESC_INFO hid_getHidDescInfo(void* pContext);
static PHID_DESC_INFO hid_getReportDescInfo(void* pContext);
static void hid_setDeviceType(void* pContext, HID_DEVICE_TYPE type);
static uhs_ubit8_t* hid_getLastReport(void* pContext);
static int hid_getDeviceNum(void* pContext);
static void hid_conn_task(void* context);
static void hid_app_task(void* context);
static uhs_status_t hid_attachDeviceInit(void* pContext);
static void hid_procMouseEvent(uhs_ubit8_t* pReport, uhs_ubit32_t size , HID_DEVICE_TYPE mouse_type );
static void hid_procKeyboardEvent(uhs_ubit8_t* pLastReport, uhs_ubit8_t* pReport);
static void hid_printMouseEvent(uhs_ubit8_t* pReport , HID_DEVICE_TYPE mouse_type );
static void hid_printKeyName(uhs_ubit8_t* pReport, uhs_ubit8_t* pKeyCode);
static char hid_getOnKeyCode(uhs_ubit8_t* pLastReport, uhs_ubit8_t* pNewReport, uhs_ubit8_t* pKeyCode);
static int hid_isShiftOn(uhs_ubit8_t *pReport);
static int hid_convert8bitToSignedValue(unsigned char val);

static unsigned char hid_dstMouseSize( PHID_DESC_INFO pReportDescInfo);
static int hid_convert12bitToSignedValue(unsigned short val);


/******************************************************************************
   FunctionF  hid_appinit
   ArgumentF  Ȃ
   Return  F  Ȃ
   Summary F  HIDs܂
   Caution F  Ȃ
******************************************************************************/
void hid_appinit(void)
{
	T_CMBX					cmbx;							/* [{bNXp[^		*/
	T_CTSK					ctsk;							/* ^XNp[^				*/
	uhs_ubit8_t				majorVersion, minorVersion;		/* o[W						*/
	uhs_status_t			retval;
	int						i;


	/*----------------*/
	/* o[W擾 */
	/*----------------*/
	retval = Usbh_Hid_GetVersion(&majorVersion, &minorVersion);
	if(retval == USBHID_API_SUCCESS) {
		SAMPLE_PRINT("HID Driver version : ");
		SAMPLE_PRINT_BYTE_HEX(majorVersion);
		SAMPLE_PRINT(".");
		SAMPLE_PRINT_BYTE_HEX(minorVersion);
		SAMPLE_PRINT("\r\n");
	}
	
	/*--------------------------*/
	/* ^XNe[u */
	/*--------------------------*/
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		g_HidTaskInfoTbl[i].tskid			= 0;
		g_HidTaskInfoTbl[i].mbxid			= 0;
		g_HidTaskInfoTbl[i].pNotifyBuff		= g_notifyBuff[i];
		g_HidTaskInfoTbl[i].pHidDescInfo	= &g_hidDescInfo[i];
		g_HidTaskInfoTbl[i].pReportDescInfo	= &g_reportDescInfo[i];
		g_HidTaskInfoTbl[i].deviceType		= HID_DEVICE_TYPE_MOUSE;
		g_HidTaskInfoTbl[i].pLastReport		= g_lastReport[i];
		g_HidTaskInfoTbl[i].pContext		= NULL;
	}
	
	/*--------------------*/
	/* [{bNX */
	/*--------------------*/
	/* p[^ݒ */
    cmbx.mbxatr		= TA_TFIFO | TA_MFIFO;
    cmbx.maxmpri	= 1;
    cmbx.mprihd		= NULL;

	/* ڑؒf^XNp[{bNX */
	g_mbxid_hid_conn = acre_mbx(&cmbx);
	if(g_mbxid_hid_conn < 0) {
		/* G[ */
		return;
	}

	/* AvP[V^XNp[{bNX~Q */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		g_HidTaskInfoTbl[i].mbxid = acre_mbx(&cmbx);
		if(g_HidTaskInfoTbl[i].mbxid < 0) {
			/* G[ */
			return;
		}
	}
	
	/*------------------------------------*/
	/* NXfBXNv^pobt@擾 */
	/*------------------------------------*/
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		g_HidTaskInfoTbl[i].pHidDescInfo->pu8Buff    = AG903_VRAMMgrMalloc(g_mplid_app, HID_DESC_SIZE);
		g_HidTaskInfoTbl[i].pReportDescInfo->pu8Buff = AG903_VRAMMgrMalloc(g_mplid_app, REPORT_DESC_SIZE);
	}

	/*----------------------*/
	/* ڑ^ؒf^XN */
	/*----------------------*/
	/* p[^ݒ */
	ctsk.tskatr		= TA_HLNG | TA_ACT | TA_FPU;
	ctsk.exinf		= (void *)NULL;							/* TASKÑp[^()			*/
	ctsk.task		= (FP)hid_conn_task;					/* TASK̋NAhX					*/
	ctsk.itskpri	= (PRI)TSK_PRI_SAMPLE;					/* TASK̗Dx							*/
	ctsk.stksz		= (INT)TSK_STACK_SIZE_SAMPLE;			/* TASK̃X^bNSIZE					*/
	ctsk.stk		= NULL;									/* TASK̃X^bNAhX=NULL()	*/
	
	/* ^XN */
	g_tskid_hid_conn = acre_tsk(&ctsk);
	if(g_tskid_hid_conn < 0) {
		/* G[ */
		return;
	}

	/*----------------------------*/
	/* AvP[V^XN */
	/*----------------------------*/
	/* p[^ݒ */
	ctsk.task		= (FP)hid_app_task;						/* TASK̋NAhX					*/

	/* ^XN */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		ctsk.exinf = (void *)&g_HidTaskInfoTbl[i];			/* TASKÑp[^(e[u)		*/
		g_HidTaskInfoTbl[i].tskid = acre_tsk(&ctsk);
		if(g_HidTaskInfoTbl[i].tskid < 0) {
			/* G[ */
			return;
		}
	}
}

/******************************************************************************
   FunctionF  hid_append
   ArgumentF  Ȃ
   Return  F  Ȃ
   Summary F  HIDIs܂
   Caution F  Ȃ
******************************************************************************/
void hid_append(void)
{
	int						i;

	del_mbx(g_mbxid_hid_conn);
	
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		del_mbx(g_HidTaskInfoTbl[i].mbxid);
	}

	ter_tsk(g_tskid_hid_conn);
	del_tsk(g_tskid_hid_conn);
	
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		ter_tsk(g_HidTaskInfoTbl[i].tskid);
		del_tsk(g_HidTaskInfoTbl[i].tskid);
	}

	return;
}

/******************************************************************************
   FunctionF  hid_appstop
   ArgumentF  Ȃ
   Return  F  AG903_ENONE	 I
           F  -AG903_EFAULT   ُI
   Summary F  HID̓]~s܂
   Caution F  Ȃ
******************************************************************************/
int32_t hid_appstop(void)
{
	int32_t			retval=AG903_ENONE;
	uint32_t		loop;
	uhs_status_t	ret;
	
	for( loop=0 ; loop<USBH_MAX_CLS_HID_NUM; loop++ ){
		if( NULL != g_HidTaskInfoTbl[loop].pContext ) {
			ret = Usbh_Hid_StopIntIN(g_HidTaskInfoTbl[loop].pContext);
			if( (USBHID_API_SUCCESS != ret) &&
				(USBHID_API_ALREADY_STOP_INTIN != ret) ) {
				retval=-AG903_EFAULT;
			}
		}
	}
	
	return retval;
}

/******************************************************************************
   FunctionF  hid_apprestart
   ArgumentF  Ȃ
   Return  F  AG903_ENONE	 I
           F  -AG903_EFAULT   ُI
   Summary F  HID̓]ĊJs܂
   Caution F  Ȃ
******************************************************************************/
int32_t hid_apprestart(void)
{
	HID_IDLE		hidIdle;
	int32_t			retval=AG903_ENONE;
	uint32_t		loop;
	uhs_status_t	ret;
	
	for( loop=0 ; loop<USBH_MAX_CLS_HID_NUM; loop++ ){
		if( NULL != g_HidTaskInfoTbl[loop].pContext ) {
			ret = Usbh_Hid_RestartIntIN(g_HidTaskInfoTbl[loop].pContext);
			if( (USBHID_API_SUCCESS != ret) &&
				(USBHID_API_ALREADY_START_INTIN != ret) ) {
				retval=-AG903_EFAULT;
			}
			
			hidIdle.u8Id		= 0;
			hidIdle.u8Duration	= 0;
			ret = Usbh_Hid_SetIdle(g_HidTaskInfoTbl[loop].pContext , &hidIdle);
			if(USBHID_API_SUCCESS != ret) {
				retval=-AG903_EFAULT;
			}
			
		}
	}
	
	return retval;
}

/******************************************************************************
   FunctionF  hid_callback
   ArgumentF  callback_id : R[obN
               pContext    : R[obNcontext
   Return  F  Ȃ
   Summary F  HIDNXhCo̐ڑ^ؒfR[obN
   Caution F  Ȃ
******************************************************************************/
void hid_callback(int callback_id, void* pContext)
{
	HID_CONN_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/
	uhs_status_t			retval;
	ER						ercd;
	
	
	/* bZ[Wobt@擾 */
	pk_msg = AG903_VRAMMgrMalloc(g_mplid_app, sizeof(HID_CONN_MSG_PKT));
	/* bZ[We */
	pk_msg->msg = (uhs_ubit32_t)callback_id;
	/* ReLXg */
	pk_msg->pContext = pContext;
	
	switch(callback_id){
		/*--------*/
		/* ڑ   */
		/*--------*/
		case CBID_HID_DEVATTACH:

//			SAMPLE_PRINT("HID device attached\r\n");

			/* ReLXgo^ */
			hid_registTaskInfo(pContext);

			/* R[obNo^ */
			retval = Usbh_Hid_RegistCallBack(pContext, hid_notifyCallback);
			if(retval != USBHID_API_SUCCESS){
				/* obt@ */
				AG903_VRAMMgrFree(g_mplid_app, pk_msg);
				return;
			}

			/* bZ[WM */
			ercd = snd_mbx(g_mbxid_hid_conn, (T_MSG *)pk_msg);
			if(ercd != E_OK) {
				/* obt@ */
				AG903_VRAMMgrFree(g_mplid_app, pk_msg);
				return;
			}
			break;
		
		/*--------*/
		/* ؒf   */
		/*--------*/
		case CBID_HID_DEVDETACH:

//			SAMPLE_PRINT("HID device detached\r\n");
			
			/* ReLXg폜 */
			hid_unregistTaskInfo(pContext);

			/* bZ[WM */
			ercd = snd_mbx(g_mbxid_hid_conn, (T_MSG *)pk_msg);
			if(ercd != E_OK) {
				/* obt@ */
				AG903_VRAMMgrFree(g_mplid_app, pk_msg);
				return;
			}
			break;
		
		/*--------*/
		/* ̑ */
		/*--------*/
		default:

//			SAMPLE_PRINT("HID callback other\r\n");
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			break;
	}
}

/******************************************************************************
   FunctionF  hid_notifyCallback
   ArgumentF  pNotifyInfo : ʒm
               RetVal      : 
   Return  F  Ȃ
   Summary F  HIDNXhCoInterrupt]ReportMR[obN
   Caution F  Ȃ
******************************************************************************/
static void hid_notifyCallback(PHID_NOTIFY_INFO pNotifyInfo, uhs_status_t RetVal)
{
	HID_APP_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/
	uhs_ubit8_t*			pBuff;							/* Notifypobt@AhX			*/
	ER						ercd;
	uhs_ubit32_t			i;
	

	/* ʊmF */
	if(RetVal != USBHID_API_SUCCESS) {
		return;
	}

	/* bZ[Wobt@擾 */
	pk_msg = AG903_VRAMMgrMalloc(g_mplid_app, sizeof(HID_APP_MSG_PKT));
	/* bZ[We */
	sample_memcpy((void *)&pk_msg->notify, (void *)pNotifyInfo, sizeof(HID_NOTIFY_INFO));
	/* ReLXg */
	pk_msg->pContext = pNotifyInfo->pContext;

	/* Interrupt f[^ */
	if(pNotifyInfo->u32Length > 0) {
		
		/* obt@擾 */
		pBuff = hid_getNotifyBuff(pNotifyInfo->pContext);
		if(pBuff == NULL) {
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			return;
		}
		
		sample_memset(pBuff, 0, pNotifyInfo->u32Length);
		
		/* f[^ */
		for(i = 0; i < pNotifyInfo->u32Length; i++) {
			pBuff[i] = pNotifyInfo->pu8Buff[i];
		};
		/* obt@u */
		pk_msg->notify.pu8Buff = pBuff;
		pk_msg->notify.u32Length = pNotifyInfo->u32Length;
	}

	/* bZ[WM */
	ercd = snd_mbx(hid_getMbxId(pNotifyInfo->pContext), (T_MSG *)pk_msg);
	if(ercd != E_OK) {
		/* obt@ */
		AG903_VRAMMgrFree(g_mplid_app, pk_msg);
	}
}

/******************************************************************************
   FunctionF  hid_registTaskInfo
   ArgumentF  pContext     : R[obNcontext
   Return  F  SAMPLE_TRUE  : 
               SAMPLE_FALSE : s
   Summary F  ^XNɃReLXgo^܂
   Caution F  Ȃ
******************************************************************************/
static int hid_registTaskInfo(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		/* o^ */
		if(g_HidTaskInfoTbl[i].pContext == NULL) {
			/* ReLXgo^ */
			g_HidTaskInfoTbl[i].pContext = pContext;
			return SAMPLE_TRUE;
		}
	}
	/* 󂫂Ȃ */
	return SAMPLE_FALSE;
}

/******************************************************************************
   FunctionF  hid_unregistTaskInfo
   ArgumentF  pContext     : R[obNcontext
   Return  F  SAMPLE_TRUE  : 
               SAMPLE_FALSE : s
   Summary F  ^XN񂩂ReLXg폜܂
   Caution F  Ȃ
******************************************************************************/
static int hid_unregistTaskInfo(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		/* ReLXgv */
		if(g_HidTaskInfoTbl[i].pContext == pContext) {
			/* ReLXg폜 */
			g_HidTaskInfoTbl[i].pContext = NULL;
			return SAMPLE_TRUE;
		}
	}
	/* ReLXgȂ */
	return SAMPLE_FALSE;
}

/******************************************************************************
   FunctionF  hid_getMbxId
   ArgumentF  pContext    : R[obNcontext
   Return  F  [{bNXID
   Summary F  o^ĂReLXgɕRtꂽ[{bNXID擾܂
   Caution F  Ȃ
******************************************************************************/
static ID hid_getMbxId(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		/* ReLXgv */
		if(g_HidTaskInfoTbl[i].pContext == pContext) {
			/* [{bNXIDԂ */
			return g_HidTaskInfoTbl[i].mbxid;
		}
	}
	
	/* G[ */
	return 0;
}

/******************************************************************************
   FunctionF  hid_getNotifyBuff
   ArgumentF  pContext    : R[obNcontext
   Return  F  Notifypobt@
   Summary F  o^ĂReLXgɕRtꂽNotifypobt@擾܂
   Caution F  Ȃ
******************************************************************************/
static uhs_ubit8_t* hid_getNotifyBuff(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		/* ReLXgv */
		if(g_HidTaskInfoTbl[i].pContext == pContext) {
			/* Notifypobt@Ԃ */
			return g_HidTaskInfoTbl[i].pNotifyBuff;
		}
	}
	
	/* G[ */
	return NULL;
}

/******************************************************************************
   FunctionF  hid_getHidDescInfo
   ArgumentF  pContext    : R[obNcontext
   Return  F  HIDfBXNv^AhX
   Summary F  o^ĂReLXgɕRtꂽHIDfBXNv^擾
               ܂
   Caution F  Ȃ
******************************************************************************/
static PHID_DESC_INFO hid_getHidDescInfo(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		/* ReLXgv */
		if(g_HidTaskInfoTbl[i].pContext == pContext) {
			/* HIDfBXNv^AhXԂ */
			return g_HidTaskInfoTbl[i].pHidDescInfo;
		}
	}
	
	/* G[ */
	return NULL;
}

/******************************************************************************
   FunctionF  hid_getReportDescInfo
   ArgumentF  pContext    : R[obNcontext
   Return  F  |[gfBXNv^AhX
   Summary F  o^ĂReLXgɕRtꂽ|[gfBXNv^
               擾܂
   Caution F  Ȃ
******************************************************************************/
static PHID_DESC_INFO hid_getReportDescInfo(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		/* ReLXgv */
		if(g_HidTaskInfoTbl[i].pContext == pContext) {
			/* HIDfBXNv^AhXԂ */
			return g_HidTaskInfoTbl[i].pReportDescInfo;
		}
	}
	
	/* G[ */
	return NULL;
}

/******************************************************************************
   FunctionF  hid_setDeviceType
   ArgumentF  pContext    : R[obNcontext
               type        : HIDfoCX^Cv
   Return  F  Ȃ
   Summary F  o^ĂReLXgHIDfoCX^Cvݒ肵܂
   Caution F  Ȃ
******************************************************************************/
static void hid_setDeviceType(void* pContext, HID_DEVICE_TYPE type)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		/* ReLXgv */
		if(g_HidTaskInfoTbl[i].pContext == pContext) {
			/* HIDfoCX^Cvݒ */
			g_HidTaskInfoTbl[i].deviceType = type;
		}
	}
}

/******************************************************************************
   FunctionF  hid_getLastReport
   ArgumentF  pContext    : R[obNcontext
   Return  F  O񃌃|[gi[pobt@
   Summary F  o^ĂReLXgɕRtꂽO񃌃|[gi[pobt@
               擾܂
   Caution F  Ȃ
******************************************************************************/
static uhs_ubit8_t* hid_getLastReport(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		/* ReLXgv */
		if(g_HidTaskInfoTbl[i].pContext == pContext) {
			/* O񃌃|[gi[pobt@Ԃ */
			return g_HidTaskInfoTbl[i].pLastReport;
		}
	}
	
	/* G[ */
	return NULL;
}

/******************************************************************************
   FunctionF  hid_getDeviceNum			 
   ArgumentF  pContext    : R[obNcontext
   Return  F  foCXԍ
   Summary F  o^ĂReLXgɕRtꂽfoCXԍ擾܂B
               foCXԍ0`1B
   Caution F  Ȃ
******************************************************************************/
static int hid_getDeviceNum(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_HID_NUM; i++) {
		/* ReLXgv */
		if(g_HidTaskInfoTbl[i].pContext == pContext) {
			/* e[u̓YfoCXԍƂ */
			return i;
		}
	}
	
	/* G[ */
	return -1;
}

/******************************************************************************
   FunctionF  hid_conn_task
   ArgumentF  context     : NULL
   Return  F  Ȃ
   Summary F  HIDڑ^ؒfm^XN
   Caution F  HIDfoCX
******************************************************************************/
static void hid_conn_task(void* context)
{
	HID_CONN_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/
	uhs_ubit32_t			msg;							/* bZ[We					*/
	void*					pContext;						/* ReLXg						*/

	((void)context);

	while(1) {
		/* ڑ^ؒfbZ[W҂ */
		rcv_mbx(g_mbxid_hid_conn, (T_MSG **)&pk_msg);
			
		/* ڑ^ꂽfoCX̃ReLXg擾 */
		pContext = pk_msg->pContext;
		/* 擾s */
		if(pContext == NULL) {
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			continue;
		}

		SAMPLE_PRINT("  context : 0x");
		SAMPLE_PRINT_LONG_HEX((unsigned long)pContext);
		SAMPLE_PRINT("\r\n");

		/* bZ[Weۑ */
		msg = pk_msg->msg;

		/* obt@ */
		AG903_VRAMMgrFree(g_mplid_app, pk_msg);
		
		/*------*/
		/* ڑ */
		/*------*/
		if(msg == CBID_HID_DEVATTACH) {

			/* NGXgs */
			hid_attachDeviceInit(pContext);
		}
		
		/*------*/
		/* ؒf */
		/*------*/
		else {
			/* Ȃ */
		}
	}
}

/******************************************************************************
   FunctionF  hid_app_task
   ArgumentF  context     : ^XNNp[^(^XN)
   Return  F  Ȃ
   Summary F  HIDAvP[V^XN
   Caution F  foCXPʂŎgp
******************************************************************************/
static void hid_app_task(void* context)
{
	HID_TASK_INFO*			pHidTaskInfo;					/* ^XN						*/
	HID_APP_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/

	((void)context);

	/* ^XN擾 */
	pHidTaskInfo = (HID_TASK_INFO *)context;

	while(1) {
		/*--------------------*/
		/* ʒmbZ[W҂ */
		/*--------------------*/
		rcv_mbx(pHidTaskInfo->mbxid, (T_MSG **)&pk_msg);
		
		SAMPLE_PRINT("  Device No.[");
		SAMPLE_PRINT_NUM(hid_getDeviceNum(pHidTaskInfo->pContext));
		SAMPLE_PRINT("]");
		
		/* HIDfoCX^Cv */
		switch(pHidTaskInfo->deviceType) {
			
			/*--------*/
			/* }EX */
			/*--------*/
			case (HID_DEVICE_TYPE_MOUSE):
			case (HID_DEVICE_TYPE_MOUSE12):
				/* }EXCxg */
				hid_procMouseEvent(pk_msg->notify.pu8Buff, pk_msg->notify.u32Length , pHidTaskInfo->deviceType);
				break;
			
			/*------------*/
			/* L[{[h */
			/*------------*/
			case (HID_DEVICE_TYPE_KEYBOARD):
				/* L[{[hCxg */
				hid_procKeyboardEvent(pHidTaskInfo->pLastReport, pk_msg->notify.pu8Buff);
				break;
			
			/* ̑ */
			default:
				SAMPLE_PRINT("\r\n");
				/* Do Nothing */
				break;
		}
		/* obt@ */
		AG903_VRAMMgrFree(g_mplid_app, pk_msg);
	}
}

/******************************************************************************
   FunctionF  hid_attachDeviceInit
   ArgumentF  pContext    : ڑcontext
   Return  F  Ȃ
   Summary F  HIDfoCXڑ̃NXNGXgsAHIDfoCX^Cv
   Caution F  擾obt@́AؒfɉB
******************************************************************************/
static uhs_status_t hid_attachDeviceInit(void* pContext)
{
	HID_IDLE				hidIdle;						/* |[gpx					*/
	PHID_DESC_INFO			pHidDescInfo;					/* HIDfBXNv^AhX	*/
	PHID_DESC_INFO			pReportDescInfo;				/* |[gfBXNv^AhX*/
	uhs_ubit8_t*			pLastReport;					/* O񃌃|[gobt@AhX		*/
	uhs_status_t			retval;


	/*----------------------*/
	/* NXNGXgs */
	/*----------------------*/
	/* SetIdle */
	hidIdle.u8Id		= 0;
	hidIdle.u8Duration	= 0;
	retval = Usbh_Hid_SetIdle(pContext, &hidIdle);
	if(retval != USBHID_API_SUCCESS){
		/* Do Nothing */
	}

	/* HIDfBXNv^AhX擾 */
	pHidDescInfo = hid_getHidDescInfo(pContext);
	/* ؒf͎擾oȂ߁AI */
	if(pHidDescInfo == NULL) {
		return -1;
	}
	pHidDescInfo->u16Length = HID_DESC_SIZE;
	pHidDescInfo->u16Length = HID_DESC_SIZE;
	/* HIDfBXNv^擾 */
	retval = Usbh_Hid_GetHIDDescriptor(pContext, pHidDescInfo);
	if(retval != USBHID_API_SUCCESS){
		return retval;
	}

	/* |[gfBXNv^AhX擾 */
	pReportDescInfo = hid_getReportDescInfo(pContext);
	/* ؒf͎擾oȂ߁AI */
	if(pReportDescInfo == NULL) {
		return -1;
	}
	pHidDescInfo->u16Length = HID_DESC_SIZE;
	pReportDescInfo->u16Length = (pHidDescInfo->pu8Buff[7] + (pHidDescInfo->pu8Buff[8] << 8));
	/* |[gfBXNv^擾 */
	retval = Usbh_Hid_GetReportDescriptor(pContext, pReportDescInfo);
	if(retval != USBHID_API_SUCCESS){
		return retval;
	}
	
	/*-----------------------*/
	/* HIDfoCX^Cv */
	/*-----------------------*/
	/* }EX */
	if((pReportDescInfo->pu8Buff[2] == 0x09) && 
	   (pReportDescInfo->pu8Buff[3] == 0x02)) {
		hid_setDeviceType(pContext, HID_DEVICE_TYPE_MOUSE);
		/* }EX̍W̃TCY𔻕 */
		if(hid_dstMouseSize( pReportDescInfo) == 2){
			hid_setDeviceType(pContext, HID_DEVICE_TYPE_MOUSE12);
			SAMPLE_PRINT("  -- mouse12\r\n");
		}else{
			SAMPLE_PRINT("  -- mouse8\r\n");
		}
	}
	/* L[{[h */
	else if((pReportDescInfo->pu8Buff[2] == 0x09) && 
	        (pReportDescInfo->pu8Buff[3] == 0x06)) {
		hid_setDeviceType(pContext, HID_DEVICE_TYPE_KEYBOARD);
		SAMPLE_PRINT("  -- keyboard\r\n");

		/* O񃌃|[gNA */
		pLastReport = hid_getLastReport(pContext);
		sample_memset(pLastReport, 0, KEYBOARD_REPORT_SIZE);
	}
	/* LȊOi{P[X͂Ȃj */
	else {
		SAMPLE_PRINT("  -- other device : ");
		SAMPLE_PRINT("0x");
		SAMPLE_PRINT_BYTE_HEX(pReportDescInfo->pu8Buff[2]);
		SAMPLE_PRINT(", 0x");
		SAMPLE_PRINT_BYTE_HEX(pReportDescInfo->pu8Buff[3]);
		SAMPLE_PRINT("\r\n");
	}
	return retval;
}

/******************************************************************************
   FunctionF  hid_procMouseEvent
   ArgumentF  pReport     : ʒmꂽ|[g
               size        : ʒmꂽ|[g̃TCY
               mouse_type  : }EX
   Return  F  Ȃ
   Summary F  }EXCxgs܂B
   Caution F  Ȃ
******************************************************************************/
static void hid_procMouseEvent(uhs_ubit8_t* pReport, uhs_ubit32_t size , HID_DEVICE_TYPE mouse_type)
{
	uhs_ubit32_t			i;


	/* |[gHEXlŏo */
	SAMPLE_PRINT("  Report ");
	for(i = 0; i < size; i++) {
		SAMPLE_PRINT_BYTE_HEX(pReport[i]);
		SAMPLE_PRINT(" ");
	}

	/* Cxge\ */
	hid_printMouseEvent(pReport , mouse_type);
		
	SAMPLE_PRINT("\r\n");
}

/******************************************************************************
   FunctionF  hid_procKeyboardEvent
   ArgumentF  pReport     : ʒmꂽ|[g
   Return  F  Ȃ
   Summary F  L[{[hCxgs܂B
   Caution F  Ȃ
******************************************************************************/
static void hid_procKeyboardEvent(uhs_ubit8_t* pLastReport, uhs_ubit8_t* pReport)
{
	uhs_ubit8_t				onKeyCode[KEY_CODE_ARR_SIZE];
	int						i;


	/* |[gHEXlŏo */
	SAMPLE_PRINT("  Report ");
	for(i = 0; i < KEYBOARD_REPORT_SIZE; i++) {
		SAMPLE_PRINT_BYTE_HEX(pReport[i]);
		SAMPLE_PRINT(" ");
	}
	
	/* ꂽL[R[h擾 */
	hid_getOnKeyCode(pLastReport, pReport, onKeyCode);
	
	/* ꂽL[\ */
	hid_printKeyName(pReport, onKeyCode);
	
	SAMPLE_PRINT("\r\n");
	
	/* |[gۑ */
	sample_memcpy(pLastReport, pReport, KEYBOARD_REPORT_SIZE);
}

/******************************************************************************
   FunctionF  hid_printMouseEvent
   ArgumentF  pReport     : ʒmꂽ|[g
           F  mouse_type  : }EX̎
   Return  F  SAMPLE_TRUE  : VtgL[ON
               SAMPLE_FALSE : VtgL[OFF
   Summary F  }EX\܂B
   Caution F  Ȃ
******************************************************************************/
static void hid_printMouseEvent(uhs_ubit8_t* pReport , HID_DEVICE_TYPE mouse_type )
{
	int					report;							/* |[gl						*/
	unsigned short		coordinates;

	SAMPLE_PRINT(" : ");
	
	SAMPLE_PRINT("Buttons[0x");
	SAMPLE_PRINT_BYTE_HEX(pReport[0]);
	SAMPLE_PRINT("], ");
	
	if( mouse_type == HID_DEVICE_TYPE_MOUSE){
		/* W 8bit */
		report = hid_convert8bitToSignedValue(pReport[1]);
		SAMPLE_PRINT("XMove[");
		SAMPLE_PRINT_NUM(report);
		SAMPLE_PRINT("], ");
		
		report = hid_convert8bitToSignedValue(pReport[2]);
		SAMPLE_PRINT("YMove[");
		SAMPLE_PRINT_NUM(report);
		SAMPLE_PRINT("], ");
		
		report = hid_convert8bitToSignedValue(pReport[3]);
		SAMPLE_PRINT("Wheel[");
		SAMPLE_PRINT_NUM(report);
		SAMPLE_PRINT("]");
	}else{
		/* W 12bit */
		coordinates = (unsigned short)pReport[1] | ((unsigned short)(pReport[2] & 0x0f) << 8);
		report = hid_convert12bitToSignedValue( coordinates);
		SAMPLE_PRINT("XMove[");
		SAMPLE_PRINT_NUM(report);
		SAMPLE_PRINT("], ");

		coordinates = ((unsigned short)(((pReport[3] & 0x0f) << 4) | (pReport[2] & 0xf0) >> 4)) | (((unsigned short)pReport[3] << 4) & 0x0f00);
		report = hid_convert12bitToSignedValue( coordinates);
		SAMPLE_PRINT("YMove[");
		SAMPLE_PRINT_NUM(report);
		SAMPLE_PRINT("], ");

		report = hid_convert8bitToSignedValue(pReport[4]);
		SAMPLE_PRINT("Wheel[");
		SAMPLE_PRINT_NUM(report);
		SAMPLE_PRINT("], ");

		report = hid_convert8bitToSignedValue(pReport[5]);
		SAMPLE_PRINT("Other[");
		SAMPLE_PRINT_NUM(report);
		SAMPLE_PRINT("]");
	}
}

/******************************************************************************
   FunctionF  hid_printKeyName
   ArgumentF  pReport     : ʒmꂽ|[g
               pKeyCode    : ONƂȂL[R[hz
   Return  F  Ȃ
   Summary F  ONꂽL[R[hɑΉL[̖̂\܂B
   Caution F  Ȃ
******************************************************************************/
static void hid_printKeyName(uhs_ubit8_t* pReport, uhs_ubit8_t* pKeyCode)
{
	char					name[2] = {0};					/* L[R[h						*/
	int						i;


	/* ꂽL[Ȃ */
	if(pKeyCode[0] == 0) {
		/* \Ȃ */
		return;
	}

	SAMPLE_PRINT(" : ");

	/* VtgON */
	if(hid_isShiftOn(pReport) == SAMPLE_TRUE) {
		for(i = 0; i < KEY_CODE_ARR_SIZE; i++) {
			/* L[R[h͊i[ĂȂ */
			if(pKeyCode[i] == 0) {
				break;
			}
			
			/* L[̎擾 */
			name[0] = g_keyTableShift[pKeyCode[i]];
			/* ̂ */
			if(name[0] != 0) {
				SAMPLE_PRINT(name);
				SAMPLE_PRINT(" ");
			}
		}
	}
	/* VtgOFF */
	else {
		for(i = 0; i < KEY_CODE_ARR_SIZE; i++) {
			/* L[R[h͊i[ĂȂ */
			if(pKeyCode[i] == 0) {
				break;
			}
			
			/* L[̎擾 */
			name[0] = g_keyTable[pKeyCode[i]];
			/* ̂ */
			if(name[0] != 0) {
				SAMPLE_PRINT(name);
				SAMPLE_PRINT(" ");
			}
		}
	}
}

/******************************************************************************
   FunctionF  hid_getOnKeyCode
   ArgumentF  pLastReport : Õ|[g
               pNewReport  : ̃|[g
               pKeyCode    : ONꂽL[R[hi[zAhX
   Return  F  SAMPLE_TRUE  : ONL[
               SAMPLE_FALSE : ONL[Ȃ
   Summary F  ꂽL[̃L[R[h擾܂B
   Caution F  Modifier byte͏B
******************************************************************************/
static char hid_getOnKeyCode(uhs_ubit8_t* pLastReport, uhs_ubit8_t* pNewReport, uhs_ubit8_t* pKeyCode)
{
	int						pos = 0;						/* L[R[hi[ʒu				*/
	int						retval = SAMPLE_FALSE;
	int						i, j;


	/* p[^`FbN */
	if((pLastReport == NULL) || (pNewReport == NULL)) {
		return SAMPLE_FALSE;
	}
	
	/* L[R[hz񏉊 */
	sample_memset(pKeyCode, 0, KEY_CODE_ARR_SIZE);
	
	/* ̃|[g̃L[R[h𒲂ׂ */
	for(i = 2; i < KEYBOARD_REPORT_SIZE; i++) {
		/* 0̏ꍇOÑL[Ȃ */
		if(pNewReport[i] == 0) {
			continue;
		}
		
		/* Õ|[gɊ܂܂ĂȂVONꂽǂ */
		for(j = 2; j < KEYBOARD_REPORT_SIZE; j++) {
			/* vOONł */
			if(pLastReport[j] == pNewReport[i]) {
				break;
			}
		}
		if(j == KEYBOARD_REPORT_SIZE) {
			pKeyCode[pos] = pNewReport[i];
			pos++;
			retval = SAMPLE_TRUE;
		}
	}

	return retval;
}

/******************************************************************************
   FunctionF  hid_isShiftOn
   ArgumentF  pReport     : ʒmꂽ|[g
   Return  F  SAMPLE_TRUE  : VtgL[ON
               SAMPLE_FALSE : VtgL[OFF
   Summary F  VtgL[ON^OFF𔻒肵܂B
   Caution F  Ȃ
******************************************************************************/
static int hid_isShiftOn(uhs_ubit8_t* pReport)
{
	/* p[^`FbN */
	if(pReport == NULL) {
		return SAMPLE_FALSE;
	}
	
	/* VtgL[ON */
	if(pReport[0] & (HID_LEFT_SHIFT | HID_RIGHT_SHIFT)) {
		return SAMPLE_TRUE;
	}

	return SAMPLE_FALSE;
}

/******************************************************************************
   FunctionF  hid_convert8bitToSignedValue
   ArgumentF  val         : ϊΏےl
   Return  F  ϊl
   Summary F  Ȃ8rbgl𕄍intlɕϊ܂B
   Caution F  Ȃ
******************************************************************************/
static int hid_convert8bitToSignedValue(unsigned char val)
{
	int						ret = val;						/* ߂l							*/


	/* }CiXl */
	if(val & 0x80) {
		ret = (0 - (unsigned char)(~val) - 1);
	}
	return ret;
}



/******************************************************************************
   FunctionF  hid_dstMouseSize
   ArgumentF  pReportDescInfo   : |[gfBXNv^AhX
   Return  F  }EX̍Wbit
                      1:W  8bit}EX
                      2:W 12bit}EX
   Summary F  |[gfBXNv^A}EX̍W̕𔻕ʂ
   Caution F  |[gfBXNv^TCÝA255Byteȉ̂̂ɑΉ
               f͈ȉ
                 EReport Descriptor 2߂"Generic Desktop Controls"
                 Ěɂ"Logical Maximum"̃f[^TCYmF
                     - 1ByteF 8bit}EX
                     - 2ByteF12bit}EX
                    ̏ɍvȂ̂8bit}EXƂB
               ƂB
******************************************************************************/
static unsigned char hid_dstMouseSize( PHID_DESC_INFO pReportDescInfo)
{
	unsigned char	i;
	unsigned char	ret = 1;
	unsigned char	detect_flg = 0;
	unsigned char	size = (unsigned char)pReportDescInfo->u16Length;

	/* |[gfBXNv^ "Usage X"  */
	for( i= 0; i < size; i++){
		switch((pReportDescInfo->pu8Buff[i]) & 0x03){	/* Short Item Datasize */
			case	0:	/* size = 0 */
				/* Do Nothing */
				break;
			case	1:	/* size = 1 */
				if(((unsigned short)pReportDescInfo->pu8Buff[i] | ((unsigned short)pReportDescInfo->pu8Buff[i+1] << 8)) == 0x0105){	/* Usage Page"Generic Desktop Controls"? */
					detect_flg++;
				}
				i++;
				break;
			case	2:	/* size = 2 */
				i += 2;
				break;
			case	3:	/* size = 4 */
				i += 4;
				break;
			default:
				SAMPLE_PRINT("\r\n");
				/* Do Nothing */
				;
				break;
		}
		if(detect_flg == 2){
			break;
		}
	}

	/* ɗ "Logical Maximum"ÃTCY 1Byte:8bit / 2Byte:12bitƔf */
	if( detect_flg == 2){
        i++;    /* Short Itemɏꏊ */
		for( ; i < size; i++){
			if(((pReportDescInfo->pu8Buff[i]) & 0xfc) == 0x14){	/* "Logical Maximum"? */
				if(((pReportDescInfo->pu8Buff[i]) & 0x03) == 0x02){	/* DataSize = 2? */
					ret	= 2;
				}else{
					/* Do Nothing */
					;
				}
				break;
			}
			switch((pReportDescInfo->pu8Buff[i]) & 0x03){	/* Short Item Datasize */
				case	0:	/* size = 0 */
					/* Do Nothing */
					break;
				case	1:	/* size = 1 */
					i++;
					break;
				case	2:	/* size = 2 */
					i += 2;
					break;
				case	3:	/* size = 4 */
					i += 4;
					break;
				default:
					SAMPLE_PRINT("\r\n");
					/* Do Nothing */
					;
					break;
			}
		}
	}else{
		/* "Usage X""Logical Maximum"Ȃꍇ́A8bit}EXƂē삳 */
		/* Do Nothing */
		;
	}

	return	ret;
}



/******************************************************************************
   FunctionF  hid_convert12bitToSignedValue
   ArgumentF  val         : ϊΏےl
   Return  F  ϊl
   Summary F  12rbgl𕄍intlɕϊ܂B
   Caution F  Ȃ
******************************************************************************/
static int hid_convert12bitToSignedValue(unsigned short val)
{
	int						ret = val;						/* ߂l							*/


	/* }CiXl */
	if(val & 0x0800) {
		ret = (0 - (unsigned char)(~val) - 1);
	}
	return ret;
}

