/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/

/*****************************************************************************/
/*     include file                                                          */
/*****************************************************************************/
/* ꂩ͕K"1"ɂ邱 */
#define AG903_SAMPLE_USB_MSC_ENABLE		(1)		/* MSCLɂꍇ"1" */
#define AG903_SAMPLE_USB_CDC_ENABLE		(0)		/* CDCLɂꍇ"1" */
#define AG903_SAMPLE_USB_HID_ENABLE		(1)		/* HIDLɂꍇ"1" */

#if AG903_SAMPLE_USB_MSC_ENABLE
#include "storage/usb_msc_internal_api.h"
#endif
#if AG903_SAMPLE_USB_CDC_ENABLE
#include "cdc/usb_cdc_internal_api.h"
#endif
#if AG903_SAMPLE_USB_HID_ENABLE
#include "hid/usb_hid_internal_api.h"
#endif
#include "usbc_main.h"
#include "unknown/usb_unknown_device.h"
#include "sample_common.h"
#include "com.h"
#include "vram/vrammgr.h"
#include "usb_sample.h"
#if AG903_SAMPLE_USB_MSC_ENABLE
#include "sample_app_msc.h"
#endif
#if AG903_SAMPLE_USB_CDC_ENABLE
#include "sample_app_cdc.h"
#endif
#if AG903_SAMPLE_USB_HID_ENABLE
#include "sample_app_hid.h"
#endif
#include "sample_util.h"

/*****************************************************************************/
/*     function prototype                                                    */
/*****************************************************************************/
static int32_t Usbh_init_module(void);
static int32_t Usbh_term_module(void);
static void Usbh_SampleHelp(void);
#if AG903_SAMPLE_USB_CDC_ENABLE
static void Usbh_CdcSample(void);
#endif
#if AG903_SAMPLE_USB_HID_ENABLE
static void Usbh_HidSample(void);
#endif
static void Usbh_InitHw(void);
static void Usbh_SampleAplInit(uint8_t devcls);
static void Usbh_SampleAplEnd(uint8_t devcls);
static void Usbh_SampleAplProc(void);
static void Usbh_ReqSuspend(void);
static void Usbh_ReqResume(void);
static int sample_app_callback(int mod_id, int callback_id, void* pContext);
static void sample_app_unknowncallback(int callback_id, void* pContext);
static void sample_app_usbhcallback(int callback_id, void* pContext);
static int sample_app_split_err_callback(int _mod_id, int callback_id, void* pContext);

/*****************************************************************************/
/*     Param			                                                     */
/*****************************************************************************/
#define USBH_SMP_ATCTIME			(30000)					/* TvANeBu[ms] */	/**b**/
#define USBH_SMP_MSC				(1<<0)					/* MSCfoCXw */
#define USBH_SMP_CDC				(1<<1)					/* CDCfoCXw */
#define USBH_SMP_HID				(1<<2)					/* HIDfoCXw */
#define USBH_SMP_

enum {	/*  */
	USBH_SMP_STATE_NORMAL=0,
	USBH_SMP_STATE_SUSPEND,
};

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/
int32_t			g_mplid_app;
static uint8_t	UsbhAplStat=USBH_SMP_STATE_NORMAL;

static void (*func[])() = {
	Usbh_SampleHelp,
#if AG903_SAMPLE_USB_HID_ENABLE
	Usbh_HidSample,
#endif
#if AG903_SAMPLE_USB_CDC_ENABLE
	Usbh_CdcSample,
#endif
};

/*****************************************************************************/
/*     Macro                                                                 */
/*****************************************************************************/
#define	EPRINT(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)
#define	PRINT(FMT, ...)			sys_print(0, FMT"\r\n",##__VA_ARGS__)
#define DMAC_ERROR(str)			sys_print(1, " ERROR:%s[%d] *%s*\r\n",__FUNCTION__, __LINE__, str)


/**
 * @brief		C
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void USBH_main(uint8_t param)
{
	uint8_t		mode = 0;
	char		input[2+2];

	((void)param);

	Usbh_SampleHelp();	/* Help\ */

	Usbh_init_module();

	while (mode != 0xFF) {
		EPRINT(" -- Choose sample number (00h<HELP> to FFh): ");
		COM_GetNum_Wait(input, sizeof(input));
		mode = (ASCtoBIN(input[0]) << 4)
			 | (ASCtoBIN(input[1]) << 0);
		if(0xFF == mode) {
			break;
		}
		if(mode >= (sizeof(func)/sizeof(void*))) {
			func[0](); /* Help */
		}
		else {
			Usbh_SampleEnd();	/* USBHI */
			sys_dlytsk(10);
			Usbh_SampleInit();	/* USBHċN */
			func[mode]();		/* Sample funcs */
		}
	}

	Usbh_term_module();

	return;
}

/**
 * @brief		Tu
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void USBH_sub(uint32_t param)
{
	((void)param);
	/* Ȃ */
	return;
}

/**
 * @brief		W[
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t Usbh_init_module(void)
{
	/* Ȃ */
	return AG903_ENONE;
}

/**
 * @brief		W[I
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t Usbh_term_module(void)
{
	/* Ȃ */
	return AG903_ENONE;
}

/**
 * @brief		wv\
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Usbh_SampleHelp(void)
{
	PRINT("\t# 00 ... Help");
#if AG903_SAMPLE_USB_HID_ENABLE
	PRINT("\t# 01 ... hid sample");
#endif
#if AG903_SAMPLE_USB_CDC_ENABLE
	PRINT("\t# 02 ... cdc sample");
#endif
	PRINT("\t# FF ... Exit Sample");

	return;
}

#if AG903_SAMPLE_USB_CDC_ENABLE
/**
 * @brief		CDC Tv
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Usbh_CdcSample(void)
{
	Usbh_SampleAplInit(USBH_SMP_CDC);
	sys_dlytsk(USBH_SMP_ATCTIME);
	Usbh_SampleAplEnd(USBH_SMP_CDC);

	return;
}
#endif

#if AG903_SAMPLE_USB_HID_ENABLE
/**
 * @brief		HID Tv
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Usbh_HidSample(void)
{
	Usbh_SampleAplInit(USBH_SMP_HID);
	Usbh_SampleAplProc();
	Usbh_SampleAplEnd(USBH_SMP_HID);

	return;
}
#endif

/**
 * @brief		Tv
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
void Usbh_SampleInit(void)
{
	AG903_VRAMMgrMplPrm		pool_prm = {0};					/* v[p[^		*/
    usbh_regist_info		init;							/* USBp[^				*/
    app_callback_info		app_cbinfo[4];					/* NXhCo				*/
    uhs_status_t			retval;							/* ߂l							*/
    int						i = 0;

    Usbh_InitHw();

#if AG903_SAMPLE_USB_MSC_ENABLE
	/* MSC}ꂽꍇ̏֐ */
    app_cbinfo[i].clsdrv_type = USB_CLASS_MASSSTOR;	/* MSCNXhCo	*/
    app_cbinfo[i].attach_callback = sample_app_callback;
    app_cbinfo[i].detach_callback = sample_app_callback;
	app_cbinfo[i].class_ini_callback = (usb_class_init_callback_t)Usbh_Stor_Init;
    app_cbinfo[i++].is_lastnode = FALSE;
#endif

#if AG903_SAMPLE_USB_CDC_ENABLE
	/* Communications Device}ꂽꍇ̏֐ */
    app_cbinfo[i].clsdrv_type = USB_CLASS_CDC;		/* CDC NXhCo	*/
    app_cbinfo[i].attach_callback = sample_app_callback;
    app_cbinfo[i].detach_callback = sample_app_callback;
    app_cbinfo[i].class_ini_callback = (usb_class_init_callback_t)Usbh_Cdc_Init;
    app_cbinfo[i++].is_lastnode = FALSE;
#endif

#if AG903_SAMPLE_USB_HID_ENABLE
	/* Human Interface Device}ꂽꍇ̏֐ */
    app_cbinfo[i].clsdrv_type = USB_CLASS_HID;		/* HIDNXhCo	*/
    app_cbinfo[i].attach_callback = sample_app_callback;
    app_cbinfo[i].detach_callback = sample_app_callback;
	app_cbinfo[i].class_ini_callback = (usb_class_init_callback_t)Usbh_Hid_Init;
    app_cbinfo[i++].is_lastnode = FALSE;
#endif

	/* T|[gOUSBfoCX}ꂽꍇ̏֐ */
    app_cbinfo[i].clsdrv_type = USB_CLASS_UNKNOWN;			/* T|[gfoCX	*/
    app_cbinfo[i].attach_callback = sample_app_callback;
    app_cbinfo[i].detach_callback = sample_app_callback;
    app_cbinfo[i].class_ini_callback = (usb_class_init_callback_t)Usb_UnknownClassDriver_Init;
    app_cbinfo[i].is_lastnode = TRUE;

    /* p[^ݒ */
    init.app_callback = app_cbinfo;									/* NXhCo	*/
    init.overload_callback = sample_app_callback;					/* OverCurrent֐	*/
    init.status_notify_callback = sample_app_callback;				/* Statusʒm֐	*/
    init.split_err_notify_callback = sample_app_split_err_callback;	/* SplitʐMG[֐	*/
    init.assert_callback = NULL;									/* AssertoR[obN */
    init.logtype = USB_MSGMON_LOGTYPE_ANALYSIS;						/* ̓O^Cv		*/

	/* USBzXghCo */
	retval = Usbh_Init(init);
	if(retval != UDI_OK) {
		/* error */
		return;
	}

	/*------------------*/
	/* v[ */
	/*------------------*/
	/* p[^ݒ */
	pool_prm.mplatr	= AG903_OSW_ATRFIFO;					/* v[҂ FIFO 			*/
	pool_prm.mplsz	= MPL_APP_SIZE;							/* v[̃oCgTCY		*/
	pool_prm.mpl	= (void *)MPL_APP_ADDR;					/* v[̈̐擪Ԓn		*/
	pool_prm.memtype = AG903_VRAM_NORMAL_CACHE_OFF;			/* LbV OFF					*/

	/* v[ */
	g_mplid_app = AG903_VRAMMgrCreateMpl(&pool_prm);

	return;
}

/**
 * @brief		TvI
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
void Usbh_SampleEnd(void)
{
    uint32_t			result;
    uhs_status_t		retval;

	retval = Usbh_Exit();
	if(retval != UDI_OK) {
		/* error */
	}

	result = AG903_VRAMMgrDeleteMpl(g_mplid_app);
	if(result != AG903_ENONE) {
		/* error */
	}

	return;
}

/**
 * @brief		HID Tv
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Usbh_InitHw(void)
{
	Board_SelectUsbMode(AG903_USB_MODE_HOST);	/* USB HOST[h */
	return;
}

#if defined(__ICCARM__)
	#pragma diag_suppress=Pe177
#endif
/**
 * @brief		TvAv
 * @param[in]	devcls	foCXNX(bitw)
 * @return		Ȃ
 * @note		Ȃ
 */
static void Usbh_SampleAplInit(uint8_t devcls)
{

#if AG903_SAMPLE_USB_MSC_ENABLE
	if(USBH_SMP_MSC&devcls) {
		msc_appinit();
	}
#endif
#if AG903_SAMPLE_USB_CDC_ENABLE
	if(USBH_SMP_CDC&devcls) {
		cdc_appinit();
	}
#endif
#if AG903_SAMPLE_USB_HID_ENABLE
	if(USBH_SMP_HID&devcls) {
		hid_appinit();
	}
#endif
	return;
}

/**
 * @brief		TvAvI
 * @param[in]	devcls	foCXNX(bitw)
 * @return		Ȃ
 * @note		Ȃ
 */
static void Usbh_SampleAplEnd(uint8_t devcls)
{

#if AG903_SAMPLE_USB_MSC_ENABLE
	if(USBH_SMP_MSC&devcls) {
		msc_append();
	}
#endif
#if AG903_SAMPLE_USB_CDC_ENABLE
	if(USBH_SMP_CDC&devcls) {
		cdc_append();
	}
#endif
#if AG903_SAMPLE_USB_HID_ENABLE
	if(USBH_SMP_HID&devcls) {
		hid_append();
	}
#endif
	return;
}

/**
 * @brief		TvAvs
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Usbh_SampleAplProc(void)
{
	char input[4];

	while(1) {
		COM_GetChara_Wait(input, 3); /* R\[͑҂ */
		if( ('e'==input[0]) || ('E'==input[0]) ) {
			break; /* I */
		}
		if( ('s'==input[0]) || ('S'==input[0]) ) {
			Usbh_ReqSuspend(); /* Suspend */
		}
		if( ('r'==input[0]) || ('R'==input[0]) ) {
			Usbh_ReqResume(); /* Resume */
		}
	}

	if(USBH_SMP_STATE_SUSPEND==UsbhAplStat) {
		Usbh_ReqResume(); /* Resume */
	}

	return;
}

#if defined(__ICCARM__)
	#pragma diag_default=Pe177
#endif

/**
 * @brief		TvAvSUSPEND
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Usbh_ReqSuspend(void)
{
	int32_t			result=AG903_ENONE;
	uhs_status_t 	ret;

	do {
		/** FSẴfoCXɑ΂ăGj[VĂ鎖I **/
		/**     iGj[V͖̓ۏ؁j                     **/

		ret = Usbh_Api_ReqDisableAttDet(); /* A^b`^f^b`֎~ */
		if(UDI_OK != ret) {
			result=-AG903_EFAULT;
			break;
		}
#if AG903_SAMPLE_USB_CDC_ENABLE
		result = cdc_appstop(); /* CDC~ */
		if(AG903_ENONE != result) {
			break;
		}
#endif
#if AG903_SAMPLE_USB_HID_ENABLE
		result = hid_appstop(); /* HID~ */
		if(AG903_ENONE != result) {
			break;
		}
#endif
		/* MSCɑ΂鏈͂Ȃ c unmountԂ̑O */

		ret = Usbh_Api_ReqSuspend(); /* suspendv */
		if(UDI_OK != ret) {
			result=-AG903_EFAULT;
			break;
		}
	}while(0);

	if(AG903_ENONE == result) {
		PRINT(" *** SUCCESS SUSPEND ***");
		UsbhAplStat = USBH_SMP_STATE_SUSPEND;
	}
	else {
		PRINT(" Error!! FAILURE SUSPEND");
	}
	return;
}

/**
 * @brief		TvAvRESUME
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Usbh_ReqResume(void)
{
	int32_t			result=AG903_ENONE;
	uhs_status_t 	ret;

	do {
		ret = Usbh_Api_ReqResume(); /* resumev */
		if(ret != UDI_OK) {
			result=-AG903_EFAULT;
			break;
		}
#if AG903_SAMPLE_USB_CDC_ENABLE
		result = cdc_apprestart(); /* CDCĊJ */
		if(AG903_ENONE != result) {
			break;
		}
#endif
#if AG903_SAMPLE_USB_HID_ENABLE
		result = hid_apprestart(); /* HIDĊJ */
		if(AG903_ENONE != result) {
			break;
		}
#endif
	}while(0);

	if(AG903_ENONE == result) {
		PRINT(" *** SUCCESS RESUME ***");
		UsbhAplStat = USBH_SMP_STATE_NORMAL;
	}
	else {
		PRINT(" Error!! FAILURE RESUME");
	}
	return;
}


/******************************************************************************
   FunctionF  sample_app_callback
   ArgumentF  mod_id      : R[obNW[ ID
               callback_id : R[obN
               pContext    : R[obN context
   Return  F  TRUÊ
   Summary F  ʃR[obN֐
   Caution F  Ȃ
******************************************************************************/
static int sample_app_callback(int mod_id, int callback_id, void* pContext)
{
	/*----------------------*/
	/* R[obNv	*/
	/*----------------------*/
	switch(mod_id){
#if AG903_SAMPLE_USB_MSC_ENABLE
		/* MSC */
		case MOD_ID_CLASSDRV_STOR:
			msc_callback(callback_id, pContext);
			break;
#endif
#if AG903_SAMPLE_USB_CDC_ENABLE
		/* CDC */
		case MOD_ID_CLASSDRV_CDC:
			cdc_callback(callback_id, pContext);
			break;
#endif
#if AG903_SAMPLE_USB_HID_ENABLE
		/* HID */
		case MOD_ID_CLASSDRV_HID:
			hid_callback(callback_id, pContext);
			break;
#endif
		/* T|[gfoCXNX */
		case MOD_ID_CLASSDRV_UNKNOWNDEV:
			sample_app_unknowncallback(callback_id, pContext);
			break;
		/* USB RA */
		case MOD_ID_USBH:
			sample_app_usbhcallback(callback_id, pContext);
			break;
		/* ̑ */
		default:
			/* Do Nothing */
			break;
	}
    return TRUE;
}

/******************************************************************************
   FunctionF  sample_app_unknowncallback
   ArgumentF  callback_id : R[obN
               pContext    : R[obNcontext
   Return  F  Ȃ
   Summary F  T|[gfoCXpڑ^ؒfR[obN֐
   Caution F  Ȃ
******************************************************************************/
static void sample_app_unknowncallback(int callback_id, void* pContext)
{
#if 0 /* Ȃ */
    struct usbd_usb_deviceinfo*	pUsbdev;	/* ytFfoCX			*/

	/* foCXo */
	pUsbdev = ((usb_cbcontext_dev_attach *)pContext)->usbdev;

	switch(callback_id){
		/*--------*/
		/* ؒf   */
		/*--------*/
		case CBID_CORE_DEVDETACH:
			SAMPLE_PRINT("Unknown device detached");
			/* LSfoCX */
			if(pUsbdev->usbdev_DevSpeed == USB_DEVSPEED_LS) {
				SAMPLE_PRINT(" [ LS Device ]");
			}
			/* FSfoCX */
			else if(pUsbdev->usbdev_DevSpeed == USB_DEVSPEED_FS) {
				SAMPLE_PRINT(" [ FS Device ]");
			}
			/* HSfoCX */
			else if(pUsbdev->usbdev_DevSpeed == USB_DEVSPEED_HS) {
				SAMPLE_PRINT(" [ HS Device ]");
			}
			SAMPLE_PRINT("\r\n");
			break;

		/*--------*/
		/* ڑ   */
		/*--------*/
		case CBID_CORE_DEVATTACH:
			SAMPLE_PRINT("Unknown device attached");
			/* LSfoCX */
			if(pUsbdev->usbdev_DevSpeed == USB_DEVSPEED_LS) {
				SAMPLE_PRINT(" [ LS Device ]");
			}
			/* FSfoCX */
			else if(pUsbdev->usbdev_DevSpeed == USB_DEVSPEED_FS) {
				SAMPLE_PRINT(" [ FS Device ]");
			}
			/* HSfoCX */
			else if(pUsbdev->usbdev_DevSpeed == USB_DEVSPEED_HS) {
				SAMPLE_PRINT(" [ HS Device ]");
			}
			SAMPLE_PRINT("\r\n");
			break;

		/*--------*/
		/* ̑ */
		/*--------*/
		default:
			SAMPLE_PRINT("Unknown device other event\r\n");
			break;
	}
#else
	((void)callback_id);
	((void)pContext);
#endif
}

/******************************************************************************
   FunctionF  sample_app_usbhcallback
   ArgumentF  callback_id : R[obN
               pContext    : R[obN context
   Return  F  Ȃ
   Summary F  USB Host corẽR[obN֐R[ꂽۂ̏
   Caution F  Ȃ
******************************************************************************/
static void sample_app_usbhcallback(int callback_id, void* pContext)
{
	usb_msgformat			msg;							/* bZ[WtH[}bg			*/


	switch(callback_id){
		/* ߓd */
		case CBID_CORE_OVERCURRENT:
			/* G[ */
			SAMPLE_PRINT("[info] USB Overcurrent!!\r\n");
			break;

		/* Xe[^Xʒm */
		case CBID_CORE_STATUS:
			/* Local RAM ɃRs[ */
			msg.msglayer	= ((usb_msgformat *)pContext)->msglayer;
			msg.msgsublayer = ((usb_msgformat *)pContext)->msgsublayer;
			msg.msgtype		= ((usb_msgformat *)pContext)->msgtype;
			msg.msglevel	= ((usb_msgformat *)pContext)->msglevel;
			msg.msgdata		= ((usb_msgformat *)pContext)->msgdata;
			msg.extdatasize = ((usb_msgformat *)pContext)->extdatasize;
			msg.extdata		= ((usb_msgformat *)pContext)->extdata;
			msg.rcvdtime	= ((usb_msgformat *)pContext)->rcvdtime;

			switch(msg.msglevel){
				/* ʏʒm*/
				case USB_MSGMON_MSGLVL_MILESTONE:
					/* ʏʒm */
//					SAMPLE_PRINT("Milestone message\r\n");
					break;
				/* G[ʒm */
				case USB_MSGMON_MSGLVL_ERROR:
					SAMPLE_PRINT("[info] USB Error!!\r\n");
					/* G[ʒm */
					break;
				/* xʒm */
				case USB_MSGMON_MSGLVL_WARNING:
					SAMPLE_PRINT("[info] USB Warning!!\r\n");
					/* xʒm */
					break;
				default:
					break;
			}
			break;
		/* NGXgɑ΂R[obN */
		case CBID_CORE_REQ:
			/* Do Nothing */
//			SAMPLE_PRINT("Request callback\r\n");
			break;
		/* ̑ */
		default:
			break;
	}
}

/******************************************************************************
   FunctionF  sample_app_split_err_callback
   ArgumentF  mod_id      : R[obNW[ ID
               callback_id : R[obN
               pContext    : R[obN context
   Return  F  Ȃ
   Summary F  SplitG[R[obN֐R[ꂽۂ̏
   Caution F  Ȃ
******************************************************************************/
static int sample_app_split_err_callback(int mod_id, int callback_id, void* pContext)
{
	((void)mod_id);
	((void)callback_id);
	((void)pContext);
	/*  */
    return TRUE;
}
