/** 
 * @brief           BSC Primitive
 * @author          AXELL CORPORATION
 * @description     Bus State Control Primitive.
 * @note            none
 * @history         2017_10_26   Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_errno.h"
#include "AG903_common.h"
#include "register/AG903_bscreg.h"
#include "bsc/bscprm.h"


/**
 * @brief           BSCPBSTAT̃WX^Read
 * @param           stat [out] oXXe[^X
 * @return          none
 * @description     BSCPBSTAT̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetPbstat(AG903_BSCPrmPbstat* stat)
{
	uint32_t	val;
	
	ASSERT(NULL != stat);
	
	val = AG903_BSC->PBSTAT;
	
	if(AG903_BSC_PBSTAT_IDE_MSK & val){
		stat->ata_ctr = true;
	}else{
		stat->ata_ctr = false;
	}
	
	if(AG903_BSC_PBSTAT_PCC_MSK & val){
		stat->cf_ctr = true;
	}else{
		stat->cf_ctr = false;
	}
	
	if(AG903_BSC_PBSTAT_BSRQ_MSK & val){
		stat->bus_req = true;
	}else{
		stat->bus_req = false;
	}
	
	if(AG903_BSC_PBSTAT_BSGRT_MSK & val){
		stat->bus_grt = true;
	}else{
		stat->bus_grt = false;
	}
	
	if(AG903_BSC_PBSTAT_MDDV_MSK & val){
    	stat->pbus_mode = AG903_BSC_PBMODE_DEVICE;
	}else{
    	stat->pbus_mode = AG903_BSC_PBMODE_HOST;
	}
	
	if(AG903_BSC_PBSTAT_MDSRM32_MSK & val){
    	stat->bus_wid = AG903_BSC_DTWIDTH_32;
	}else{
		stat->bus_wid = AG903_BSC_DTWIDTH_16;
	}
	
	return;
}


/**
 * @brief           BSCPBINTMASK̃WX^Write
 * @param           mask [in] }XNw(rbgP)
 * @return          none
 * @description     BSCPBINTMASK̃WX^Write
 * @note            none
*/
void AG903_BSCPrmSetIntMask(uint8_t mask)
{
	AG903_BSC->PBINTMASK = (uint32_t)(mask & (AG903_BSC_PBINTMASK_INT0_MSK | AG903_BSC_PBINTMASK_INT1_MSK |
											  AG903_BSC_PBINTMASK_INT2_MSK | AG903_BSC_PBINTMASK_INT3_MSK));
	return;
}


/**
 * @brief           BSCPBINTMASK̃WX^Read
 * @param           mask [out] }XN(rbgP)
 * @return          none
 * @description     BSCPBINTMASK̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetIntMask(uint8_t* mask)
{
	ASSERT(NULL != mask);
	(*mask) = (uint8_t)(AG903_BSC->PBINTMASK & (AG903_BSC_PBINTMASK_INT0_MSK | AG903_BSC_PBINTMASK_INT1_MSK |
											    AG903_BSC_PBINTMASK_INT2_MSK | AG903_BSC_PBINTMASK_INT3_MSK));
	return;
}


/**
 * @brief           BSCPBINTMODẼWX^Write
 * @param           mode [in] 荞݃[h
 * @return          none
 * @description     BSCPBINTMODẼWX^Write
 * @note            none
*/
void AG903_BSCPrmSetIntMode(uint8_t mode)
{
	AG903_BSC->PBINTMODE = (uint32_t)(mode & (AG903_BSC_PBINTMODE_INT0_MSK | AG903_BSC_PBINTMODE_INT1_MSK |
											  AG903_BSC_PBINTMODE_INT2_MSK | AG903_BSC_PBINTMODE_INT3_MSK));
	return;
}

/**
 * @brief           BSCPBINTMODẼWX^Read
 * @param           mode [out] 荞݃[h
 * @return          none
 * @description     BSCPBINTMODẼWX^Read
 * @note            none
*/
void AG903_BSCPrmGetIntMode(uint8_t* mode)
{
	ASSERT(NULL != mode);
	(*mode) = (uint8_t)(AG903_BSC->PBINTMODE & (AG903_BSC_PBINTMODE_INT0_MSK | AG903_BSC_PBINTMODE_INT1_MSK |
											    AG903_BSC_PBINTMODE_INT2_MSK | AG903_BSC_PBINTMODE_INT3_MSK));
	return;
}


/**
 * @brief           BSCPBINTPOL̃WX^Write
 * @param           pol [in] ɐݒ
 * @return          none
 * @description     BSCPBINTPOL̃WX^Write
 * @note            none
*/
void AG903_BSCPrmSetIntPol(uint8_t pol)
{
	AG903_BSC->PBINTPOL = (uint32_t)(pol & (AG903_BSC_PBINTPOL_INT0_MSK | AG903_BSC_PBINTPOL_INT1_MSK |
											AG903_BSC_PBINTPOL_INT2_MSK | AG903_BSC_PBINTPOL_INT3_MSK));
	return;
}


/**
 * @brief           BSCPBINTPOL̃WX^Read
 * @param           pol [out] ɐݒ
 * @return          none
 * @description     BSCPBINTPOL̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetIntPol(uint8_t* pol)
{
	ASSERT(NULL != pol);
	(*pol) = (uint32_t)(AG903_BSC->PBINTMODE & (AG903_BSC_PBINTPOL_INT0_MSK | AG903_BSC_PBINTPOL_INT1_MSK |
												AG903_BSC_PBINTPOL_INT2_MSK | AG903_BSC_PBINTPOL_INT3_MSK));
	return;
}


/**
 * @brief           BSCPBINTCLR̃WX^Write
 * @param           clr [in] NAw
 * @return          none
 * @description     BSCPBINTCLR̃WX^Write
 * @note            none
*/
void AG903_BSCPrmSetIntClr(uint8_t clr)
{
	AG903_BSC->PBINTCLR = (uint32_t)(clr & (AG903_BSC_PBINTCLR_INT0_MSK | AG903_BSC_PBINTCLR_INT1_MSK |
											AG903_BSC_PBINTCLR_INT2_MSK | AG903_BSC_PBINTCLR_INT3_MSK));
	return;
}


/**
 * @brief           BSCCFMODẼWX^Write
 * @param           mode [in] 샂[h
 * @return          none
 * @description     BSCCFMODẼWX^Write
 * @note            modesȏꍇ͉s܂B
*/
void AG903_BSCPrmSetCfMode(uint8_t mode)
{
	if((AG903_BSC_CFMODE_CF==mode) || (AG903_BSC_CFMODE_ATA==mode)) {
		AG903_BSC->CFMODE = mode;
	}

	return;
}


/**
 * @brief           BSCCFMODẼWX^Read
 * @param           mode [out] 샂[h
 * @return          none
 * @description     BSCCFMODẼWX^Read
 * @note            none
*/
void AG903_BSCPrmGetCfMode(uint8_t* mode)
{
	ASSERT(NULL != mode);
	
	(*mode) = (uint8_t)(AG903_BSC->CFMODE & AG903_BSC_CFMODE_MDCF_MSK);
	
	return;
}


/**
 * @brief           BSCPBDMAPOL̃WX^Write
 * @param           req [in] nHDMAREQ̋ɐ
 * @param           ack [in] nHDMAACK̋ɐ
 * @return          none
 * @description     BSCPBDMAPOL̃WX^Write
 * @note            none
*/
void AG903_BSCPrmSetDmaPol(uint8_t req, uint8_t ack)
{
	uint32_t	val = 0;
	
	if(AG903_BSC_POL_POSITIVE == req) {
		val |= (req << AG903_BSC_PBDMAPOL_DRQ_POS);
	}
	if(AG903_BSC_POL_POSITIVE == ack) {
		val |= (ack << AG903_BSC_PBDMAPOL_DCK_POS);
	}
	AG903_BSC->PBDMAPOL = val;
	
	return;
}


/**
 * @brief           BSCPBDMAPOL̃WX^Read
 * @param           req [out] nHDMAREQ̋ɐ
 * @param           ack [out] nHDMAACK̋ɐ
 * @return          none
 * @description     BSCPBDMAPOL̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetDmaPol(uint8_t* req, uint8_t* ack)
{
	uint32_t	val;
	
	ASSERT(NULL != ack);
	ASSERT(NULL != req);
	
	val = AG903_BSC->PBDMAPOL;
	if(AG903_BSC_PBDMAPOL_DRQ_MSK & val) {
		(*req) = AG903_BSC_POL_POSITIVE;
	}
	else {
		(*req) = AG903_BSC_POL_NEGATIVE;
	}
	if(AG903_BSC_PBDMAPOL_DCK_MSK & val) {
		(*ack) = AG903_BSC_POL_POSITIVE;
	}
	else {
		(*ack) = AG903_BSC_POL_NEGATIVE;
	}
	
	return;
}


/**
 * @brief           BSCCFPMCMD̃WX^Write
 * @param           slp [in] dُ팟oɂJڂ̎{L
 * @param           act [in] J[h}ɂJڂ̎{L
 * @param           cmd [in] dǗV[PTւ̃R}h
 * @return          none
 * @description     BSCCFPMCMD̃WX^Write
 * @note            none
*/
void AG903_BSCPrmSetCfpmCmd(uint8_t slp, uint8_t act, uint8_t cmd)
{
	uint32_t	val = 0;

	if(false == slp) {
		val |= (1 << AG903_BSC_CFPMCMD_SLP_POS);	/* 1bFJڂsȂ */
	}

	if(false == act) {
		val |= (1 << AG903_BSC_CFPMCMD_ACT_POS);	/* 1bFJڂsȂ */
	}
	
	val |= (cmd << AG903_BSC_CFPMCMD_CMD_POS) & AG903_BSC_CFPMCMD_CMD_MSK;

	AG903_BSC->CFPMCMD = val;

	return;
}


/**
 * @brief           BSCCFPMCMD̃WX^Read
 * @param           slp [out] dُ팟oɂJڂ̎{L
 * @param           act [out] J[h}ɂJڂ̎{L
 * @return          none
 * @description     BSCCFPMCMD̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetCfpmCmd(uint8_t* slp, uint8_t* act)
{
	uint32_t	val;
	
	ASSERT(NULL != slp);
	ASSERT(NULL != act);
	
	val = AG903_BSC->CFPMCMD;
	
	if(AG903_BSC_CFPMCMD_SLP_MSK & val) {
		(*slp) = false;	/* 1bFJڂsȂ */
	}
	else {
		(*slp) = true;
	}
	
	if(AG903_BSC_CFPMCMD_ACT_MSK & val) {
		(*act) = false;	/* 1bFJڂsȂ */
	}
	else {
		(*act) = true;
	}

	return;
}


/**
 * @brief           BSCCFPMSTAT̃WX^Read
 * @param           cd   [out] CF_nCD [q̏
 * @param           stat [out] dǗV[PT̏
 * @return          none
 * @description     BSCCFPMSTAT̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetCfpmStat(uint8_t* cd, uint8_t* stat)
{
	uint32_t	val;
	
	ASSERT(NULL != cd);
	ASSERT(NULL != stat);
	
	val = AG903_BSC->CFPMSTAT;
	(*cd)	= (uint8_t)((val & AG903_BSC_CFPMSTAT_CD_MSK) >> AG903_BSC_CFPMSTAT_CD_POS);
	(*stat) = (uint8_t)((val & AG903_BSC_CFPMSTAT_STAT_MSK) >> AG903_BSC_CFPMSTAT_STAT_POS);
	
	return;
}


/**
 * @brief           BSCCFPMTOÑWX^Write
 * @param           cycle [in] CFd҂
 * @return          none
 * @description     BSCCFPMTOÑWX^Write
 * @note            cycle0.1msȏݒBiCFJ[hdlj
*/
void AG903_BSCPrmSetCfpmTon(uint32_t cycle)
{
	AG903_BSC->CFPMTON = cycle & AG903_BSC_CFPMTON_CYCLE_MSK;
	
	return;
}


/**
 * @brief           BSCCFPMTOÑWX^Read
 * @param           cycle [out] CFd҂ (PʁFpoXzXgNbN)
 * @return          none
 * @description     BSCCFPMTOÑWX^Read
 * @note            none
*/
void AG903_BSCPrmGetCfpmTon(uint32_t* cycle)
{
	ASSERT(NULL != cycle);
	
	(*cycle) = AG903_BSC->CFPMTON & AG903_BSC_CFPMTON_CYCLE_MSK;
	
	return;
}


/**
 * @brief           BSCCFPMTR0̃WX^Write
 * @param           cycle [in] CFZbgO҂ (PʁFpoXzXgNbN)
 * @return          none
 * @description     BSCCFPMTR0̃WX^Write
 * @note            cycle1msȏݒBiCFJ[hdlj
*/
void AG903_BSCPrmSetCfpmTr0(uint32_t cycle)
{
	AG903_BSC->CFPMTR0 = cycle & AG903_BSC_CFPMTR0_CYCLE_MSK;
	
	return;
}


/**
 * @brief           BSCCFPMTR0̃WX^Read
 * @param           cycle [out] CFZbgO҂ (PʁFpoXzXgNbN)
 * @return          none
 * @description     BSCCFPMTR0̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetCfpmTr0(uint32_t* cycle)
{
	ASSERT(NULL != cycle);
	
	(*cycle) = AG903_BSC->CFPMTR0 & AG903_BSC_CFPMTR0_CYCLE_MSK;
	
	return;
}


/**
 * @brief           BSCCFPMTR1̃WX^Write
 * @param           cycle [in] CFZbg҂ (PʁFpoXzXgNbN)
 * @return          none
 * @description     BSCCFPMTR1̃WX^Write
 * @note            cycle0.01msȏݒBiCFJ[hdlj
*/
void AG903_BSCPrmSetCfpmTr1(uint32_t cycle)
{
	AG903_BSC->CFPMTR1 = cycle & AG903_BSC_CFPMTR1_CYCLE_MSK;
	
	return;
}


/**
 * @brief           BSCCFPMTR1̃WX^Read
 * @param           cycle [out] CFZbg҂ (PʁFpoXzXgNbN)
 * @return          none
 * @description     BSCCFPMTR1̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetCfpmTr1(uint32_t* cycle)
{
	ASSERT(NULL != cycle);
	
	(*cycle) = AG903_BSC->CFPMTR1 & AG903_BSC_CFPMTR1_CYCLE_MSK;
	
	return;
}


/**
 * @brief           BSCCFPMTR2̃WX^Write
 * @param           cycle [in] CFZbg҂ (PʁFpoXzXgNbN)
 * @return          none
 * @description     BSCCFPMTR2̃WX^Write
 * @note            cycle20msȏݒBiCFJ[hdlj
*/
void AG903_BSCPrmSetCfpmTr2(uint32_t cycle)
{
	AG903_BSC->CFPMTR2 = cycle & AG903_BSC_CFPMTR2_CYCLE_MSK;
	
	return;
}


/**
 * @brief           BSCCFPMTR2̃WX^Read
 * @param           cycle [out] CFZbg҂ (PʁFpoXzXgNbN)
 * @return          none
 * @description     BSCCFPMTR2̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetCfpmTr2(uint32_t* cycle)
{
	ASSERT(NULL != cycle);
	
	(*cycle) = AG903_BSC->CFPMTR2 & AG903_BSC_CFPMTR2_CYCLE_MSK;
	
	return;
}


/**
 * @brief           BSCCFPMTPR̃WX^Write
 * @param           cycle [in] CFANZXی쎞 (PʁFpoXzXgNbN)
 * @return          none
 * @description     BSCCFPMTPR̃WX^Write
 * @note            cycle1usȏݒBiCFJ[hdlj
*/
void AG903_BSCPrmSetCfpmTpr(uint32_t cycle)
{
	AG903_BSC->CFPMTPR = cycle & AG903_BSC_CFPMTPR_CYCLE_MSK;

	return;
}


/**
 * @brief           BSCCFPMTPR̃WX^Read
 * @param           cycle [out] CFANZXی쎞 (PʁFpoXzXgNbN)
 * @return          none
 * @description     BSCCFPMTPR̃WX^Read
 * @note            none
*/
void AG903_BSCPrmGetCfpmTpr(uint32_t* cycle)
{
	ASSERT(NULL != cycle);

	(*cycle) = AG903_BSC->CFPMTPR & AG903_BSC_CFPMTPR_CYCLE_MSK;

	return;
}
