/**
 * @brief       VOD Primitive
 * @author      AXELL CORPORATION
 * @description VOD Primitive
 * @note        none
 * @history     2017_10_26  
 * @history     2017_10_26  Ver2.0
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_common.h"

#include "dsp/vodprm.h"
#include "dsp/dspmgr.h"

/* 萔` */

/**
 * VOD`l
 */
#define	AG903_VOD_CH_NUM					(AG903_DSP_CH_NUM)


/**
 * @brief o͑I擾
 * @param ch [in] ʔԍi0A1j
 * @param portsel [out] ʏo̓p[^
 * @retval none
 * @note +00h
 */
void AG903_VODPrmGetPORTSEL(uint8_t ch, uint32_t *portsel)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(portsel != (uint32_t *)NULL);

	*portsel = (AG903_VODn(ch)->PORTSEL & AG903_VODn_PORTSEL_SEL_MSK) >> AG903_VODn_PORTSEL_SEL_POS;
}

/**
 * @brief o͑Iݒ
 * @param ch [in] ʔԍi0A1j
 * @param portsel [in] ʏo̓p[^
 * @retval none
 * @note +00h
 */
void AG903_VODPrmSetPORTSEL(uint8_t ch, uint32_t portsel)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	AG903_VODn(ch)->PORTSEL = (portsel << AG903_VODn_PORTSEL_SEL_POS) & AG903_VODn_PORTSEL_SEL_MSK;
}

/**
 * @brief 샂[h擾
 * @param ch [in] ʔԍi0A1j
 * @param mod [out] 擾ݒl
 * @retval none
 * @note +04h
 */
void AG903_VODPrmGetMOD(uint8_t ch, VODPrmParamMOD *mod)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(mod != (VODPrmParamMOD *)NULL);

	uint32_t reg = AG903_VODn(ch)->MOD;
	mod->dp   = (reg & AG903_VODn_MOD_DP_MSK  ) >> AG903_VODn_MOD_DP_POS;
	mod->vp   = (reg & AG903_VODn_MOD_VP_MSK  ) >> AG903_VODn_MOD_VP_POS;
	mod->hp   = (reg & AG903_VODn_MOD_HP_MSK  ) >> AG903_VODn_MOD_HP_POS;
	mod->fp   = (reg & AG903_VODn_MOD_FP_MSK  ) >> AG903_VODn_MOD_FP_POS;
	mod->cdp  = (reg & AG903_VODn_MOD_CDP_MSK ) >> AG903_VODn_MOD_CDP_POS;
	mod->dex  = (reg & AG903_VODn_MOD_DEX_MSK ) >> AG903_VODn_MOD_DEX_POS;
	mod->vex  = (reg & AG903_VODn_MOD_VEX_MSK ) >> AG903_VODn_MOD_VEX_POS;
	mod->hex  = (reg & AG903_VODn_MOD_HEX_MSK ) >> AG903_VODn_MOD_HEX_POS;
	mod->fex  = (reg & AG903_VODn_MOD_FEX_MSK ) >> AG903_VODn_MOD_FEX_POS;
	mod->cdex = (reg & AG903_VODn_MOD_CDEX_MSK) >> AG903_VODn_MOD_CDEX_POS;
	mod->pex  = (reg & AG903_VODn_MOD_PEX_MSK ) >> AG903_VODn_MOD_PEX_POS;
	mod->cp   = (reg & AG903_VODn_MOD_CP_MSK  ) >> AG903_VODn_MOD_CP_POS;
	mod->code = (reg & AG903_VODn_MOD_CODE_MSK) >> AG903_VODn_MOD_CODE_POS;
	mod->yuv  = (reg & AG903_VODn_MOD_YUV_MSK ) >> AG903_VODn_MOD_YUV_POS;
	mod->fmt  = (reg & AG903_VODn_MOD_FMT_MSK ) >> AG903_VODn_MOD_FMT_POS;
	mod->ct0  = (reg & AG903_VODn_MOD_CT0_MSK ) >> AG903_VODn_MOD_CT0_POS;
	mod->ct1  = (reg & AG903_VODn_MOD_CT1_MSK ) >> AG903_VODn_MOD_CT1_POS;
}

/**
 * @brief 샂[hݒ
 * @param ch [in] ʔԍi0A1j
 * @param mod [in] ݒl
 * @retval none
 * @note +04h
 */
void AG903_VODPrmSetMOD(uint8_t ch, VODPrmParamMOD *mod)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(mod != (VODPrmParamMOD *)NULL);

	uint32_t reg = 0;
	reg |= (mod->dp   << AG903_VODn_MOD_DP_POS  ) & AG903_VODn_MOD_DP_MSK;
	reg |= (mod->vp   << AG903_VODn_MOD_VP_POS  ) & AG903_VODn_MOD_VP_MSK;
	reg |= (mod->hp   << AG903_VODn_MOD_HP_POS  ) & AG903_VODn_MOD_HP_MSK;
	reg |= (mod->fp   << AG903_VODn_MOD_FP_POS  ) & AG903_VODn_MOD_FP_MSK;
	reg |= (mod->cdp  << AG903_VODn_MOD_CDP_POS ) & AG903_VODn_MOD_CDP_MSK;
	reg |= (mod->dex  << AG903_VODn_MOD_DEX_POS ) & AG903_VODn_MOD_DEX_MSK;
	reg |= (mod->vex  << AG903_VODn_MOD_VEX_POS ) & AG903_VODn_MOD_VEX_MSK;
	reg |= (mod->hex  << AG903_VODn_MOD_HEX_POS ) & AG903_VODn_MOD_HEX_MSK;
	reg |= (mod->fex  << AG903_VODn_MOD_FEX_POS ) & AG903_VODn_MOD_FEX_MSK;
	reg |= (mod->cdex << AG903_VODn_MOD_CDEX_POS) & AG903_VODn_MOD_CDEX_MSK;
	reg |= (mod->pex  << AG903_VODn_MOD_PEX_POS ) & AG903_VODn_MOD_PEX_MSK;
	reg |= (mod->cp   << AG903_VODn_MOD_CP_POS  ) & AG903_VODn_MOD_CP_MSK;
	reg |= (mod->code << AG903_VODn_MOD_CODE_POS) & AG903_VODn_MOD_CODE_MSK;
	reg |= (mod->yuv  << AG903_VODn_MOD_YUV_POS ) & AG903_VODn_MOD_YUV_MSK;
	reg |= (mod->fmt  << AG903_VODn_MOD_FMT_POS ) & AG903_VODn_MOD_FMT_MSK;
	reg |= (mod->ct0  << AG903_VODn_MOD_CT0_POS ) & AG903_VODn_MOD_CT0_MSK;
	reg |= (mod->ct1  << AG903_VODn_MOD_CT1_POS ) & AG903_VODn_MOD_CT1_MSK;
	AG903_VODn(ch)->MOD = reg;
}

/**
 * @brief obNCg䃂[h擾
 * @param ch [in] ʔԍi0A1j
 * @param en [out] 擾ݒl
 * @param unit [out] 擾ݒl
 * @retval none
 * @note +0Ch
 */
void AG903_VODPrmGetBPWRMOD(uint8_t ch, uint32_t *en, uint32_t *unit)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(en != (uint32_t *)NULL);
	ASSERT(unit != (uint32_t *)NULL);

	uint32_t reg = AG903_VODn(ch)->BPWRMOD;
	*en =   (reg & AG903_VODn_BPWRMOD_EN_MSK	) >> AG903_VODn_BPWRMOD_EN_POS;
	*unit = (reg & AG903_VODn_BPWRMOD_UNIT_MSK) >> AG903_VODn_BPWRMOD_UNIT_POS;
}

/**
 * @brief obNCg䃂[hݒ
 * @param ch [in] ʔԍi0A1j
 * @param en [in] ݒl
 * @param unit [in] ݒl
 * @retval none
 * @note +0Ch
 */
void AG903_VODPrmSetBPWRMOD(uint8_t ch, uint32_t en, uint32_t unit)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	uint32_t reg = 0;
	reg |= (en	<< AG903_VODn_BPWRMOD_EN_POS	) & AG903_VODn_BPWRMOD_EN_MSK;
	reg |= (unit << AG903_VODn_BPWRMOD_UNIT_POS) & AG903_VODn_BPWRMOD_UNIT_MSK;
	AG903_VODn(ch)->BPWRMOD = reg;
}

/**
 * @brief pldONԎ擾
 * @param ch [in] ʔԍi0A1j
 * @param cnt [out] 擾ݒl
 * @retval none
 * @note +10h
 */
void AG903_VODPrmGetPPWRONCNT(uint8_t ch, uint32_t *cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(cnt != (uint32_t *)NULL);

	*cnt = (AG903_VODn(ch)->PPWRONCNT & AG903_VODn_PPWRONCNT_CNT_MSK) >> AG903_VODn_PPWRONCNT_CNT_POS;
}

/**
 * @brief pldONԐݒ
 * @param ch [in] ʔԍi0A1j
 * @param cnt [in] ݒl
 * @retval none
 * @note +10h
 */
void AG903_VODPrmSetPPWRONCNT(uint8_t ch, uint32_t cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	AG903_VODn(ch)->PPWRONCNT = (cnt << AG903_VODn_PPWRONCNT_CNT_POS) & AG903_VODn_PPWRONCNT_CNT_MSK;
}

/**
 * @brief obNCgdONԎ擾
 * @param ch [in] ʔԍi0A1j
 * @param cnt [out] 擾ݒl
 * @retval none
 * @note +14h
 */
void AG903_VODPrmGetBPWRONCNT(uint8_t ch, uint32_t *cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(cnt != (uint32_t *)NULL);

	*cnt = (AG903_VODn(ch)->BPWRONCNT & AG903_VODn_BPWRONCNT_CNT_MSK) >> AG903_VODn_BPWRONCNT_CNT_POS;
}

/**
 * @brief obNCgdONԐݒ
 * @param ch [in] ʔԍi0A1j
 * @param cnt [in] ݒl
 * @retval none
 * @note +14h
 */
void AG903_VODPrmSetBPWRONCNT(uint8_t ch, uint32_t cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	AG903_VODn(ch)->BPWRONCNT = (cnt << AG903_VODn_BPWRONCNT_CNT_POS) & AG903_VODn_BPWRONCNT_CNT_MSK;
}

/**
 * @brief obNCgLONԎ擾
 * @param ch [in] ʔԍi0A1j
 * @param cnt [out] 擾ݒl
 * @retval none
 * @note +18h
 */
void AG903_VODPrmGetBLGTONCNT(uint8_t ch, uint32_t *cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(cnt != (uint32_t *)NULL);

	*cnt = (AG903_VODn(ch)->BLGTONCNT & AG903_VODn_BLGTONCNT_CNT_MSK) >> AG903_VODn_BLGTONCNT_CNT_POS;
}

/**
 * @brief obNCgLONԐݒ
 * @param ch [in] ʔԍi0A1j
 * @param cnt [in] ݒl
 * @retval none
 * @note +18h
 */
void AG903_VODPrmSetBLGTONCNT(uint8_t ch, uint32_t cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	AG903_VODn(ch)->BLGTONCNT = (cnt << AG903_VODn_BLGTONCNT_CNT_POS) & AG903_VODn_BLGTONCNT_CNT_MSK;
}

/**
 * @brief pldOFFԎ擾
 * @param ch [in] ʔԍi0A1j
 * @param cnt [out] 擾ݒl
 * @retval none
 * @note +1Ch
 */
void AG903_VODPrmGetPPWROFFCNT(uint8_t ch, uint32_t *cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(cnt != (uint32_t *)NULL);

	*cnt = (AG903_VODn(ch)->PPWROFFCNT & AG903_VODn_PPWROFFCNT_CNT_MSK) >> AG903_VODn_PPWROFFCNT_CNT_POS;
}

/**
 * @brief pldOFFԐݒ
 * @param ch [in] ʔԍi0A1j
 * @param cnt [in] ݒl
 * @retval none
 * @note +1Ch
 */
void AG903_VODPrmSetPPWROFFCNT(uint8_t ch, uint32_t cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	AG903_VODn(ch)->PPWROFFCNT = (cnt << AG903_VODn_PPWROFFCNT_CNT_POS) & AG903_VODn_PPWROFFCNT_CNT_MSK;
}

/**
 * @brief obNCgdOFFԎ擾
 * @param ch [in] ʔԍi0A1j
 * @param cnt [out] 擾ݒl
 * @retval none
 * @note +20h
 */
void AG903_VODPrmGetBPWROFFCNT(uint8_t ch, uint32_t *cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(cnt != (uint32_t *)NULL);

	*cnt = (AG903_VODn(ch)->BPWROFFCNT & AG903_VODn_BPWROFFCNT_CNT_MSK) >> AG903_VODn_BPWROFFCNT_CNT_POS;
}

/**
 * @brief obNCgdOFFԐݒ
 * @param ch [in] ʔԍi0A1j
 * @param cnt [in] ݒl
 * @retval none
 * @note +20h
 */
void AG903_VODPrmSetBPWROFFCNT(uint8_t ch, uint32_t cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	AG903_VODn(ch)->BPWROFFCNT = (cnt << AG903_VODn_BPWROFFCNT_CNT_POS) & AG903_VODn_BPWROFFCNT_CNT_MSK;
}

/**
 * @brief obNCgLOFFԎ擾
 * @param ch [in] ʔԍi0A1j
 * @param cnt [out] 擾ݒl
 * @retval none
 * @note +24h
 */
void AG903_VODPrmGetBLGTOFFCNT(uint8_t ch, uint32_t *cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(cnt != (uint32_t *)NULL);

	*cnt = (AG903_VODn(ch)->BLGTOFFCNT & AG903_VODn_BLGTOFFCNT_CNT_MSK) >> AG903_VODn_BLGTOFFCNT_CNT_POS;
}

/**
 * @brief obNCgLOFFԐݒ
 * @param ch [in] ʔԍi0A1j
 * @param cnt [in] ݒl
 * @retval none
 * @note +24h
 */
void AG903_VODPrmSetBLGTOFFCNT(uint8_t ch, uint32_t cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	AG903_VODn(ch)->BLGTOFFCNT = (cnt << AG903_VODn_BLGTOFFCNT_CNT_POS) & AG903_VODn_BLGTOFFCNT_CNT_MSK;
}

/**
 * @brief PWM擾
 * @param ch [in] ʔԍi0A1j
 * @param period [out] 擾ݒl
 * @retval none
 * @note +28h
 */
void AG903_VODPrmGetPWMPERIOD(uint8_t ch, uint32_t *period)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(period != (uint32_t *)NULL);

	*period =
		(AG903_VODn(ch)->PWMPERIOD & AG903_VODn_PWMPERIOD_PERIOD_MSK) >> AG903_VODn_PWMPERIOD_PERIOD_POS;
}

/**
 * @brief PWMݒ
 * @param ch [in] ʔԍi0A1j
 * @param period [in] ݒl
 * @retval none
 * @note +28h
 */
void AG903_VODPrmSetPWMPERIOD(uint8_t ch, uint32_t period)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	AG903_VODn(ch)->PWMPERIOD =
		(period << AG903_VODn_PWMPERIOD_PERIOD_POS) & AG903_VODn_PWMPERIOD_PERIOD_MSK;
}

/**
 * @brief PWMJEg擾
 * @param ch [in] ʔԍi0A1j
 * @param cnt [out] 擾ݒl
 * @retval none
 * @note +2Ch
 */
void AG903_VODPrmGetPWMCNT(uint8_t ch, uint32_t *cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(cnt != (uint32_t *)NULL);

	*cnt = (AG903_VODn(ch)->PWMCNT & AG903_VODn_PWMCNT_CNT_MSK) >> AG903_VODn_PWMCNT_CNT_POS;
}

/**
 * @brief PWMJEgݒ
 * @param ch [in] ʔԍi0A1j
 * @param cnt [in] ݒl
 * @retval none
 * @note +2Ch
 */
void AG903_VODPrmSetPWMCNT(uint8_t ch, uint32_t cnt)
{
	ASSERT(ch < AG903_VOD_CH_NUM);

	AG903_VODn(ch)->PWMCNT = (cnt << AG903_VODn_PWMCNT_CNT_POS) & AG903_VODn_PWMCNT_CNT_MSK;
}

/**
 * @brief HԎ擾
 * @param ch [in] ʔԍi0A1j
 * @param state [out] 擾l
 * @retval none
 * @note +30h
 */
void AG903_VODPrmGetSTAT(uint8_t ch, uint32_t *state)
{
	ASSERT(ch < AG903_VOD_CH_NUM);
	ASSERT(state != (uint32_t *)NULL);

	*state = (AG903_VODn(ch)->STAT & AG903_VODn_STAT_STATE_MSK) >> AG903_VODn_STAT_STATE_POS;
}

/**
 * @brief }N0擾
 * @param fr [out] 擾ݒl
 * @param pm [out] 擾ݒl
 * @param pdx [out] 擾ݒl
 * @retval none
 * @note +00h
 */
void AG903_VODPrmGetMACRO0(uint32_t *fr, uint32_t *pm, uint32_t *pdx)
{
	ASSERT(fr != (uint32_t *)NULL);
	ASSERT(pm != (uint32_t *)NULL);
	ASSERT(pdx != (uint32_t *)NULL);

	uint32_t reg = AG903_VOD->MACRO0;
	*fr  = (reg & AG903_VOD_MACRO0_FR_MSK ) >> AG903_VOD_MACRO0_FR_POS;
	*pm	 = (reg & AG903_VOD_MACRO0_PM_MSK ) >> AG903_VOD_MACRO0_PM_POS;
	*pdx = (reg & AG903_VOD_MACRO0_PDX_MSK) >> AG903_VOD_MACRO0_PDX_POS;
}

/**
 * @brief }N0ݒ
 * @param fr [in] ݒl
 * @param pm [in] ݒl
 * @param pdx [in] ݒl
 * @retval none
 * @note +00h
 */
void AG903_VODPrmSetMACRO0(uint32_t fr, uint32_t pm, uint32_t pdx)
{
	uint32_t reg = 0;
	reg |= (fr  << AG903_VOD_MACRO0_FR_POS ) & AG903_VOD_MACRO0_FR_MSK;
	reg |= (pm  << AG903_VOD_MACRO0_PM_POS ) & AG903_VOD_MACRO0_PM_MSK;
	reg |= (pdx << AG903_VOD_MACRO0_PDX_POS) & AG903_VOD_MACRO0_PDX_MSK;
	AG903_VOD->MACRO0 = reg;
}

/**
 * @brief }N1擾
 * @param fr [out] 擾ݒl
 * @param pm [out] 擾ݒl
 * @param pdx [out] 擾ݒl
 * @retval none
 * @note +04h
 */
void AG903_VODPrmGetMACRO1(uint32_t *fr, uint32_t *pm, uint32_t *pdx)
{
	ASSERT(fr != (uint32_t *)NULL);
	ASSERT(pm != (uint32_t *)NULL);
	ASSERT(pdx != (uint32_t *)NULL);

	uint32_t reg = AG903_VOD->MACRO1;
	*fr  = (reg & AG903_VOD_MACRO1_FR_MSK ) >> AG903_VOD_MACRO1_FR_POS;
	*pm  = (reg & AG903_VOD_MACRO1_PM_MSK ) >> AG903_VOD_MACRO1_PM_POS;
	*pdx = (reg & AG903_VOD_MACRO1_PDX_MSK) >> AG903_VOD_MACRO1_PDX_POS;
}

/**
 * @brief }N1ݒ
 * @param fr [in] ݒl
 * @param pm [in] ݒl
 * @param pdx [in] ݒl
 * @retval none
 * @note +04h
 */
void AG903_VODPrmSetMACRO1(uint32_t fr, uint32_t pm, uint32_t pdx)
{
	uint32_t reg = 0;
	reg |= (fr  << AG903_VOD_MACRO1_FR_POS ) & AG903_VOD_MACRO1_FR_MSK;
	reg |= (pm  << AG903_VOD_MACRO1_PM_POS ) & AG903_VOD_MACRO1_PM_MSK;
	reg |= (pdx << AG903_VOD_MACRO1_PDX_POS) & AG903_VOD_MACRO1_PDX_MSK;
	AG903_VOD->MACRO1 = reg;
}
