/**
 * @brief           PGP Manager Common Header
 * @author          AXELL CORPORATION
 * @description     PGP Manager Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2019_12_27  [SDK3.0] PGP̃xO͊֐mۂ\[X֐ǉ (#1951)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef PGPMGRCOMMONH
#define PGPMGRCOMMONH

#include "pgp/pgpmgr.h"

/* ReLXg */
typedef struct _PgpMgrContext {
    _Bool                 pipeline_time_sharing_enable;
    _Bool                 jpeg_output_enable;
    uint32_t              jpeg_output_pipeline;
    uint32_t              num_pipeline_handles;
    AG903_PgpMgrPipelineHandle  pipeline_handles[AG903_PGP_MGR_MAX_PIPELINE_HANDLE];
    uint32_t              num_vram_input_handles;
    AG903_PgpMgrVRAMInputHandle vram_input_handles[AG903_PGP_MGR_MAX_VRAMI_HANDLE];
    uint32_t              num_frame_calc_handles;
    AG903_PgpMgrFrameCalcHandle frame_calc_handles[AG903_PGP_MGR_MAX_FRAME_CALC_HANDLE];
    uint32_t              num_dgc_lut;
    AG903_PgpMgrDGCLookupTable  dgc_lut[AG903_PGP_MGR_MAX_DGC_LUT];
    AG903_PgpMgrPipelineHandle  *assign_pipeline[AG903_PGP_MGR_PIPELINE_NUM];
    AG903_PgpMgrVRAMInputHandle *assign_vram[AG903_PGP_MGR_VRAMI_NUM];
    AG903_PgpMgrPipelineHandle  *exec_pipeline[AG903_PGP_MGR_PIPELINE_NUM];
    AG903_PgpMgrVRAMInputHandle *exec_vram[AG903_PGP_MGR_VRAMI_NUM];
    PGPMGRCALLBACK        intr_input_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_output_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_done_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_vram_error_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_lbl_error_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_hgm_error_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_nd_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_ifc_ovf_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_input_line_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_output_line_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_lbl_done_func[AG903_PGP_MGR_PIPELINE_NUM];
    PGPMGRCALLBACK        intr_hgm_done_func[AG903_PGP_MGR_PIPELINE_NUM];
    int32_t               intr_hdr_id[AG903_PGP_MGR_PIPELINE_NUM];
} PgpMgrContext;

extern PgpMgrContext *PgpGetContext(void);
extern void PgpMgrInitPipelineHandle(AG903_PgpMgrPipelineHandle *handle);
extern void PgpMgrInitVRAMInputHandle(AG903_PgpMgrVRAMInputHandle *handle);
extern int32_t PgpMgrAssignPipelineHandle(AG903_PgpMgrPipelineHandle *handle);
extern int32_t PgpMgrAssignFrameCalcHandle(AG903_PgpMgrFrameCalcHandle *handle);
extern int32_t PgpMgrForceAssignPipelineHandle(AG903_PgpMgrPipelineHandle *handle, uint32_t pipeline);
extern int32_t PgpMgrForceAssignFrameCalcHandle(AG903_PgpMgrFrameCalcHandle *handle, uint32_t pipeline);
extern int32_t PgpMgrCheckAssignPipelineHandle(AG903_PgpMgrPipelineHandle *handle, uint32_t pipeline);
extern int32_t PgpMgrExecPipelineHandle(AG903_PgpMgrPipelineHandle *handle, uint32_t cmd);
extern int32_t PgpMgrExecFrameCalcHandle(AG903_PgpMgrFrameCalcHandle *handle, uint32_t cmd);
extern void PgpMgrExecVRAMInputHandle(AG903_PgpMgrVRAMInputHandle *handle, uint32_t cmd);
extern void PgpMgrGetPresetColorSpaceParameter(uint32_t format, uint32_t *limit, uint32_t *shift, int32_t *mtx);
extern void *PgpMgrAnalyzeLabelingTable(void *src, uint32_t tbl_num, uint32_t *out_tbl_num);
extern void PgpMgrReleaseLabelingTable(void *tbl);
extern void PgpMgrSetIntr(void);
extern void PgpMgrResetIntr(void);

#endif
/* DOM-IGNORE-END */

