/** 
 * @brief           Communication Device Class Driver API Header
 * @author          AXELL CORPORATION
 * @description     Communication Device Class Driver񋟃wb_<p>
 *                  AvP[ViData Class Interfacej
 * @note            none
 * @history         2017_02_22 
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
#ifndef __USB_CDC_DATAIF_API_H__
#define __USB_CDC_DATAIF_API_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_cdc_type.h"
#include "usb_cdc_log.h"


extern uhs_status_t Usbh_Cdc_Open(void* pContext);
extern uhs_status_t Usbh_Cdc_Close(void* pContext);
extern uhs_status_t Usbh_Cdc_ReadData(void* pContext, PCDC_BUFF_INFO pstData, uhs_ubit32_t* pu32RemainBuffSize);
extern uhs_status_t Usbh_Cdc_WriteData(void* pContext, PCDC_BUFF_INFO pstData);
extern uhs_status_t Usbh_Cdc_RestartBulkIN(void* pContext);
extern uhs_status_t Usbh_Cdc_StopBulkIN(void* pContext);
extern uhs_status_t Usbh_Cdc_RestartIntIN(void* pContext);
extern uhs_status_t Usbh_Cdc_StopIntIN(void* pContext);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define DIAPI_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define DIAPI_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#define DIAPI_CDC_REPORT_MILESTONE(num) Usbh_Cdc_Log_ReportMilestone((num))
#else
#define DIAPI_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportDummy(err)
#define DIAPI_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportDummy(err)
#define DIAPI_CDC_REPORT_MILESTONE(num) Usbh_Cdc_Log_ReportMilestone((num))
#endif

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/

#endif /* __USB_CDC_DATAIF_API_H__ */
