/** 
 * @brief           USBH HID Osutils Header
 * @author          AXELL CORPORATION
 * @description	    USBH HID Osutils Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_HID_OSUTILS_H__
#define __USB_HID_OSUTILS_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_hid_coreinclude.h"
#include "usb_hid_log.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern void *HidUtils_Malloc(uhs_size_t nSize);
extern uhs_boolean_t HidUtils_Free(void *pMem);

extern kernel_context_t *HidUtils_CreateSemaphore(kernel_context_t *pSem, uhs_index_t num, uhs_index_t init);
extern uhs_boolean_t HidUtils_DeleteSemaphore(kernel_context_t *pSem);
extern uhs_boolean_t HidUtils_AcquisitionSemaphore(kernel_context_t *pSem, uhs_ubit32_t u32Timeout);
extern uhs_boolean_t HidUtils_ReleaseSemaphore(kernel_context_t *pSem);

extern kernel_context_t *HidUtils_CreateEvent(kernel_context_t* pEvent, uhs_boolean_t bInit);
extern uhs_boolean_t HidUtils_DeleteEvent(kernel_context_t *pEvent);
extern uhs_boolean_t HidUtils_SetEvent(kernel_context_t *pEvent);
extern uhs_boolean_t HidUtils_WaitEvent(kernel_context_t *pEvent, uhs_ubit32_t u32Timeout);


/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define OSUTILS_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define OSUTILS_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#else
#define OSUTILS_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportDummy(err)
#define OSUTILS_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportDummy(err)
#endif

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_HID_OSUTILS_H__ */
