/** 
 * @brief           Mass Storage Devices Class Driver API Header
 * @author          AXELL CORPORATION
 * @description     Mass Storage Devices Class Driver񋟃wb_
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
#ifndef __USB_MSC_API_H__
#define __USB_MSC_API_H__
/* DOM-IGNORE-END */

#include "uhs_type.h"

/** G[R[h̊l */
#define USBSTOR_ERRCODE_BASE -0x0100

/* USB Storage Class Driver ԋpG[R[h(API߂l) */
/** I */
#define USBSTOR_SUCCESS 0
/** }Egς݂̃jbgw肳ꂽ */
#define USBSTOR_API_MOUNTED_UNIT              (USBSTOR_ERRCODE_BASE - 1)
/** p[^wɌ肪 */
#define USBSTOR_API_PARAM_ERROR               (USBSTOR_ERRCODE_BASE - 2)
/** }Eg̃hCuw肳ꂽ */
#define USBSTOR_API_UNMOUNT_DRIVE             (USBSTOR_ERRCODE_BASE - 3)
/** jbg݂Ȃ */
#define USBSTOR_API_NOT_FOUND_UNIT            (USBSTOR_ERRCODE_BASE - 20)
/** jbg̏łĂȂ */
#define USBSTOR_API_UNIT_NOT_READY            (USBSTOR_ERRCODE_BASE - 21)
/** jbggpłȂ */
#define USBSTOR_API_UNIT_NOT_USE              (USBSTOR_ERRCODE_BASE - 22)
/** jbgG[ */
#define USBSTOR_API_ILLIGAL_UNIT              (USBSTOR_ERRCODE_BASE - 23)
/** hCuG[ */
#define USBSTOR_API_ILLIGAL_DRIVE             (USBSTOR_ERRCODE_BASE - 24)
/** USBXg[WfoCXɑ΂R}hsɃG[ */
#define USBSTOR_MEDIUM_COMMAND_ERROR          (USBSTOR_ERRCODE_BASE - 4)
/** KvȃR}hUSBXg[WfoCXT|[gȂߏpłȂ */
#define USBSTOR_MEDIUM_COMMAND_NOT_SUPPORT    (USBSTOR_ERRCODE_BASE - 5)
/** USBXg[WfoCXReadG[񍐂ꂽ */
#define USBSTOR_MEDIUM_FAILED_READ            (USBSTOR_ERRCODE_BASE - 6)
/** USBXg[WfoCXWriteG[񍐂ꂽ */
#define USBSTOR_MEDIUM_FAILED_WRITE           (USBSTOR_ERRCODE_BASE - 7)
/** USBXg[WfoCX̃fBAꂽ */
#define USBSTOR_MEDIUM_MAY_HAVE_CHANGED       (USBSTOR_ERRCODE_BASE - 8)
/** USBXg[WfoCXɃfBAĂȂ */
#define USBSTOR_MEDIUM_NOT_PRESENT            (USBSTOR_ERRCODE_BASE - 9)
/** USBXg[WfoCXR}hp[^G[񍐂ꂽ */
#define USBSTOR_MEDIUM_PARAMETER_ERROR        (USBSTOR_ERRCODE_BASE - 10)
/** KvȃR}hp[^USBXg[WfoCXT|[gȂߏpłȂ */
#define USBSTOR_MEDIUM_PARAMETER_NOT_SUPPORT  (USBSTOR_ERRCODE_BASE - 11)
/** USBXg[WfoCXƂUSBʐMŃG[ */
#define USBSTOR_MEDIUM_TRANSFER_ERROR         (USBSTOR_ERRCODE_BASE - 12)
/** USBXg[WfoCXmSensef[^񍐂Ă */
#define USBSTOR_MEDIUM_UNKNOWN_SENSE_ERROR    (USBSTOR_ERRCODE_BASE - 13)
/** CgveNgĂ */
#define USBSTOR_MEDIUM_WRITE_PROTECT          (USBSTOR_ERRCODE_BASE - 14)
/** G[(USB Core) */
#define USBSTOR_INTERNAL_FAILED_CORE          (USBSTOR_ERRCODE_BASE - 15)
/** G[(MSC Driver) */
#define USBSTOR_INTERNAL_FAILED_MSC           (USBSTOR_ERRCODE_BASE - 16)
/** VXe\[X(AOSIuWFNg)mۂłȂ */
#define USBSTOR_SYS_OUT_OF_RESOURCE           (USBSTOR_ERRCODE_BASE - 17)
/** VXeG[ */
#define USBSTOR_SYS_SYSTEM_ERROR              (USBSTOR_ERRCODE_BASE - 18)


/* G[R[h̊l(Xe[^Xj^) */
#define USBSTOR_LOG_ERRCODE_BASE 0x0100

/* G[R[h(Xe[^Xj^) */
#define USBSTOR_LOG_API_MOUNTED_UNIT              (USBSTOR_LOG_ERRCODE_BASE + 1)
#define USBSTOR_LOG_API_PARAM_ERROR               (USBSTOR_LOG_ERRCODE_BASE + 2)
#define USBSTOR_LOG_API_UNMOUNT_DRIVE             (USBSTOR_LOG_ERRCODE_BASE + 3)

#define USBSTOR_LOG_API_NOT_FOUND_UNIT            (USBSTOR_LOG_ERRCODE_BASE + 20)
#define USBSTOR_LOG_API_UNIT_NOT_READY            (USBSTOR_LOG_ERRCODE_BASE + 21)
#define USBSTOR_LOG_API_UNIT_NOT_USE              (USBSTOR_LOG_ERRCODE_BASE + 22)
#define USBSTOR_LOG_API_ILLIGAL_UNIT              (USBSTOR_LOG_ERRCODE_BASE + 23)
#define USBSTOR_LOG_API_ILLIGAL_DRIVE             (USBSTOR_LOG_ERRCODE_BASE + 24)

#define USBSTOR_LOG_MEDIUM_COMMAND_ERROR          (USBSTOR_LOG_ERRCODE_BASE + 4)
#define USBSTOR_LOG_MEDIUM_COMMAND_NOT_SUPPORT    (USBSTOR_LOG_ERRCODE_BASE + 5)
#define USBSTOR_LOG_MEDIUM_FAILED_READ            (USBSTOR_LOG_ERRCODE_BASE + 6)
#define USBSTOR_LOG_MEDIUM_FAILED_WRITE           (USBSTOR_LOG_ERRCODE_BASE + 7)
#define USBSTOR_LOG_MEDIUM_MAY_HAVE_CHANGED       (USBSTOR_LOG_ERRCODE_BASE + 8)
#define USBSTOR_LOG_MEDIUM_NOT_PRESENT            (USBSTOR_LOG_ERRCODE_BASE + 9)
#define USBSTOR_LOG_MEDIUM_PARAMETER_ERROR        (USBSTOR_LOG_ERRCODE_BASE + 10)
#define USBSTOR_LOG_MEDIUM_PARAMETER_NOT_SUPPORT  (USBSTOR_LOG_ERRCODE_BASE + 11)
#define USBSTOR_LOG_MEDIUM_TRANSFER_ERROR         (USBSTOR_LOG_ERRCODE_BASE + 12)
#define USBSTOR_LOG_MEDIUM_UNKNOWN_SENSE_ERROR    (USBSTOR_LOG_ERRCODE_BASE + 13)
#define USBSTOR_LOG_MEDIUM_WRITE_PROTECT          (USBSTOR_LOG_ERRCODE_BASE + 14)
#define USBSTOR_LOG_INTERNAL_FAILED_CORE          (USBSTOR_LOG_ERRCODE_BASE + 15)
#define USBSTOR_LOG_INTERNAL_FAILED_MSC           (USBSTOR_LOG_ERRCODE_BASE + 16)
#define USBSTOR_LOG_SYS_OUT_OF_RESOURCE           (USBSTOR_LOG_ERRCODE_BASE + 17)
#define USBSTOR_LOG_SYS_SYSTEM_ERROR              (USBSTOR_LOG_ERRCODE_BASE + 18)


/* xR[h */
#define USBSTOR_WARNCODE_BASE 0x0400
#define USBSTOR_WARNING_OVERCONN              (USBSTOR_WARNCODE_BASE + 1)
#define USBSTOR_WARNING_NOT_SUPPORT_MULTI_LUN (USBSTOR_WARNCODE_BASE + 2)

/* ReadSector/WriteSectorsMilestone\L */
/** TRUE=\AFALSE=\ */
#define STOR_RW_MILESTONE_ERA FALSE

/* Milestone l̒` */
#define USBSTOR_CHECKPOINT_BASE 0x1000
#define USBSTOR_CHKPOINTS_API_INITIALIZE      (USBSTOR_CHECKPOINT_BASE + 1)
#define USBSTOR_CHKPOINTS_API_FINALIZE        (USBSTOR_CHECKPOINT_BASE + 2)
#define USBSTOR_CHKPOINTS_API_REREGISTCB      (USBSTOR_CHECKPOINT_BASE + 3)
#define USBSTOR_CHKPOINTS_API_MOUNT           (USBSTOR_CHECKPOINT_BASE + 4)
#define USBSTOR_CHKPOINTS_API_UNMOUNT         (USBSTOR_CHECKPOINT_BASE + 5)
#define USBSTOR_CHKPOINTS_API_GETUNMOUNTUNIT  (USBSTOR_CHECKPOINT_BASE + 6)
#define USBSTOR_CHKPOINTS_API_GETUNITINFO     (USBSTOR_CHECKPOINT_BASE + 7)
#define USBSTOR_CHKPOINTS_API_GETUNITSTATUS   (USBSTOR_CHECKPOINT_BASE + 8)
#define USBSTOR_CHKPOINTS_API_READSECTOR      (USBSTOR_CHECKPOINT_BASE + 9)
#define USBSTOR_CHKPOINTS_API_WRITESECTOR     (USBSTOR_CHECKPOINT_BASE + 10)
#define USBSTOR_CHKPOINTS_EVNT_ATTACH_DEVICE  (USBSTOR_CHECKPOINT_BASE + 11)
#define USBSTOR_CHKPOINTS_EVNT_DETACH_DEVICE  (USBSTOR_CHECKPOINT_BASE + 12)
#define USBSTOR_CHKPOINTS_API_STARTSTOP       (USBSTOR_CHECKPOINT_BASE + 13)

/** }XXg[WNXCoFW[o[W */
#define STOR_MAJOR_VERSION		(0x01)
/** }XXg[WNXhCoF}Ci[o[W */
#define STOR_MINOR_VERSION		(0x00)

/** R[obNID */
typedef enum _STOR_CALLBACK_ID {
    CBID_STOR_DEVATTACH,                                /** foCXڑꂽ(gp\) */
    CBID_STOR_DEVATTACH_NOT_READY,                      /** foCXڑꂽ(fBA) */
    CBID_STOR_DEVATTACH_NOT_USE,                        /** foCXڑꂽ(gps) */
    CBID_STOR_DEVDETACH                                 /** foCXؒfꂽ */
} STOR_CALLBACK_ID;

typedef enum _STOR_UNIT_STATUS {
    STOR_READY,
    STOR_NOT_READY,
    STOR_NOT_USE
} STOR_UNIT_STATUS;

typedef enum _STOR_IMMED_STATUS {
    STOR_IMMED_CLR,
    STOR_IMMED_SET
} STOR_IMMED_STATUS;

typedef enum _STOR_LOEJ_STATUS {
    STOR_LOEJ_CLR,
    STOR_LOEJ_SET
} STOR_LOEJ_STATUS;

typedef enum _STOR_START_STATUS {
    STOR_START_CLR,
    STOR_START_SET
} STOR_START_STATUS;


/** {hCo̓f[^ǗPʂłXg[Wjbg\̂̎QƗpf[^^<p>
    Xg[Wjbg\(struct StorUnit)̓hCo̓f[^ł邽߁A{APIQł͕ێ̂߂ɎQƗp|C^^݂̂J܂B */
typedef struct StorUnit* PSTOR_UNIT;

/** ʃ[UAvP[V`hCu\IuWFNg󂯂邽߂̃|C^^<p>
    Xg[WNXhCo̊eAPIɑ΂hCuwɎgp܂B<p>
    {hCóAt@CVXe`̃hCu\ɂhCu󂯎邽߂PUSER_DRV^gp܂A
    |C^wIuWFNg(AhX)v邩ǂŃhCu𔻒肵Ă邽߃AhXύXẴhCuw͍sȂŉB<p>
    ꍇ̓ۏ؂͂܂B */
typedef void* PUSER_DRV;

/** Xg[Wjbg̏i[\<p>
    {hCoXg[Wjbg̏񍐂邽߂Ɏgp܂B<p>
    ^C~O F Usbh_Stor_GetUnitInfo API̎sOɌĂяömۂĉB<p>
    폜^C~O F Usbh_Stor_GetUnitInfo APǏĂяo̔Cӂ̃^C~O */
typedef struct StorUnitInfo {
    uhs_ubit16_t u16BlockSize;			/** ZN^̃ubNTCY */
    uhs_ubit32_t u32LastBlockAddress;	/** ŏIubNAhX */
    uhs_boolean_t bRemovable;			/** foCX񍐂[outO */
    uhs_ubit8_t u8VendorName[8 + 1];	/** Ж(NULI[) */
    uhs_ubit8_t u8ProductName[16 + 1];	/** i(NULI[) */
} STOR_UNIT_INFO, *PSTOR_UNIT_INFO;

/** X^[gXgbvjbgR}h^ */
typedef struct StorStartStopUnitInfo {
   STOR_IMMED_STATUS Immed;				/** Immedrbg */
   STOR_LOEJ_STATUS  LoEj;				/** LoEjrbg */
   STOR_START_STATUS Start;				/** Startrbg */
} STOR_STARTSTOP_UNIT_INFO, *PSTOR_STARTSTOP_UNIT_INFO;


extern uhs_sbit32_t Usbh_Stor_Mount(PSTOR_UNIT pUnit, PUSER_DRV pDrv);
extern uhs_sbit32_t Usbh_Stor_Unmount(PUSER_DRV pDrv);
extern PSTOR_UNIT Usbh_Stor_GetUnmountUnit(void);
extern uhs_sbit32_t Usbh_Stor_GetUnitInfo(PSTOR_UNIT pUnit, STOR_UNIT_INFO *pInfo);
extern STOR_UNIT_STATUS Usbh_Stor_GetUnitStatus(PSTOR_UNIT pUnit);
extern uhs_sbit32_t Usbh_Stor_ReadSector(PUSER_DRV pDrv, uhs_ubit32_t u32LBA, uhs_ubit16_t u16BlockCount, uhs_ubit8_t *pDataBuffer);
extern uhs_sbit32_t Usbh_Stor_WriteSector(PUSER_DRV pDrv, uhs_ubit32_t u32LBA, uhs_ubit16_t u16BlockCount, uhs_ubit8_t *pDataBuffer);
extern uhs_sbit32_t Usbh_Stor_GetLastError(void *pObj);
extern uhs_status_t Usbh_Stor_GetVersion(uhs_ubit8_t* pu8MajorVersion, uhs_ubit8_t* pu8MinorVersion);
extern uhs_status_t Usbh_Stor_Api_StartStop(PSTOR_UNIT pUnit,PSTOR_STARTSTOP_UNIT_INFO pstData );
extern int Usbh_Stor_GetAttachDevNum(void);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#define CONTEXT_BASE        0x70000000

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_MSC_API_H__ */
