/** 
 * @brief           Wrapper Header
 * @author          AXELL CORPORATION
 * @description     Wrapper Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */


#ifndef __DEPEND_KERNEL_WRAPPER_H__
#define __DEPEND_KERNEL_WRAPPER_H__

// *************************************************************************************************
//	define
// *************************************************************************************************
// iv҂
#define WAITFOREVER     0xffffffff

#define NO_WAIT     0

// *************************************************************************************************
//	include
// *************************************************************************************************
#include	"uhs_configtop.h"
#include	"uhs_type.h"


// *************************************************************************************************
//	define
// *************************************************************************************************
#define		WRAPPER_KERNEL_INITIALIZE( osc , size , addr)									__kernel_initialize_itron4( osc , size , addr )
#define		WRAPPER_KERNEL_TERMINATE( osc)													__kernel_terminate_itron4( osc)
#ifdef		USBH_MEM_LEAK_CHK_ADDINFO
	#define		WRAPPER_KERNEL_MEM_ALLOC( osc, address, size, timeout, InInterrupt , file , line_num )	__kernel_mem_alloc_itron4( osc, address, size, timeout, InInterrupt , file , line_num )
#else
	#define		WRAPPER_KERNEL_MEM_ALLOC( osc, address, size, timeout, InInterrupt)				__kernel_mem_alloc_itron4( osc, address, size, timeout, InInterrupt)
#endif
#define		WRAPPER_KERNEL_MEM_FREE( osc, address, InInterrupt)								__kernel_mem_free_itron4( osc, address, InInterrupt)
#define		WRAPPER_KERNEL_CREATE_SEMAPHORE( osc, num, init)								__kernel_create_semaphore_itron4( osc, num, init)
#define		WRAPPER_KERNEL_DELETE_SEMAPHORE( osc)											__kernel_delete_semaphore_itron4( osc)
#define		WRAPPER_KERNEL_ACQUISITION_SEMAPHORE( osc, timeout, InInterrupt)				__kernel_acquisition_semaphore_itron4( osc, timeout, InInterrupt)
#define		WRAPPER_KERNEL_RELEASE_SEMAPHORE( osc, InInterrupt)								__kernel_release_semaphore_itron4( osc, InInterrupt)
#define		WRAPPER_KERNEL_CREATE_EVENT( osc, initac)										__kernel_create_event_itron4( osc, initac)
#define		WRAPPER_KERNEL_DELETE_EVENT( osc)												__kernel_delete_event_itron4( osc)
#define		WRAPPER_KERNEL_SET_EVENT( osc, InInterrupt)										__kernel_set_event_itron4( osc, InInterrupt)
#define		WRAPPER_KERNEL_WAIT_EVENT( osc, timeout, InInterrupt)							__kernel_wait_event_itron4( osc, timeout, InInterrupt)
#define		WRAPPER_KERNEL_CREATE_DTQ( osc)													__kernel_create_dataqueue_itron4( osc)
#define		WRAPPER_KERNEL_DELETE_DTQ( osc)													__kernel_delete_dataqueue_itron4( osc)
#define		WRAPPER_KERNEL_SEND_DTQ( osc, data, InInterrupt)								__kernel_send_dataqueue_itron4( osc, data, InInterrupt)
#define		WRAPPER_KERNEL_RECIEVE_DTQ( osc, data, timeout, InInterrupt)					__kernel_recieve_dtq_itron4( osc, data, timeout, InInterrupt)
#define		WRAPPER_KERNEL_WAIT( osc, time)													__kernel_wait_itron4( osc, time)
#define		WRAPPER_KERNEL_CREATE_CYCLEHND( osc, start, context, cycletime, initac)			__kernel_create_cyclehnd_itron4( osc, start, context, cycletime, initac)
#define		WRAPPER_KERNEL_DELETE_CYCLEHND( osc)											__kernel_delete_cyclehnd_itron4( osc)
#define		WRAPPER_KERNEL_CREATE_THREAD( osc, start, context, pri, stack)					__kernel_create_thread_itron4( osc, start, context, pri, stack)
#define		WRAPPER_KERNEL_DELETE_THREAD( osc)												__kernel_delete_thread_itron4( osc)
#define		WRAPPER_KERNEL_EXIT_THREAD( osc)												__kernel_exit_thread_itron4( osc)
#define		WRAPPER_KERNEL_CREATE_MESSAGE( osc)												__kernel_create_message_itron4( osc)
#define		WRAPPER_KERNEL_DELETE_MESSAGE( osc, InInterrupt)								__kernel_delete_message_itron4( osc, InInterrupt)
#define		WRAPPER_KERNEL_SEND_MESSAGE( osc, pk_msg, InInterrupt)							__kernel_send_message_itron4( osc, pk_msg, InInterrupt)
#define		WRAPPER_KERNEL_RECEIVE_MESSAGE( osc, pk_msg, timeout, InInterrupt)				__kernel_receive_message_itron4( osc, pk_msg, timeout, InInterrupt)
#define		WRAPPER_KERNEL_GET_TIMER( osc, time_h, time_l)									__kernel_get_timer_itron4( osc, time_h, time_l)
#define		WRAPPER_KERNEL_REGISTER_INTERRUPT( int_num , int_lvl , intr_handller , handle )	__kernel_register_interrupt( int_num , int_lvl , intr_handller , handle	)
#define		WRAPPER_KERNEL_UNREGISTER_INTERRUPT( int_hndle_num )							__kernel_unregister_interrupt( int_hndle_num )
#define		WRAPPER_KERNEL_ENABLE_INTERRUPT( int_num )										__kernel_enable_interrupt( int_num )
#define		WRAPPER_KERNEL_DISABLE_INTERRUPT( int_num )										__kernel_disable_interrupt( int_num )

#endif /* __DEPEND_KERNEL_WRAPPER_H__ */
