/**
 * @brief           VID Primitive
 * @author          AXELL CORPORATION
 * @description     VID Primitive Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include <stdio.h>
#include "vid/vidprm.h"
#include "register/AG903_vidreg.h"
#include "AG903_common.h"


/**
 * @brief         VIDCTRL WX^ݒ
 * @param         on [in] ONtB[hݒl
 * @return        void
 * @description   VIDCTRL WX^ݒ
*/
void AG903_VidPrmSetVIDCTRL(uint32_t on)
{
    uint32_t                    val;

    ASSERT(!(on & ~(0x1)));

    val = (on << AG903_VID_CTRL_ON_POS);

    AG903_VID->CTRL = val;
}


/**
 * @brief         VIDCTRL WX^擾
 * @param         on [out] ONtB[h擾l
 * @return        void
 * @description   VIDCTRL WX^擾
*/
void AG903_VidPrmGetVIDCTRL(uint32_t *on)
{
    uint32_t                    val;

    ASSERT(on != NULL);

    val = AG903_VID->CTRL;

    *on = (val & AG903_VID_CTRL_ON_MSK) >> AG903_VID_CTRL_ON_POS;
}


/**
 * @brief         VIDFMTWX^ ݒ
 * @param         fmt [in] FMTtB[hݒl
 * @return        void
 * @description   VIDFMTWX^ ݒ
*/
void AG903_VidPrmSetVIDFMT(uint32_t fmt)
{
    uint32_t                    val;

    ASSERT(!(fmt & ~(0x7)));

    val = (fmt << AG903_VID_FMT_FMT_POS);

    AG903_VID->FMT = val;
}


/**
 * @brief         VIDFMT WX^擾
 * @param         fmt [out] FMTtB[h擾l
 * @return        void
 * @description   VIDFMT WX^擾
*/
void AG903_VidPrmGetVIDFMT(uint32_t *fmt)
{
    uint32_t                    val;

    ASSERT(fmt != NULL);

    val = AG903_VID->FMT;

    *fmt = (val & AG903_VID_FMT_FMT_MSK) >> AG903_VID_FMT_FMT_POS;
}


/**
 * @brief         VIDIOnCTRL WX^ݒ
 * @param         id [in] `lԍ 
 * @param         soe [in] SOEtB[hݒl 
 * @return        void
 * @description   VIDIOnCTRL WX^ݒ
*/
void AG903_VidPrmSetVIDIOnCTRL(uint32_t id, uint32_t soe)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(!(soe & ~(0x1)));

    val = (soe << AG903_VIDIOn_CTRL_SOE_POS);

    AG903_VIDIOn(id)->CTRL = val;
}


/**
 * @brief         VIDIOnCTRL WX^擾
 * @param         id [in] `lԍ 
 * @param         soe [out] SOEtB[h擾l  
 * @return        void
 * @description   VIDIOnCTRL WX^擾
*/
void AG903_VidPrmGetVIDIOnCTRL(uint32_t id, uint32_t *soe)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(soe != NULL);

    val = AG903_VIDIOn(id)->CTRL;

    *soe = (val & AG903_VIDIOn_CTRL_SOE_MSK) >> AG903_VIDIOn_CTRL_SOE_POS;
}


/**
 * @brief         VIDIOnMOD WX^ݒ
 * @param         id [in] `lԍ 
 * @param         mod [in] VIDIOnMODݒli[
 * @return        void
 * @description   VIDIOnMOD WX^ݒ
*/
void AG903_VidPrmSetVIDIOnMOD(uint32_t id, VIDPrmParamVIDIOnMOD *mod)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(mod != NULL);
    ASSERT(!(mod->vpol & ~(0x1)));
    ASSERT(!(mod->hpol & ~(0x1)));
    ASSERT(!(mod->dpol & ~(0x1)));
    ASSERT(!(mod->fpol & ~(0x1)));
    ASSERT(!(mod->cpol & ~(0x1)));

    val = (mod->vpol << AG903_VIDIOn_MOD_VPOL_POS)
        | (mod->hpol << AG903_VIDIOn_MOD_HPOL_POS)
        | (mod->dpol << AG903_VIDIOn_MOD_DPOL_POS)
        | (mod->fpol << AG903_VIDIOn_MOD_FPOL_POS)
        | (mod->cpol << AG903_VIDIOn_MOD_CPOL_POS);

    AG903_VIDIOn(id)->MOD = val;
}


/**
 * @brief         VIDIOnMOD WX^擾
 * @param         id [in] `lԍ 
 * @param         mod [out] VIDIOnMOD擾li[
 * @return        void
 * @description   VIDIOnMOD WX^擾
*/
void AG903_VidPrmGetVIDIOnMOD(uint32_t id, VIDPrmParamVIDIOnMOD *mod)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(mod != NULL);

    val = AG903_VIDIOn(id)->MOD;

    mod->vpol = (val & AG903_VIDIOn_MOD_VPOL_MSK) >> AG903_VIDIOn_MOD_VPOL_POS;
    mod->hpol = (val & AG903_VIDIOn_MOD_HPOL_MSK) >> AG903_VIDIOn_MOD_HPOL_POS;
    mod->dpol = (val & AG903_VIDIOn_MOD_DPOL_MSK) >> AG903_VIDIOn_MOD_DPOL_POS;
    mod->fpol = (val & AG903_VIDIOn_MOD_FPOL_MSK) >> AG903_VIDIOn_MOD_FPOL_POS;
    mod->cpol = (val & AG903_VIDIOn_MOD_CPOL_MSK) >> AG903_VIDIOn_MOD_CPOL_POS;
}


/**
 * @brief         VIDIOnOHPRM0 WX^ݒ
 * @param         id [in] `lԍ 
 * @param         hpw [in] HPWtB[hݒl 
 * @return        void
 * @description   VIDIOnOHPRM0 WX^ݒ
*/
void AG903_VidPrmSetVIDIOnOHPRM0(uint32_t id, uint32_t hpw)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(!(hpw & ~(0xFFF)));

    val = (hpw << AG903_VIDIOn_OHPRM0_HPW_POS);

    AG903_VIDIOn(id)->OHPRM0 = val;
}


/**
 * @brief         VIDIOnOHPRM0 WX^擾
 * @param         id [in] `lԍ 
 * @param         hpw [out] HPWtB[h擾l 
 * @return        void
 * @description   VIDIOnOHPRM0 WX^擾
*/
void AG903_VidPrmGetVIDIOnOHPRM0(uint32_t id, uint32_t *hpw)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(hpw != NULL);

    val = AG903_VIDIOn(id)->OHPRM0;

    *hpw = (val & AG903_VIDIOn_OHPRM0_HPW_MSK) >> AG903_VIDIOn_OHPRM0_HPW_POS;
}


/**
 * @brief         VIDIOnOHPRM1 WX^ݒ
 * @param         id [in] `lԍ 
 * @param         hfp [in] HFPtB[hݒl
 * @param         hbp [in] HBPtB[hݒl
 * @return        void
 * @description   VIDIOnOHPRM1 WX^ݒ
*/
void AG903_VidPrmSetVIDIOnOHPRM1(uint32_t id, uint32_t hfp, uint32_t hbp)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(!(hfp & ~(0xFFF)));
    ASSERT(!(hbp & ~(0xFFF)));

    val = (hfp << AG903_VIDIOn_OHPRM1_HFP_POS)
        | (hbp << AG903_VIDIOn_OHPRM1_HBP_POS);

    AG903_VIDIOn(id)->OHPRM1 = val;
}


/**
 * @brief         VIDIOnOHPRM1 WX^擾
 * @param         id [in] `lԍ 
 * @param         hfp [out] HFPtB[h擾l
 * @param         hbp [out] HBPtB[h擾l
 * @return        void
 * @description   VIDIOnOHPRM1 WX^擾
*/
void AG903_VidPrmGetVIDIOnOHPRM1(uint32_t id, uint32_t *hfp, uint32_t *hbp)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(hfp != NULL);
    ASSERT(hbp != NULL);

    val = AG903_VIDIOn(id)->OHPRM1;

    *hfp = (val & AG903_VIDIOn_OHPRM1_HFP_MSK) >> AG903_VIDIOn_OHPRM1_HFP_POS;
    *hbp = (val & AG903_VIDIOn_OHPRM1_HBP_MSK) >> AG903_VIDIOn_OHPRM1_HBP_POS;
}


/**
 * @brief         VIDIOnOVPRM0 WX^ݒ
 * @param         id [in] `lԍ 
 * @param         vpw [in] VPWtB[hݒl
 * @return        void
 * @description   VIDIOnOVPRM0 WX^ݒ
*/
void AG903_VidPrmSetVIDIOnOVPRM0(uint32_t id, uint32_t vpw)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(!(vpw & ~(0xFFF)));

    val = (vpw << AG903_VIDIOn_OVPRM0_VPW_POS);

    AG903_VIDIOn(id)->OVPRM0 = val;
}


/**
 * @brief         VIDIOnOVPRM0 WX^擾
 * @param         id [in] `lԍ 
 * @param         vpw [out] VPWtB[h擾l 
 * @return        void
 * @description   VIDIOnOVPRM0 WX^擾
*/
void AG903_VidPrmGetVIDIOnOVPRM0(uint32_t id, uint32_t *vpw)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(vpw != NULL);

    val = AG903_VIDIOn(id)->OVPRM0;

    *vpw = (val & AG903_VIDIOn_OVPRM0_VPW_MSK) >> AG903_VIDIOn_OVPRM0_VPW_POS;
}


/**
 * @brief         VIDIOnOVPRM1 WX^ݒ
 * @param         id [in] `lԍ 
 * @param         vfp [in] VFPtB[hݒl 
 * @param         vbp [in] VBPtB[hݒl 
 * @return        void
 * @description   VIDIOnOVPRM1 WX^ݒ
*/
void AG903_VidPrmSetVIDIOnOVPRM1(uint32_t id, uint32_t vfp, uint32_t vbp)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(!(vfp & ~(0xFFF)));
    ASSERT(!(vbp & ~(0xFFF)));

    val = (vfp << AG903_VIDIOn_OVPRM1_VFP_POS)
        | (vbp << AG903_VIDIOn_OVPRM1_VBP_POS);

    AG903_VIDIOn(id)->OVPRM1 = val;
}


/**
 * @brief         VIDIOnOVPRM1 WX^擾
 * @param         id [in] `lԍ 
 * @param         vfp [out] VFPtB[h擾l
 * @param         vbp [out] VBPtB[h擾l 
 * @return        void
 * @description   VIDIOnOVPRM1 WX^擾
*/
void AG903_VidPrmGetVIDIOnOVPRM1(uint32_t id, uint32_t *vfp, uint32_t *vbp)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(vfp != NULL);
    ASSERT(vbp != NULL);

    val = AG903_VIDIOn(id)->OVPRM1;

    *vfp = (val & AG903_VIDIOn_OVPRM1_VFP_MSK) >> AG903_VIDIOn_OVPRM1_VFP_POS;
    *vbp = (val & AG903_VIDIOn_OVPRM1_VBP_MSK) >> AG903_VIDIOn_OVPRM1_VBP_POS;
}


/**
 * @brief         VIDIOnOSIZE WX^ݒ
 * @param         id [in] `lԍ 
 * @param         vfs [in] VFStB[hݒl
 * @param         hfs [in] HFStB[hݒl 
 * @return        void
 * @description   VIDIOnOSIZE WX^ݒ
*/
void AG903_VidPrmSetVIDIOnOSIZE(uint32_t id, uint32_t vfs, uint32_t hfs)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(!(vfs & ~(0xFFF)));
    ASSERT(!(hfs & ~(0xFFF)));

    val = (vfs << AG903_VIDIOn_OSIZE_VFS_POS)
        | (hfs << AG903_VIDIOn_OSIZE_HFS_POS);

    AG903_VIDIOn(id)->OSIZE = val;
}


/**
 * @brief         VIDIOnOSIZE WX^擾
 * @param         id [in] `lԍ 
 * @param         vfs [out] VFStB[h擾l
 * @param         hfs [out] HFStB[h擾l 
 * @return        void
 * @description   VIDIOnOSIZE WX^擾
*/
void AG903_VidPrmGetVIDIOnOSIZE(uint32_t id, uint32_t *vfs, uint32_t *hfs)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(vfs != NULL);
    ASSERT(hfs != NULL);

    val = AG903_VIDIOn(id)->OSIZE;

    *vfs = (val & AG903_VIDIOn_OSIZE_VFS_MSK) >> AG903_VIDIOn_OSIZE_VFS_POS;
    *hfs = (val & AG903_VIDIOn_OSIZE_HFS_MSK) >> AG903_VIDIOn_OSIZE_HFS_POS;
}


/**
 * @brief         VIDIOnSTATE WX^擾
 * @param         id [in] `lԍ 
 * @param         cwt [out] CWTtB[h擾l 
 * @return        void
 * @description   VIDIOnSTATE WX^擾
*/
void AG903_VidPrmGetVIDIOnSTAT(uint32_t id, uint32_t *cwt)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_IO_PORTS);
    ASSERT(cwt != NULL);

    val = AG903_VIDIOn(id)->STAT;

    *cwt = (val & AG903_VIDIOn_STAT_CWT_MSK) >> AG903_VIDIOn_STAT_CWT_POS;
}


/**
 * @brief         VIDCOnMOD WX^ݒ
 * @param         id [in] `lԍ 
 * @param         mod [in] VIDCOnMODݒli[
 * @return        void
 * @description   VIDCOnMOD WX^ݒ
*/
void AG903_VidPrmSetVIDCOnMOD(uint32_t id, VIDPrmParamVIDCOnMOD *mod)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(mod != NULL);
    ASSERT(!(mod->tdmblk & ~(0x1)));
    ASSERT(!(mod->tdmtrs & ~(0x1)));
    ASSERT(!(mod->delay & ~(0x1)));
    ASSERT(!(mod->trsdec & ~(0x1)));

    val = (mod->tdmblk << AG903_VIDCOn_MOD_TDMBLK_POS)
        | (mod->tdmtrs << AG903_VIDCOn_MOD_TDMTRS_POS)
        | (mod->delay  << AG903_VIDCOn_MOD_DELAY_POS)
        | (mod->trsdec << AG903_VIDCOn_MOD_TRSDEC_POS);

    AG903_VIDCOn(id)->MOD = val;
}


/**
 * @brief         VIDCOnMOD WX^擾
 * @param         id [in] `lԍ 
 * @param         mod [out] VIDCOnMOD擾li[
 * @return        void
 * @description   VIDCOnMOD WX^擾
*/
void AG903_VidPrmGetVIDCOnMOD(uint32_t id, VIDPrmParamVIDCOnMOD *mod)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(mod != NULL);

    val = AG903_VIDCOn(id)->MOD;

    mod->tdmblk = (val & AG903_VIDCOn_MOD_TDMBLK_MSK) >> AG903_VIDCOn_MOD_TDMBLK_POS;
    mod->tdmtrs = (val & AG903_VIDCOn_MOD_TDMTRS_MSK) >> AG903_VIDCOn_MOD_TDMTRS_POS;
    mod->delay  = (val & AG903_VIDCOn_MOD_DELAY_MSK)  >> AG903_VIDCOn_MOD_DELAY_POS;
    mod->trsdec = (val & AG903_VIDCOn_MOD_TRSDEC_MSK) >> AG903_VIDCOn_MOD_TRSDEC_POS;
}


/**
 * @brief         VIDCOnTRSPRM WX^ݒ
 * @param         id [in] `lԍ 
 * @param         trsprm [in] VIDCOnTRSPRMݒli[
 * @return        void
 * @description   VIDCOnTRSPRM WX^ݒ
*/
void AG903_VidPrmSetVIDCOnTRSPRM(uint32_t id, VIDPrmParamVIDCOnTRSPRM *trsprm)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(trsprm != NULL);
    ASSERT(!(trsprm->efp  & ~(0x1)));
    ASSERT(!(trsprm->ofp  & ~(0x1)));
    ASSERT(!(trsprm->vfp  & ~(0xFFF)));
    ASSERT(!(trsprm->href & ~(0x1)));
    ASSERT(!(trsprm->hfp  & ~(0xFFF)));

    val = (trsprm->efp  << AG903_VIDCOn_TRSPRM_EFP_POS)
        | (trsprm->ofp  << AG903_VIDCOn_TRSPRM_OFP_POS)
        | (trsprm->vfp  << AG903_VIDCOn_TRSPRM_VFP_POS)
        | (trsprm->href << AG903_VIDCOn_TRSPRM_HREF_POS)
        | (trsprm->hfp  << AG903_VIDCOn_TRSPRM_HFP_POS);

    AG903_VIDCOn(id)->TRSPRM = val;
}


/**
 * @brief         VIDCOnTRSPRM WX^擾
 * @param         id [in] `lԍ 
 * @param         trsprm [out] VIDCOnTRSPRM擾li[
 * @param         efp [out] EFPtB[h擾l 
 * @param         ofp [out] OFPtB[h擾l 
 * @param         vfp [out] VFPtB[h擾l 
 * @param         href [out] HREFtB[h擾l 
 * @param         hfp [out] HFPtB[h擾l 
 * @return        void
 * @description   VIDCOnTRSPRM WX^擾
*/
void AG903_VidPrmGetVIDCOnTRSPRM(uint32_t id, VIDPrmParamVIDCOnTRSPRM *trsprm)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(trsprm != NULL);

    val = AG903_VIDCOn(id)->TRSPRM;

    trsprm->efp  = (val & AG903_VIDCOn_TRSPRM_EFP_MSK)  >> AG903_VIDCOn_TRSPRM_EFP_POS;
    trsprm->ofp  = (val & AG903_VIDCOn_TRSPRM_OFP_MSK)  >> AG903_VIDCOn_TRSPRM_OFP_POS;
    trsprm->vfp  = (val & AG903_VIDCOn_TRSPRM_VFP_MSK)  >> AG903_VIDCOn_TRSPRM_VFP_POS;
    trsprm->href = (val & AG903_VIDCOn_TRSPRM_HREF_MSK) >> AG903_VIDCOn_TRSPRM_HREF_POS;
    trsprm->hfp  = (val & AG903_VIDCOn_TRSPRM_HFP_MSK)  >> AG903_VIDCOn_TRSPRM_HFP_POS;
}


/**
 * @brief         VIDCOnSDPRM WX^ݒ
 * @param         id [in] `lԍ 
 * @param         vmax [in] VMAXtB[hݒl 
 * @param         hmax [in] HMAXtB[hݒl 
 * @return        void
 * @description   VIDCOnSDPRM WX^ݒ
*/
void AG903_VidPrmSetVIDCOnSDPRM(uint32_t id, uint32_t vmax, uint32_t hmax)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(!(vmax & ~(0x1FFF)));
    ASSERT(!(hmax & ~(0x1FFF)));

    val = (vmax << AG903_VIDCOn_SDPRM_VMAX_POS)
        | (hmax << AG903_VIDCOn_SDPRM_HMAX_POS);

    AG903_VIDCOn(id)->SDPRM = val;
}


/**
 * @brief         VIDCOnSDPRM WX^擾
 * @param         id [in] `lԍ 
 * @param         vmax [out] VMAXtB[h擾l 
 * @param         hmax [out] HMAXtB[h擾l 
 * @return        void
 * @description   VIDCOnSDPRM WX^擾
*/
void AG903_VidPrmGetVIDCOnSDPRM(uint32_t id, uint32_t *vmax, uint32_t *hmax)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(vmax != NULL);
    ASSERT(hmax != NULL);

    val = AG903_VIDCOn(id)->SDPRM;

    *vmax = (val & AG903_VIDCOn_SDPRM_VMAX_MSK) >> AG903_VIDCOn_SDPRM_VMAX_POS;
    *hmax = (val & AG903_VIDCOn_SDPRM_HMAX_MSK) >> AG903_VIDCOn_SDPRM_HMAX_POS;
}


/**
 * @brief         VIDCOnSTAT WX^擾
 * @param         id [in] `lԍ 
 * @param         stat [out] VIDCOnSTAT擾li[
 * @return        void
 * @description   VIDCOnSTAT WX^擾
*/
void AG903_VidPrmGetVIDCOnSTAT(uint32_t id, VIDPrmParamVIDCOnSTAT *stat)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(stat != NULL);

    val = AG903_VIDCOn(id)->STAT;

    stat->blkval = (val & AG903_VIDCOn_STAT_BLKVAL_MSK) >> AG903_VIDCOn_STAT_BLKVAL_POS;
    stat->trsval = (val & AG903_VIDCOn_STAT_TRSVAL_MSK) >> AG903_VIDCOn_STAT_TRSVAL_POS;
    stat->vblank = (val & AG903_VIDCOn_STAT_VBLANK_MSK) >> AG903_VIDCOn_STAT_VBLANK_POS;
    stat->hblank = (val & AG903_VIDCOn_STAT_HBLANK_MSK) >> AG903_VIDCOn_STAT_HBLANK_POS;
    stat->tdmch  = (val & AG903_VIDCOn_STAT_TDMCH_MSK)  >> AG903_VIDCOn_STAT_TDMCH_POS;
}


/**
 * @brief         VIDCOnHST0 WX^擾
 * @param         id [in] `lԍ 
 * @param         hpw [out] HPWtB[h擾l 
 * @return        void
 * @description   VIDCOnHST0 WX^擾
*/
void AG903_VidPrmGetVIDCOnHST0(uint32_t id, uint32_t *hpw)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(hpw != NULL);

    val = AG903_VIDCOn(id)->HST0;

    *hpw = (val & AG903_VIDCOn_HST0_HPW_MSK) >> AG903_VIDCOn_HST0_HPW_POS;
}


/**
 * @brief         VIDCOnHST1 WX^擾
 * @param         id [in] `lԍ 
 * @param         hfp [out] HFPtB[h擾l 
 * @param         hbp [out] HBPtB[h擾l 
 * @return        void
 * @description   VIDCOnHST1 WX^擾
*/
void AG903_VidPrmGetVIDCOnHST1(uint32_t id, uint32_t *hfp, uint32_t *hbp)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(hfp != NULL);
    ASSERT(hbp != NULL);

    val = AG903_VIDCOn(id)->HST1;

    *hfp = (val & AG903_VIDCOn_HST1_HFP_MSK) >> AG903_VIDCOn_HST1_HFP_POS;
    *hbp = (val & AG903_VIDCOn_HST1_HBP_MSK) >> AG903_VIDCOn_HST1_HBP_POS;
}


/**
 * @brief         VIDCOnVST0 WX^擾
 * @param         id [in] `lԍ 
 * @param         vst0 [out] VIDCOnVST0擾li[
 * @return        void
 * @description   VIDCOnVST0 WX^擾
*/
void AG903_VidPrmGetVIDCOnVST0(uint32_t id, VIDPrmParamVIDCOnVST0 *vst0)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(vst0 != NULL);

    val = AG903_VIDCOn(id)->VST0;

    vst0->scan = (val & AG903_VIDCOn_VST0_SCAN_MSK) >> AG903_VIDCOn_VST0_SCAN_POS;
    vst0->ebp  = (val & AG903_VIDCOn_VST0_EBP_MSK)  >> AG903_VIDCOn_VST0_EBP_POS;
    vst0->efp  = (val & AG903_VIDCOn_VST0_EFP_MSK)  >> AG903_VIDCOn_VST0_EFP_POS;
    vst0->obp  = (val & AG903_VIDCOn_VST0_OBP_MSK)  >> AG903_VIDCOn_VST0_OBP_POS;
    vst0->ofp  = (val & AG903_VIDCOn_VST0_OFP_MSK)  >> AG903_VIDCOn_VST0_OFP_POS;
    vst0->vpw  = (val & AG903_VIDCOn_VST0_VPW_MSK)  >> AG903_VIDCOn_VST0_VPW_POS;
}


/**
 * @brief         VIDCOnVST1 WX^擾
 * @param         id [in] `lԍ 
 * @param         vfp [out] VFPtB[h擾l 
 * @param         vbp [out] VBPtB[h擾l 
 * @return        void
 * @description   VIDCOnVST1 WX^擾
*/
void AG903_VidPrmGetVIDCOnVST1(uint32_t id, uint32_t *vfp, uint32_t *vbp)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(vfp != NULL);
    ASSERT(vbp != NULL);

    val = AG903_VIDCOn(id)->VST1;

    *vfp = (val & AG903_VIDCOn_VST1_VFP_MSK) >> AG903_VIDCOn_VST1_VFP_POS;
    *vbp = (val & AG903_VIDCOn_VST1_VBP_MSK) >> AG903_VIDCOn_VST1_VBP_POS;
}


/**
 * @brief         VIDCOnFST WX^擾
 * @param         id [in] `lԍ 
 * @param         vfs [out] VFStB[h擾l 
 * @param         hfs [out] HFStB[h擾l 
 * @return        void
 * @description   VIDCOnFST WX^擾
*/
void AG903_VidPrmGetVIDCOnFST(uint32_t id, uint32_t *vfs, uint32_t *hfs)
{
    uint32_t                    val;

    ASSERT(id < AG903_VID_PRM_MAX_CAPTURE_PORTS);
    ASSERT(vfs != NULL);
    ASSERT(hfs != NULL);

    val = AG903_VIDCOn(id)->FST;

    *vfs = (val & AG903_VIDCOn_FST_VFS_MSK) >> AG903_VIDCOn_FST_VFS_POS;
    *hfs = (val & AG903_VIDCOn_FST_HFS_MSK) >> AG903_VIDCOn_FST_HFS_POS;
}
