/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

/* IuWFNg */
static VGPath path;

static VGubyte char_cmd[] = {
    0x02, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 
    0x0c, 0x00, 0x02, 0x04, 0x04, 0x04, 0x00, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
    0x04, 0x00, 0x02, 0x12, 0x12, 0x12, 0x12, 0x00
};

static VGfloat char_coord[] = {
    486.40, 32.75, 487.65, 24.93, 488.49, 16.97, 490.89, 9.39, 
    483.71, 9.39, 476.52, 9.39, 469.33, 9.39, 473.71, 22.15, 
    473.86, 35.81, 475.54, 49.08, 474.10, 54.36, 470.63, 43.46, 
    468.03, 42.11, 463.79, 37.14, 458.09, 33.20, 451.33, 32.97, 
    444.82, 31.96, 437.59, 33.63, 433.39, 39.04, 424.98, 46.72, 
    424.61, 59.95, 429.01, 69.82, 436.00, 86.32, 446.41, 101.10, 
    457.06, 115.41, 464.74, 125.30, 472.43, 135.18, 480.11, 145.06, 
    491.98, 129.63, 504.21, 114.48, 515.76, 98.82, 523.70, 87.11, 
    532.08, 74.69, 533.91, 60.33, 534.83, 51.23, 531.60, 41.36, 
    523.57, 36.29, 515.27, 30.53, 503.52, 32.26, 495.46, 37.57, 
    490.25, 40.45, 487.46, 46.93, 485.22, 51.00, 482.31, 50.46, 
    484.71, 46.55, 484.56, 44.42, 485.17, 40.53, 485.79, 36.64, 
    486.40, 32.75, 286.75, 145.18, 398.70, 145.18, 398.70, 5.67, 
    286.75, 5.67, 262.09, 94.40, 227.39, 56.81, 238.85, 1.06, 
    199.70, 30.93, 161.07, 0.00, 171.57, 56.05, 136.23, 92.69, 
    181.87, 97.46, 198.66, 151.03, 216.37, 97.93, 113.73, 73.85, 
    56.86, 69.20, 0.00, 56.86, 4.65, 56.86, 69.20, 0.00, 
    0.00, 73.85, 56.86, 69.20, 0.00, 56.86, 143.05, 56.86, 
    69.20, 0.00, 113.73, 73.85, 
};

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGPathIuWFNg̐ */
    path = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_F, 1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);

    /* VGPathIuWFNgɌ`f[^o^ */
    vgAppendPathData(path, sizeof(char_cmd), char_cmd, char_coord);

    /* ݂̃}gNXPATH_USER_TO_SURFACEɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_PATH_USER_TO_SURFACE);

    /* s񏉊 */
    vgLoadIdentity();
}


static void DrawWithAntialiasing(void)
{
    /* A`GCAX */
    vgSeti(VG_RENDERING_QUALITY, VG_RENDERING_QUALITY_NONANTIALIASED);
    vgTranslate(50, 10);
    vgDrawPath(path, VG_FILL_PATH);

    /* A`GCAXLij*/
    vgSeti(VG_RENDERING_QUALITY, VG_RENDERING_QUALITY_FASTER);
    vgTranslate(0, 150);
    vgDrawPath(path, VG_FILL_PATH);

    /* A`GCAXLiiʁj*/
    vgSeti(VG_RENDERING_QUALITY, VG_RENDERING_QUALITY_BETTER);
    vgTranslate(0, 150);
    vgDrawPath(path, VG_FILL_PATH);
}

static void TestTerm(void)
{
    vgDestroyPath(path);
}

void AntialiasingMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* pX`揈 */
    DrawWithAntialiasing();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}

