/**
 * @brief       PGP Manager
 * @author      AXELL CORPORATION
 * @description PGP Manager Layer.
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
 * @history     2018_01_24  [SDK2.1] 摜O̐ڂɂG[`FbNƐ̒ǉ (#1773)
 * @history     2018_01_24  [SDK2.1] pCvC̓|[gɎw肷fW^rfI̓|[gnȟ^Ɍ (#1757)
 * @history     2019_12_27  [SDK3.0] PGP̃xO͊֐mۂ\[X֐ǉ (#1951)
 * @history     2024_03_22  [SDK3.6] PGP̃\[XVIDł邱ƂmFƂ̌^LXg̕sC (#4940)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2024 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include <stdio.h>
#include "pgpmgr_common.h"
#include "pgp/pgpprm.h"
#include "via/viamgr.h"
#include "vid/vidmgr.h"

/* ÕReLXg
   nh̏̓nh擾ɍsȂ܂B*/
static PgpMgrContext PgpContext = {
#ifdef AG903_PGP_MGR_TS_FORCE_DISABLE
               false,
#else
               true,
#endif /* AG903_PGP_MGR_TS_FORCE_DISABLE */
               false, 0,
               0, {{0}},
               0, {{0}},
               0, {{0}},
               0, {{0}},
               {NULL}, {NULL}, {NULL}, {NULL},
               {NULL}, {NULL}, {NULL}, {NULL}, {NULL}, {NULL}, {NULL}, {NULL}, {NULL}, {NULL}, {NULL}, {NULL},
               {0},
};

/*
 * @brief   Manager Layer̃ReLXg擾܂BManager LayerŎgp֐łB
 * @param   none
 * @return  ReLXg̃|C^
 * @note    {֐̓[U[ڎgp邱Ƃ͂܂B
*/
PgpMgrContext *PgpGetContext(void)
{
    return &PgpContext;
}


/* FԌW̃}XNl */
#define CSC_MUL_MASK        0xFFF
#define CSC_ADD_MASK        0xFFFFF
/* ԃtB^̃}XNl */
#define SPF1_COEFF_MASK     0xFF
#define SPF1_OFFSET_MASK    0x1FF
/* 臒l̃}XNp[^̗Lrbg̃}XNl */
#define THR_MSK_L_MASK      0x1
#define THR_MSK_H_MASK      0x1
#define THR_MSK_X_MASK      0x1
#define THR_MSK_HMAX_MASK   0xFF
#define THR_MSK_HMIN_MASK   0xFF
#define THR_MSK_LMAX_MASK   0xFF
#define THR_MSK_LMIN_MASK   0xFF
/* 臒l8bit臒lp[^̗Lrbg̃}XNl */
#define THR_8THR_MAXV_MASK  0xFF
#define THR_8THR_MAXTH_MASK 0xFF
#define THR_8THR_MINTH_MASK 0xFF
/* 臒l1bitԃtB^p[^̗Lrbg̃}XNl */
#define THR_SPF1_COEFF_MASK 0x1
#define THR_SPF1_THR_MASK   0x3F
/* t[ԉZɂQC̗Lrbg̃}XNl */
#define IFC_GAIN_MASK       0xFF

#ifndef AG903_PGP_MGR_TS_FORCE_DISABLE

/**
 * @brief         O̗̎Lw
 * @param         enable [in] ̗Lw肵܂B
 * @return        w茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL ɃpCvCnh擾ꂽԂŗL؂ւꍇ
 * @description   pCvC̗̎L/ݒ肵܂B
 * @note          SẴpCvCnhAVRAM̓nhꂽԂŎsĂB<p>
 *                s̏ꍇAAG903_PGP_MGR_TS_FORCE_DISABLE ݒ肳Ăꍇ͐ݒ肵܂B <p>
 *                _ł́A(AG903_PGP_MGR_TS_FORCE_DISABLE)ŎgpĉB
*/
int32_t AG903_PgpMgrEnableTimeSharingPipeline(_Bool enable)
{
    if ((PgpContext.num_pipeline_handles != 0) ||
        (PgpContext.num_vram_input_handles != 0) ||
        (PgpContext.num_frame_calc_handles != 0) ||
        (PgpContext.num_dgc_lut != 0)) {
        return -AG903_EINVAL;
    }

    PgpContext.pipeline_time_sharing_enable = enable;

    return AG903_ENONE;
}
#endif /* AG903_PGP_MGR_TS_FORCE_DISABLE */


/**
 * @brief         w萔̃pCvCnh擾
 * @param         num [in] 擾pCvCnh̐w肵܂B
 * @param         handles [out] 擾pCvCnhi[|C^w肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL numɎw肵ƁA擾ς̃pCvCnh̍vlőnh𒴂ꍇ<p>handlesNULLw肳ꂽꍇ
 * @description   pCvCnh擾܂B
 * @note          none
*/
int32_t AG903_PgpMgrGetPipelineHandle(int32_t num, AG903_PgpMgrPipelineHandle **handles)
{
    int i, j;

    /* LAɂ擾\ȍőnh͈ق܂ */
    if (PgpContext.pipeline_time_sharing_enable == true) {
        if ((num + PgpContext.num_pipeline_handles) > AG903_PGP_MGR_MAX_PIPELINE_HANDLE) {
            return -AG903_EINVAL;
        }
    } else {
        if ((num + PgpContext.num_pipeline_handles) > AG903_PGP_MGR_PIPELINE_NUM) {
            return -AG903_EINVAL;
        }
    }

    if (handles == NULL) {
        return -AG903_EINVAL;
    }

    /* gp\ȃpCvCnhAhandlesɊi[܂ */
    for (i = 0; i < num; i++) {
        for (j = 0; j < AG903_PGP_MGR_MAX_PIPELINE_HANDLE; j++) {
            if (PgpContext.pipeline_handles[j].is_used == false) {
                /* nh̐ݒl܂B */
                PgpMgrInitPipelineHandle(&PgpContext.pipeline_handles[j]);

                PgpContext.pipeline_handles[j].is_used = true;
                PgpContext.pipeline_handles[j].id = AG903_PGP_MGR_PIPELINE_HANDLE_ID;
                handles[i] = &PgpContext.pipeline_handles[j];
                break;
            }
        }
    }

    /* pCvCnh0ω^C~OŊ荞݃nh̐ݒsȂ܂ */
    if (PgpContext.num_pipeline_handles == 0) {
        PgpMgrSetIntr();
    }
    PgpContext.num_pipeline_handles += num;
    return AG903_ENONE;
}


/**
 * @brief         pCvCnh̉
 * @param         handle [in] pCvCnhw肵܂B
 * @return        
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>w肳ꂽpCvCnhݎs̏ꍇ
 * @description   w肳ꂽpCvCnh܂B
 * @note          none
*/
int32_t AG903_PgpMgrReleasePipelineHandle(AG903_PgpMgrPipelineHandle *handle)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }
    /* pCvCnht[ԉZ̃}X^AX[uɎw肳Ăꍇ̓G[Ƃ܂ */
    if (handle->is_used_frame_calc == true) {
        return -AG903_EINVAL;
    }

    /* pCvC̊蓖ĂsȂĂꍇɈȉ̏sȂ܂ */
    if (handle->pipeline_no != -1) {
        /* pCvCnhgpł̏ꍇ̓G[Ƃ܂ */
        if (PgpContext.exec_pipeline[handle->pipeline_no] == handle) {
            PGPPrmParamPGPnSTATE state;
            AG903_PgpPrmGetPGPnSTATE(handle->pipeline_no, &state);
            if (state.st != AG903_PGP_MGR_STATE_IDLE) {
                return -AG903_EBUSY;
            }
            PgpContext.exec_pipeline[handle->pipeline_no] = NULL;
        }
        if (PgpContext.assign_pipeline[handle->pipeline_no] == handle) {
            PgpContext.assign_pipeline[handle->pipeline_no] = NULL;
        }
    }
    if (handle->input_handle != NULL) {
        AG903_PgpMgrVRAMInputHandle *vram_handle = (AG903_PgpMgrVRAMInputHandle *)handle->input_handle;
        /* ̓\[XVRAM͂̏ꍇɃt@XJEgfNg܂ */
        if (vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
            vram_handle->ref_cnt--;
            /* 얳At@XJEg0AVRAM͂蓖čς̏ꍇ͊蓖Ă܂ */
            if (PgpContext.pipeline_time_sharing_enable == false) {
                if ((vram_handle->ref_cnt == 0) && (vram_handle->port_no != -1)) {
                    if (PgpContext.assign_vram[vram_handle->port_no] == vram_handle) {
                        PgpContext.assign_vram[vram_handle->port_no] = NULL;
                    }
                }
            }
        }
    }
    /* Zxϊe[u֘AtĂꍇAZxϊe[ũt@XJEgfNg܂ */
    if (handle->dgc_lut != NULL) {
        handle->dgc_lut->ref_cnt--;
    }
    handle->is_used = false;
    handle->id = 0;
    PgpContext.num_pipeline_handles--;

    /* pCvCnhSĔjꂽ^C~OŊ荞݃nh̐ݒZbg܂ */
    if (PgpContext.num_pipeline_handles == 0) {
        PgpMgrResetIntr();
    }
    return AG903_ENONE;
}


/**
 * @brief         pCvCnh܂̓t[ԉZnh𕨗IȃpCvCɊ蓖
 * @param         handle [in] 蓖ĂsȂpCvCnh܂̓t[ԉZnhw肵܂B
 * @return        pCvCԍA̓G[
 * @retval        pCvCԍ 蓖Đ
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>蓖ĂɎsꍇ<p>̓\[Xݒ̃nhw肳ꂽꍇ
 * @description   w肳ꂽpCvCnhA܂̓t[ԉZnh̐ݒlmFĎs\ȃpCvC蓖Ă܂B <p>
 *                pCvC̊蓖ẮAu[ۑpCvCv > u͉摜pCvCv >
 *                uZpCvCv̏ɍs܂B<p>
 *                ڂ́uPGPpCvCԍvQƂĂB<p>
 *                ̓\[XVRAM̏ꍇ́AVRAM͂̊蓖Ăs܂B<p>VRAM̃|[g2{܂̂ŁA󂢂Ă|[gATC܂B<p>
 *                w肳ꂽnht[ԉZnh̏ꍇA}X^/X[uŏقȂ܂B<p>
 *                }X^ : ʏ̃pCvC蓖Ăs܂B<p>
 *                X[u : KZpCvC蓖Ă܂B<p>
 *                ܂AX[uVRAM͂̏ꍇ́A}X^̃pCvCnh̊蓖Ăɂ茈肳܂B
 * @note          얳͓pCvCɑ΂ĕ̃nh蓖Ă邱Ƃ͏o܂B
*/
int32_t AG903_PgpMgrAssignPipeline(void *handle)
{
    uint32_t id;

    if (handle == NULL) {
        return -AG903_EINVAL;
    }

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    id = ((AG903_PgpMgrPipelineHandle *)handle)->id;
    if ((id != AG903_PGP_MGR_PIPELINE_HANDLE_ID) && (id != AG903_PGP_MGR_FRAME_CALC_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    if (id == AG903_PGP_MGR_PIPELINE_HANDLE_ID) {
        AG903_PgpMgrPipelineHandle *p = (AG903_PgpMgrPipelineHandle *)handle;
        /* Ɋ蓖čς̏ꍇ͏I܂ */
        if (p->is_assign == true) {
            return -AG903_EINVAL;
        }
        /* ̓\[Xݒ̏ꍇG[Ƃ܂ */
        if (p->input_handle == NULL) {
            return -AG903_EINVAL;
        }
        /* pCvCnh̊蓖ĂsȂ܂ */
        return PgpMgrAssignPipelineHandle(p);
    } else {
        AG903_PgpMgrFrameCalcHandle *f = (AG903_PgpMgrFrameCalcHandle *)handle;
        /* Ɋ蓖čς̏ꍇ͏I܂(蓖Ă̓}X^AX[uɍsȂ邽߃}X^ŊmF܂) */
        if (f->master_handle->is_assign == true) {
            return -AG903_EINVAL;
        }
        /* }X^pCvCnh̓̓\[Xݒ̏ꍇG[Ƃ܂ */
        if (f->master_handle->input_handle == NULL) {
            return -AG903_EINVAL;
        }
        /* X[upCvCnh̏ꍇA̓\[Xݒ̏ꍇG[Ƃ܂ */
        if (f->slave_pipeline == true) {
            AG903_PgpMgrPipelineHandle *slave = (AG903_PgpMgrPipelineHandle *)f->slave_handle;
            if (slave->input_handle == NULL) {
                return -AG903_EINVAL;
            }
        }
        /* t[ԉZnh̊蓖ĂsȂ܂ */
        return PgpMgrAssignFrameCalcHandle(f);
    }
}


/**
 * @brief         pCvCnh܂̓t[ԉZnhw肵pCvCɋ蓖
 * @param         handle [in] 蓖ĂsȂpCvCnh܂̓t[ԉZnhw肵܂B
 * @param         pipeline [in] 蓖Đ PGPpCvCԍ w肵܂B
 * @return        PGPpCvCԍA̓G[
 * @retval        PGPpCvCԍ 蓖Đ
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>蓖ĂɎsꍇ<p>̓\[Xݒ̃nhw肳ꂽꍇ<p>pipelineɕsȒlw肳ꂽꍇ
 * @description   w肳ꂽpCvCɑ΂ăpCvCnhA܂̓t[ԉZnhIɊ蓖Ă܂B
 * @note          w肵pCvCɑ̃nh蓖čς̏ꍇ͊蓖ĎsƔ肳܂B<p>
 *                pCvCnh̐ݒ肪蓖Đ̃pCvCŎs\ł邩̃`FbN͍sȂ܂B<p>
 *                炩 AG903_PgpMgrCheckFunctionValidation ֐ɂĎs\ł邩`FbNĉB
*/
int32_t AG903_PgpMgrForceAssignPipeline(void *handle, uint32_t pipeline)
{
    uint32_t id;

    if (handle == NULL) {
        return -AG903_EINVAL;
    }
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    id = ((AG903_PgpMgrPipelineHandle *)handle)->id;
    if ((id != AG903_PGP_MGR_PIPELINE_HANDLE_ID) && (id != AG903_PGP_MGR_FRAME_CALC_HANDLE_ID)) {
        return -AG903_EINVAL;
    }
    switch (pipeline) {
        case AG903_PGP_MGR_CALC_PIPELINE0:
        case AG903_PGP_MGR_CALC_PIPELINE1:
        case AG903_PGP_MGR_INPUT_PIPELINE0:
        case AG903_PGP_MGR_INPUT_PIPELINE1:
        case AG903_PGP_MGR_FRAME_PIPELINE0:
        case AG903_PGP_MGR_FRAME_PIPELINE1:
            break;
        default:
            return -AG903_EINVAL;
    }

    if (id == AG903_PGP_MGR_PIPELINE_HANDLE_ID) {
        AG903_PgpMgrPipelineHandle *p = (AG903_PgpMgrPipelineHandle *)handle;
        /* Ɋ蓖čς̏ꍇ͏I܂ */
        if (p->is_assign == true) {
            return -AG903_EINVAL;
        }
        /* ̓\[Xݒ̏ꍇG[Ƃ܂ */
        if (p->input_handle == NULL) {
            return -AG903_EINVAL;
        }
        /* t[ԉZnhƂĎgpĂꍇG[Ƃ܂ */
        if (p->is_used_frame_calc == true) {
            return -AG903_EINVAL;
        }
        /* pCvCnh̊蓖ĂsȂ܂ */
        return PgpMgrForceAssignPipelineHandle(p, pipeline);
    } else {
        AG903_PgpMgrFrameCalcHandle *f = (AG903_PgpMgrFrameCalcHandle *)handle;
        /* Ɋ蓖čς̏ꍇ͏I܂(蓖Ă̓}X^AX[uɍsȂ邽߃}X^ŊmF܂) */
        if (f->master_handle->is_assign == true) {
            return -AG903_EINVAL;
        }
        /* }X^pCvCnh̓̓\[Xݒ̏ꍇG[Ƃ܂ */
        if (f->master_handle->input_handle == NULL) {
            return -AG903_EINVAL;
        }
        /* X[upCvCnh̏ꍇA̓\[Xݒ̏ꍇG[Ƃ܂ */
        if (f->slave_pipeline == true) {
            AG903_PgpMgrPipelineHandle *slave = (AG903_PgpMgrPipelineHandle *)f->slave_handle;
            if (slave->input_handle == NULL) {
                return -AG903_EINVAL;
            }
        }
        /* t[ԉZnh̊蓖ĂsȂ܂ */
        return PgpMgrForceAssignFrameCalcHandle(f, pipeline);
    }
}


/**
 * @brief         pCvCnh̕pCvCɑ΂銄蓖ĉ
 * @param         handle [in]  蓖ĂpCvCnh܂̓t[ԉZnhw肵܂B
 * @return        
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>蓖đÕnhw肳ꂽꍇ<p>w肳ꂽpCvCnhݎs̏ꍇ
 * @description   w肵pCvCnhA܂̓t[ԉZnh̕pCvC̊蓖Ă܂B
 * @note          w肵pCvCnh̓̓\[X̐ݒ܂B<p>
 *                ēx蓖ĂsȂꍇ AG903_PgpMgrSetInputPort ֐œ̓\[Xw肵ĉB
*/
int32_t AG903_PgpMgrReleaseAssignment(void *handle)
{
    uint32_t id;
    AG903_PgpMgrVRAMInputHandle *vram_handle;

    if (handle == NULL) {
        return -AG903_EINVAL;
    }
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    id = ((AG903_PgpMgrPipelineHandle *)handle)->id;
    if ((id != AG903_PGP_MGR_PIPELINE_HANDLE_ID) && (id != AG903_PGP_MGR_FRAME_CALC_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    if (id == AG903_PGP_MGR_PIPELINE_HANDLE_ID) {
        AG903_PgpMgrPipelineHandle *p = (AG903_PgpMgrPipelineHandle *)handle;
        /* 蓖đȌꍇ̓G[Ƃ܂ */
        if (p->is_assign == false) {
            return -AG903_EINVAL;
        }
        if (PgpContext.exec_pipeline[p->pipeline_no] == p) {
            /* ݎs̏ꍇ̓G[Ƃ܂ */
            PGPPrmParamPGPnSTATE state;
            AG903_PgpPrmGetPGPnSTATE(p->pipeline_no, &state);
            if (state.st != AG903_PGP_MGR_STATE_IDLE) {
                return -AG903_EBUSY;
            }
            PgpContext.exec_pipeline[p->pipeline_no] = NULL;
        }
        /* 蓖ĉ̏Ԃɐݒ肵܂ */
        if (PgpContext.assign_pipeline[p->pipeline_no] == handle) {
            PgpContext.assign_pipeline[p->pipeline_no] = NULL;
        }
        /* ̓\[XVRAM͂̏ꍇɃt@XJEgfNg܂ */
        vram_handle = (AG903_PgpMgrVRAMInputHandle *)p->input_handle;
        if ((vram_handle != NULL) && (vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
            vram_handle->ref_cnt--;
        }
        p->is_assign = false;
        p->pipeline_no = -1;
        p->input_handle = NULL;
    } else {
        AG903_PgpMgrFrameCalcHandle *f = (AG903_PgpMgrFrameCalcHandle *)handle;
        AG903_PgpMgrPipelineHandle *master = (AG903_PgpMgrPipelineHandle *)f->master_handle;
        AG903_PgpMgrPipelineHandle *slave = (AG903_PgpMgrPipelineHandle *)f->slave_handle;
        /* 蓖đȌꍇ̓G[Ƃ܂(蓖Ă̓}X^AX[uɍsȂ邽߃}X^ŊmF܂) */
        if (master->is_assign == false) {
            return -AG903_EINVAL;
        }
        if (PgpContext.exec_pipeline[master->pipeline_no] == master) {
            /* ݎs̏ꍇ̓G[Ƃ܂ */
            PGPPrmParamPGPnSTATE state;
            AG903_PgpPrmGetPGPnSTATE(master->pipeline_no, &state);
            if (state.st != AG903_PGP_MGR_STATE_IDLE) {
                return -AG903_EBUSY;
            }
            PgpContext.exec_pipeline[master->pipeline_no] = NULL;
        }
        /* 蓖ĉ̏Ԃɐݒ肵܂ */
        if (PgpContext.assign_pipeline[master->pipeline_no] == master) {
            PgpContext.assign_pipeline[master->pipeline_no] = NULL;
        }
        /* ̓\[XVRAM͂̏ꍇɃt@XJEgfNg܂ */
        vram_handle = (AG903_PgpMgrVRAMInputHandle *)master->input_handle;
        if ((vram_handle != NULL) && (vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
            vram_handle->ref_cnt--;
        }
        master->is_assign = false;
        master->pipeline_no = -1;
        master->input_handle = NULL;
        /* X[upCvCnh̏ꍇAX[ů蓖Ă܂ */
        if (slave->id == AG903_PGP_MGR_PIPELINE_HANDLE_ID) {
            if (PgpContext.assign_pipeline[slave->pipeline_no] == slave) {
                PgpContext.assign_pipeline[slave->pipeline_no] = NULL;
            }
            if (PgpContext.exec_pipeline[slave->pipeline_no] == slave) {
                PgpContext.exec_pipeline[slave->pipeline_no] = NULL;
            }
            /* ̓\[XVRAM͂̏ꍇɃt@XJEgfNg܂ */
            vram_handle = (AG903_PgpMgrVRAMInputHandle *)slave->input_handle;
            if ((vram_handle != NULL) && (vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
               vram_handle->ref_cnt--;
            }
            slave->is_assign = false;
            slave->pipeline_no = -1;
            slave->input_handle = NULL;
        }
    }

    return AG903_ENONE;
}


/**
 * @brief         pCvCnhw肵pCvCւ̊蓖ĉۃ`FbN
 * @param         handle [in] `FbNpCvCnhw肵܂B
 * @param         pipeline [in] 蓖Đ PGPpCvCԍ w肵܂B
 * @return        `FbN
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>蓖ĕs\ȏꍇ<p>pipelineɕsȒlw肳ꂽꍇ
 * @description   w肳ꂽpCvCnhAw肳ꂽpCvCŏ\ǂ`FbN܂B
*/
int32_t AG903_PgpMgrCheckFunctionValidation(AG903_PgpMgrPipelineHandle *handle, uint32_t pipeline)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (pipeline) {
        case AG903_PGP_MGR_CALC_PIPELINE0:
        case AG903_PGP_MGR_CALC_PIPELINE1:
        case AG903_PGP_MGR_INPUT_PIPELINE0:
        case AG903_PGP_MGR_INPUT_PIPELINE1:
        case AG903_PGP_MGR_FRAME_PIPELINE0:
        case AG903_PGP_MGR_FRAME_PIPELINE1:
            break;
        default:
            return -AG903_EINVAL;
    }

    return PgpMgrCheckAssignPipelineHandle(handle, pipeline);
}


/**
 * @brief         pCvC̎s
 * @param         handle [in] spCvCnh܂̓t[ԉZnhw肵܂B
 * @param         cmd [in] PGPpCvCR}h w肵܂B
 * @return        s
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>cmdɕsȒlw肳ꂽꍇ<p>pCvCIȃpCvCɊ蓖ĂĂȂꍇ
 * @retval        -AG903_EBUSY ̃pCvCnhspCvCŌݏ̏ꍇ<p>pCvC̃R}hL[ɋ󂫂ꍇAR}h󂯂Ԃł͖ꍇ
 * @description   pCvC̎ss܂B <p>
 *                ȉ̃G[`FbN薳ꍇAs܂B<p>
 *                E蓖ĂsĂȂpCvCnhw肳Ă邩ǂ<p>
 *                Et[ԉZnh̏ꍇ́A}X^̃pCvCnhƃX[upCvCnhɊ蓖ĂĂ邩<p>
 *                EspCvCݏǂ<p>
 *                E1VbgR}h̏ꍇApCvC̃R}hL[ɋ󂫂邩ǂ
 * @note          ̓\[XVRAM͂̏ꍇA{֐s AG903_PgpMgrExecVRAMInput ֐sĂB<p>
 *                qXgOgpꍇA{֐sO AG903_PgpMgrExecHistogram ֐sĂB<p>
 *                xOgpꍇA{֐sO AG903_PgpMgrExecLabeling ֐sĂB
*/
int32_t AG903_PgpMgrExecPipeline(void *handle, uint32_t cmd)
{
    uint32_t id;

    if (handle == NULL) {
        return -AG903_EINVAL;
    }

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    id = ((AG903_PgpMgrPipelineHandle *)handle)->id;
    if ((id != AG903_PGP_MGR_PIPELINE_HANDLE_ID) && (id != AG903_PGP_MGR_FRAME_CALC_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    switch (cmd) {
        case AG903_PGP_MGR_CMD_NONE:
        case AG903_PGP_MGR_CMD_EXEC:
        case AG903_PGP_MGR_CMD_EXEC_CONTINUE:
        case AG903_PGP_MGR_CMD_TRIG:
        case AG903_PGP_MGR_CMD_TRIG_CONTINUE:
        case AG903_PGP_MGR_CMD_IDLE:
        case AG903_PGP_MGR_CMD_RESET_TIMESTAMP_CNT:
        case AG903_PGP_MGR_CMD_RESET_FRAME_CNT:
        case AG903_PGP_MGR_CMD_RESET_INTR_CNT:
        case AG903_PGP_MGR_CMD_FORCE_QUIT:
            break;
        default:
            return -AG903_EINVAL;
    }

    if (id == AG903_PGP_MGR_PIPELINE_HANDLE_ID) {
        AG903_PgpMgrPipelineHandle *p = (AG903_PgpMgrPipelineHandle *)handle;
        /* 蓖đȌꍇ̓G[Ƃ܂ */
        if (p->is_assign == false) {
            return -AG903_EINVAL;
        }
        /* pCvCs܂ */
        return PgpMgrExecPipelineHandle(p, cmd);
    } else {
        AG903_PgpMgrFrameCalcHandle *f = (AG903_PgpMgrFrameCalcHandle *)handle;
        AG903_PgpMgrPipelineHandle *master = (AG903_PgpMgrPipelineHandle *)f->master_handle;
        /* 蓖đȌꍇ̓G[Ƃ܂(蓖Ă̓}X^AX[uɍsȂ邽߃}X^ŊmF܂) */
        if (master->is_assign == false) {
            return -AG903_EINVAL;
        }
        /* pCvCs܂ */
        return PgpMgrExecFrameCalcHandle(f, cmd);
    }
}


/**
 * @brief         荞݂̃R[obN֐o^
 * @param         handle [in] 荞ݓo^pCvCnhw肵܂B
 * @param         type [in] uPGP荞ݎʁvw肵܂B
 * @param         func [in] R[obN֐w肵܂B
 * @return        o^
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>typeɕsȒlw肳ꂽꍇ
 * @description   pCvC̎sʂ󂯂邽߂̃R[obN֐o^܂B<p>
 *                ܂Afunc=NULL w肷邱ƂŃR[obN֐̍폜s܂B
*/
int32_t AG903_PgpMgrSetIntrCallbackFunc(AG903_PgpMgrPipelineHandle *handle, uint32_t type, void (*func)(int32_t id, void *handle))
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    switch (type) {
        case AG903_PGP_MGR_INTR_INPUT:
            handle->intr_vsynci_enable = (func == NULL) ? false : true;
            handle->intr_input_func = func;
            break;
        case AG903_PGP_MGR_INTR_OUTPUT:
            handle->intr_vsynco_enable = (func == NULL) ? false : true;
            handle->intr_output_func = func;
            break;
        case AG903_PGP_MGR_INTR_DONE:
            handle->intr_vsynco_enable = (func == NULL) ? false : true;
            handle->intr_done_func = func;
            break;
        case AG903_PGP_MGR_INTR_VRAM_ERROR:
            handle->intr_voicpl_enable = handle->intr_vooflw_enable = (func == NULL) ? false : true;
            handle->intr_vram_error_func = func;
            break;
        case AG903_PGP_MGR_INTR_LBL_ERROR:
            handle->intr_lblcrpt_enable = (func == NULL) ? false : true;
            handle->intr_lbl_error_func = func;
            break;
        case AG903_PGP_MGR_INTR_HGM_ERROR:
            handle->intr_hgmicpl_enable = (func == NULL) ? false : true;
            handle->intr_hgm_error_func = func;
            break;
        case AG903_PGP_MGR_INTR_ND:
            handle->intr_nd_enable = (func == NULL) ? false : true;
            handle->intr_nd_func = func;
            break;
        case AG903_PGP_MGR_INTR_IFC_OVF:
            handle->intr_ifcofs_enable = handle->intr_ifcofm_enable = (func == NULL) ? false : true;
            handle->intr_ifc_ovf_func = func;
            break;
        case AG903_PGP_MGR_INTR_INPUT_LINE:
            handle->intr_vlinei_enable = (func == NULL) ? false : true;
            handle->intr_input_line_func = func;
            break;
        case AG903_PGP_MGR_INTR_OUTPUT_LINE:
            handle->intr_vlineo_enable = (func == NULL) ? false : true;
            handle->intr_output_line_func = func;
            break;
        case AG903_PGP_MGR_INTR_LBL_DONE:
            handle->intr_lblcpl_enable = (func == NULL) ? false : true;
            handle->intr_lbl_done_func = func;
            break;
        case AG903_PGP_MGR_INTR_HGM_DONE:
            handle->intr_hgmcpl_enable = (func == NULL) ? false : true;
            handle->intr_hgm_done_func = func;
            break;
        default:
            return -AG903_EINVAL;
    }

    handle->is_dirty = true;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_INTR_ENABLE] = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̓o͊荞ݐݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         input_field [in] ͊荞݂ɂVSYNC荞݂o͂tB[huPGPtB[hvw肵܂B
 * @param         input_fcnt [in] ͊荞݂ɂt[JE^̍őlw肵܂B
 * @param         input_line [in] ͊荞݂ɂ郉C荞ݔ̃Cԍw肵܂B
 * @param         output_field [in] o͊荞݂ɂVSYNC荞݂o͂tB[huPGPtB[hvw肵܂B
 * @param         output_fcnt [in] o͊荞݂ɂt[JE^̍őlw肵܂B
 * @param         output_line [in] o͊荞݂ɂ郉C荞ݔ̃Cԍw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL
 *                handleɕsȒlw肳ꂽꍇ<p>input_fieldɕsȒlw肳ꂽꍇ<p>input_fcntɕsȒlw肳ꂽꍇ<p>
 *                input_lineɕsȒlw肳ꂽꍇ<p>output_fieldɕsȒlw肳ꂽꍇ<p>output_fcntɕsȒlw肳ꂽꍇ<p>output_lineɕsȒlw肳ꂽꍇ
 * @description   pCvC̓o݂͊̏ݒs܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>w\͈</th></tr>
 *                <tr><td>input_field</td><td>PGPtB[h</td></tr>
 *                <tr><td>input_fcnt</td><td>1 ~ AG903_PGP_MGR_INTR_CTRL_MAX_FRAME_CNT</td></tr>
 *                <tr><td>input_line</td><td>1 ~ AG903_PGP_MGR_INTR_CTRL_MAX_INPUT_LINE</td></tr>
 *                <tr><td>output_field</td><td>PGPtB[h</td></tr>
 *                <tr><td>output_fcnt</td><td>1 ~ AG903_PGP_MGR_INTR_CTRL_MAX_FRAME_CNT</td></tr>
 *                <tr><td>output_line</td><td>1 ~ AG903_PGP_MGR_INTR_CTRL_MAX_OUTPUT_LINE</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigIntrCtrl(AG903_PgpMgrPipelineHandle *handle, uint32_t input_field, uint32_t input_fcnt, uint32_t input_line, uint32_t output_field, uint32_t output_fcnt, uint32_t output_line)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (input_field) {
        case AG903_PGP_MGR_INTR_CTRL_FIELD_ODD:
        case AG903_PGP_MGR_INTR_CTRL_FIELD_EVEN:
        case AG903_PGP_MGR_INTR_CTRL_FIELD_ODD_EVEN:
            break;
        default:
            return -AG903_EINVAL;
    }
    if ((input_fcnt == 0) || (input_fcnt > AG903_PGP_MGR_INTR_CTRL_MAX_FRAME_CNT)) {
        return -AG903_EINVAL;
    }
    if (input_line > AG903_PGP_MGR_INTR_CTRL_MAX_INPUT_LINE) {
        return -AG903_EINVAL;
    }
    switch (output_field) {
        case AG903_PGP_MGR_INTR_CTRL_FIELD_ODD:
        case AG903_PGP_MGR_INTR_CTRL_FIELD_EVEN:
        case AG903_PGP_MGR_INTR_CTRL_FIELD_ODD_EVEN:
            break;
        default:
            return -AG903_EINVAL;
    }
    if ((output_fcnt == 0) || (output_fcnt > AG903_PGP_MGR_INTR_CTRL_MAX_FRAME_CNT)) {
        return -AG903_EINVAL;
    }
    if (output_line > AG903_PGP_MGR_INTR_CTRL_MAX_OUTPUT_LINE) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_intr_field = input_field;
    handle->input_intr_fcnt = input_fcnt;
    handle->input_intr_line = input_line;
    handle->output_intr_field = output_field;
    handle->output_intr_fcnt = output_fcnt;
    handle->output_intr_line = output_line;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_INTR_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̃Xe[^X擾
 * @param         handle [in] pCvCnhw肵܂B
 * @param         blank [out] VBLANK ̓͒li[|C^w肵܂B
 * @param         is_vram_out [out] VRAM o͒ł邱ƂtOi[|C^w肵܂B
 * @param         queue_cnt [out] L[ɗ߂R}hi[|C^w肵܂B
 * @param         sub_status [out] pCvC̃TuXe[^Xi[|C^w肵܂B
 * @param         status [out] pCvČݎsR}hi[|C^w肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>pCvCIɊ蓖ĂĂȂꍇ<p>蓖Đ̕pCvC̃pCvCnhɂĎgpĂꍇ
 * @description   pCvC̃Xe[^X擾܂B<p>
 *                ڂ́uPGPXe[^XvQƂĂB
 * @note          NULL w肳ꂽɑ΂ăXe[^Xl̎擾͍sȂ܂B
*/
int32_t AG903_PgpMgrGetPipelineStatus(AG903_PgpMgrPipelineHandle *handle, uint32_t *blank, _Bool *is_vram_out, uint32_t *queue_cnt, uint32_t *sub_status, uint32_t *status)
{
    PGPPrmParamPGPnSTATE state;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }
    /* pCvC̊蓖ĂĂȂꍇ̓G[Ƃ܂ */
    if (handle->is_assign != true) {
        return -AG903_EINVAL;
    }

    /* Primitive Layerl[h܂ [hlAG903_PGP_MGR_STATE_IDLEƓlw܂ */
    AG903_PgpPrmGetPGPnSTATE(handle->pipeline_no, &state);

    /* 蓖Đ̕pCvC̃pCvCnhɎgpĂꍇ̓G[Ƃ܂ */
    if ((PgpContext.exec_pipeline[handle->pipeline_no] != handle) && (state.st != AG903_PGP_MGR_STATE_IDLE)) {
        return -AG903_EINVAL;
    }
    /* NULLȊÖ̂ݒli[܂ */
    if (blank != NULL) {
        *blank = state.blank;
    }
    if (is_vram_out != NULL) {
        *is_vram_out = state.vrmacc;
    }
    if (queue_cnt != NULL) {
        *queue_cnt = state.queue;
    }
    if (sub_status != NULL) {
        *sub_status = state.sst;
    }
    if (status != NULL) {
        *status = state.st;
    }
    return AG903_ENONE;
}


/**
 * @brief         rfÍAt[o̓gK̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         vlinei_enable [in] rfI͂̃CgK̗L/w肵܂B
 * @param         vsynci_enable [in] rfI͂̐gK̗L/w肵܂B
 * @param         vlineo_enable [in] t[o͂̃CgK̗L/w肵܂B
 * @param         vsynco_enable [in] t[o͂̐gK̗L/w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   rfÍAt[o̓gK̗L/̐ݒs܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamTrigCtrl(AG903_PgpMgrPipelineHandle *handle, _Bool vlinei_enable, _Bool vsynci_enable, _Bool vlineo_enable, _Bool vsynco_enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->trig_vlinei_enable = vlinei_enable;
    handle->trig_vsynci_enable = vsynci_enable;
    handle->trig_vlineo_enable = vlineo_enable;
    handle->trig_vsynco_enable = vsynco_enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         rfÍAt[o̓gKݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         input_field [in] rfI̓gKɂVSYNCgKo͂tB[hw肵܂B
 * @param         input_fcnt [in] rfI̓gKɂt[JE^̍őlw肵܂B
 * @param         input_line [in] rfI̓gKɂ郉C荞ݔ̃Cԍw肵܂B
 * @param         output_field [in] t[o̓gKɂVSYNCgKo͂tB[hw肵܂B
 * @param         output_fcnt [in] t[o̓gKɂt[JE^̍őlw肵܂B
 * @param         output_line [in] t[o̓gKɂ郉C荞ݔ̃Cԍw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>
 *                input_fieldɕsȒlw肳ꂽꍇ<p>input_fcntɕsȒlw肳ꂽꍇ<p>input_lineɕsȒlw肳ꂽꍇ<p>
 *                output_fieldɕsȒlw肳ꂽꍇ<p>output_fcntɕsȒlw肳ꂽꍇ<p>output_lineɕsȒlw肳ꂽꍇ
 * @description   rfÍAt[o̓gK̏ݒs܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>w\͈</th></tr>
 *                <tr><td>input_field</td><td>PGPgK</td></tr>
 *                <tr><td>input_fcnt</td><td>1 ~ AG903_PGP_MGR_TRIG_CTRL_MAX_FRAME_CNT</td></tr>
 *                <tr><td>input_line</td><td>1 ~ AG903_PGP_MGR_TRIG_CTRL_MAX_INPUT_LINE</td></tr>
 *                <tr><td>output_field</td><td>PGPgK</td></tr>
 *                <tr><td>output_fcnt</td><td>1 ~ AG903_PGP_MGR_TRIG_CTRL_MAX_FRAME_CNT</td></tr>
 *                <tr><td>output_line</td><td>1 ~ AG903_PGP_MGR_TRIG_CTRL_MAX_OUTPUT_LINE</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigTrigCtrl(AG903_PgpMgrPipelineHandle *handle, uint32_t input_field, uint32_t input_fcnt, uint32_t input_line, uint32_t output_field, uint32_t output_fcnt, uint32_t output_line)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (input_field) {
        case AG903_PGP_MGR_TRIG_CTRL_FIELD_ODD:
        case AG903_PGP_MGR_TRIG_CTRL_FIELD_EVEN:
        case AG903_PGP_MGR_TRIG_CTRL_FIELD_ODD_EVEN:
            break;
        default:
            return -AG903_EINVAL;
    }
    if ((input_fcnt == 0) || (input_fcnt > AG903_PGP_MGR_TRIG_CTRL_MAX_FRAME_CNT)) {
        return -AG903_EINVAL;
    }
    if (input_line > AG903_PGP_MGR_TRIG_CTRL_MAX_INPUT_LINE) {
        return -AG903_EINVAL;
    }
    switch (output_field) {
        case AG903_PGP_MGR_TRIG_CTRL_FIELD_ODD:
        case AG903_PGP_MGR_TRIG_CTRL_FIELD_EVEN:
        case AG903_PGP_MGR_TRIG_CTRL_FIELD_ODD_EVEN:
            break;
        default:
            return -AG903_EINVAL;
    }
    if ((output_fcnt == 0) || (output_fcnt > AG903_PGP_MGR_TRIG_CTRL_MAX_FRAME_CNT)) {
        return -AG903_EINVAL;
    }
    if (output_line > AG903_PGP_MGR_TRIG_CTRL_MAX_OUTPUT_LINE) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_trig_field = input_field;
    handle->input_trig_fcnt = input_fcnt;
    handle->input_trig_line = input_line;
    handle->output_trig_field = output_field;
    handle->output_trig_fcnt = output_fcnt;
    handle->output_trig_line = output_line;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_TRIG_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         Lv`͂HSYNCɑ΂xݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         h_delay [in] Lv`͂HSYNC̒xw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>h_delayɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   Lv`͂́@HSYNC ɑ΂xݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>w\͈</th></tr>
 *                <tr><td>h_delay</td><td>0 ~ AG903_PGP_MGR_MAX_INPUT_HSYNC_DELAY</td></tr>
 *                </table>
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamInputHSyncDelay(AG903_PgpMgrPipelineHandle *handle, uint32_t h_delay)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (h_delay > AG903_PGP_MGR_MAX_INPUT_HSYNC_DELAY) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_hsync_delay = h_delay;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         Lv`͂̓샂[hݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         md [in] Lv`͂̓샂[hw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>mdɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   Lv`͂̓샂[hݒ肵܂B<p>
 *                ڂ́uPGPLv`샂[hvQƂĂB
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamInputMode(AG903_PgpMgrPipelineHandle *handle, uint32_t md)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (md) {
        case AG903_PGP_MGR_INPUT_MD_VSYNC:
        case AG903_PGP_MGR_INPUT_MD_ODD_VSYNC:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_mode = md;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         Lv`͂̃^CvX^vɎgpNbN\[Xݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         tick [in] Lv`͂̃^CvX^vɎgpNbN\[Xw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>tickɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   Lv`͂̃^CX^vɎgpNbN\[Xݒ肵܂B<p>
 *                ڂ́uPGP^CX^vNbNvQƂĂB
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamInputTimeCLK(AG903_PgpMgrPipelineHandle *handle, uint32_t tick)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (tick) {
        case AG903_PGP_MGR_INPUT_TIME_CLK0:
        case AG903_PGP_MGR_INPUT_TIME_CLK1:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_timer_clk = tick;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         gKÑ^C}W[̃`lԍݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         timer_ch [in] ^C}W[̃`lԍw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>timer_chɕsȒlw肳ꂽꍇ
 * @description   gKÑ^C}W[̃`lԍݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>w\͈</th></tr>
 *                <tr><td>timer_ch</td><td>0 ~ AG903_PGP_MGR_MAX_TRIG_TIMER_CHANNEL</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigInputTrigChannel(AG903_PgpMgrPipelineHandle *handle, uint32_t timer_ch)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (timer_ch > AG903_PGP_MGR_MAX_TRIG_TIMER_CHANNEL) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_trig_timer_ch = timer_ch;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_INPUT_TRIG_CH] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̓̓|[gݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         src [in] ̓nhw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>srcɕsȃnhw肳ꂽꍇ
 * @description   pCvC̓̓|[gw肵܂B<p>
 *                ̓nh̃nh́A|C^̐擪4ByteŎʂ܂B<p>
 *                w\ȃnh͈ȉ̒ʂłB
 *                <table>
 *                <tr><th>nh</th><th>^</th></tr>
 *                <tr><td>AiOrfI̓nh</td><td>AG903_ViaMgrInputHandle</td></tr>
 *                <tr><td>fW^rfI̓nh</td><td>AG903_VidMgrInputHandle</td></tr>
 *                <tr><td>VRAM̓nh</td><td>AG903_PgpMgrVRAMInputHandle</td></tr>
 *                </table>
 * @note          src=NULL ̏ꍇAݐݒ肳Ă̓|[g̐ݒ܂B
*/
int32_t AG903_PgpMgrSetInputPort(AG903_PgpMgrPipelineHandle *handle, void *src)
{
    const uint32_t via_port[4] = {
        AG903_PGP_MGR_INPUT_PORT_VIA_0,
        AG903_PGP_MGR_INPUT_PORT_VIA_1,
        AG903_PGP_MGR_INPUT_PORT_VIA_2,
        AG903_PGP_MGR_INPUT_PORT_VIA_3,
    };
    const uint32_t vid_port[4] = {
        AG903_PGP_MGR_INPUT_PORT_VID_0,
        AG903_PGP_MGR_INPUT_PORT_VID_1,
        AG903_PGP_MGR_INPUT_PORT_VID_2,
        AG903_PGP_MGR_INPUT_PORT_VID_3,
    };

    AG903_ViaMgrInputHandle *via_h = (AG903_ViaMgrInputHandle *)src;
	AG903_VidMgrOutputHandle *vid_h = (AG903_VidMgrOutputHandle *)src;
    AG903_PgpMgrVRAMInputHandle *vram_h = (AG903_PgpMgrVRAMInputHandle *)src;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    if (src != NULL) {
        if (via_h->id == AG903_VIA_MGR_INPUT_HANDLE_ID) {
            handle->input_port = via_port[via_h->port_no];
        } else if (vid_h->id == AG903_VID_MGR_OUTPUT_HANDLE_ID) {
            handle->input_port = vid_port[vid_h->port_no];
        } else if (vram_h->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
            /* VRAM͂̏ꍇ̓|[g̊蓖ĂĂȂP[X邽߁Ainput_portւ̐ݒ͊蓖ĎɍsȂ܂ */
            vram_h->ref_cnt++;
        } else {
            return -AG903_EINVAL;
        }
    }

    /* ɑVRAM̓nh̓|[gɐݒ肳Ăꍇ́AVRAM̓nh̃t@XJEgfNg܂ */
    vram_h = (AG903_PgpMgrVRAMInputHandle *)handle->input_handle;
    if ((vram_h != NULL) && (vram_h->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        vram_h->ref_cnt--;
    }

    /* ̓nhێ܂ */
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_INPUT_TRIG_CH] = true;
    handle->input_handle = src;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̓̓tH[}bgݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         format [in] ̓tH[}bgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>formatɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC̓̓tH[}bgݒ肵܂B<p>
 *                ڂ́uPGP̓tH[}bgvQƂĂB
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamInputFormat(AG903_PgpMgrPipelineHandle *handle, uint32_t format)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (format) {
        case AG903_PGP_MGR_INPUT_FMT_RGB888:
        case AG903_PGP_MGR_INPUT_FMT_RGB565:
        case AG903_PGP_MGR_INPUT_FMT_YCBCR444:
        case AG903_PGP_MGR_INPUT_FMT_YCBCR422_WO_IP:
        case AG903_PGP_MGR_INPUT_FMT_YCBCR422_W_IP:
        case AG903_PGP_MGR_INPUT_FMT_CLUT8:
        case AG903_PGP_MGR_INPUT_FMT_CLUT1:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_format = format;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̃Lv`TCYݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         vsize [in] Lv`TCYw肵܂B
 * @param         hsize [in] Lv`TCYw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>vsizeɕsȒlw肳ꂽꍇ<p>hsizeɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC̃Lv`TCYݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>vsize</td><td>1 ~ AG903_PGP_MGR_MAX_INPUT_SIZE</td></tr>
 *                <tr><td>hsize</td><td>1 ~ AG903_PGP_MGR_MAX_INPUT_SIZE</td></tr>
 *                </table>
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamInputSize(AG903_PgpMgrPipelineHandle *handle, uint32_t vsize, uint32_t hsize)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if ((vsize == 0) || (vsize > AG903_PGP_MGR_MAX_INPUT_SIZE)) {
        return -AG903_EINVAL;
    }
    if ((hsize == 0) || (hsize > AG903_PGP_MGR_MAX_INPUT_SIZE)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_vsize = vsize;
    handle->input_hsize = hsize;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̃Lv`JnWݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         vpos [in] Lv`JnWʒuw肵܂B
 * @param         hpos [in] Lv`JnWʒuw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>vposɕsȒlw肳ꂽꍇ<p>hposɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC̃Lv`JnWݒ肵܂B
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>vpos</td><td>0 ~ AG903_PGP_MGR_MAX_INPUT_POS</td></tr>
 *                <tr><td>hpos</td><td>0 ~ AG903_PGP_MGR_MAX_INPUT_POS</td></tr>
 *                </table>
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamInputPosition(AG903_PgpMgrPipelineHandle *handle, uint32_t vpos, uint32_t hpos)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (vpos > AG903_PGP_MGR_MAX_INPUT_POS) {
        return -AG903_EINVAL;
    }
    if (hpos > AG903_PGP_MGR_MAX_INPUT_POS) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_vpos = vpos;
    handle->input_hpos = hpos;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̃Lv`̃t[@ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         scan [in] t[@w肵܂B
 * @param         epos [in] C^[X[hłEVENt[vpos̗L/w肵܂B
 * @param         opos [in] C^[X[hłODDt[vpos̗L/w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>scanɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC̃Lv`̃t[p[^ݒ肵܂B<p>
 *                ڂ́AuPGPt[@vQƂĂB
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamInputScan(AG903_PgpMgrPipelineHandle *handle, uint32_t scan, _Bool epos, _Bool opos)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (scan) {
        case AG903_PGP_MGR_SCAN_PROGRESSIVE:
        case AG903_PGP_MGR_SCAN_INTERLACE:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->input_scan = scan;
    handle->input_epos = epos;
    handle->input_opos = opos;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         t[ۑ̃pfBOlݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         pad [in] t[ۑ̃pfBOlw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>padɕsȒlw肳ꂽꍇ
 * @description   pCvC̃t[ۑ̃pfBOlݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>vpos</td><td>0 ~ AG903_PGP_MGR_MAX_OUTPUT_PAD</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigOutputFramePadding(AG903_PgpMgrPipelineHandle *handle, uint32_t pad)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (pad > AG903_PGP_MGR_MAX_OUTPUT_PAD) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_pad = pad;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_OUTPUT_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         24bit͒l̃~bgݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         limit [in] 24bit͂̃~bgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>limitɕsȒlw肳ꂽꍇ
 * @description   pCvC 24bit ͒l̃~bgݒ肵܂B<p>
 *                ڂ́AuPGP~bgvQƂĉB<p>
 *                ̂ limit ł́A AG903_PGP_MGR_LIMIT_0_255 / AG903_PGP_MGR_LIMIT_16_235_AND_240 ̎w肪\łB
*/
int32_t AG903_PgpMgrSetConfigOutputLimit(AG903_PgpMgrPipelineHandle *handle, uint32_t limit)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (limit) {
        case AG903_PGP_MGR_LIMIT_0_255:
        case AG903_PGP_MGR_LIMIT_16_235_AND_240:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_limit = limit;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_OUTPUT_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         t[to̗͂L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] t[to̗͂LtOw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @description   pCvC̃t[to̗͂L/ݒ肵܂B
*/
int32_t AG903_PgpMgrEnableConfigOutputFrameInfo(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_fai_enable = enable;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_OUTPUT_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         F̃fBUO̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] F̃fBUO̗LtOw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @description   pCvČF̃fBUO̗L/ݒ肵܂B
*/
int32_t AG903_PgpMgrEnableConfigOutputDither(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_dither_enable = enable;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_OUTPUT_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvCõ͎t[@ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         scan [in] t[{@w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>scanɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvCõ͎t[@̃p[^ݒ肵܂B<p>
 *                ڂ́AuPGPt[@vQƂĂB
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamOutputScan(AG903_PgpMgrPipelineHandle *handle, uint32_t scan)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (scan) {
        case AG903_PGP_MGR_SCAN_PROGRESSIVE:
        case AG903_PGP_MGR_SCAN_INTERLACE:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_scan = scan;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvCõ͎AhXw@ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         dim [in] AhXw@w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>dimɕsȒlw肳ꂽꍇ
 * @description   pCvCõ͎AhXw@̃p[^ݒ肵܂B<p>
 *                ڂ́AuPGPAhXw@vQƂĂB
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamOutputAddrDim(AG903_PgpMgrPipelineHandle *handle, uint32_t dim)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (dim) {
        case AG903_PGP_MGR_ADDR_DIMENTION_1:
        case AG903_PGP_MGR_ADDR_DIMENTION_2:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_dim = dim;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvCõ͎f[^Xbvݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         word [in] [hf[^̃Xbv̗L/tOw肵܂B
 * @param         hword [in] n[t[hf[^̃Xbv̗L/tOw肵܂B
 * @param         four_bit [in] 4bitf[^̃Xbv̗L/tOw肵܂B
 * @param         ont_bit [in] 1bitf[^̃Xbv̗L/tOw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @description   pCvCõ͎f[^Xbvݒ肵܂B
*/
int32_t AG903_PgpMgrSetConfigOutputDataSwap(AG903_PgpMgrPipelineHandle *handle, _Bool word, _Bool hword, _Bool four_bit, _Bool one_bit)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_word_swap_enable = word;
    handle->output_hword_swap_enable = hword;
    handle->output_4bit_swap_enable = four_bit;
    handle->output_1bit_swap_enable = one_bit;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_OUTPUT_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         C^[X͂̃t[ۑ@ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         frame_save [in] C^[X͂̃t[ۑ@w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>frame_saveɕsȒlw肳ꂽꍇ
 * @description   C^[X͂̃t[ۑ@ݒ肵܂B<p>
 *                ڂ́AuPGPt[ۑ@vQƂĂB
*/
int32_t AG903_PgpMgrSetConfigOutputInterlaceFrame(AG903_PgpMgrPipelineHandle *handle, uint32_t frame_save)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (frame_save) {
        case AG903_PGP_MGR_OUTPUT_FRAME_SAVE_ODD:
        case AG903_PGP_MGR_OUTPUT_FRAME_SAVE_EVEN:
        case AG903_PGP_MGR_OUTPUT_FRAME_SAVE_IGNORE_FIELD:
        case AG903_PGP_MGR_OUTPUT_FRAME_SAVE_FIELD:
        case AG903_PGP_MGR_OUTPUT_FRAME_SAVE_WEAVE:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_md = frame_save;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_OUTPUT_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         obt@Ǘjbgݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         bmu [in] obt@Ǘjbgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>bmuɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   obt@Ǘjbgݒ肵܂B<p>
 *                t[@vObVuA܂̓C^[X͂̃t[ۑŊt[̂݁A
 *                ͋t[݂̂w肵ꍇAAG903_PGP_MGR_OUTPUT_BMU_ENABLE_EVEN͎wł܂B<p>
 *                ڂ́AuPGPBMUݒvQƂĂB
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamOutputBMU(AG903_PgpMgrPipelineHandle *handle, uint32_t bmu)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (bmu) {
        case AG903_PGP_MGR_OUTPUT_BMU_NONE:
        case AG903_PGP_MGR_OUTPUT_BMU_ENABLE:
        case AG903_PGP_MGR_OUTPUT_BMU_ENABLE_EVEN:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_bmu = bmu;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvCõ͎tH[}bgݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         format [in] o̓tH[}bgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>formatɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvCõ͎tH[}bgݒ肵܂B<p>
 *                ڂ́AuPGPo̓tH[}bgvQƂĂB
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamOutputFormat(AG903_PgpMgrPipelineHandle *handle, uint32_t format)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (format) {
        case AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB888_32BIT:
        case AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB888_24BIT:
        case AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB565:
        case AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_ARGB1555:
        case AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_ARGB4444:
        case AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB888_SEP:
        case AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR444_32BIT:
        case AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR444_24BIT:
        case AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR422:
        case AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR444_SEP:
        case AG903_PGP_MGR_OUTPUT_FMT_CLUT8_TO_CLUT8:
        case AG903_PGP_MGR_OUTPUT_FMT_CLUT1_TO_CLUT1:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_format = format;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         RGBo͂ɂpCvCõ͎J[}XNݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         red [in] Redvf̗L/tOw肵܂B(1:o͂A0:o͂Ȃ)
 * @param         green [in] Greenvf̗L/tOw肵܂B(1:o͂A0:o͂Ȃ)
 * @param         blue [in] Bluevf̗L/tOw肵܂B(1:o͂A0:o͂Ȃ)
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>red,green,bluȇSĂ̗vfŖw肳ꂽꍇ
 * @description   pCvCõ͎J[}XNݒ肵܂B<p>
 *                Red,Green,BlueSĂ̗vf̖͋֎~łB
*/
int32_t AG903_PgpMgrEnableConfigOutputColorMask(AG903_PgpMgrPipelineHandle *handle, _Bool red, _Bool green, _Bool blue)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID) || ((red == false) && (green == false) && (blue == false))) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_red_enable = red;
    handle->output_green_enable = green;
    handle->output_blue_enable = blue;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_OUTPUT_COLOR_MASK] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̏o͐x[XAhXݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         addr [in] o͐x[XAhX|C^Ŏw肵܂B(8oCgACKv)
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>addrNULLw肳ꂽꍇ
 * @description   pCvC̏o͐x[XAhXݒ肵܂B
*/
int32_t AG903_PgpMgrSetConfigOutputBaseAddr(AG903_PgpMgrPipelineHandle *handle, void *addr)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (addr == NULL) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_base_addr = (uint32_t)addr;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_OUTPUT_BASE_ADDR] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̏o͐悪2̏ꍇ̃XgChoCgݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         stride [in] 2ŏo͂ꍇ̃XgChoCgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>strideɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC̏o͐悪2̏ꍇAXgChoCgݒ肵܂B<p>
 *                o̓tH[}bgYCbCr422̎AXgChoCg͋ɐݒ肵ĂB<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>stride</td><td>1 ~ AG903_PGP_MGR_OUTPUT_MAX_STRIDE_BYTE</td></tr>
 *                </table>
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamOutputStride(AG903_PgpMgrPipelineHandle *handle, uint32_t stride)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if ((stride == 0) || (stride > AG903_PGP_MGR_OUTPUT_MAX_STRIDE_BYTE)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->output_vram_stride = stride;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         pCvC̃t[t̒l擾
 * @param         handle [in] pCvCnhw肵܂B
 * @param         tmstmp [out] ^CX^vpJE^̒lێ|C^w肵܂B
 * @param         field [out] ̓tB[h̒lێ|C^w肵܂B
 * @param         port [out] |[gԍ̒lێ|C^w肵܂B
 * @param         fnum [out] t[ԍ̓JE^̒lێ|C^w肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>pCvCIɊ蓖ĂĂȂꍇ<p>蓖Đ̕pCvC̃pCvCnhŎgpĂꍇ
 * @description   pCvC̃t[t̒l擾܂B<p>
 *                ƃWX^̑Ή͈ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ΏۃWX^</th></tr>
 *                <tr><td>tmstmp</td><td>AG903_PGPn_FAIVAL0  TMSTMPtB[h</td></tr>
 *                <tr><td>field</td><td>AG903_PGPn_FAIVAL1  FIELDtB[h</td></tr>
 *                <tr><td>port</td><td>AG903_PGPn_FAIVAL1  PORTtB[h</td></tr>
 *                <tr><td>fnum</td><td>AG903_PGPn_FAIVAL1  FNUMtB[h</td></tr>
 *                </table>
 * @note          =NULL ̏ꍇAỸp[^͎擾܂B
*/
int32_t AG903_PgpMgrGetFrameInfo(AG903_PgpMgrPipelineHandle *handle, uint32_t *tmstmp, uint32_t *field, uint32_t *port, uint32_t *fnum)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂȂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == false) {
        return -AG903_EINVAL;
    }
    /* 蓖Đ̕pCvC̃pCvCnhɎgpĂꍇ̓G[Ƃ܂ */
    if (PgpContext.exec_pipeline[handle->pipeline_no] != handle) {
        return -AG903_EINVAL;
    }

    /* Primitive LayerʂĒl擾܂ */
    if (tmstmp != NULL) {
        AG903_PgpPrmGetPGPnFAIVAL0(handle->pipeline_no, tmstmp);
    }
    if (field != NULL || port != NULL || fnum != NULL) {
        uint32_t tmp_field, tmp_port, tmp_fnum;
        AG903_PgpPrmGetPGPnFAIVAL1(handle->pipeline_no, &tmp_field, &tmp_port, &tmp_fnum);
        if (field != NULL) {
            *field = tmp_field;
        }
        if (port != NULL) {
            *port = tmp_port;
        }
        if (fnum != NULL) {
            *fnum = tmp_fnum;
        }
    }
    return AG903_ENONE;
}


/**
 * @brief         t[ԉZƂ̑̉Z̏ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         order [in] Z̏w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>orderɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC@\̃t[ԉZƂ̑Z̏ݒ肵܂B<p>
 *                ڂ́AuPGPZvQƂĂB
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamFrameCalcOrder(AG903_PgpMgrPipelineHandle *handle, uint32_t order)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (order) {
        case AG903_PGP_MGR_IFCODR_FRAME_TO_OTHER:
        case AG903_PGP_MGR_IFCODR_OTHER_TO_FRAME:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->ifc_order = order;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         臒l̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] 臒lZ̗L/w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC@\臒l̗L/ݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamThresholdOp(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->thr_enable = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         Zxϊ̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] ZxϊZ̗L/w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC@\̔Zxϊ̗L/ݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamDGC(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->dgc_enable = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         HSVAHLSϊ̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] HSVAHLSϊ̗L/w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC@\ HSV/HLS ϊ̗L/ݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamHSV(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->hsv1_enable = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         ԃtB^̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] ԃtB^̗L/w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽ
 * @description   pCvC@\̋ԃtB^̗L/ݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamSpatialFilter(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->spf_enable = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         XP[O̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] XP[O̗L/w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC@\̃XP[O̗L/ݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamScaling(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->scale_enable = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         Fԕϊ̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] Fԕϊ̗L/w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC@\̐Fԕϊ̗L/ݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamColorSpace(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->csc1_enable = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         3^bvmCYtB^̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] 3^bvmCYtB^̗Lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC@\ 3^bvmCYtB^̗L/ݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamNRF(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->nrf_enable = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         qXgO̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] qXgO̗L/w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC@\̃qXgO̗L/ݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B<p>
 *                {֐̐ݒl̓pCvC̊蓖ĎɃqXgO@\gp邩肷邽߂݂̂Ɏgp܂B<p>
 *                ۂɃqXgO@\gpꍇ̓qXgO̎sR}h𔭍sKv܂B
*/
int32_t AG903_PgpMgrEnableParamHistogram(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->hgm_enable = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         xO̗L/ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] xO̗Lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   pCvC@\̃xO̗L/ݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B<p>
 *                {֐̐ݒl̓pCvC̊蓖ĎɃxO@\gp邩肷邽߂݂̂Ɏgp܂B<p>
 *                ۂɃxO@\gpꍇ̓xO̎sR}h𔭍sKv܂B
*/
int32_t AG903_PgpMgrEnableParamLabeling(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->lbl_enable = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         I/PϊH̃p[^ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         limit [in] õ͎~bgw肵܂B
 * @param         blky [in] uNԂYo͒lw肵܂B
 * @param         blkc [in] uNԂYo͒lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>
 *                limitɕsȒlw肳ꂽꍇ<p>blkyɕsȒlw肳ꂽꍇ<p>blkcɕsȒlw肳ꂽꍇ
 * @description   I/PϊH̃p[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>limit</td><td>PGP~bg</td></tr>
 *                <tr><td>blky</td><td>0 ~ AG903_PGP_MGR_MAX_IP_BLANK</td></tr>
 *                <tr><td>blkc</td><td>0 ~ AG903_PGP_MGR_MAX_IP_BLANK</td></tr>
 *                </table>
 *                PGP~bg ̂AAG903_PGP_MGR_LIMIT_0_255 / AG903_PGP_MGR_LIMIT_16_235_AND_240 w\łB
*/
int32_t AG903_PgpMgrSetConfigIPConversion(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, uint32_t blky, uint32_t blkc)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (limit) {
        case AG903_PGP_MGR_LIMIT_0_255:
        case AG903_PGP_MGR_LIMIT_16_235_AND_240:
            break;
        default:
            return -AG903_EINVAL;
    }
    if (blky > AG903_PGP_MGR_MAX_IP_BLANK) {
        return -AG903_EINVAL;
    }
    if (blkc > AG903_PGP_MGR_MAX_IP_BLANK) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->ipc_limit = limit;
    handle->ipc_blk_y = blky;
    handle->ipc_blk_c = blkc;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_IP_CONV] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         Fԕϊ𐧌䂷p[^ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         limit [in] õ͎~bgw肵܂B
 * @param         shift [in] ỏ͎EVtgʂw肵܂B
 * @param         mtx [in] FԕϊWw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>limitɕsȒlw肳ꂽꍇ<p>shiftɕsȒlw肳ꂽꍇ<p>mtxNULLw肳ꂽꍇ
 * @description   Fԕϊ𐧌䂷p[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>limit</td><td>PGP~bg</td></tr>
 *                <tr><td>shift</td><td>0 ~ AG903_PGP_MGR_MAX_COLOR_SPACE_SHIFT</td></tr>
 *                <tr><td>mtx</td><td>3x4}gNX̕t<p>Zvf:20bit<p>ȊO:12bit</td></tr>
 *                </table>
 *                PGP~bg ̂AAG903_PGP_MGR_LIMIT_0_255 / AG903_PGP_MGR_LIMIT_16_235_AND_240 w\łB
 * @note          }gNX3x4̗vf͉12bitLƂȂAZvf͉19bitLƂȂ܂B
*/
int32_t AG903_PgpMgrSetConfigColorSpace(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, uint32_t shift, int32_t mtx[3][4])
{
    int32_t i;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (limit) {
        case AG903_PGP_MGR_LIMIT_0_255:
        case AG903_PGP_MGR_LIMIT_16_235_AND_240:
            break;
        default:
            return -AG903_EINVAL;
    }
    if (shift > AG903_PGP_MGR_MAX_COLOR_SPACE_SHIFT) {
        return -AG903_EINVAL;
    }
    if (mtx == NULL) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->csc1_limit = limit;
    handle->csc1_shift = shift;
    for (i = 0; i < 3; i++) {
        handle->csc1_matrix[i][0] = mtx[i][0] & CSC_MUL_MASK;
        handle->csc1_matrix[i][1] = mtx[i][1] & CSC_MUL_MASK;
        handle->csc1_matrix[i][2] = mtx[i][2] & CSC_MUL_MASK;
        handle->csc1_matrix[i][3] = mtx[i][3] & CSC_ADD_MASK;
    }
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_COLOR_SPACE] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         Fԕϊ̃vZbgݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         format [in] Fԕϊ̃vZbgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>formatɕsȒlw肳ꂽꍇ
 * @description   Fԕϊ̃vZbgݒ肵܂B<p>
 *                ڂ́AuPGPFԃvZbgvQƂĂB
*/
int32_t AG903_PgpMgrSetConfigPresetColorSpace(AG903_PgpMgrPipelineHandle *handle, uint32_t format)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (format) {
        case AG903_PGP_MGR_CSC_YUV_BT_601_FULL_TO_RGB:
        case AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_601_FULL:
        case AG903_PGP_MGR_CSC_YUV_BT_601_LIMIT_TO_RGB:
        case AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_601_LIMIT:
        case AG903_PGP_MGR_CSC_YUV_BT_709_FULL_TO_RGB:
        case AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_709_FULL:
        case AG903_PGP_MGR_CSC_YUV_BT_709_LIMIT_TO_RGB:
        case AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_709_LIMIT:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    PgpMgrGetPresetColorSpaceParameter(format, &handle->csc1_limit, &handle->csc1_shift, &handle->csc1_matrix[0][0]);
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_COLOR_SPACE] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         XP[Õp[^ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         limit [in] õ͎~bgw肵܂B
 * @param         filter [in] k̃tB^[hw肵܂B
 * @param         nmr_v [in] k̕qw肵܂B
 * @param         dnm_v [in] k̕w肵܂B
 * @param         nmr_h [in] k̕qw肵܂B
 * @param         dnm_h [in] k̕w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>
 *                limitɕsȒlw肳ꂽꍇ<p>nmr_vɕsȒlw肳ꂽꍇ<p>dnm_vɕsȒlw肳ꂽꍇ<p>nmr_hɕsȒlw肳ꂽꍇ<p>dnm_hɕsȒlw肳ꂽꍇ
 * @description   XP[Õp[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>limit</td><td>PGP~bg</td></tr>
 *                <tr><td>filter</td><td>PGPktB^[</td></tr>
 *                <tr><td>nmr_v</td><td>1 ~ AG903_PGP_MGR_MAX_SCALING_VALUE</td></tr>
 *                <tr><td>dnm_v</td><td>1 ~ AG903_PGP_MGR_MAX_SCALING_VALUE</td></tr>
 *                <tr><td>nmr_h</td><td>1 ~ AG903_PGP_MGR_MAX_SCALING_VALUE</td></tr>
 *                <tr><td>dnm_h</td><td>1 ~ AG903_PGP_MGR_MAX_SCALING_VALUE</td></tr>
 *                </table>
 *                PGP~bg ̂AAG903_PGP_MGR_LIMIT_0_255 / AG903_PGP_MGR_LIMIT_16_235_AND_240 w\łB
*/
int32_t AG903_PgpMgrSetConfigScaling(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, uint32_t filter, uint32_t nmr_v, uint32_t dnm_v, uint32_t nmr_h, uint32_t dnm_h)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (limit) {
        case AG903_PGP_MGR_LIMIT_0_255:
        case AG903_PGP_MGR_LIMIT_16_235_AND_240:
            break;
        default:
            return -AG903_EINVAL;
    }
    switch (filter) {
        case AG903_PGP_MGR_FILTER_NEAREST:
        case AG903_PGP_MGR_FILTER_LINEAR:
            break;
        default:
            return -AG903_EINVAL;
    }
    if ((nmr_v == 0) || (nmr_v > AG903_PGP_MGR_MAX_SCALING_VALUE)) {
        return -AG903_EINVAL;
    }
    if ((dnm_v == 0) || (dnm_v > AG903_PGP_MGR_MAX_SCALING_VALUE)) {
        return -AG903_EINVAL;
    }
    if ((nmr_h == 0) || (nmr_h > AG903_PGP_MGR_MAX_SCALING_VALUE)) {
        return -AG903_EINVAL;
    }
    if ((dnm_h == 0) || (dnm_h > AG903_PGP_MGR_MAX_SCALING_VALUE)) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->scale_limit = limit;
    handle->scale_mtd = filter;
    handle->scale_v_nmr = nmr_v;
    handle->scale_v_dnm = dnm_v;
    handle->scale_h_nmr = nmr_h;
    handle->scale_h_dnm = dnm_h;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_SCALING] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}

/**
 * @brief         ԃtB^𐧌䂷p[^ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         shift [in] ỏ͎EVtgʂw肵܂B
 * @param         border [in] El̏@w肵܂B
 * @param         border_red [in] EľŒJ[()w肵܂B
 * @param         border_green [in] EľŒJ[()w肵܂B
 * @param         border_blue [in] EľŒJ[()w肵܂B
 * @param         coeff [in] ԃtB^Ww肵܂B
 * @param         offset [in] ỏ͎ZItZbgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>shiftɕsȒlw肳ꂽꍇ<p>borderɕsȒlw肳ꂽꍇ<p>coeffNULLw肳ꂽꍇ
 * @description   ԃtB^𐧌䂷p[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>shift</td><td>0 ~ AG903_PGP_MGR_MAX_SPF_SHIFT</td></tr>
 *                <tr><td>border</td><td>PGPEl</td></tr>
 *                <tr><td>border_red</td><td>8bit Ŏw</td></tr>
 *                <tr><td>border_green</td><td>8bit Ŏw</td></tr>
 *                <tr><td>border_blue</td><td>8bit Ŏw</td></tr>
 *                <tr><td>coeff</td><td>t 8bit Ŏw</td></tr>
 *                <tr><td>offset</td><td>t 9bit Ŏw</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigSpatialFilter(AG903_PgpMgrPipelineHandle *handle, uint32_t shift, uint32_t border, uint32_t border_red, uint32_t border_green, uint32_t border_blue, int32_t coeff[9], int32_t offset)
{
    int32_t i;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (shift > AG903_PGP_MGR_MAX_SPF_SHIFT) {
        return -AG903_EINVAL;
    }
    switch (border) {
        case AG903_PGP_MGR_SPF_BORDER_COLOR:
        case AG903_PGP_MGR_SPF_BORDER_NEIGHBOR:
            break;
        default:
            return -AG903_EINVAL;
    }
    if (coeff == NULL) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->spf_shift = shift;
    handle->spf_border_sel = border;
    handle->spf_border_red = border_red;
    handle->spf_border_green = border_green;
    handle->spf_border_blue = border_blue;
    for (i = 0; i < 9; i++) {
        handle->spf_coeff[i] = coeff[i] & SPF1_COEFF_MASK;
    }
    handle->spf_offset = offset & SPF1_OFFSET_MASK;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_SP_FILTER] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         HSVAHLSϊH̏o̓tH[}bgݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         sel [in] HSVAHLSI܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>selɕsȒlw肳ꂽꍇ
 * @description   HSVAHLSϊH̏o̓tH[}bgݒ肵܂B<p>
 *                ڂ́AuPGPϊHvQƂĂB
*/
int32_t AG903_PgpMgrSetConfigHSVHLSConversion(AG903_PgpMgrPipelineHandle *handle, uint32_t sel)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (sel) {
        case AG903_PGP_MGR_CONVERT_HSV:
        case AG903_PGP_MGR_CONVERT_HLS:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->hsv_hls_sel = sel;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_HSVHSL_CONV] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}

/**
 * @brief         qXgO̎s
 * @param         handle [in] qXgOspCvCnhw肵܂B
 * @param         cmd [in] sR}hw肵܂B
 * @return        䌋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL
 *                handleɕsȒlw肳ꂽꍇ<p>cmdɕsȒlw肳ꂽꍇ<p>pCvCnhIȃpCvCɊ蓖ĂĂȂꍇ
 * @retval        -AG903_EBUSY ̃pCvCnhspCvCŌݏ̏ꍇ<p>R}hqXgOsAL[ɋ󂫂ꍇ
 * @description   qXgO̐R}h𔭍s܂B<p>
 *                R}h́AuPGPqXgOR}hvQƂĂB
*/
int32_t AG903_PgpMgrExecHistogram(AG903_PgpMgrPipelineHandle *handle, uint32_t cmd)
{
    PGPPrmParamPGPnSTATE   state;
    PGPPrmParamPGPnHGMSTAT hgmstat;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂȂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == false) {
        return -AG903_EINVAL;
    }
    /* s̕pCvC̃Xe[^X擾 */
    AG903_PgpPrmGetPGPnSTATE(handle->pipeline_no, &state);
    /* ̃pCvCnhݎs̏ꍇ̓G[ */
    if ((PgpContext.exec_pipeline[handle->pipeline_no] != handle ) && (state.st != AG903_PGP_MGR_STATE_IDLE)) {
        return -AG903_EBUSY;
    }
    AG903_PgpPrmGetPGPnHGMSTAT(handle->pipeline_no, &hgmstat);

    switch (cmd) {
        case AG903_PGP_MGR_HGM_CMD_EXEC:
        case AG903_PGP_MGR_HGM_CMD_EXEC_WO_VRAM:
            /* qXgÕR}hL[ɋ󂫂Ȃ΃G[ */
            if ((hgmstat.queue == (AG903_PGP_MGR_HGM_CMD_MAX_QUEUE - 1)) || ((hgmstat.cmd != 0) && (cmd != hgmstat.cmd))) {
                return -AG903_EBUSY;
            }
            break;
        case AG903_PGP_MGR_HGM_CMD_NONE:
        case AG903_PGP_MGR_HGM_CMD_DELETE:
        case AG903_PGP_MGR_HGM_CMD_RESET:
            break;
        default:
            return -AG903_EINVAL;
    }


    /* Primitive LayerʂăqXgÕR}h𔭍s */
    AG903_PgpPrmSetPGPnHGMCMD(handle->pipeline_no, cmd);

    return AG903_ENONE;
}

/**
 * @brief         qXgÕp[^ݒ
 * @param         handle [in] qXgOspCvCnhw肵܂B
 * @param         inv [in] o͖Ԃw肵܂B
 * @param         exc [in] qXgOo̒lO@w肵܂B
 * @param         thr [in] qXgOv̍őlŏl擾臒lw肵܂B
 * @param         shift [in] vf[^ỏ͎EVtglw肵܂B
 * @param         v_inc [in] ̊Ԉݒw肵܂B
 * @param         h_inc [in] ̊Ԉݒw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL
 *                handleɕsȒlw肳ꂽꍇ<p>invɕsȒlw肳ꂽꍇ<p>excɕsȒlw肳ꂽꍇ<p>
 *                thrɕsȒlw肳ꂽꍇ<p>shiftɕsȒlw肳ꂽꍇ<p>v_incɕsȒlw肳ꂽꍇ<p>h_incɕsȒlw肳ꂽꍇ
 * @description   qXgÕp[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>inv</td><td>0 ~ AG903_PGP_MGR_MAX_HGM_OUTPUT_INVALIDATE</td></tr>
 *                <tr><td>exc</td><td>PGPqXgOO@</td></tr>
 *                <tr><td>thr</td><td>0 ~ AG903_PGP_MGR_MAX_HGM_THR</td></tr>
 *                <tr><td>shift</td><td>0 ~ AG903_PGP_MGR_MAX_HGM_SHIFT</td></tr>
 *                <tr><td>v_inc</td><td>0 ~ AG903_PGP_MGR_MAX_HGM_INC</td></tr>
 *                <tr><td>h_inc</td><td>0 ~ AG903_PGP_MGR_MAX_HGM_INC</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigHistogramParameter(AG903_PgpMgrPipelineHandle *handle, uint32_t inv, uint32_t exc, uint32_t thr, uint32_t shift, uint32_t v_inc, uint32_t h_inc)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (inv > AG903_PGP_MGR_MAX_HGM_OUTPUT_INVALIDATE) {
        return -AG903_EINVAL;
    }
    switch (exc) {
        case AG903_PGP_MGR_HGM_EXC_NONE:
        case AG903_PGP_MGR_HGM_EXC_0:
        case AG903_PGP_MGR_HGM_EXC_0_16:
        case AG903_PGP_MGR_HGM_EXC_0_WO_R:
            break;
        default:
            return -AG903_EINVAL;
    }
    if (thr > AG903_PGP_MGR_MAX_HGM_THR) {
        return -AG903_EINVAL;
    }
    if (shift > AG903_PGP_MGR_MAX_HGM_SHIFT) {
        return -AG903_EINVAL;
    }
    if (v_inc > AG903_PGP_MGR_MAX_HGM_INC) {
        return -AG903_EINVAL;
    }
    if (h_inc > AG903_PGP_MGR_MAX_HGM_INC) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->hgm_invalidate = inv;
    handle->hgm_exc = exc;
    handle->hgm_thr = thr;
    handle->hgm_shift = shift;
    handle->hgm_vinc = v_inc;
    handle->hgm_hinc = h_inc;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_HGM_PARAM] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}

/**
 * @brief         qXgÕp[^ݒ
 * @param         handle [in] qXgOspCvCnhw肵܂B
 * @param         vsize [in] qXgOvTCYw肵܂B
 * @param         hsize [in] qXgOvTCYw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>vsizeɕsȒlw肳ꂽꍇ<p>hsizeɕsȒlw肳ꂽꍇ
 * @description   qXgOvTCYݒ肵܂BLv`TCY𒴂l͐ݒ֎~łB<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>vsize</td><td>1 ~ AG903_PGP_MGR_MAX_HGM_SIZE</td></tr>
 *                <tr><td>hsize</td><td>1 ~ AG903_PGP_MGR_MAX_HGM_SIZE</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigHistogramSize(AG903_PgpMgrPipelineHandle *handle, uint32_t vsize, uint32_t hsize)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if ((vsize == 0) || (vsize > AG903_PGP_MGR_MAX_HGM_SIZE)) {
        return -AG903_EINVAL;
    }
    if ((hsize == 0) || (hsize > AG903_PGP_MGR_MAX_HGM_SIZE)) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->hgm_vsize = vsize;
    handle->hgm_hsize = hsize;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_HGM_SIZE] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}

/**
 * @brief         qXgOvJnWݒ
 * @param         handle [in] qXgOspCvCnhw肵܂B
 * @param         vpos [in] qXgOvJnWw肵܂B
 * @param         hpos [in] qXgOvJnWw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>vposɕsȒlw肳ꂽꍇ<p>hposɕsȒlw肳ꂽꍇ
 * @description   qXgOvJnWݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>vpos</td><td>0 ~ AG903_PGP_MGR_MAX_HGM_POS</td></tr>
 *                <tr><td>hpos</td><td>0 ~ AG903_PGP_MGR_MAX_HGM_POS</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigHistogramPosition(AG903_PgpMgrPipelineHandle *handle, uint32_t vpos, uint32_t hpos)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (vpos > AG903_PGP_MGR_MAX_HGM_POS) {
        return -AG903_EINVAL;
    }
    if (hpos > AG903_PGP_MGR_MAX_HGM_POS) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->hgm_vpos = vpos;
    handle->hgm_hpos = hpos;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_HGM_POS] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}

/**
 * @brief         qXgOvo͐x[XAhXݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         addr [in] qXgOvvo͐x[XAhX̃|C^w肵܂B(8oCgACKv)
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>addrNULLw肳ꂽꍇ
 * @description   qXgOvo͐̃x[XAhXݒ肵܂B
*/
int32_t AG903_PgpMgrSetConfigHistogramBaseAddr(AG903_PgpMgrPipelineHandle *handle, void *addr)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (addr == NULL) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->hgm_addr = (uint32_t)addr;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_HGM_BASE_ADDR] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         qXgOṽobt@Ǘjbgݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] obt@Ǘjbg̗Lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   qXgOṽobt@Ǘjbg̎gpLݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamHistogramBMU(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->hgm_bmu = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         qXgOv̍ŕplAőlAŏl擾
 * @param         handle [in] pCvCnhw肵܂B
 * @param         most_r [out] Redvf̍ŕpli[|C^w肵܂B
 * @param         max_r [out] Redvf̍őli[|C^w肵܂B
 * @param         min_r [out] Redvf̍ŏli[|C^w肵܂B
 * @param         most_g [out] Greenvf̍ŕpli[|C^w肵܂B
 * @param         max_g [out] Greenvf̍őli[|C^w肵܂B
 * @param         min_g [out] Greenvf̍ŏli[|C^w肵܂B
 * @param         most_b [out] Bluevf̍ŕpli[|C^w肵܂B
 * @param         max_b [out] Bluevf̍őli[|C^w肵܂B
 * @param         min_b [out] Bluevf̍ŏli[|C^w肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>pCvCIɊ蓖ĂĂȂꍇ<p>蓖Đ̕pCvC̃pCvCnhŎgpĂꍇ
 * @description   qXgOv̊evf̍ŕplAőlAŏl擾܂B
 * @note          i[|C^=NULL ̏ꍇA̒l͎擾܂B
*/
int32_t AG903_PgpMgrGetHistogramParameter(AG903_PgpMgrPipelineHandle *handle, uint32_t *most_r, uint32_t *max_r, uint32_t *min_r, uint32_t *most_g, uint32_t *max_g, uint32_t *min_g, uint32_t *most_b, uint32_t *max_b, uint32_t *min_b)
{
    uint32_t dummy, tmp_max, tmp_min;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂȂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == false) {
        return -AG903_EINVAL;
    }
    /* 蓖Đ̕pCvC̃pCvCnhɎgpĂꍇ̓G[Ƃ܂ */
    if (PgpContext.exec_pipeline[handle->pipeline_no] != handle) {
        return -AG903_EINVAL;
    }

    /* Primitive LayerʂĒl擾܂ */
    if (most_r != NULL) {
        AG903_PgpPrmGetPGPnHGMMOD2(handle->pipeline_no, &dummy, most_r, &dummy);
    }
    AG903_PgpPrmGetPGPnHGMRNG2(handle->pipeline_no, &tmp_max, &tmp_min);
    if (max_r != NULL) {
        *max_r = tmp_max;
    }
    if (min_r != NULL) {
        *min_r = tmp_min;
    }
    if (most_g != NULL) {
        AG903_PgpPrmGetPGPnHGMMOD1(handle->pipeline_no, &dummy, most_g, &dummy);
    }
    AG903_PgpPrmGetPGPnHGMRNG1(handle->pipeline_no, &tmp_max, &tmp_min);
    if (max_g != NULL) {
        *max_g = tmp_max;
    }
    if (min_g != NULL) {
        *min_g = tmp_min;
    }
    if (most_b != NULL) {
        AG903_PgpPrmGetPGPnHGMMOD0(handle->pipeline_no, &dummy, most_b, &dummy);
    }
    AG903_PgpPrmGetPGPnHGMRNG0(handle->pipeline_no, &tmp_max, &tmp_min);
    if (max_b != NULL) {
        *max_b = tmp_max;
    }
    if (min_b != NULL) {
        *min_b = tmp_min;
    }
    return AG903_ENONE;
}


/**
 * @brief         qXgOṽXe[^X擾
 * @param         handle [in] pCvCnhw肵܂B
 * @param         is_init [out] qXgOHł邱ƂtOi[|C^w肵܂B
 * @param         is_vram_out [out] VRAMo͒ł邱ƂtOi[|C^w肵܂B
 * @param         is_act [out] qXgOHł邱ƂtOi[|C^w肵܂B
 * @param         queue_cnt [out] qXgOJEgsł邱ƎtOi[|C^w肵܂B
 * @param         exec_cmd [out] qXgOs̃R}hi[|C^w肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>pCvCIɊ蓖ĂĂȂꍇ<p>蓖Đ̕pCvC̃pCvCnhŎgpĂꍇ
 * @description   qXgÕXe[^X擾܂B
 * @note          i[|C^=NULL̏ꍇA̒l͎擾܂B
*/
int32_t AG903_PgpMgrGetHistogramStatus(AG903_PgpMgrPipelineHandle *handle, _Bool *is_init, _Bool *is_vram_out, _Bool *is_act, uint32_t *queue_cnt, uint32_t *exec_cmd)
{
  PGPPrmParamPGPnHGMSTAT hgmstat;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂȂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == false) {
        return -AG903_EINVAL;
    }
    /* Primitive LayerʂĒl擾܂ */
    AG903_PgpPrmGetPGPnHGMSTAT(handle->pipeline_no, &hgmstat);

    /* 蓖Đ̕pCvC̃pCvCnhɎgpĂꍇ̓G[Ƃ܂ */
    if ((PgpContext.exec_pipeline[handle->pipeline_no] != handle) && (hgmstat.cmd != AG903_PGP_MGR_HGM_CMD_NONE)) {
        return -AG903_EINVAL;
    }
    if (is_init != NULL) {
        *is_init = hgmstat.init;
    }
    if (is_vram_out != NULL) {
        *is_vram_out = hgmstat.vrmacc;
    }
    if (is_act != NULL) {
        *is_act = hgmstat.act;
    }
    if (queue_cnt != NULL) {
        *queue_cnt = hgmstat.queue;
    }
    if (exec_cmd != NULL) {
        *exec_cmd = hgmstat.cmd;
    }
    return AG903_ENONE;
}


/**
 * @brief         臒l̋@\ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         limit [in] limit o͒l̃~bgw肵܂B
 * @param         spf [in] 1bitԃtB^̗LtOw肵܂B
 * @param         mask [in] 摜؂oH̗LtOw肵܂B
 * @param         csc [in] Fԕϊ̗LtOw肵܂B
 * @param         hsv_hls [in] HSVAHLSϊ̗LtOw肵܂B
 * @param         thr8 [in] 8bit臒l̗LtOw肵܂B
 * @param         sel_out [in] o̓ZN^̃\[Xw肵܂B
 * @param         sel_clut8 [in] CLUT8o͂̃\[Xw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>limitɕsȒlw肳ꂽꍇ<p>sel_outɕsȒlw肳ꂽꍇ<p>sel_clut8ɕsȒlw肳ꂽꍇ
 * @description   臒l̋@\I܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>limit</td><td>PGP~bg</td></tr>
 *                <tr><td>sel_out</td><td>PGPo̓ZN^\[X</td></tr>
 *                <tr><td>sel_clut8</td><td>PGPCLUT8o̓\[X</td></tr>
 *                </table>
 *                PGP~bg ̂AAG903_PGP_MGR_LIMIT_NONE / AG903_PGP_MGR_LIMIT_16_235_AND_240 w\łB
*/
int32_t AG903_PgpMgrSetConfigThreshold(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, _Bool spf, _Bool mask, _Bool csc, _Bool hsv_hls, _Bool thr8, uint32_t sel_out, uint32_t sel_clut8)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (limit) {
        case AG903_PGP_MGR_LIMIT_NONE:
        case AG903_PGP_MGR_LIMIT_16_235_AND_240:
            break;
        default:
            return -AG903_EINVAL;
    }
    switch (sel_out) {
        case AG903_PGP_MGR_THR_OUT_SEL_RGB:
        case AG903_PGP_MGR_THR_OUT_SEL_MUX8:
        case AG903_PGP_MGR_THR_OUT_SEL_SPF1:
        case AG903_PGP_MGR_THR_OUT_SEL_LBL:
            break;
        default:
            return -AG903_EINVAL;
    }
    switch (sel_clut8) {
        case AG903_PGP_MGR_THR_CLUT8_OUT_B:
        case AG903_PGP_MGR_THR_CLUT8_OUT_G:
        case AG903_PGP_MGR_THR_CLUT8_OUT_R:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->thr_limit = limit;
    handle->thr_spf1_enable = spf;
    handle->thr_msk_enable = mask;
    handle->thr_csc2_enable = csc;
    handle->thr_hsv2_enable = hsv_hls;
    handle->thr_thr8bit_enable = thr8;
    handle->thr_out_sel = sel_out;
    handle->thr_clut8_sel = sel_clut8;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_THR] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         臒l HSVAHLS ϊH̏o̓tH[}bg@\ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         sel [in] HSVAHLSw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>selɕsȒlw肳ꂽ
 * @description   臒l HSVAHLS ϊH̏o̓tH[}bgݒ肵܂B<p>
 *                ڂ́AuPGPϊHvQƂĂB
*/
int32_t AG903_PgpMgrSetConfigThresholdHSVHLSConversion(AG903_PgpMgrPipelineHandle *handle, uint32_t sel)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (sel) {
        case AG903_PGP_MGR_CONVERT_HSV:
        case AG903_PGP_MGR_CONVERT_HLS:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->thr_hsv_hls_sel = sel;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_THR_HSCHLS_CONV] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         臒l̐Fԕϊ𐧌䂷p[^ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         limit [in] limit o͒l̃~bgw肵܂B
 * @param         shift [in] 臒l̐FoLϊ̏ỏ͎EVtgʂw肵܂B
 * @param         mtx [in] 臒l̐FԕϊWw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>limitɕsȒlw肳ꂽꍇ<p>shiftɕsȒlw肳ꂽꍇ<p>mtxNULLw肳ꂽꍇ
 * @description   臒l̐Fԕϊ𐧌䂷p[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>limit</td><td>PGP~bg</td></tr>
 *                <tr><td>shift</td><td>0 ~ AG903_PGP_MGR_MAX_COLOR_SPACE_SHIFT</td></tr>
 *                <tr><td>mtx</td><td>3x4}gNX̕t<p>Zvf:20bit<p>ȊO:12bit</td></tr>
 *                </table>
 *                PGP~bg ̂AAG903_PGP_MGR_LIMIT_NONE / AG903_PGP_MGR_LIMIT_16_235_AND_240 w\łB
 * @note          }gNX3x4̗vf͉12bitLƂȂAZvf͉19bitLƂȂ܂B
*/
int32_t AG903_PgpMgrSetConfigThresholdColorSpace(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, uint32_t shift, int32_t mtx[3][4])
{
    int32_t i;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (limit) {
        case AG903_PGP_MGR_LIMIT_0_255:
        case AG903_PGP_MGR_LIMIT_16_235_AND_240:
            break;
        default:
            return -AG903_EINVAL;
    }
    if (shift > AG903_PGP_MGR_MAX_COLOR_SPACE_SHIFT) {
        return -AG903_EINVAL;
    }
    if (mtx == NULL) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->thr_csc2_limit = limit;
    handle->thr_csc2_shift = shift;
    for (i = 0; i < 3; i++) {
        handle->thr_csc2_matrix[i][0] = mtx[i][0] & CSC_MUL_MASK;
        handle->thr_csc2_matrix[i][1] = mtx[i][1] & CSC_MUL_MASK;
        handle->thr_csc2_matrix[i][2] = mtx[i][2] & CSC_MUL_MASK;
        handle->thr_csc2_matrix[i][3] = mtx[i][3] & CSC_ADD_MASK;
    }
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_THR_COLOR_SPACE] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         Fԕϊ̃vZbgݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         format [in] Fԕϊ̃vZbgw肵܂B
 * @return        Fԕϊ̃vZbgݒ肵܂B
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>formatɕsȒlw肳ꂽꍇ
 * @description   Fԕϊ̃vZbgݒ肵܂B<p>
 *                ڂ́AuPGPFԃvZbgvQƂĂB
*/
int32_t AG903_PgpMgrSetConfigThresholdPresetColorSpace(AG903_PgpMgrPipelineHandle *handle, uint32_t format)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (format) {
        case AG903_PGP_MGR_CSC_YUV_BT_601_FULL_TO_RGB:
        case AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_601_FULL:
        case AG903_PGP_MGR_CSC_YUV_BT_601_LIMIT_TO_RGB:
        case AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_601_LIMIT:
        case AG903_PGP_MGR_CSC_YUV_BT_709_FULL_TO_RGB:
        case AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_709_FULL:
        case AG903_PGP_MGR_CSC_YUV_BT_709_LIMIT_TO_RGB:
        case AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_709_LIMIT:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    PgpMgrGetPresetColorSpaceParameter(format, &handle->thr_csc2_limit, &handle->thr_csc2_shift, &handle->thr_csc2_matrix[0][0]);
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_THR_COLOR_SPACE] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         臒l̃}XNݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         ch [in] ݒ肷}XNvfw肵܂B
 * @param         h [in] 臒l̃}XNp[^H̒lw肵܂B
 * @param         l [in] 臒l̃}XNp[^L̒lw肵܂B
 * @param         x [in] 臒l̃}XNp[^X̒lw肵܂B
 * @param         hmax [in] 臒l̃}XNp[^HMAX̒lw肵܂B
 * @param         hmin [in] 臒l̃}XNp[^HMIN̒lw肵܂B
 * @param         lmax [in] 臒l̃}XNp[^LMAX̒lw肵܂B
 * @param         lmin [in] 臒l̃}XNp[^LMIN̒lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>chɕsȒlw肳ꂽꍇ
 * @description   臒l̃}XÑp[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>ch</td><td>PGP臒l}XNvf</td></tr>
 *                <tr><td>h/l/x</td><td> 1bit ̂ݗL</td></tr>
 *                <tr><td>hmax/hmin/lmax/lmin</td><td> 8bit ̂ݗL</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigThresholdMask(AG903_PgpMgrPipelineHandle *handle, uint32_t ch, uint32_t h, uint32_t l, uint32_t x, uint32_t hmax, uint32_t hmin, uint32_t lmax, uint32_t lmin)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (ch) {
        case AG903_PGP_MGR_THR_CHANNEL_B:
        case AG903_PGP_MGR_THR_CHANNEL_G:
        case AG903_PGP_MGR_THR_CHANNEL_R:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->thr_msk_h[ch] = h & THR_MSK_L_MASK;
    handle->thr_msk_l[ch] = l & THR_MSK_H_MASK;
    handle->thr_msk_x[ch] = x & THR_MSK_X_MASK;
    handle->thr_msk_hmax[ch] = hmax & THR_MSK_HMAX_MASK;
    handle->thr_msk_hmin[ch] = hmin & THR_MSK_HMIN_MASK;
    handle->thr_msk_lmax[ch] = lmax & THR_MSK_LMAX_MASK;
    handle->thr_msk_lmin[ch] = lmin & THR_MSK_LMIN_MASK;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_THR_MASK] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         臒l 8bit 臒l̃p[^ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         ch [in] ݒ肷}XNvfw肵܂B
 * @param         type [in] 臒l8bit臒l̃^Cvw肵܂B
 * @param         maxval [in] 臒l8bit臒lmaxValue̒lw肵܂B
 * @param         maxthr [in] 臒l8bit臒lmaxThreshold̒lw肵܂B
 * @param         minthr [in] 臒l8bit臒lminThreshold̒lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>chɕsȒlw肳ꂽꍇ<p>typeɕsȒlw肳ꂽꍇ<p>PGP臒l^Cvgdl̎ minthr > maxthr ƂȂlw肳ꂽꍇ
 * @description   臒l 8bit 臒l̃p[^ݒ肵܂Bgdl̎ minthr > maxthr ƂȂl͎wł܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>ch</td><td>PGP臒l}XNvf</td></tr>
 *                <tr><td>type</td><td>PGP臒l^Cv</td></tr>
 *                <tr><td>maxval/maxthr/minthr</td><td> 8bit ̂ݗL</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigThreshold8Bit(AG903_PgpMgrPipelineHandle *handle, uint32_t ch, uint32_t type, uint32_t maxval, uint32_t maxthr, uint32_t minthr)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (ch) {
        case AG903_PGP_MGR_THR_CHANNEL_B:
        case AG903_PGP_MGR_THR_CHANNEL_G:
        case AG903_PGP_MGR_THR_CHANNEL_R:
            break;
        default:
            return -AG903_EINVAL;
    }
    switch (type) {
        case AG903_PGP_MGR_THR_8BIT_TYPE_THR_BIN:
        case AG903_PGP_MGR_THR_8BIT_TYPE_THR_BIN_INV:
        case AG903_PGP_MGR_THR_8BIT_TYPE_TRU:
        case AG903_PGP_MGR_THR_8BIT_TYPE_THR_ZERO:
        case AG903_PGP_MGR_THR_8BIT_TYPE_THR_ZERO_INV:
            break;
        case AG903_PGP_MGR_THR_8BIT_TYPE_THR_BIN_EXT:
        case AG903_PGP_MGR_THR_8BIT_TYPE_THR_BIN_INV_EXT:
        case AG903_PGP_MGR_THR_8BIT_TYPE_TRU_EXT:
        case AG903_PGP_MGR_THR_8BIT_TYPE_THR_ZERO_EXT:
        case AG903_PGP_MGR_THR_8BIT_TYPE_THR_ZERO_INV_EXT:
            if (minthr > maxthr) {
                return -AG903_EINVAL;
            }
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->thr_thr8_prm_type[ch] = type;
    handle->thr_thr8_prm_maxval[ch] = maxval & THR_8THR_MAXV_MASK;
    handle->thr_thr8_prm_maxthr[ch] = maxthr & THR_8THR_MAXTH_MASK;
    handle->thr_thr8_prm_minthr[ch] = minthr & THR_8THR_MINTH_MASK;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_THR_8BIT] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         臒l 1bit 臒lݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         h [in] 臒l1bit臒lp[^H̒lw肵܂B
 * @param         l [in] 臒l1bit臒lp[^L̒lw肵܂B
 * @param         x [in] 臒l1bit臒lp[^X̒lw肵܂B
 * @param         hmax [in] 臒l1bit臒lp[^HMAX̒lw肵܂B
 * @param         hmin [in] 臒l1bit臒lp[^HMIN̒lw肵܂B
 * @param         lmax [in] 臒l1bit臒lp[^LMAX̒lw肵܂B
 * @param         lmin [in] 臒l1bit臒lp[^LMIN̒lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @description   臒l 1bit 臒l̃p[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>h/l/x</td><td> 1bit ̂ݗL</td></tr>
 *                <tr><td>hmax/hmin/lmax/lmin</td><td> 8bit ̂ݗL</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigThreshold1Bit(AG903_PgpMgrPipelineHandle *handle, uint32_t h, uint32_t l, uint32_t x, uint32_t hmax, uint32_t hmin, uint32_t lmax, uint32_t lmin)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->thr_thr1_h = h & THR_MSK_L_MASK;
    handle->thr_thr1_l = l & THR_MSK_H_MASK;
    handle->thr_thr1_x = x & THR_MSK_X_MASK;
    handle->thr_thr1_hmax = hmax & THR_MSK_HMAX_MASK;
    handle->thr_thr1_hmin = hmin & THR_MSK_HMIN_MASK;
    handle->thr_thr1_lmax = lmax & THR_MSK_LMAX_MASK;
    handle->thr_thr1_lmin = lmin & THR_MSK_LMIN_MASK;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_THR_1BIT] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         臒l 1bit ԃtB^ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         coeff [in] 臒l1bitԃtB^Ww肵܂B
 * @param         thr [in] 臒l1bitԃtB^臒lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>coeffNULLw肳ꂽꍇ
 * @description   臒l 1bit ԃtB^̃p[^ݒ肵܂B
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>coeff</td><td> 1bit ̂ݗL</td></tr>
 *                <tr><td>thr</td><td> 6bit ̂ݗL</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigThresholdSpatialFilter1Bit(AG903_PgpMgrPipelineHandle *handle, int32_t coeff[9], int32_t thr)
{
    int32_t i;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (coeff == NULL) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    for (i = 0; i < 9; i++) {
        handle->thr_spf1_coeff[i] = coeff[i] & THR_SPF1_COEFF_MASK;
    }
    handle->thr_spf1_thr = thr & THR_SPF1_THR_MASK;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_THR_SP_FILTER_1BIT] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         xO̎s
 * @param         handle [in] xOspCvCnhw肵܂B
 * @param         cmd [in] sR}hw肵܂B
 * @return        䌋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>cmdɕsȒlw肳ꂽꍇ<p>pCvCnhIȃpCvCɊ蓖ĂĂȂꍇ
 * @retval        -AG903_EBUSY ̃pCvCnhspCvCŌݏ̏ꍇ<p>R}hxO̎sAL[ɋ󂫂ꍇ
 * @description   xO̐R}h𔭍s܂B<p>
 *                ڂ́AuPGPxOR}hvQƂĂB
*/
int32_t AG903_PgpMgrExecLabeling(AG903_PgpMgrPipelineHandle *handle, uint32_t cmd)
{
    PGPPrmParamPGPnSTATE state;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    switch (cmd) {
        case AG903_PGP_MGR_LBL_CMD_NONE:
        case AG903_PGP_MGR_LBL_CMD_EXEC:
        case AG903_PGP_MGR_LBL_CMD_DELETE:
        case AG903_PGP_MGR_LBL_CMD_RESET:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂȂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == false) {
        return -AG903_EINVAL;
    }
    /* s̕pCvC̃Xe[^X擾 */
    AG903_PgpPrmGetPGPnSTATE(handle->pipeline_no, &state);
    /* ̃pCvCnhݎs̏ꍇ̓G[ */
    if ((PgpContext.exec_pipeline[handle->pipeline_no] != handle ) && (state.st != AG903_PGP_MGR_STATE_IDLE)) {
        return -AG903_EBUSY;
    }

    PGPPrmParamPGPnLBLSTAT lblstat;
    AG903_PgpPrmGetPGPnLBLSTAT(handle->pipeline_no, &lblstat);
    /* xÕR}hL[ɋ󂫂Ȃ΃G[ */
    if ((cmd == AG903_PGP_MGR_LBL_CMD_EXEC) && (lblstat.queue == (AG903_PGP_MGR_LBL_CMD_MAX_QUEUE - 1))) {
        return -AG903_EBUSY;
    }

    /* Primitive LayerʂăxÕR}h𔭍s */
    AG903_PgpPrmSetPGPnLBLCMD(handle->pipeline_no, cmd);

    return AG903_ENONE;
}


/**
 * @brief         xȌo͗L/ԃp[^ݒ
 * @param         handle [in] xOspCvCnhw肵܂B
 * @param         vld [in] xȌo͗LԂ̒lw肵܂B
 * @param         inv [in] xȌo͖Ԃ̒lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>vldɕsȒlw肳ꂽꍇ<p>invɕsȒlw肳ꂽꍇ
 * @description   xȌo͗L/Ԃ̃p[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>vld</td><td>1 ~ AG903_PGP_MGR_MAX_LBL_OUTPUT_VALIDATE</td></tr>
 *                <tr><td>inv</td><td>0 ~ AG903_PGP_MGR_MAX_LBL_OUTPUT_INVALIDATE</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigLabelingValidTime(AG903_PgpMgrPipelineHandle *handle, uint32_t vld, uint32_t inv)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if ((vld == 0) || (vld > AG903_PGP_MGR_MAX_LBL_OUTPUT_VALIDATE)) {
        return -AG903_EINVAL;
    }
    if (inv > AG903_PGP_MGR_MAX_LBL_OUTPUT_INVALIDATE) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->lbl_valid = vld;
    handle->lbl_invalid = inv;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_LBL_PARAM] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         xO̐p[^ݒ
 * @param         handle [in] xOspCvCnhw肵܂B
 * @param         connect [in] xO̘A@w肵܂B
 * @param         flush_thr [in] xOte[ũtbVsȂ臒lw肵܂B
 * @param         max_id [in] xOte[uID̍őlw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>connectɕsȒlw肳ꂽꍇ<p>flush_thrɕsȒlw肳ꂽꍇ<p>max_idɕsȒlw肳ꂽꍇ
 * @description   xO̐p[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>connect</td><td>PGPxOA</td></tr>
 *                <tr><td>flush_thr</td><td>0 ~ AG903_PGP_MGR_MAX_LBL_FLUSH_THR</td></tr>
 *                <tr><td>max_id</td><td>0 ~ AG903_PGP_MGR_MAX_LBL_ID</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigLabelingParameter(AG903_PgpMgrPipelineHandle *handle, uint32_t connect, uint32_t flush_thr, uint32_t max_id)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (connect) {
        case AG903_PGP_MGR_LBL_CNCT_8:
        case AG903_PGP_MGR_LBL_CNCT_4:
            break;
        default:
            return -AG903_EINVAL;
    }
    if (flush_thr > AG903_PGP_MGR_MAX_LBL_FLUSH_THR) {
        return -AG903_EINVAL;
    }
    if (max_id > AG903_PGP_MGR_MAX_LBL_ID) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->lbl_connect = connect;
    handle->lbl_flush_thr = flush_thr;
    handle->lbl_maxid = max_id;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_LBL_PARAM] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         xOTCYݒ
 * @param         handle [in] xOspCvCnhw肵܂B
 * @param         vsize [in] xOTCYw肵܂B
 * @param         hsize [in] xOTCYw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>vsizeɕsȒlw肳ꂽꍇ<p>hsizeɕsȒlw肳ꂽꍇ
 * @description   xȌTCYݒ肵܂BLv`TCY𒴂l͐ݒ֎~łB<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>vsize</td><td>1 ~ AG903_PGP_MGR_MAX_LBL_VSIZE</td></tr>
 *                <tr><td>hsize</td><td>1 ~ AG903_PGP_MGR_MAX_LBL_HSIZE</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigLabelingSize(AG903_PgpMgrPipelineHandle *handle, uint32_t vsize, uint32_t hsize)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if ((vsize == 0) || (vsize > AG903_PGP_MGR_MAX_LBL_VSIZE)) {
        return -AG903_EINVAL;
    }
    if ((hsize == 0) || (hsize > AG903_PGP_MGR_MAX_LBL_HSIZE)) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->lbl_vsize = vsize;
    handle->lbl_hsize = hsize;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_LBL_SIZE] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         xOJnWݒ
 * @param         handle [in] xOspCvCnhw肵܂B
 * @param         vpos [in] xOJnWw肵܂B
 * @param         hpos [in] xOJnWw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>vposɕsȒlw肳ꂽꍇ<p>hposɕsȒlw肳ꂽꍇ
 * @description   xȌJnWݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>vsize</td><td>0 ~ AG903_PGP_MGR_MAX_LBL_POS</td></tr>
 *                <tr><td>hsize</td><td>0 ~ AG903_PGP_MGR_MAX_LBL_POS</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigLabelingPosition(AG903_PgpMgrPipelineHandle *handle, uint32_t vpos, uint32_t hpos)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (vpos > AG903_PGP_MGR_MAX_LBL_POS) {
        return -AG903_EINVAL;
    }
    if (hpos > AG903_PGP_MGR_MAX_LBL_POS) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->lbl_vpos = vpos;
    handle->lbl_hpos = hpos;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_LBL_POS] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         xOto͐̃x[XAhXݒ
 * @param         handle [in] xOspCvCnhw肵܂B
 * @param         addr [in] xOto͐x[XAhX̃|C^w肵܂B(8oCgACKv)
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>addrNULLw肳ꂽꍇ
 * @description   xOto͐̃x[XAhXݒ肵܂B
*/
int32_t AG903_PgpMgrSetConfigLabelingBaseAddr(AG903_PgpMgrPipelineHandle *handle, void *addr)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (addr == NULL) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->lbl_addr = (uint32_t)addr;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_LBL_BASE_ADDR] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         xÕobt@ǗjbggpLݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @param         enable [in] obt@Ǘjbg̗Lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY pCvC蓖Čɖ{֐Ăяoꂽꍇ
 * @description   xÕobt@ǗjbggpLݒ肵܂B
 * @note          {֐ł̃p[^ݒ̓pCvC蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrEnableParamLabelingBMU(AG903_PgpMgrPipelineHandle *handle, _Bool enable)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == true) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->lbl_bmu = enable;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         xÕXe[^X擾
 * @param         handle [in] pCvCnhw肵܂B
 * @param         id [out] xOte[uIDi[|C^w肵܂B
 * @param         is_vram_out [out] VRAMo͒ł邱ƂtOi[|C^w肵܂B
 * @param         is_act [out] xOsł邱ƎtOi[|C^w肵܂B
 * @param         queue_cnt [out] L[ɗ߂R}hi[|C^w肵܂B
 * @param         exec_cmd [out] xO̎s̃R}hi[|C^w肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>pCvCIɊ蓖ĂĂȂꍇ<p>蓖Đ̕pCvC̃pCvCnhŎgpĂꍇ
 * @description   xÕXe[^X擾܂B
 * @note          i[|C^=NULL ̏ꍇA̒l͎擾܂B
*/
int32_t AG903_PgpMgrGetLabelingStatus(AG903_PgpMgrPipelineHandle *handle, uint32_t *id, _Bool *is_vram_out, _Bool *is_act, uint32_t *queue_cnt, uint32_t *exec_cmd)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂȂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == false) {
        return -AG903_EINVAL;
    }

    /* Primitive LayerʂĒl擾܂ */
    PGPPrmParamPGPnLBLSTAT lblstat;
    AG903_PgpPrmGetPGPnLBLSTAT(handle->pipeline_no, &lblstat);

    /* 蓖Đ̕pCvC̃pCvCnhɎgpĂꍇ̓G[Ƃ܂ */
    if ((PgpContext.exec_pipeline[handle->pipeline_no] != handle) && (lblstat.cmd != AG903_PGP_MGR_LBL_CMD_NONE)) {
        return -AG903_EINVAL;
    }
    if (id != NULL) {
        *id = lblstat.l_id;
    }
    if (is_vram_out != NULL) {
        *is_vram_out = lblstat.vrmacc;
    }
    if (is_act != NULL) {
        *is_act = lblstat.act;
    }
    if (queue_cnt != NULL) {
        *queue_cnt = lblstat.queue;
    }
    if (exec_cmd != NULL) {
        *exec_cmd = lblstat.cmd;
    }
    return AG903_ENONE;
}


/**
 * @brief         xOte[ủ
 * @param         src [in] xOte[ui[ꂽ|C^w肵܂B
 * @param         tbl_num [in] xOte[uw肵܂B(1)
 * @param         dst [out] ͌̃xOte[ui[|C^w肵܂B
 * @return        ͌
 * @retval        ͌̃e[u 
 * @retval        -AG903_ENOMEM AP[gɎsꍇ
 * @retval        -AG903_EINVAL srcNULLw肳ꂽꍇ<p>tbl_num1̒lw肳ꂽꍇ
 * @description   xOte[u͂܂B<p>
 *                xOt (xmin, ymin) (xmax, ymax) ̋`̈̂אڂ̂̋`̈ƂĂ܂Ƃ߂܂B<p>
 *                 dst ɕԂ͌ʂ̓Cuɂ蓮IɊmۂꂽłB͌ʎgp AG903_PgpMgrReleaseLabelingTableɂĊJĉB
 * @note          xOte[ũtH[}bǵALSIdlQƂĂB
*/
int32_t AG903_PgpMgrAnalyzeLabelingTable(void *src, uint32_t tbl_num, void **dst)
{
    uint32_t dst_num;

    /* ̃G[`FbN */
    if (src == NULL) {
        return -AG903_EINVAL;
    }
    if (tbl_num < 1) {
        return -AG903_EINVAL;
    }

    /* ͌ʂdstɊi[܂ */
    *dst = PgpMgrAnalyzeLabelingTable(src, tbl_num, &dst_num);

    /* o̓e[u == 0 */
    if (dst_num == 0) {
        return 0;
    }

    /* dstNULL̏ꍇ͊i[惁̈̊mۂɎsƔf܂ */
    if (*dst == NULL) {
        return -AG903_ENOMEM;
    }

    return dst_num;
}


/**
 * @brief         xOte[ůJ
 * @param         tbl [in] ͌̃xOte[ui[|C^w肵܂B
 * @return        s
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL ُ
 * @note          ̊֐ AG903_PgpMgrAnalyzeLabelingTableƑ΂ŎgpĉB
*/
int32_t AG903_PgpMgrReleaseLabelingTable(void *tbl)
{
	if (tbl == NULL) {
		return -AG903_EINVAL;
	}
	PgpMgrReleaseLabelingTable(tbl);
	return AG903_ENONE;
}


/**
 * @brief         t[ԉZnh擾
 * @param         handle [out] 擾t[ԉZnhi[|C^w肵܂B
 * @param         master [in] }X^ƂĎgppCvCnhw肵܂B
 * @param         slave [in] X[uƂĎgppCvCnhA܂VRAM̓nhw肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL
 *                擾\ȍőnh𒴂ꍇ<p>masterɗLȃpCvCnhȊOw肳ꂽꍇ<p>slaveɗLȃpCvCnh܂VRAM̓nhȊOw肳ꂽꍇ<p>handlesNULLw肳ꂽꍇ
 * @retval        -AG903_EBUSY masterɎw肳ꂽpCvCnhɊ蓖čς̏ꍇ<p>slaveɃpCvCnhw肳AAw肳ꂽpCvCnhɊ蓖čς̏ꍇ
 * @description   t[ԉZ̃nh擾܂B<p>
 *                t[ԉZ̃nh̓}X^[ƂȂpCvCnhƃX[ũpCvCnh܂VRAM̓nh쐬܂B
 * @note          t[ԉZnh̏́AAG903_PGP_MGR_MAX_FRAME_CALC_HANDLE ƂȂ܂B<p>
 *                얳̏ꍇ̏́AAG903_PGP_MGR_CALC_PIPELINE_NUM ƂȂ܂B
*/
int32_t AG903_PgpMgrGetFrameCalcHandle(AG903_PgpMgrFrameCalcHandle **handle, AG903_PgpMgrPipelineHandle *master, void *slave)
{
    int32_t i;
    AG903_PgpMgrPipelineHandle *slave_pipeline = (AG903_PgpMgrPipelineHandle *)slave;
    AG903_PgpMgrVRAMInputHandle *slave_vram = (AG903_PgpMgrVRAMInputHandle *)slave;

    /* LAɂ擾\ȍőnh͈ق܂ */
    if (PgpContext.pipeline_time_sharing_enable == true) {
        if ((PgpContext.num_frame_calc_handles + 1) > AG903_PGP_MGR_MAX_FRAME_CALC_HANDLE) {
            return -AG903_ENOMEM;
        }
    } else {
        if ((PgpContext.num_frame_calc_handles + 1) > AG903_PGP_MGR_CALC_PIPELINE_NUM) {
            return -AG903_ENOMEM;
        }
    }

    if ((handle == NULL) || (master == NULL) || (slave == NULL)) {
        return -AG903_EINVAL;
    }

    /* }X^pCvCnht[ԉZƂĎgp\`FbN܂ */
    if (master->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID) {
        return -AG903_EINVAL;
    }
    if ((master->is_assign == true) || (master->is_used_frame_calc == true)) {
        return -AG903_EBUSY;
    }
    /* X[unht[ԉZƂĎgp\`FbN܂ */
    if (slave_pipeline->id == AG903_PGP_MGR_PIPELINE_HANDLE_ID) {
        if ((slave_pipeline->is_assign == true) || (slave_pipeline->is_used_frame_calc == true)) {
            return -AG903_EBUSY;
        }
        slave_pipeline->frame_out_enable = false;
        slave_pipeline->is_used_frame_calc = true;
        slave_pipeline->is_dirty = true;
    } else if (slave_vram->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
        slave_vram->ref_cnt++;
    } else {
        return -AG903_EINVAL;
    }
    master->ifc_enable = true;
    master->is_used_frame_calc = true;
    master->is_dirty = true;

    /* gp\ȃt[ԉZnhAhandlesɊi[܂ */
    for (i = 0; i < AG903_PGP_MGR_MAX_FRAME_CALC_HANDLE; i++) {
        if (PgpContext.frame_calc_handles[i].is_used == false) {
            PgpContext.frame_calc_handles[i].is_used = true;
            PgpContext.frame_calc_handles[i].master_handle = master;
            PgpContext.frame_calc_handles[i].slave_handle = slave;
            PgpContext.frame_calc_handles[i].id = AG903_PGP_MGR_FRAME_CALC_HANDLE_ID;
            PgpContext.frame_calc_handles[i].slave_pipeline = (slave_pipeline->id == AG903_PGP_MGR_PIPELINE_HANDLE_ID) ? true : false;
            *handle = &PgpContext.frame_calc_handles[i];
            break;
        }
    }
    PgpContext.num_frame_calc_handles++;
    return AG903_ENONE;
}


/**
 * @brief         t[ԉZnh
 * @param         handle [in] t[ԉZnhw肵܂B
 * @return        
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY w肳ꂽt[ԉZnhݎs̏ꍇ
 * @description   w肳ꂽt[ԉZnh܂B
*/
int32_t AG903_PgpMgrReleaseFrameCalcHandle(AG903_PgpMgrFrameCalcHandle *handle)
{
    AG903_PgpMgrPipelineHandle *slave_pipeline;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_FRAME_CALC_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvC̊蓖ĂsȂĂꍇɈȉ̏sȂ܂(}X^蓖ĂĂꍇAX[u蓖čςƂ܂) */
    if (handle->master_handle->pipeline_no != -1) {
        /* pCvCnhgpł̏ꍇ̓G[Ƃ܂ */
        if (PgpContext.exec_pipeline[handle->master_handle->pipeline_no] == handle->master_handle) {
            PGPPrmParamPGPnSTATE state;
            AG903_PgpPrmGetPGPnSTATE(handle->master_handle->pipeline_no, &state);
            if (state.st != AG903_PGP_MGR_STATE_IDLE) {
                return -AG903_EBUSY;
            }
            PgpContext.exec_pipeline[handle->master_handle->pipeline_no] = NULL;
        }
        /* 蓖ēŊ蓖Đ悪w肳Ăꍇ͉܂ */
        if (PgpContext.assign_pipeline[handle->master_handle->pipeline_no] == handle->master_handle) {
            PgpContext.assign_pipeline[handle->master_handle->pipeline_no] = NULL;
        }
        if (handle->slave_pipeline == true) {
            slave_pipeline = (AG903_PgpMgrPipelineHandle *)handle->slave_handle;
            if (PgpContext.assign_pipeline[slave_pipeline->pipeline_no] == slave_pipeline) {
                PgpContext.assign_pipeline[slave_pipeline->pipeline_no] = NULL;
            }
        }
    }

    /* t[ԉZnh̐ݒ肩}X^AX[u܂ */
    handle->master_handle->ifc_enable = false;
    handle->master_handle->is_used_frame_calc = false;
    handle->master_handle->is_assign = false;
    handle->master_handle->pipeline_no = -1;
    handle->master_handle->is_dirty = true;
    if (handle->slave_pipeline == true) {
        slave_pipeline = (AG903_PgpMgrPipelineHandle *)handle->slave_handle;
        if ((slave_pipeline->pipeline_no != -1) && (PgpContext.exec_pipeline[slave_pipeline->pipeline_no] == slave_pipeline)) {
            PgpContext.exec_pipeline[slave_pipeline->pipeline_no] = NULL;
        }
        slave_pipeline->frame_out_enable = true;
        slave_pipeline->is_used_frame_calc = false;
        slave_pipeline->is_assign = false;
        slave_pipeline->pipeline_no = -1;
        slave_pipeline->is_dirty = true;
    } else {
        AG903_PgpMgrVRAMInputHandle *slave_vram = (AG903_PgpMgrVRAMInputHandle *)handle->slave_handle;
        slave_vram->ref_cnt--;
    }

    handle->is_used = false;
    handle->id = 0;
    PgpContext.num_frame_calc_handles--;
    return AG903_ENONE;
}


/**
 * @brief         t[ԉZp[^ݒ
 * @param         handle [in] t[ԉZnhw肵܂B
 * @param         scan [in] t[@w肵܂B
 * @param         limit [in] o͒l̃~bgw肵܂B
 * @param         slave_src [in] X[u̓̓\[Xw肵܂B
 * @param         operation [in] t[Ԃ̉Z@w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>
 *                scanɕsȒlw肳ꂽꍇ<p>limitɕsȒlw肳ꂽꍇ<p>slave_srcɕsȒlw肳ꂽꍇ<p>operationɕsȒlw肳ꂽꍇ
 * @description   t[ԉZ̃p[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>scan</td><td>PGPt[@</td></tr>
 *                <tr><td>limit</td><td>PGP~bg</td></tr>
 *                <tr><td>slave_src</td><td>PGPt[̓\[X</td></tr>
 *                <tr><td>operation</td><td>PGPt[ԉZ@</td></tr>
 *                </table>
 *                PGP~bg ̂AAG903_PGP_MGR_LIMIT_0_255 / AG903_PGP_MGR_LIMIT_16_235_AND_240 / AG903_PGP_MGR_IFC_LIMIT_M128_127 w\łB
*/
int32_t AG903_PgpMgrSetConfigFrameCalcParameter(AG903_PgpMgrFrameCalcHandle *handle, uint32_t scan, uint32_t limit, uint32_t slave_src, uint32_t operation)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_FRAME_CALC_HANDLE_ID)) {
        return -AG903_EINVAL;
    }
    /* ̃G[`FbN */
    switch (scan) {
        case AG903_PGP_MGR_SCAN_PROGRESSIVE:
        case AG903_PGP_MGR_SCAN_INTERLACE:
            break;
        default:
            return -AG903_EINVAL;
    }
    switch (limit) {
        case AG903_PGP_MGR_IFC_LIMIT_0_255:
        case AG903_PGP_MGR_IFC_LIMIT_16_235_AND_240:
        case AG903_PGP_MGR_IFC_LIMIT_M128_127:
            break;
        default:
            return -AG903_EINVAL;
    }
    switch (slave_src) {
        case AG903_PGP_MGR_IFC_SLAVE_VRAM_UI:
        case AG903_PGP_MGR_IFC_SLAVE_VRAM_I:
        case AG903_PGP_MGR_IFC_SLAVE_PIPELINE:
            break;
        default:
            return -AG903_EINVAL;
    }
    switch (operation) {
        case AG903_PGP_MGR_IFC_OP_AND:
        case AG903_PGP_MGR_IFC_OP_OR:
        case AG903_PGP_MGR_IFC_OP_XOR:
        case AG903_PGP_MGR_IFC_OP_ADD:
        case AG903_PGP_MGR_IFC_OP_ABS:
            break;
        default:
            return -AG903_EINVAL;
    }
    /* p[^nhɕێADirtytOZbg܂ */
    handle->master_handle->ifc_scan = scan;
    handle->master_handle->ifc_limit = limit;
    handle->master_handle->ifc_slave_src = (handle->slave_pipeline == true) ? AG903_PGP_MGR_IFC_SLAVE_PIPELINE : slave_src;
    handle->master_handle->ifc_operation = operation;
    handle->master_handle->is_config_dirty[AG903_PGP_MGR_CONFIG_IFC_PARAM] = true;
    handle->master_handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         t[ԉZ̃QCp[^ݒ
 * @param         handle [in] t[ԉZnhw肵܂B
 * @param         master_gain [in] }X^͂̃QCw肵܂B
 * @param         slave_gain [in] X[u͂̃QCw肵܂B
 * @param         master_shift [in] }X^͂̃QCZʂ̃Vtgʂw肵܂B
 * @param         slave_shift [in] X[u͂̃QCZʂ̃Vtgʂw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @description   t[ԉZ̃QCp[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>master_gain</td><td> 8bit ̂ݗL</td></tr>
 *                <tr><td>slave_gain</td><td> 8bit ̂ݗL</td></tr>
 *                <tr><td>master_shift</td><td>0 ~ AG903_PGP_MGR_MAX_IFC_GAIN_SHIFT</td></tr>
 *                <tr><td>slave_shift</td><td>0 ~ AG903_PGP_MGR_MAX_IFC_GAIN_SHIFT</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigFrameCalcGain(AG903_PgpMgrFrameCalcHandle *handle, int32_t master_gain, int32_t slave_gain, uint32_t master_shift, uint32_t slave_shift)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_FRAME_CALC_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (master_shift > AG903_PGP_MGR_MAX_IFC_GAIN_SHIFT) {
        return -AG903_EINVAL;
    }
    if (slave_shift > AG903_PGP_MGR_MAX_IFC_GAIN_SHIFT) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->master_handle->ifc_master_gain = master_gain & IFC_GAIN_MASK;
    handle->master_handle->ifc_slave_gain = slave_gain & IFC_GAIN_MASK;
    handle->master_handle->ifc_master_shift = master_shift;
    handle->master_handle->ifc_slave_shift = slave_shift;
    handle->master_handle->is_config_dirty[AG903_PGP_MGR_CONFIG_IFC_PARAM] = true;
    handle->master_handle->is_config_dirty[AG903_PGP_MGR_CONFIG_IFC_GAIN] = true;
    handle->master_handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         w肵VRAM̓nh擾
 * @param         num [in] 擾VRAM̓nh̐w肵܂B
 * @param         handles [out] 擾VRAM̓nhi[|C^w肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL numɎw肵ƁA擾ςVRAM̓nh̍vlőnh𒴂ꍇ<p>handlesNULLw肳ꂽꍇ
 * @description   VRAM͂̃nh擾܂B
 * @note          VRAM̓nh̏́AAG903_PGP_MGR_MAX_VRAMI_HANDLE ƂȂ܂B<p>
 *                얳̏ꍇ̏́AAG903_PGP_MGR_VRAMI_NUM ƂȂ܂B
 *
 *
*/
int32_t AG903_PgpMgrGetVRAMInputHandle(int32_t num, AG903_PgpMgrVRAMInputHandle **handles)
{
    int i, j;

    /* LAɂ擾\ȍőnh͈ق܂ */
    if (PgpContext.pipeline_time_sharing_enable == true) {
        if ((num + PgpContext.num_vram_input_handles) > AG903_PGP_MGR_MAX_VRAMI_HANDLE) {
            return -AG903_EINVAL;
        }
    } else {
        if ((num + PgpContext.num_vram_input_handles) > AG903_PGP_MGR_VRAMI_NUM) {
            return -AG903_EINVAL;
        }
    }

    if (handles == NULL) {
        return -AG903_EINVAL;
    }

    /* gp\VRAM̓nhAhandlesɊi[܂ */
    for (i = 0; i < num; i++) {
        for (j = 0; j < AG903_PGP_MGR_MAX_VRAMI_HANDLE; j++) {
            if (PgpContext.vram_input_handles[j].is_used == false) {
                /* nh̐ݒl܂B */
                PgpMgrInitVRAMInputHandle(&PgpContext.vram_input_handles[j]);

                PgpContext.vram_input_handles[j].is_used = true;
                PgpContext.vram_input_handles[j].id = AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID;
                handles[i] = &PgpContext.vram_input_handles[j];
                break;
            }
        }
    }

    PgpContext.num_vram_input_handles += num;

    return AG903_ENONE;
}


/**
 * @brief         VRAM̓nh
 * @param         handle [in] VRAM̓nhw肵܂B
 * @return        
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY w肳ꂽVRAM̓nh̃nhɊ֘AtĂꍇ
 * @description   w肳ꂽVRAM̓nh܂B
*/
int32_t AG903_PgpMgrReleaseVRAMInputHandle(AG903_PgpMgrVRAMInputHandle *handle)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃nhɊ֘AtĂ(t@XJEg0ȊO)̏ꍇ̓G[Ƃ܂ */
    if (handle->ref_cnt != 0) {
        return -AG903_EBUSY;
    }

    if (PgpContext.assign_vram[handle->port_no] == handle) {
        PgpContext.assign_vram[handle->port_no] = NULL;
    }
    if (PgpContext.exec_vram[handle->port_no] == handle) {
        PgpContext.exec_vram[handle->port_no] = NULL;
    }

    handle->is_used = false;
    handle->id = 0;
    PgpContext.num_vram_input_handles--;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̎s
 * @param         handle [in] sVRAM̓nhw肵܂B
 * @param         cmd [in] sR}hw肵܂B
 * @return        䌋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>cmdɕsȒlw肳ꂽꍇ<p>̓|[g̊蓖ĂsȂĂȂꍇ
 * @retval        -AG903_EBUSY VRAM̓nhs|[gŌݏ̏ꍇ<p>VRAM͂̃R}hL[ɋ󂫂ꍇAR}h󂯂Ԃł͖ꍇ
 * @description   VRAM͂̃R}h𔭍s܂B<p>
 *                ڂ́AuPGPVRAM̓R}hvQƂĂB
*/
int32_t AG903_PgpMgrExecVRAMInput(AG903_PgpMgrVRAMInputHandle *handle, uint32_t cmd)
{
    uint32_t dummy, queue, st;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* 蓖đȌꍇ̓G[Ƃ܂ */
    if (handle->port_no == -1) {
        return -AG903_EINVAL;
    }
    /* s̕|[g̃Xe[^X擾 */
    AG903_PgpPrmGetPGPVInSTATE(handle->port_no, &dummy, &queue, &st);
    /* VRAM̓nhݎs̏ꍇ̓G[ */
    if ((PgpContext.exec_vram[handle->port_no] != handle ) && (st != AG903_PGP_MGR_VI_CMD_NONE)) {
        return -AG903_EBUSY;
    }

    switch (cmd) {
        case AG903_PGP_MGR_VI_CMD_EXEC:
            /* R}hL[ɋ󂫂ȂA܂́ÃR}hs̏ꍇG[ */
            if ((queue == (AG903_PGP_MGR_VI_CMD_MAX_QUEUE - 1)) || ((st != 0) && (cmd != st))) {
                return -AG903_EBUSY;
            }
            break;
        case AG903_PGP_MGR_VI_CMD_EXEC_CONTINUE:
            /* As̓AChԂ̂݃R}h󂯂\ */
            if (st != 0) {
                return -AG903_EBUSY;
            }
            break;
        case AG903_PGP_MGR_VI_CMD_NONE:
        case AG903_PGP_MGR_VI_CMD_IDLE:
        case AG903_PGP_MGR_VI_CMD_RESET:
            break;
        default:
            return -AG903_EINVAL;
    }
    /* R}hs */
    PgpMgrExecVRAMInputHandle(handle, cmd);
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̃Xe[^X擾
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         is_vram_out [out] VRAMo͒ł邱ƂtOi[|C^w肵܂B
 * @param         queue_cnt [out] L[ɗ߂R}hi[|C^w肵܂B
 * @param         exec_cmd [out] VRAM͂̎s̃R}hi[|C^w肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>pCvCIɊ蓖ĂĂȂꍇ<p>蓖Đ̕VRAM|[gVRAM͂ŎgpĂꍇ
 * @description   VRAM͂̃Xe[^X擾܂B
 * @note          i[|C^=NULL̏ꍇAl͎擾܂B
*/
int32_t AG903_PgpMgrGetVRAMStatus(AG903_PgpMgrVRAMInputHandle *handle, _Bool *is_vram_out, uint32_t *queue_cnt, uint32_t *exec_cmd)
{
    uint32_t tmp_vram, tmp_queue, tmp_st;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* |[gɊ蓖ĂĂȂꍇ̓G[Ƃ܂ */
    if (handle->port_no == -1) {
        return -AG903_EINVAL;
    }

    /* Primitive LayerʂĒl擾܂ */
    AG903_PgpPrmGetPGPVInSTATE(handle->port_no, &tmp_vram, &tmp_queue, &tmp_st);

    /* 蓖Đ̕VRAM|[gVRAM̓nhɎgpĂꍇ̓G[Ƃ܂ */
    if ((PgpContext.exec_vram[handle->port_no] != handle) && (tmp_st != AG903_PGP_MGR_VI_CMD_NONE)) {
        return -AG903_EINVAL;
    }
    if (is_vram_out != NULL) {
        *is_vram_out = tmp_vram;
    }
    if (queue_cnt != NULL) {
        *queue_cnt = tmp_queue;
    }
    if (exec_cmd != NULL) {
        *exec_cmd = tmp_st;
    }
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̃obt@Ǘjbgݒ
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         bmu [in] obt@Ǘjbgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>bmuɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY VRAM|[g蓖Čɖ{֐Ăяoꂽꍇ
 * @description   VRAM͂̃obt@Ǘjbgݒ肵܂B<p>
 *                ڂ́AuPGPVRAMBMUݒvQƂĂB
 * @note          {֐ł̃p[^ݒVRAM|[g蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamVRAMInputBMU(AG903_PgpMgrVRAMInputHandle *handle, uint32_t bmu)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (bmu) {
        case AG903_PGP_MGR_VI_BMU_NONE:
        case AG903_PGP_MGR_VI_BMU_ENABLE:
        case AG903_PGP_MGR_VI_BMU_ENABLE_ODD:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* VRAM|[gɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->port_no != -1) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->bmu = bmu;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̃t[@ݒ
 * @param         handle [in] sVRAM̓nhw肵܂B
 * @param         scan [in] t[@w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>scanɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY VRAM|[g蓖Čɖ{֐Ăяoꂽꍇ
 * @description   VRAM͎̃t[@̃p[^ݒ肵܂B<p>
 *                ڂ́AuPGPt[@vQƂĂB
 * @note          {֐ł̃p[^ݒVRAM|[g蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamVRAMInputScan(AG903_PgpMgrVRAMInputHandle *handle, uint32_t scan)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (scan) {
        case AG903_PGP_MGR_SCAN_PROGRESSIVE:
        case AG903_PGP_MGR_SCAN_INTERLACE:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* VRAM|[gɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->port_no != -1) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->scan = scan;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̃AhXw@ݒ
 * @param         handle [in] sVRAM̓nhw肵܂B
 * @param         dim [in] AhXw@w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>dimɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY VRAM|[g蓖Čɖ{֐Ăяoꂽꍇ
 * @description   VRAM͎̃AhXw@ݒ肵܂B<p>
 *                ڂ́AuPGPAhXw@vQƂĂB
 * @note          {֐ł̃p[^ݒVRAM|[g蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamVRAMInputAddrDim(AG903_PgpMgrVRAMInputHandle *handle, uint32_t dim)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (dim) {
        case AG903_PGP_MGR_ADDR_DIMENTION_1:
        case AG903_PGP_MGR_ADDR_DIMENTION_2:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* VRAM|[gɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->port_no != -1) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->dim = dim;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̃f[^Xbvݒ
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         word [in] [hf[^̃Xbv̗LtOw肵܂B
 * @param         hword [in] n[t[hf[^̃Xbv̗LtOw肵܂B
 * @param         four_bit [in] 4bitf[^̃Xbv̗LtOw肵܂B
 * @param         ont_bit [in] 1bitf[^̃Xbv̗LtOw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @description   VRAM͎̃f[^Xbvݒ肵܂B
*/
int32_t AG903_PgpMgrSetConfigVRAMDataSwap(AG903_PgpMgrVRAMInputHandle *handle, _Bool word, _Bool hword, _Bool four_bit, _Bool one_bit)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->vram_word_swap_enable = word;
    handle->vram_hword_swap_enable = hword;
    handle->vram_4bit_swap_enable = four_bit;
    handle->vram_1bit_swap_enable = one_bit;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_VI_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̃C^[Xt[̓ǂ݂@ݒ
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         frame_read [in] C^[Xt[̓ǂ݂@w肵܂B
 * @param         fai [in] t[ẗ̗XLbv@\LtOw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>frame_readɕsȒlw肳ꂽꍇ
 * @description   VRAM͂̃C^[Xt[̓ǂݏo@ݒ肵܂B<p>
 *                ڂ́AuPGPVRAM̓t[ǂݏo@vQƂĂB
*/
int32_t AG903_PgpMgrSetConfigVRAMInterlaceFrame(AG903_PgpMgrVRAMInputHandle *handle, uint32_t frame_read, _Bool fai)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (frame_read) {
        case AG903_PGP_MGR_VI_FRAME_READ_ODD:
        case AG903_PGP_MGR_VI_FRAME_READ_EVEN:
        case AG903_PGP_MGR_VI_FRAME_READ_FIELD:
        case AG903_PGP_MGR_VI_FRAME_READ_WEAVE:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->md = frame_read;
    handle->fai_enable = fai;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_VI_CTRL] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̏o͗L/ԃp[^ݒ
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         div [in] o͊Ԃ̈L΂ݒw肵܂B
 * @param         vld [in] o͗LԂw肵܂B
 * @param         inv [in] o͖Ԃw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>divɕsȒlw肳ꂽꍇ<p>vldɕsȒlw肳ꂽꍇ<p>invɕsȒlw肳ꂽꍇ
 * @description   VRAMo̗͂L/ԃp[^ݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>div</td><td>1 ~ AG903_PGP_MGR_MAX_VI_DIV</td></tr>
 *                <tr><td>vld</td><td>1 ~ AG903_PGP_MGR_MAX_VI_VALIDATE</td></tr>
 *                <tr><td>inv</td><td>0 ~ AG903_PGP_MGR_MAX_VI_INVALIDATE</td></tr>
 *                </table>
*/
int32_t AG903_PgpMgrSetConfigVRAMValidTime(AG903_PgpMgrVRAMInputHandle *handle, uint32_t div, uint32_t vld, uint32_t inv)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if ((div == 0) || (div > AG903_PGP_MGR_MAX_VI_DIV)) {
        return -AG903_EINVAL;
    }
    if ((vld == 0) || (vld > AG903_PGP_MGR_MAX_VI_VALIDATE)) {
        return -AG903_EINVAL;
    }
    if (inv > AG903_PGP_MGR_MAX_VI_INVALIDATE) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->div = div;
    handle->valid = vld;
    handle->invalid = inv;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_VI_CTRL1] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̃tH[}bgݒ
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         format [in] ̓tH[}bgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>formatɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY VRAM|[g蓖Čɖ{֐Ăяoꂽꍇ
 * @description   VRAM̓tH[}bgݒ肵܂B<p>
 *                ڂ́AuPGPVRAM̓tH[}bgvQƂĂB
 * @note          {֐ł̃p[^ݒVRAM|[g蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamVRAMFormat(AG903_PgpMgrVRAMInputHandle *handle, uint32_t format)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    switch (format) {
        case AG903_PGP_MGR_VI_FMT_RGB888_32:
        case AG903_PGP_MGR_VI_FMT_RGB888_24:
        case AG903_PGP_MGR_VI_FMT_RGB565:
        case AG903_PGP_MGR_VI_FMT_YCBCR444_32:
        case AG903_PGP_MGR_VI_FMT_YCBCR444_24:
        case AG903_PGP_MGR_VI_FMT_YCBCR422:
        case AG903_PGP_MGR_VI_FMT_CLUT8:
        case AG903_PGP_MGR_VI_FMT_CLUT1:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* VRAM|[gɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->port_no != -1) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->format = format;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̏o͐x[XAhXݒ
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         addr [in] o͐x[XAhX̃|C^w肵܂B(8oCgACKv)
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>addrNULLw肳ꂽꍇ
 * @description   VRAM͂̏o͐x[XAhXݒ肵܂B
*/
int32_t AG903_PgpMgrSetConfigVRAMBaseAddr(AG903_PgpMgrVRAMInputHandle *handle, void *addr)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if (addr == NULL) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->addr = (uint32_t)addr;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_VI_BASE] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂񎟌AhX̏ꍇ̃XgChoCgݒ
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         stride [in] 2AhX̏ꍇ̃XgChoCgw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>strideɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY VRAM|[g蓖Čɖ{֐Ăяoꂽꍇ
 * @description   VRAM͂񎟌AhX̏ꍇ̃XgChoCgݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>stride</td><td>1 ~ AG903_PGP_MGR_VI_MAX_STRIDE_BYTE</td></tr>
 *                </table>
 * @note          {֐ł̃p[^ݒVRAM|[g蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamVRAMStride(AG903_PgpMgrVRAMInputHandle *handle, uint32_t stride)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if ((stride == 0) || (stride > AG903_PGP_MGR_VI_MAX_STRIDE_BYTE)) {
        return -AG903_EINVAL;
    }

    /* VRAM|[gɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->port_no != -1) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->stride = stride;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̓Mo̓p[^ݒ
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         h_pw [in] MpXw肵܂B
 * @param         h_fp [in] tg|[`w肵܂B
 * @param         h_bp [in] obN|[`w肵܂B
 * @param         v_pw [in] MpXw肵܂B
 * @param         v_fp [in] tg|[`w肵܂B
 * @param         v_bp [in] obN|[`w肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handle/h_pw/h_fp/h_bp/v_pw/v_fp/v_bpɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY VRAM|[g蓖Čɖ{֐Ăяoꂽꍇ
 * @description   VRAM͂̓M̏o̓p[^ݒ肵܂B<p>
 *                (h_pw + h_fp + h_bp + TCY)16sNZȏɐݒ肵ĉB<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>h_pw</td><td>1 ~ AG903_PGP_MGR_MAX_VI_H_PULES_WIDTH</td></tr>
 *                <tr><td>h_fp</td><td>1 ~ AG903_PGP_MGR_MAX_VI_H_FRONT_PORCH</td></tr>
 *                <tr><td>h_bp</td><td>1 ~ AG903_PGP_MGR_MAX_VI_H_BACK_PORCH</td></tr>
 *                <tr><td>v_pw</td><td>1 ~ AG903_PGP_MGR_MAX_VI_V_PULES_WIDTH</td></tr>
 *                <tr><td>v_fp</td><td>1 ~ AG903_PGP_MGR_MAX_VI_V_FRONT_PORCH</td></tr>
 *                <tr><td>v_bp</td><td>1 ~ AG903_PGP_MGR_MAX_VI_V_BACK_PORCH</td></tr>
 *                </table>
 * @note          {֐ł̃p[^ݒVRAM|[g蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamVRAMSyncSignal(AG903_PgpMgrVRAMInputHandle *handle, uint32_t h_pw, uint32_t h_fp, uint32_t h_bp, uint32_t v_pw, uint32_t v_fp, uint32_t v_bp)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if ((h_pw == 0) || (h_pw > AG903_PGP_MGR_MAX_VI_H_PULES_WIDTH)) {
        return -AG903_EINVAL;
    }
    if ((h_fp == 0) || (h_fp > AG903_PGP_MGR_MAX_VI_H_FRONT_PORCH)) {
        return -AG903_EINVAL;
    }
    if ((h_bp == 0) || (h_bp > AG903_PGP_MGR_MAX_VI_H_BACK_PORCH)) {
        return -AG903_EINVAL;
    }
    if ((v_pw == 0) || (v_pw > AG903_PGP_MGR_MAX_VI_V_PULES_WIDTH)) {
        return -AG903_EINVAL;
    }
    if ((v_fp == 0) || (v_fp > AG903_PGP_MGR_MAX_VI_V_FRONT_PORCH)) {
        return -AG903_EINVAL;
    }
    if ((v_bp == 0) || (v_bp > AG903_PGP_MGR_MAX_VI_V_BACK_PORCH)) {
        return -AG903_EINVAL;
    }

    /* VRAM|[gɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->port_no != -1) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->h_pulse_width = h_pw;
    handle->h_front_porch = h_fp;
    handle->h_back_porch = h_bp;
    handle->v_pulse_width = v_pw;
    handle->v_front_porch = v_fp;
    handle->v_back_porch = v_bp;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̃t[TCYݒ
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         h_size [in] TCYw肵܂B
 * @param         v_size [in] TCYw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handle/h_size/v_sizeɕsȒlw肳ꂽꍇ
 * @retval        -AG903_EBUSY VRAM|[g蓖Čɖ{֐Ăяoꂽꍇ
 * @description   VRAM͂̃t[TCYݒ肵܂B<p>
 *                Ɏw\Ȕ͈͈͂ȉ̒ʂłB
 *                <table>
 *                <tr><th></th><th>ݒ\͈</th></tr>
 *                <tr><td>h_size</td><td>1 ~ AG903_PGP_MGR_MAX_VI_H_SIZE</td></tr>
 *                <tr><td>v_size</td><td>1 ~ AG903_PGP_MGR_MAX_VI_V_SIZE</td></tr>
 *                </table>
 * @note          {֐ł̃p[^ݒVRAM|[g蓖đOɍsȂKv܂B
*/
int32_t AG903_PgpMgrSetParamVRAMSize(AG903_PgpMgrVRAMInputHandle *handle, uint32_t h_size, uint32_t v_size)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ̃G[`FbN */
    if ((h_size == 0) || (h_size > AG903_PGP_MGR_MAX_VI_H_SIZE)) {
        return -AG903_EINVAL;
    }
    if ((v_size == 0) || (v_size > AG903_PGP_MGR_MAX_VI_V_SIZE)) {
        return -AG903_EINVAL;
    }

    /* VRAM|[gɊ蓖ĂĂꍇ̓G[Ƃ܂ */
    if (handle->port_no != -1) {
        return -AG903_EBUSY;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->h_frame_size = h_size;
    handle->v_frame_size = v_size;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         VRAM͂̃C^[X[hłEVEN/ODDt[
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         e_vbp [in] C^[X[hłEVENt[VBP̗L/w肵܂B
 * @param         e_vfp [in] C^[X[hłEVENt[VFP̗L/w肵܂B
 * @param         o_vbp [in] C^[X[hłODDt[VBP̗L/w肵܂B
 * @param         o_vfp [in] C^[X[hłODDt[VFP̗L/w肵܂B
 * @param         o_vsize [in] C^[X[hłODDt[VSIZE̗L/w肵܂B
 * @return        
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ
 * @description   VRAM͂̃C^[X[hł EVEN/ODD t[𒲐܂B
*/
int32_t AG903_PgpMgrAdjustVRAMFrame(AG903_PgpMgrVRAMInputHandle *handle, _Bool e_vbp, _Bool e_vfp, _Bool o_vbp, _Bool o_vfp, _Bool o_vsize)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* p[^nhɕێADirtytOZbg܂ */
    handle->adjust_even_vbp = e_vbp;
    handle->adjust_even_vfp = e_vfp;
    handle->adjust_odd_vbp = o_vbp;
    handle->adjust_odd_vfp = o_vfp;
    handle->adjust_odd_vsize = o_vsize;
    handle->is_config_dirty[AG903_PGP_MGR_CONFIG_VI_ADJUST_FRAME] = true;
    handle->is_dirty = true;
    return AG903_ENONE;
}


/**
 * @brief         w肳ꂽVRAM̓nhƃpCvCnh̉fp[^̌݊mF
 * @param         handle [in] VRAM̓nhw肵܂B
 * @param         pipeline [in] pCvCnhw肵܂B
 * @return        mF
 * @retval        AG903_ENONE ݊ꍇ
 * @retval        -AG903_EINVAL vramɕsȒlw肳ꂽꍇ<p>pipelineɕsȒlw肳ꂽꍇ<p>VRAM̓nhƃpCvCnh̉fp[^Ɍ݊ꍇ
 * @description   w肳ꂽVRAM̓nh̐ݒƃpCvCnh̉fp[^ݒɌ݊邩mF܂B
*/
int32_t AG903_PgpMgrCheckVRAMParameter(AG903_PgpMgrVRAMInputHandle *vram, AG903_PgpMgrPipelineHandle *pipeline)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((vram == NULL) || (vram->id != AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }
    if ((pipeline == NULL) || (pipeline->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* uNGǍ݊mF܂ */
    if ((vram->h_pulse_width + vram->h_back_porch) != pipeline->input_hpos) {
        return -AG903_EINVAL;
    }
    /* uNGǍ݊mF܂ */
    if ((vram->v_pulse_width + vram->v_back_porch) != pipeline->input_vpos) {
        return -AG903_EINVAL;
    }

    return AG903_ENONE;
}


/**
 * @brief         w肳ꂽpCvCnhJPEGo͐ݒ
 * @param         handle [in] pCvCnhw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȒlw肳ꂽꍇ<p>pCvCnhIɊ蓖ĂĂȂꍇ
 * @description   w肳ꂽpCvCnhJPEGo͂ɐݒ肵܂B
 * @note          {֐JPEGo͂ŎgppCvCw肷݂̂łB<p>
 *                ۂɂ̃pCvCpJPEG@\gpꍇAAG903_PgpMgrEnableJPEG ֐ɂJPEGLɂKv܂B
 *
*/
int32_t AG903_PgpMgrSetJPEG(AG903_PgpMgrPipelineHandle *handle)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCɊ蓖ĂĂȂꍇ̓G[Ƃ܂ */
    if (handle->is_assign == false) {
        return -AG903_EINVAL;
    }

    PgpContext.jpeg_output_pipeline = handle->pipeline_no;

    return AG903_ENONE;
}


/**
 * @brief         JPEGo̗͂L/ݒ
 * @param         enable [in] JPEGo̗͂Lw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EBUSY JPEG@\L̏ԂŖ{֐ɂėLɂݒ肪sȂꂽꍇ
 * @description   JPEGo̗͂L/؂ւ܂B
 * @note          JPEG@\̗L͖Ԃ̂ݗLɕύX邱Ƃ\łB<p>
 *                ́ÃpCvC瓯ɗLɂ邱Ƃ邽߂łB<p>
 *                JPEG@\Lɂꍇ́AJPEG@\~Ă邱ƂmFAUɂĂLɂĉB
*/
int32_t AG903_PgpMgrEnableJPEG(_Bool enable)
{
    if ((enable == true) && (PgpContext.jpeg_output_enable == true)) {
       return -AG903_EBUSY;
    }

    PgpContext.jpeg_output_enable = enable;

    /* Primitive LayerʂJPEG@\̐ݒsȂ܂ */
    AG903_PgpPrmSetPGPJPGOUTSEL(PgpContext.jpeg_output_enable, PgpContext.jpeg_output_pipeline);

    return AG903_ENONE;
}


#define PACK_LUT(d0, d1, d2, d3) (((d0) << 0) | ((d1) << 8) | ((d2) << 16) | ((d3) << 24))
/**
 * @brief         Zxϊe[unh擾
 * @param         red [in] Zxϊe[uRedl̃e[uw肵܂B
 * @param         green [in] Zxϊe[uGreenl̃e[uw肵܂B
 * @param         blue [in] Zxϊe[uBluel̃e[uw肵܂B
 * @param         table [out] 擾Zxϊe[unhi[|C^w肵܂B
 * @return        擾
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL redAgreenAbluêꂩNULLw肳ꂽꍇ
 * @retval        -AG903_ENOMEM Zxϊe[unh̍vlőnh𒴂ꍇ
 * @retval        -AG903_EINVAL tableNULLw肳ꂽꍇ
 * @description   Zxϊe[u擾܂B
*/
int32_t AG903_PgpMgrGetDGCLUT(uint8_t red[256], uint8_t green[256], uint8_t blue[256], AG903_PgpMgrDGCLookupTable **table)
{
    int i, j;

    /* ̃G[`FbN */
    if ((red == NULL) || (green == NULL) || (blue == NULL) || (table == NULL)) {
        return -AG903_EINVAL;
    }

    if ((PgpContext.num_dgc_lut + 1) > AG903_PGP_MGR_MAX_DGC_LUT) {
        return -AG903_ENOMEM;
    }

    /* gp\ȔZxϊe[unhAtableɊi[܂ */
    for (i = 0; i < AG903_PGP_MGR_MAX_DGC_LUT; i++) {
        if (PgpContext.dgc_lut[i].is_used == false) {
            PgpContext.dgc_lut[i].is_used = true;
            PgpContext.dgc_lut[i].id = AG903_PGP_MGR_DGC_LUT_ID;
            PgpContext.dgc_lut[i].ref_cnt = 0;
            /* Zxϊe[uf[^쐬܂ */
            for (j = 0; j < 256; j++) {
                PgpContext.dgc_lut[i].lut_data[0][j] = blue[j];
                PgpContext.dgc_lut[i].lut_data[1][j] = green[j];
                PgpContext.dgc_lut[i].lut_data[2][j] = red[j];
            }
            *table = &PgpContext.dgc_lut[i];
            break;
        }
    }

    PgpContext.num_dgc_lut++;

    return AG903_ENONE;
}


/**
 * @brief         Zxϊe[u
 * @param         table [in] Zxϊe[uw肵܂B
 * @return        
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL tableɕsȒlw肳ꂽꍇ<p>Zxϊe[upCvCnhɊ֘AtĂꍇ
 * @description   w肳ꂽZxϊe[u܂B
*/
int32_t AG903_PgpMgrReleaseDGCLUT(AG903_PgpMgrDGCLookupTable *table)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((table == NULL) || (table->id != AG903_PGP_MGR_DGC_LUT_ID)) {
        return -AG903_EINVAL;
    }

    /* pCvCnhɊ֘AtĂꍇ̓G[Ƃ܂ */
    if (table->ref_cnt != 0) {
        return -AG903_EINVAL;
    }

    /* Zxϊe[uԂɂ܂ */
    table->is_used = false;
    table->id = 0;
    PgpContext.num_dgc_lut--;

    return AG903_ENONE;
}


/**
 * @brief         pCvCnhւ̔Zxϊe[u֘At
 * @param         pipeline [in] Zxϊe[uƊ֘AtpCvCnhw肵܂B
 * @param         dgc_lut [in] ֘AtZxϊe[uw肵܂B
 * @return        ֘At
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL pipelineɕsȒlw肳ꂽꍇ<p>dgc_lutɕsȒlw肳ꂽꍇ(NULL͏܂)
 * @description   pCvCnhɔZxϊe[u֘At܂B
 * @note          table=NULL̏ꍇApCvCnhƂ̊֘At܂B
*/
int32_t AG903_PgpMgrSetConfigDGCLUT(AG903_PgpMgrPipelineHandle *pipeline, AG903_PgpMgrDGCLookupTable *dgc_lut)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((pipeline == NULL) || (pipeline->id != AG903_PGP_MGR_PIPELINE_HANDLE_ID)) {
        return -AG903_EINVAL;
    }
    if ((dgc_lut != NULL) && (dgc_lut->id != AG903_PGP_MGR_DGC_LUT_ID)) {
        return -AG903_EINVAL;
    }

    /* e[uĐݒ肳ꂽꍇ͉܂ */
    if (pipeline->dgc_lut == dgc_lut) {
        return AG903_ENONE;
    }

    if (pipeline->dgc_lut != NULL) {
        pipeline->dgc_lut->ref_cnt--;
        pipeline->dgc_lut = NULL;
    }

    pipeline->dgc_lut = dgc_lut;
    if (dgc_lut != NULL) {
        pipeline->dgc_lut_dirty = true;
        dgc_lut->ref_cnt++;
    }

    return AG903_ENONE;
}
