/**
 * @brief           HDA Register Definition
 * @author          AXELL CORPORATION
 * @description     HDA Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_HDA_REGMAP_H_
#define _AG903_HDA_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** HDA Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint16_t  GCAP;

        struct {
            __I  uint16_t  OK64                           :  1;
            __I  uint16_t  NSDO                           :  2;
            __I  uint16_t  BSS                            :  5;
            __I  uint16_t  ISS                            :  4;
            __I  uint16_t  OSS                            :  4;
        } GCAP_bits;
    };

    union {
        __I  uint8_t   VMIN;
    };

    union {
        __I  uint8_t   VMAJ;
    };

    union {
        __I  uint16_t  OUTPAY;
    };

    union {
        __I  uint16_t  INPAY;
    };

    union {
        __IO uint32_t  GCTL;

        struct {
            __IO uint32_t  CRST                           :  1;
            __IO uint32_t  FCNTRL                         :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  UNSOL                          :  1;
        } GCTL_bits;
    };

    union {
        __IO uint16_t  WAKEEN;

        struct {
            __IO uint16_t  SDIWEN                         : 15;
        } WAKEEN_bits;
    };

    union {
        __IO uint16_t  WAKESTS;

        struct {
            __IO uint16_t  SDIWAKE                        : 15;
        } WAKESTS_bits;
    };

    union {
        __IO uint16_t  GSTS;

        struct {
                 uint16_t                                 :  1;
            __IO uint16_t  FSTS                           :  1;
        } GSTS_bits;
    };

    __I  uint8_t   RESERVED1[2];
    __I  uint32_t  RESERVED2[1];

    union {
        __I  uint16_t  OUTSTRMPAY;
    };

    union {
        __I  uint16_t  INSTRMPAY;
    };

    __I  uint32_t  RESERVED3[1];

    union {
        __IO uint32_t  INTCTL;

        struct {
            __IO uint32_t  SIE                            : 30;
            __IO uint32_t  CIE                            :  1;
            __IO uint32_t  GIE                            :  1;
        } INTCTL_bits;
    };

    union {
        __I  uint32_t  INTSTS;

        struct {
            __I  uint32_t  SIS                            : 30;
            __I  uint32_t  CIS                            :  1;
            __I  uint32_t  GIS                            :  1;
        } INTSTS_bits;
    };

    __I  uint32_t  RESERVED4[2];

    union {
        __I  uint32_t  WALCLK;
    };

    __I  uint32_t  RESERVED5[1];

    union {
        __IO uint32_t  SSYNC;

        struct {
            __IO uint32_t  SSYNC                          : 30;
        } SSYNC_bits;
    };

    __I  uint32_t  RESERVED6[1];

    union {
        __IO uint32_t  CORBLBASE;

        struct {
                 uint32_t                                 :  7;
            __IO uint32_t  CORBLBASE                      : 25;
        } CORBLBASE_bits;
    };

    union {
        __IO uint32_t  CORBUBASE;
    };

    union {
        __IO uint16_t  CORBWP;

        struct {
            __IO uint16_t  CORBWP                         :  8;
        } CORBWP_bits;
    };

    union {
        __IO uint16_t  CORBRP;

        struct {
            __I  uint16_t  CORBRP                         :  8;
                 uint16_t                                 :  7;
            __IO uint16_t  CORBRPRST                      :  1;
        } CORBRP_bits;
    };

    union {
        __IO uint8_t   CORBCTL;

        struct {
            __IO uint8_t   CMEIE                          :  1;
            __IO uint8_t   CORBRUN                        :  1;
        } CORBCTL_bits;
    };

    union {
        __IO uint8_t   CORBSTS;

        struct {
            __IO uint8_t   CMEI                           :  1;
        } CORBSTS_bits;
    };

    union {
        __I  uint8_t   CORBSIZE;

        struct {
            __I  uint8_t   CORBSIZE                       :  2;
                 uint8_t                                  :  2;
            __I  uint8_t   CORBSZCAP                      :  4;
        } CORBSIZE_bits;
    };

    __I  uint8_t   RESERVED7[1];

    union {
        __IO uint32_t  RIRBLBASE;

        struct {
                 uint32_t                                 :  7;
            __IO uint32_t  RIRBLBASE                      : 25;
        } RIRBLBASE_bits;
    };

    union {
        __IO uint32_t  RIRBUBASE;
    };

    union {
        __IO uint16_t  RIRBWP;

        struct {
            __I  uint16_t  RIRBWP                         :  8;
                 uint16_t                                 :  7;
            __O  uint16_t  RIRBWPRST                      :  1;
        } RIRBWP_bits;
    };

    union {
        __IO uint16_t  RINTCNT;

        struct {
            __IO uint16_t  RINTCNT                        :  8;
        } RINTCNT_bits;
    };

    union {
        __IO uint8_t   RIRBCTL;

        struct {
            __IO uint8_t   RINTCTL                        :  1;
            __IO uint8_t   RIRBDMAEN                      :  1;
            __IO uint8_t   RIRBOIC                        :  1;
        } RIRBCTL_bits;
    };

    union {
        __IO uint8_t   RIRBSTS;

        struct {
            __IO uint8_t   RINTFL                         :  1;
                 uint8_t                                  :  1;
            __IO uint8_t   RIRBOIS                        :  1;
        } RIRBSTS_bits;
    };

    union {
        __I  uint8_t   RIRBSIZE;

        struct {
            __I  uint8_t   RIRBSIZE                       :  2;
                 uint8_t                                  :  2;
            __I  uint8_t   RIRBSZCAP                      :  4;
        } RIRBSIZE_bits;
    };

    __I  uint8_t   RESERVED8[1];

    union {
        __I  uint32_t  ICOI;
    };

    union {
        __I  uint32_t  IRII;
    };

    union {
        __IO uint16_t  ICS;

        struct {
            __IO uint16_t  ICB                            :  1;
            __IO uint16_t  IRV                            :  1;
            __I  uint16_t  ICV                            :  1;
            __I  uint16_t  IRRUNSOL                       :  1;
            __I  uint16_t  IRRADD                         :  4;
        } ICS_bits;
    };

    __I  uint8_t   RESERVED9[2];
    __I  uint32_t  RESERVED10[1];

    union {
        __IO uint32_t  DPLBASE;

        struct {
            __IO uint32_t  DPBE                           :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  DPLBASE                        : 25;
        } DPLBASE_bits;
    };

    union {
        __IO uint32_t  DPUBASE;
    };

    __I  uint32_t  RESERVED11[2];

    union {
        __IO uint8_t   ISD0CTLL;

        struct {
            __IO uint8_t   SRST                           :  1;
            __IO uint8_t   RUN                            :  1;
            __IO uint8_t   IOCE                           :  1;
            __IO uint8_t   FEIE                           :  1;
            __IO uint8_t   DEIE                           :  1;
        } ISD0CTLL_bits;
    };

    __I  uint8_t   RESERVED12[1];

    union {
        __IO uint8_t   ISD0CTLU;

        struct {
            __IO uint8_t   STRIPE                         :  2;
            __IO uint8_t   TP                             :  1;
            __IO uint8_t   DIR                            :  1;
            __IO uint8_t   STRM                           :  4;
        } ISD0CTLU_bits;
    };

    union {
        __IO uint8_t   ISD0STS;

        struct {
                 uint8_t                                  :  2;
            __IO uint8_t   BCIS                           :  1;
            __IO uint8_t   FIFOE                          :  1;
            __IO uint8_t   DESE                           :  1;
            __I  uint8_t   FIFORDY                        :  1;
        } ISD0STS_bits;
    };

    union {
        __I  uint32_t  ISD0LPIB;
    };

    union {
        __IO uint32_t  ISD0CBL;
    };

    union {
        __IO uint16_t  ISD0LVI;

        struct {
            __IO uint16_t  LVI                            :  8;
        } ISD0LVI_bits;
    };

    __I  uint8_t   RESERVED13[2];

    union {
        __I  uint16_t  ISD0FIFOS;
    };

    union {
        __IO uint16_t  ISD0FMT;

        struct {
            __IO uint16_t  CHAN                           :  4;
            __IO uint16_t  BITS                           :  3;
                 uint16_t                                 :  1;
            __IO uint16_t  DIV                            :  3;
            __IO uint16_t  MULT                           :  3;
            __IO uint16_t  BASE                           :  1;
        } ISD0FMT_bits;
    };

    __I  uint32_t  RESERVED14[1];

    union {
        __IO uint32_t  ISD0BDPL;

        struct {
                 uint32_t                                 :  7;
            __IO uint32_t  BDLLBASE                       : 25;
        } ISD0BDPL_bits;
    };

    union {
        __IO uint32_t  ISD0BDPU;
    };

    union {
        __IO uint8_t   OSD0CTLL;

        struct {
            __IO uint8_t   SRST                           :  1;
            __IO uint8_t   RUN                            :  1;
            __IO uint8_t   IOCE                           :  1;
            __IO uint8_t   FEIE                           :  1;
            __IO uint8_t   DEIE                           :  1;
        } OSD0CTLL_bits;
    };

    __I  uint8_t   RESERVED15[1];

    union {
        __IO uint8_t   OSD0CTLU;

        struct {
            __IO uint8_t   STRIPE                         :  2;
            __IO uint8_t   TP                             :  1;
            __IO uint8_t   DIR                            :  1;
            __IO uint8_t   STRM                           :  4;
        } OSD0CTLU_bits;
    };

    union {
        __IO uint8_t   OSD0STS;

        struct {
                 uint8_t                                  :  2;
            __IO uint8_t   BCIS                           :  1;
            __IO uint8_t   FIFOE                          :  1;
            __IO uint8_t   DESE                           :  1;
            __I  uint8_t   FIFORDY                        :  1;
        } OSD0STS_bits;
    };

    union {
        __I  uint32_t  OSD0LPIB;
    };

    union {
        __IO uint32_t  OSD0CBL;
    };

    union {
        __IO uint16_t  OSD0LVI;

        struct {
            __IO uint16_t  LVI                            :  8;
        } OSD0LVI_bits;
    };

    __I  uint8_t   RESERVED16[2];

    union {
        __I  uint16_t  OSD0FIFOS;
    };

    union {
        __IO uint16_t  OSD0FMT;

        struct {
            __IO uint16_t  CHAN                           :  4;
            __IO uint16_t  BITS                           :  3;
                 uint16_t                                 :  1;
            __IO uint16_t  DIV                            :  3;
            __IO uint16_t  MULT                           :  3;
            __IO uint16_t  BASE                           :  1;
        } OSD0FMT_bits;
    };

    __I  uint32_t  RESERVED17[1];

    union {
        __IO uint32_t  OSD0BDPL;

        struct {
                 uint32_t                                 :  7;
            __IO uint32_t  BDLLBASE                       : 25;
        } OSD0BDPL_bits;
    };

    union {
        __IO uint32_t  OSD0BDPU;
    };

    union {
        __IO uint8_t   OSD1CTLL;

        struct {
            __IO uint8_t   SRST                           :  1;
            __IO uint8_t   RUN                            :  1;
            __IO uint8_t   IOCE                           :  1;
            __IO uint8_t   FEIE                           :  1;
            __IO uint8_t   DEIE                           :  1;
        } OSD1CTLL_bits;
    };

    __I  uint8_t   RESERVED18[1];

    union {
        __IO uint8_t   OSD1CTLU;

        struct {
            __IO uint8_t   STRIPE                         :  2;
            __IO uint8_t   TP                             :  1;
            __IO uint8_t   DIR                            :  1;
            __IO uint8_t   STRM                           :  4;
        } OSD1CTLU_bits;
    };

    union {
        __IO uint8_t   OSD1STS;

        struct {
                 uint8_t                                  :  2;
            __IO uint8_t   BCIS                           :  1;
            __IO uint8_t   FIFOE                          :  1;
            __IO uint8_t   DESE                           :  1;
            __I  uint8_t   FIFORDY                        :  1;
        } OSD1STS_bits;
    };

    union {
        __I  uint32_t  OSD1LPIB;
    };

    union {
        __IO uint32_t  OSD1CBL;
    };

    union {
        __IO uint16_t  OSD1LVI;

        struct {
            __IO uint16_t  LVI                            :  8;
        } OSD1LVI_bits;
    };

    __I  uint8_t   RESERVED19[2];

    union {
        __I  uint16_t  OSD1FIFOS;
    };

    union {
        __IO uint16_t  OSD1FMT;

        struct {
            __IO uint16_t  CHAN                           :  4;
            __IO uint16_t  BITS                           :  3;
                 uint16_t                                 :  1;
            __IO uint16_t  DIV                            :  3;
            __IO uint16_t  MULT                           :  3;
            __IO uint16_t  BASE                           :  1;
        } OSD1FMT_bits;
    };

    __I  uint32_t  RESERVED20[1];

    union {
        __IO uint32_t  OSD1BDPL;

        struct {
                 uint32_t                                 :  7;
            __IO uint32_t  BDLLBASE                       : 25;
        } OSD1BDPL_bits;
    };

    union {
        __IO uint32_t  OSD1BDPU;
    };

    union {
        __IO uint8_t   OSD2CTLL;

        struct {
            __IO uint8_t   SRST                           :  1;
            __IO uint8_t   RUN                            :  1;
            __IO uint8_t   IOCE                           :  1;
            __IO uint8_t   FEIE                           :  1;
            __IO uint8_t   DEIE                           :  1;
        } OSD2CTLL_bits;
    };

    __I  uint8_t   RESERVED21[1];

    union {
        __IO uint8_t   OSD2CTLU;

        struct {
            __IO uint8_t   STRIPE                         :  2;
            __IO uint8_t   TP                             :  1;
            __IO uint8_t   DIR                            :  1;
            __IO uint8_t   STRM                           :  4;
        } OSD2CTLU_bits;
    };

    union {
        __IO uint8_t   OSD2STS;

        struct {
                 uint8_t                                  :  2;
            __IO uint8_t   BCIS                           :  1;
            __IO uint8_t   FIFOE                          :  1;
            __IO uint8_t   DESE                           :  1;
            __I  uint8_t   FIFORDY                        :  1;
        } OSD2STS_bits;
    };

    union {
        __I  uint32_t  OSD2LPIB;
    };

    union {
        __IO uint32_t  OSD2CBL;
    };

    union {
        __IO uint16_t  OSD2LVI;

        struct {
            __IO uint16_t  LVI                            :  8;
        } OSD2LVI_bits;
    };

    __I  uint8_t   RESERVED22[2];

    union {
        __I  uint16_t  OSD2FIFOS;
    };

    union {
        __IO uint16_t  OSD2FMT;

        struct {
            __IO uint16_t  CHAN                           :  4;
            __IO uint16_t  BITS                           :  3;
                 uint16_t                                 :  1;
            __IO uint16_t  DIV                            :  3;
            __IO uint16_t  MULT                           :  3;
            __IO uint16_t  BASE                           :  1;
        } OSD2FMT_bits;
    };

    __I  uint32_t  RESERVED23[1];

    union {
        __IO uint32_t  OSD2BDPL;

        struct {
                 uint32_t                                 :  7;
            __IO uint32_t  BDLLBASE                       : 25;
        } OSD2BDPL_bits;
    };

    union {
        __IO uint32_t  OSD2BDPU;
    };

    union {
        __IO uint8_t   OSD3CTLL;

        struct {
            __IO uint8_t   SRST                           :  1;
            __IO uint8_t   RUN                            :  1;
            __IO uint8_t   IOCE                           :  1;
            __IO uint8_t   FEIE                           :  1;
            __IO uint8_t   DEIE                           :  1;
        } OSD3CTLL_bits;
    };

    __I  uint8_t   RESERVED24[1];

    union {
        __IO uint8_t   OSD3CTLU;

        struct {
            __IO uint8_t   STRIPE                         :  2;
            __IO uint8_t   TP                             :  1;
            __IO uint8_t   DIR                            :  1;
            __IO uint8_t   STRM                           :  4;
        } OSD3CTLU_bits;
    };

    union {
        __IO uint8_t   OSD3STS;

        struct {
                 uint8_t                                  :  2;
            __IO uint8_t   BCIS                           :  1;
            __IO uint8_t   FIFOE                          :  1;
            __IO uint8_t   DESE                           :  1;
            __I  uint8_t   FIFORDY                        :  1;
        } OSD3STS_bits;
    };

    union {
        __I  uint32_t  OSD3LPIB;
    };

    union {
        __IO uint32_t  OSD3CBL;
    };

    union {
        __IO uint16_t  OSD3LVI;

        struct {
            __IO uint16_t  LVI                            :  8;
        } OSD3LVI_bits;
    };

    __I  uint8_t   RESERVED25[2];

    union {
        __I  uint16_t  OSD3FIFOS;
    };

    union {
        __IO uint16_t  OSD3FMT;

        struct {
            __IO uint16_t  CHAN                           :  4;
            __IO uint16_t  BITS                           :  3;
                 uint16_t                                 :  1;
            __IO uint16_t  DIV                            :  3;
            __IO uint16_t  MULT                           :  3;
            __IO uint16_t  BASE                           :  1;
        } OSD3FMT_bits;
    };

    __I  uint32_t  RESERVED26[1];

    union {
        __IO uint32_t  OSD3BDPL;

        struct {
                 uint32_t                                 :  7;
            __IO uint32_t  BDLLBASE                       : 25;
        } OSD3BDPL_bits;
    };

    union {
        __IO uint32_t  OSD3BDPU;
    };

    __I  uint32_t  RESERVED27[1988];

    union {
        __I  uint32_t  WALCLKA;
    };

    __I  uint32_t  RESERVED28[20];

    union {
        __I  uint32_t  ISD0LPIBA;
    };

    __I  uint32_t  RESERVED29[7];

    union {
        __I  uint32_t  OSD0LPIBA;
    };

    __I  uint32_t  RESERVED30[7];

    union {
        __I  uint32_t  OSD1LPIBA;
    };

    __I  uint32_t  RESERVED31[7];

    union {
        __I  uint32_t  OSD2LPIBA;
    };

    __I  uint32_t  RESERVED32[7];

    union {
        __I  uint32_t  OSD3LPIBA;
    };

/* DOM-IGNORE-END */
}AG903_HDA_Type;

#define AG903_HDA                                ((volatile AG903_HDA_Type *) AG903_HDA_BASE)                            /** HDA Base Address */


#define AG903_HDA_GCAP_OK64_POS                            0                                                             /** HDAGCAP OK64-bit position */
#define AG903_HDA_GCAP_OK64_MSK                            (0x1U << AG903_HDA_GCAP_OK64_POS)                             /** HDAGCAP OK64-bit mask */
#define AG903_HDA_GCAP_NSDO_POS                            1                                                             /** HDAGCAP NSDO-bit position */
#define AG903_HDA_GCAP_NSDO_MSK                            (0x3U << AG903_HDA_GCAP_NSDO_POS)                             /** HDAGCAP NSDO-bit mask */
#define AG903_HDA_GCAP_BSS_POS                             3                                                             /** HDAGCAP BSS-bit position */
#define AG903_HDA_GCAP_BSS_MSK                             (0x1fU << AG903_HDA_GCAP_BSS_POS)                             /** HDAGCAP BSS-bit mask */
#define AG903_HDA_GCAP_ISS_POS                             8                                                             /** HDAGCAP ISS-bit position */
#define AG903_HDA_GCAP_ISS_MSK                             (0xfU << AG903_HDA_GCAP_ISS_POS)                              /** HDAGCAP ISS-bit mask */
#define AG903_HDA_GCAP_OSS_POS                             12                                                            /** HDAGCAP OSS-bit position */
#define AG903_HDA_GCAP_OSS_MSK                             (0xfU << AG903_HDA_GCAP_OSS_POS)                              /** HDAGCAP OSS-bit mask */

#define AG903_HDA_VMIN_VMIN_POS                            0                                                             /** HDAVMIN VMIN-bit position */
#define AG903_HDA_VMIN_VMIN_MSK                            (0xffU << AG903_HDA_VMIN_VMIN_POS)                            /** HDAVMIN VMIN-bit mask */

#define AG903_HDA_VMAJ_VMAJ_POS                            0                                                             /** HDAVMAJ VMAJ-bit position */
#define AG903_HDA_VMAJ_VMAJ_MSK                            (0xffU << AG903_HDA_VMAJ_VMAJ_POS)                            /** HDAVMAJ VMAJ-bit mask */

#define AG903_HDA_OUTPAY_OUTPAY_POS                        0                                                             /** HDAOUTPAY OUTPAY-bit position */
#define AG903_HDA_OUTPAY_OUTPAY_MSK                        (0xffffU << AG903_HDA_OUTPAY_OUTPAY_POS)                      /** HDAOUTPAY OUTPAY-bit mask */

#define AG903_HDA_INPAY_INPAY_POS                          0                                                             /** HDAINPAY INPAY-bit position */
#define AG903_HDA_INPAY_INPAY_MSK                          (0xffffU << AG903_HDA_INPAY_INPAY_POS)                        /** HDAINPAY INPAY-bit mask */

#define AG903_HDA_GCTL_CRST_POS                            0                                                             /** HDAGCTL CRST-bit position */
#define AG903_HDA_GCTL_CRST_MSK                            (0x1UL << AG903_HDA_GCTL_CRST_POS)                            /** HDAGCTL CRST-bit mask */
#define AG903_HDA_GCTL_FCNTRL_POS                          1                                                             /** HDAGCTL FCNTRL-bit position */
#define AG903_HDA_GCTL_FCNTRL_MSK                          (0x1UL << AG903_HDA_GCTL_FCNTRL_POS)                          /** HDAGCTL FCNTRL-bit mask */
#define AG903_HDA_GCTL_UNSOL_POS                           8                                                             /** HDAGCTL UNSOL-bit position */
#define AG903_HDA_GCTL_UNSOL_MSK                           (0x1UL << AG903_HDA_GCTL_UNSOL_POS)                           /** HDAGCTL UNSOL-bit mask */

#define AG903_HDA_WAKEEN_SDIWEN_POS                        0                                                             /** HDAWAKEEN SDIWEN-bit position */
#define AG903_HDA_WAKEEN_SDIWEN_MSK                        (0x7fffU << AG903_HDA_WAKEEN_SDIWEN_POS)                      /** HDAWAKEEN SDIWEN-bit mask */

#define AG903_HDA_WAKESTS_SDIWAKE_POS                      0                                                             /** HDAWAKESTS SDIWAKE-bit position */
#define AG903_HDA_WAKESTS_SDIWAKE_MSK                      (0x7fffU << AG903_HDA_WAKESTS_SDIWAKE_POS)                    /** HDAWAKESTS SDIWAKE-bit mask */

#define AG903_HDA_GSTS_FSTS_POS                            1                                                             /** HDAGSTS FSTS-bit position */
#define AG903_HDA_GSTS_FSTS_MSK                            (0x1U << AG903_HDA_GSTS_FSTS_POS)                             /** HDAGSTS FSTS-bit mask */

#define AG903_HDA_OUTSTRMPAY_OUTSTRMPAY_POS                0                                                             /** HDAOUTSTRMPAY OUTSTRMPAY-bit position */
#define AG903_HDA_OUTSTRMPAY_OUTSTRMPAY_MSK                (0xffffU << AG903_HDA_OUTSTRMPAY_OUTSTRMPAY_POS)              /** HDAOUTSTRMPAY OUTSTRMPAY-bit mask */

#define AG903_HDA_INSTRMPAY_INSTRMPAY_POS                  0                                                             /** HDAINSTRMPAY INSTRMPAY-bit position */
#define AG903_HDA_INSTRMPAY_INSTRMPAY_MSK                  (0xffffU << AG903_HDA_INSTRMPAY_INSTRMPAY_POS)                /** HDAINSTRMPAY INSTRMPAY-bit mask */

#define AG903_HDA_INTCTL_SIE_POS                           0                                                             /** HDAINTCTL SIE-bit position */
#define AG903_HDA_INTCTL_SIE_MSK                           (0x3fffffffUL << AG903_HDA_INTCTL_SIE_POS)                    /** HDAINTCTL SIE-bit mask */
#define AG903_HDA_INTCTL_CIE_POS                           30                                                            /** HDAINTCTL CIE-bit position */
#define AG903_HDA_INTCTL_CIE_MSK                           (0x1UL << AG903_HDA_INTCTL_CIE_POS)                           /** HDAINTCTL CIE-bit mask */
#define AG903_HDA_INTCTL_GIE_POS                           31                                                            /** HDAINTCTL GIE-bit position */
#define AG903_HDA_INTCTL_GIE_MSK                           (0x1UL << AG903_HDA_INTCTL_GIE_POS)                           /** HDAINTCTL GIE-bit mask */

#define AG903_HDA_INTSTS_SIS_POS                           0                                                             /** HDAINTSTS SIS-bit position */
#define AG903_HDA_INTSTS_SIS_MSK                           (0x3fffffffUL << AG903_HDA_INTSTS_SIS_POS)                    /** HDAINTSTS SIS-bit mask */
#define AG903_HDA_INTSTS_CIS_POS                           30                                                            /** HDAINTSTS CIS-bit position */
#define AG903_HDA_INTSTS_CIS_MSK                           (0x1UL << AG903_HDA_INTSTS_CIS_POS)                           /** HDAINTSTS CIS-bit mask */
#define AG903_HDA_INTSTS_GIS_POS                           31                                                            /** HDAINTSTS GIS-bit position */
#define AG903_HDA_INTSTS_GIS_MSK                           (0x1UL << AG903_HDA_INTSTS_GIS_POS)                           /** HDAINTSTS GIS-bit mask */

#define AG903_HDA_WALCLK_COUNTER_POS                       0                                                             /** HDAWALCLK COUNTER-bit position */
#define AG903_HDA_WALCLK_COUNTER_MSK                       (0xffffffffUL << AG903_HDA_WALCLK_COUNTER_POS)                /** HDAWALCLK COUNTER-bit mask */

#define AG903_HDA_SSYNC_SSYNC_POS                          0                                                             /** HDASSYNC SSYNC-bit position */
#define AG903_HDA_SSYNC_SSYNC_MSK                          (0x3fffffffUL << AG903_HDA_SSYNC_SSYNC_POS)                   /** HDASSYNC SSYNC-bit mask */

#define AG903_HDA_CORBLBASE_CORBLBASE_POS                  7                                                             /** HDACORBLBASE CORBLBASE-bit position */
#define AG903_HDA_CORBLBASE_CORBLBASE_MSK                  (0x1ffffffUL << AG903_HDA_CORBLBASE_CORBLBASE_POS)            /** HDACORBLBASE CORBLBASE-bit mask */

#define AG903_HDA_CORBUBASE_CORBUBASE_POS                  0                                                             /** HDACORBUBASE CORBUBASE-bit position */
#define AG903_HDA_CORBUBASE_CORBUBASE_MSK                  (0xffffffffUL << AG903_HDA_CORBUBASE_CORBUBASE_POS)           /** HDACORBUBASE CORBUBASE-bit mask */

#define AG903_HDA_CORBWP_CORBWP_POS                        0                                                             /** HDACORBWP CORBWP-bit position */
#define AG903_HDA_CORBWP_CORBWP_MSK                        (0xffU << AG903_HDA_CORBWP_CORBWP_POS)                        /** HDACORBWP CORBWP-bit mask */

#define AG903_HDA_CORBRP_CORBRP_POS                        0                                                             /** HDACORBRP CORBRP-bit position */
#define AG903_HDA_CORBRP_CORBRP_MSK                        (0xffU << AG903_HDA_CORBRP_CORBRP_POS)                        /** HDACORBRP CORBRP-bit mask */
#define AG903_HDA_CORBRP_CORBRPRST_POS                     15                                                            /** HDACORBRP CORBRPRST-bit position */
#define AG903_HDA_CORBRP_CORBRPRST_MSK                     (0x1U << AG903_HDA_CORBRP_CORBRPRST_POS)                      /** HDACORBRP CORBRPRST-bit mask */

#define AG903_HDA_CORBCTL_CMEIE_POS                        0                                                             /** HDACORBCTL CMEIE-bit position */
#define AG903_HDA_CORBCTL_CMEIE_MSK                        (0x1U << AG903_HDA_CORBCTL_CMEIE_POS)                         /** HDACORBCTL CMEIE-bit mask */
#define AG903_HDA_CORBCTL_CORBRUN_POS                      1                                                             /** HDACORBCTL CORBRUN-bit position */
#define AG903_HDA_CORBCTL_CORBRUN_MSK                      (0x1U << AG903_HDA_CORBCTL_CORBRUN_POS)                       /** HDACORBCTL CORBRUN-bit mask */

#define AG903_HDA_CORBSTS_CMEI_POS                         0                                                             /** HDACORBSTS CMEI-bit position */
#define AG903_HDA_CORBSTS_CMEI_MSK                         (0x1U << AG903_HDA_CORBSTS_CMEI_POS)                          /** HDACORBSTS CMEI-bit mask */

#define AG903_HDA_CORBSIZE_CORBSIZE_POS                    0                                                             /** HDACORBSIZE CORBSIZE-bit position */
#define AG903_HDA_CORBSIZE_CORBSIZE_MSK                    (0x3U << AG903_HDA_CORBSIZE_CORBSIZE_POS)                     /** HDACORBSIZE CORBSIZE-bit mask */
#define AG903_HDA_CORBSIZE_CORBSZCAP_POS                   4                                                             /** HDACORBSIZE CORBSZCAP-bit position */
#define AG903_HDA_CORBSIZE_CORBSZCAP_MSK                   (0xfU << AG903_HDA_CORBSIZE_CORBSZCAP_POS)                    /** HDACORBSIZE CORBSZCAP-bit mask */

#define AG903_HDA_RIRBLBASE_RIRBLBASE_POS                  7                                                             /** HDARIRBLBASE RIRBLBASE-bit position */
#define AG903_HDA_RIRBLBASE_RIRBLBASE_MSK                  (0x1ffffffUL << AG903_HDA_RIRBLBASE_RIRBLBASE_POS)            /** HDARIRBLBASE RIRBLBASE-bit mask */

#define AG903_HDA_RIRBUBASE_RIRBUBASE_POS                  0                                                             /** HDARIRBUBASE RIRBUBASE-bit position */
#define AG903_HDA_RIRBUBASE_RIRBUBASE_MSK                  (0xffffffffUL << AG903_HDA_RIRBUBASE_RIRBUBASE_POS)           /** HDARIRBUBASE RIRBUBASE-bit mask */

#define AG903_HDA_RIRBWP_RIRBWP_POS                        0                                                             /** HDARIRBWP RIRBWP-bit position */
#define AG903_HDA_RIRBWP_RIRBWP_MSK                        (0xffU << AG903_HDA_RIRBWP_RIRBWP_POS)                        /** HDARIRBWP RIRBWP-bit mask */
#define AG903_HDA_RIRBWP_RIRBWPRST_POS                     15                                                            /** HDARIRBWP RIRBWPRST-bit position */
#define AG903_HDA_RIRBWP_RIRBWPRST_MSK                     (0x1U << AG903_HDA_RIRBWP_RIRBWPRST_POS)                      /** HDARIRBWP RIRBWPRST-bit mask */

#define AG903_HDA_RINTCNT_RINTCNT_POS                      0                                                             /** HDARINTCNT RINTCNT-bit position */
#define AG903_HDA_RINTCNT_RINTCNT_MSK                      (0xffU << AG903_HDA_RINTCNT_RINTCNT_POS)                      /** HDARINTCNT RINTCNT-bit mask */

#define AG903_HDA_RIRBCTL_RINTCTL_POS                      0                                                             /** HDARIRBCTL RINTCTL-bit position */
#define AG903_HDA_RIRBCTL_RINTCTL_MSK                      (0x1U << AG903_HDA_RIRBCTL_RINTCTL_POS)                       /** HDARIRBCTL RINTCTL-bit mask */
#define AG903_HDA_RIRBCTL_RIRBDMAEN_POS                    1                                                             /** HDARIRBCTL RIRBDMAEN-bit position */
#define AG903_HDA_RIRBCTL_RIRBDMAEN_MSK                    (0x1U << AG903_HDA_RIRBCTL_RIRBDMAEN_POS)                     /** HDARIRBCTL RIRBDMAEN-bit mask */
#define AG903_HDA_RIRBCTL_RIRBOIC_POS                      2                                                             /** HDARIRBCTL RIRBOIC-bit position */
#define AG903_HDA_RIRBCTL_RIRBOIC_MSK                      (0x1U << AG903_HDA_RIRBCTL_RIRBOIC_POS)                       /** HDARIRBCTL RIRBOIC-bit mask */

#define AG903_HDA_RIRBSTS_RINTFL_POS                       0                                                             /** HDARIRBSTS RINTFL-bit position */
#define AG903_HDA_RIRBSTS_RINTFL_MSK                       (0x1U << AG903_HDA_RIRBSTS_RINTFL_POS)                        /** HDARIRBSTS RINTFL-bit mask */
#define AG903_HDA_RIRBSTS_RIRBOIS_POS                      2                                                             /** HDARIRBSTS RIRBOIS-bit position */
#define AG903_HDA_RIRBSTS_RIRBOIS_MSK                      (0x1U << AG903_HDA_RIRBSTS_RIRBOIS_POS)                       /** HDARIRBSTS RIRBOIS-bit mask */

#define AG903_HDA_RIRBSIZE_RIRBSIZE_POS                    0                                                             /** HDARIRBSIZE RIRBSIZE-bit position */
#define AG903_HDA_RIRBSIZE_RIRBSIZE_MSK                    (0x3U << AG903_HDA_RIRBSIZE_RIRBSIZE_POS)                     /** HDARIRBSIZE RIRBSIZE-bit mask */
#define AG903_HDA_RIRBSIZE_RIRBSZCAP_POS                   4                                                             /** HDARIRBSIZE RIRBSZCAP-bit position */
#define AG903_HDA_RIRBSIZE_RIRBSZCAP_MSK                   (0xfU << AG903_HDA_RIRBSIZE_RIRBSZCAP_POS)                    /** HDARIRBSIZE RIRBSZCAP-bit mask */

#define AG903_HDA_ICOI_ICW_POS                             0                                                             /** HDAICOI ICW-bit position */
#define AG903_HDA_ICOI_ICW_MSK                             (0xffffffffUL << AG903_HDA_ICOI_ICW_POS)                      /** HDAICOI ICW-bit mask */

#define AG903_HDA_IRII_IRR_POS                             0                                                             /** HDAIRII IRR-bit position */
#define AG903_HDA_IRII_IRR_MSK                             (0xffffffffUL << AG903_HDA_IRII_IRR_POS)                      /** HDAIRII IRR-bit mask */

#define AG903_HDA_ICS_ICB_POS                              0                                                             /** HDAICS ICB-bit position */
#define AG903_HDA_ICS_ICB_MSK                              (0x1U << AG903_HDA_ICS_ICB_POS)                               /** HDAICS ICB-bit mask */
#define AG903_HDA_ICS_IRV_POS                              1                                                             /** HDAICS IRV-bit position */
#define AG903_HDA_ICS_IRV_MSK                              (0x1U << AG903_HDA_ICS_IRV_POS)                               /** HDAICS IRV-bit mask */
#define AG903_HDA_ICS_ICV_POS                              2                                                             /** HDAICS ICV-bit position */
#define AG903_HDA_ICS_ICV_MSK                              (0x1U << AG903_HDA_ICS_ICV_POS)                               /** HDAICS ICV-bit mask */
#define AG903_HDA_ICS_IRRUNSOL_POS                         3                                                             /** HDAICS IRRUNSOL-bit position */
#define AG903_HDA_ICS_IRRUNSOL_MSK                         (0x1U << AG903_HDA_ICS_IRRUNSOL_POS)                          /** HDAICS IRRUNSOL-bit mask */
#define AG903_HDA_ICS_IRRADD_POS                           4                                                             /** HDAICS IRRADD-bit position */
#define AG903_HDA_ICS_IRRADD_MSK                           (0xfU << AG903_HDA_ICS_IRRADD_POS)                            /** HDAICS IRRADD-bit mask */

#define AG903_HDA_DPLBASE_DPBE_POS                         0                                                             /** HDADPLBASE DPBE-bit position */
#define AG903_HDA_DPLBASE_DPBE_MSK                         (0x1UL << AG903_HDA_DPLBASE_DPBE_POS)                         /** HDADPLBASE DPBE-bit mask */
#define AG903_HDA_DPLBASE_DPLBASE_POS                      7                                                             /** HDADPLBASE DPLBASE-bit position */
#define AG903_HDA_DPLBASE_DPLBASE_MSK                      (0x1ffffffUL << AG903_HDA_DPLBASE_DPLBASE_POS)                /** HDADPLBASE DPLBASE-bit mask */

#define AG903_HDA_DPUBASE_DPUBASE_POS                      0                                                             /** HDADPUBASE DPUBASE-bit position */
#define AG903_HDA_DPUBASE_DPUBASE_MSK                      (0xffffffffUL << AG903_HDA_DPUBASE_DPUBASE_POS)               /** HDADPUBASE DPUBASE-bit mask */

#define AG903_HDA_ISD0CTLL_SRST_POS                        0                                                             /** HDAISD0CTLL SRST-bit position */
#define AG903_HDA_ISD0CTLL_SRST_MSK                        (0x1U << AG903_HDA_ISD0CTLL_SRST_POS)                         /** HDAISD0CTLL SRST-bit mask */
#define AG903_HDA_ISD0CTLL_RUN_POS                         1                                                             /** HDAISD0CTLL RUN-bit position */
#define AG903_HDA_ISD0CTLL_RUN_MSK                         (0x1U << AG903_HDA_ISD0CTLL_RUN_POS)                          /** HDAISD0CTLL RUN-bit mask */
#define AG903_HDA_ISD0CTLL_IOCE_POS                        2                                                             /** HDAISD0CTLL IOCE-bit position */
#define AG903_HDA_ISD0CTLL_IOCE_MSK                        (0x1U << AG903_HDA_ISD0CTLL_IOCE_POS)                         /** HDAISD0CTLL IOCE-bit mask */
#define AG903_HDA_ISD0CTLL_FEIE_POS                        3                                                             /** HDAISD0CTLL FEIE-bit position */
#define AG903_HDA_ISD0CTLL_FEIE_MSK                        (0x1U << AG903_HDA_ISD0CTLL_FEIE_POS)                         /** HDAISD0CTLL FEIE-bit mask */
#define AG903_HDA_ISD0CTLL_DEIE_POS                        4                                                             /** HDAISD0CTLL DEIE-bit position */
#define AG903_HDA_ISD0CTLL_DEIE_MSK                        (0x1U << AG903_HDA_ISD0CTLL_DEIE_POS)                         /** HDAISD0CTLL DEIE-bit mask */

#define AG903_HDA_ISD0CTLU_STRIPE_POS                      0                                                             /** HDAISD0CTLU STRIPE-bit position */
#define AG903_HDA_ISD0CTLU_STRIPE_MSK                      (0x3U << AG903_HDA_ISD0CTLU_STRIPE_POS)                       /** HDAISD0CTLU STRIPE-bit mask */
#define AG903_HDA_ISD0CTLU_TP_POS                          2                                                             /** HDAISD0CTLU TP-bit position */
#define AG903_HDA_ISD0CTLU_TP_MSK                          (0x1U << AG903_HDA_ISD0CTLU_TP_POS)                           /** HDAISD0CTLU TP-bit mask */
#define AG903_HDA_ISD0CTLU_DIR_POS                         3                                                             /** HDAISD0CTLU DIR-bit position */
#define AG903_HDA_ISD0CTLU_DIR_MSK                         (0x1U << AG903_HDA_ISD0CTLU_DIR_POS)                          /** HDAISD0CTLU DIR-bit mask */
#define AG903_HDA_ISD0CTLU_STRM_POS                        4                                                             /** HDAISD0CTLU STRM-bit position */
#define AG903_HDA_ISD0CTLU_STRM_MSK                        (0xfU << AG903_HDA_ISD0CTLU_STRM_POS)                         /** HDAISD0CTLU STRM-bit mask */

#define AG903_HDA_ISD0STS_BCIS_POS                         2                                                             /** HDAISD0STS BCIS-bit position */
#define AG903_HDA_ISD0STS_BCIS_MSK                         (0x1U << AG903_HDA_ISD0STS_BCIS_POS)                          /** HDAISD0STS BCIS-bit mask */
#define AG903_HDA_ISD0STS_FIFOE_POS                        3                                                             /** HDAISD0STS FIFOE-bit position */
#define AG903_HDA_ISD0STS_FIFOE_MSK                        (0x1U << AG903_HDA_ISD0STS_FIFOE_POS)                         /** HDAISD0STS FIFOE-bit mask */
#define AG903_HDA_ISD0STS_DESE_POS                         4                                                             /** HDAISD0STS DESE-bit position */
#define AG903_HDA_ISD0STS_DESE_MSK                         (0x1U << AG903_HDA_ISD0STS_DESE_POS)                          /** HDAISD0STS DESE-bit mask */
#define AG903_HDA_ISD0STS_FIFORDY_POS                      5                                                             /** HDAISD0STS FIFORDY-bit position */
#define AG903_HDA_ISD0STS_FIFORDY_MSK                      (0x1U << AG903_HDA_ISD0STS_FIFORDY_POS)                       /** HDAISD0STS FIFORDY-bit mask */

#define AG903_HDA_ISD0LPIB_LPIB_POS                        0                                                             /** HDAISD0LPIB LPIB-bit position */
#define AG903_HDA_ISD0LPIB_LPIB_MSK                        (0xffffffffUL << AG903_HDA_ISD0LPIB_LPIB_POS)                 /** HDAISD0LPIB LPIB-bit mask */

#define AG903_HDA_ISD0CBL_CBL_POS                          0                                                             /** HDAISD0CBL CBL-bit position */
#define AG903_HDA_ISD0CBL_CBL_MSK                          (0xffffffffUL << AG903_HDA_ISD0CBL_CBL_POS)                   /** HDAISD0CBL CBL-bit mask */

#define AG903_HDA_ISD0LVI_LVI_POS                          0                                                             /** HDAISD0LVI LVI-bit position */
#define AG903_HDA_ISD0LVI_LVI_MSK                          (0xffU << AG903_HDA_ISD0LVI_LVI_POS)                          /** HDAISD0LVI LVI-bit mask */

#define AG903_HDA_ISD0FIFOS_FIFOS_POS                      0                                                             /** HDAISD0FIFOS FIFOS-bit position */
#define AG903_HDA_ISD0FIFOS_FIFOS_MSK                      (0xffffU << AG903_HDA_ISD0FIFOS_FIFOS_POS)                    /** HDAISD0FIFOS FIFOS-bit mask */

#define AG903_HDA_ISD0FMT_CHAN_POS                         0                                                             /** HDAISD0FMT CHAN-bit position */
#define AG903_HDA_ISD0FMT_CHAN_MSK                         (0xfU << AG903_HDA_ISD0FMT_CHAN_POS)                          /** HDAISD0FMT CHAN-bit mask */
#define AG903_HDA_ISD0FMT_BITS_POS                         4                                                             /** HDAISD0FMT BITS-bit position */
#define AG903_HDA_ISD0FMT_BITS_MSK                         (0x7U << AG903_HDA_ISD0FMT_BITS_POS)                          /** HDAISD0FMT BITS-bit mask */
#define AG903_HDA_ISD0FMT_DIV_POS                          8                                                             /** HDAISD0FMT DIV-bit position */
#define AG903_HDA_ISD0FMT_DIV_MSK                          (0x7U << AG903_HDA_ISD0FMT_DIV_POS)                           /** HDAISD0FMT DIV-bit mask */
#define AG903_HDA_ISD0FMT_MULT_POS                         11                                                            /** HDAISD0FMT MULT-bit position */
#define AG903_HDA_ISD0FMT_MULT_MSK                         (0x7U << AG903_HDA_ISD0FMT_MULT_POS)                          /** HDAISD0FMT MULT-bit mask */
#define AG903_HDA_ISD0FMT_BASE_POS                         14                                                            /** HDAISD0FMT BASE-bit position */
#define AG903_HDA_ISD0FMT_BASE_MSK                         (0x1U << AG903_HDA_ISD0FMT_BASE_POS)                          /** HDAISD0FMT BASE-bit mask */

#define AG903_HDA_ISD0BDPL_BDLLBASE_POS                    7                                                             /** HDAISD0BDPL BDLLBASE-bit position */
#define AG903_HDA_ISD0BDPL_BDLLBASE_MSK                    (0x1ffffffUL << AG903_HDA_ISD0BDPL_BDLLBASE_POS)              /** HDAISD0BDPL BDLLBASE-bit mask */

#define AG903_HDA_ISD0BDPU_BDLUBASE_POS                    0                                                             /** HDAISD0BDPU BDLUBASE-bit position */
#define AG903_HDA_ISD0BDPU_BDLUBASE_MSK                    (0xffffffffUL << AG903_HDA_ISD0BDPU_BDLUBASE_POS)             /** HDAISD0BDPU BDLUBASE-bit mask */

#define AG903_HDA_OSD0CTLL_SRST_POS                        0                                                             /** HDAOSD0CTLL SRST-bit position */
#define AG903_HDA_OSD0CTLL_SRST_MSK                        (0x1U << AG903_HDA_OSD0CTLL_SRST_POS)                         /** HDAOSD0CTLL SRST-bit mask */
#define AG903_HDA_OSD0CTLL_RUN_POS                         1                                                             /** HDAOSD0CTLL RUN-bit position */
#define AG903_HDA_OSD0CTLL_RUN_MSK                         (0x1U << AG903_HDA_OSD0CTLL_RUN_POS)                          /** HDAOSD0CTLL RUN-bit mask */
#define AG903_HDA_OSD0CTLL_IOCE_POS                        2                                                             /** HDAOSD0CTLL IOCE-bit position */
#define AG903_HDA_OSD0CTLL_IOCE_MSK                        (0x1U << AG903_HDA_OSD0CTLL_IOCE_POS)                         /** HDAOSD0CTLL IOCE-bit mask */
#define AG903_HDA_OSD0CTLL_FEIE_POS                        3                                                             /** HDAOSD0CTLL FEIE-bit position */
#define AG903_HDA_OSD0CTLL_FEIE_MSK                        (0x1U << AG903_HDA_OSD0CTLL_FEIE_POS)                         /** HDAOSD0CTLL FEIE-bit mask */
#define AG903_HDA_OSD0CTLL_DEIE_POS                        4                                                             /** HDAOSD0CTLL DEIE-bit position */
#define AG903_HDA_OSD0CTLL_DEIE_MSK                        (0x1U << AG903_HDA_OSD0CTLL_DEIE_POS)                         /** HDAOSD0CTLL DEIE-bit mask */

#define AG903_HDA_OSD0CTLU_STRIPE_POS                      0                                                             /** HDAOSD0CTLU STRIPE-bit position */
#define AG903_HDA_OSD0CTLU_STRIPE_MSK                      (0x3U << AG903_HDA_OSD0CTLU_STRIPE_POS)                       /** HDAOSD0CTLU STRIPE-bit mask */
#define AG903_HDA_OSD0CTLU_TP_POS                          2                                                             /** HDAOSD0CTLU TP-bit position */
#define AG903_HDA_OSD0CTLU_TP_MSK                          (0x1U << AG903_HDA_OSD0CTLU_TP_POS)                           /** HDAOSD0CTLU TP-bit mask */
#define AG903_HDA_OSD0CTLU_DIR_POS                         3                                                             /** HDAOSD0CTLU DIR-bit position */
#define AG903_HDA_OSD0CTLU_DIR_MSK                         (0x1U << AG903_HDA_OSD0CTLU_DIR_POS)                          /** HDAOSD0CTLU DIR-bit mask */
#define AG903_HDA_OSD0CTLU_STRM_POS                        4                                                             /** HDAOSD0CTLU STRM-bit position */
#define AG903_HDA_OSD0CTLU_STRM_MSK                        (0xfU << AG903_HDA_OSD0CTLU_STRM_POS)                         /** HDAOSD0CTLU STRM-bit mask */

#define AG903_HDA_OSD0STS_BCIS_POS                         2                                                             /** HDAOSD0STS BCIS-bit position */
#define AG903_HDA_OSD0STS_BCIS_MSK                         (0x1U << AG903_HDA_OSD0STS_BCIS_POS)                          /** HDAOSD0STS BCIS-bit mask */
#define AG903_HDA_OSD0STS_FIFOE_POS                        3                                                             /** HDAOSD0STS FIFOE-bit position */
#define AG903_HDA_OSD0STS_FIFOE_MSK                        (0x1U << AG903_HDA_OSD0STS_FIFOE_POS)                         /** HDAOSD0STS FIFOE-bit mask */
#define AG903_HDA_OSD0STS_DESE_POS                         4                                                             /** HDAOSD0STS DESE-bit position */
#define AG903_HDA_OSD0STS_DESE_MSK                         (0x1U << AG903_HDA_OSD0STS_DESE_POS)                          /** HDAOSD0STS DESE-bit mask */
#define AG903_HDA_OSD0STS_FIFORDY_POS                      5                                                             /** HDAOSD0STS FIFORDY-bit position */
#define AG903_HDA_OSD0STS_FIFORDY_MSK                      (0x1U << AG903_HDA_OSD0STS_FIFORDY_POS)                       /** HDAOSD0STS FIFORDY-bit mask */

#define AG903_HDA_OSD0LPIB_LPIB_POS                        0                                                             /** HDAOSD0LPIB LPIB-bit position */
#define AG903_HDA_OSD0LPIB_LPIB_MSK                        (0xffffffffUL << AG903_HDA_OSD0LPIB_LPIB_POS)                 /** HDAOSD0LPIB LPIB-bit mask */

#define AG903_HDA_OSD0CBL_CBL_POS                          0                                                             /** HDAOSD0CBL CBL-bit position */
#define AG903_HDA_OSD0CBL_CBL_MSK                          (0xffffffffUL << AG903_HDA_OSD0CBL_CBL_POS)                   /** HDAOSD0CBL CBL-bit mask */

#define AG903_HDA_OSD0LVI_LVI_POS                          0                                                             /** HDAOSD0LVI LVI-bit position */
#define AG903_HDA_OSD0LVI_LVI_MSK                          (0xffU << AG903_HDA_OSD0LVI_LVI_POS)                          /** HDAOSD0LVI LVI-bit mask */

#define AG903_HDA_OSD0FIFOS_FIFOS_POS                      0                                                             /** HDAOSD0FIFOS FIFOS-bit position */
#define AG903_HDA_OSD0FIFOS_FIFOS_MSK                      (0xffffU << AG903_HDA_OSD0FIFOS_FIFOS_POS)                    /** HDAOSD0FIFOS FIFOS-bit mask */

#define AG903_HDA_OSD0FMT_CHAN_POS                         0                                                             /** HDAOSD0FMT CHAN-bit position */
#define AG903_HDA_OSD0FMT_CHAN_MSK                         (0xfU << AG903_HDA_OSD0FMT_CHAN_POS)                          /** HDAOSD0FMT CHAN-bit mask */
#define AG903_HDA_OSD0FMT_BITS_POS                         4                                                             /** HDAOSD0FMT BITS-bit position */
#define AG903_HDA_OSD0FMT_BITS_MSK                         (0x7U << AG903_HDA_OSD0FMT_BITS_POS)                          /** HDAOSD0FMT BITS-bit mask */
#define AG903_HDA_OSD0FMT_DIV_POS                          8                                                             /** HDAOSD0FMT DIV-bit position */
#define AG903_HDA_OSD0FMT_DIV_MSK                          (0x7U << AG903_HDA_OSD0FMT_DIV_POS)                           /** HDAOSD0FMT DIV-bit mask */
#define AG903_HDA_OSD0FMT_MULT_POS                         11                                                            /** HDAOSD0FMT MULT-bit position */
#define AG903_HDA_OSD0FMT_MULT_MSK                         (0x7U << AG903_HDA_OSD0FMT_MULT_POS)                          /** HDAOSD0FMT MULT-bit mask */
#define AG903_HDA_OSD0FMT_BASE_POS                         14                                                            /** HDAOSD0FMT BASE-bit position */
#define AG903_HDA_OSD0FMT_BASE_MSK                         (0x1U << AG903_HDA_OSD0FMT_BASE_POS)                          /** HDAOSD0FMT BASE-bit mask */

#define AG903_HDA_OSD0BDPL_BDLLBASE_POS                    7                                                             /** HDAOSD0BDPL BDLLBASE-bit position */
#define AG903_HDA_OSD0BDPL_BDLLBASE_MSK                    (0x1ffffffUL << AG903_HDA_OSD0BDPL_BDLLBASE_POS)              /** HDAOSD0BDPL BDLLBASE-bit mask */

#define AG903_HDA_OSD0BDPU_BDLUBASE_POS                    0                                                             /** HDAOSD0BDPU BDLUBASE-bit position */
#define AG903_HDA_OSD0BDPU_BDLUBASE_MSK                    (0xffffffffUL << AG903_HDA_OSD0BDPU_BDLUBASE_POS)             /** HDAOSD0BDPU BDLUBASE-bit mask */

#define AG903_HDA_OSD1CTLL_SRST_POS                        0                                                             /** HDAOSD1CTLL SRST-bit position */
#define AG903_HDA_OSD1CTLL_SRST_MSK                        (0x1U << AG903_HDA_OSD1CTLL_SRST_POS)                         /** HDAOSD1CTLL SRST-bit mask */
#define AG903_HDA_OSD1CTLL_RUN_POS                         1                                                             /** HDAOSD1CTLL RUN-bit position */
#define AG903_HDA_OSD1CTLL_RUN_MSK                         (0x1U << AG903_HDA_OSD1CTLL_RUN_POS)                          /** HDAOSD1CTLL RUN-bit mask */
#define AG903_HDA_OSD1CTLL_IOCE_POS                        2                                                             /** HDAOSD1CTLL IOCE-bit position */
#define AG903_HDA_OSD1CTLL_IOCE_MSK                        (0x1U << AG903_HDA_OSD1CTLL_IOCE_POS)                         /** HDAOSD1CTLL IOCE-bit mask */
#define AG903_HDA_OSD1CTLL_FEIE_POS                        3                                                             /** HDAOSD1CTLL FEIE-bit position */
#define AG903_HDA_OSD1CTLL_FEIE_MSK                        (0x1U << AG903_HDA_OSD1CTLL_FEIE_POS)                         /** HDAOSD1CTLL FEIE-bit mask */
#define AG903_HDA_OSD1CTLL_DEIE_POS                        4                                                             /** HDAOSD1CTLL DEIE-bit position */
#define AG903_HDA_OSD1CTLL_DEIE_MSK                        (0x1U << AG903_HDA_OSD1CTLL_DEIE_POS)                         /** HDAOSD1CTLL DEIE-bit mask */

#define AG903_HDA_OSD1CTLU_STRIPE_POS                      0                                                             /** HDAOSD1CTLU STRIPE-bit position */
#define AG903_HDA_OSD1CTLU_STRIPE_MSK                      (0x3U << AG903_HDA_OSD1CTLU_STRIPE_POS)                       /** HDAOSD1CTLU STRIPE-bit mask */
#define AG903_HDA_OSD1CTLU_TP_POS                          2                                                             /** HDAOSD1CTLU TP-bit position */
#define AG903_HDA_OSD1CTLU_TP_MSK                          (0x1U << AG903_HDA_OSD1CTLU_TP_POS)                           /** HDAOSD1CTLU TP-bit mask */
#define AG903_HDA_OSD1CTLU_DIR_POS                         3                                                             /** HDAOSD1CTLU DIR-bit position */
#define AG903_HDA_OSD1CTLU_DIR_MSK                         (0x1U << AG903_HDA_OSD1CTLU_DIR_POS)                          /** HDAOSD1CTLU DIR-bit mask */
#define AG903_HDA_OSD1CTLU_STRM_POS                        4                                                             /** HDAOSD1CTLU STRM-bit position */
#define AG903_HDA_OSD1CTLU_STRM_MSK                        (0xfU << AG903_HDA_OSD1CTLU_STRM_POS)                         /** HDAOSD1CTLU STRM-bit mask */

#define AG903_HDA_OSD1STS_BCIS_POS                         2                                                             /** HDAOSD1STS BCIS-bit position */
#define AG903_HDA_OSD1STS_BCIS_MSK                         (0x1U << AG903_HDA_OSD1STS_BCIS_POS)                          /** HDAOSD1STS BCIS-bit mask */
#define AG903_HDA_OSD1STS_FIFOE_POS                        3                                                             /** HDAOSD1STS FIFOE-bit position */
#define AG903_HDA_OSD1STS_FIFOE_MSK                        (0x1U << AG903_HDA_OSD1STS_FIFOE_POS)                         /** HDAOSD1STS FIFOE-bit mask */
#define AG903_HDA_OSD1STS_DESE_POS                         4                                                             /** HDAOSD1STS DESE-bit position */
#define AG903_HDA_OSD1STS_DESE_MSK                         (0x1U << AG903_HDA_OSD1STS_DESE_POS)                          /** HDAOSD1STS DESE-bit mask */
#define AG903_HDA_OSD1STS_FIFORDY_POS                      5                                                             /** HDAOSD1STS FIFORDY-bit position */
#define AG903_HDA_OSD1STS_FIFORDY_MSK                      (0x1U << AG903_HDA_OSD1STS_FIFORDY_POS)                       /** HDAOSD1STS FIFORDY-bit mask */

#define AG903_HDA_OSD1LPIB_LPIB_POS                        0                                                             /** HDAOSD1LPIB LPIB-bit position */
#define AG903_HDA_OSD1LPIB_LPIB_MSK                        (0xffffffffUL << AG903_HDA_OSD1LPIB_LPIB_POS)                 /** HDAOSD1LPIB LPIB-bit mask */

#define AG903_HDA_OSD1CBL_CBL_POS                          0                                                             /** HDAOSD1CBL CBL-bit position */
#define AG903_HDA_OSD1CBL_CBL_MSK                          (0xffffffffUL << AG903_HDA_OSD1CBL_CBL_POS)                   /** HDAOSD1CBL CBL-bit mask */

#define AG903_HDA_OSD1LVI_LVI_POS                          0                                                             /** HDAOSD1LVI LVI-bit position */
#define AG903_HDA_OSD1LVI_LVI_MSK                          (0xffU << AG903_HDA_OSD1LVI_LVI_POS)                          /** HDAOSD1LVI LVI-bit mask */

#define AG903_HDA_OSD1FIFOS_FIFOS_POS                      0                                                             /** HDAOSD1FIFOS FIFOS-bit position */
#define AG903_HDA_OSD1FIFOS_FIFOS_MSK                      (0xffffU << AG903_HDA_OSD1FIFOS_FIFOS_POS)                    /** HDAOSD1FIFOS FIFOS-bit mask */

#define AG903_HDA_OSD1FMT_CHAN_POS                         0                                                             /** HDAOSD1FMT CHAN-bit position */
#define AG903_HDA_OSD1FMT_CHAN_MSK                         (0xfU << AG903_HDA_OSD1FMT_CHAN_POS)                          /** HDAOSD1FMT CHAN-bit mask */
#define AG903_HDA_OSD1FMT_BITS_POS                         4                                                             /** HDAOSD1FMT BITS-bit position */
#define AG903_HDA_OSD1FMT_BITS_MSK                         (0x7U << AG903_HDA_OSD1FMT_BITS_POS)                          /** HDAOSD1FMT BITS-bit mask */
#define AG903_HDA_OSD1FMT_DIV_POS                          8                                                             /** HDAOSD1FMT DIV-bit position */
#define AG903_HDA_OSD1FMT_DIV_MSK                          (0x7U << AG903_HDA_OSD1FMT_DIV_POS)                           /** HDAOSD1FMT DIV-bit mask */
#define AG903_HDA_OSD1FMT_MULT_POS                         11                                                            /** HDAOSD1FMT MULT-bit position */
#define AG903_HDA_OSD1FMT_MULT_MSK                         (0x7U << AG903_HDA_OSD1FMT_MULT_POS)                          /** HDAOSD1FMT MULT-bit mask */
#define AG903_HDA_OSD1FMT_BASE_POS                         14                                                            /** HDAOSD1FMT BASE-bit position */
#define AG903_HDA_OSD1FMT_BASE_MSK                         (0x1U << AG903_HDA_OSD1FMT_BASE_POS)                          /** HDAOSD1FMT BASE-bit mask */

#define AG903_HDA_OSD1BDPL_BDLLBASE_POS                    7                                                             /** HDAOSD1BDPL BDLLBASE-bit position */
#define AG903_HDA_OSD1BDPL_BDLLBASE_MSK                    (0x1ffffffUL << AG903_HDA_OSD1BDPL_BDLLBASE_POS)              /** HDAOSD1BDPL BDLLBASE-bit mask */

#define AG903_HDA_OSD1BDPU_BDLUBASE_POS                    0                                                             /** HDAOSD1BDPU BDLUBASE-bit position */
#define AG903_HDA_OSD1BDPU_BDLUBASE_MSK                    (0xffffffffUL << AG903_HDA_OSD1BDPU_BDLUBASE_POS)             /** HDAOSD1BDPU BDLUBASE-bit mask */

#define AG903_HDA_OSD2CTLL_SRST_POS                        0                                                             /** HDAOSD2CTLL SRST-bit position */
#define AG903_HDA_OSD2CTLL_SRST_MSK                        (0x1U << AG903_HDA_OSD2CTLL_SRST_POS)                         /** HDAOSD2CTLL SRST-bit mask */
#define AG903_HDA_OSD2CTLL_RUN_POS                         1                                                             /** HDAOSD2CTLL RUN-bit position */
#define AG903_HDA_OSD2CTLL_RUN_MSK                         (0x1U << AG903_HDA_OSD2CTLL_RUN_POS)                          /** HDAOSD2CTLL RUN-bit mask */
#define AG903_HDA_OSD2CTLL_IOCE_POS                        2                                                             /** HDAOSD2CTLL IOCE-bit position */
#define AG903_HDA_OSD2CTLL_IOCE_MSK                        (0x1U << AG903_HDA_OSD2CTLL_IOCE_POS)                         /** HDAOSD2CTLL IOCE-bit mask */
#define AG903_HDA_OSD2CTLL_FEIE_POS                        3                                                             /** HDAOSD2CTLL FEIE-bit position */
#define AG903_HDA_OSD2CTLL_FEIE_MSK                        (0x1U << AG903_HDA_OSD2CTLL_FEIE_POS)                         /** HDAOSD2CTLL FEIE-bit mask */
#define AG903_HDA_OSD2CTLL_DEIE_POS                        4                                                             /** HDAOSD2CTLL DEIE-bit position */
#define AG903_HDA_OSD2CTLL_DEIE_MSK                        (0x1U << AG903_HDA_OSD2CTLL_DEIE_POS)                         /** HDAOSD2CTLL DEIE-bit mask */

#define AG903_HDA_OSD2CTLU_STRIPE_POS                      0                                                             /** HDAOSD2CTLU STRIPE-bit position */
#define AG903_HDA_OSD2CTLU_STRIPE_MSK                      (0x3U << AG903_HDA_OSD2CTLU_STRIPE_POS)                       /** HDAOSD2CTLU STRIPE-bit mask */
#define AG903_HDA_OSD2CTLU_TP_POS                          2                                                             /** HDAOSD2CTLU TP-bit position */
#define AG903_HDA_OSD2CTLU_TP_MSK                          (0x1U << AG903_HDA_OSD2CTLU_TP_POS)                           /** HDAOSD2CTLU TP-bit mask */
#define AG903_HDA_OSD2CTLU_DIR_POS                         3                                                             /** HDAOSD2CTLU DIR-bit position */
#define AG903_HDA_OSD2CTLU_DIR_MSK                         (0x1U << AG903_HDA_OSD2CTLU_DIR_POS)                          /** HDAOSD2CTLU DIR-bit mask */
#define AG903_HDA_OSD2CTLU_STRM_POS                        4                                                             /** HDAOSD2CTLU STRM-bit position */
#define AG903_HDA_OSD2CTLU_STRM_MSK                        (0xfU << AG903_HDA_OSD2CTLU_STRM_POS)                         /** HDAOSD2CTLU STRM-bit mask */

#define AG903_HDA_OSD2STS_BCIS_POS                         2                                                             /** HDAOSD2STS BCIS-bit position */
#define AG903_HDA_OSD2STS_BCIS_MSK                         (0x1U << AG903_HDA_OSD2STS_BCIS_POS)                          /** HDAOSD2STS BCIS-bit mask */
#define AG903_HDA_OSD2STS_FIFOE_POS                        3                                                             /** HDAOSD2STS FIFOE-bit position */
#define AG903_HDA_OSD2STS_FIFOE_MSK                        (0x1U << AG903_HDA_OSD2STS_FIFOE_POS)                         /** HDAOSD2STS FIFOE-bit mask */
#define AG903_HDA_OSD2STS_DESE_POS                         4                                                             /** HDAOSD2STS DESE-bit position */
#define AG903_HDA_OSD2STS_DESE_MSK                         (0x1U << AG903_HDA_OSD2STS_DESE_POS)                          /** HDAOSD2STS DESE-bit mask */
#define AG903_HDA_OSD2STS_FIFORDY_POS                      5                                                             /** HDAOSD2STS FIFORDY-bit position */
#define AG903_HDA_OSD2STS_FIFORDY_MSK                      (0x1U << AG903_HDA_OSD2STS_FIFORDY_POS)                       /** HDAOSD2STS FIFORDY-bit mask */

#define AG903_HDA_OSD2LPIB_LPIB_POS                        0                                                             /** HDAOSD2LPIB LPIB-bit position */
#define AG903_HDA_OSD2LPIB_LPIB_MSK                        (0xffffffffUL << AG903_HDA_OSD2LPIB_LPIB_POS)                 /** HDAOSD2LPIB LPIB-bit mask */

#define AG903_HDA_OSD2CBL_CBL_POS                          0                                                             /** HDAOSD2CBL CBL-bit position */
#define AG903_HDA_OSD2CBL_CBL_MSK                          (0xffffffffUL << AG903_HDA_OSD2CBL_CBL_POS)                   /** HDAOSD2CBL CBL-bit mask */

#define AG903_HDA_OSD2LVI_LVI_POS                          0                                                             /** HDAOSD2LVI LVI-bit position */
#define AG903_HDA_OSD2LVI_LVI_MSK                          (0xffU << AG903_HDA_OSD2LVI_LVI_POS)                          /** HDAOSD2LVI LVI-bit mask */

#define AG903_HDA_OSD2FIFOS_FIFOS_POS                      0                                                             /** HDAOSD2FIFOS FIFOS-bit position */
#define AG903_HDA_OSD2FIFOS_FIFOS_MSK                      (0xffffU << AG903_HDA_OSD2FIFOS_FIFOS_POS)                    /** HDAOSD2FIFOS FIFOS-bit mask */

#define AG903_HDA_OSD2FMT_CHAN_POS                         0                                                             /** HDAOSD2FMT CHAN-bit position */
#define AG903_HDA_OSD2FMT_CHAN_MSK                         (0xfU << AG903_HDA_OSD2FMT_CHAN_POS)                          /** HDAOSD2FMT CHAN-bit mask */
#define AG903_HDA_OSD2FMT_BITS_POS                         4                                                             /** HDAOSD2FMT BITS-bit position */
#define AG903_HDA_OSD2FMT_BITS_MSK                         (0x7U << AG903_HDA_OSD2FMT_BITS_POS)                          /** HDAOSD2FMT BITS-bit mask */
#define AG903_HDA_OSD2FMT_DIV_POS                          8                                                             /** HDAOSD2FMT DIV-bit position */
#define AG903_HDA_OSD2FMT_DIV_MSK                          (0x7U << AG903_HDA_OSD2FMT_DIV_POS)                           /** HDAOSD2FMT DIV-bit mask */
#define AG903_HDA_OSD2FMT_MULT_POS                         11                                                            /** HDAOSD2FMT MULT-bit position */
#define AG903_HDA_OSD2FMT_MULT_MSK                         (0x7U << AG903_HDA_OSD2FMT_MULT_POS)                          /** HDAOSD2FMT MULT-bit mask */
#define AG903_HDA_OSD2FMT_BASE_POS                         14                                                            /** HDAOSD2FMT BASE-bit position */
#define AG903_HDA_OSD2FMT_BASE_MSK                         (0x1U << AG903_HDA_OSD2FMT_BASE_POS)                          /** HDAOSD2FMT BASE-bit mask */

#define AG903_HDA_OSD2BDPL_BDLLBASE_POS                    7                                                             /** HDAOSD2BDPL BDLLBASE-bit position */
#define AG903_HDA_OSD2BDPL_BDLLBASE_MSK                    (0x1ffffffUL << AG903_HDA_OSD2BDPL_BDLLBASE_POS)              /** HDAOSD2BDPL BDLLBASE-bit mask */

#define AG903_HDA_OSD2BDPU_BDLUBASE_POS                    0                                                             /** HDAOSD2BDPU BDLUBASE-bit position */
#define AG903_HDA_OSD2BDPU_BDLUBASE_MSK                    (0xffffffffUL << AG903_HDA_OSD2BDPU_BDLUBASE_POS)             /** HDAOSD2BDPU BDLUBASE-bit mask */

#define AG903_HDA_OSD3CTLL_SRST_POS                        0                                                             /** HDAOSD3CTLL SRST-bit position */
#define AG903_HDA_OSD3CTLL_SRST_MSK                        (0x1U << AG903_HDA_OSD3CTLL_SRST_POS)                         /** HDAOSD3CTLL SRST-bit mask */
#define AG903_HDA_OSD3CTLL_RUN_POS                         1                                                             /** HDAOSD3CTLL RUN-bit position */
#define AG903_HDA_OSD3CTLL_RUN_MSK                         (0x1U << AG903_HDA_OSD3CTLL_RUN_POS)                          /** HDAOSD3CTLL RUN-bit mask */
#define AG903_HDA_OSD3CTLL_IOCE_POS                        2                                                             /** HDAOSD3CTLL IOCE-bit position */
#define AG903_HDA_OSD3CTLL_IOCE_MSK                        (0x1U << AG903_HDA_OSD3CTLL_IOCE_POS)                         /** HDAOSD3CTLL IOCE-bit mask */
#define AG903_HDA_OSD3CTLL_FEIE_POS                        3                                                             /** HDAOSD3CTLL FEIE-bit position */
#define AG903_HDA_OSD3CTLL_FEIE_MSK                        (0x1U << AG903_HDA_OSD3CTLL_FEIE_POS)                         /** HDAOSD3CTLL FEIE-bit mask */
#define AG903_HDA_OSD3CTLL_DEIE_POS                        4                                                             /** HDAOSD3CTLL DEIE-bit position */
#define AG903_HDA_OSD3CTLL_DEIE_MSK                        (0x1U << AG903_HDA_OSD3CTLL_DEIE_POS)                         /** HDAOSD3CTLL DEIE-bit mask */

#define AG903_HDA_OSD3CTLU_STRIPE_POS                      0                                                             /** HDAOSD3CTLU STRIPE-bit position */
#define AG903_HDA_OSD3CTLU_STRIPE_MSK                      (0x3U << AG903_HDA_OSD3CTLU_STRIPE_POS)                       /** HDAOSD3CTLU STRIPE-bit mask */
#define AG903_HDA_OSD3CTLU_TP_POS                          2                                                             /** HDAOSD3CTLU TP-bit position */
#define AG903_HDA_OSD3CTLU_TP_MSK                          (0x1U << AG903_HDA_OSD3CTLU_TP_POS)                           /** HDAOSD3CTLU TP-bit mask */
#define AG903_HDA_OSD3CTLU_DIR_POS                         3                                                             /** HDAOSD3CTLU DIR-bit position */
#define AG903_HDA_OSD3CTLU_DIR_MSK                         (0x1U << AG903_HDA_OSD3CTLU_DIR_POS)                          /** HDAOSD3CTLU DIR-bit mask */
#define AG903_HDA_OSD3CTLU_STRM_POS                        4                                                             /** HDAOSD3CTLU STRM-bit position */
#define AG903_HDA_OSD3CTLU_STRM_MSK                        (0xfU << AG903_HDA_OSD3CTLU_STRM_POS)                         /** HDAOSD3CTLU STRM-bit mask */

#define AG903_HDA_OSD3STS_BCIS_POS                         2                                                             /** HDAOSD3STS BCIS-bit position */
#define AG903_HDA_OSD3STS_BCIS_MSK                         (0x1U << AG903_HDA_OSD3STS_BCIS_POS)                          /** HDAOSD3STS BCIS-bit mask */
#define AG903_HDA_OSD3STS_FIFOE_POS                        3                                                             /** HDAOSD3STS FIFOE-bit position */
#define AG903_HDA_OSD3STS_FIFOE_MSK                        (0x1U << AG903_HDA_OSD3STS_FIFOE_POS)                         /** HDAOSD3STS FIFOE-bit mask */
#define AG903_HDA_OSD3STS_DESE_POS                         4                                                             /** HDAOSD3STS DESE-bit position */
#define AG903_HDA_OSD3STS_DESE_MSK                         (0x1U << AG903_HDA_OSD3STS_DESE_POS)                          /** HDAOSD3STS DESE-bit mask */
#define AG903_HDA_OSD3STS_FIFORDY_POS                      5                                                             /** HDAOSD3STS FIFORDY-bit position */
#define AG903_HDA_OSD3STS_FIFORDY_MSK                      (0x1U << AG903_HDA_OSD3STS_FIFORDY_POS)                       /** HDAOSD3STS FIFORDY-bit mask */

#define AG903_HDA_OSD3LPIB_LPIB_POS                        0                                                             /** HDAOSD3LPIB LPIB-bit position */
#define AG903_HDA_OSD3LPIB_LPIB_MSK                        (0xffffffffUL << AG903_HDA_OSD3LPIB_LPIB_POS)                 /** HDAOSD3LPIB LPIB-bit mask */

#define AG903_HDA_OSD3CBL_CBL_POS                          0                                                             /** HDAOSD3CBL CBL-bit position */
#define AG903_HDA_OSD3CBL_CBL_MSK                          (0xffffffffUL << AG903_HDA_OSD3CBL_CBL_POS)                   /** HDAOSD3CBL CBL-bit mask */

#define AG903_HDA_OSD3LVI_LVI_POS                          0                                                             /** HDAOSD3LVI LVI-bit position */
#define AG903_HDA_OSD3LVI_LVI_MSK                          (0xffU << AG903_HDA_OSD3LVI_LVI_POS)                          /** HDAOSD3LVI LVI-bit mask */

#define AG903_HDA_OSD3FIFOS_FIFOS_POS                      0                                                             /** HDAOSD3FIFOS FIFOS-bit position */
#define AG903_HDA_OSD3FIFOS_FIFOS_MSK                      (0xffffU << AG903_HDA_OSD3FIFOS_FIFOS_POS)                    /** HDAOSD3FIFOS FIFOS-bit mask */

#define AG903_HDA_OSD3FMT_CHAN_POS                         0                                                             /** HDAOSD3FMT CHAN-bit position */
#define AG903_HDA_OSD3FMT_CHAN_MSK                         (0xfU << AG903_HDA_OSD3FMT_CHAN_POS)                          /** HDAOSD3FMT CHAN-bit mask */
#define AG903_HDA_OSD3FMT_BITS_POS                         4                                                             /** HDAOSD3FMT BITS-bit position */
#define AG903_HDA_OSD3FMT_BITS_MSK                         (0x7U << AG903_HDA_OSD3FMT_BITS_POS)                          /** HDAOSD3FMT BITS-bit mask */
#define AG903_HDA_OSD3FMT_DIV_POS                          8                                                             /** HDAOSD3FMT DIV-bit position */
#define AG903_HDA_OSD3FMT_DIV_MSK                          (0x7U << AG903_HDA_OSD3FMT_DIV_POS)                           /** HDAOSD3FMT DIV-bit mask */
#define AG903_HDA_OSD3FMT_MULT_POS                         11                                                            /** HDAOSD3FMT MULT-bit position */
#define AG903_HDA_OSD3FMT_MULT_MSK                         (0x7U << AG903_HDA_OSD3FMT_MULT_POS)                          /** HDAOSD3FMT MULT-bit mask */
#define AG903_HDA_OSD3FMT_BASE_POS                         14                                                            /** HDAOSD3FMT BASE-bit position */
#define AG903_HDA_OSD3FMT_BASE_MSK                         (0x1U << AG903_HDA_OSD3FMT_BASE_POS)                          /** HDAOSD3FMT BASE-bit mask */

#define AG903_HDA_OSD3BDPL_BDLLBASE_POS                    7                                                             /** HDAOSD3BDPL BDLLBASE-bit position */
#define AG903_HDA_OSD3BDPL_BDLLBASE_MSK                    (0x1ffffffUL << AG903_HDA_OSD3BDPL_BDLLBASE_POS)              /** HDAOSD3BDPL BDLLBASE-bit mask */

#define AG903_HDA_OSD3BDPU_BDLUBASE_POS                    0                                                             /** HDAOSD3BDPU BDLUBASE-bit position */
#define AG903_HDA_OSD3BDPU_BDLUBASE_MSK                    (0xffffffffUL << AG903_HDA_OSD3BDPU_BDLUBASE_POS)             /** HDAOSD3BDPU BDLUBASE-bit mask */

#define AG903_HDA_WALCLKA_COUNTERA_POS                     0                                                             /** HDAWALCLKA COUNTERA-bit position */
#define AG903_HDA_WALCLKA_COUNTERA_MSK                     (0xffffffffUL << AG903_HDA_WALCLKA_COUNTERA_POS)              /** HDAWALCLKA COUNTERA-bit mask */

#define AG903_HDA_ISD0LPIBA_LPIBA_POS                      0                                                             /** HDAISD0LPIBA LPIBA-bit position */
#define AG903_HDA_ISD0LPIBA_LPIBA_MSK                      (0xffffffffUL << AG903_HDA_ISD0LPIBA_LPIBA_POS)               /** HDAISD0LPIBA LPIBA-bit mask */

#define AG903_HDA_OSD0LPIBA_LPIBA_POS                      0                                                             /** HDAOSD0LPIBA LPIBA-bit position */
#define AG903_HDA_OSD0LPIBA_LPIBA_MSK                      (0xffffffffUL << AG903_HDA_OSD0LPIBA_LPIBA_POS)               /** HDAOSD0LPIBA LPIBA-bit mask */

#define AG903_HDA_OSD1LPIBA_LPIBA_POS                      0                                                             /** HDAOSD1LPIBA LPIBA-bit position */
#define AG903_HDA_OSD1LPIBA_LPIBA_MSK                      (0xffffffffUL << AG903_HDA_OSD1LPIBA_LPIBA_POS)               /** HDAOSD1LPIBA LPIBA-bit mask */

#define AG903_HDA_OSD2LPIBA_LPIBA_POS                      0                                                             /** HDAOSD2LPIBA LPIBA-bit position */
#define AG903_HDA_OSD2LPIBA_LPIBA_MSK                      (0xffffffffUL << AG903_HDA_OSD2LPIBA_LPIBA_POS)               /** HDAOSD2LPIBA LPIBA-bit mask */

#define AG903_HDA_OSD3LPIBA_LPIBA_POS                      0                                                             /** HDAOSD3LPIBA LPIBA-bit position */
#define AG903_HDA_OSD3LPIBA_LPIBA_MSK                      (0xffffffffUL << AG903_HDA_OSD3LPIBA_LPIBA_POS)               /** HDAOSD3LPIBA LPIBA-bit mask */

#endif /* _AG903_HDA_REGMAP_H_ */

