/**
 * @brief           VID Manager Header
 * @author          AXELL CORPORATION
 * @description     VID Manager Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef VIDMGR_H
#define VIDMGR_H
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>
#include "AG903_errno.h"

/** fW^rfI̓|[g */
#define AG903_VID_MGR_MAX_IN_PORTS          (2)
/** fW^rfIo̓|[g */
#define AG903_VID_MGR_MAX_OUT_PORTS         (4)

/** fW^rfI̓|[gnhʂ郆j[NID */
#define AG903_VID_MGR_INPUT_HANDLE_ID       (0xB1234BBB)
/** fW^rfIo̓|[gnhʂ郆j[NID */
#define AG903_VID_MGR_OUTPUT_HANDLE_ID      (0xB5678BBB)

/** ̓|[gnh */
#define AG903_VID_MGR_INPUT_HANDLE          (0)
/** o̓|[gnh */
#define AG903_VID_MGR_OUTPUT_HANDLE         (1)

/** ̓tH[}bg 24bitiRGB888AYCbCr444jCh0o */
#define AG903_VID_MGR_24BIT_TO_CH0          (0)
/** ̓tH[}bg 8bit Ch0́iYCbCr422jCh0o */
#define AG903_VID_MGR_8BITCH0_TO_CH0        (1)
/** ̓tH[}bg 8bit Ch1́iYCbCr422jCh1o */
#define AG903_VID_MGR_8BITCH1_TO_CH1        (2)
/** ̓tH[}bg 8bit Ch0A1́iYCbCr422jCh0A1o */
#define AG903_VID_MGR_8BITCH01_TO_CH01      (3)
/** ̓tH[}bg 8bit Ch0 4chsNZTDMiYCbCr422jCh0-3o */
#define AG903_VID_MGR_8BITCH0_TO_CH0123     (4)

/** M */
#define AG903_VID_MGR_IO_SIGNAL_INPUT       (0)
/** Mo */
#define AG903_VID_MGR_IO_SIGNAL_OUTPUT      (1)

/** oVSYNC̋ɐ_ */
#define AG903_VID_MGR_IO_VSYNC_POL_MINUS    (0)
/** oVSYNC̋ɐ_ */
#define AG903_VID_MGR_IO_VSYNC_POL_PLUS     (1)
/** oHSYNC̋ɐ_ */
#define AG903_VID_MGR_IO_HSYNC_POL_MINUS    (0)
/** oHSYNC̋ɐ_ */
#define AG903_VID_MGR_IO_HSYNC_POL_PLUS     (1)

/** DE̋ɐ_ */
#define AG903_VID_MGR_IN_DE_POL_MINUS       (0)
/** DE̋ɐ_ */
#define AG903_VID_MGR_IN_DE_POL_PLUS        (1)

/** FIELD̋ɐ_ */
#define AG903_VID_MGR_IN_FIELD_POL_MINUS    (0)
/** FIELD̋ɐ_ */
#define AG903_VID_MGR_IN_FIELD_POL_PLUS     (1)

/** ̓NbN̋ɐ_ */
#define AG903_VID_MGR_IN_CLK_POL_MINUS      (0)
/** ̓NbN̋ɐ_ */
#define AG903_VID_MGR_IN_CLK_POL_PLUS       (1)

/** MpX̍ől */
#define AG903_VID_MGR_MAX_OUT_HORIZONTAL_PULSE_WIDTH    (4096)

/** tg|[`̍ől */
#define AG903_VID_MGR_MAX_OUT_HORIZONTAL_FRONT_PORCH    (4096)

/** obN|[`̍ől */
#define AG903_VID_MGR_MAX_OUT_HORIZONTAL_BACK_PORCH     (4096)

/** t[TCY̍ől */
#define AG903_VID_MGR_MAX_OUT_HORIZONTAL_FRAME_SIZE     (4096)

/** MpX̍ől */
#define AG903_VID_MGR_MAX_OUT_VERTICAL_PULSE_WIDTH      (4096)

/** tg|[`̍ől */
#define AG903_VID_MGR_MAX_OUT_VERTICAL_FRONT_PORCH      (4096)

/** obN|[`̍ől */
#define AG903_VID_MGR_MAX_OUT_VERTICAL_BACK_PORCH       (4096)

/** t[TCY̍ől */
#define AG903_VID_MGR_MAX_OUT_VERTICAL_FRAME_SIZE       (4096)

/** TDM샂[h o̓`l킹@\𖳌 */
#define AG903_VID_MGR_TDM_NONE              (0)
/** TDM샂[h BLANKM̃`lƏo̓`l킹 */
#define AG903_VID_MGR_TDM_FIT_BLANK_SIGNAL  (1)
/** TDM샂[h TRSM̃`lƏo̓`l킹 */
#define AG903_VID_MGR_TDM_FIT_TRS_SIGNAL    (2)

/** C^[X[hEvent[VFP+1Ȃ */
#define AG903_VID_MGR_TRS_EFP_ZERO          (0)
/** C^[X[hEvent[VFP+1 */
#define AG903_VID_MGR_TRS_EFP_ONE           (1)
/** C^[X[hOddt[VFP+1Ȃ */
#define AG903_VID_MGR_TRS_OFP_ZERO          (0)
/** C^[X[hOddt[VFP+1 */
#define AG903_VID_MGR_TRS_OFP_ONE           (1)

/** uNԊJnSAV/EAVVSYNCオFIELDlf܂ł̃TCN̍ől */
#define AG903_VID_MGR_MAX_TRS_VFP           (4096)

/** EAVHSYNC𐶐 */
#define AG903_VID_MGR_TRS_HREF_EAV          (0)
/** SAVHSYNC𐶐 */
#define AG903_VID_MGR_TRS_HREF_SAV          (1)

/** SAV/EAVHSYNCオ܂ł̃TCN̍ől */
#define AG903_VID_MGR_MAX_TRS_HFP           (4095)

/** ̍őTCN̍ől */
#define AG903_VID_MGR_MAX_SD_VERTICAL_CYCLE     (8192)
/** ̍őTCN̍ől */
#define AG903_VID_MGR_MAX_SD_HORIZONTAL_CYCLE   (8192)

/**
 * fW^rfI̓|[gnh
 */
typedef struct _AG903_VidMgrInputHandle {
    uint32_t  id;               /** fW^̓|[gnhʂID */
    _Bool     is_dirty;         /** ̓|[gdritytOBݒ肪ύXɂȂꍇtrueݒ */
    uint32_t  port_no;          /** ̓|[g̕No */
    uint32_t  sync_signal;      /** M̓́Eo͐ݒ */
    uint32_t  inout_vsync_pol;  /** oVSYNC̋ɐ */
    uint32_t  inout_hsync_pol;  /** oHSYNC̋ɐ */
    uint32_t  in_de_pol;        /** DE̋ɐ */
    uint32_t  in_field_pol;     /** FIELD̋ɐ */
    uint32_t  in_clk_pol;       /** ̓NbN̋ɐ */
    uint32_t  h_pulse_width;    /** MpX */
    uint32_t  h_front_porch;    /** tg|[` */
    uint32_t  h_back_porch;     /** obN|[` */
    uint32_t  h_frame_size;     /** t[TCY */
    uint32_t  v_pulse_width;    /** MpX */
    uint32_t  v_front_porch;    /** tg|[` */
    uint32_t  v_back_porch;     /** tg|[` */
    uint32_t  v_frame_size;     /** t[TCY */
} AG903_VidMgrInputHandle;

/**
 * fW^rfIo̓|[gnh
 */
typedef struct _AG903_VidMgrOutputHandle {
    uint32_t  id;               /** fW^o̓|[gnhʂID */
    _Bool     is_dirty;         /** o̓|[g̕No */
    uint32_t  port_no;          /** o̓|[gdritytOBݒ肪ύXɂȂꍇtrueݒ */
    uint32_t  tdm;              /** 4bit TDM̐ݒ */
    _Bool     delay;            /** ̓f[^̒xݒ̗LtO */
    _Bool     trs_dec_enable;   /** TRSfR[h̗LtO */
    uint32_t  trs_efp;          /** C^[X[hEvent[VPF+1 */
    uint32_t  trs_ofp;          /** C^[X[hOddt[VPF+1 */
    uint32_t  trs_vfp;          /** uNԊJnSAV/EAVVSYNCオFIELDlf܂ł̃TCN */
    uint32_t  trs_href;         /** HSYNC̊ */
    uint32_t  trs_hfp;          /** SAV/EAVHSYNCオ܂ł̃TCN */
    uint32_t  v_max;            /** ̍őTCN */
    uint32_t  h_max;            /** ̍őTCN */
} AG903_VidMgrOutputHandle;


int32_t AG903_VidMgrEnable(_Bool enable);
int32_t AG903_VidMgrSetInputFormat(uint32_t format);
int32_t AG903_VidMgrGetInputHandle(int32_t *ports, int32_t num_ports, AG903_VidMgrInputHandle **handles);
int32_t AG903_VidMgrReleaseInputHandle(AG903_VidMgrInputHandle *handle);
int32_t AG903_VidMgrGetOutputHandle(int32_t *ports, int32_t num_ports, AG903_VidMgrOutputHandle **handles);
int32_t AG903_VidMgrReleaseOutputHandle(AG903_VidMgrOutputHandle *handle);
int32_t AG903_VidMgrCommitSetting(void);
int32_t AG903_VidMgrCheckHandleValidation(void *handle, int32_t handle_type);
int32_t AG903_VidMgrSetIOSignal(AG903_VidMgrInputHandle *handle, uint32_t inout);
int32_t AG903_VidMgrSetIOMode(AG903_VidMgrInputHandle *handle, uint32_t v_pol, uint32_t h_pol, uint32_t d_pol, uint32_t f_pol, uint32_t c_pol);
int32_t AG903_VidMgrSetIOParameter(AG903_VidMgrInputHandle *handle, uint32_t h_pw, uint32_t h_fp, uint32_t h_bp, uint32_t h_fs, uint32_t v_pw, uint32_t v_fp, uint32_t v_bp, uint32_t v_fs);
int32_t AG903_VidMgrGetIODotClk(AG903_VidMgrInputHandle *handle, uint32_t *cwt);
int32_t AG903_VidMgrSetCaptureTDMMode(AG903_VidMgrOutputHandle *handle, uint32_t tdm);
int32_t AG903_VidMgrEnableCaptureDelay(AG903_VidMgrOutputHandle *handle, _Bool delay);
int32_t AG903_VidMgrEnableTRSDecode(AG903_VidMgrOutputHandle *handle, _Bool trs_dec);
int32_t AG903_VidMgrSetTRSParameter(AG903_VidMgrOutputHandle *handle, uint32_t efp, uint32_t ofp, uint32_t vfp, uint32_t href, uint32_t hfp);
int32_t AG903_VidMgrSetDetectionCycle(AG903_VidMgrOutputHandle *handle, uint32_t v_max, uint32_t h_max);
int32_t AG903_VidMgrGetOutputState(AG903_VidMgrOutputHandle *handle, uint32_t *blk_val, uint32_t *trs_val, uint32_t *v_blank, uint32_t *h_blank, uint32_t *tdm_ch);


#ifdef __cplusplus
}
#endif


#endif
