/**
 * @brief       PGP Manager (Assign)
 * @author      AXELL CORPORATION
 * @description PGP Manager Layer.
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
 * @history     2018_01_24  Ver2.1 [#1767] fBUO@\LɂĂK؂ȃpCvCĂȂsΉ
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include <stdio.h>
#include "pgpmgr_common.h"

#define PIPELINE_SIZE_FULLHD   1920
#define PIPELINE_SIZE_VGA      768


/* pCvCnh̐ݒe犄蓖ĐI܂ */
static int32_t PgpMgrAssignPipeline(AG903_PgpMgrPipelineHandle *handle)
{
    int32_t pipeline_no;
    PgpMgrContext *ctx = PgpGetContext();

    /* t[ۑpCvCɊ蓖ĉ\ȏꍇ́At[ۑpCvCɊ蓖Ă܂ */
    if ((handle->thr_enable == false) && (handle->dgc_enable == false) && (handle->hsv1_enable == false) &&
        (handle->spf_enable == false) && (handle->hgm_enable == false) && (handle->lbl_enable == false) &&
        (handle->ifc_enable == false) &&
        (handle->input_format != AG903_PGP_MGR_INPUT_FMT_YCBCR422_W_IP) && (handle->scale_enable == false) &&
        (handle->csc1_enable == false) && (handle->nrf_enable == false) &&
        (handle->output_dither_enable == false) &&
        ((ctx->assign_pipeline[AG903_PGP_MGR_FRAME_PIPELINE0] == NULL) || (ctx->assign_pipeline[AG903_PGP_MGR_FRAME_PIPELINE1] == NULL))) {
        if (ctx->assign_pipeline[AG903_PGP_MGR_FRAME_PIPELINE1] != NULL) {
            pipeline_no = AG903_PGP_MGR_FRAME_PIPELINE0;
        } else {
            pipeline_no = AG903_PGP_MGR_FRAME_PIPELINE1;
        }
    /* ͉摜pCvCɊ蓖ĉ\ȏꍇ́A͉摜pCvCɊ蓖Ă܂ */
    } else if ((handle->thr_enable == false) && (handle->dgc_enable == false) && (handle->hsv1_enable == false) &&
        (handle->spf_enable == false) && (handle->hgm_enable == false) && (handle->lbl_enable == false) &&
        (handle->ifc_enable == false) &&
        (((ctx->assign_pipeline[AG903_PGP_MGR_INPUT_PIPELINE0] == NULL) && (handle->input_hsize <= PIPELINE_SIZE_FULLHD)) ||
        ((ctx->assign_pipeline[AG903_PGP_MGR_INPUT_PIPELINE1] == NULL) && (handle->input_hsize <= PIPELINE_SIZE_VGA)))) {
        if ((ctx->assign_pipeline[AG903_PGP_MGR_INPUT_PIPELINE1] == NULL) && (handle->input_hsize <= PIPELINE_SIZE_VGA)) {
            pipeline_no = AG903_PGP_MGR_INPUT_PIPELINE1;
        } else {
            pipeline_no = AG903_PGP_MGR_INPUT_PIPELINE0;
        }
    /* ZpCvCɊĉ\ȏꍇ́A ZpCvCɊ蓖Ă܂*/
    } else if (((ctx->assign_pipeline[AG903_PGP_MGR_CALC_PIPELINE0] == NULL) && (handle->input_hsize <= PIPELINE_SIZE_FULLHD)) ||
        ((ctx->assign_pipeline[AG903_PGP_MGR_CALC_PIPELINE1] == NULL) && (handle->input_hsize <= PIPELINE_SIZE_VGA))) {
        if ((ctx->assign_pipeline[AG903_PGP_MGR_CALC_PIPELINE1] == NULL) && (handle->input_hsize <= PIPELINE_SIZE_VGA)) {
            pipeline_no = AG903_PGP_MGR_CALC_PIPELINE1;
        } else {
            pipeline_no = AG903_PGP_MGR_CALC_PIPELINE0;
        }
    } else {
        /* 蓖Ďs */
        pipeline_no = -1;
    }
    return pipeline_no;
}


/* w肵pCvCɑ΂ăt[ԉZ̃X[upCvCnh̊蓖Ă\`FbN܂ */
static int32_t PgpMgrCheckSlaveAssignPipeline(AG903_PgpMgrPipelineHandle *handle, uint32_t pipeline)
{
    PgpMgrContext *ctx = PgpGetContext();

    switch (pipeline) {
        case AG903_PGP_MGR_CALC_PIPELINE0:
            if ((ctx->assign_pipeline[AG903_PGP_MGR_CALC_PIPELINE0] == NULL) && handle->input_hsize <= PIPELINE_SIZE_FULLHD) {
                return 0;
            }
            break;
        case AG903_PGP_MGR_CALC_PIPELINE1:
        default:
            if ((ctx->assign_pipeline[AG903_PGP_MGR_CALC_PIPELINE1] == NULL) && handle->input_hsize <= PIPELINE_SIZE_VGA) {
                return 0;
            }
            break;
    } 
    return -AG903_EINVAL;
}


/* VRAM̓nh̊蓖ĂsȂ܂ */
static int32_t PgpMgrAssignVRAMInput(AG903_PgpMgrVRAMInputHandle *handle)
{
    int32_t vram_port_no;

    /* VRAM̓nh͕̃pCvCŋL\Ȃ̂ŁAɊ蓖čς̏ꍇ͏𔲂܂ */
    if (handle->port_no != -1) {
        return handle->port_no;
    }

    /* 얳͋󂢂ĂVRAM̓|[gIAL݂͌Ɋ蓖Ă܂ */
    PgpMgrContext *ctx = PgpGetContext();
    if (ctx->pipeline_time_sharing_enable == false) {
        if (ctx->assign_vram[0] == NULL) {
            vram_port_no = 0;
        } else if (ctx->assign_vram[1] == NULL) {
            vram_port_no = 1;
        } else {
            /* 蓖Ďs */
            vram_port_no = -1;
        }
    } else {
        static int32_t next_vram_port_no = 0;
        vram_port_no = next_vram_port_no;
        next_vram_port_no = (next_vram_port_no == 0) ? 1 : 0;
    }
    return vram_port_no;
}


/* pCvC̊蓖ďXV邽߂̃}N */
#define SET_PIPELINE_ASSIGN_INFO(handle, pipeline) \
            if (ctx->pipeline_time_sharing_enable == false) { \
                ctx->assign_pipeline[(pipeline)] = (handle); \
            }; \
            (handle)->is_assign = true; \
            (handle)->is_dirty = false; \
            (handle)->pipeline_no = (pipeline);
/* VRAM͊蓖ďXV邽߂̃}N */
#define SET_VRAM_ASSIGN_INFO(handle, vram_port_no) \
            if (ctx->pipeline_time_sharing_enable == false) { \
                ctx->assign_vram[(vram_port_no)] = (handle); \
            } \
            (handle)->is_dirty = false; \
            (handle)->port_no = (vram_port_no);


/**
 * @brief   pCvCnh̊蓖ĂsȂ܂B
 * @param   handle [in] 蓖ĂsȂpCvCnhw肵܂B
 * @return  pCvCԍ 蓖Đ
 * @return  -AG903_EINVAL 蓖Ďs̏ꍇ
 * @note    {֐̓[U[ڎgp邱Ƃ͂܂B
*/
int32_t PgpMgrAssignPipelineHandle(AG903_PgpMgrPipelineHandle *handle)
{
    int32_t pipeline_no = PgpMgrAssignPipeline(handle);
    _Bool input_vram = false;
    int32_t vram_port_no = 0;
    PgpMgrContext *ctx = PgpGetContext();

    /* pCvCւ̓̓\[XVRAM͂̏ꍇAVRAM͂̊蓖ĂsȂ܂ */
    AG903_PgpMgrVRAMInputHandle *vram_handle = (AG903_PgpMgrVRAMInputHandle *)handle->input_handle;
    if (vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
        input_vram = true;
        vram_port_no = PgpMgrAssignVRAMInput(vram_handle);
    }

    /* 蓖Ďs̏ꍇ̓G[Ƃ܂ */
    if ((pipeline_no == -1) || (vram_port_no == -1)) {
        return -AG903_EINVAL;
    }

    /* ̓\[XVRAM͂̏ꍇAVRAM̓nh̐ݒXV܂ */
    if (input_vram == true) {
        /* VRAM͂̊蓖ďXV܂ */
        SET_VRAM_ASSIGN_INFO(vram_handle, vram_port_no);
        /* VRAM͂̃|[gԍ͊蓖ĎɌ肷邽߁ApCvC̓̓|[g̒l̃^C~OōXV܂ */
        handle->input_port = vram_port_no == 0 ? AG903_PGP_MGR_INPUT_PORT_VRAM_0 : AG903_PGP_MGR_INPUT_PORT_VRAM_1;
    }

    /* pCvC̊蓖ďXV܂ */
    SET_PIPELINE_ASSIGN_INFO(handle, pipeline_no);
    return pipeline_no;
}


/**
 * @brief   t[ԉZnh̊蓖ĂsȂ܂B
 * @param   handle [in] 蓖ĂsȂt[ԉZnhw肵܂B
 * @return  pCvCԍ 蓖Đ
 * @return  -AG903_EINVAL 蓖Ďs̏ꍇ
 * @note    {֐̓[U[ڎgp邱Ƃ͂܂B
*/
int32_t PgpMgrAssignFrameCalcHandle(AG903_PgpMgrFrameCalcHandle *handle)
{
    int32_t master_pipeline_no, slave_pipeline_no;
    int32_t master_vram_port_no = 0, slave_vram_port_no;
    AG903_PgpMgrVRAMInputHandle *master_vram_handle;
    AG903_PgpMgrVRAMInputHandle *slave_vram_handle;
    PgpMgrContext *ctx = PgpGetContext();

    /* }X^̃pCvC蓖ĂsȂ܂ */
    master_pipeline_no = PgpMgrAssignPipeline(handle->master_handle);
    if (master_pipeline_no == -1) {
        return -AG903_EINVAL;
    }
    /* }X^pCvCւ̓̓\[XVRAM͂̏ꍇAVRAM͂̊蓖ĂsȂ܂ */
    master_vram_handle = (AG903_PgpMgrVRAMInputHandle *)handle->master_handle->input_handle;
    if (master_vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
        master_vram_port_no = PgpMgrAssignVRAMInput(master_vram_handle);
        if (master_vram_port_no == -1) {
            return -AG903_EINVAL;
        }
    }
    if (handle->slave_pipeline == true) {
        AG903_PgpMgrPipelineHandle *slave = (AG903_PgpMgrPipelineHandle *)handle->slave_handle;
        slave_pipeline_no = (master_pipeline_no == AG903_PGP_MGR_CALC_PIPELINE0) ?
                                AG903_PGP_MGR_CALC_PIPELINE1 : AG903_PGP_MGR_CALC_PIPELINE0;
        if (PgpMgrCheckSlaveAssignPipeline(slave, slave_pipeline_no) != 0) {
            return -AG903_EINVAL;
        }
        /* X[upCvCւ̓̓\[XVRAM͂̏ꍇAVRAM͂̊蓖ĂsȂ܂ */
        slave_vram_handle = (AG903_PgpMgrVRAMInputHandle *)slave->input_handle;
        if (slave_vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
            /* }X^AX[uVRAM̓nhLꍇA蓖ē̏̓XLbv܂ */
            if (master_vram_handle == slave_vram_handle) {
                slave_vram_port_no = master_vram_port_no;
            } else {
                slave_vram_port_no = PgpMgrAssignVRAMInput(slave_vram_handle);
                if (slave_vram_port_no == -1) {
                    return -AG903_EINVAL;
                }
                /* VRAM͑f[^\XV܂ */
                SET_VRAM_ASSIGN_INFO(slave_vram_handle, slave_vram_port_no);
            }
            /* VRAM͂̃|[gԍ͊蓖ĎɌ肷邽߁ApCvC̓̓|[g̒l̃^C~OōXV܂ */
            slave->input_port = slave_vram_port_no == 0 ? AG903_PGP_MGR_INPUT_PORT_VRAM_0 : AG903_PGP_MGR_INPUT_PORT_VRAM_1;
        }
        /* X[u蓖ĉ\ȏꍇ͊蓖ĐǗf[^\Ƀnhێ܂ */
        SET_PIPELINE_ASSIGN_INFO(slave, slave_pipeline_no);
    } else {
        /* X[uVRAM͂̏ꍇA}X^̃pCvCԍVRAM̓|[g肵܂ */
        slave_vram_handle = (AG903_PgpMgrVRAMInputHandle *)handle->slave_handle;
        slave_vram_port_no = (master_pipeline_no == AG903_PGP_MGR_CALC_PIPELINE0) ? 2 : 3;
        SET_VRAM_ASSIGN_INFO(slave_vram_handle, slave_vram_port_no);
    }
    /* }X^̓\[XVRAM͂̏ꍇAVRAM̓nh̐ݒXV܂ */
    if (master_vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
        /* VRAM͂̊蓖ďXV܂ */
        SET_VRAM_ASSIGN_INFO(master_vram_handle, master_vram_port_no);
        /* VRAM͂̃|[gԍ͊蓖ĎɌ肷邽߁ApCvC̓̓|[g̒l̃^C~OōXV܂ */
        handle->master_handle->input_port = master_vram_port_no == 0 ? AG903_PGP_MGR_INPUT_PORT_VRAM_0 : AG903_PGP_MGR_INPUT_PORT_VRAM_1;
    }
    /* pCvC̊蓖ďXV܂ */
    SET_PIPELINE_ASSIGN_INFO(handle->master_handle, master_pipeline_no);
    return master_pipeline_no;
}


/* Ŏw肳ꂽpCvCɋ蓖ĉ\`FbN܂ */
static int32_t PgpMgrCheckForceAssignPipeline(uint32_t pipeline)
{
    int32_t i;
    PgpMgrContext *ctx = PgpGetContext();

    /* w肵pCvCɑ̃pCvCnh蓖čςł邩`FbN܂ */
    if (ctx->assign_pipeline[pipeline] != NULL) {
        return -AG903_EINVAL;
    }
    for (i = 0; i < AG903_PGP_MGR_MAX_PIPELINE_HANDLE; i++) {
        if ((ctx->pipeline_handles[i].is_used == true) && (ctx->pipeline_handles[i].is_assign == true) &&
                                                          ((uint32_t)ctx->pipeline_handles[i].pipeline_no == pipeline)) {
            return -AG903_EINVAL;
        }
    }
    return 0;
}

/* pCvC̋蓖ďXV邽߂̃}N */
#define SET_PIPELINE_FORCE_ASSIGN_INFO(handle, pipeline) \
            ctx->assign_pipeline[(pipeline)] = (handle); \
            (handle)->is_assign = true; \
            (handle)->is_dirty = false; \
            (handle)->pipeline_no = (pipeline);

/**
 * @brief   pCvCnhw肵pCvCɋ蓖ĂsȂ܂B
 * @param   handle [in] 蓖ĂsȂpCvCnhw肵܂B
 * @param   pipeline [in] 蓖ĐpCvCԍ
 * @return  pCvCԍ 蓖Đ
 * @return  -AG903_EINVAL 蓖Ďs̏ꍇ
 * @note    {֐̓[U[ڎgp邱Ƃ͂܂B
*/
int32_t PgpMgrForceAssignPipelineHandle(AG903_PgpMgrPipelineHandle *handle, uint32_t pipeline)
{
    int32_t vram_port_no;
    AG903_PgpMgrVRAMInputHandle *vram_handle;
    PgpMgrContext *ctx = PgpGetContext();

    /* 蓖ĉ\`FbN܂ */
    if (PgpMgrCheckForceAssignPipeline(pipeline) != 0) {
        return -AG903_EINVAL;
    }

    /* pCvCւ̓̓\[XVRAM͂ł邩`FbN܂ */
    vram_handle = (AG903_PgpMgrVRAMInputHandle *)handle->input_handle;
    if (vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
        vram_port_no = PgpMgrAssignVRAMInput(vram_handle);

        /* VRAM͂̊蓖ĂɎsꍇ̓G[Ƃ܂ */
        if (vram_port_no == -1) {
            return -AG903_EINVAL;
        }
        /* 蓖ĉ\ȏꍇ͊蓖ĐǗf[^\Ƀnhێ܂ */
        SET_VRAM_ASSIGN_INFO(vram_handle, vram_port_no);
        /* VRAM͂̃|[gԍ͊蓖ĎɌ肷邽߁ApCvC̓̓|[g̒l̃^C~OōXV܂ */
        handle->input_port = vram_port_no == 0 ? AG903_PGP_MGR_INPUT_PORT_VRAM_0 : AG903_PGP_MGR_INPUT_PORT_VRAM_1;
    }

    /* 蓖ĉ\ȏꍇ͊蓖ĐǗf[^\Ƀnhێ܂ */
    SET_PIPELINE_FORCE_ASSIGN_INFO(handle, pipeline);
    return pipeline;
}


/**
 * @brief   t[ԉZnhw肵pCvCɋ蓖ĂsȂ܂B
 * @param   handle [in] 蓖ĂsȂt[ԉZnhw肵܂B
 * @param   pipeline [in] 蓖ĐpCvCԍ(}X^)
 * @return  pCvCԍ 蓖Đ
 * @return  -AG903_EINVAL 蓖Ďs̏ꍇ
 * @note    X[upCvCnh̏ꍇA蓖Đ̓}X^Ƃ͈قȂ鉉ZpCvCɂȂ܂B<p>
 *          {֐̓[U[ڎgp邱Ƃ͂܂B
*/
int32_t PgpMgrForceAssignFrameCalcHandle(AG903_PgpMgrFrameCalcHandle *handle, uint32_t pipeline)
{
    int32_t master_vram_port_no = -1, slave_vram_port_no = -1;
    AG903_PgpMgrVRAMInputHandle *master_vram_handle;
    AG903_PgpMgrVRAMInputHandle *slave_vram_handle;
    PgpMgrContext *ctx = PgpGetContext();

    /* }X^͉ZpCvCȊO̓G[Ƃ܂ */
    switch (pipeline) {
        case AG903_PGP_MGR_CALC_PIPELINE0:
        case AG903_PGP_MGR_CALC_PIPELINE1:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* }X^pCvCnh̋蓖ĉ\`FbN܂ */
    if (PgpMgrCheckForceAssignPipeline(pipeline) != 0) {
        return -AG903_EINVAL;
    }
    /* pCvCւ̓̓\[XVRAM͂̏ꍇ͊蓖ĂsȂ܂ */
    master_vram_handle = (AG903_PgpMgrVRAMInputHandle *)handle->master_handle->input_handle;
    if (master_vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
        master_vram_port_no = PgpMgrAssignVRAMInput(master_vram_handle);
        /* VRAM͂̊蓖ĂɎsꍇ̓G[Ƃ܂ */
        if (master_vram_port_no == -1) {
            return -AG903_EINVAL;
        }
    }

    if (handle->slave_pipeline == true) {
        uint32_t slave_pipeline = (pipeline == AG903_PGP_MGR_CALC_PIPELINE0) ? AG903_PGP_MGR_CALC_PIPELINE1 : AG903_PGP_MGR_CALC_PIPELINE0;
        AG903_PgpMgrPipelineHandle *slave = (AG903_PgpMgrPipelineHandle *)handle->slave_handle;
        /* X[upCvCnh̏ꍇA}X^Ƃ͕ʂ̉ZpCvCɊ蓖ĉ\`FbN܂ */
        if (PgpMgrCheckForceAssignPipeline(slave_pipeline) != 0) {
            return -AG903_EINVAL;
        }
        /* pCvCւ̓̓\[XVRAM͂̏ꍇ͊蓖ĂsȂ܂ */
        slave_vram_handle = (AG903_PgpMgrVRAMInputHandle *)slave->input_handle;
        if (slave_vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
            /* }X^AX[uVRAM̓nhLꍇA蓖ē̏̓XLbv܂ */
            if (master_vram_handle == slave_vram_handle) {
                slave_vram_port_no = master_vram_port_no;
            } else {
                slave_vram_port_no = PgpMgrAssignVRAMInput(slave_vram_handle);
                /* VRAM͂̊蓖ĂɎsꍇ̓G[Ƃ܂ */
                if (slave_vram_port_no == -1) {
                    return -AG903_EINVAL;
                }
                /* VRAM͑f[^\XV܂ */
               SET_VRAM_ASSIGN_INFO(slave_vram_handle, slave_vram_port_no);
            }
            /* VRAM͂̃|[gԍ͊蓖ĎɌ肷邽߁ApCvC̓̓|[g̒l̃^C~OōXV܂ */
            slave->input_port = slave_vram_port_no == 0 ? AG903_PGP_MGR_INPUT_PORT_VRAM_0 : AG903_PGP_MGR_INPUT_PORT_VRAM_1;
        }
        /* X[u蓖ĉ\ȏꍇ͊蓖ĐǗf[^\Ƀnhێ܂ */
        SET_PIPELINE_FORCE_ASSIGN_INFO(slave, slave_pipeline);
    } else {
        /* X[uVRAM͂̏ꍇA}X^̃pCvCԍVRAM̓|[g肵܂ */
        slave_vram_handle = (AG903_PgpMgrVRAMInputHandle *)handle->slave_handle;
        slave_vram_port_no = (pipeline == AG903_PGP_MGR_CALC_PIPELINE0) ? 2 : 3;
        SET_VRAM_ASSIGN_INFO(slave_vram_handle, slave_vram_port_no);
    }

    /* }X^蓖ĐǗf[^\Ƀnhێ܂ */
    SET_PIPELINE_FORCE_ASSIGN_INFO(handle->master_handle, pipeline);
    /* }X^͂VRAM͂̏ꍇ͂Ȃf[^\XV܂ */
    if (master_vram_handle->id == AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID) {
        SET_VRAM_ASSIGN_INFO(master_vram_handle, master_vram_port_no);
        /* VRAM͂̃|[gԍ͊蓖ĎɌ肷邽߁ApCvC̓̓|[g̒l̃^C~OōXV܂ */
        handle->master_handle->input_port = master_vram_port_no == 0 ? AG903_PGP_MGR_INPUT_PORT_VRAM_0 : AG903_PGP_MGR_INPUT_PORT_VRAM_1;
    }
    return pipeline;
}


/**
 * @brief   pCvCnhw肵pCvCɊ蓖ĉ\`FbN܂B
 * @param   handle [in] 蓖ă`FbNsȂpCvCnhw肵܂B
 * @param   pipeline [in] 蓖ĐpCvCԍ
 * @return  AG903_ENONE 蓖Đ
 * @return  -AG903_EINVAL 蓖Ďs̏ꍇ
 * @note    {֐̓[U[ڎgp邱Ƃ͂܂B
*/
int32_t PgpMgrCheckAssignPipelineHandle(AG903_PgpMgrPipelineHandle *handle, uint32_t pipeline)
{
    switch (pipeline) {
        case AG903_PGP_MGR_CALC_PIPELINE0:
            /* ZpCvC͑SĂ̋@\킹邽߁ATCŶ݃`FbN */
            if (handle->input_hsize > PIPELINE_SIZE_FULLHD) {
                return -AG903_EINVAL;
            }
            break;
        case AG903_PGP_MGR_CALC_PIPELINE1:
            /* ZpCvC͑SĂ̋@\킹邽߁ATCŶ݃`FbN */
            if (handle->input_hsize > PIPELINE_SIZE_VGA) {
                return -AG903_EINVAL;
            }
            break;
        case AG903_PGP_MGR_INPUT_PIPELINE0:
            /* TCYƁAZpCvC̋@\Lł邩`FbN */
            if ((handle->input_hsize > PIPELINE_SIZE_FULLHD) || (handle->thr_enable == true) || (handle->dgc_enable == true) ||
                (handle->hsv1_enable == true) || (handle->spf_enable == true) || (handle->hgm_enable == true) ||
                (handle->lbl_enable == true) || (handle->ifc_enable == true)) {
                return -AG903_EINVAL;
            }
            break;
        case AG903_PGP_MGR_INPUT_PIPELINE1:
            /* TCYƁAZpCvC̋@\Lł邩`FbN */
            if ((handle->input_hsize > PIPELINE_SIZE_VGA) || (handle->thr_enable == true) || (handle->dgc_enable == true) ||
                (handle->hsv1_enable == true) || (handle->spf_enable == true) || (handle->hgm_enable == true) ||
                (handle->lbl_enable == true) || (handle->ifc_enable == true)) {
                return -AG903_EINVAL;
            }
            break;
        case AG903_PGP_MGR_FRAME_PIPELINE0:
        case AG903_PGP_MGR_FRAME_PIPELINE1:
            /* ZpCvCA͉摜pCvC̋@\Lł邩`FbN */
            if ((handle->thr_enable == true) || (handle->dgc_enable == true) || (handle->hsv1_enable == true) ||
                (handle->spf_enable == true) || (handle->hgm_enable == true) || (handle->lbl_enable == true) ||
                (handle->ifc_enable == true) ||
                (handle->scale_enable == true) || (handle->csc1_enable == true) || (handle->nrf_enable == true) ||
                (handle->input_format == AG903_PGP_MGR_INPUT_FMT_YCBCR422_W_IP)) {
                return -AG903_EINVAL;
            }
            break;
    }
    return AG903_ENONE;
}
