/**
 * @brief           GPIO Manager Header
 * @author          AXELL CORPORATION
 * @description     GPIO Manager񋟃wb_B<p>GPIO ManagergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2021_01_29  [SDK3.2] GPIO|[g̔rLɂƂ̃AZu[`C (#2844)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2021 AXELL CORPORATION, all rights reserved.
 */

#ifndef _GPIOMGR_H_
#define _GPIOMGR_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** GPIO|[gr䂷ꍇ͖{}N"1"ɂB*/
#define AG903_GPIO_USE_LDREX	(0)

/** ch̃R[obNo^B<p>
	ݔɓo^̌sׁAݏԂɉe܂B<p>
	R[obN̓o^͕KvŒɂĉB*/
#define AG903_GPIO_CALLBACK_NUM	(4)

/** R[obN֐̌^B<p>
	portchPort`lԍi0`3jAstatus̓GbWoXe[^Xi0FoA1FojB*/
typedef void (*AG903_GPIOMgrClbk)(uint8_t portch, uint32_t status);

int32_t AG903_GPIOMgrInit(void);
int32_t AG903_GPIOMgrSetByteData(uint8_t blknum, uint8_t data);
int32_t AG903_GPIOMgrSetPortData(uint8_t portch, uint32_t data, uint32_t target);
int32_t AG903_GPIOMgrGetByteData(uint8_t blknum, uint8_t* data);
int32_t AG903_GPIOMgrGetPortData(uint8_t portch, uint32_t* data);
int32_t AG903_GPIOMgrSetDirection(uint8_t portch, uint32_t direction);
int32_t AG903_GPIOMgrGetDirection(uint8_t portch, uint32_t* direction);
int32_t AG903_GPIOMgrSetType(uint8_t portch, uint32_t type);
int32_t AG903_GPIOMgrGetType(uint8_t portch, uint32_t* type);
int32_t AG903_GPIOMgrSetPositiveDetect(uint8_t portch, uint32_t enable);
int32_t AG903_GPIOMgrGetPositiveDetect(uint8_t portch, uint32_t* enable);
int32_t AG903_GPIOMgrSetNegativeDetect(uint8_t portch, uint32_t enable);
int32_t AG903_GPIOMgrGetNegativeDetect(uint8_t portch, uint32_t* enable);
int32_t AG903_GPIOMgrSetMask(uint8_t portch, uint32_t mask);
int32_t AG903_GPIOMgrGetMask(uint8_t portch, uint32_t* mask);
int32_t AG903_GPIOMgrGetEdgeDetect(uint8_t portch, uint32_t* status);
int32_t AG903_GPIOMgrClearEdgeDetect(uint8_t portch, uint32_t clrbit);
int32_t AG903_GPIOMgrSetCallback(uint8_t portch, uint32_t target, AG903_GPIOMgrClbk clbk);
int32_t AG903_GPIOMgrClearCallback(uint8_t portch, uint32_t target, AG903_GPIOMgrClbk clbk);

#ifdef __cplusplus
}
#endif
#endif /* _GPIOMGR_H_ */
