/**
 * @brief           BMU Manager Header
 * @author          AXELL CORPORATION
 * @description     BMU Manager Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _BMUMGR_H_
#define _BMUMGR_H_
/* DOM-IGNORE-END */


#ifdef __cplusplus
extern "C" {
#endif

#ifndef AG903_BMU_UNIT_NUM
	/** BMU̍ő`l */
	#define AG903_BMU_UNIT_NUM (16)
#endif


/* BMU SRC W[ID */

/** PGPZpCvC0 */
#define AG903_BMU_SRC_PGP0			(0)
/** PGPZpCvC1 */
#define AG903_BMU_SRC_PGP1			(1)
/** PGP͉摜pCvC0 */
#define AG903_BMU_SRC_PGP2			(2)
/** PGP͉摜pCvC1 */
#define AG903_BMU_SRC_PGP3			(3)
/** PGPt[ۑpCvC0 */
#define AG903_BMU_SRC_PGP4			(4)
/** PGPt[ۑpCvC1 */
#define AG903_BMU_SRC_PGP5			(5)
/** gps */
#define AG903_BMU_SRC_PGP6			(6)
/** gps */
#define AG903_BMU_SRC_PGP7			(7)
/** PGPqXgOpCvC0 */
#define AG903_BMU_SRC_PGP8			(8)
/** PGPqXgOpCvC1 */
#define AG903_BMU_SRC_PGP9			(9)
/** PGPxOpCvC0 */
#define AG903_BMU_SRC_PGP10			(10)
/** PGPxOpCvC1 */
#define AG903_BMU_SRC_PGP11			(11)
/** `H0 */
#define AG903_BMU_SRC_GFX0			(12)
/** `H1 */
#define AG903_BMU_SRC_GFX1			(13)
/** `H2 */
#define AG903_BMU_SRC_GFX2			(14)
/** `H3 */
#define AG903_BMU_SRC_GFX3			(15)
/** GVDfR[h0 */
#define AG903_BMU_SRC_GVD0			(16)
/** GVDfR[h1 */
#define AG903_BMU_SRC_GVD1			(17)
/** GVDfR[h2 */
#define AG903_BMU_SRC_GVD2			(18)
/** GVDfR[h3 */
#define AG903_BMU_SRC_GVD3			(19)
/** VXe0 */
#define AG903_BMU_SRC_SYS0			(20)
/** VXe1 */
#define AG903_BMU_SRC_SYS1			(21)
/** VXe2 */
#define AG903_BMU_SRC_SYS2			(22)
/** VXe3 */
#define AG903_BMU_SRC_SYS3			(23)
/** VXe4 */
#define AG903_BMU_SRC_SYS4			(24)
/** VXe5 */
#define AG903_BMU_SRC_SYS5			(25)
/** VXe6 */
#define AG903_BMU_SRC_SYS6			(26)
/** VXe7 */
#define AG903_BMU_SRC_SYS7			(27)
/** VXe8 */
#define AG903_BMU_SRC_SYS8			(28)
/** VXe9 */
#define AG903_BMU_SRC_SYS9			(29)
/** VXe10 */
#define AG903_BMU_SRC_SYS10			(30)
/** JPGÎ~R[fbNifR[hj */
#define AG903_BMU_SRC_JPG0			(31)

/* SINK W[ID */

/** PGPLv`0 */
#define AG903_BMU_SINK_PGP0			(0)
/** PGPLv`1 */
#define AG903_BMU_SINK_PGP1			(1)
/** PGPLv`2 */
#define AG903_BMU_SINK_PGP2			(2)
/** PGPLv`3 */
#define AG903_BMU_SINK_PGP3			(3)
/** `0 */
#define AG903_BMU_SINK_GFX0			(4)
/** `1 */
#define AG903_BMU_SINK_GFX1			(5)
/** `2 */
#define AG903_BMU_SINK_GFX2			(6)
/** `3 */
#define AG903_BMU_SINK_GFX3			(7)
/** VXe0 */
#define AG903_BMU_SINK_SYS0			(8)
/** VXe1 */
#define AG903_BMU_SINK_SYS1			(9)
/** VXe2 */
#define AG903_BMU_SINK_SYS2			(10)
/** VXe3 */
#define AG903_BMU_SINK_SYS3			(11)
/** \H0 */
#define AG903_BMU_SINK_DSP0			(12)
/** \H1 */
#define AG903_BMU_SINK_DSP1			(13)
/** JPGÎ~R[fbNiGR[hj */
#define AG903_BMU_SINK_JPG0			(14)

/* SINK W[ WAIT */

/** SINKW[wait Enable */
#define AG903_BMU_SINK_WAIT_ENABLE	(0)
/** SINKW[wait Disable */
#define AG903_BMU_SINK_WAIT_DISABLE	(1)

/* [h */

/** obt@Ǘ[h0  */
#define AG903_BMU_BUF_MGR_MODE0		(0)
/** obt@Ǘ[h1  */
#define AG903_BMU_BUF_MGR_MODE1		(1)
/** obt@Ǘ[h2 񓯊 */
#define AG903_BMU_BUF_MGR_MODE2		(2)
/** obt@Ǘ[h3 񓯊 */
#define AG903_BMU_BUF_MGR_MODE3		(3)

/** BMUXe[^X */
typedef struct _AG903_BMUMgrStatus
{
	uint8_t is_valid;                  /** obt@ݏ  */
	uint8_t is_empty;                  /** obt@󂫏 */
	uint8_t is_read_wait_appeared;     /** VNW[EFCg i[hj */
	uint8_t is_read_busy;              /** VNW[ */
	uint8_t read_module_num;           /** VNW[̎gpobt@ԍ */

	uint8_t is_full;                   /** obt@̋󂫏 */
	uint8_t is_write_wait_appeared;    /** \[XW[EFCg */
	uint8_t is_write_busy;             /** \[XW[ */
	uint8_t write_module_num;          /** \[XW[̎gpobt@ԍ */
} AG903_BMUMgrStatus;

/** BMUnh */
typedef struct _AG903_BMUMgrHandle
{
	uint8_t unit_id;    /** 蓖Ăꂽ`l */
	uint8_t is_exec;    /** s */
	uint32_t src_id;    /** \[XW[ID */
} AG903_BMUMgrHandle;

int32_t AG903_BMUMgrGetHandle(AG903_BMUMgrHandle **handle);
int32_t AG903_BMUMgrReleaseHandle(AG903_BMUMgrHandle *handle);
int32_t AG903_BMUMgrEnable(AG903_BMUMgrHandle *handle);
int32_t AG903_BMUMgrDisable(AG903_BMUMgrHandle *handle);
int32_t AG903_BMUMgrSetMode(AG903_BMUMgrHandle *handle, uint8_t ini, uint8_t mgr);
int32_t AG903_BMUMgrSetSrcModule(AG903_BMUMgrHandle *handle, uint8_t src);
int32_t AG903_BMUMgrAddSinkModule(AG903_BMUMgrHandle *handle, uint8_t sink);
int32_t AG903_BMUMgrRemoveSinkModule(AG903_BMUMgrHandle *handle, uint8_t sink);
int32_t AG903_BMUMgrGetSinkStatus(AG903_BMUMgrHandle *handle, uint8_t sink, uint8_t *status);
int32_t AG903_BMUMgrSetBufferConfig(AG903_BMUMgrHandle *handle, void *buffer, uint32_t stride, uint32_t buf_num);
int32_t AG903_BMUMgrGetStatus(AG903_BMUMgrHandle *handle, AG903_BMUMgrStatus *status);
int32_t AG903_BMUMgrGetBMUSinkAddress(AG903_BMUMgrHandle *handle, uint32_t *addr);
int32_t AG903_BMUMgrGetBMUSrcAddress(AG903_BMUMgrHandle *handle, uint32_t *addr);
int32_t AG903_BMUMgrGetBMUId(AG903_BMUMgrHandle *handle, uint8_t *id);

#ifdef __cplusplus
}
#endif
#endif
