/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

/* `f[^() */
static VGubyte cmd1[] = {
    VG_MOVE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS, VG_CLOSE_PATH
};
static VGbyte coord1[] = {
    50, 50,
    50, 100,
    100,100,
    100, 50,
};

/* `f[^(񎟃xWFȐ) */
static VGubyte cmd2[] = {
    VG_MOVE_TO_ABS, VG_QUAD_TO_ABS, VG_QUAD_TO_ABS, VG_QUAD_TO_ABS
};
static VGshort coord2[] = {
    200, 50,
    250, 88, 250, 150,
    250, 88, 300, 50,
    250, 88, 200, 50, 
};

/* `f[^(OxWFȐ) */
static VGubyte cmd3[] = {
    VG_MOVE_TO_ABS, VG_CUBIC_TO_ABS, VG_CUBIC_TO_ABS
};
static VGint coord3[] = {
    50, 250,
    50, 350, 150, 150, 150, 250, 
    150, 350, 50, 150, 50, 250,
};

/* `f[^(~) */
static VGubyte cmd4[] = {
    VG_MOVE_TO_ABS, VG_LCCWARC_TO_ABS, VG_LCCWARC_TO_ABS
};
static VGfloat coord4[] = {
    250.0F, 200.0F,
    50.0F, 50.0F, 0.0F, 250.0F, 300.0F,
    50.0F, 50.0F, 0.0F, 250.0F, 200.0F
};

/* IuWFNg */
static VGPath path1, path2, path3, path4;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGPathIuWFNg̐(8bit) */
    path1 = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_S_8,
                        1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);
    /* VGPathIuWFNg̐(16bit) */
    path2 = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_S_16,
                        1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);
    /* VGPathIuWFNg̐(32bit) */
    path3 = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_S_32,
                        1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);
    /* VGPathIuWFNg̐(_) */
    path4 = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_F,
                        1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);

    /* VGPathIuWFNgɌ`f[^o^ */
    vgAppendPathData(path1, sizeof(cmd1), cmd1, coord1);
    vgAppendPathData(path2, sizeof(cmd2), cmd2, coord2);
    vgAppendPathData(path3, sizeof(cmd3), cmd3, coord3);
    vgAppendPathData(path4, sizeof(cmd4), cmd4, coord4);

    /* ݂̃}gNXPATH_USER_TO_SURFACEɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_PATH_USER_TO_SURFACE);

    /* s񏉊 */
    vgLoadIdentity();
}

static void TestDraw(void)
{
    /* VGPath`ihԂj */
    vgDrawPath(path1, VG_FILL_PATH);
    vgDrawPath(path2, VG_FILL_PATH);
    vgDrawPath(path3, VG_FILL_PATH);
    vgDrawPath(path4, VG_FILL_PATH);
}

static void TestTerm(void)
{
    /* VGPathIuWFNgj */
    vgDestroyPath(path1);
    vgDestroyPath(path2);
    vgDestroyPath(path3);
    vgDestroyPath(path4);
}

void PathMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* `揈 */
    TestDraw();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
