/** 
 * @brief           UDI extern Header
 * @author          AXELL CORPORATION
 * @description     UDI(Uniform Driver Interface)W̔
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/

/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */




#ifndef __UDI_EXTERN_H__
#define __UDI_EXTERN_H__
/* DOM-IGNORE-END */

// *************************************************************************************************
//	define
// *************************************************************************************************
typedef signed char                     udi_sbit8_t;        /* t8bit^ */
typedef signed short                    udi_sbit16_t;       /* t16bit^ */
typedef signed long                     udi_sbit32_t;       /* t32bit^ */
typedef unsigned char                   udi_ubit8_t;        /* 8bit^ */
typedef unsigned short                  udi_ubit16_t;       /* 16bit^ */
typedef unsigned long                   udi_ubit32_t;       /* 32bit^ */

typedef udi_ubit8_t                     udi_boolean_t;      /* u[㐔 0==False, 0!=True */

typedef udi_sbit32_t                    udi_status_t;       /* ֐߂l^ */

/* Mask Values and Flags for udi_status_t */
#define UDI_STATUS_CODE_MASK            (0x0000FFFF)
#define UDI_STAT_META_SPECIFIC          (0x00008000)
#define UDI_SPECIFIC_STATUS_MASK        (0x00007FFF)
#define UDI_CORRELATE_OFFSET            (16)
#define UDI_CORRELATE_MASK              (0xFFFF0000)

/* Common Status Values */
/** I */
#define UDI_OK                          (0)
/** T|[gĂȂ */
#define UDI_STAT_NOT_SUPPORTED          (-1)
/** ߕs\ */
#define UDI_STAT_NOT_UNDERSTOOD         (-2)
/** sȏ */
#define UDI_STAT_INVALID_STATE          (-3)
/** FɎs */
#define UDI_STAT_MISTAKEN_IDENTITY      (-4)
/** f */
#define UDI_STAT_ABORTED                (-5)
/** ^CAEg */
#define UDI_STAT_TIMEOUT                (-6)
/** rW[ */
#define UDI_STAT_BUSY                   (-7)
/** \[Xs */
#define UDI_STAT_RESOURCE_UNAVAIL       (-8)
/** HWG[ */
#define UDI_STAT_HW_PROBLEM             (-9)
/** Ȃ */
#define UDI_STAT_NOT_RESPONDING         (-10)

//	|	#define UDI_STAT_DATA_UNDERRUN          (-11)

/** f[^I[o[ */
#define UDI_STAT_DATA_OVERRUN           (-12)
/** f[^G[ */
#define UDI_STAT_DATA_ERROR             (-13)

//	|	#define UDI_STAT_PARENT_DRV_ERROR       (-14)
//	|	#define UDI_STAT_CANNOT_BIND            (-15)
//	|	#define UDI_STAT_CANNOT_BIND_EXCL       (-16)

/** ڑfoCX */
#define UDI_STAT_TOO_MANY_PARENTS       (-17)

//	|	#define UDI_STAT_BAD_PARENT_TYPE        (-18)

/** ς */
#define UDI_STAT_TERMINATED             (-19)
/** sv */
#define UDI_STAT_ATTR_MISMATCH          (-20)

typedef unsigned int                    udi_size_t;         /* TCYw */
typedef unsigned char                   udi_index_t;        /* CfbNXw */

#endif /* __UDI_EXTERN_H__ */

