/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#ifndef FFSYSDRV_CFG_H
#define FFSYSDRV_CFG_H


/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
/* Global configuration */
#define CFG_DRV_DSK_CNT				(2)			/* Number of disks */
#define CFG_DRV_DSK_ID_ENA       	(1)     	/* Disk device ID enable */

/* Device ID */
#define FFS_DEVID_SD				(0)
#define FFS_DEVID_CF				(1)
#define FFS_DEVID_USB				(2)

/* Low-driver 0 [SD] */
#include "DDR_AG903_SD.h"
#define CFG_DRV_LOW0_DEV_ID     	(0)      	/* Device ID */
#define CFG_DRV_LOW0_TMO        	(4000)   	/* Timeout (msec) */
#define ffs_drv_low0_ini        	sd_ena
#define ffs_drv_low0_ext        	sd_dis
#define ffs_drv_low0_mnt        	sd_mnt
#define ffs_drv_low0_umt        	sd_umt
#define ffs_drv_low0_read       	sd_read
#define ffs_drv_low0_write      	sd_write

/* Low-driver 1 [CF] */
#if (CFG_DRV_DSK_CNT > 1)
#include "DDR_AG903_CF.h"
#define CFG_DRV_LOW1_DEV_ID     	(0)      	/* Device ID */
#define CFG_DRV_LOW1_TMO        	(4000)   	/* Timeout (msec) */
#define ffs_drv_low1_ini        	cf_ena
#define ffs_drv_low1_ext        	cf_dis
#define ffs_drv_low1_mnt        	cf_mnt
#define ffs_drv_low1_umt        	cf_umt
#define ffs_drv_low1_read       	cf_read
#define ffs_drv_low1_write      	cf_write
#endif

#endif
