/** 
 * @brief           USBH MSC Scsierror Header
 * @author          AXELL CORPORATION
 * @description     USBH MSC Scsierror Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_MSC_SCSIERROR_H__
#define __USB_MSC_SCSIERROR_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "uhs_configtop.h"

#include "usb_msc_log.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define SCSI_REPORT_SUMMARY(err) Usbh_Stor_Log_ReportError( g_filename, __LINE__, (uhs_ubit16_t)(err), (uhs_ubit8_t*)"1", 0 )
#define SCSI_REPORT_ERROR_CMD(err, cmd, len) Usbh_Stor_Log_ReportError( g_filename, __LINE__, (uhs_ubit16_t)(err), (cmd), (len) )
#define SCSI_REPORT_DETAIL(err, mesg, len) Usbh_Stor_Log_ReportError( g_filename, __LINE__, (uhs_ubit16_t)(err), (mesg), (len) )
#else
#define SCSI_REPORT_SUMMARY(err) Usbh_Stor_Log_ReportDummy(err)
#define SCSI_REPORT_ERROR_CMD(err, cmd, len) Usbh_Stor_Log_ReportDummy(err)
#define SCSI_REPORT_DETAIL(err, mesg, len) Usbh_Stor_Log_ReportDummy(err)
#endif

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_MSC_SCSIERROR_H__ */
