/**
 * @brief           BMU Register Definition
 * @author          AXELL CORPORATION
 * @description     BMU Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_BMU_REGMAP_H_
#define _AG903_BMU_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** BMUn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CTRL;

        struct {
            __IO uint32_t  EN                             :  1;
        } CTRL_bits;
    };

    union {
        __IO uint32_t  MOD;

        struct {
            __IO uint32_t  SRC                            :  5;
                 uint32_t                                 : 11;
            __IO uint32_t  MGR                            :  2;
            __IO uint32_t  INI                            :  1;
        } MOD_bits;
    };

    union {
        __IO uint32_t  SINKMODULE;

        struct {
            __IO uint32_t  SINK0                          :  1;
            __IO uint32_t  SINK1                          :  1;
            __IO uint32_t  SINK2                          :  1;
            __IO uint32_t  SINK3                          :  1;
            __IO uint32_t  SINK4                          :  1;
            __IO uint32_t  SINK5                          :  1;
            __IO uint32_t  SINK6                          :  1;
            __IO uint32_t  SINK7                          :  1;
            __IO uint32_t  SINK8                          :  1;
            __IO uint32_t  SINK9                          :  1;
            __IO uint32_t  SINK10                         :  1;
            __IO uint32_t  SINK11                         :  1;
            __IO uint32_t  SINK12                         :  1;
            __IO uint32_t  SINK13                         :  1;
            __IO uint32_t  SINK14                         :  1;
            __IO uint32_t  SINK15                         :  1;
        } SINKMODULE_bits;
    };

    union {
        __I  uint32_t  SINKSTAT;

        struct {
            __I  uint32_t  SINK0                          :  1;
            __I  uint32_t  SINK1                          :  1;
            __I  uint32_t  SINK2                          :  1;
            __I  uint32_t  SINK3                          :  1;
            __I  uint32_t  SINK4                          :  1;
            __I  uint32_t  SINK5                          :  1;
            __I  uint32_t  SINK6                          :  1;
            __I  uint32_t  SINK7                          :  1;
            __I  uint32_t  SINK8                          :  1;
            __I  uint32_t  SINK9                          :  1;
            __I  uint32_t  SINK10                         :  1;
            __I  uint32_t  SINK11                         :  1;
            __I  uint32_t  SINK12                         :  1;
            __I  uint32_t  SINK13                         :  1;
            __I  uint32_t  SINK14                         :  1;
            __I  uint32_t  SINK15                         :  1;
        } SINKSTAT_bits;
    };

    union {
        __IO uint32_t  BASEADR;

        struct {
                 uint32_t                                 :  7;
            __IO uint32_t  ADR                            : 22;
        } BASEADR_bits;
    };

    union {
        __IO uint32_t  STRIDE;

        struct {
                 uint32_t                                 :  7;
            __IO uint32_t  STRIDE                         : 18;
        } STRIDE_bits;
    };

    union {
        __IO uint32_t  BUFNUM;

        struct {
            __IO uint32_t  NUM                            :  3;
        } BUFNUM_bits;
    };

    union {
        __I  uint32_t  STAT;

        struct {
            __I  uint32_t  WNUM                           :  3;
                 uint32_t                                 :  5;
            __I  uint32_t  WBSY                           :  1;
            __I  uint32_t  WWA                            :  1;
            __I  uint32_t  FULL                           :  1;
                 uint32_t                                 :  5;
            __I  uint32_t  RNUM                           :  3;
                 uint32_t                                 :  5;
            __I  uint32_t  RBSY                           :  1;
            __I  uint32_t  RWA                            :  1;
            __I  uint32_t  EMPTY                          :  1;
            __I  uint32_t  VAL                            :  1;
        } STAT_bits;
    };

/* DOM-IGNORE-END */
}AG903_BMUn_Type;

#define AG903_BMUn(ch)                           ((volatile AG903_BMUn_Type *)(AG903_BMU0_BASE + 0x40 * ch))             /** BMUn Base Address (n=0..15) */
#define AG903_BMUn_CTRL(ch)                      AG903_BMUn(ch)->CTRL                                                    /** BMUnCTRL Address (n=0..15) */
#define AG903_BMUn_MOD(ch)                       AG903_BMUn(ch)->MOD                                                     /** BMUnMOD Address (n=0..15) */
#define AG903_BMUn_SINKMODULE(ch)                AG903_BMUn(ch)->SINKMODULE                                              /** BMUnSINKMODULE Address (n=0..15) */
#define AG903_BMUn_SINKSTAT(ch)                  AG903_BMUn(ch)->SINKSTAT                                                /** BMUnSINKSTAT Address (n=0..15) */
#define AG903_BMUn_BASEADR(ch)                   AG903_BMUn(ch)->BASEADR                                                 /** BMUnBASEADR Address (n=0..15) */
#define AG903_BMUn_STRIDE(ch)                    AG903_BMUn(ch)->STRIDE                                                  /** BMUnSTRIDE Address (n=0..15) */
#define AG903_BMUn_BUFNUM(ch)                    AG903_BMUn(ch)->BUFNUM                                                  /** BMUnBUFNUM Address (n=0..15) */
#define AG903_BMUn_STAT(ch)                      AG903_BMUn(ch)->STAT                                                    /** BMUnSTAT Address (n=0..15) */

#define AG903_BMU0                               ((volatile AG903_BMUn_Type *) AG903_BMU0_BASE)                          /** BMUn Base Address */
#define AG903_BMU1                               ((volatile AG903_BMUn_Type *) AG903_BMU1_BASE)                          /** BMUn Base Address */
#define AG903_BMU2                               ((volatile AG903_BMUn_Type *) AG903_BMU2_BASE)                          /** BMUn Base Address */
#define AG903_BMU3                               ((volatile AG903_BMUn_Type *) AG903_BMU3_BASE)                          /** BMUn Base Address */
#define AG903_BMU4                               ((volatile AG903_BMUn_Type *) AG903_BMU4_BASE)                          /** BMUn Base Address */
#define AG903_BMU5                               ((volatile AG903_BMUn_Type *) AG903_BMU5_BASE)                          /** BMUn Base Address */
#define AG903_BMU6                               ((volatile AG903_BMUn_Type *) AG903_BMU6_BASE)                          /** BMUn Base Address */
#define AG903_BMU7                               ((volatile AG903_BMUn_Type *) AG903_BMU7_BASE)                          /** BMUn Base Address */
#define AG903_BMU8                               ((volatile AG903_BMUn_Type *) AG903_BMU8_BASE)                          /** BMUn Base Address */
#define AG903_BMU9                               ((volatile AG903_BMUn_Type *) AG903_BMU9_BASE)                          /** BMUn Base Address */
#define AG903_BMU10                              ((volatile AG903_BMUn_Type *) AG903_BMU10_BASE)                         /** BMUn Base Address */
#define AG903_BMU11                              ((volatile AG903_BMUn_Type *) AG903_BMU11_BASE)                         /** BMUn Base Address */
#define AG903_BMU12                              ((volatile AG903_BMUn_Type *) AG903_BMU12_BASE)                         /** BMUn Base Address */
#define AG903_BMU13                              ((volatile AG903_BMUn_Type *) AG903_BMU13_BASE)                         /** BMUn Base Address */
#define AG903_BMU14                              ((volatile AG903_BMUn_Type *) AG903_BMU14_BASE)                         /** BMUn Base Address */
#define AG903_BMU15                              ((volatile AG903_BMUn_Type *) AG903_BMU15_BASE)                         /** BMUn Base Address */


#define AG903_BMUn_CTRL_EN_POS                             0                                                             /** BMUnCTRL EN-bit position */
#define AG903_BMUn_CTRL_EN_MSK                             (0x1UL << AG903_BMUn_CTRL_EN_POS)                             /** BMUnCTRL EN-bit mask */

#define AG903_BMUn_MOD_SRC_POS                             0                                                             /** BMUnMOD SRC-bit position */
#define AG903_BMUn_MOD_SRC_MSK                             (0x1fUL << AG903_BMUn_MOD_SRC_POS)                            /** BMUnMOD SRC-bit mask */
#define AG903_BMUn_MOD_MGR_POS                             16                                                            /** BMUnMOD MGR-bit position */
#define AG903_BMUn_MOD_MGR_MSK                             (0x3UL << AG903_BMUn_MOD_MGR_POS)                             /** BMUnMOD MGR-bit mask */
#define AG903_BMUn_MOD_INI_POS                             18                                                            /** BMUnMOD INI-bit position */
#define AG903_BMUn_MOD_INI_MSK                             (0x1UL << AG903_BMUn_MOD_INI_POS)                             /** BMUnMOD INI-bit mask */

#define AG903_BMUn_SINKMODULE_SINK0_POS                    0                                                             /** BMUnSINKMODULE SINK0-bit position */
#define AG903_BMUn_SINKMODULE_SINK0_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK0_POS)                    /** BMUnSINKMODULE SINK0-bit mask */
#define AG903_BMUn_SINKMODULE_SINK1_POS                    1                                                             /** BMUnSINKMODULE SINK1-bit position */
#define AG903_BMUn_SINKMODULE_SINK1_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK1_POS)                    /** BMUnSINKMODULE SINK1-bit mask */
#define AG903_BMUn_SINKMODULE_SINK2_POS                    2                                                             /** BMUnSINKMODULE SINK2-bit position */
#define AG903_BMUn_SINKMODULE_SINK2_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK2_POS)                    /** BMUnSINKMODULE SINK2-bit mask */
#define AG903_BMUn_SINKMODULE_SINK3_POS                    3                                                             /** BMUnSINKMODULE SINK3-bit position */
#define AG903_BMUn_SINKMODULE_SINK3_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK3_POS)                    /** BMUnSINKMODULE SINK3-bit mask */
#define AG903_BMUn_SINKMODULE_SINK4_POS                    4                                                             /** BMUnSINKMODULE SINK4-bit position */
#define AG903_BMUn_SINKMODULE_SINK4_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK4_POS)                    /** BMUnSINKMODULE SINK4-bit mask */
#define AG903_BMUn_SINKMODULE_SINK5_POS                    5                                                             /** BMUnSINKMODULE SINK5-bit position */
#define AG903_BMUn_SINKMODULE_SINK5_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK5_POS)                    /** BMUnSINKMODULE SINK5-bit mask */
#define AG903_BMUn_SINKMODULE_SINK6_POS                    6                                                             /** BMUnSINKMODULE SINK6-bit position */
#define AG903_BMUn_SINKMODULE_SINK6_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK6_POS)                    /** BMUnSINKMODULE SINK6-bit mask */
#define AG903_BMUn_SINKMODULE_SINK7_POS                    7                                                             /** BMUnSINKMODULE SINK7-bit position */
#define AG903_BMUn_SINKMODULE_SINK7_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK7_POS)                    /** BMUnSINKMODULE SINK7-bit mask */
#define AG903_BMUn_SINKMODULE_SINK8_POS                    8                                                             /** BMUnSINKMODULE SINK8-bit position */
#define AG903_BMUn_SINKMODULE_SINK8_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK8_POS)                    /** BMUnSINKMODULE SINK8-bit mask */
#define AG903_BMUn_SINKMODULE_SINK9_POS                    9                                                             /** BMUnSINKMODULE SINK9-bit position */
#define AG903_BMUn_SINKMODULE_SINK9_MSK                    (0x1UL << AG903_BMUn_SINKMODULE_SINK9_POS)                    /** BMUnSINKMODULE SINK9-bit mask */
#define AG903_BMUn_SINKMODULE_SINK10_POS                   10                                                            /** BMUnSINKMODULE SINK10-bit position */
#define AG903_BMUn_SINKMODULE_SINK10_MSK                   (0x1UL << AG903_BMUn_SINKMODULE_SINK10_POS)                   /** BMUnSINKMODULE SINK10-bit mask */
#define AG903_BMUn_SINKMODULE_SINK11_POS                   11                                                            /** BMUnSINKMODULE SINK11-bit position */
#define AG903_BMUn_SINKMODULE_SINK11_MSK                   (0x1UL << AG903_BMUn_SINKMODULE_SINK11_POS)                   /** BMUnSINKMODULE SINK11-bit mask */
#define AG903_BMUn_SINKMODULE_SINK12_POS                   12                                                            /** BMUnSINKMODULE SINK12-bit position */
#define AG903_BMUn_SINKMODULE_SINK12_MSK                   (0x1UL << AG903_BMUn_SINKMODULE_SINK12_POS)                   /** BMUnSINKMODULE SINK12-bit mask */
#define AG903_BMUn_SINKMODULE_SINK13_POS                   13                                                            /** BMUnSINKMODULE SINK13-bit position */
#define AG903_BMUn_SINKMODULE_SINK13_MSK                   (0x1UL << AG903_BMUn_SINKMODULE_SINK13_POS)                   /** BMUnSINKMODULE SINK13-bit mask */
#define AG903_BMUn_SINKMODULE_SINK14_POS                   14                                                            /** BMUnSINKMODULE SINK14-bit position */
#define AG903_BMUn_SINKMODULE_SINK14_MSK                   (0x1UL << AG903_BMUn_SINKMODULE_SINK14_POS)                   /** BMUnSINKMODULE SINK14-bit mask */
#define AG903_BMUn_SINKMODULE_SINK15_POS                   15                                                            /** BMUnSINKMODULE SINK15-bit position */
#define AG903_BMUn_SINKMODULE_SINK15_MSK                   (0x1UL << AG903_BMUn_SINKMODULE_SINK15_POS)                   /** BMUnSINKMODULE SINK15-bit mask */

#define AG903_BMUn_SINKSTAT_SINK0_POS                      0                                                             /** BMUnSINKSTAT SINK0-bit position */
#define AG903_BMUn_SINKSTAT_SINK0_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK0_POS)                      /** BMUnSINKSTAT SINK0-bit mask */
#define AG903_BMUn_SINKSTAT_SINK1_POS                      1                                                             /** BMUnSINKSTAT SINK1-bit position */
#define AG903_BMUn_SINKSTAT_SINK1_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK1_POS)                      /** BMUnSINKSTAT SINK1-bit mask */
#define AG903_BMUn_SINKSTAT_SINK2_POS                      2                                                             /** BMUnSINKSTAT SINK2-bit position */
#define AG903_BMUn_SINKSTAT_SINK2_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK2_POS)                      /** BMUnSINKSTAT SINK2-bit mask */
#define AG903_BMUn_SINKSTAT_SINK3_POS                      3                                                             /** BMUnSINKSTAT SINK3-bit position */
#define AG903_BMUn_SINKSTAT_SINK3_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK3_POS)                      /** BMUnSINKSTAT SINK3-bit mask */
#define AG903_BMUn_SINKSTAT_SINK4_POS                      4                                                             /** BMUnSINKSTAT SINK4-bit position */
#define AG903_BMUn_SINKSTAT_SINK4_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK4_POS)                      /** BMUnSINKSTAT SINK4-bit mask */
#define AG903_BMUn_SINKSTAT_SINK5_POS                      5                                                             /** BMUnSINKSTAT SINK5-bit position */
#define AG903_BMUn_SINKSTAT_SINK5_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK5_POS)                      /** BMUnSINKSTAT SINK5-bit mask */
#define AG903_BMUn_SINKSTAT_SINK6_POS                      6                                                             /** BMUnSINKSTAT SINK6-bit position */
#define AG903_BMUn_SINKSTAT_SINK6_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK6_POS)                      /** BMUnSINKSTAT SINK6-bit mask */
#define AG903_BMUn_SINKSTAT_SINK7_POS                      7                                                             /** BMUnSINKSTAT SINK7-bit position */
#define AG903_BMUn_SINKSTAT_SINK7_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK7_POS)                      /** BMUnSINKSTAT SINK7-bit mask */
#define AG903_BMUn_SINKSTAT_SINK8_POS                      8                                                             /** BMUnSINKSTAT SINK8-bit position */
#define AG903_BMUn_SINKSTAT_SINK8_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK8_POS)                      /** BMUnSINKSTAT SINK8-bit mask */
#define AG903_BMUn_SINKSTAT_SINK9_POS                      9                                                             /** BMUnSINKSTAT SINK9-bit position */
#define AG903_BMUn_SINKSTAT_SINK9_MSK                      (0x1UL << AG903_BMUn_SINKSTAT_SINK9_POS)                      /** BMUnSINKSTAT SINK9-bit mask */
#define AG903_BMUn_SINKSTAT_SINK10_POS                     10                                                            /** BMUnSINKSTAT SINK10-bit position */
#define AG903_BMUn_SINKSTAT_SINK10_MSK                     (0x1UL << AG903_BMUn_SINKSTAT_SINK10_POS)                     /** BMUnSINKSTAT SINK10-bit mask */
#define AG903_BMUn_SINKSTAT_SINK11_POS                     11                                                            /** BMUnSINKSTAT SINK11-bit position */
#define AG903_BMUn_SINKSTAT_SINK11_MSK                     (0x1UL << AG903_BMUn_SINKSTAT_SINK11_POS)                     /** BMUnSINKSTAT SINK11-bit mask */
#define AG903_BMUn_SINKSTAT_SINK12_POS                     12                                                            /** BMUnSINKSTAT SINK12-bit position */
#define AG903_BMUn_SINKSTAT_SINK12_MSK                     (0x1UL << AG903_BMUn_SINKSTAT_SINK12_POS)                     /** BMUnSINKSTAT SINK12-bit mask */
#define AG903_BMUn_SINKSTAT_SINK13_POS                     13                                                            /** BMUnSINKSTAT SINK13-bit position */
#define AG903_BMUn_SINKSTAT_SINK13_MSK                     (0x1UL << AG903_BMUn_SINKSTAT_SINK13_POS)                     /** BMUnSINKSTAT SINK13-bit mask */
#define AG903_BMUn_SINKSTAT_SINK14_POS                     14                                                            /** BMUnSINKSTAT SINK14-bit position */
#define AG903_BMUn_SINKSTAT_SINK14_MSK                     (0x1UL << AG903_BMUn_SINKSTAT_SINK14_POS)                     /** BMUnSINKSTAT SINK14-bit mask */
#define AG903_BMUn_SINKSTAT_SINK15_POS                     15                                                            /** BMUnSINKSTAT SINK15-bit position */
#define AG903_BMUn_SINKSTAT_SINK15_MSK                     (0x1UL << AG903_BMUn_SINKSTAT_SINK15_POS)                     /** BMUnSINKSTAT SINK15-bit mask */

#define AG903_BMUn_BASEADR_ADR_POS                         7                                                             /** BMUnBASEADR ADR-bit position */
#define AG903_BMUn_BASEADR_ADR_MSK                         (0x3fffffUL << AG903_BMUn_BASEADR_ADR_POS)                    /** BMUnBASEADR ADR-bit mask */

#define AG903_BMUn_STRIDE_STRIDE_POS                       7                                                             /** BMUnSTRIDE STRIDE-bit position */
#define AG903_BMUn_STRIDE_STRIDE_MSK                       (0x3ffffUL << AG903_BMUn_STRIDE_STRIDE_POS)                   /** BMUnSTRIDE STRIDE-bit mask */

#define AG903_BMUn_BUFNUM_NUM_POS                          0                                                             /** BMUnBUFNUM NUM-bit position */
#define AG903_BMUn_BUFNUM_NUM_MSK                          (0x7UL << AG903_BMUn_BUFNUM_NUM_POS)                          /** BMUnBUFNUM NUM-bit mask */

#define AG903_BMUn_STAT_WNUM_POS                           0                                                             /** BMUnSTAT WNUM-bit position */
#define AG903_BMUn_STAT_WNUM_MSK                           (0x7UL << AG903_BMUn_STAT_WNUM_POS)                           /** BMUnSTAT WNUM-bit mask */
#define AG903_BMUn_STAT_WBSY_POS                           8                                                             /** BMUnSTAT WBSY-bit position */
#define AG903_BMUn_STAT_WBSY_MSK                           (0x1UL << AG903_BMUn_STAT_WBSY_POS)                           /** BMUnSTAT WBSY-bit mask */
#define AG903_BMUn_STAT_WWA_POS                            9                                                             /** BMUnSTAT WWA-bit position */
#define AG903_BMUn_STAT_WWA_MSK                            (0x1UL << AG903_BMUn_STAT_WWA_POS)                            /** BMUnSTAT WWA-bit mask */
#define AG903_BMUn_STAT_FULL_POS                           10                                                            /** BMUnSTAT FULL-bit position */
#define AG903_BMUn_STAT_FULL_MSK                           (0x1UL << AG903_BMUn_STAT_FULL_POS)                           /** BMUnSTAT FULL-bit mask */
#define AG903_BMUn_STAT_RNUM_POS                           16                                                            /** BMUnSTAT RNUM-bit position */
#define AG903_BMUn_STAT_RNUM_MSK                           (0x7UL << AG903_BMUn_STAT_RNUM_POS)                           /** BMUnSTAT RNUM-bit mask */
#define AG903_BMUn_STAT_RBSY_POS                           24                                                            /** BMUnSTAT RBSY-bit position */
#define AG903_BMUn_STAT_RBSY_MSK                           (0x1UL << AG903_BMUn_STAT_RBSY_POS)                           /** BMUnSTAT RBSY-bit mask */
#define AG903_BMUn_STAT_RWA_POS                            25                                                            /** BMUnSTAT RWA-bit position */
#define AG903_BMUn_STAT_RWA_MSK                            (0x1UL << AG903_BMUn_STAT_RWA_POS)                            /** BMUnSTAT RWA-bit mask */
#define AG903_BMUn_STAT_EMPTY_POS                          26                                                            /** BMUnSTAT EMPTY-bit position */
#define AG903_BMUn_STAT_EMPTY_MSK                          (0x1UL << AG903_BMUn_STAT_EMPTY_POS)                          /** BMUnSTAT EMPTY-bit mask */
#define AG903_BMUn_STAT_VAL_POS                            27                                                            /** BMUnSTAT VAL-bit position */
#define AG903_BMUn_STAT_VAL_MSK                            (0x1UL << AG903_BMUn_STAT_VAL_POS)                            /** BMUnSTAT VAL-bit mask */


#endif /* _AG903_BMU_REGMAP_H_ */

