/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "kernel.h"
#include "sample_util.h"

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern ER puts_com(ID, VB *, UINT *, TMO);

/*****************************************************************************/
/*     define                                                                */
/*****************************************************************************/
#define DID_UART0   1

/******************************************************************************
   FunctionF  sample_puts
   ArgumentF  str         : 
   Return  F  Ȃ
   Summary F  R\[ɏo͂܂
   Caution F  Ȃ
******************************************************************************/
void sample_puts(char *str)
{
	UINT			txcnt;
	unsigned int	i;
	
	
	/* R\[ɕׂȂ߁Await */
	for(i = 0; i < 20000; i++);
	
	txcnt = sample_strlen(str);

	puts_com(DID_UART0, (VB *)str , &txcnt, TMO_FEVR);

	return;
}

/******************************************************************************
   FunctionF  sample_memcpy
   ArgumentF  str1        : Rs[AhX
               str2        : Rs[AhX
               len         : Rs[oCg
   Return  F  Rs[擪AhX
   Summary F  memcpy֐
   Caution F  Ȃ
******************************************************************************/
void *sample_memcpy(void *str1, const void *str2, int len)
{
	int				i;
	void			*ret	=	(void *)str1;
	unsigned char	*wptr	=	(unsigned char *)str1;
	unsigned char	*rptr	=	(unsigned char *)str2;

	for( i=0 ; i<len ; i++ ){
		wptr[ i ]	=	rptr[ i ];
	}

	return	ret;
}

/******************************************************************************
   FunctionF  sample_memset
   ArgumentF  str         : ZbgAhX
               chr         : Zbgl
               len         : ZbgoCg
   Return  F  擪AhX
   Summary F  memset֐
   Caution F  Ȃ
******************************************************************************/
void *sample_memset(void *str, int chr, int len)
{
	int				i;
	void			*ret	=	(void *)str;
	unsigned char	*wptr	=	(unsigned char *)str;

	for( i=0 ; i<len ; i++ ){
		wptr[ i ]	=	(unsigned char)chr;
	}

	return	ret;
}	

/******************************************************************************
   FunctionF  sample_strlen
   ArgumentF  s           : Ώە
   Return  F  
   Summary F  strlen֐
   Caution F  Ȃ
******************************************************************************/
int sample_strlen(const char *s)
{
	int		i;
	int		len;

	for( i=0,len=0 ; s[ i ]!=0  ; i++ ){
		len++;
	}

	return	len;
}

/******************************************************************************
   FunctionF  sample_strcmp
   ArgumentF  str1        : r敶
   ArgumentF  str1        : r
   Return  F  0           : v
               0ȊO       : sv
   Summary F  strcmp֐
   Caution F  Ȃ
******************************************************************************/
int sample_strcmp(const char *str1, const char *str2)
{
    const unsigned char *c1 = (const unsigned char*)str1;
    const unsigned char *c2 = (const unsigned char*)str2;

    for ( ; (*c1 == *c2) && (*c1 != '\0'); c1++, c2++) {
    }

    return *c1 - *c2;
}

/******************************************************************************
   FunctionF  sample_memcmp
   ArgumentF  dst         : rf[^AhX
               src         : rf[^AhX
               len         : roCg
   Return  F  0           : v
               0ȊO       : sv
   Summary F  memcmp֐
   Caution F  Ȃ
******************************************************************************/
int sample_memcmp(void *dst, void *src, int len)
{
	int		result;
	int		i;

	result = 0;
	for(i = 0; i < len; i++) {
		if((*(char *)dst) != (*( char *)src)) {
			result = ((*(char *)dst) - (*(char *)src));
			break;
		}

		dst = ((char *)dst + 1);
		src = ((char *)src + 1);
	}

	return(result);
}

/******************************************************************************
   FunctionF  sample_putnum
   ArgumentF  num         : o͂鐔l
   Return  F  Ȃ
   Summary F  w萔l10i`ŃR\[o͂܂
   Caution F  Ȃ
******************************************************************************/
void sample_putnum(int num)
{
	const int		COLUMN_MAX = 10;				/* int^̍ő包					*/
	char			buf[11];						/* o͂镶					*/
	unsigned int	uinum = num;					/* ƂΏېl				*/
	unsigned char	flag = 0;						/* ŏʌoǂ		*/
	int				div;							/* ΏېlɊ鐔l				*/
	char			c;
	int				i, j = 0;
	
	
	/* 0 */
	if(num == 0) {
		buf[j++] = '0';
		buf[j] = '\0';
	}
	/* 0ȊO */
	else {
		sample_memset(buf, 0, sizeof(buf));
		
		/* }CiXl */
		if (num < 0) {
			buf[j++] = '-';
			uinum = (unsigned int)(0-num);
		}
		
		for(i = 0, div = 1000000000; i < COLUMN_MAX; i++, div/=10) {
		
			c = (uinum / div);
			/* ŏʌo */
			if (flag == 0) {
				/* loꍇ */
				if (c != 0) {
					flag++;
				}
				/* ܂o */
				else {
					continue;
				}
			}
			/* o͕ */
			buf[j++] = (0x30 + c);
			uinum -= (c * div);
		}
	}
	/* Ƃďo */
	sample_puts(buf);
}

/******************************************************************************
   FunctionF  sample_putbytehex
   ArgumentF  num         : o͂鐔l
   Return  F  Ȃ
   Summary F  w萔l1byte16i`ŃR\[o͂܂
   Caution F  Ȃ
******************************************************************************/
void sample_putbytehex(unsigned char num)
{
	const int		COLUMN_MAX = 2;					/* int^̍ő包					*/
	char			buf[9];							/* o͂镶					*/
	int				shift;							/* ΏېlVtg镝			*/
	char			c;
	int				i = 0, j = 0;
	
	
	/* 0 */
	if(num == 0) {
		sample_memcpy(buf, "00", 2);
		buf[2] = '\0';
	}
	/* 0ȊO */
	else {
		sample_memset(buf, 0, sizeof(buf));
		
		for(i = 0, j = 0, shift = ((COLUMN_MAX-1)*4); i < COLUMN_MAX; i++, shift-=4) {
		
			/* 1擾 */
			c = ((num >> shift) & 0x0f);
			
			/* ɕϊ */
			if ((c >= 0x01) && (c <= 0x09)) {
				buf[j] = (c + '0');
			}
			else if ((c >= 0x0a) && (c <= 0x0f)) {
				buf[j] = ('a' + (c - 0x0a));
			}
			else if(c == 0) {
				buf[j] = (c + '0');
			}
			else {
				/* lłȂꍇ͉Ȃ */
			}
			j++;
		}
	}
	/* Ƃďo */
	sample_puts(buf);
}

/******************************************************************************
   FunctionF  sample_putlonghex
   ArgumentF  num         : o͂鐔l
   Return  F  Ȃ
   Summary F  w萔l4byte16i`ŃR\[o͂܂
   Caution F  Ȃ
******************************************************************************/
void sample_putlonghex(unsigned long num)
{
	const int		COLUMN_MAX = 8;					/* int^̍ő包					*/
	char			buf[9];							/* o͂镶					*/
	int				shift;							/* ΏېlVtg镝			*/
	char			c;
	int				i = 0, j = 0;
	
	
	/* 0 */
	if(num == 0) {
		sample_memcpy(buf, "00000000", 8);
		buf[8] = '\0';
	}
	/* 0ȊO */
	else {
		sample_memset(buf, 0, sizeof(buf));
		
		for(i = 0, j = 0, shift = ((COLUMN_MAX-1)*4); i < COLUMN_MAX; i++, shift-=4) {
		
			/* 1擾 */
			c = ((num >> shift) & 0x0f);
			
			/* ɕϊ */
			if ((c >= 0x01) && (c <= 0x09)) {
				buf[j] = (c + '0');
			}
			else if ((c >= 0x0a) && (c <= 0x0f)) {
				buf[j] = ('a' + (c - 0x0a));
			}
			else if(c == 0) {
				buf[j] = (c + '0');
			}
			else {
				/* lłȂꍇ͉Ȃ */
			}
			j++;
		}
	}
	/* Ƃďo */
	sample_puts(buf);
}

